/* ***** BEGIN LICENSE BLOCK ***** 
 * Version: RCSL 1.0/RPSL 1.0 
 *  
 * Portions Copyright (c) 1995-2002 RealNetworks, Inc. All Rights Reserved. 
 *      
 * The contents of this file, and the files included with this file, are 
 * subject to the current version of the RealNetworks Public Source License 
 * Version 1.0 (the "RPSL") available at 
 * http://www.helixcommunity.org/content/rpsl unless you have licensed 
 * the file under the RealNetworks Community Source License Version 1.0 
 * (the "RCSL") available at http://www.helixcommunity.org/content/rcsl, 
 * in which case the RCSL will apply. You may also obtain the license terms 
 * directly from RealNetworks.  You may not use this file except in 
 * compliance with the RPSL or, if you have a valid RCSL with RealNetworks 
 * applicable to this file, the RCSL.  Please see the applicable RPSL or 
 * RCSL for the rights, obligations and limitations governing use of the 
 * contents of the file.  
 *  
 * This file is part of the Helix DNA Technology. RealNetworks is the 
 * developer of the Original Code and owns the copyrights in the portions 
 * it created. 
 *  
 * This file, and the files included with this file, is distributed and made 
 * available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER 
 * EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS ALL SUCH WARRANTIES, 
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY, FITNESS 
 * FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT. 
 * 
 * Technology Compatibility Kit Test Suite(s) Location: 
 *    http://www.helixcommunity.org/content/tck 
 * 
 * Contributor(s): 
 *  
 * ***** END LICENSE BLOCK ***** */

#ifndef _RMAEDIT_H_
#define _RMAEDIT_H_

struct	IHXValues;
struct	IHXPacket;
struct  IHXBuffer;
struct IHXProgressSink;

/*
 * Forward declarations of some interfaces defined here-in.
 */

typedef _INTERFACE IHXRMFileSink			IHXRMFileSink;

/****************************************************************************
 *  Function:
 *		RMACreateRMEdit
 *
 *  Purpose:
 *		Creates an instance of a G2 RMEditor object. 
 */
STDAPI RMACreateRMEdit(IUnknown**  /*OUT*/	ppIUnknown);

typedef HX_RESULT (HXEXPORT_PTR FPCREATEINSTANCE) (IUnknown** /*OUT*/ ppIUnknown);

/****************************************************************************
 * 
 *  Interface:
 *
 *	IHXRMEdit
 *
 *  Purpose:
 *
 *	Interface to G2 RMEditor module
 *
 *  IHXRMEdit
 *
 *  {7010AF10-0B86-11d2-A1BD-0060083BE563}
 *
 */

DEFINE_GUID(IID_IHXRMEdit, 
0x7010af10, 0xb86, 0x11d2, 0xa1, 0xbd, 0x0, 0x60, 0x8, 0x3b, 0xe5, 0x63);


#define CLSID_IHXRMEdit IID_IHXRMEdit

#undef  INTERFACE
#define INTERFACE   IHXRMEdit

DECLARE_INTERFACE_(IHXRMEdit, IUnknown)
{
    /***********************************************************************/
    /*
     *	IUnknown methods
     */
    STDMETHOD(QueryInterface)	(THIS_
				REFIID riid,
				void** ppvObj) PURE;

    STDMETHOD_(ULONG32,AddRef)	(THIS) PURE;

    STDMETHOD_(ULONG32,Release)	(THIS) PURE;

    /***********************************************************************/
    /*
     *	IHXRMEdit methods
     */
 
    /************************************************************************
     *	Method:
     *	    IHXRMEdit::GetFileVersion
     *	Purpose:
     *	    returns the version number of the input file. 
     *		1 == .rm1 file (Single Rate)
     *		2 == .rm2 file (Sure Stream)
     *
     *	Parameters:
     *	    pulVersion - [out] address of UINT32 that will hold the version
     */
	STDMETHOD(GetFileVersion) (THIS_
				UINT32* pulVersion) PURE;                   

    /************************************************************************
     *	Method:
     *	    IHXRMEdit::GetErrorString
     *	Purpose:
     *	    returns the error string associated with the specified HX_RESULT
     *
     *	Parameters:
     *	    res - [in] the HX_RESULT you want an error string for
     *		szErrString - [out] a preallocated buffer to hold the error string
     *		unMaxSize - the size of the szErrString buffer
     */
	STDMETHOD(GetErrorString) (THIS_
				HX_RESULT res, char* szErrString, UINT16 unMaxSize) PURE;                   

    /************************************************************************
     *	Method:
     *	    IHXRMEdit::SetTitle
     *	Purpose:
     *	    sets the title string
     *
     *	Parameters:
     *		szTitle - [in] the Title string for the file
     */
	STDMETHOD(SetTitle) (THIS_
				const char* szTitle) PURE;                   

    /************************************************************************
     *	Method:
     *	    IHXRMEdit::SetAuthor
     *	Purpose:
     *	    sets the author string
     *
     *	Parameters:
     *		szAuthor - [in] the Author string for the file
     */
	STDMETHOD(SetAuthor) (THIS_
				const char* szAuthor) PURE;                   

    /************************************************************************
     *	Method:
     *	    IHXRMEdit::SetCopyright
     *	Purpose:
     *	    sets the copyright string
     *
     *	Parameters:
     *		szCopyright - [in] the Copyright string for the file
     */
	STDMETHOD(SetCopyright) (THIS_
				const char* szCopyright) PURE;                   

    /************************************************************************
     *	Method:
     *	    IHXRMEdit::SetComment
     *	Purpose:
     *	    sets the comment string
     *
     *	Parameters:
     *		szComment - [in] the Comment string for the file
     */
	STDMETHOD(SetComment) (THIS_
				const char* szComment) PURE;                   

    /************************************************************************
     *	Method:
     *	    IHXRMEdit::SetSelectiveRecord
     *	Purpose:
     *	    enables/disables the Selective Record (Allow Recording) flag
     *
     *	Parameters:
     *		bEnable - [in] TRUE enable Allow Recording
     *					   FALSE disable Allow Recording 
	 */
	STDMETHOD(SetSelectiveRecord) (THIS_
				BOOL bEnable) PURE;                   

    /************************************************************************
     *	Method:
     *	    IHXRMEdit::SetMobilePlayback
     *	Purpose:
     *	    enables/disables the Mobile Playback (Allow Download) flag
     *
     *	Parameters:
     *		bEnable - [in] TRUE enable Allow Download
     *					   FALSE disable Allow Download 
	 */
	STDMETHOD(SetMobilePlayback) (THIS_
				BOOL bEnable) PURE;                   

    /************************************************************************
     *	Method:
     *	    IHXRMEdit::SetPerfectPlay
     *	Purpose:
     *	    enables/disables the Perfect Play (Buffered Playback) flag
     *
     *	Parameters:
     *		bEnable - [in] TRUE enable Buffered Playback
     *					   FALSE disable Buffered Playback 
	 */
	STDMETHOD(SetPerfectPlay) (THIS_
				BOOL bEnable) PURE;                   

	/************************************************************************
     *	Method:
     *	    IHXRMEdit::SetStartTime
     *	Purpose:
     *	    specifes the start time in milliseconds for the edit operation.
     *
     *	Parameters:
     *		ulStartTime - [in] the start time in milliseconds.
	 *
	 *  Note: If you do not call this method, the default start time will be
	 *		  start of the file.
	 */
	STDMETHOD(SetStartTime) (THIS_
				UINT32 ulStartTime) PURE;             

	/************************************************************************
     *	Method:
     *	    IHXRMEdit::SetStartTime
     *	Purpose:
     *	    specifes the start time in Days:Hours:Minutes:Seconds:Milliseconds format
	 *	    for the edit operation.
     *
     *	Parameters:
     *		szStartTime - [in] the start time in Days:Hours:Minutes:Seconds:Milliseconds format.
	 *		i.e. 0:0:0:0:0
	 *
	 *  Note: If you do not call this method, the default start time will be
	 *		  start of the file.
	 */
	STDMETHOD(SetStartTime) (THIS_
				const char* szStartTime) PURE;             

	/************************************************************************
     *	Method:
     *	    IHXRMEdit::SetEndTime
     *	Purpose:
     *	    specifes the end time in milliseconds for the edit operation.
     *
     *	Parameters:
     *		ulEndTime - [in] the end time in milliseconds.
	 *
	 *  Note: If you do not call this method, the default end time will be
	 *		  the end of the file (EOF).
	 */
	STDMETHOD(SetEndTime) (THIS_
				UINT32 ulEndTime) PURE;                 

	/************************************************************************
     *	Method:
     *	    IHXRMEdit::SetEndTime
     *	Purpose:
     *	    specifes the end time in Days:Hours:Minutes:Seconds:Milliseconds format
	 *	    for the edit operation.
     *
     *	Parameters:
     *		szEndTime - [in] the end time in Days:Hours:Minutes:Seconds:Milliseconds format.
	 *		i.e. 0:0:0:0:0
	 *
	 *  Note: If you do not call this method, the default end time will be
	 *		  the end of the file (EOF).
	 */	
	STDMETHOD(SetEndTime) (THIS_
				const char* szEndTime) PURE;             

	/************************************************************************
     *	Method:
     *	    IHXRMEdit::SetInputFile
     *	Purpose:
     *	    specifies the file name of the input .rm file. If you are pasting several
	 *		.rm files, call SetInputFile() with the name of the first file and AddInputFile()
	 *		for the remaining files.
     *
     *	Parameters:
     *		szFileName - [in] the path to the input file.
	 *		bLoadFileInfo - [in] Set bLoadFileInfo to TRUE if you want the Edit SDK to load the 
	 *		input file's Content info (Title, Author, Copyright, Comment) and Property Flags 
	 *		(Selective Record, Mobile Play, etc.) You can then access this info using the 
	 *		Get methods (i.e. GetTitle(), etc.)
	 */	
	STDMETHOD(SetInputFile) (THIS_
				const char* szFileName,BOOL bLoadFileInfo) PURE;  

	/************************************************************************
     *	Method:
     *	    IHXRMEdit::AddInputFile
     *	Purpose:
     *	    specifies the file name of a .rm file to paste to the end of the input file
	 *		specified in SetInputFile().SetInputFile() should be called before this method.
     *
     *	Parameters:
     *		szFileName - [in] the path to the .rm file to be pasted to the end of the file
	 *		specified with SetInputFile().
	 */	
	STDMETHOD(AddInputFile) (THIS_
				const char* szFileName) PURE;  

	/************************************************************************
     *	Method:
     *	    IHXRMEdit::SetOutputFile
     *	Purpose:
     *	    specifies the file name of the output file. This .rm file will contain the results
	 *		of the edit operation.
     *
     *	Parameters:
     *		szFileName - [in] the path to the output .rm file. If the file already exists, it 
	 *		will be replaced. If the file does not exist it will be created.
	 */	
	STDMETHOD(SetOutputFile) (THIS_
				const char* szFileName) PURE; 

	/************************************************************************
     *	Method:
     *	    IHXRMEdit::GetTitle
     *	Purpose:
     *	    returns the current title string.
     *
     *	Parameters:
     *		szTitle - [out] the title string will be returned in szTitle. szTitle must be 
	 *		preallocated by the caller.
	 *		ulSize - [in] the size of the szTitle buffer.
	 */	
	STDMETHOD(GetTitle) (THIS_
				char* szTitle, UINT32 ulSize) PURE; 

	/************************************************************************
     *	Method:
     *	    IHXRMEdit::GetAuthor
     *	Purpose:
     *	    returns the current author string.
     *
     *	Parameters:
     *		szAuthor - [out] the author string will be returned in szAuthor. szAuthor must be 
	 *		preallocated by the caller.
	 *		ulSize - [in] the size of the szAuthor buffer.
	 */	
	STDMETHOD(GetAuthor) (THIS_
				char* szAuthor, UINT32 ulSize) PURE; 

	/************************************************************************
     *	Method:
     *	    IHXRMEdit::GetCopyright
     *	Purpose:
     *	    returns the current copyright string.
     *
     *	Parameters:
     *		szAuthor - [out] the Copyright string will be returned in szCopyright. szCopyright must be 
	 *		preallocated by the caller.
	 *		ulSize - [in] the size of the szCopyright buffer.
	 */	
	STDMETHOD(GetCopyright) (THIS_
				char* szCopyright, UINT32 ulSize) PURE; 

	/************************************************************************
     *	Method:
     *	    IHXRMEdit::GetComment
     *	Purpose:
     *	    returns the current comment string.
     *
     *	Parameters:
     *		szComment - [out] the Comment string will be returned in szComment. szComment must be 
	 *		preallocated by the caller.
	 *		ulSize - [in] the size of the szComment buffer.
	 */	
	STDMETHOD(GetComment) (THIS_
				char* szComment, UINT32 ulSize) PURE; 

	/************************************************************************
     *	Method:
     *	    IHXRMEdit::GetSelectiveRecord
     *	Purpose:
     *	    returns the returns the current state of the Selective Record 
	 *		(Allow Recording) flag.
     *
     *	Parameters:
     *		bEnabled - [out] the state of the selective record flag will be returned in bEnabled. 
	 */	
	STDMETHOD(GetSelectiveRecord) (THIS_
				BOOL* bEnabled) PURE;                   

	/************************************************************************
     *	Method:
     *	    IHXRMEdit::GetMobilePlayback
     *	Purpose:
     *	    returns the returns the current state of the Mobile Playback
	 *		(Allow Download) flag.
	 *
     *	Parameters:
     *		bEnabled - [out] the state of the mobile playback flag will be returned in bEnabled. 
	 */	
	STDMETHOD(GetMobilePlayback) (THIS_
				BOOL* bEnabled) PURE;                   

	/************************************************************************
     *	Method:
     *	    IHXRMEdit::GetPerfectPlay
     *	Purpose:
     *	    returns the returns the current state of the PerfectPlay
	 *		(Buffered Playback) flag.
	 *
     *	Parameters:
     *		bEnabled - [out] the state of the PerfectPlay flag will be returned in bEnabled. 
	 */	
	STDMETHOD(GetPerfectPlay) (THIS_
				BOOL* bEnabled) PURE;                   

	/************************************************************************
     *	Method:
     *	    IHXRMEdit::GetStartTime
     *	Purpose:
     *	    returns the current start time in milliseconds
	 *
     *	Parameters:
     *		pulStartTime - [out] the current start time will be returned in pulStartTime. 
	 */	
	STDMETHOD(GetStartTime) (THIS_
				UINT32* pulStartTime) PURE;                   

	/************************************************************************
     *	Method:
     *	    IHXRMEdit::GetEndTime
     *	Purpose:
     *	    returns the current end time in milliseconds
	 *
     *	Parameters:
     *		pulEndTime - [out] the current end time will be returned in pulEndTime. 
	 */	
	STDMETHOD(GetEndTime) (THIS_
				UINT32* pulEndTime) PURE;                                       

	/************************************************************************
     *	Method:
     *	    IHXRMEdit::GetNumInputFiles
     *	Purpose:
     *	    returns the number of input files that have be added via the 
	 *		SetInputFile() and AddInputFile() methods.
	 *
     *	Parameters:
     *		pulNumInputFiles - [out] the current number of input files. 
	 */	
	STDMETHOD(GetNumInputFiles) (THIS_
				UINT32* pulNumInputFiles) PURE;        

	/************************************************************************
     *	Method:
     *	    IHXRMEdit::GetIndexedInputFile
     *	Purpose:
     *		returns the file name of the input file specified by index. 
	 *		Use GetNumInputFiles() to determine how many files have been added to
	 *		theRMEditor interface.
	 *
     *	Parameters:
     *		index - [in] the index of the required input file. Must be in the
	 *		range of 0 to GetNumInputFiles() - 1.
	 *		szFileName - [out] the path to the input file. This buffer must be preallocated.
     *		ulMaxBufSize - [in] the size of the buffer szFileName. 
	 */	
	STDMETHOD(GetIndexedInputFile) (THIS_
				UINT32 index, char* szFileName, UINT32 ulMaxBufSize) PURE;        

	/************************************************************************
     *	Method:
     *	    IHXRMEdit::GetOutputFile
     *	Purpose:
     *		returns the file name of the output file.
	 *
     *	Parameters:
 	 *		szFileName - [out] the path to the output file. This buffer must be preallocated.
     *		ulMaxBufSize - [in] the size of the buffer szFileName. 
	 */	
	STDMETHOD(GetOutputFile) (THIS_
				char* szFileName, UINT32 ulMaxBufSize) PURE;        

	/************************************************************************
     *	Method:
     *	    IHXRMEdit::SetRMFileSink
     *	Purpose:
     *		Adds an IHXRMFileSink interface to the RMEditor interface. The IHXRMFileSink 
	 *		interface will be notified whenever a media properties header or data
	 *		packet is written to the output file.
	 *
     *	Parameters:
 	 *		pRMFileSink - [in] a pointer to a IHXRMFileSink interface.
	 */	
	STDMETHOD(SetRMFileSink)	(THIS_
				IHXRMFileSink* pRMFileSink) PURE;

	/************************************************************************
     *	Method:
     *	    IHXRMEdit::RemoveRMFileSink
     *	Purpose:
     *		removes the specified IHXRMFileSink from the RMEditor interface.
	 *
     *	Parameters:
 	 *		pRMFileSink - [in] a pointer to a IHXRMFileSink interface..
	 */	
	STDMETHOD(RemoveRMFileSink)	(THIS_
				IHXRMFileSink* pRMFileSink) PURE;

	/************************************************************************
     *	Method:
     *	    IHXRMEdit::CreateIRMABuffer
     *	Purpose:
     *		creates an instance of an IRMABuffer.
	 *
     *	Parameters:
 	 *		pBuffer - a handle to an IRMABuffer.
	 */	
	STDMETHOD(CreateIRMABuffer)	(THIS_
				IHXBuffer** pBuffer) PURE;

	/************************************************************************
     *	Method:
     *	    IHXRMEdit::OpenLogFile
     *	Purpose:
     *		opens the specified file for logging. All status and error messages will be
	 *		logged to this file.
	 *
     *	Parameters:
 	 *		pFileName - [in] the path to the log file.
	 */	
	STDMETHOD(OpenLogFile)	(THIS_
				const char* pFileName) PURE;

	/************************************************************************
     *	Method:
     *	    IHXRMEdit::CloseLogFile
     *	Purpose:
     *		closes the log file
	 *
     *	Parameters:
 	 *		None
	 */	
	STDMETHOD(CloseLogFile)	(THIS) PURE;

	/************************************************************************
     *	Method:
     *	    IHXRMEdit::Log
     *	Purpose:
     *		logs the string to the log file
	 *
     *	Parameters:
 	 *		pLogString - [in] the string to be logged to the log file.
	 */	
	STDMETHOD(Log)	(THIS_
				const char* pLogString) PURE;

	/************************************************************************
     *	Method:
     *	    IHXRMEdit::Process
     *	Purpose:
     *		processes the edit using the current settings. Creates and writes to the output file.
	 *
     *	Parameters:
 	 *		None
	 */	
	STDMETHOD(Process) (THIS) PURE; 

};

/****************************************************************************
 * 
 *  Interface:
 *
 *	IHXRMEdit3
 *
 *  Purpose:
 *
 *	Interface to G2 RMEditor module
 *
 *  {6D5DA0F0-ADBC-11d3-865F-5E9198000000}
 *
 */

DEFINE_GUID(IID_IHXRMEdit3, 
0x6d5da0f0, 0xadbc, 0x11d3, 0x86, 0x5f, 0x5e, 0x91, 0x98, 0x0, 0x0, 0x0);

#define CLSID_IHXRMEdit3 IID_IHXRMEdit3

#undef  INTERFACE
#define INTERFACE   IHXRMEdit3

DECLARE_INTERFACE_(IHXRMEdit3, IHXRMEdit)
{
	/************************************************************************
     *	Method:
     *	    IHXRMEdit3::AddSaveProgressSink
     *	Purpose:
     *		Add sink which receives callbacks with save progress
	 */	
    STDMETHOD(AddSaveProgressSink)(IHXProgressSink* pProgressSink) PURE;
    
	/************************************************************************
     *	Method:
     *	    IHXRMEdit3::RemoveSaveProgressSink
     *	Purpose:
     *		Remove progress-during-save sink
	 */	
    STDMETHOD(RemoveSaveProgressSink)(IHXProgressSink* pProgressSink) PURE;
};

#endif
//_RMAEDIT_H_
