/* ***** BEGIN LICENSE BLOCK *****
 * Version: RCSL 1.0/RPSL 1.0
 *
 * Portions Copyright (c) 1995-2002 RealNetworks, Inc. All Rights Reserved.
 *
 * The contents of this file, and the files included with this file, are
 * subject to the current version of the RealNetworks Public Source License
 * Version 1.0 (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the RealNetworks Community Source License Version 1.0
 * (the "RCSL") available at http://www.helixcommunity.org/content/rcsl,
 * in which case the RCSL will apply. You may also obtain the license terms
 * directly from RealNetworks.  You may not use this file except in
 * compliance with the RPSL or, if you have a valid RCSL with RealNetworks
 * applicable to this file, the RCSL.  Please see the applicable RPSL or
 * RCSL for the rights, obligations and limitations governing use of the
 * contents of the file.
 *
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the portions
 * it created.
 *
 * This file, and the files included with this file, is distributed and made
 * available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT.
 *
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 *
 * Contributor(s):
 *
 * ***** END LICENSE BLOCK ***** */



#ifndef _HXTCONSTANTS_H
#define _HXTCONSTANTS_H


/* ************* */
/* MEDIA FORMATS */
/* ************* */

/* Media format */
static const char kPropMediaFormat[] =					"MediaFormat";				/* string */

/* Media Format List */
static const char kValueMediaFormatUncompAudio[] =		"UncompressedAudio";		/* string */
static const char kValueMediaFormatUncompVideo[] =		"UncompressedVideo";		/* string */
static const char kValueMediaFormatRNEvents[] =			"rnEvents";					/* string */
static const char kValueMediaFormatRNImageMaps[] =		"rnImageMaps";				/* string */
static const char kValueMediaFormatRMAPacketized[] =	"rmaPacketized";			/* string */
static const char kValueMediaFormatAsmPacketized[] =	"asmPacketized";
static const char kValueMediaFormatAsmAudioPacketized[] = "asmPacketizedAudio";			/* string */
static const char kValueMediaFormatAsmVideoPacketized[] = "asmPacketizedVideo";			/* string */
static const char kValueMediaFormatRNCompAudio[] =		"rnCompressedAudio";		/* string */
static const char kValueMediaFormatRNCompVideo[] =		"rnCompressedVideo";		/* string */
static const char kValueMediaFormatMP3Audio[] =			"MP3Audio";					/* string */
static const char kValueMediaFormatMPEG4CompAudio[] =		"MPEG4CompressedAudio";

/* Audio connection properties for kValueMediaFormatUncompAudio */
static const char kPropAudioChannelFormat[] =			"audioChannelFormat";		/* UINT32 */
static const char kPropAudioSampleRate[] =				"audioSampleRate";			/* UINT32 */
static const char kPropAudioSampleFormat[] =			"audioSampleFormat";		/* UINT32 */

/* Video connection properties for kValueMediaFormatUncompVideo */
static const char kPropVideoColorFormat[] =				"videoColorFormat";			/* UINT32 */
static const char kPropVideoFrameWidth[] =				"videoFrameWidth";			/* UINT32 */
static const char kPropVideoFrameHeight[] =				"videoFrameHeight";			/* UINT32 */
static const char kPropVideoFrameRate[] =				"videoFrameRate";			/* double */


/* ************* */
/* ALL PLUGINS */
/* ************* */

/* 1) All Plugins expose a pluginName field in XML and in their XXXplugin.cpp file
	kPropPluginName is of the form:    rn-category-shortdescription  (lowercase)
    where rn is for the company,  category is one of 6 assigned below,
    and short description is enough info to uniquely describe the plugin   */
static const char kPropPluginName[] =						"pluginName";					/* string */

static const char kValuePluginNameAVFileAVIUncomp[] =		"rn-avfile-aviuncompressed";	/* string */
static const char kValuePluginNameAVFileDirectShow[] =		"rn-avfile-directshow";			/* string */
static const char kValuePluginNameAVFileMOVUncomp[] =		"rn-avfile-movuncompressed";	/* string */
static const char kValuePluginNameAVFileQTCompressed[] =	"rn-avfile-qt";					/* string */
static const char kValuePluginNameAVFileWAVUncomp[] =		"rn-avfile-wavuncompressed";	/* string */
static const char kValuePluginNameAVFilePlaylist[] =		"rn-avfile-playlist";			/* string */
static const char kValuePluginNameFFReader[] =				"rn-avfile-ffreader";			/* string */
static const char kValuePluginNameCaptureAV[] =				"rn-capture-av";				/* string */
static const char kValuePluginNameInputMediaSink[] =		"rn-input-mediasink";			/* string */
static const char kValuePluginNameInputRMFile[] =			"rn-input-realmedia";			/* string */
static const char kValuePluginNameInputEvents[] =			"rn-avfile-realevents";			/* string */
static const char kValuePluginNameInputImageMaps[] =		"rn-avfile-imagemaps";			/* string */
static const char kValuePluginNamePrefilterCropping[] =		"rn-prefilter-inputcropping";	/* string */
static const char kValuePluginNamePrefilterResizer[] =		"rn-prefilter-videoresize";	/* string */
static const char kValuePluginNamePrefilterAudioGain[] =	"rn-prefilter-audiogain";	/* string */
static const char kValuePluginNamePrefilterAudioConverter[] =	"rn-prefilter-audioconverter";	/* string */
static const char kValuePluginNamePrefilterVideoNoiseReduction[] =	"rn-prefilter-videonoisereduction";		/* string */
static const char kValuePluginNamePrefilterDeinterlace[] =	"rn-prefilter-deinterlace";		/* string */
static const char kValuePluginNamePrefilterDupFrameDropper[] =	"rn-prefilter-dupframedropper";		/* string */
static const char kValuePluginNamePrefilterBlackLevel[] =	"rn-prefilter-blacklevel";		/* string */
static const char kValuePluginNamePrefilterVideoSignalDetector[] =	"rn-prefilter-videosignaldetector";		/* string */
static const char kValuePluginNamePrefilterLevelMeter[] =	"rn-prefilter-levelmeter";		/* string */
static const char kValuePluginNamePrefilterAudioDelayComp[] = "rn-prefilter-audiodelaycomp"; /* string */
static const char kValuePluginNamePrefilterTimestampAdjuster[] = "rn-prefilter-timestampadjuster";
static const char kValuePluginNameCodecRealAudio[] =		"rn-audiocodec-realaudio";		/* string */
static const char kValuePluginNameCodecRealVideo[] =		"rn-videocodec-realvideo";		/* string */
static const char kValuePluginNameTransformAudioFormatConverter[] =	"rn-transform-audioformatconv";	/* string */
static const char kValuePluginNameTransformFrameDropper[] =	"rn-transform-framedropper";    /* string */
static const char kValuePluginNameTransformJoiner[] =		"rn-transform-joiner";			/* string */
static const char kValuePluginNameTransformResampler[] =	"rn-transform-resampler";		/* string */
static const char kValuePluginNameTransformResamplerExact[] =	"rn-transform-resamplerexact";	/* string */
static const char kValuePluginNamePacketizerRealAudio[] =	"rn-packetizer-realaudio";		/* string */
static const char kValuePluginNamePacketizerMPEG4Audio[] =	"rn-packetizer-mpeg4audio";		/* string */
static const char kValuePluginNameTransformRealEvents[] =	"rn-transform-realevent";		/* string */
static const char kValuePluginNameTransformImageMaps[] =	"rn-transform-imagemap";		/* string */
static const char kValuePluginNameTransformASMMux[] =		"rn-transform-asmmux";			/* string */
static const char kValuePluginNameTransformRealTime[] =		"rn-transform-realtime";		/* string */
static const char kValuePluginNameTransformSplitter[] =		"rn-transform-splitter";		/* string */
static const char kValuePluginNameTransformAsmMediaFormatConverter[] = "rn-transform-asmmediaformatconv";
static const char kValuePluginNamePostfilterDRM[] =			"rn-postfilter-drm";			/* string */
static const char kValuePluginNamePacketizerRealVideo[] =	"rn-packetizer-realvideo";		/* string */
static const char kValuePluginNameFileDestRealMedia[] =		"rn-file-realmedia";			/* string */
static const char kValuePluginNameFileDestOgg[] =			"rn-file-ogg";					/* string */
static const char kValuePluginNameFileDestHXFileWriter[] =	"rn-file-hxwriter";				/* string */
static const char kValuePluginNameFileDestNull[] =			"rn-writer-null";				/* string */
static const char kValuePluginNameServerG2Push[] =			"rn-server-g2";					/* string */
static const char kValuePluginNameServerRBS[] =				"rn-server-rbs";				/* string */
static const char kValuePluginNameDestinationMediaSink[] =	"rn-destination-mediasink";		/* string */
static const char kValuePluginNameDestinationPreview[] =	"rn-destination-preview";		/* string */
static const char kValuePluginNameSourceSwitcher[] =		"rn-input-switcher";			/* string */
static const char kValuePluginNameCodecVorbis[] =			"rn-audiocodec-vorbis";		/* string */
static char const kValuePluginNameCodecLossless[] =			"rn-audiocodec-lossless" ;
static char const kValuePluginName3GPPSessionFormat[] =	"rn-3gpp-session-format";
static char const kValuePluginNameRMSessionFormat[] =		"rn-rm-session-format";
static char const kValuePluginNameDestinationPacketSource[] =	"rn-destination-packetsource";

/* 2) All Plugins expose a pluginType field in XML */
static const char kPropPluginType[] =							"pluginType";				/* string */

static const char kValuePluginTypeInputAVFile[] =				"avFileInput";				/* string */
static const char kValuePluginTypeInputCapture[] =				"captureInput";				/* string */
static const char kValuePluginTypeInputMediaSink[] =			"mediaSinkInput";			/* string */
static const char kValuePluginTypeInputCompressedMediaRM[] =	"rmFileInput";				/* string */
static const char kValuePluginTypeInputParGroup[] =	"parGroupInput";				/* string */
static const char kValuePluginTypeInputSeqGroup[] =	"seqGroupInput";				/* string */
static const char kValuePluginTypePrefilterCropping[] =			"inputCroppingPrefilter";	/* string */
static const char kValuePluginTypePrefilterResizer[] =			"videoResizePrefilter";	/* string */
static const char kValuePluginTypePrefilterAudioGain[] =		"audioGainPrefilter";	/* string */
static const char kValuePluginTypePrefilterAudioConverter[] =		"audioConverter";	/* string */
static const char kValuePluginTypePrefilterVideoNoiseReduction[] =	"videoNoiseReductionPrefilter";		/* string */
static const char kValuePluginTypePrefilterDeinterlace[] =		"deinterlacePrefilter";		/* string */
static const char kValuePluginTypePrefilterDupFrameDropper[] =		"dupFrameDropperPrefilter";		/* string */
static const char kValuePluginTypePrefilterBlackLevel[] =		"blackLevelPrefilter";		/* string */
static const char kValuePluginTypePrefilterVideoSignalDetector[] =	"videoSignalDetectorPrefilter";		/* string */
static const char kValuePluginTypePrefilterLevelMeter[] =		"levelMeterPrefilter";		/* string */
static const char kValuePluginTypePrefilterAudioDelayComp[] = "audioDelaycompPrefilter"; /* string */
static const char kValuePluginTypePrefilterTimestampAdjuster[] = "rn-prefilter-timestampadjuster";
static const char kValuePluginTypeAudioStream[] =				"audioStream";				/* string */
static const char kValuePluginTypeVideoStream[] =				"videoStream";				/* string */
static const char kValuePluginTypeAudioResampler[] =			"audioResampler";			/* string */
static const char kValuePluginTypePacketizerAudio[] =			"audioPacketizer";		/* string */
static const char kValuePluginTypeAudioFormatConverter[] =		"audioformatconv";			/* string */
static const char kValuePluginTypeEventStream[] =				"eventStream";				/* string */
static const char kValuePluginTypeImageMapStream[] =			"imageMapStream";			/* string */
static const char kValuePluginTypeTransformASMMux[] =			"transformASMMux";			/* string */
static const char kValuePluginTypeTransformRealTime[] =			"transformRealTime";		/* string */
static const char kValuePluginTypeTransformSplitter[] =			"transformSplitter";		/* string */
static const char kValuePluginTypeTransformAsmMediaFormatConverter[] = "transformAsmMediaFormatConv";
static const char kValuePluginTypePacketizerVideo[] =			"videoPacketizer";			/* string */
static const char kValuePluginTypePostfilterDRM[] =				"drmPostfilter";			/* string */
static const char kValuePluginTypeDestinationFile[] =			"fileDestination";			/* string */
static const char kValuePluginTypeDestinationG2PushServer[] =	"g2PushServer";				/* string */
static const char kValuePluginTypeDestinationPushServer[] =		"pushServer";				/* string */
static const char kValuePluginTypeDestinationPullServer[] =		"pullServer";				/* string */
static const char kValuePluginTypeDestinationMediaSink[] =		"mediaSinkDestination";		/* string */
static const char kValuePluginTypeDestinationPreview[] =		"previewDestination";		/* string */
static const char kValuePluginTypeSourceSwitcher[] =			"inputSwitching";			/* string */
static const char kValuePluginTypeSessionFormat[] =			"headerGenerator";
static const char kValuePluginTypeDestinationPacketSource[] =		"packetsourceDestination";


/* 3) All Plugins expose a pluginCategory field in their XXXPlugin.cpp file
	This category allows a plugin handler to select plugins by meaningful groups. */

static const char kPropPluginCategory[] =						"pluginCategory";				/* string */

static const char kValuePluginCategoryInputAVFile[] =			"categoryInputAVFile";			/* string */
static const char kValuePluginCategoryInputCapture[] =			"categoryInputCapture";			/* string */
static const char kValuePluginCategoryInputGeneral[] =			"categoryInputGeneral";			/* string */
static const char kValuePluginCategoryPrefilter[] =				"categoryPrefilter";			/* string */
static const char kValuePluginCategoryCodec[] =					"categoryCodec";				/* string */
static const char kValuePluginCategoryPacketizer[] =			"categoryPacketizer";			/* string */
static const char kValuePluginCategoryTransformGeneral[] =		"categoryTransformGeneral";		/* string */
static const char kValuePluginCategoryPostfilter[] =			"categoryPostfilter";			/* string */
static const char kValuePluginCategoryDestinationFile[] =		"categoryDestinationFile";		/* string */
static const char kValuePluginCategoryDestinationServer[] =		"categoryDestinationServer";	/* string */
static const char kValuePluginCategoryDestinationGeneral[] =	"categoryDestinationGeneral";	/* string */
static const char kValuePluginCategorySessionFormat[] =		"categorySessionFormat";

/* Optional -- consider for all plugins */
static const char kPropIsRealTime[] =					"isRealTime";				/* BOOL */
static const char kPropIsRepeatable[] =					"isRepeatable";				/* BOOL */

/* ************* */
/* INPUT PLUGINS */
/* ************* */

/* capture device enumeration */
static const char kPropCaptureType[] =					"captureType";				/* string */

static const char kPropCaptureMediaType[] =				"captureMediaType";			/* string */
static const char kValueCaptureMediaTypeAudioCapture[] ="audioCapture";				/* string */
static const char kValueCaptureMediaTypeVideoCapture[] ="videoCapture";				/* string */
static const char kValueCaptureMediaTypeAudioMixer[] =	"audioMixer";				/* string */

static const char kPropCapturePorts[] =					"capturePorts";				/* Property bag */
static const char kPropVideoFormat[] =					"videoFormat";				/* string */

static const char kValueInputSeqContainer[] =			"seqContainer";				/* string */
static const char kValueInputParContainer[] =			"parContainer";				/* string */

static const char kPropInputWidth[] =					"inputWidth";				/* UINT32 */
static const char kPropInputHeight[] =					"inputHeight";				/* UINT32 */
static const char kPropInputColorFormat[] =				"inputColorFormat";			/* UINT32 */
static const char kPropInputVideoDevicePort[] =			"inputVideoDevicePort";		/* string */

static const char kPropDeviceBusy[] =                   "deviceBusy";               /* bool */

static const char kPropVideoInputPin[] =				"videoInputPin";			/* IUnknown/IHXTMediaInputPin */
static const char kPropAudioInputPin[] =				"audioInputPin";			/* IUnknown/IHXTMediaInputPin */
static const char kPropEventInputPin[] =				"eventInputPin";			/* IUnknown/IHXTMediaInputPin */
static const char kPropImageMapInputPin[] =				"imagemapInputPin";			/* IUnknown/IHXTMediaInputPin */


/* ************* */
/* Input File and Capture Properties Requirements */
/* ************* */

/* Required Input File properties which must be set on the ConfigurationAgent's PropertyBag */
static const char kPropInputPathname[] =				"filename";					/* string */
static const char kPropNumTracks[] =					"numTracks";				/* UINT32 */
static const char kPropDuration[] =						"duration";					/* IUnknown */

static const char kPropDecompressMedia[] =                             "decompressMedia";

/* - no longer required for inputs - automatically generated by inputhelperformat */
static const char kPropFileSizeBytes[] =				"fileSizeBytes";			/* INT64 */

static const char kPropPlayCount[] =				"playCount";			/* UINT32 */
static const UINT32 kValuePlayCountInfinite =			0;
static const char kPropDynamicPlaylist[] =			"dynamicPlaylist";		/* BOOL */


/* a track bag will be created for each significant track in an input file or capture device
   each bag has a name which is independent of type:
		kPropTrackInfo[0..n] :
   to create the property name for the track bag append a number to the string constant:
	 kPropTrackInfo

  the specific requirements for different track types are listed below
   once the track bag is filled in with the default properties it must be
   set on the configuration agent's property bag using the SetPropertyBag function
*/

/* 1) Each track bag must set this property with one of the following values below */
/*    Track type is usually either: kValuePluginTypeAudioStream, kValuePluginTypeVideoStream */
/*	  kValuePluginTypeEventStream, or kValuePluginTypeImageMapStream  */
static const char kPropTrackInfoType[] =				"trackType";				/* string */

/* 2) each track bag must also use the kPropDuration field defined above */

/* 3) In addition, Audio track bags must implement the following  */
static const char kPropTrackAudioNumChannels[] =		"audioChannels";			/* UINT32 */
static const char kPropTrackAudioBitDepth[] =			"audioBitDepth";			/* UINT32 */
static const char kPropTrackAudioSampleRate[] =			"audioSampleRate";			/* UINT32 */

/* 4) also Audio track bags must also set kPropTrackAudioFormat with one of the following values */
static const char kPropTrackAudioFormat[] =				"audioFormat";				/* string */

/* optional values for above field */
static const char kValueAudioFormatPCM[] =				"pcm";						/* string */
static const char kValueAudioFormatMP3[] =				"mp3";						/* string */

/* 5) Video tracks must implement the following properties */
static const char kPropTrackVideoColorFormat[] =		"videoColorFormat";			/* string */
static const char kPropTrackVideoWidth[] =				"videoFrameWidth";			/* UINT32 */
static const char kPropTrackVideoHeight[] =				"videoFrameHeight";			/* UINT32 */
static const char kPropTrackVideoFrameRate[] =			"videoFrameRate";			/* double */

/* 6) dont forget -- video tracks bags must also set the kPropDuration property */

/* 7) for either the kPropTrackAudioFormat or the kPropTrackVideoColorFormat properties */
/*    the track bag must implement the kValueFormatUnknown if the format is unsupported */
static const char kValueFormatUnknown[] =				"unknown";					/* string */

/* 8) Input Capture devices only must set these additional properties on video and audio track bags */
static const char kPropTrackDeviceName[] =				"deviceName";				/* string */
static const char kPropTrackDevicePort[] =				"devicePort";				/* string */

/* 9) Optional Capture device property */
static const char kPropTrackDeviceDescription[] =		"deviceDescription";		/* string */

/* ************* */
/* End of track bag requirements */
/* ************* */

/* Capture */
static const char kPropBufferSize[] =					"bufferSize";				/* UINT32 */

/* dialogs for live capture */
/* media types */
static const char kPropAudioCaptureDialogs[] =			"audioCaptureDialogs";		/* property bag */
static const char kPropVideoCaptureDialogs[] =			"videoCaptureDialogs";		/* property bag */

static const char kPropCaptureDialogNames[] =			"captureDialogNames";		/* property bag */
static const char kPropCaptureDialogControl[] =			"captureDialogControl";		/* IUnknown */

/* input reader error handling property and values */
static const char kPropStatus[] =						"Status";					/* string */
static const char kValueOkayStatus[] =					"Okay";						/* string */
static const char kValueInvalidStreamStatus[] =			"InvalidStream";			/* string */
static const char kValueErrorStatus[] =					"Error";					/* string */
static const char kValueForcedInitStatus[] =			"ForcedInit";				/* string */
static const char kValueInitFailedStatus[] =			"initializationFailed";		/* string */



/* ************************/
/* TRANSFORM (PREFILTERS) */
/* ************************/

/* describe which of the following filter types below are desired */
static const char kPropIsEnabled[]  =					"enabled" ;						/* BOOL */

/* Audio Gain */
static const char kPropAudioLimiterGain[]     =			"gain" ;						/* double */
static const char kPropAudioLimiterRelease[]  =			"release" ;						/* double */

/* Audio watchdog */
static const char kPropAudioWatchdogSilenceThreshold[]  = "silenceThreshold" ; /* double */
static const char kPropAudioWatchdogSilenceThresholdDuration[] = "silenceThresholdDuration" ; /* IUnknown */

/* Audio delay compensation prefilter */
static const char kPropAudioDelay[]   =					"delay" ; /* duration / IUnknown */
static const char kPropAudioAdvance[] =					"advance" ; /* duration / IUnknown */

/* Video Cropping configuration */
static const char kPropCropLeft[] =						"left";							/* UINT32 */
static const char kPropCropTop[] =						"top";							/* UINT32 */
static const char kPropCropWidth[]  =					"width";						/* UINT32 */
static const char kPropCropHeight[] =					"height";						/* UINT32 */

/* Video Signal detector */
static const char kPropFramePollInterval[] =				"framePollInterval";			/* UINT32 */
static const char kPropNoSignalComplexityThreshold[] =			"noSignalComplexityThreshold";		/* UINT32 */
static const char kPropNoSignalDurationThreshold[] =			"noSignalDurationThreshold";		/* IUnknown / IHXTTime */
static const char kPropNoisySignalComplexityThreshold[] =		"noisySignalComplexityThreshold";	/* UINT32 */
static const char kPropNoisySignalDurationThreshold[] =			"noisySignalDurationThreshold";		/* IUnknown / IHXTTime */

/* Video deinterlace/inverse telecine prefilter */
static const char kPropDITManual[]=						"manual";						/* UINT32 */
static const char kPropDITDeinterlace[]=				"deinterlace";					/* UINT32 */
static const char kPropDITInvTelecine[]=				"inverseTelecine";				/* UINT32 */

/* Video duplicate frame dropper */
static const char kPropDupFrameDropperMaxAvgSSD[]=		"maxAvgSSD" ;					/* UINT32 */
static const char kPropDupFrameDropperMaxAvgChromaSSD[]="maxAvgChromaSSD" ;				/* UINT32 */
static const char kPropDupFrameDropperMaxSSD[]=			"maxAreaSSD" ;					/* UINT32 */
static const char kPropDupFrameDropperMaxChromaSSD[]=	"maxAreaChromaSSD" ;			/* UINT32 */
static const char kPropDupFrameDropperMaxDroppedFrames[]=	"maxDroppedFrames" ;		/* UINT32 */
static const char kPropDupFrameDropperEarlyExit[]=		"earlyExit";					/* BOOL */
static const char kPropDupFrameDropperDetailedLogInfo[]="enableDetailedLogInfo";		/* BOOL */


/* Black Level prefilter */

/* Video noise reduction prefilter */
static const char kPropNRLevel[] =						"level";						/* string */
static const char kValueNROff[] =						"off";							/* string */
static const char kValueNRLow[] =						"low";							/* string */
static const char kValueNRHigh[] =						"high";							/* string */

/* Video resize filter */
static const char kPropVideoResizeWidth[] =		    "videoResizeWidth";						/* string */
static const char kPropVideoResizeHeight[] =		    "videoResizeHeight";						/* string */
static const char kPropVideoResizeQuality[] =	    "videoResizeQuality";						/* string */

/* **************************/
/* OTHER TRANSFORM PLUGINS  */
/* **************************/

/* proxy support */
static const char kValueProxyType[] =                   "proxyType";                /* string */
static const char kValueProxyTypeDefault[] =            "proxyTypeDefault";         /* string */

/* audio and video codecs */
static const char kPropCodecName[] =					"codecName";				/* string */
static const char kPropBitrate[] =						"totalBitrate";				/* UINT32 */


/* Encoding type */
static const char kPropEncodingType[] =					"encodingType";				/* string */
static const char kValueEncodingTypeCBR[] =				"cbr";						/* string */
static const char kValueEncodingTypeVBRBitrate[] =		"vbrBitrate";				/* string */
static const char kValueEncodingTypeVBRQuality[] =		"vbrQuality";				/* string */
static const char kValueEncodingTypeVBRUnconstrainedQuality[] =		"vbrUnconstrainedQuality";				/* string */
static const char kValueEncodingTypeVBRUnconstrainedBitrate[] =		"vbrUnconstrainedBitrate";				/* string */

static const char kPropEncodingQuality[] =				"quality"	;				/* UINT32 */

/* Encoding complexity */
static const char kPropEncodingComplexity[] =			"encodingComplexity";		/* string */
static const char kValueEncodingComplexityLow[] =	"low";
static const char kValueEncodingComplexityMedium[] =	"medium";
static const char kValueEncodingComplexityHigh[] =	"high";


/* Audio Codec Plugin and interleaver plugin properties. */


static const char kPropAudioBitsPerFrame[] =			"audioBitsPerFrame";		/* UINT32 */
static const char kPropAudioBitsPerBlock[] =			"audioBitsPerBlock";		/* UINT32 */
static const char kPropAudioBlocksPerSuperBlock[] =		"audioBlocksPerSuperBlock"; /* UINT32 */


static const char kPropCodecFlavor[] =					"codecFlavor";				/* UINT32 */
static const UINT32 kValueUninitializedCodecFlavor =			0xffffffff;

static const char kValueVideoFormatPAL[] =				"PAL";						/* string */
static const char kValueVideoFormatNTSC[] =				"NTSC";						/* string */
static const char kValueVideoFormatSECAM[] =	   		"SECAM";   					/* string */
static const char kValueVideoFormatAUTO[] =				"AUTO";						/* string */

static const char kValueVideoModeSharp[] =				"sharp";					/* string */
static const char kValueVideoModeNormal[] =				"normal";					/* string */
static const char kValueVideoModeSmooth[] =				"smooth";					/* string */
static const char kValueVideoModeSlideshow[] =			"slideshow";				/* string */

static const char kPropOutputWidth[] =					"outputWidth";				/* UINT32 */
static const char kPropOutputHeight[] =					"outputHeight";				/* UINT32 */

static const char kPropResizeQuality[] =				"resizeQuality";			/* string */
static const char kValueResizeQualityFast[] =			"fast";						/* string */
static const char kValueResizeQualityHigh[] =			"high";						/* string */

static const char kValueCodecNameRV10[] =				"rv10";						/* string */
static const char kValueCodecNameRV9[] =				"rv9";						/* string */
static const char kValueCodecNameRV8[] =				"rv8";						/* string */
static const char kValueCodecNameRV6[] =				"rvg2svt";					/* string */

static const char kPropMaxOutputFrameRate[] =			"maxFrameRate";				/* double */
static const char kPropMaxTimeBetweenKeyFrames[] =		"maxKeyFrameInterval";		/* double */

static const char kPropMaxStartupLatency[] =			"maxStartupLatency";		/* double */
static const char kPropLossProtection[] =				"enableLossProtection";		/* bool */

static const char kPropMaxPacketSize[] =				"maxPacketSize";			/* UINT32 */

static const char kPropEnableInterleaving[] =			"enableInterleaving";		/* bool */



/* ****************/
/* POSTFILTER PLUGINS see pluginType above for more info*/
/* ****************/

/* ****************/
/* OUTPUT PLUGINS */
/* ****************/

/* Output Destination Property and its values*/
static const char kPropOutputPathname[] =				"filename";					/* string */
static const char kPropTempDirPath[] =					"tempDir";					/* string */
/* update when filename changes */
static const char kPropActualOutputFilename[] =			"actualOutputFilename";		/* string */

/* RM writer properties.  Note that kPropFileRollSize is in MB, not bytes */
static const char kPropFileRollSize[] =                                 "destinationRollSize";                  /* UINT32 */
static const char kPropFileRollTime[] =                                 "destinationRollTime";                  /* IUnknown */
static const char kPropMergeWriteSize[] =				"writeSize";				/* UINT32 */
static const char kPropMergeWriteInterval[] =			"writeInterval";			/* UINT32 */

/* other RSOutRBS server properties */

static const char kPropBroadcastAddress[] =				"address";					/* string */
static const char kPropBroadcastListenAddress[] =		"listenAddress";			/* string */
static const char kPropBroadcastPort[] =				"port";						/* UINT32 */
static const char kPropListenPort[] =					"listenPort";				/* UINT32 */
static const char kPropBroadcastEndPort[] =				"endPort";					/* UINT32 */

static const char kPropBroadcastPath[] =				"path";						/* string */
static const char kPropBroadcastSecurityType[] =		"securityType";				/* string */
static const char kPropBroadcastAuthType[] =			"authType";					/* string */
static const char kValueAccountBased[] =				"account-based";			/* string */
static const char kValueSinglePassword[] =				"single-password";			/* string */

/* other RSOutRBS only server properties */
static const char kPropBroadcastUsername[] =			"username";					/* string */
static const char kPropBroadcastPassword[] =			"password";					/* string */
static const char kPropBroadcastSavePassword[] =		"savePassword";				/* BOOLEAN */
static const char kPropBroadcastMulticastTTL[] =		"multicastTTL";				/* UINT32 */
static const char kPropBroadcastFecPercent[] =			"fecPercent";				/* UINT32 */
static const char kPropBroadcastFecOffset[] =			"fecOffset";				/* UINT32 */
static const char kPropBroadcastAllowResend[] =			"allowResends";				/* BOOLEAN */
static const char kPropBroadcastServerTimeout[]		=	"serverTimeout";			/* string */
static const char kPropBroadcastBufferlessTransport[] =	"bufferlessTransport";		/* string */
static const char kPropBroadcastMetadataResendInterval[] = "metadataResendInterval";/* UINT32 */
static const char kPropBroadcastEnableTCPReconnect[]	= "enableTCPReconnect";		/* BOOLEAN */
static const char kPropBroadcastTCPReconnectInterval[]	= "TCPReconnectInterval";	/* UINT32 */
static const char kPropBroadcastMulticastAddress[]		= "multicastAddress";		/* string */
static const char kPropBroadcastEnableSureStreamAwareSplitting[]= "enableSureStreamAwareSplitting";	/* BOOLEAN */
static const char kPropBroadcaststatisticsUpdateInterval[]		= "statisticsUpdateInterval";		/* double */
static const char kPropBroadcastSourceName[]			= "sourceName";				/* string */
/* General Server broadcast transport and its values */
static const char kPropBroadcastTransport[] =			"transport";				/* string */
static const char kValueUDPUnicast[] =					"udp/unicast";				/* string */
static const char kValueUDPMulticast[] =				"udp/multicast";			/* string */
static const char kValueTCP[] =							"tcp";						/* string */

static const char kPropBroadcastStreamname[] =			"streamname";				/* string */
static const char kPropBroadcastConfiguration[] =		"broadcastConfiguration";	/* IUnknown/IHXTBroadcastConfiguration */

static const char kPropPacketSource[] =				"packetSource";
/* ****************/
/* ENCODING SDK   */
/* ****************/

/* GUI based Preview configuration */
static const char kPropSinkUpdateInterval[] =			"sinkUpdateInterval";		/* INT32 */
static const INT32 kValueFirstSample =					-1;							/* INT32 */
static const INT32 kValueAllSamples =					0;							/* INT32 */
static const char kPropPreviewSinkPosition[] =			"previewSinkPosition";		/* UINT32 */
static const UINT32 kValueBeforeAllPrefilters =			0;							/* UINT32 */
static const UINT32 kValueAfterAllPrefilters =			100;						/* UINT32 */
static const UINT32 kValueAfterCodec =					200;						/* UINT32 */

/* IHXTEncodingJob properties */
static const char kPropEnableTwoPass[] =   				"enableTwoPass"; 			/* BOOL */
static const char kPropDisableWallclock[] =				"disableWallclock"; 			/* BOOL */
static const char kPropDisableLoadManagement[] =			"disableLoadManagement"; 		/* BOOL */
static const char kPropLoadManagementJitterThreshold[] =		"loadManagementJitterThreshold"; 	/* IUnknown */
static const char kPropLoadManagementLatencyMax[] =			"loadManagementLatencyMax"; 		/* IUnknown */
static const char kPropLoadManagementLatencyThreshold[] =		"loadManagementLatencyThreshold"; 	/* IUnknown */

/* Job metadata */
static const char kPropTitle[] =   						"Title"; 					/* string */
static const char kPropAuthor[] =   					"Author"; 					/* string */
static const char kPropCopyright[] =  					"Copyright"; 				/* string */
static const char kPropKeywords[] =   					"Keywords"; 				/* string */
static const char kPropDescription[] =					"Description";				/* string */

static const char kPropAllowRecording[] =				"Allow Recording";			/* BOOL */
static const char kPropContentRating[] =				"Content Rating";			/* UINT32 */

static const UINT32 kValueRatingNotRated =					0;							/* UINT32 */
static const UINT32 kValueRatingAllAges =						1;							/* UINT32 */
static const UINT32 kValueRatingOlderChildren =				2;							/* UINT32 */
static const UINT32 kValueRatingYoungerTeens =				3;							/* UINT32 */
static const UINT32 kValueRatingOlderTeens =					4;							/* UINT32 */
static const UINT32 kValueRatingAdultSupervision =			5;		 					/* UINT32 */
static const UINT32 kValueRatingAdultsOnly =					6;							/* UINT32 */


/* Media profile stuff */
static const char kPropVideoMode[] =					"videoMode";				/* string */
static const char kPropDisableAudio[] =					"disableAudio";				/* BOOL */
static const char kPropDisableVideo[] =					"disableVideo";				/* BOOL */
static const char kPropDisableEvents[] =				"disableEvents";			/* BOOL */
static const char kPropDisableImageMaps[] =				"disableImageMaps";			/* BOOL */


static const char kValueAudioFormatMusic[] =			"music";					/* string */
static const char kValueAudioFormatVoice[] =			"voice";					/* string */

static const char kPropPresentationType[] =				"presentationType";			/* string */
static const char kValuePresentationAudioOnly[]=		"audio-only";				/* string */
static const char kValuePresentationAudioVideo[]=		"audio-video";				/* string */

static const char kPropAudioMode[] =					"audioMode";				/* string */
static const char kValueAudioModeMusic[] =				"music";					/* string */
static const char kValueAudioModeVoice[] =				"voice";					/* string */

static const char kPropAudioResamplingQuality[] =		"audioResamplingQuality";	/* string */
static const char kValueAudioResamplingQualityFast[] =	"fast";						/* string */
static const char kValueAudioResamplingQualityHigh[] =	"high";						/* string */


/* Audience/stream definition stuff */
static const char kPropAvgBitrate[] =					"avgBitrate";				/* UINT32 */
static const char kPropMaxBitrate[] =					"maxBitrate";				/* UINT32 */
static const char kPropStreamContext[] =				"streamContext";			/* prop bag */

/* asm based */
static const char kPropStreamToken[] =					"streamToken";				/* UINT32 */
static const char kPropAsmHeaders[] =					"asmHeaders";				/* IUnknown */


/* ASM rulebook/stream token stuff */
static const char kPropStreamTokenContainer[] =			"streamTokens";				/* Property bag */
static const char kPropNumStreamTokens[] =				"numStreamTokens";			/* UINT32 */
static const char kPropStreamTokenBase[] =				"streamToken";				/* string */
static const char kPropMimeType[] =						"mimeType";					/* UINT32 */
static const char kPropLogicalStream[] =				"logicalStream";			/* UINT32 */
static const char kPropFlagRulePairs[] =				"flagRulePairs";			/* string */

/* ASM config */
enum LOGICAL_MIME_TYPE
{
    LOGICAL_MIME_TYPE_UNKNOWN
    ,LOGICAL_MIME_TYPE_REALAUDIO
    ,LOGICAL_MIME_TYPE_REALVIDEO
    ,LOGICAL_MIME_TYPE_REALEVENTS
    ,LOGICAL_MIME_TYPE_REALIMAGEMAPS
    ,MAX_LOGICAL_MIME_TYPE
};


/* SDK stuff */
static const char kPropObjectName[] =					"name";						/* string */
static const char kPropForceInit[] =					"forceInit";				/* bool */
static const char kPropUserSpecifiedPropEnum[] =		"userSpecifiedPropEnum";	/* IUnknown, IHXTPropertyEnumerator */
static const char kPropUserSpecifiedPropBag[] =			"userSpecifiedPropBag";		/* IUnknown, IHXTPropertyBag */

static const char kPropEventsInput[] =					"events";					/* IUnknown */
static const char kPropImageMapsInput[] =				"imagemaps";				/* IUnknown */

static const char kPropMajorVersion[] =					"majorVersion";
static const char kPropMinorVersion[] =					"minorVersion";

/* Types */
static const char kPropObjectType[] =					"type";						/* string */
static const char kPropAudioDeviceID[] =				"audioDeviceID";			/* string */
static const char kPropAudioDevicePort[] =				"audioDevicePort";			/* string */
static const char kPropAudioMixerID[] =					"audioMixerID";				/* string */
static const char kPropAudioMixerPort[] =				"audioMixerPort";			/* string */
static const char kPropVideoDeviceID[] =				"videoDeviceID";			/* string */
static const char kPropVideoDevicePort[] =				"videoDevicePort";			/* string */
static const char kPropAudioCaptureMono[] =				"audioCaptureMono";			/*  BOOL  */

/* Null inputs */
static const char kPropInitUserProps[] =				"initUserProps";			/* IHXTPropertyBag */

/* output stream types */

/* Media descriptors */
static const char kFilterDescriptorUncompSource[] =		"UncompressedSource";		/* string */
static const char kFilterDescriptorASM[] =				"fdASM";					/* string */
static const char kFilterDescriptorCodec[] =			"fdCodec";					/* string */
static const char kFilterDescriptorPrefilter[] =		"fdPrefilter";				/* string */
static const char kFilterDescriptorPostfilter[] =		"fdPostfilter";				/* string */
static const char kFilterDescriptorPacketizer[] =		"fdPacketizer";				/* string */

/*job file element names */
const char kPropXmlns[] = 		  						"xmlns";
const char kPropXmlnsXSI[] = 		  					"xmlns:xsi";
const char kPropXSISchemaLocation[] = 		  			"xsi:schemaLocation";
const char kPropXSIType[] = 		  					"xsi:type";
const char kPropEncodingJob[] =							"job";
const char kPropName[] =								"name";
const char kPropClipInfo[] =							"clipInfo";
const char kPropOutputProfile[] =						"output";
const char kPropOutputProfiles[] =						"parOutputs";
const char kPropInputs[] =								"inputs";
const char kPropInput[] =								"input";
const char kPropParInputs[] =							"parInputs";
const char kPropSeqInputs[] =							"seqInputs";
const char kPropParOutputs[] =							"parOutputs";
const char kPropPrefilters[] =							"prefilters";
const char kPropPrefilter[] =							"prefilter";
const char kPropPostfilter[] =							"postfilter";
const char kPropPostfilters[] =							"postfilters";
const char kPropDestinations[] =						"destinations";
const char kPropDestination[] =							"destination";
const char kPropMediaProfile[] =						"mediaProfile";
const char kPropEntry[] =	                     		"entry";
const char kPropValue[] =	                      		"value";
const char kPropServers[] =								"servers";
const char kPropStreams[] =								"streams";
const char kPropStream[] =								"stream";
const char kPropPacketizers[] =							"packetizers";
const char kPropPacketizer[] =							"packetizer";
const char kPropServer[] =								"server";
const char kPropAudiences[] =							"audiences";
const char kPropAudience[] =							"audience";
const char kPropAudienceRef[] =							"audienceRef";
const char kPropAudienceRefs[] =				  		"audienceRefs";
const char kPropServerRef[] =							"serverRef";
const char kPropFilename[] =							"filename";
const char kAttribType[] =								"type";
const char kAttrib_uint[] =								"uint";
const char kAttrib_string[] =							"string";
const char kAttrib_int[] =								"int";
const char kAttrib_int64[] =							"int64";
const char kAttrib_double[] =							"double";
const char kAttrib_bag[] =								"bag";
const char kAttrib_duration[] =							"duration";
const char kAttrib_bool[] =								"bool";


/* codec info properties and values for codec enumeration.*/
static const char kPropInstantiationProps[] =			"instantiationProps";		/* prop bag */
static const char kPropFilterGuid[] =					"filterGUID";				/* string */
static const char kPropCodecSpecificInfo[] =			"CodecSpecificInfo";		/* prop bag */
static const char kPropCodecLongName[] =				"CodecLongName";			/* string */
static const char kPropCodecFamilyId[] =				"CodecFamilyID";			/* UINT32 */
static const char kPropCodecPreferedType[] =			"AudioCodecPreferedType";	/* string */
static const char kPropAudioHighFrequency[] =			"HighFrequency";			/* UINT32 */
static const char kValueVoiceType[] =					"voice";					/* string */
static const char kValueMusicType[] =					"music";					/* string */

static const char kPropHasAudio[] =						"hasAudio";					/* BOOL */
static const char kPropHasVideo[] =						"hasVideo";					/* BOOL */
static const char kPropHasEvents[] =					"hasEvents";				/* BOOL */
static const char kPropHasImageMaps[] =					"hasImageMaps";				/* BOOL */

static const char kPropEncodingMode[] =   				"encodingMode";				/* UINT32 */
static const char kPropAnalysisPathname[] =  			"analysisFile";				/* string */

static const UINT32 kSinglePassEncodingMode =			0; 							/* UINT32 */
static const UINT32 kValueAnalysisMode =   				1; 							/* UINT32 */
static const UINT32 kValueEncodeUsingAnalysisMode =		2; 							/* UINT32 */


/* loading groups of plugins */
static const char kPropPluginID[] =						"PluginID";					/* string */
static const char kPropComponentName[] =				"ComponentName";			/* string arrays ?*/
static const char kPropComponentCLSID[] =				"ComponentCLSID";			/* UINT32 */
static const char kPropPluginLongName[] =				"pluginLongName";			/* string */

/* input reader plugins only */
static const char kPropFileExtensions[] =				"FileExtensions";			/* string arrays ?*/
static const char kPropPluginEnumType[] =				"PluginEnumType";			/* string */

static const UINT32 kValueMinExtensionPriority = 0;
static const UINT32 kValueMaxExtensionPriority = 100;

static const char kValuePluginEnumeratingCodecs[] =		"RTACodecEnumeratorPlugin";	/* string */
static const char kValuePluginEnumeratingCaptureDevices[] =	"RTACaptureDeviceEnumeratorPlugin";	/* string */

/* codec plugins only */
static const char kPropCodecNamesSuppported[] =					"CodecNamesSupported";

/* Allocator properties */

/* name of bag containing allocator properties nested property in a given connection format / propety bag */
static const char kPropAllocator[] =					"allocatorProperties";		/* prop bag */

/* the following properties may be specified in the nested allocator property bag  */

/* number of bytes requested - size of pool to allocate */
static const char kAllocatorPropBytesRequested[] =		"allocatorBytesRequested";

/* number of bytes to reserve at beginning of buffer, in addition to bytes requested: */
/* this number is usually the maximum frame size for vbr content and 0 for cbr content */
static const char kAllocatorPropPrefix[] =				"allocatorPrefix";

/* preferred buffer alignment (most useful for cbr content such as raw video frames) */
/* this attribute may affect hardware cache performance */
static const char kAllocatorPropAlign[] =				"allocatorAlign";

/* Max sizes for properties */
const int knMaxPropStringSize   =						100;


static const char kPropStatsTime[] = "time";										/* i64 time in millisecond*/
static const char kPropStatsDuration[] = "duration";								/* i64 time interval in millisecond*/
static const char kPropStatsBitrate[] = "bitrate";									/* UINT32 average bit per second */
static const char kPropStatsFPS[]="fps";											/* double average frames per second */
static const char kPropStatsMinFPS[]="minimumfps";									/* double minimum frames per second */
static const char kPropStatsVideoFrameQuality[]="videoFrameQuality";				/* UINT32 video quality */
static const char kPropStatsMinVideoFrameQuality[] = "minimumvideoFrameQuality";	/* UINT32 minimum video quality */
static const char kPropStatsPreroll[] = "preroll";									/* double preroll in second*/
static const char kPropStatsMinFPSTime[] = "minimumfpstime";						/* i64 time when mimimum fps occured*/
static const char kPropStatsMinVideoFrameQualityTime[] = "minimumvideoFrameQualitytime";	/* i64 time when mimimum quality occured*/
static const char kPropStatsAvgBitrate[] = "avgBitrate";
static const char kPropStatsMinBitrate[] = "minBitrate";
static const char kPropStatsMaxBitrate[] = "maxBitrate";


static const char kPropStatsState[] = "state"; 	/* UINT32 current state of object */

/* Different States that a process supports */
enum EHXTStateCode
{
	IDLE_STATE = 0,
	RUNNING_STATE
};

/* Color format naming convention  */
/* (LE - little endiann) */
/* (BE - big endiann ) */
/*  Names speify layouout in memory BGRA means ( BBBB BBBB GGGG GGGG RRRR RRRR AAAA AAAA) */
/*  All color formats are should have new row begning on 4 byte boundary. */
enum EHXTVideoColorFormat
{
	HXT_VIDEO_FORMAT_BGR24_INVERTED = 0,		/* default 24 bit format on windows.  */

	HXT_VIDEO_FORMAT_BGR24_NONINVERTED,

	HXT_VIDEO_FORMAT_BGRA32_INVERTED,		/* default 32 bit format on windows.  */

	HXT_VIDEO_FORMAT_BGRA32_NONINVERTED,

	HXT_VIDEO_FORMAT_LE_ARGB555_INVERTED,	/* default 16 bit windows format.  */

	HXT_VIDEO_FORMAT_LE_ARGB555_NONINVERTED,

	HXT_VIDEO_FORMAT_LE_RGB565_INVERTED,		/* default 16 bit windows format  */

	HXT_VIDEO_FORMAT_LE_RGB565_NONINVERTED,

	HXT_VIDEO_FORMAT_RGB24_INVERTED,

	HXT_VIDEO_FORMAT_RGB24_NONINVERTED,		/* default 24 bit format on mac.   */

	HXT_VIDEO_FORMAT_ARGB32_INVERTED,

	HXT_VIDEO_FORMAT_ARGB32_NONINVERTED,		/*  default 32 bit format on mac.  */

	HXT_VIDEO_FORMAT_RGBA32_INVERTED,

	HXT_VIDEO_FORMAT_RGBA32_NONINVERTED,

	HXT_VIDEO_FORMAT_ABGR32_INVERTED,

	HXT_VIDEO_FORMAT_ABGR32_NONINVERTED,

	HXT_VIDEO_FORMAT_BE_ARGB555_INVERTED,

	HXT_VIDEO_FORMAT_BE_ARGB555_NONINVERTED,	/*  default 16 bit format on mac.  */

	HXT_VIDEO_FORMAT_BE_RGB565_INVERTED,

	HXT_VIDEO_FORMAT_BE_RGB565_NONINVERTED,

	HXT_VIDEO_FORMAT_LE_RGBA555_INVERTED,

	HXT_VIDEO_FORMAT_LE_RGBA555_NONINVERTED,

	HXT_VIDEO_FORMAT_BGR8_INVERTED,

	HXT_VIDEO_FORMAT_BGR8_NONINVERTED,


    /* planar yuv formats */
    HXT_VIDEO_FORMAT_I420,           /*  the codec's format -- planar 4:2:0 (covers fourCC 'IYUV' as well)  */

    HXT_VIDEO_FORMAT_YV12,           /*  same as I420, but with UV planes swapped  */

    HXT_VIDEO_FORMAT_YVU9,           /*  planar 16:2:0 format   */

	HXT_VIDEO_FORMAT_IF09,			/*  Same as YVU9 but an additional 4x4 subsampled plane is appended containing delta information relative to the last frame.  */

    /* packed YUV formats */
    HXT_VIDEO_FORMAT_YUY2,           /*  packed 4:2:2 format   */

    HXT_VIDEO_FORMAT_YUY2_INVERTED,	/*  packed 4:2:2 format, inverted (Winnov Videum)   */

    HXT_VIDEO_FORMAT_UYVY,           /*  packed 4:2:2 format, different ordering.  */

	HXT_VIDEO_FORMAT_IUYV,

	HXT_VIDEO_FORMAT_IY41,

	HXT_VIDEO_FORMAT_IYU1,

	HXT_VIDEO_FORMAT_IYU2,

	HXT_VIDEO_FORMAT_CYUV,

	HXT_VIDEO_FORMAT_YVYU,

	HXT_VIDEO_FORMAT_Y211,

	HXT_VIDEO_FORMAT_Y41T,

	HXT_VIDEO_FORMAT_Y42T,

	HXT_VIDEO_FORMAT_CLJR,

	/* Mac specific YUVs and YCbCr */
	HXT_VIDEO_FORMAT_YUV2,

	HXT_VIDEO_FORMAT_V308,

	HXT_VIDEO_FORMAT_V408,

	HXT_VIDEO_FORMAT_V216,

	HXT_VIDEO_FORMAT_V410,

	HXT_NUM_VIDEO_FORMATS
};

#define HXT_VIDEO_FORMAT_YUNV HXT_VIDEO_FORMAT_YUY2

#define HXT_VIDEO_FORMAT_UYNV HXT_VIDEO_FORMAT_UYVY

#define HXT_VIDEO_FORMAT_IYUV HXT_VIDEO_FORMAT_I420

#define HXT_VIDEO_FORMAT_YUVU HXT_VIDEO_FORMAT_YUV2


#endif // _HXTCONSTANTS_H




