/* ***** BEGIN LICENSE BLOCK ***** 
 * Version: RCSL 1.0/RPSL 1.0 
 *  
 * Portions Copyright (c) 1995-2002 RealNetworks, Inc. All Rights Reserved. 
 *      
 * The contents of this file, and the files included with this file, are 
 * subject to the current version of the RealNetworks Public Source License 
 * Version 1.0 (the "RPSL") available at 
 * http://www.helixcommunity.org/content/rpsl unless you have licensed 
 * the file under the RealNetworks Community Source License Version 1.0 
 * (the "RCSL") available at http://www.helixcommunity.org/content/rcsl, 
 * in which case the RCSL will apply. You may also obtain the license terms 
 * directly from RealNetworks.  You may not use this file except in 
 * compliance with the RPSL or, if you have a valid RCSL with RealNetworks 
 * applicable to this file, the RCSL.  Please see the applicable RPSL or 
 * RCSL for the rights, obligations and limitations governing use of the 
 * contents of the file.  
 *  
 * This file is part of the Helix DNA Technology. RealNetworks is the 
 * developer of the Original Code and owns the copyrights in the portions 
 * it created. 
 *  
 * This file, and the files included with this file, is distributed and made 
 * available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER 
 * EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS ALL SUCH WARRANTIES, 
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY, FITNESS 
 * FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT. 
 * 
 * Technology Compatibility Kit Test Suite(s) Location: 
 *    http://www.helixcommunity.org/content/tck 
 * 
 * Contributor(s): 
 *  
 * ***** END LICENSE BLOCK ***** */ 

/****************************************************************************
 * 
 *  Exhaustive list of IID's used in IHX interfaces
 *
 *  Note: These IIDs generally are duplicated in the headers that are specific
 *  to each interface, so if you change this file, change the other file(s) as
 *  well.  Having all these IIDS in one files is convenient to some folks, but
 *  not everyone includes this file, hence the need to keep them in individual 
 *  files as well.
 */

#ifndef _HXIIDS_H_
#define _HXIIDS_H_

/*
 *  File:
 *	hxcom.h
 *  Description:
 *	Interfaces defined by COM.
 *  Interfaces:
 *	IID_IUnknown:		    {00000000-0000-0000-C000000000000046}
 *	IID_IMalloc:		    {00000002-0000-0000-C000000000000046}
 */ 

/*
 * These GUIDs are defined in hxcom.h:
 *
 * DEFINE_GUID_ENUM(IID_IUnknown,   0x00000000, 0x0000, 0x0000, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46)
 * DEFINE_GUID_ENUM(IID_IMalloc,    0x00000002, 0x0000, 0x0000, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46)
 *
 */

/*
 *  File:
 *	hxcomm.h
 *  Description:
 *	RealMedia Common Utility interfaces
 *  Interfaces:
 *	IID_IHXCommonClassFactory: {00000000-0901-11d1-8B06-00A024406D59}
 *	IID_IHXStatistics:	    {00000001-0901-11d1-8B06-00A024406D59}
 *	IID_IHXRegistryID:	    {00000002-0901-11d1-8B06-00A024406D59}
 *	IID_IHXServerFork:	    {00000003-0901-11d1-8B06-00A024406D59}
 *	IID_IHXServerControl:	    {00000004-0901-11d1-8B06-00A024406D59}
 *	IID_IHXServerControl2:	    {00000005-0901-11d1-8B06-00A024406D59}
 *	IID_IHXReconfigServerResponse:	    {00000006-0901-11d1-8B06-00A024406D59}
 */

#ifndef _HXCCF_H_
DEFINE_GUID_ENUM(IID_IHXCommonClassFactory,	    0x00000000, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
#endif /* _HXCCF_H_ */

#ifndef _HXCOMM_H_
DEFINE_GUID_ENUM(IID_IHXStatistics,	    	    0x00000001, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXRegistryID,		    0x00000002, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXServerFork,		    0x00000003, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXServerControl,	    0x00000004, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXServerControl2,	    0x00000005, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXReconfigServerResponse, 0x00000006, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXServerReconfigNotification, 0x00000007, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXWantServerReconfigNotification, 0x00000008, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
#endif

/*
 *  File:
 *	hxengin.h
 *  Description:
 *	Interfaces related to callbacks, networking, and scheduling.
 *  Interfaces:
 *	IID_IHXCallback:	    {00000100-0901-11d1-8B06-00A024406D59}
 *	IID_IHXScheduler:	    {00000101-0901-11d1-8B06-00A024406D59}
 *	IID_IHXTCPResponse:	    {00000102-0901-11d1-8B06-00A024406D59}
 *	IID_IHXTCPSocket:	    {00000103-0901-11d1-8B06-00A024406D59}
 *	IID_IHXListenResponse:	    {00000104-0901-11d1-8B06-00A024406D59}
 *	IID_IHXListenSocket:	    {00000105-0901-11d1-8B06-00A024406D59}
 *	IID_IHXNetworkServices:    {00000106-0901-11d1-8B06-00A024406D59}
 *	IID_IHXUDPResponse:	    {00000107-0901-11d1-8B06-00A024406D59}
 *	IID_IHXUDPSocket:	    {00000108-0901-11d1-8B06-00A024406D59}
 *      IID_IHXResolver:           {00000109-0901-11d1-8B06-00A024406D59}
 *      IID_IHXResolverResponse:   {0000010A-0901-11d1-8B06-00A024406D59}
 *      IID_IHXInterruptSafe:      {0000010B-0901-11d1-8B06-00A024406D59}
 *      IID_IHXAsyncIOSelection:   {0000010C-0901-11d1-8B06-00A024406D59}
 *      IID_IHXUDPMulticastInit:   {0000010D-0901-11d1-8B06-00A024406D59}
 *      IID_IHXInterruptState:     {0000010E-0901-11d1-8B06-00A024406D59}
 *      IID_IHXOptimizedScheduler: {0000010F-0901-11d1-8B06-00A024406D59}
 *	IID_IHXLoadBalancedListen: {00000110-0901-11d1-8B06-00A024406D59}
 *	IID_IHXOverrideDefaultServices: {00000111-0901-11d1-8B06-00A024406D59}
 *	IID_IHXHTTPPostObject:	    {00000112-0901-11d1-8B06-00A024406D59}
 *	IID_IHXHTTPPostResponse:   {00000113-0901-11d1-8B06-00A024406D59}
 *	IID_IHXSetSocketOption:    {00000114-0901-11d1-8B06-00A024406D59}
 *	IID_IHXThreadSafeMethods:  {00000115-0901-11d1-8B06-00A024406D59}
 *	IID_IHXMutex:		    {00000116-0901-11d1-8B06-00A024406D59}
 *	IID_IHXNetworkInterfaceEnumerator{00000121-0901-11d1-8B06-00A024406D59}
 *
 */
#ifndef _HXENGIN_H_
DEFINE_GUID_ENUM(IID_IHXCallback,		0x00000100, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXScheduler,		0x00000101, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXTCPResponse,	0x00000102, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXTCPSocket,		0x00000103, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXListenResponse,	0x00000104, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXListenSocket,	0x00000105, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXNetworkServices,	0x00000106, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXNetworkServices2,   0x17951551, 0x5683, 0x11d3, 0xb6, 0xba, 0x0, 0xc0, 0xf0, 0x31, 0xc2, 0x37)
DEFINE_GUID_ENUM(IID_IHXUDPResponse,	0x00000107, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXUDPSocket,		0x00000108, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXResolver,		0x00000109, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXResolverResponse,	0x0000010A, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXInterruptSafe,	0x0000010B, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXAsyncIOSelection,	0x0000010C, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXUDPMulticastInit,	0x0000010D, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXInterruptState,	0x0000010E, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXOptimizedScheduler,	0x0000010F, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXLoadBalancedListen,	0x00000110, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXOverrideDefaultServices,	0x00000111, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXSetSocketOption,	0x00000114, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXThreadSafeMethods,	0x00000115, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXMutex,		0x00000116, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXNetworkInterfaceEnumerator,0x00000121, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
#endif


/*
 *  File:
 *	hxfiles.h
 *  Description:
 *	Interfaces related to file systems.
 *  Interfaces:
 *	IID_IHXFileObject:		{00000200-0901-11d1-8B06-00A024406D59}
 *	IID_IHXFileResponse:		{00000201-0901-11d1-8B06-00A024406D59}
 *	IID_IHXFileSystemObject:	{00000202-0901-11d1-8B06-00A024406D59}
 *	IID_IHXDirObject:		{00000203-0901-11d1-8B06-00A024406D59}
 *	IID_IHXDirResponse:		{00000204-0901-11d1-8B06-00A024406D59}
 *	IID_IHXFileStat:		{00000205-0901-11d1-8B06-00A024406D59}
 *	IID_IHXFileStatResponse:	{00000206-0901-11d1-8B06-00A024406D59}
 *	IID_IHXFileSystemManager:	{00000207-0901-11d1-8B06-00A024406D59}
 *	IID_IHXFileSystemManagerResponse:
 *					{00000208-0901-11d1-8B06-00A024406D59}
 *	IID_IHXFileExists:		{00000209-0901-11d1-8B06-00A024406D59}
 *	IID_IHXFileExistsResponse:	{0000020A-0901-11d1-8B06-00A024406D59}
 *	IID_IHXFileMimeMapper:		{0000020B-0901-11d1-8B06-00A024406D59}
 *	IID_IHXFileMimeMapperResponse:	{0000020C-0901-11d1-8B06-00A024406D59}
 *	IID_IHXBroadcastMapper:	{0000020D-0901-11d1-8B06-00A024406D59}
 *	IID_BroadcastMimeMapperResponse:{0000020E-0901-11d1-8B06-00A024406D59}
 *      IID_IHXGetFileFromSamePool:    {0000020F-0901-11d1-8B06-00A024406D59}
 *      IID_GetFileFromSamePoolResponse:{00000210-0901-11d1-8B06-00A024406D59}
 *      IID_IHXFileAuthenticator:      {00000211-0901-11d1-8B06-00A024406D59} 
 *      IID_IHXRequestHandler:         {00000212-0901-11d1-8B06-00A024406D59} 
 *      IID_IHXRequest:                {00000213-0901-11d1-8B06-00A024406D59} 
 *      IID_IHXFileRename:             {00000214-0901-11d1-8B06-00A024406D59}
 *      IID_IHXFileMove:				{23E72FB0-DE0E-11d5-AA9A-00010251B340}
 *      IID_IHXDirHandler:             {00000215-0901-11d1-8B06-00A024406D59}
 *      IID_IHXDirHandlerResponse:     {00000216-0901-11d1-8B06-00A024406D59}
 *	IID_IHXRequestContext		{00000217-0901-11d1-8B06-00A024406D59}
 *      IID_IHXFileRemove:             {0000021A-0901-11d1-8B06-00A024406D59}
 *      DEPRECATED DEPRECATED           {0000021B-0901-11d1-8B06-00A024406D59}
 *
 */
#ifndef _HXFILES_H_
DEFINE_GUID_ENUM(IID_IHXHTTPPostObject,	0x00000112, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXHTTPPostResponse,	0x00000113, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXFileObject,			0x00000200, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXFileResponse,		0x00000201, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXFileSystemObject,		0x00000202, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXDirObject,			0x00000203, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)	//NOTE, use is deprecated
DEFINE_GUID_ENUM(IID_IHXDirResponse,		0x00000204, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)	//NOTE, use is deprecated
DEFINE_GUID_ENUM(IID_IHXFileStat,			0x00000205, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXFileStatResponse,		0x00000206, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXFileSystemManager,		0x00000207, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXFileSystemManagerResponse,	0x00000208, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXFileExists,			0x00000209, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXFileExistsResponse,		0x0000020a, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXFileMimeMapper,		0x0000020b, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXFileMimeMapperResponse,	0x0000020c, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXBroadcastMapper,		0x0000020d, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXBroadcastMapperResponse,	0x0000020e, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXGetFileFromSamePool,	0x0000020f, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXGetFileFromSamePoolResponse,0x00000210, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXFileAuthenticator,          0x00000211, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXRequestHandler,             0x00000212, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXRequest,                    0x00000213, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXFileRename,                 0x00000214, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXFileMove,					0x23e72fb0, 0xde0e, 0x11d5, 0xaa, 0x9a, 0x0, 0x1, 0x2, 0x51, 0xb3, 0x40)
DEFINE_GUID_ENUM(IID_IHXDirHandler,                 0x00000215, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXDirHandlerResponse,         0x00000216, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXRequestContext,		0x00000217, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXFileRemove,                 0x0000021a, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXFileRecognizer,             0x00000220, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXFileRecognizerResponse,     0x00000221, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
#endif
/*
 *  File:
 *	hxrendr.h
 *  Description:
 *	Interfaces related to renderers.
 *  Interfaces:
 *	IID_IHXRenderer:	    	{00000300-0901-11d1-8B06-00A024406D59}
 *	IID_IHXPersistentRenderer:	{00000301-0901-11d1-8B06-00A024406D59}
 */
DEFINE_GUID_ENUM(IID_IHXRenderer,		    0x00000300, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)

/*
 *  File:
 *	hxcore.h
 *  Description:
 *	Interfaces related to the client core services.
 *  Interfaces:
 *	IID_IHXStream:		    {00000400-0901-11d1-8B06-00A024406D59}
 *	IID_IHXStreamSource	    {00000401-0901-11d1-8B06-00A024406D59}
 *	IID_IHXPlayer:		    {00000402-0901-11d1-8B06-00A024406D59}
 *	IID_IHXClientEngine:	    {00000403-0901-11d1-8B06-00A024406D59}
 *	IID_IHXClientEngineSelector{00000404-0901-11d1-8B06-00A024406D59}
 *	IID_IHXClientEngineSetup:  {00000405-0901-11d1-8B06-00A024406D59}
 *				 :  {00000406-0901-11d1-8B06-00A024406D59}  -- Deprecated 
 *	IID_IHXInfoLogger:	    {00000409-0901-11d1-8B06-00A024406D59}
 *	    			    {0000040F-0901-11d1-8B06-00A024406D59}  -- Deprecated
 *	IID_IHXPlayer2:	    {00000411-0901-11d1-8B06-00A024406D59}
 *	IID_IHXPlayerNavigator:    {00000414-0901-11d1-8B06-00A024406D59}
 *	IID_IHXPersistentComponentManager: {00000415-0901-11d1-8B06-00A024406D59}
 *	IID_IHXPersistentComponent:	    {00000416-0901-11d1-8B06-00A024406D59}
 */
#ifndef _HXCORE_H_
DEFINE_GUID_ENUM(IID_IHXStream,	    0x00000400, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXStreamSource,   0x00000401, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXPlayer,	    0x00000402, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXClientEngine,   0x00000403, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
#ifdef _UNIX
DEFINE_GUID_ENUM(IID_IHXClientEngineSelector,	0x00000404, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
#endif
DEFINE_GUID_ENUM(IID_IHXClientEngineSetup,		0x00000405, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXInfoLogger, 		0x00000409, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXPlayer2,			0x00000411, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXUpdateProperties,		0x00000413, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXPlayerNavigator,		0x00000414, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXPersistentComponentManager,	0x00000415, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXPersistentComponent,	0x00000416, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
#endif
/*
 *  File:
 *	hxprefs.h
 *  Description:
 *	Interfaces related to persistent preferences services.
 *  Interfaces:
 *	IID_IHXPreferences:	    {00000500-0901-11d1-8B06-00A024406D59}
 */
#ifndef _HXPREFS_H_
DEFINE_GUID_ENUM(IID_IHXPreferences,    0x00000500, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXPreferences2, 0x00000503, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 
			0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXPreferenceEnumerator, 0x00000504, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 
			0xa0, 0x24, 0x40, 0x6d, 0x59)
#endif

/*
 *  File:
 *      hxmon.h
 *  Description:
 *      Interfaces related to Monitor plugins.
 *  Interfaces:
 *      IID_IHXRegistry:                  {00000600-0901-11d1-8B06-00A024406D59}
 *      IID_IHXPropWatch:                   {00000601-0901-11d1-8B06-00A024406D59}
 *      IID_IHXPropWatchResponse:           {00000602-0901-11d1-8B06-00A024406D59}
 *      IID_IHXActiveRegistry:              {00000603-0901-11d1-8B06-00A024406D59}
 *      IID_IHXActivePropUser:              {00000604-0901-11d1-8B06-00A024406D59}
 *      IID_IHXActivePropUserResponse:      {00000605-0901-11d1-8B06-00A024406D59}
 *      IID_IHXCopyRegistry:                {00000606-0901-11d1-8B06-00A024406D59}
 *      IID_IHXRegistryAltStringHandling: {00000607-0901-11d1-8B06-00A024406D59}
 *      IID_IHXRegistry2:                 {00000608-0901-11d1-8B06-00A024406D59}
 */
#ifndef _HXMON_H_
DEFINE_GUID_ENUM(IID_IHXRegistry,                 0x00000600, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXPropWatch,                  0x00000601, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXPropWatchResponse,          0x00000602, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXActiveRegistry,             0x00000603, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXActivePropUser,             0x00000604, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXActivePropUserResponse,     0x00000605, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXCopyRegistry,               0x00000606, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXRegistryAltStringHandling,0x00000607, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXRegistry2,                0x00000608, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
#endif
/*
 *  File:
 *	hxausvc.h
 *  Description:
 *	Interfaces related to audio services.
 *  Interfaces:
 *	IID_IHXAudioPlayer:        	 {00000700-0901-11d1-8B06-00A024406D59}
 *	IID_IHXAudioPlayerResponse:	 {00000701-0901-11d1-8B06-00A024406D59}
 *	IID_IHXAudioStream: 	    	 {00000702-0901-11d1-8B06-00A024406D59}
 *	IID_IHXAudioDevice: 	    	 {00000703-0901-11d1-8B06-00A024406D59}
 *	IID_IHXAudioDeviceResponse:	 {00000704-0901-11d1-8B06-00A024406D59}
 *	IID_IHXAudioHook:	     	 {00000705-0901-11d1-8B06-00A024406D59}
 *	IID_IHXAudioStreamInfoResponse: {00000706-0901-11d1-8B06-00A024406D59}
 *	IID_IHXVolume: 		 {00000707-0901-11d1-8B06-00A024406D59}
 *	IID_IHXVolumeAdviseSink: 	 {00000708-0901-11d1-8B06-00A024406D59}
 *	IID_IHXDryNotification: 	 {00000709-0901-11d1-8B06-00A024406D59}
 *	IID_IHXAudioDeviceManager: 	 {0000070A-0901-11d1-8B06-00A024406D59}
 *	IID_IHXAudioCrossFade: 	 {0000070B-0901-11d1-8B06-00A024406D59}
 *	IID_IHXAudioStream2: 		 {0000070C-0901-11d1-8B06-00A024406D59}
 *	IID_IHXAudioPushdown: 		 {0000070D-0901-11d1-8B06-00A024406D59}
 *	IID_IHXAudioHookManager:	 {0000070E-0901-11d1-8B06-00A024406D59}
 */
DEFINE_GUID_ENUM(IID_IHXAudioPlayer,	     0x00000700, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXAudioPlayerResponse,     0x00000701, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXAudioStream,	     0x00000702, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXAudioDevice,	     0x00000703, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXAudioDeviceResponse,     0x00000704, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXAudioHook,		     0x00000705, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXAudioStreamInfoResponse, 0x00000706, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXVolume, 		     0x00000707, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXVolumeAdviseSink, 	     0x00000708, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXDryNotification,	     0x00000709, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXAudioDeviceManager,	     0x0000070A, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXAudioCrossFade,	     0x0000070B, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXAudioStream2,	     0x0000070C, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXAudioPushdown,	     0x0000070D, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXAudioHookManager,	     0x0000070E, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)

/*
 *  File:
 *	hxerror.h
 *  Description:
 *	Interfaces related to error reporting and receiving notification of errors.
 *  Interfaces:
 *	IID_IHXErrorMessages:	    {00000800-0901-11d1-8B06-00A024406D59}
 *  	IID_IHXErrorSink:	    {00000801-0901-11d1-8B06-00A024406D59}
 *	IID_IHXErrorSinkControl:   {00000802-0901-11d1-8B06-00A024406D59}
 */
#ifndef _HXERROR_H_
DEFINE_GUID_ENUM(IID_IHXErrorMessages, 	    0x00000800, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXErrorSink,		    0x00000801, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXErrorSinkControl,	    0x00000802, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
#endif
/*
 *  File:
 *	hxhyper.h
 *  Description:
 *	Simple Hyper Navigation Interfaces
 *  Interfaces:
 *	IID_IHXHyperNavigate:			{00000900-0901-11d1-8B06-00A024406D59}
 *	IID_IHXHyperNavigate2:			{00000901-0901-11d1-8B06-00A024406D59}
 *	IID_IHXHyperNavigateWithContext:	{00000902-0901-11d1-8B06-00A024406D59}
 */
DEFINE_GUID_ENUM(IID_IHXHyperNavigate,		    0x00000900, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)

/*
 *  File:
 *	hxclsnk.h
 *  Description:
 *	Client Advise Sink Interfaces
 *  Interfaces:
 *	IID_IHXClientAdviseSink:   {00000B00-0901-11d1-8B06-00A024406D59}
 */
DEFINE_GUID_ENUM(IID_IHXClientAdviseSink,  0x00000B00, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)

/*
 *  File:
 *	hxplugn.h
 *  Description:
 *	Plugin inspector interface
 *  Interfaces:
 *	IID_IHXPlugin:			{00000C00-0901-11d1-8B06-00A024406D59}
 *	IID_IHXPluginEnumerator	{00000C01-0901-11d1-8B06-00A024406D59}
 *	IID_IHXPluginGroupEnumerator   {00000C02-0901-11d1-8B06-00A024406D59}
 *	IID_IHXPluginReloader		{00000C03-0901-11d1-8B06-00A024406D59}
 *	IID_IHXPluginFactory		{00000C04-0901-11d1-8B06-00A024406D59}
 *      IID_IHXPersistentComponent	{00000C0B-0901-11d1-8B06-00A024406D59}
 */
#ifndef _HXPLUGN_H_
DEFINE_GUID_ENUM(IID_IHXPlugin,		0x00000C00, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXPluginEnumerator,	0x00000C01, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXPluginGroupEnumerator, 0x00000C02, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXPluginSearchEnumerator, 0x3244b391, 0x42d4, 0x11d4, 0x95, 0x3, 0x0, 0x90, 0x27, 0x90, 0x29, 0x9c)
DEFINE_GUID_ENUM(IID_IHXPluginReloader,	0x00000C03, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXPluginFactory,	0x00000C04, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
#endif
/*
 *  File:
 *	hxwin.h
 *  Description:
 *	Site interfaces
 *  Interfaces:
 *	IID_IHXSiteWindowed:				{00000D01-0901-11d1-8B06-00A024406D59}
 *	IID_IHXSiteWindowless:				{00000D02-0901-11d1-8B-6-00A024406D59}
 *	IID_IHXSite:					{00000D03-0901-11d1-8B-6-00A024406D59}
 *	IID_IHXSiteUser:				{00000D04-0901-11d1-8B-6-00A024406D59}
 *	IID_IHXSiteWatcher:				{00000D05-0901-11d1-8B-6-00A024406D59}
 *	IID_IHXSiteUserSupplier:			{00000D06-0901-11d1-8B-6-00A024406D59}
 *	IID_IHXSiteSupplier:				{00000D07-0901-11d1-8B-6-00A024406D59}
 *	IID_IHXSiteManager:				{00000D08-0901-11d1-8B-6-00A024406D59}
 *	IID_IHXMultiInstanceSiteUserSupplier:		{00000D09-0901-11d1-8B-6-00A024406D59}
 *	IID_IHXSite2:					{00000D0A-0901-11d1-8B-6-00A024406D59}
 *	IID_IHXSiteFullScreen				{00000D0B-0901-11d1-8B-6-00A024406D59}
 *	IID_IHXEventHookMgr				{00000D0D-0901-11d1-8B-6-00A024406D59}
 *	IID_IHXEventHook				{00000D0E-0901-11d1-8B-6-00A024406D59}
 *	IID_IHXPassiveSiteWatcher			{00000D0F-0901-11d1-8B-6-00A024406D59}
 *	IID_IHXStatusMessage				{00000D10-0901-11d1-8B-6-00A024406D59}
 */
#ifndef _HXWIN_H_
DEFINE_GUID_ENUM(IID_IHXSiteWindowed,		    0x00000D01, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXSiteWindowless,		    0x00000D02, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXSite, 			    0x00000D03,	0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXSiteUser,			    0x00000D04, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXSiteWatcher,		    0x00000D05, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXSiteUserSupplier,		    0x00000D06, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXSiteSupplier,		    0x00000D07, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXSiteManager,		    0x00000D08, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXMultiInstanceSiteUserSupplier,  0x00000D09, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXSite2,  			    0x00000D0A, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXSiteFullScreen,		    0x00000D0B, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXEventHookMgr,		    0x00000D0D, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXEventHook,			    0x00000D0E, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXPassiveSiteWatcher,		    0x00000D0F, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXStatusMessage,		    0x00000D10, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXKeyBoardFocus,                  0x00000D23, 0x903, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXDrawFocus,                      0x00000D24, 0x903, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXSubRectSite,                  0x00000D25, 0x903, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
#endif
/*
 *  File:
 *	hxformt.h
 *  Description:
 *	Interfaces related to file and broadcast format plugins.
 *  Interfaces:
 *
 *	IID_IHXFileFormatObject:	{00000F00-0901-11d1-8B06-00A024406D59}
 *	IID_IHXBroadcastFormatObject:	{00000F01-0901-11d1-8B06-00A024406D59}
 *	IID_IHXFormatResponse:              {00000F02-0901-11d1-8B06-00A024406D59}
 *  IID_IHXFormatReuse:                 {e55077c4-a299-11d7-864c-0002b3658720}
 *	IID_IHXPacketFormat:		{00000F03-0901-11d1-8B06-00A024406D59}
 *	IID_IHXPacketTimeOffsetHandler {00000F04-0901-11d1-8B06-00A024406D59}
 *      IID_IHXPacketTimeOffsetHandlerResponse {00000F05-0901-11d1-8B06-00A024406D59}
 *      IID_IHXLiveFileFormatInfo      {00000F06-0901-11d1-8B06-00A024406D59}
 */
#ifndef _HXFORMT_H_
DEFINE_GUID_ENUM(IID_IHXFileFormatObject,	    0x00000F00, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXBroadcastFormatObject,  0x00000F01, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXFormatResponse,	    0x00000F02, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXFormatReuse,        0xe55077c4, 0xa299, 0x11d7, 0x86, 0x4c, 0x0, 0x2, 0xb3, 0x65, 0x87, 0x20)
DEFINE_GUID_ENUM(IID_IHXPacketFormat,	    0x00000F03, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXPacketTimeOffsetHandler, 0x00000F04, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXPacketTimeOffsetHandlerResponse, 0x00000F05, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXLiveFileFormatInfo,     0x00000F06, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)

DEFINE_GUID_ENUM(IID_IHXSyncFileFormatObject,   0x00000F0C, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)

#endif

#ifndef _HXFWRTR_H_
#endif

#ifndef _HXSRCIN_H_
DEFINE_GUID_ENUM(IID_IHXSourceInput,		    0xebf8d220, 0x40f7, 0x11d6, 0xab, 0x3f, 0x0, 0x1, 0x2, 0x51, 0xb3, 0x40)
DEFINE_GUID_ENUM(IID_IHXSourceHandler,		    0xb2646da0, 0x410a, 0x11d6, 0xab, 0x3f, 0x0, 0x1, 0x2, 0x51, 0xb3, 0x40)
#endif

/*
 *  File:
 *	hxpends.h
 *  Description:
 *	Interfaces related to get pending status from objects
 *  Interfaces:
 *	IHXPendingStatus:	{00001100-0901-11d1-8B06-00A024406D59}
 */
#ifndef _HXPENDS_H_
DEFINE_GUID_ENUM(IID_IHXPendingStatus,	    0x00001100, 0x901, 0x11d1, 0x8b, 0x6, 0x0,  0xa0, 0x24, 0x40, 0x6d, 0x59)
#endif
/*
 *  File:
 *	ihxpckts.h
 *  Description:
 *	Interfaces related to buffers, packets, streams, etc.
 *  Interfaces:
 *	IID_IHXBuffer:		    {00001300-0901-11d1-8B06-00A024406D59}
 *	IID_IHXPacket:		    {00001301-0901-11d1-8B06-00A024406D59}
 *	IID_IHXRTPPacket	    {0169A731-1ED0-11d4-952B-00902742C923}
 *	IID_IHXRTPPacketInfo	    {0169A731-1ED0-11d4-952B-00902742C923}
 *	IID_IHXValues:		    {00001302-0901-11d1-8B06-00A024406D59}
 *	IID_IHXValuesRemove:	    {00001303-0901-11d1-8B06-00A024406D59}
 *	IID_IHXClientPacket:	    {00001304-0901-11d1-8B06-00A024406D59}
 *	IID_IHXBroadcastDistPktExt:{00001305-0901-11d1-8B06-00A024406D59}
 */
#ifndef _IHXPCKTS_H_
DEFINE_GUID_ENUM(IID_IHXBuffer,		    0x00001300, 0x0901, 0x11d1, 0x8b, 0x06, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59) 
DEFINE_GUID_ENUM(IID_IHXPacket,		    0x00001301, 0x0901, 0x11d1, 0x8b, 0x06, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXRTPPacket,	    0x0169a731, 0x1ed0, 0x11d4, 0x95, 0x2b, 0x0, 0x90, 0x27, 0x42, 0xc9, 0x23)
DEFINE_GUID_ENUM(IID_IHXRTPPacketInfo,	    0xec7d67bb, 0x2e79, 0x49c3, 0xb6, 0x67, 0xba, 0x8a, 0x93, 0x8d, 0xbc, 0xe0)
DEFINE_GUID_ENUM(IID_IHXValues,		    0x00001302, 0x0901, 0x11d1, 0x8b, 0x06, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59) 
DEFINE_GUID_ENUM(IID_IHXValuesRemove,	    0x00001303, 0x0901, 0x11d1, 0x8b, 0x06, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59) 
#endif
/*
 *  File:
 *      hxasm.h
 *  Description:
 *	Interfaces related to abm and back channel support.
 * 
 *  Interfaces:
 *  	IID_IHXBackChannel:	    {00001500-0901-11d1-8B06-00A024406D59}
 *  	IID_IHXASMSource:	    {00001501-0901-11d1-8B06-00A024406D59}
 *  	IID_IHXASMStream:	    {00001502-0901-11d1-8B06-00A024406D59}
 *  	IID_IHXASMStream2:	    {30d39e2c-1e56-11b2-8618-0002b39a94d0}
 *  	IID_IHXASMStreamSink:	    {00001503-0901-11d1-8B06-00A024406D59}
 */
#ifndef _HXASM_H_
DEFINE_GUID_ENUM(IID_IHXBackChannel,	    0x00001500, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXASMSource,		    0x00001501, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXASMStream,		    0x00001502, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXASMStream2,		    0x00001504, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXASMStreamSink,	    0x00001503, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
#endif
/*
 *  File:
 *      hxencod.h
 *  Description:
 *      Interfaces related to superencoders.
 *
 *  Interaces:
 *      IID_IHXEncoderResponse     {00001600-0901-11d1-8B06-00A024406D59}
 *      IID_IHXEncoder             {00001601-0901-11d1-8B06-00A024406D59}
 *      IID_IHXEncoderCompletion   {00001602-0901-11d1-8B06-00A024406D59}
 *      IID_IHXConnectionlessControl
                                    {00001603-0901-11d1-8B06-00A024406D59}
 *      IID_IHXEncoderResponseCompletion
                                    {00001604-0901-11d1-8B06-00A024406D59}
 *      IID_IHXTransportControl    {00001605-0901-11d1-8B06-00A024406D59}
 */
#ifndef _HXENCOD_H_
DEFINE_GUID_ENUM(IID_IHXEncoderResponse, 	0x00001600, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXEncoder,		0x00001601, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXEncoderCompletion,	0x00001602, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXConnectionlessControl,
					0x00001603, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXEncoderResponseCompletion,
					0x00001604, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXTransportControl,	0x00001605, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
#endif

/*
 *  File:
 *      hxbrdcst.h
 *  Description:
 *
 *      RealSystem iQ remote broadcast functionality
 *
 *  Interfaces:
 *
 *    IID_IHXRemoteBroadcastServices:  {8F933081-27B6-11d5-9569-00902742E832}
 *    IID_IHXRemoteBroadcastConfiguration: {8F933083-27B6-11d5-9569-00902742E832}
 *    IID_IHXRemoteBroadcastConfigurationResponse: {67C1BA10-39BC-11d5-956A-00902742E832}
 */

#ifndef _HXBRDCST_H_
DEFINE_GUID_ENUM(IID_IHXRemoteBroadcastServices, 0x8f933081, 0x27b6, 0x11d5, 0x95, 0x69, 0x0, 0x90, 0x27, 0x42, 0xe8, 0x32)
DEFINE_GUID_ENUM(IID_IHXRemoteBroadcastConfiguration, 0x8f933083, 0x27b6, 0x11d5, 0x95, 0x69, 0x0, 0x90, 0x27, 0x42, 0xe8, 0x32)
DEFINE_GUID_ENUM(IID_IHXRemoteBroadcastConfigurationResponse, 0x67c1ba10, 0x39bc, 0x11d5, 0x95, 0x6a, 0x0, 0x90, 0x27, 0x42, 0xe8, 0x32)
#endif

/*
 *  File:
 *      hxauth.h
 *  Description:
 *      Password handling API
 *  Interfaces:
 *      IID_IHXPassword            {00001700-0901-11d1-8B06-00A024406D59}
 */

/*
 * 000017**-0901-11d1-8B06-00A024406D59 is reserved for interfaces in hxauth.h (below)
 */

/*
 *  File:
 *      hxauth.h
 *  Description:
 *      Authentication API
 *  Interfaces:
 *      IID_IHXAuthenticator	      {00001800-0901-11d1-8B06-00A024406D59}
 *      IID_IHXAuthenticatorResponse {00001801-0901-11d1-8B06-00A024406D59}
 *      IID_IHXAuthenticatorRequest  {00001802-0901-11d1-8B06-00A024406D59}
 *	IID_IHXPassword	      {00001700-0901-11d1-8B06-00A024406D59}
 *      IID_IHXAuthenticationManager {00001A00-0901-11d1-8B06-00A024406D59}
 *      IID_IHXAuthenticationManager2
 *                                    {34e171d2-a8f0-4832-bc7d-06dfe3ae58fd}
 *      IID_IHXAuthenticationManagerResponse 
 *                                    {00001A01-0901-11d1-8B06-00A024406D59}
 */
#ifndef _HXAUTH_H_
DEFINE_GUID_ENUM(IID_IHXAuthenticator, 	    0x00001800, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXAuthenticatorResponse,  0x00001801, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXAuthenticatorRequest,   0x00001802, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXPassword, 		    0x00001700, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXAuthenticationManager,	    0x00001a00, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXAuthenticationManager2,         0x34e171d2, 0xa8f0, 0x4832, 0xbc, 0x7d, 0x06, 0xdf, 0xe3, 0xae, 0x58, 0xfd)
DEFINE_GUID_ENUM(IID_IHXAuthenticationManagerResponse,  0x00001a01, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
#endif
/*
 *  File:
 *      hxsdesc.h
 *  Description:
 *      Stream description API
 *  Interfaces:
 *      IID_IHXStreamDescription           {00001900-0901-11d1-8B06-00A024406D59}
 *      IID_IHXRTPPayloadInfo              {00001901-0901-11d1-8B06-00A024406D59}
 *      IID_IHXStreamDescriptionSettings   {00001902-0901-11d1-8B06-00A024406D59}
 */
#ifndef _HXSDESC_
DEFINE_GUID_ENUM(IID_IHXStreamDescription,          0x00001900, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXRTPPayloadInfo,             0x00001901, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXStreamDescriptionSettings,  0x00001902, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
#endif
/*
 * 00001A**-0901-11d1-8B06-00A024406D59 is reserved for interfaces in hxauth.h (above)
 */

/*
 *  File:
 *      hxlvtxt.h
 *  Description:
 *      Interfaces related to live text superencoder.
 *
 *  Interaces:
 *      IID_IHXLiveText         {00001b00-0901-11d1-8B06-00A024406D59}
 *      IID_IHXLiveText2        {00001b01-0901-11d1-8B06-00A024406D59}
 */
#ifndef _HXLVTXT_H_
DEFINE_GUID_ENUM(IID_IHXLiveText,	0x00001b00, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXLiveText2,	0x00001b01, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
#endif
/*
 *  File:
 *      hxcfg.h
 *  Description:
 *      Interfaces used by server configuration tools.
 *
 *  Interfaces:
 *      IID_IHXConfigFile	{00001c00-0901-11d1-8B06-00A024406D59}
 *	IID_IHXRegConfig	{00001c01-0901-11d1-8B06-00A024406D59}
 *
 */
#ifndef _HXCFG_H_
DEFINE_GUID_ENUM(IID_IHXConfigFile, 0x00001c00, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 
	 		0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXRegConfig, 0x00001c01, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 
				0xa0, 0x24, 0x40, 0x6d, 0x59)
#endif

/*
 *  File:
 *      rmappv.h
 *  Description:
 *      Interfaces related to Pay Per View Database Plugins
 *  Interfaces:
 *      IID_IHXPPVDatabase {00001d00-0901-11d1-8B06-00A024406D59}
 */
DEFINE_GUID_ENUM(IID_IHXPPVDatabase,  
			0x00001d00, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)


/*
 *  00001e**-0901-11d1-8B06-00A024406D59 is reserved for an interface which
 *  has been deprecated.
 */

/*
 *  File:
 *      rmacmenu.h
 *  Description:
 *      Interfaces used by renderers for context menus.
 *
 *  Interfaces:
 *  IID_IHXContextMenu		    {00001f00-0901-11d1-8B06-00A024406D59}
 *  IID_IHXContextMenuResponse	    {00001f01-0901-11d1-8B06-00A024406D59}
 */
#ifndef _HXCMENU_H_
DEFINE_GUID_ENUM(IID_IHXContextMenu, 0x00001f00, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 
			0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXContextMenuResponse, 0x00001f01, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 
			0xa0, 0x24, 0x40, 0x6d, 0x59)

#endif
/*
 *  File:
 *      hxphook.h
 *  Description:
 *      Interfaces used by the top level client. client core and renderer to 
 *	support Selective Record.
 *
 *  Interfaces:
 *      IID_IHXPacketHook		    {00002000-0901-11d1-8B06-00A024406D59}
 *	IID_IHXPacketHookManager	    {00002001-0901-11d1-8B06-00A024406D59}
 *	IID_IHXPacketHookHelper	    {00002002-0901-11d1-8B06-00A024406D59}
 *	IID_IHXPacketHookHelperResponse    {00002003-0901-11d1-8B06-00A024406D59}
 */

#ifndef _HXPHOOK_H_

DEFINE_GUID_ENUM(IID_IHXPacketHook,			0x00002000, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXPacketHookManager,		0x00002001, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXPacketHookHelper,		0x00002002, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXPacketHookHelperResponse,	0x00002003, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)

#endif

/*
 *  File:
 *      hxpsink.h
 *  Description:
 *      Interfaces used by the top level client or renderers to determine
 *	that a player has been created or closed.
 *
 *  Interfaces:
 *      IID_IHXPlayerCreationSink	    {00002100-0901-11d1-8B06-00A024406D59}
 *	IID_IHXPlayerSinkControl    	    {00002101-0901-11d1-8B06-00A024406D59}
 */
DEFINE_GUID_ENUM(IID_IHXPlayerCreationSink,		0x00002100, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXPlayerSinkControl, 		0x00002101, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)

/*
 *  File:
 *      hxvsurf.h
 *  Description:
 *      Interface used by renderers to blt data to the screen (when in
 *	full screen mode).
 *
 *  Interfaces:
 *      IID_IHXVideoSurface	    	    {00002200-0901-11d1-8B06-00A024406D59}
 */
DEFINE_GUID_ENUM(IID_IHXVideoSurface, 	0x00002200, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXVideoHookSink,	0x00002201, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXVideoHook,		0x00002202, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXVideoSurface2,      0x00002203, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXRenderTimeLine,     0x00002204, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXSubRectVideoSurface, 	0x00002205, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)



/*
 *  File:
 *      hxgroup.h
 *  Description:
 *      Client side Group related interfaces
 *
 *  Interfaces:
 *	IID_IHXGroup			{00002400-0901-11d1-8B06-00A024406D59}
 *	IID_IHXGroupManager		{00002401-0901-11d1-8B06-00A024406D59}
 *	IID_IHXGroupSink		{00002402-0901-11d1-8B06-00A024406D59}
 *	IID_IHXTrack		{00002404-0901-11d1-8B06-00A024406D59}
 */
DEFINE_GUID_ENUM(IID_IHXGroup,		0x00002400, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXGroupManager,	0x00002401, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXGroupSink,		0x00002402, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXTrack,		0x00002404, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXTrackSink,		0x00002405, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXPrefetchSink,	0x00002406, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXGroupSink2,		0x00002407, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXPrefetch,		0x00002408, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)

/*
 *  File:
 *      hxupgrd.h
 *  Description:
 *      Interfaces used by player for auto-upgrade.
 *
 *  Interfaces:
 *  IID_IHXUpgradeCollection    {00002500-0901-11d1-8B06-00A024406D59}
 *  IID_IHXUpgradeHandler	 {00002501-0901-11d1-8B06-00A024406D59}
 */
DEFINE_GUID_ENUM(IID_IHXUpgradeCollection,
                        0x00002500, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXUpgradeHandler,
                        0x00002501, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)

DEFINE_GUID_ENUM(IID_IHXUpgradeCollection2,
                        0x00002503, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)

/*
 *  File:
 *      hxallow.h
 *  Description:
 *      Interfaces related to Allowance plugins
 *  Interfaces:
 *      IID_IHXPlayerConnectionAdviseSink {00002600-0901-11d1-8B06-00A024406D59}
 *      IID_IHXPlayerConnectionResponse   {00002601-0901-11d1-8B06-00A024406D59}
 *      IID_IHXPlayerController           {00002602-0901-11d1-8B06-00A024406D59}
 *      IID_IHXPlayerConnectionAdviseSinkManager
                                           {00002603-0901-11d1-8B06-00A024406D59}
 *      IID_IHXPlayerConnectionAdviseEvents
                                          {8fe78da6-a828-11d7-939c-00601df0ce4c}
 *      IID_IHXProxyConnectionAdviseSink  {00002604-0901-11d1-8B06-00A024406D59}
 *      IID_IHXProxyConnectionResponse    {00002605-0901-11d1-8B06-00A024406D59}
 *      IID_IHXProxyController            {00002605-0901-11d1-8B06-00A024406D59}
 *      IID_IHXPlayerControllerProxyRedirect {00002607-0901-11d1-8B06-00A024406D59}
 *      IID_IHXMidBoxNotify               {f8c5dcaf-9a5f-4d1b-a061-22fa0d038848}
 */
DEFINE_GUID_ENUM(IID_IHXPlayerConnectionAdviseSink,  
			0x00002600, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXPlayerConnectionResponse,    
			0x00002601, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXPlayerController,            
			0x00002602, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXPlayerConnectionAdviseSinkManager,            
			0x00002603, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXPlayerConnectionAdviseEvents,
			0x8fe78da6, 0xa828, 0x11d7, 0x93, 0x9c, 0x0, 0x60, 0x1d, 0xf0, 0xce, 0x4c)

DEFINE_GUID_ENUM(IID_IHXProxyConnectionAdviseSink,  
			0x00002604, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXProxyConnectionResponse,  
			0x00002605, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXProxyController,  
			0x00002606, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXPlayerControllerProxyRedirect, 0x00002607, 0x901, 0x11d1,
            0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXMidBoxNotify, 0xf8c5dcaf, 0x9a5f, 0x4d1b,
	    0xa0, 0x61, 0x22, 0xfa, 0x0d, 0x03, 0x88, 0x48)

/*
 *  File:
 *      rmaaconf.h
 *  Description:
 *      Interfaces used by the top level client. client core to 
 *	support Auto. Transport Configuration
 *
 *  Interfaces:
 *	IID_IHXAutoConfig		    {00002700-0901-11d1-8B06-00A024406D59}
 *	IID_IHXAutoConfigResponse	    {00002701-0901-11d1-8B06-00A024406D59}
 */

DEFINE_GUID_ENUM(IID_IHXAutoConfig,			0x00002700, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXAutoConfigResponse,		0x00002701, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)

/*
 *  File:
 *      hxauthn.h
 *  Description:
 *      Interfaces used to validate a users access to content.
 *
 *  Interfaces:
 *	IID_IHXCredRequestResponse,	{00002800-0901-11d1-8B06-00A024406D59}
 *	IID_IHXCredRequest,		{00002801-0901-11d1-8B06-00A024406D59}
 *	IID_IHXClientAuthResponse,	{00002802-0901-11d1-8B06-00A024406D59}
 *	IID_IHXClientAuthConversation,	{00002803-0901-11d1-8B06-00A024406D59}
 *	IID_IHXServerAuthResponse,	{00002804-0901-11d1-8B06-00A024406D59}
 *	IID_IHXServerAuthConversation,	{00002805-0901-11d1-8B06-00A024406D59}
 *	IID_IHXUserContext,		{00002806-0901-11d1-8B06-00A024406D59}
 *	IID_IHXUserProperties,		{00002807-0901-11d1-8B06-00A024406D59}
 *	IID_IHXUserImpersonation,	{00002808-0901-11d1-8B06-00A024406D59}
 *	IID_IHXUserDB,			{00002809-0901-11d1-8B06-00A024406D59}
 *	IID_IHXChallengeResponse,	{0000280A-0901-11d1-8B06-00A024406D59}
 *	IID_IHXChallenge,		{0000280B-0901-11d1-8B06-00A024406D59}
 */

DEFINE_GUID_ENUM(IID_IHXCredRequestResponse,    0x00002800, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXCredRequest,	    0x00002801, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXClientAuthResponse,	    0x00002802, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXClientAuthConversation, 0x00002803, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXServerAuthResponse,	    0x00002804, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXServerAuthConversation, 0x00002805, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXUserContext,	    0x00002806, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXUserProperties,	    0x00002807, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXUserImpersonation,	    0x00002808, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXChallengeResponse,	    0x00002809, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXChallenge,		    0x0000280A, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)


/*
 * File:
 *    hxplgns.h
 *
 * Description:
 *    Interfaces for Plugins:
 *	IHXObjectConfiguration	- Consistant configuration.
 *	IHXPluginProperties	- Consistant property retrival.
 *
 * Interfaces:
 *    IID_IHXObjectConfiguration:  {00002900-0901-11d1-8B06-00A024406D59}
 *    IID_IHXPluginProperties:	    {00002901-0901-11d1-8B06-00A024406D59}
 */
DEFINE_GUID_ENUM(IID_IHXObjectConfiguration,    0x00002900, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXPluginProperties,	    0x00002901, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)

/*
 * File:
 *    hxdb.h
 *
 * Description:
 *    Interfaces for Plugins:
 *	IHXDatabaseManager			- Creates Configured Database Instances
 *	IHXAuthenticationDBManagerResponse	- Provides Callbacks for IHXAuthenticationDBManager
 *	IHXAuthenticationDBManager		- Functions to add and remove users from a database
 *	IHXAsyncEnumAuthenticationDBResponse	- Provides Callbacks for IHXAsyncEnumAuthenticationDB
 *	IHXAsyncEnumAuthenticationDB		- Functions to enumerate the list of users in a database
 *	IHXAuthenticationDBAccessResponse	- Provides Callbacks for IHXAuthenticationDBAccess
 *	IHXAuthenticationDBAccess		- Functions to access a users info in the database
 *	IHXGUIDDBManagerResponse		- Provides Callbacks for IHXGUIDDBManager
 *	IHXGUIDDBManager			- Functions to add and remove GUID's from a database
 *	IHXPPVDBManagerResponse		- Provides Callbacks for IHXPPVDBManager
 *	IHXPPVDBManager			- Functions to add, remove, and adjust a user's permissions from a database
 *	IHXRedirectDBManagerResponse		- Provides Callbacks for IHXRedirectDBManager
 *	IHXRedirectDBManager			- Functions to add and remove URL Redirects from a database
 *	IHXRegistrationLoggerResponse		- Provides Callbacks for IHXRegistrationLogger
 *	IHXRegistrationLogger			- Functions to Log registration Activity.
 *
 * Interfaces:
 *    IID_IHXDatabaseManager:			{00002A00-0901-11d1-8B06-00A024406D59}
 *    IID_IHXAuthenticationDBManagerResponse:  {00002A01-0901-11d1-8B06-00A024406D59}
 *    IID_IHXAuthenticationDBManager:		{00002A02-0901-11d1-8B06-00A024406D59}
 *    IID_IHXAsyncEnumAuthenticationDBResponse:{00002A03-0901-11d1-8B06-00A024406D59}
 *    IID_IHXAsyncEnumAuthenticationDB:	{00002A04-0901-11d1-8B06-00A024406D59}
 *    IID_IHXAuthenticationDBAccessResponse:	{00002A05-0901-11d1-8B06-00A024406D59}
 *    IID_IHXAuthenticationDBAccess:		{00002A06-0901-11d1-8B06-00A024406D59}
 *    IID_IHXGUIDDBManagerResponse:		{00002A07-0901-11d1-8B06-00A024406D59}
 *    IID_IHXGUIDDBManager:			{00002A08-0901-11d1-8B06-00A024406D59}
 *    IID_IHXPPVDBManagerResponse:		{00002A09-0901-11d1-8B06-00A024406D59}
 *    IID_IHXPPVDBManager:			{00002A0A-0901-11d1-8B06-00A024406D59}
 *    IID_IHXRedirectDBManagerResponse:	{00002A0B-0901-11d1-8B06-00A024406D59}
 *    IID_IHXRedirectDBManager:		{00002A0C-0901-11d1-8B06-00A024406D59}
 *    IID_IHXRegistrationLoggerResponse:	{00002A0D-0901-11d1-8B06-00A024406D59}
 *    IID_IHXRegistrationLogger:		{00002A0E-0901-11d1-8B06-00A024406D59}
 */
DEFINE_GUID_ENUM(IID_IHXDatabaseManager,			    0x00002A00, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXAuthenticationDBManagerResponse,	    0x00002A01, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXAuthenticationDBManager,		    0x00002A02, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXAsyncEnumAuthenticationDBResponse,	    0x00002A03, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXAsyncEnumAuthenticationDB,		    0x00002A04, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXAuthenticationDBAccessResponse,	    0x00002A05, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXAuthenticationDBAccess,		    0x00002A06, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXGUIDDBManagerResponse,		    0x00002A07, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXGUIDDBManager,			    0x00002A08, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXPPVDBManagerResponse,		    0x00002A09, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXPPVDBManager,			    0x00002A0A, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXRedirectDBManagerResponse,		    0x00002A0B, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXRedirectDBManager,			    0x00002A0C, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXRegistrationLoggerResponse,		    0x00002A0D, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXRegistrationLogger,			    0x00002A0E, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)


/*
 * File:
 *	hxxmltg.h
 *
 * Description:
 *  Interfaces for Plugins:
 *	IHXXMLTagHandler: Interface for registering for a specific tag
 *	and providing an IHXXMLTagObject to tagfsys.
 *	(Works like IHXFileSystemObject)
 *
 *	IHXXMLTagObject: Interface for receiving the contents of a tag
 *	for which the creating IHXXMLTagHandler has registerd.
 *
 *	IHXXMLTagObjectResponse: Interface for IHXXMLTagObject to return
 *	the replacement for the tag.  This is implemented by tagfsys.
 *
 *
 * Interfaces:
 *	IID_IHXXMLTagObjectResponse: {00002C02-0901-11d1-8B06-00A024406D59}
 *	IID_IHXXMLTagHandler:	{00002C03-0901-11d1-8B06-00A024406D59}
 *	IID_IHXXMLTagObject:	{00002C04-0901-11d1-8B06-00A024406D59}
 */
#ifndef _HXXMLTG_H
DEFINE_GUID_ENUM(IID_IHXXMLTagObjectResponse, 0x00002C02, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXXMLTagHandler, 0x00002C03, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXXMLTagObject, 0x00002C04, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
#endif


/*
 * File:
 *    hxcache.h
 *
 * Description:
 *    Interfaces for caching services:
 *	IHXCache				- Creates IHXCacheFiles
 *	IHXCacheResponse			- Response object for IHXCache
 *	IHXCacheFile				- Persistant store object for caching
 *	IHXCacheFileResponse			- Response object for IHXCacheFile
 *
 *
 * Interfaces:
 *    IID_IHXCache:				{00002E00-0901-11d1-8B06-00A024406D59}
 *    IID_IHXCacheResponse:			{00002E01-0901-11d1-8B06-00A024406D59}
 *    IID_IHXCacheFile:			{00002E02-0901-11d1-8B06-00A024406D59}
 *    IID_IHXCacheFileResponse:		{00002E03-0901-11d1-8B06-00A024406D59}
 *    IID_IHXMIIFetch:				{00002E04-0901-11d1-8B06-00A024406D59}
 *    IID_IHXFIFOCache:			{00002E05-0901-11d1-8B06-00A024406D59}
 */

DEFINE_GUID_ENUM(IID_IHXCache,			0x00002E00, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXCacheResponse,		0x00002E01, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXCacheFile,			0x00002E02, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXCacheFileResponse,		0x00002E03, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXMIIFetch,			0x00002E04, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXFIFOCache,			0x00002E05, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)

/*
 *  File: intrpm.h
 *
 *  IID_IHXInterPluginMessenger:	{00003000-0901-11d1-8B06-00A024406D59}
 */
DEFINE_GUID_ENUM(IID_IHXInterPluginMessenger,	0x00003000, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)

/*
 *  File: intrpm.h
 *
 *  IID_IHXInterPluginMessenger2:	{00003001-0901-11d1-8B06-00A024406D59}
 */
DEFINE_GUID_ENUM(IID_IHXInterPluginMessenger2,	0x00003001, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)

/*
 *  File: hxvalue.h
 *
 *  DEPRECATED:			{00003100-0901-11d1-8B06-00A024406D59}
 *  DEPRECATED:			{00003101-0901-11d1-8B06-00A024406D59}
 *  DEPRECATED:			{00003102-0901-11d1-8B06-00A024406D59}
 *  DEPRECATED:			{00003103-0901-11d1-8B06-00A024406D59}
 *  DEPRECATED:			{00003104-0901-11d1-8B06-00A024406D59}
 *  DEPRECATED:			{00003105-0901-11d1-8B06-00A024406D59}
 *  DEPRECATED:			{00003106-0901-11d1-8B06-00A024406D59}
 *  DEPRECATED:			{00003107-0901-11d1-8B06-00A024406D59}
 *
 *  IID_IHXKeyValueList:	{00003108-0901-11d1-8B06-00A024406D59}
 *  IID_IHXKeyValueListIter:	{00003109-0901-11d1-8B06-00A024406D59}
 *  IID_IHXKeyValueListIterOneKey: {00003110-0901-11d1-8B06-00A024406D59}
 *  IID_IHXOptions:		{00003111-0901-11d1-8B06-00A024406D59}
 */
#ifndef _HXVALUE_H_
/* DEPRECATED 3100 - 3107 */
DEFINE_GUID_ENUM(IID_IHXKeyValueList,	0x00003108, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXKeyValueListIter,	0x00003109, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXKeyValueListIterOneKey,	0x00003110, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXOptions,		0x00003111, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
#endif

/*
 * File:
 *    ihxcookies.h
 *
 * Description:
 *    Interfaces for Plugins:
 *	IHXCookies		- Cookie database management APIs
 *	IHXCookiesHelper	- Cookie output helper APIs
 *
 * Interfaces:
 *    IID_IHXCookies:				{00003200-0901-11d1-8B06-00A024406D59}
 *    IID_IHXCookiesHelper:			{00003201-0901-11d1-8B06-00A024406D59}
 */
DEFINE_GUID_ENUM(IID_IHXCookies,			0x00003200, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXCookiesHelper,		0x00003201, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)

/*
 *  File: addrpool.h
 *
 *  IID_IHXMulticastAddressPool:	{00003300-0901-11d1-8B06-00A024406D59}
 */
DEFINE_GUID_ENUM(IID_IHXMulticastAddressPool,	0x00003300, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)

/*
 *  File: sapmgr.h
 *
 *  IID_IHXSapManager:	{00003400-0901-11d1-8B06-00A024406D59}
 */
DEFINE_GUID_ENUM(IID_IHXSapManager,	0x00003400, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)


/*
 * File:
 *    hxvsrc.h
 *
 * Description:
 *    Interfaces for Plugins:
 *	IHXFileViewSource		- Interface so file formats can support view source.
 *	IHXFileViewSourceResponse	- Response interface.
 *
 * Interfaces:
 *    IID_IHXFileViewSource:				{00003500-0901-11d1-8B06-00A024406D59}
 *    IID_IHXFileViewSourceResponse:			{00003501-0901-11d1-8B06-00A024406D59}
 *    IID_IHXViewSourceCommand:			{00003504-0901-11d1-8B06-00A024406D59}
 *    IID_IHXViewSourceURLResponse			{00003505-0901-11d1-8B06-00A024406D59}
 */
#ifndef _HXVSRC_H_
DEFINE_GUID_ENUM(IID_IHXFileViewSource,		0x00003500, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXFileViewSourceResponse,	0x00003501, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXViewSourceCommand,		0x00003504, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXViewSourceURLResponse,	0x00003505, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)


#endif

/*
 *  File:
 *	hxdllaccess.h
 *  Description:
 *	Interfaces to Dll Access Service
 *  Interfaces:
 *	IID_IHXDllAccess:	    {D5A71AA1-A6ED-479f-9FC6-F06B99142691}
 */
#ifndef _HXDLLACCESS_H_
DEFINE_GUID_ENUM(IID_IHXDllAccess,  0xd5a71aa1, 0xa6ed, 0x479f, 0x9f, 0xc6, 0xf0, 0x6b, 0x99, 0x14, 0x26, 0x91) 
#endif	// _HXDLLACCESS_H_


/* File:
 *	hxdtcvt.h
 *
 * Description
 *  IHXDataConvertSystemObject - RMA Stream data conversion creator
 *  IHXDataConvert - RMA Stream data conversion
 *  IHXDataConvertResponse - response for above
 *  IHXDataRevert - RMA Stream data reversion
 *  IHXDataRevertResponse - response for above
 */
DEFINE_GUID_ENUM(IID_IHXDataConvertSystemObject,
    0x00003900, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXDataConvert,
    0x00003901, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXDataConvertResponse,
    0x00003902, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXDataRevert,
    0x00003903, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXDataRevertResponse,
    0x00003904, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)

/* File:
 *	hxvport.h
 *
 * Description
 *  IHXViewPortManager - RMA ViewportManager
 *  IHXViewPort - RMA Viewport
 *  IHXViewPortSink - RMA Viewport sink
 *  IHXViewPortSupplier - RMA Viewport supplier
 */
DEFINE_GUID_ENUM(IID_IHXViewPortManager,
    0x00004000, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXViewPort,
    0x00004001, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXViewPortSink,
    0x00004002, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
DEFINE_GUID_ENUM(IID_IHXViewPortSupplier,
    0x00004003, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)

/* File:
 *	hxmmrkr.h
 *
 * Description
 *  IHXMediaMarkerManager - RMA Media Marker Manager
 *  IHXMediaMarkerSink    - RMA Media Marker Sink
 */
DEFINE_GUID_ENUM(IID_IHXMediaMarkerManager,
    0x46679d62, 0xf7ac, 0x4b0e, 0x80, 0x0, 0xf4, 0xee, 0x90, 0xf7, 0x85, 0xb1)
DEFINE_GUID_ENUM(IID_IHXMediaMarkerSink,
    0xa4643c85, 0x5b52, 0x4b07, 0xa7, 0x61, 0x32, 0xcf, 0xb2, 0xf2, 0x84, 0xfe)

/*
 * File:
 *       hxinter.h
 *
 * Description
 *  IHXEventManager - RMA Inter-datatype event manager
 *  IHXEventSink    - RMA Inter-datatype event sink
 *
 */
DEFINE_GUID_ENUM(IID_IHXEventManager,
    0xf932b582, 0x517, 0x4ca4, 0x84, 0x4c, 0x26, 0xa4, 0xe8, 0xe9, 0x69, 0x83)
DEFINE_GUID_ENUM(IID_IHXEventSink,
    0x76cf54bc, 0x9fce, 0x45e7, 0x90, 0xd1, 0x3, 0x46, 0x5, 0xf8, 0xdd, 0x14)

/*
 *  File:
 *	hxslta.h
 *
 *  Description:
 *
 *    IHXSLTA - RMA version of slta.  Simulates a live stream from file format.
 *
 *    IHXSltaEvent - Allows events to be sent in an SLTA stream
 */
DEFINE_GUID_ENUM(IID_IHXSLTA,
    0x00000D00, 0xb4c8, 0x11d0, 0x99, 0x95, 0x0, 0xa0, 0x24, 0x8d, 0xa5, 0xf0)

DEFINE_GUID_ENUM(IID_IHXSltaEvent,
    0x00000D01, 0xb4c8, 0x11d0, 0x99, 0x95, 0x0, 0xa0, 0x24, 0x8d, 0xa5, 0xf0)



/*
 *  File:
 *	ihxcookies2.h
 *
 *  Description:
 *
 *    IHXCookies2 - Lets you get expired cookies
 */
#ifndef _ihxcookies2_h_
DEFINE_GUID_ENUM(IID_IHXCookies2, 0x5634537f, 0x162f, 0x41b0, 0x93, 0xfc, 0x6e, 0xf, 0x77, 0x10, 0x71, 0x81)
#endif


/*
 *  File:
 *	rmasm2sm.h
 *
 *  Description:
 *
 *    IHXSmilToSmilRendererCommunicator - Lets you communicate from SMIL 1.0
 *    renderer to SMIL 2.0 renderer that SMIL 2 stream is being proxied.
 */
#ifndef _HXSM2SM_H_
#endif

/*
 *  File:
 *	hxproductversion.h
 *
 *  Description:
 *
 *      Provide version information regarding the executable core.
 */
DEFINE_GUID_ENUM(IID_IHXProductVersion, 0xA0991C6E, 0xD51B, 0x4549, 
	    0xA0, 0xD7, 0xBE, 0xD5, 0xED, 0x18, 0xF1, 0xC7)


/*
 *  File:
 *	progsink.h
 *
 *  Description:
 *
 *    Enables subscription for notification on the progress of merging files.
 */
#ifndef _PROGSINK_H_

DEFINE_GUID_ENUM(IID_IHXProgressSink, 
    0x6f8c5fb0, 0xc1d3, 0x11d2, 0x87, 0x1b, 0x0, 0xc0, 0xf0, 0x31, 0xc2, 0x66)

DEFINE_GUID_ENUM(IID_IHXProgressSinkControl, 
    0xdc464800, 0xc1d3, 0x11d2, 0x87, 0x1b, 0x0, 0xc0, 0xf0, 0x31, 0xc2, 0x66)

#endif

/*
 *  File:
 *	rmflsnk.h
 *
 *  Description:
 *
 *    Enables receipt of header and packets from the rmeditor, prior to writing to file.
 */

#ifndef _RMFLSNK_H_

DEFINE_GUID_ENUM(IID_IHXRMFileSink,
	    0x19137680, 0x377b, 0x11d2, 0xa1, 0xc4, 0x0, 0x60, 0x8, 0x3b, 0xe5, 0x63)

DEFINE_GUID_ENUM(IID_IHXRMFileSinkControl, 
	    0xcb88b91, 0xa444, 0x11d2, 0x87, 0x92, 0x0, 0xc0, 0xf0, 0x31, 0x93, 0x8b)

#endif

/*
 *  File:
 *	hxqos.h
 *
 *  Description:
 *
 *    Server QoS subsystem profile selection, and QoS Signalling mechanism
 */
#ifndef _HX_QOS_H_

DEFINE_GUID_ENUM(IID_IHXQoSProfileSelector, 
                 0x75db043b, 0xc5a8, 0x49b2, 0x8d, 0x3f, 0x8c, 0xf9, 0x9f, 0x9e, 0x64, 0x44)

DEFINE_GUID_ENUM(IID_IHXQoSSignalSourceResponse, 
                 0xb6154b09, 0xbbc3, 0x4239, 0xbe, 0x8b, 0x81, 0x60, 0x7c, 0xa0, 0xbe, 0x9)

DEFINE_GUID_ENUM(IID_IHXQoSSignalSource, 
                 0x42aeddae, 0x3c4a, 0x498c, 0x86, 0x3e, 0xe6, 0xed, 0xee, 0xd4, 0x2, 0xa5)

DEFINE_GUID_ENUM(IID_IHXQoSSignalSink, 
                 0x8b94c9cf, 0x48e2, 0x4384, 0xbc, 0x39, 0x70, 0x1b, 0x92, 0x4f, 0x55, 0x6f)

DEFINE_GUID_ENUM(IID_IHXQoSSignalBus, 
                 0x8003507e, 0x453f, 0x4439, 0xbf, 0x8, 0x7f, 0x8a, 0xe, 0x8, 0x3d, 0x9e)

DEFINE_GUID_ENUM(IID_IHXQoSSignal, 
                 0x32126bdc, 0x74, 0x4f43, 0x8d, 0x2c, 0x65, 0xd7, 0x6d, 0x60, 0xb5, 0xcb)

DEFINE_GUID_ENUM(IID_IHXQoSClassFactory,
                 0xc1316a78, 0x2960, 0x4f5c, 0xa2, 0xa9, 0x46, 0xd9, 0xc9, 0x25, 0xe8, 0x8f)

DEFINE_GUID_ENUM(IID_IHXQoSCongestionControl, 
		 0x99c0a316, 0xfbbc, 0x41a9, 0x96, 0x28, 0xee, 0xcc, 0xcc, 0xf2, 0x20, 0x3f)

DEFINE_GUID_ENUM(IID_IHXQoSCongestionEquation, 
		 0xce97019f, 0x6a3d, 0x4c26, 0x81, 0x55, 0xc8, 0xae, 0xba, 0xdc, 0x77, 0x62)

DEFINE_GUID_ENUM(IID_IHXQoSDiffServConfigurator, 
		 0x5fb79e3a, 0x9bef, 0x4676, 0x89, 0x77, 0x8, 0xff, 0x6b, 0x2d, 0x72, 0x70)

DEFINE_GUID_ENUM(IID_IHXQoSProfileConfigurator,
		 0x75db043b, 0xc5a8, 0x49b2, 0x8d, 0x3f, 0x8c, 0xf9, 0x9f, 0x9e, 0x64, 0x48)

DEFINE_GUID_ENUM(IID_IHXQoSRateShapeAggregator, 
		 0x18496bea, 0xf2a7, 0x45fc, 0xb3, 0x12, 0x88, 0x52, 0x14, 0x11, 0x9a, 0xb2)

DEFINE_GUID_ENUM(IID_IHXQoSRateShaper, 
		 0x2a287694, 0xef37, 0x4266, 0x85, 0x8f, 0xe8, 0x4f, 0xe3, 0x6a, 0xbd, 0x90)

#endif /* _HX_QOS_H_ */

#ifndef _HXQOSSESS_H

DEFINE_GUID_ENUM(IID_IHXQoSClientBufferVerifier, 
                 0x51d547a0, 0xf019, 0x49e8, 0xb4, 0x98, 0x50, 0xdf, 0x22, 0xf7, 0xeb, 0x6b)

DEFINE_GUID_ENUM(IID_IHXQoSRateManager, 
                 0x8fce6b44, 0x6067, 0x4060, 0x86, 0x75, 0xd8, 0xb5, 0x6d, 0x5, 0x95, 0x92)

DEFINE_GUID_ENUM(IID_IHXClientBufferInfo, 
                 0xa7a1ab2, 0x6e3e, 0x4ed4, 0x80, 0xf, 0x97, 0xd5, 0x4e, 0x67, 0xee, 0x3c)
#endif

#ifndef _HXQOSBUFFERUPDATE_H_
DEFINE_GUID_ENUM(IID_IHXBufferDepthUpdate, 
                 0xbdeaf826, 0x1cd5, 0x4200, 0xb1, 0xb2, 0x48, 0x53, 0x9d, 0xdf, 0xd4, 0x58)
#endif

#ifndef _HXPCKTFLWCTRL_H_
DEFINE_GUID_ENUM(IID_IHXPacketFlowControl, 
                 0x00000130, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)

#endif

/*
 * Server-specific IID's required for capability exchange
 */

#ifndef _HX_CLIENT_PROFILE_H_
DEFINE_GUID_ENUM(IID_IHXClientProfileManager,
                 0x00004400, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)

DEFINE_GUID_ENUM(IID_IHXClientProfileManagerResponse,
                 0x00004401, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)

DEFINE_GUID_ENUM(IID_IHXClientProfileInfo,
                 0x00004402, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)

DEFINE_GUID_ENUM(IID_IHXClientProfile,
                 0x00004403, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)

DEFINE_GUID_ENUM(IID_IHXCPAttribute, 
                 0x00004404, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
#endif

#ifndef _HX_PSS_PROFILE_H
DEFINE_GUID_ENUM(IID_IHXPSSProfileData,
                 0x00004410, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)

DEFINE_GUID_ENUM(IID_IHXPSSPTAgent,
                 0x00004411, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59) 

DEFINE_GUID_ENUM(IID_IHXPSSPTAgentResponse,
                 0x00004412, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
#endif

#ifndef _HXRDFPARSER_H_
DEFINE_GUID_ENUM(IID_IHXRDFParser,
                 0x00004420, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)

DEFINE_GUID_ENUM(IID_IHXRDFGraph,
                 0x00004421, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)

DEFINE_GUID_ENUM(IID_IHXRDFGraphNode, 
                 0x00004422, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)

DEFINE_GUID_ENUM(IID_IHXRDFGraphEdge, 
                 0x00004423, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
#endif

#ifndef _HXPROFILECACHE_H_
DEFINE_GUID_ENUM(IID_IHXProfileCache, 
                 0x00004430, 0x901, 0x11d1, 0x8b, 0x6, 0x0, 0xa0, 0x24, 0x40, 0x6d, 0x59)
#endif

#ifndef _ISIFS_H_
/* file server/engine/inputsource/pub/isifs.h */
DEFINE_GUID_ENUM(IID_IHXRateDescription, 
    0x7499aaa3, 0x5304, 0x426e, 0x99, 0xfd, 0x37, 0xef, 0x21, 0x08, 0xd0, 0x8f)
DEFINE_GUID_ENUM(IID_IHXRateDescManager, 
    0x8467996c, 0x9097, 0x4721, 0x9d, 0x4d, 0xd8, 0xa6, 0xd4, 0xbb, 0x03, 0x03)
DEFINE_GUID_ENUM(IID_IHXRateDescResponse, 
    0x1e8e5cb1, 0x36ee, 0x4209, 0x9d, 0xcc, 0x4b, 0x66, 0x1f, 0x7b, 0xaa, 0x59)
#endif

#ifndef _ISPIFS_H_
/* file server/engine/inputsource/pub/ispifs.h */
DEFINE_GUID_ENUM(IID_IHXSyncHeaderSource, 
    0x5e5ed607, 0x79f0, 0x4b8d, 0xa0, 0xf6, 0x70, 0xd6, 0x57, 0x8d, 0x63, 0x99)
#endif    

#endif /* _HXIIDS_H_ */

