
import os
import re
import sys

from dirwalker import DirWalker

def IsUmakeFile(filepath, opts={}):
    if opts.has_key('verbose'): print "# IsUmakeFile(%s)" % filepath
    f = os.path.basename(filepath)

    fileMatchRE = re.compile(r'([uU]makefil|.*\.pcf)$')
    fileNoMatchRE = re.compile(r'([mM]akefile|Entries|README.*|Repository|Root|Tag|.*\.([achHio]|cpp?|CPP?|dep|dll|in|lib|mak|obj|orig.*|pyc?|rc|so[\.0-9]*|upp|ver)|.*\~)$')
    contentSearchRE = re.compile(r'(project\.|common_(includes|libraries|srcs)|MultiTarget)',
                                 re.DOTALL)
        
    bUmakeFile = 0
    if not os.path.isfile(filepath):
        if opts.has_key('verbose'): print "#...is not a regular file"
    elif fileMatchRE.match(f):
        if opts.has_key('verbose'): print "#...matched filename"
        bUmakeFile = 1
    elif fileNoMatchRE.match(f):
        if opts.has_key('verbose'): print "#...no-matched filename"
    else:
        file = None
        try: file = open(filepath)
        except: print "# WARNING: Error opening %s" % filepath

        m = None
        if file:
            # ought to be able to find something in 1st 4K
            fileStr = file.read(4096)
            file.close()
            
            m = contentSearchRE.search(fileStr)

            if opts.has_key('verbose'):
                if m: print "#...matched on content scan"
                else: print "#...no-matched on content scan"
        if m: bUmakeFile = 1

    return bUmakeFile
