#! /usr/bin/python
#
# This script is supposed to (basically) allow for going through a source
# directory and a target directory and summarize where files moved to in
# going from source to target directory.  It can also scan the target
# directory for "duplicate" filenames (files with the same base name, but
# in different directories).
#
# See the usage() function below for latest usage instructions.
#

import fnmatch
import os

debug = 0

class DirWalker:
    baseDir = ""
    subDir = ""
    depth = 0

    def __init__(self):
        self.baseDir = ""
        self.baseFile = ""
        self.subDir = ""
        self.depth = 0
    
    def Walk(self, dir):
        files = []
        dirs = []

        if os.path.isfile(dir):
            self.baseFile = dir
            self.baseDir = os.path.dirname(dir)
            files = [os.path.basename(dir)]
            self.subDir = ""
            self.depth = 0
        else:
            self.baseFile = ""
            if self.depth == 0: self.baseDir = dir

            dirPath = os.path.join(self.baseDir, self.subDir)

            for f in os.listdir(dirPath):
                p = os.path.join(dirPath, f)
                if os.path.isdir(p):
                    dirs.append(f)
                files.append(f)

            files.sort()
            dirs.sort()
        
        for d in dirs:
            saveSubDir = self.subDir
            self.subDir = os.path.join(self.subDir, d)
            self.depth = self.depth + 1
            self.Walk(d)
            self.depth = self.depth - 1
            self.subDir = saveSubDir

        for f in files:
            self.Visit(f)

    def Visit(self, f):
        print "dir=%s; sub=%s; file=%s" % (self.baseDir, self.subDir, f)
