
import fnmatch
import os
import re
import sys
import time

from dirwalker import DirWalker

class CandidateWalker(DirWalker):
    def __init__(self, filePatterns, opts):
        self.filePatterns = filePatterns
        self.opts = opts
        self.canddict = dict()
        self.m_bVerbose = 0
        if self.opts.has_key('verbose'):
            self.m_bVerbose = 1

        self.fileStarted = None

        self.wordRE = re.compile(r'(.*?)([\w_]+)', re.IGNORECASE)

    def DoFile(self, f):
        if self.m_bVerbose: print "# DoFile(%s)" % f

        inFname = os.path.join(self.baseDir, self.subDir, f)
        try:
            inFile = open(inFname)
        except IOError, e:
            print "# ERROR: File error on %s" % inFname
            return

        line = inFile.readline()
        lineNum = 1
        while line:
            if self.m_bVerbose: print "Trying: %s" % line
            pos = 0
            m = self.wordRE.match(line)
            while m:
                matchStr = m.group(2)
                if self.m_bVerbose: print "\tWord: %s" % matchStr
                if matchStr.find("RMA") != -1 or \
                   matchStr.find("RN")  != -1 or \
                   matchStr.find("PN")  != -1 or \
                   matchStr.find("rma") != -1 or \
                   matchStr.find("rn")  != -1 or \
                   matchStr.find("pn")  != -1:
                    if not self.canddict.has_key(matchStr):
                        if self.m_bVerbose: print "\t\tAdding %s to dictionary" % matchStr
                        self.canddict[matchStr] = 1
                        
                pos = m.end()
                m = self.wordRE.match(line, pos)

            line = inFile.readline()
            lineNum = lineNum + 1

        inFile.close()

    def Visit(self, f):
        if self.m_bVerbose: print "# Visit(%s)" % f
        for patt in self.filePatterns:
            if fnmatch.fnmatchcase(f, patt):
                self.DoFile(f)
                break

    def WriteCandidateFile(self, candfilename):
        if self.m_bVerbose: print "# WriteCandidateFile(%s)" % candfilename
        # Copy the candidate dict to a list for sorting
        tmplist = list()
        for dent in self.canddict:
            tmplist.append(dent)
        tmplist.sort()
        # Write out the dict file
        try:
            candfile = open(candfilename, "w")
        except IOError:
            print "# ERROR: Could not open %s for writing" % candfilename
        for lent in tmplist:
            candfile.write(lent + "\n")
        candfile.close()
        print "%d candidate entries written to %s" % (len(tmplist), candfilename)
        
        
        
    
