/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.dvb.projectx.xinput.topfield_raw;

import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import net.sourceforge.dvb.projectx.common.Resource;
import net.sourceforge.dvb.projectx.xinput.topfield_raw.RawFileInputStream;
import net.sourceforge.dvb.projectx.xinput.topfield_raw.RawReadIF;

public class RawInterface {
    RawReadIF rawRead;
    long stream_size;
    String sourcefile;

    public RawInterface(String string) {
        try {
            Class<?> clazz = Class.forName("RawRead");
            this.rawRead = (RawReadIF)clazz.newInstance();
            this.sourcefile = string;
            this.stream_size = 0L;
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Can't instantiate RawInterface");
        }
    }

    public final void add_native_files(ArrayList arrayList) {
        this.rawRead.add_native_files(arrayList);
    }

    public final String GetLoadStatus() {
        if (this.rawRead.AccessEnabled()) {
            return this.rawRead.GetLoadStatus();
        }
        return Resource.getString("rawread.msg1");
    }

    public final long getFileSize() {
        return this.rawRead.getFileSize(this.sourcefile);
    }

    public final String getFileDate() {
        long l = this.rawRead.lastModified(this.sourcefile.substring(1));
        return DateFormat.getDateInstance(1).format(new Date(l)) + "  " + DateFormat.getTimeInstance(1).format(new Date(l));
    }

    public final RawFileInputStream getStream() throws IOException {
        RawFileInputStream rawFileInputStream = new RawFileInputStream(this.rawRead, this.sourcefile);
        this.stream_size = rawFileInputStream.streamSize();
        return rawFileInputStream;
    }

    public final long getStreamSize() {
        return this.stream_size;
    }
}

