/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.dvb.projectx.xinput.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.MalformedURLException;
import net.sourceforge.dvb.projectx.common.Common;
import net.sourceforge.dvb.projectx.common.Resource;
import net.sourceforge.dvb.projectx.gui.Dialogs;
import net.sourceforge.dvb.projectx.xinput.FileType;
import net.sourceforge.dvb.projectx.xinput.XInputFileIF;

public class XInputFileImpl
implements XInputFileIF {
    private boolean debug = false;
    private FileType fileType = null;
    private boolean isopen = false;
    private InputStream inputStream = null;
    private File file = null;
    private String file_separator = System.getProperty("file.separator");
    private RandomAccessFile randomAccessFile = null;

    private XInputFileImpl() {
        throw new UnsupportedOperationException();
    }

    public XInputFileImpl(File file) {
        if (this.debug) {
            System.out.println("Try to create XInputFile of Type FILE");
        }
        if (!file.isFile()) {
            throw new IllegalArgumentException("File is not of type FileType.FILE");
        }
        this.file = file;
        this.fileType = FileType.FILE;
        if (!this.exists()) {
            throw new IllegalArgumentException("File doesn't exist");
        }
        if (this.debug) {
            System.out.println("Succeeded to create XInputFile of Type FILE");
        }
    }

    public String toString() {
        return this.file.getAbsolutePath();
    }

    public String getUrl() {
        return "file://" + this.file.getAbsolutePath();
    }

    public long length() {
        return this.file.length();
    }

    public long lastModified() {
        return this.file.lastModified();
    }

    public boolean exists() {
        return this.file.exists();
    }

    public String getName() {
        return this.file.getName();
    }

    public String getParent() {
        return this.file.getParent();
    }

    public InputStream getInputStream() throws FileNotFoundException, MalformedURLException, IOException {
        return new FileInputStream(this.file);
    }

    public boolean rename() throws IOException {
        if (this.isopen) {
            return false;
        }
        String string = this.getParent();
        String string2 = this.getName();
        String string3 = null;
        boolean bl = false;
        if (!string.endsWith(this.file_separator)) {
            string = string + this.file_separator;
        }
        if ((string3 = Dialogs.getUserInput(string2, Resource.getString("autoload.dialog.rename") + " " + string + string2)) != null && !string3.equals("")) {
            if (new File(string + string3).exists()) {
                bl = Dialogs.getUserConfirmation(Resource.getString("autoload.dialog.fileexists"));
                if (bl) {
                    new File(string + string3).delete();
                    bl = Common.renameTo(string + string2, string + string3);
                }
            } else {
                bl = Common.renameTo(string + string2, string + string3);
            }
        }
        if (bl) {
            this.file = new File(string + string3);
        }
        return bl;
    }

    public void randomAccessOpen(String string) throws IOException {
        if (this.isopen) {
            throw new IllegalStateException("XInputFile is already open!");
        }
        this.randomAccessFile = new RandomAccessFile(this.file, string);
        this.isopen = true;
    }

    public void randomAccessClose() throws IOException {
        if (!this.isopen) {
            throw new IllegalStateException("XInputFile is already closed!");
        }
        if (this.randomAccessFile != null) {
            this.randomAccessFile.close();
            this.randomAccessFile = null;
        }
        this.isopen = false;
    }

    public void randomAccessSeek(long l) throws IOException {
        this.randomAccessFile.seek(l);
    }

    public long randomAccessGetFilePointer() throws IOException {
        return this.randomAccessFile.getFilePointer();
    }

    public int randomAccessRead() throws IOException {
        return this.randomAccessFile.read();
    }

    public int randomAccessRead(byte[] byArray) throws IOException {
        return this.randomAccessFile.read(byArray);
    }

    public int randomAccessRead(byte[] byArray, int n, int n2) throws IOException {
        return this.randomAccessFile.read(byArray, n, n2);
    }

    public String randomAccessReadLine() throws IOException {
        return this.randomAccessFile.readLine();
    }

    public void randomAccessWrite(byte[] byArray) throws IOException {
        this.randomAccessFile.write(byArray);
    }

    public void randomAccessSingleRead(byte[] byArray, long l) throws IOException {
        this.randomAccessOpen("r");
        this.randomAccessSeek(l);
        this.randomAccessRead(byArray);
        this.randomAccessClose();
    }

    public long randomAccessReadLong() throws IOException {
        return this.randomAccessFile.readLong();
    }

    public FileType getFileType() {
        return this.fileType;
    }
}

