/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.dvb.projectx.xinput.file;

import java.io.File;
import java.io.FileFilter;
import net.sourceforge.dvb.projectx.xinput.DirType;
import net.sourceforge.dvb.projectx.xinput.XInputDirectoryIF;
import net.sourceforge.dvb.projectx.xinput.XInputFile;

public class XInputDirectoryImpl
implements XInputDirectoryIF {
    private DirType dirType = null;
    private File file = null;
    private String testMsg = null;

    private XInputDirectoryImpl() {
        throw new UnsupportedOperationException("Usage is not allowed!");
    }

    public XInputDirectoryImpl(File file) {
        if (!file.exists() || !file.isDirectory()) {
            throw new IllegalArgumentException("aFile is not a directory!");
        }
        this.dirType = DirType.FILE_DIR;
        this.file = file;
    }

    public XInputDirectoryImpl(String string) {
        File file = new File(string);
        if (!file.exists() || !file.isDirectory()) {
            throw new IllegalArgumentException("'" + string + "' is not a directory!");
        }
        this.dirType = DirType.FILE_DIR;
        this.file = file;
    }

    public String toString() {
        return this.file.getAbsolutePath();
    }

    public String getDirectory() {
        return this.file.getParent();
    }

    public String getPassword() {
        return "";
    }

    public String getServer() {
        return "";
    }

    public String getPort() {
        return "";
    }

    public String getUser() {
        return "";
    }

    public String getLog() {
        return "";
    }

    public XInputFile[] getFiles() {
        XInputFile[] xInputFileArray = null;
        class MyFileFilter
        implements FileFilter {
            MyFileFilter() {
            }

            public boolean accept(File file) {
                return file.isFile();
            }
        }
        File[] fileArray = this.file.listFiles(new MyFileFilter());
        xInputFileArray = new XInputFile[fileArray.length];
        for (int i = 0; i < fileArray.length; ++i) {
            xInputFileArray[i] = new XInputFile(fileArray[i]);
        }
        return xInputFileArray;
    }

    public boolean test() {
        boolean bl = false;
        bl = this.file.exists() && this.file.isDirectory();
        this.testMsg = bl ? "Test succeeded" : "Test failed";
        return bl;
    }

    public String getTestMsg() {
        return this.testMsg;
    }

    public DirType getDirType() {
        return this.dirType;
    }
}

