/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.dvb.projectx.video;

import java.util.Arrays;
import net.sourceforge.dvb.projectx.common.Resource;

public final class WSS {
    private static int[] pixels = new int[267];
    private static int a;
    private static String str;
    private static String start;

    public WSS() {
        WSS.init(new int[0], 0);
    }

    public static void init(int[] nArray, int n) {
        str = null;
        if (nArray.length < 200) {
            return;
        }
        WSS.scale(nArray, n);
    }

    public static String getWSS() {
        return str;
    }

    private static void scale(int[] nArray, int n) {
        Arrays.fill(pixels, 0);
        int n2 = 267;
        float f = 0.0f;
        float f2 = (float)n / (float)n2;
        for (int i = 0; f < (float)n && i < n2; f += f2, ++i) {
            WSS.pixels[i] = 0xFF & nArray[(int)f] >>> 16;
        }
        a = 0;
        WSS.handlepixels();
    }

    private static void handlepixels() {
        str = "WSS status:<p>";
        if (WSS.getRunIn()) {
            str = str + Resource.getString("wss.run_in") + " @ " + a + "<p>";
            a += 29;
            if (WSS.getStartCode()) {
                int n;
                str = str + Resource.getString("wss.startcode") + " @ " + a + "<p>";
                str = str + Resource.getString("wss.group_1") + " " + start + " @ " + (a += 24) + " :" + "<p>";
                str = str + " * " + WSS.getGroup1() + "<p>";
                str = str + Resource.getString("wss.group_2") + " " + start + " @ " + (a += 24) + " :" + "<p>";
                String[] stringArray = WSS.getGroup2();
                for (n = 0; n < 4; ++n) {
                    str = str + " * " + stringArray[n] + "<p>";
                }
                str = str + Resource.getString("wss.group_3") + " " + start + " @ " + (a += 24) + " :" + "<p>";
                stringArray = WSS.getGroup3();
                for (n = 0; n < 2; ++n) {
                    str = str + " * " + stringArray[n] + "<p>";
                }
                str = str + Resource.getString("wss.group_4") + " " + start + " @ " + (a += 18) + " :" + "<p>";
                stringArray = WSS.getGroup4();
                for (n = 0; n < 2; ++n) {
                    str = str + " * " + stringArray[n] + "<p>";
                }
            } else {
                str = str + Resource.getString("wss.no_startcode");
            }
        } else {
            str = str + Resource.getString("wss.no_run_in");
            str = null;
        }
        a = 0;
    }

    private static boolean getRunIn() {
        while (a < 30) {
            if (pixels[a] > 120 && pixels[a + 2] >= 120 && pixels[a + 5] < 120 && pixels[a + 8] >= 120 && pixels[a + 11] < 120 && pixels[a + 14] >= 120 && pixels[a + 17] < 120 && pixels[a + 20] >= 120 && pixels[a + 23] < 120 && pixels[a + 26] >= 120) {
                return true;
            }
            ++a;
        }
        return false;
    }

    private static boolean getStartCode() {
        return pixels[a] < 120 && pixels[a + 3] >= 120 && pixels[a + 7] < 120 && pixels[a + 10] >= 120 && pixels[a + 14] < 120 && pixels[a + 19] >= 120;
    }

    private static String getGroup1() {
        int n = 0;
        for (int i = 0; i < 8; ++i) {
            n |= pixels[a + 3 * i] < 120 ? 0 : 1 << 7 - i;
        }
        switch (n) {
            case 86: {
                return "  " + Resource.getString("wss.group_1.0001");
            }
            case 149: {
                return "  " + Resource.getString("wss.group_1.1000");
            }
            case 101: {
                return "  " + Resource.getString("wss.group_1.0100");
            }
            case 166: {
                return "  " + Resource.getString("wss.group_1.1101");
            }
            case 89: {
                return "  " + Resource.getString("wss.group_1.0010");
            }
            case 106: {
                return "  " + Resource.getString("wss.group_1.0111");
            }
            case 169: {
                return "  " + Resource.getString("wss.group_1.1110");
            }
        }
        return "  " + Resource.getString("wss.group_1.error");
    }

    private static String[] getGroup2() {
        int n = 0;
        for (int i = 0; i < 8; ++i) {
            n |= pixels[a + 3 * i] < 120 ? 0 : 1 << 7 - i;
        }
        String[] stringArray = new String[4];
        switch (n >>> 6) {
            case 1: {
                stringArray[0] = "  " + Resource.getString("wss.group_2.0.01");
                break;
            }
            case 2: {
                stringArray[0] = "  " + Resource.getString("wss.group_2.0.10");
                break;
            }
            default: {
                stringArray[0] = "  " + Resource.getString("wss.group_2.0.00");
            }
        }
        switch (3 & n >>> 4) {
            case 1: {
                stringArray[1] = "  " + Resource.getString("wss.group_2.1.01");
                break;
            }
            case 2: {
                stringArray[1] = "  " + Resource.getString("wss.group_2.1.10");
                break;
            }
            default: {
                stringArray[1] = "  " + Resource.getString("wss.group_2.1.00");
            }
        }
        switch (3 & n >>> 2) {
            case 1: {
                stringArray[2] = "  " + Resource.getString("wss.group_2.2.01");
                break;
            }
            case 2: {
                stringArray[2] = "  " + Resource.getString("wss.group_2.2.10");
                break;
            }
            default: {
                stringArray[2] = "  " + Resource.getString("wss.group_2.2.00");
            }
        }
        switch (3 & n) {
            case 1: {
                stringArray[3] = "  " + Resource.getString("wss.group_2.3.01");
                break;
            }
            case 2: {
                stringArray[3] = "  " + Resource.getString("wss.group_2.3.10");
                break;
            }
            default: {
                stringArray[3] = "  " + Resource.getString("wss.group_2.3.00");
            }
        }
        return stringArray;
    }

    private static String[] getGroup3() {
        int n = 0;
        for (int i = 0; i < 6; ++i) {
            n |= pixels[a + 3 * i] < 120 ? 0 : 1 << 5 - i;
        }
        String[] stringArray = new String[2];
        switch (3 & n >>> 4) {
            case 1: {
                stringArray[0] = "  " + Resource.getString("wss.group_3.0.01");
                break;
            }
            case 2: {
                stringArray[0] = "  " + Resource.getString("wss.group_3.0.10");
                break;
            }
            default: {
                stringArray[0] = "  " + Resource.getString("wss.group_3.0.00");
            }
        }
        switch (0xF & n) {
            case 5: {
                stringArray[1] = "  " + Resource.getString("wss.group_3.1.00");
                break;
            }
            case 6: {
                stringArray[1] = "  " + Resource.getString("wss.group_3.1.01");
                break;
            }
            case 9: {
                stringArray[1] = "  " + Resource.getString("wss.group_3.1.10");
                break;
            }
            case 10: {
                stringArray[1] = "  " + Resource.getString("wss.group_3.1.11");
                break;
            }
            default: {
                stringArray[1] = "  " + Resource.getString("wss.group_3.1.err");
            }
        }
        return stringArray;
    }

    private static String[] getGroup4() {
        int n = 0;
        for (int i = 0; i < 6; ++i) {
            n |= pixels[a + 3 * i] < 120 ? 0 : 1 << 5 - i;
        }
        String[] stringArray = new String[2];
        switch (3 & n >>> 4) {
            case 1: {
                stringArray[0] = "  " + Resource.getString("wss.group_4.0.01");
                break;
            }
            case 2: {
                stringArray[0] = "  " + Resource.getString("wss.group_4.0.10");
                break;
            }
            default: {
                stringArray[0] = "  " + Resource.getString("wss.group_4.0.00");
            }
        }
        switch (0xF & n) {
            case 5: {
                stringArray[1] = "  " + Resource.getString("wss.group_4.1.00");
                break;
            }
            case 6: {
                stringArray[1] = "  " + Resource.getString("wss.group_4.1.01");
                break;
            }
            case 9: {
                stringArray[1] = "  " + Resource.getString("wss.group_4.1.10");
                break;
            }
            case 10: {
                stringArray[1] = "  " + Resource.getString("wss.group_4.1.11");
                break;
            }
            default: {
                stringArray[1] = "  " + Resource.getString("wss.group_4.1.err");
            }
        }
        return stringArray;
    }

    static {
        start = Resource.getString("wss.start");
    }
}

