/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.dvb.projectx.video;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import net.sourceforge.dvb.projectx.common.Resource;
import net.sourceforge.dvb.projectx.common.X;
import net.sourceforge.dvb.projectx.gui.UISwitchListener;
import net.sourceforge.dvb.projectx.xinput.XInputFile;

public class PatchPanel
extends JDialog {
    private JTextField[] patchfield = new JTextField[3];
    XInputFile xInputFile = null;
    private String[] notes = new String[]{" H:", " V:", " BR:", "bps "};
    private long ins = 0L;
    private byte[] os = new byte[1];
    private PatchListener patchAction = new PatchListener();

    public PatchPanel(JFrame jFrame) {
        super(jFrame, Resource.getString("patch.title"), true);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        for (int i = 0; i < 3; ++i) {
            this.patchfield[i] = new JTextField("");
            this.patchfield[i].setPreferredSize(new Dimension(65, 22));
            this.patchfield[i].setMaximumSize(new Dimension(65, 22));
            jPanel2.add(new JLabel(this.notes[i]));
            jPanel2.add(this.patchfield[i]);
        }
        jPanel2.add(new JLabel(this.notes[3]));
        JButton jButton = new JButton();
        Resource.localize(jButton, "patch.change");
        jButton.setActionCommand("change");
        jButton.addActionListener(this.patchAction);
        jPanel2.add(jButton);
        JButton jButton2 = new JButton();
        Resource.localize(jButton2, "patch.cancel");
        jButton2.setActionCommand("cancel");
        jButton2.addActionListener(this.patchAction);
        jPanel2.add(jButton2);
        this.getRootPane().setDefaultButton(jButton2);
        jPanel.add(jPanel2);
        this.getContentPane().add(jPanel);
        if (!X.CLI_mode) {
            this.pack();
        }
        this.centerDialog();
        UIManager.addPropertyChangeListener(new UISwitchListener(jPanel));
    }

    private boolean search(XInputFile xInputFile, byte[] byArray) {
        try {
            long l = xInputFile.length();
            byte[] byArray2 = new byte[l < 650000L ? (int)l : 650000];
            this.os = byArray;
            xInputFile.randomAccessSingleRead(byArray2, 0L);
            for (int i = 0; i < byArray2.length - 15; ++i) {
                if (byArray2[i] != 0 || byArray2[i + 1] != 0 || byArray2[i + 2] != 1 || byArray2[i + 3] != -77 || byArray2[i + 4] != byArray[4] || byArray2[i + 5] != byArray[5] || byArray2[i + 6] != byArray[6] || byArray2[i + 7] != byArray[7]) continue;
                this.ins = i;
                this.patchfield[0].setText("" + ((0xFF & byArray2[i + 4]) << 4 | (0xF0 & byArray2[i + 5]) >>> 4));
                this.patchfield[1].setText("" + ((0xF & byArray2[i + 5]) << 8 | 0xFF & byArray2[i + 6]));
                this.patchfield[2].setText("" + ((0xFF & byArray2[i + 8]) << 10 | (0xFF & byArray2[i + 9]) << 2 | (0xC0 & byArray2[i + 10]) >>> 6) * 400);
                return true;
            }
        }
        catch (IOException iOException) {
            X.Msg(Resource.getString("patch.error") + " " + iOException);
        }
        return false;
    }

    public void entry(XInputFile xInputFile, byte[] byArray) {
        this.xInputFile = xInputFile;
        if (this.search(this.xInputFile, byArray)) {
            this.show();
        }
    }

    protected void centerDialog() {
        Dimension dimension = this.getToolkit().getScreenSize();
        Dimension dimension2 = this.getSize();
        dimension.height /= 2;
        dimension.width /= 2;
        dimension2.height /= 2;
        dimension2.width /= 2;
        int n = dimension.height - dimension2.height;
        int n2 = dimension.width - dimension2.width;
        this.setLocation(n2, n);
    }

    private void cancel() {
        this.setVisible(false);
    }

    private void change() {
        try {
            int n = Integer.parseInt(this.patchfield[0].getText());
            int n2 = Integer.parseInt(this.patchfield[1].getText());
            int n3 = Integer.parseInt(this.patchfield[2].getText()) / 400;
            this.os[4] = (byte)(0xFF & n >>> 4);
            this.os[5] = (byte)(0xF0 & n << 4 | 0xF & n2 >>> 8);
            this.os[6] = (byte)(0xFF & n2);
            this.os[8] = (byte)(0xFF & n3 >>> 10);
            this.os[9] = (byte)(0xFF & n3 >>> 2);
            this.os[10] = (byte)(0x3F & this.os[10] | 0xC0 & n3 << 6);
            this.dochange();
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private void dochange() {
        try {
            this.xInputFile.randomAccessOpen("rw");
            this.xInputFile.randomAccessSeek(this.ins);
            this.xInputFile.randomAccessWrite(this.os);
            this.xInputFile.randomAccessClose();
        }
        catch (IOException iOException) {
            X.Msg(Resource.getString("patch.error2") + " " + iOException);
        }
        this.setVisible(false);
    }

    private class PatchListener
    implements ActionListener {
        private PatchListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("change")) {
                PatchPanel.this.change();
            } else if (string.equals("cancel")) {
                PatchPanel.this.cancel();
            }
        }
    }
}

