/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.dvb.projectx.subtitle;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.font.FontRenderContext;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.TimeZone;
import javax.swing.JFrame;
import javax.swing.JPanel;
import net.sourceforge.dvb.projectx.common.Resource;
import net.sourceforge.dvb.projectx.common.X;
import net.sourceforge.dvb.projectx.subtitle.Bitmap;
import net.sourceforge.dvb.projectx.subtitle.DVBSubpicture;

public class SubPicture
extends JFrame {
    public Picture picture;
    String title = Resource.getString("subpicture.title");

    public SubPicture() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                SubPicture.this.close();
            }
        });
        this.picture = new Picture();
        this.picture.run();
        this.getContentPane().add("Center", this.picture);
        this.setTitle(this.title);
        this.setSize(new Dimension(726, 601));
        this.setLocation(100, 100);
        this.setResizable(false);
    }

    public void newTitle(String string) {
        this.setTitle(this.title + " " + string);
    }

    public void close() {
        this.dispose();
    }

    public class Picture
    extends JPanel
    implements Runnable {
        public DateFormat sms = new SimpleDateFormat("HH:mm:ss.SSS");
        public Thread thread;
        private int w = 720;
        private int h = 576;
        private int x = 20;
        private int nibble = 0;
        private int val = 0;
        private int default_alpha = 10;
        private int modified_alpha = 0;
        private BufferedImage bimg;
        private Graphics2D big;
        private Font font;
        private Font font_alt;
        private Font font_std;
        private FontRenderContext frc;
        private final int[] default_teletext_colors = new int[]{-10461088, -1351584, -15668464, -1316080, -11513621, -1351445, -15668245, -1315861, -10461088, -2072480, -10428320, -2039712, -10460960, -2072352, -10428192, -2039584, -9408400, -3116944, -9383824, -3092368, -9408304, -3116848, -9383728, -3092272, -8355712, -4161408, -8339328, -4145024, -8355648, -4161344, -8339264, -4144960, -7303024, -4157296, -7290736, -4145008, -7302976, -4157248, -7290688, -5197648, -6250336, -5201760, -6246240, -5197664, -6250320, -5201744, -6246224, -6250336, -5197648, -4153184, -6238048, -4140896, -6250288, -3104560, -6238000, -7303024, -3092272, -2060144, -7282544, -2039664, -7302944, -2060064, -7282464, -8355712, 0, 128};
        private final int[] default_sup_colors = new int[]{-15724528, -6250336, -1315861, -10461088, -1372144, -15668464, -1316080, -15724309, -1371925, -15668245, -1343360, -8328320, -1315968, -8355605, -1343253, -8328213, 0};
        private Object[] str = new Object[0];
        private byte[] RLEheader = new byte[]{83, 80, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        private byte[] sections = new byte[]{0, 0, 3, 50, 16, 4, -1, -6, 5, 0, 0, 0, 0, 0, 0, 6, 0, 0, 0, 0, 1, -1, 1, 80, 0, 0, 2, -1};
        private ByteArrayOutputStream out = new ByteArrayOutputStream();
        private byte[] newline = new byte[]{0, 0};
        private int[] Rect = new int[4];
        private int[] pos = new int[4];
        private int[] option = new int[10];
        private int[] standard_values = new int[]{26, 10, 32, 80, 560, 720, 576, -1, 4};
        private ArrayList user_color_table = new ArrayList();
        private Bitmap bitmap;
        private boolean read_from_Image = false;
        private int isforced_status = 0;
        private boolean global_error = false;
        private int line_offset = 28;
        public DVBSubpicture dvb = new DVBSubpicture();

        public Picture() {
            this.bimg = new BufferedImage(this.w, this.h, 1);
            this.big = this.bimg.createGraphics();
            this.set("Tahoma", "26;10;32;80;560;720;576;-1;4");
            this.frc = this.big.getFontRenderContext();
            this.setBackground(Color.gray);
            this.sms.setTimeZone(TimeZone.getTimeZone("GMT+0:00"));
        }

        public void paint(Graphics graphics) {
            if (this.big == null) {
                return;
            }
            graphics.drawImage(this.bimg, 0, 0, this);
        }

        public void showPicTTX(Object[] objectArray) {
            this.str = objectArray;
            this.buildImgTTX();
            this.repaint();
        }

        public byte[] setTime(byte[] byArray, long l) {
            long l2 = 0L;
            for (int i = 0; i < 4; ++i) {
                l2 |= (long)((0xFF & byArray[i + 2]) << i * 8);
            }
            long l3 = 1L + (l - l2) / 1000L;
            int n = (0xFF & byArray[12]) << 8 | 0xFF & byArray[13];
            byArray[34 + n] = (byte)(0xFFL & l3 >>> 8);
            byArray[35 + n] = (byte)(0xFFL & l3);
            SubPicture.this.newTitle(" / " + Resource.getString("subpicture.in_time") + ": " + this.sms.format(new Date(l2 / 90L)) + " " + Resource.getString("subpicture.duration") + ": " + this.sms.format(new Date((l - l2) / 90L)));
            return byArray;
        }

        public void buildImgTTX() {
            int n;
            boolean bl;
            Object object;
            int n2;
            int n3 = 6;
            this.Rect[0] = this.option[3];
            this.Rect[3] = 2 * n3 + this.line_offset * this.str.length;
            this.Rect[1] = this.option[6] - this.option[2] - this.Rect[3];
            this.Rect[2] = this.option[4];
            this.pos[0] = this.Rect[0];
            this.pos[1] = this.Rect[1];
            this.pos[2] = this.Rect[0] + this.Rect[2] - 1;
            this.pos[3] = this.Rect[1] + this.Rect[3] - 1;
            this.paintVideoSize();
            this.big.setColor(Color.white);
            this.big.drawRect(this.Rect[0] - 1, this.Rect[1] - 1, this.Rect[2] + 1, this.Rect[3] + 1);
            this.big.setFont(this.font_std);
            this.big.drawString("x" + this.pos[0] + ", y" + this.pos[1] + " / " + (this.pos[2] - this.pos[0] + 1) + "*" + (this.pos[3] - this.pos[1] + 1), this.Rect[0] - 1, this.Rect[1] - 5);
            int[] nArray = this.getColorTable(1);
            this.big.setFont(this.font);
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 0; i < this.str.length; ++i) {
                int[] nArray2 = (int[])this.str[i];
                for (int j = 0; j < nArray2.length; ++j) {
                    int n4 = (7 & nArray2[j] >>> 4) << 3;
                    n2 = nArray[n4 + (7 & nArray2[j])];
                    object = Integer.toString(n2);
                    String string = new Character((char)(nArray2[j] >>> 8)).toString();
                    if (arrayList.indexOf(object) >= 0 || string.equals(" ")) continue;
                    arrayList.add((String)object);
                }
            }
            if (arrayList.size() < 3 && X.cBox[79].isSelected()) {
                this.big.setColor(new Color(nArray[65]));
                this.modified_alpha = 0;
                bl = true;
            } else {
                this.big.setColor(new Color(nArray[64]));
                this.modified_alpha = this.default_alpha;
                bl = false;
            }
            this.big.fillRect(this.Rect[0], this.Rect[1], this.Rect[2], this.Rect[3]);
            for (n = 0; bl && n < this.str.length; ++n) {
                int[] nArray3 = (int[])this.str[n];
                String string = "";
                this.big.setColor(new Color(nArray[64]));
                for (n2 = 0; n2 < nArray3.length; ++n2) {
                    string = string + new Character((char)(nArray3[n2] >>> 8)).toString();
                }
                this.x = this.option[3];
                n2 = this.Rect[1] + this.line_offset * (1 + n);
                object = new int[]{2, 3, 3, 3, 3, 3, 2};
                for (int i = 0; i < ((Object)object).length; ++i) {
                    int n5 = this.x;
                    int n6 = n2 - ((Object)object).length / 2 + i;
                    for (reference var14_21 = -object[i]; var14_21 < object[i] + true; ++var14_21) {
                        this.big.drawString(string, n5 + var14_21, n6);
                    }
                }
            }
            for (n = 0; n < this.str.length; ++n) {
                int[] nArray4 = (int[])this.str[n];
                this.x = this.option[3];
                for (int i = 0; i < nArray4.length; ++i) {
                    n2 = (7 & nArray4[i] >>> 4) << 3;
                    this.big.setColor(new Color(nArray[n2 + (7 & nArray4[i])]));
                    this.big.drawString("" + (char)(nArray4[i] >>> 8), this.x, this.Rect[1] + this.line_offset * (1 + n));
                    this.x = (int)((double)this.x + this.font.getStringBounds("" + (char)(nArray4[i] >>> 8), this.frc).getWidth());
                }
            }
        }

        public void resetUserColorTable() {
            this.user_color_table.clear();
        }

        public Object[] getUserColorTableArray() {
            return this.user_color_table.toArray();
        }

        public ArrayList getUserColorTable() {
            return this.user_color_table;
        }

        public void updateUserColorTable(Bitmap bitmap) {
            this.bitmap = bitmap;
            int[] nArray = this.bitmap.getPixel();
            for (int i = 0; i < nArray.length; ++i) {
                String string = "" + nArray[i];
                if (!this.user_color_table.contains(string)) {
                    this.user_color_table.add(string);
                }
                this.bitmap.getColorIndex(this.getUserColorTableIndex(nArray[i]));
            }
        }

        private void updateUserColorTable(int[] nArray) {
            for (int i = 0; i < nArray.length; ++i) {
                String string = "" + nArray[i];
                if (this.user_color_table.contains(string)) continue;
                this.user_color_table.add(string);
            }
        }

        private int getUserColorTableIndex(int n) {
            int n2 = this.user_color_table.indexOf("" + n);
            if (n2 < 0) {
                return 0;
            }
            return n2;
        }

        public byte[] writeRLE(long l, int n) throws IOException {
            this.read_from_Image = true;
            this.bitmap = new Bitmap(this.Rect[0], this.Rect[1], this.Rect[2], this.Rect[3], this.bimg.getRGB(this.Rect[0], this.Rect[1], this.Rect[2], this.Rect[3], null, 0, this.Rect[2]), 2, 0, 1, 2, l, n);
            return this.buildRLE();
        }

        public byte[] writeRLE(Bitmap bitmap) throws IOException {
            this.bitmap = bitmap;
            this.setArea();
            return this.buildRLE();
        }

        private byte[] buildRLE() {
            byte[] byArray = null;
            try {
                int n;
                int[] nArray = this.bitmap.getPixel();
                this.updateUserColorTable(nArray);
                this.out.reset();
                this.out.write(this.RLEheader);
                int n2 = 0;
                int n3 = 0;
                int n4 = 0;
                int n5 = 0;
                int n6 = 0;
                for (n = 0; n < 2; ++n) {
                    n3 = 0;
                    n6 = 0;
                    for (n4 = n * this.bitmap.getWidth(); n4 < nArray.length; n4 += 2 * this.bitmap.getWidth()) {
                        n3 = 0;
                        n6 = 0;
                        n5 = 0;
                        while (n5 < this.bitmap.getWidth()) {
                            if (nArray[n4 + n5] != n6) {
                                this.updateRLE(n3, n6);
                                n6 = nArray[n4 + n5];
                                n3 = 0;
                            } else if (n3 > 254) {
                                this.updateRLE(n3, n6);
                                n3 = 0;
                            }
                            ++n5;
                            ++n3;
                        }
                        --n3;
                        while (n3 > 255) {
                            this.updateRLE(255, n6);
                            n3 -= 255;
                        }
                        this.updateRLE(n3, n6);
                        this.alignRLE();
                        this.out.write(this.newline);
                    }
                    this.alignRLE();
                    if (n2 != 0) continue;
                    n2 = this.out.size() - 10;
                }
                this.out.write(this.newline);
                n = this.out.size() - 12;
                n3 = n + 24;
                n4 = this.out.size() + 22;
                this.setScreenPosition(this.bitmap.getX(), this.bitmap.getY(), this.bitmap.getMaxX() - 1, this.bitmap.getMaxY() - 1);
                this.setControlBlockPosition(n3, n2);
                this.setPGCsection();
                this.out.write(this.sections);
                if ((this.out.size() & 1) == 1) {
                    this.out.write(-1);
                }
                this.out.flush();
                byArray = this.out.toByteArray();
                n5 = byArray.length - 10;
                byArray[10] = (byte)(0xFF & n5 >>> 8);
                byArray[11] = (byte)(0xFF & n5);
                byArray[12] = (byte)(0xFF & n >>> 8);
                byArray[13] = (byte)(0xFF & n);
                for (n6 = 0; n6 < 4; ++n6) {
                    byArray[n6 + 2] = (byte)(0xFFL & this.bitmap.getInTime() >>> n6 * 8);
                }
                byArray[n4] = (byte)(0xFF & this.bitmap.getPlayTime() >>> 8);
                byArray[n4 + 1] = (byte)(0xFF & this.bitmap.getPlayTime());
            }
            catch (IOException iOException) {
                X.Msg(Resource.getString("subpicture.msg1"));
            }
            this.read_from_Image = false;
            return byArray;
        }

        private void alignRLE() {
            if (this.nibble == 0) {
                return;
            }
            this.out.write((byte)this.val);
            this.nibble = 0;
            this.val = 0;
        }

        private void updateRLE(int n, int n2) {
            if (n < 1) {
                return;
            }
            int n3 = this.getUserColorTableIndex(n2);
            n3 = this.bitmap.getColorIndex(n3);
            n = n << 2 | n3;
            if (this.nibble == 0) {
                if (n > 255) {
                    this.out.write((byte)(0xFF & n >>> 8));
                    this.out.write((byte)(0xFF & n));
                } else if (n > 63) {
                    this.out.write((byte)(0xFF & n >>> 4));
                    this.val = 0xF0 & n << 4;
                    this.nibble = 4;
                } else if (n > 15) {
                    this.out.write((byte)(0xFF & n));
                } else {
                    this.val = 0xF0 & n << 4;
                    this.nibble = 4;
                }
            } else if (n > 255) {
                this.out.write((byte)(this.val | 0xF & n >>> 12));
                this.out.write((byte)(0xFF & n >>> 4));
                this.val = 0xF0 & n << 4;
            } else if (n > 63) {
                this.out.write((byte)(this.val | 0xF & n >>> 8));
                this.out.write((byte)(0xFF & n));
                this.nibble = 0;
                this.val = 0;
            } else if (n > 15) {
                this.out.write((byte)(this.val | 0xF & n >>> 4));
                this.val = 0xF0 & n << 4;
            } else {
                this.out.write((byte)(this.val | 0xF & n));
                this.nibble = 0;
                this.val = 0;
            }
        }

        private void setScreenPosition(int n, int n2, int n3, int n4) {
            this.sections[9] = (byte)(n >>> 4);
            this.sections[10] = (byte)(n << 4 | n3 >>> 8);
            this.sections[11] = (byte)n3;
            this.sections[12] = (byte)(n2 >>> 4);
            this.sections[13] = (byte)(n2 << 4 | n4 >>> 8);
            this.sections[14] = (byte)n4;
        }

        private void setControlBlockPosition(int n, int n2) {
            this.sections[16] = 0;
            this.sections[17] = 4;
            this.sections[18] = (byte)(0xFF & n2 >>> 8);
            this.sections[19] = (byte)(0xFF & n2);
            this.sections[0] = this.sections[24] = (byte)(0xFF & n >>> 8);
            this.sections[1] = this.sections[25] = (byte)(0xFF & n);
        }

        private void setPGCsection() {
            int n = this.setPGClinks();
            this.sections[3] = (byte)(0xFF & n >>> 8);
            this.sections[4] = (byte)(0xFF & n);
            this.sections[6] = (byte)(0xFF & n >>> 24);
            this.sections[7] = (byte)(0xFF & n >>> 16);
        }

        public int setPGClinks() {
            Object[] objectArray = this.bitmap.getColorIndices();
            Object[] objectArray2 = this.getUserColorTableArray();
            int n = 65040;
            int n2 = 65529;
            for (int i = 0; i < 4; ++i) {
                if (i >= objectArray.length) continue;
                int n3 = 0xF & Integer.parseInt(objectArray[i].toString());
                int n4 = 0xF & Integer.parseInt(objectArray2[n3].toString()) >>> 28;
                n = n & ~(15 << i * 4) | n3 << i * 4;
                n2 = n2 & ~(15 << i * 4) | n4 << i * 4;
            }
            if (this.read_from_Image) {
                n2 &= 0xFFF0 | this.modified_alpha;
            }
            return n2 << 16 | n;
        }

        public void set2() {
            this.option[2] = this.option[7];
        }

        public int getMaximumLines() {
            return this.option[8];
        }

        public int set(String string, String string2) {
            this.resetUserColorTable();
            System.arraycopy(this.standard_values, 0, this.option, 0, this.standard_values.length);
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ";");
            for (int i = 0; stringTokenizer.hasMoreTokens() && i < this.option.length; ++i) {
                this.option[i] = Integer.parseInt(stringTokenizer.nextToken());
            }
            this.line_offset = this.option[0] + 2;
            this.default_alpha = 0xF & this.option[1];
            this.font = new Font(string, 1, this.option[0]);
            this.font_alt = new Font(string, 3, this.option[0]);
            this.font_std = new Font("Tahoma", 0, 14);
            return this.option[7];
        }

        private int[] getColorTable(int n) {
            if (n == 0) {
                return this.default_sup_colors;
            }
            return this.default_teletext_colors;
        }

        private void setArea() {
            this.Rect[0] = this.bitmap.getX();
            this.Rect[1] = this.bitmap.getY();
            this.Rect[2] = this.bitmap.getWidth();
            this.Rect[3] = this.bitmap.getHeight();
            this.pos[0] = this.bitmap.getX();
            this.pos[1] = this.bitmap.getY();
            this.pos[2] = this.bitmap.getMaxX();
            this.pos[3] = this.bitmap.getMaxY();
        }

        public String getArea() {
            String string = "";
            string = string + "x " + this.Rect[0];
            string = string + " y " + this.Rect[1];
            string = string + " w " + this.Rect[2];
            string = string + " h " + this.Rect[3];
            string = string + " x1 " + this.pos[0];
            string = string + " y1 " + this.pos[1];
            string = string + " x2 " + this.pos[2];
            string = string + " y2 " + this.pos[3];
            return string;
        }

        public void run() {
        }

        private int paintVideoSize() {
            int[] nArray = X.getVideoBasics();
            if (nArray[0] == 0) {
                nArray[0] = 720;
            }
            if (nArray[1] == 0) {
                nArray[1] = 576;
            }
            this.big.setColor(new Color(-11206656));
            this.big.fillRect(0, 0, this.w, this.h);
            this.big.setColor(Color.gray);
            this.big.fillRect(0, 0, nArray[0], nArray[1]);
            return nArray[1];
        }

        private int Get_Bits(byte[] byArray, int[] nArray, int n) {
            int n2 = nArray[1] >>> 3;
            if (n2 >= byArray.length - 4) {
                this.global_error = true;
                nArray[1] = nArray[1] + n;
                nArray[0] = nArray[1] >>> 3;
                return 0;
            }
            int n3 = (0xFF & byArray[n2]) << 24 | (0xFF & byArray[n2 + 1]) << 16 | (0xFF & byArray[n2 + 2]) << 8 | 0xFF & byArray[n2 + 3];
            n3 <<= nArray[1] & 7;
            nArray[1] = nArray[1] + n;
            nArray[0] = nArray[1] >>> 3;
            return n3 >>>= 32 - n;
        }

        private int Show_Bits(byte[] byArray, int[] nArray, int n) {
            int n2 = nArray[1] >>> 3;
            if (n2 >= byArray.length - 4) {
                this.global_error = true;
                return 0;
            }
            int n3 = (0xFF & byArray[n2]) << 24 | (0xFF & byArray[n2 + 1]) << 16 | (0xFF & byArray[n2 + 2]) << 8 | 0xFF & byArray[n2 + 3];
            n3 <<= nArray[1] & 7;
            return n3 >>>= 32 - n;
        }

        private void Flush_Bits(int[] nArray, int n) {
            nArray[1] = nArray[1] + n;
            nArray[0] = nArray[1] >>> 3;
        }

        private void align_Bits(int[] nArray) {
            if ((1 & nArray[1] >>> 2) != 0) {
                this.Flush_Bits(nArray, 4);
            }
        }

        public String isForced_Msg() {
            String string = null;
            if ((this.isforced_status & 1) == 0) {
                string = (this.isforced_status & 2) > 0 ? Resource.getString("subpicture.msg.forced.no") : Resource.getString("subpicture.msg.forced.yes");
            }
            this.isforced_status |= 1;
            return string;
        }

        public void reset() {
            this.isforced_status = 0;
        }

        public int decode_picture(byte[] byArray, int n, boolean bl) {
            return this.decode_picture(byArray, n, bl, 0L, false, true);
        }

        public int decode_picture(byte[] byArray, int n, boolean bl, long l, boolean bl2, boolean bl3) {
            int n2;
            int n3;
            this.read_from_Image = false;
            this.global_error = false;
            boolean bl4 = false;
            int n4 = byArray.length;
            byte[] byArray2 = new byte[n4 + 4];
            System.arraycopy(byArray, 0, byArray2, 0, n4);
            int[] nArray = new int[]{n, n << 3};
            int[] nArray2 = new int[4];
            int[] nArray3 = new int[3];
            int[] nArray4 = new int[4];
            if (nArray[0] > n4 - 4) {
                return -4;
            }
            int n5 = this.Get_Bits(byArray2, nArray, 16);
            if (this.Show_Bits(byArray2, nArray, 24) == 15) {
                this.big.setFont(this.font_std);
                int n6 = this.dvb.decodeDVBSubpicture(byArray2, nArray, this.big, this.bimg, l, bl2, bl3);
                if (n6 > -2) {
                    this.repaint();
                }
                return n6;
            }
            if (nArray[0] + n5 != n4 + 2) {
                return -5;
            }
            nArray3[2] = this.Get_Bits(byArray2, nArray, 16) - 2;
            this.Flush_Bits(nArray, nArray3[2] << 3);
            int n7 = this.Get_Bits(byArray2, nArray, 16);
            if (n7 == nArray3[2] + 2) {
                n7 = n5;
                bl4 = true;
                X.Msg(Resource.getString("subpicture.msg2"));
            } else {
                nArray3[2] = nArray3[2] + (n + 2);
            }
            int[] nArray5 = this.getColorTable(0);
            block9: while (nArray[0] < n + n7) {
                n3 = this.Get_Bits(byArray2, nArray, 8);
                switch (n3) {
                    case 0: {
                        this.isforced_status = (this.isforced_status & 5) != 5 ? 4 : 5;
                        continue block9;
                    }
                    case 1: {
                        this.isforced_status = (this.isforced_status & 3) != 3 ? 2 : 3;
                        continue block9;
                    }
                    case 2: 
                    case 255: {
                        continue block9;
                    }
                    case 3: {
                        for (n2 = 0; n2 < 4; ++n2) {
                            int n8 = 3 - n2;
                            nArray4[n8] = nArray4[n8] | nArray5[this.Get_Bits(byArray2, nArray, 4)] & 0xFFFFFF;
                        }
                        continue block9;
                    }
                    case 4: {
                        for (n2 = 0; n2 < 4; ++n2) {
                            int n9 = 3 - n2;
                            nArray4[n9] = nArray4[n9] | 17 * (0xF ^ this.Get_Bits(byArray2, nArray, 4)) << 24;
                        }
                        continue block9;
                    }
                    case 5: {
                        for (n2 = 0; n2 < 4; ++n2) {
                            nArray2[n2] = this.Get_Bits(byArray2, nArray, 12);
                        }
                        continue block9;
                    }
                    case 6: {
                        for (n2 = 0; n2 < 2; ++n2) {
                            nArray3[n2] = this.Get_Bits(byArray2, nArray, 16);
                        }
                        continue block9;
                    }
                }
                X.Msg(Resource.getString("subpicture.msg3") + ": " + n3);
            }
            if (n + n7 != nArray[0]) {
                return -6;
            }
            n3 = 0;
            if (!bl4) {
                n3 = this.Get_Bits(byArray2, nArray, 16);
                if (n7 != this.Get_Bits(byArray2, nArray, 16)) {
                    return -7;
                }
                if (this.Get_Bits(byArray2, nArray, 8) != 2) {
                    return -8;
                }
                this.Flush_Bits(nArray, (nArray[0] & 1) != 1 ? 16 : 8);
            }
            if (nArray[0] != n4) {
                return -9;
            }
            if (this.global_error) {
                return -3;
            }
            if (!bl) {
                return n3 * 1000;
            }
            n2 = 0;
            while (n2 < 2) {
                int n10 = n2++;
                nArray3[n10] = nArray3[n10] + n;
            }
            this.paintVideoSize();
            n2 = nArray2[2];
            int n11 = nArray2[1] - nArray2[0] + 1;
            int n12 = nArray2[3] - nArray2[2] + 1;
            this.big.setColor(Color.white);
            this.big.drawRect(nArray2[0] - 1, n2 - 1, n11 + 1, n12 + 1);
            this.big.setFont(this.font_std);
            this.big.drawString("x" + nArray2[0] + ", y" + nArray2[2] + " / " + n11 + "*" + n12, nArray2[0] - 1, n2 - 5);
            for (int i = 0; i < 2; ++i) {
                int n13 = 0;
                int n14 = nArray2[0];
                int n15 = n2 + i;
                nArray[0] = nArray3[i];
                nArray[1] = nArray[0] << 3;
                while (nArray[0] < nArray3[i + 1]) {
                    n13 = this.Get_Bits(byArray2, nArray, 4);
                    if (n13 > 3) {
                        this.big.setColor(new Color(nArray4[n13 & 3]));
                        this.big.drawLine(n14, n15, n14 += n13 >>> 2, n15);
                        continue;
                    }
                    if ((n13 = n13 << 4 | this.Get_Bits(byArray2, nArray, 4)) > 15) {
                        this.big.setColor(new Color(nArray4[n13 & 3]));
                        this.big.drawLine(n14, n15, n14 += n13 >>> 2, n15);
                        continue;
                    }
                    if ((n13 = n13 << 4 | this.Get_Bits(byArray2, nArray, 4)) > 63) {
                        this.big.setColor(new Color(nArray4[n13 & 3]));
                        this.big.drawLine(n14, n15, n14 += n13 >>> 2, n15);
                        continue;
                    }
                    if ((n13 = n13 << 4 | this.Get_Bits(byArray2, nArray, 4)) > 0) {
                        this.big.setColor(new Color(nArray4[n13 & 3]));
                        this.big.drawLine(n14, n15, n14 += n13 >>> 2, n15);
                        continue;
                    }
                    n14 = nArray2[0];
                    n15 += 2;
                    this.align_Bits(nArray);
                }
            }
            this.repaint();
            if (this.global_error) {
                return -3;
            }
            return n3 * 1000;
        }
    }
}

