/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.dvb.projectx.subtitle;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import net.sourceforge.dvb.projectx.subtitle.Bitmap;

public class BMP {
    private static final byte[] defaultHeader = new byte[]{66, 77, 0, 0, 0, 0, 0, 0, 0, 0, 54, 0, 0, 0, 40, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 24, 0, 0, 0, 0, 0, 0, 0, 0, 0, -120, 11, 0, 0, -120, 11, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static Hashtable bmps = new Hashtable();

    private BMP() {
    }

    public static String getContents() {
        return bmps.toString();
    }

    public static Enumeration getKeys() {
        return bmps.keys();
    }

    public static boolean isEmpty() {
        return bmps.isEmpty();
    }

    public static void clear() {
        bmps.clear();
    }

    public static void savePixels(Bitmap bitmap) {
        bmps.put("" + bitmap.getId(), bitmap);
    }

    public static Bitmap getBitmap(int n) {
        return (Bitmap)bmps.get("" + n);
    }

    private static void littleEndian(byte[] byArray, int n, int n2) {
        for (int i = 0; i < 4; ++i) {
            byArray[n + i] = (byte)(n2 >> i * 8 & 0xFF);
        }
    }

    public static void buildBMP_24bit(String string, String string2) throws IOException {
        int n;
        Bitmap bitmap = (Bitmap)bmps.get(string2);
        if (bitmap == null) {
            return;
        }
        int n2 = bitmap.getWidth();
        int n3 = 3 * n2 * (n = bitmap.getHeight()) + n * (n2 & 3);
        if (n3 == 0) {
            return;
        }
        int[] nArray = bitmap.getPixel();
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string + ".bmp"), 65535);
        byte[] byArray = new byte[defaultHeader.length];
        System.arraycopy(defaultHeader, 0, byArray, 0, defaultHeader.length);
        byte[] byArray2 = new byte[3];
        BMP.littleEndian(byArray, 2, 54 + n3);
        BMP.littleEndian(byArray, 18, n2);
        BMP.littleEndian(byArray, 22, n);
        BMP.littleEndian(byArray, 34, n3);
        bufferedOutputStream.write(byArray);
        for (int i = n - 1; i >= 0; --i) {
            for (int j = 0; j < n2; ++j) {
                for (int k = 0; k < 3; ++k) {
                    byArray2[k] = (byte)(nArray[j + i * n2] >> k * 8 & 0xFF);
                }
                bufferedOutputStream.write(byArray2);
            }
            bufferedOutputStream.write(new byte[n2 & 3]);
        }
        bufferedOutputStream.flush();
        bufferedOutputStream.close();
    }

    public static String buildBMP_palettized(String string, String string2, ArrayList arrayList, int n) throws IOException {
        return BMP.buildBMP_palettized(string, (Bitmap)bmps.get(string2), arrayList, n);
    }

    public static String buildBMP_palettized(String string, Bitmap bitmap, ArrayList arrayList, int n) throws IOException {
        int n2;
        int n3;
        int n4;
        if (bitmap == null) {
            return "";
        }
        n = 256;
        int n5 = bitmap.getWidth();
        int n6 = n * 4 + n5 * (n4 = bitmap.getHeight()) + n4 * (n5 & 3);
        if (n6 == 0) {
            return "";
        }
        string = string + ".bmp";
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string), 65535);
        byte[] byArray = new byte[defaultHeader.length];
        System.arraycopy(defaultHeader, 0, byArray, 0, defaultHeader.length);
        boolean bl = false;
        byArray[28] = n == 256 ? 8 : 4;
        BMP.littleEndian(byArray, 2, 54 + n6);
        BMP.littleEndian(byArray, 10, 54 + n * 4);
        BMP.littleEndian(byArray, 18, n5);
        BMP.littleEndian(byArray, 22, n4);
        BMP.littleEndian(byArray, 34, n6);
        bufferedOutputStream.write(byArray);
        Object[] objectArray = arrayList.toArray();
        byte[] byArray2 = new byte[4];
        for (int i = 0; i < n; ++i) {
            if (i < objectArray.length) {
                n3 = 0xFFFFFF & Integer.parseInt(objectArray[i].toString());
                for (n2 = 0; n2 < 3; ++n2) {
                    byArray2[n2] = (byte)(0xFF & n3 >> (n2 << 3));
                }
            }
            bufferedOutputStream.write(byArray2);
        }
        objectArray = null;
        int[] nArray = bitmap.getPixel();
        for (n3 = n4 - 1; n3 >= 0; --n3) {
            boolean bl2 = false;
            for (n2 = 0; n2 < n5; ++n2) {
                bufferedOutputStream.write(0xFF & BMP.getColorIndex(nArray[n2 + n3 * n5], arrayList));
            }
            bufferedOutputStream.write(new byte[n5 & 3]);
        }
        bufferedOutputStream.flush();
        bufferedOutputStream.close();
        return string;
    }

    private static int getColorIndex(int n, ArrayList arrayList) {
        String string = "" + n;
        int n2 = arrayList.indexOf(string);
        if (n2 != -1) {
            return n2;
        }
        return arrayList.size() - 1;
    }

    public static String write_ColorTable(String string, ArrayList arrayList, int n) throws IOException {
        Object[] objectArray = arrayList.toArray();
        byte[] byArray = new byte[4];
        string = string + ".spf";
        n = 256;
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string), 65535);
        for (int i = 0; i < n; ++i) {
            if (i < objectArray.length) {
                int n2 = 0xFFFFFF & Integer.parseInt(objectArray[i].toString());
                for (int j = 0; j < 3; ++j) {
                    byArray[j] = (byte)(0xFF & n2 >> (j << 3));
                }
            }
            bufferedOutputStream.write(byArray);
        }
        objectArray = null;
        bufferedOutputStream.flush();
        bufferedOutputStream.close();
        return string;
    }
}

