/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.dvb.projectx.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.TimeZone;
import net.sourceforge.dvb.projectx.audio.Audio;
import net.sourceforge.dvb.projectx.common.Resource;
import net.sourceforge.dvb.projectx.common.X;
import net.sourceforge.dvb.projectx.video.Video;
import net.sourceforge.dvb.projectx.xinput.XInputFile;

public class Scan {
    private final String msg_1 = Resource.getString("scan.msg1");
    private final String msg_2 = Resource.getString("scan.msg2");
    private final String msg_3 = Resource.getString("scan.msg3");
    private final String msg_4 = Resource.getString("scan.msg4");
    private final String msg_5 = Resource.getString("scan.msg5");
    private final String msg_6 = Resource.getString("scan.msg6");
    private final String msg_7 = Resource.getString("scan.msg7");
    private final String msg_8 = Resource.getString("scan.msg8");
    private final String msg_9 = Resource.getString("scan.msg9");
    private final String[] type = new String[]{Resource.getString("scan.unsupported"), "PVA (Video/Audio PES)", "MPEG-1 PS/SS (Video/Audio PES)", "MPEG-2 PS/SS (Video/Audio PES)", "PES (Video/Audio/TTX)", "PES (MPEG Audio)", "PES (private stream 1)", "ES (AC-3 Audio)", "ES (MPEG Audio)", "ES (MPEG Video)", "ES (AC-3 Audio) (psb. SMPTE)", "DVB/MPEG2 TS", "ES (DTS Audio)", "ES (DTS Audio) (psb. SMPTE)", "ES (RIFF Audio)", "ES (compressed RIFF Audio)", "ES (Subpicture 2-bit RLE)"};
    String video = " ";
    String audio = " ";
    String addInfo = "";
    String playtime = "";
    String text = "";
    String pics = "";
    XInputFile origFile;
    ArrayList pidlist = new ArrayList();
    boolean hasVideo = false;
    boolean nullpacket = false;
    byte[] vbasic = new byte[12];
    int buffersize = 1024000;
    int filetype = 0;
    DateFormat timeformat = new SimpleDateFormat("HH:mm:ss.SSS");
    ArrayList video_streams;
    ArrayList audio_streams;
    ArrayList ttx_streams;
    ArrayList pic_streams;
    Audio Audio = new Audio();

    public Scan() {
        this.video_streams = new ArrayList();
        this.audio_streams = new ArrayList();
        this.ttx_streams = new ArrayList();
        this.pic_streams = new ArrayList();
    }

    public int inputInt(XInputFile xInputFile) {
        this.filetype = this.testFile(xInputFile, false);
        return this.filetype;
    }

    public String Type(XInputFile xInputFile) {
        this.origFile = xInputFile;
        this.filetype = this.testFile(xInputFile, true);
        return this.type[this.filetype] + this.addInfo;
    }

    public boolean isSupported() {
        return this.filetype != 0;
    }

    public String Date(XInputFile xInputFile) {
        return DateFormat.getDateInstance(1).format(new Date(xInputFile.lastModified())) + "  " + DateFormat.getTimeInstance(1).format(new Date(xInputFile.lastModified()));
    }

    private String readStreams(ArrayList arrayList, String string) {
        string = arrayList.get(0).toString();
        for (int i = 1; i < arrayList.size(); ++i) {
            string = string + "\n\r\t" + arrayList.get(i).toString();
        }
        return string;
    }

    public String getVideo() {
        if (this.video_streams.size() == 0) {
            return this.video;
        }
        return this.readStreams(this.video_streams, this.video);
    }

    public String getAudio() {
        if (this.audio_streams.size() == 0) {
            return this.audio;
        }
        return this.readStreams(this.audio_streams, this.audio);
    }

    public String getText() {
        if (this.ttx_streams.size() == 0) {
            return this.text;
        }
        return this.readStreams(this.ttx_streams, this.text);
    }

    public String getPics() {
        if (this.pic_streams.size() == 0) {
            return this.pics;
        }
        return this.readStreams(this.pic_streams, this.pics);
    }

    public String getPlaytime() {
        return this.playtime;
    }

    public boolean isEditable() {
        if (this.origFile == null) {
            return false;
        }
        return this.origFile.exists() && this.hasVideo;
    }

    public XInputFile getFile() {
        return this.origFile;
    }

    public byte[] getVBasic() {
        return this.vbasic;
    }

    public int AC3Audio(byte[] byArray) {
        block0: for (int i = 0; i < 10000; ++i) {
            if (this.Audio.AC3_parseHeader(byArray, i) < 0) continue;
            for (int j = 0; j < 17; ++j) {
                if (this.Audio.AC3_parseNextHeader(byArray, i + this.Audio.Size + j) != 1) continue;
                if ((0xFF & byArray[i + this.Audio.Size]) > 63 || (0xFF & byArray[i + this.Audio.Size]) == 0) continue block0;
                this.audio_streams.add(this.Audio.AC3_saveAnddisplayHeader());
                return 1;
            }
        }
        return 0;
    }

    public void DTSAudio(byte[] byArray) {
        block0: for (int i = 0; i < 10000; ++i) {
            if (this.Audio.DTS_parseHeader(byArray, i) < 0) continue;
            for (int j = 0; j < 15; ++j) {
                if (this.Audio.DTS_parseNextHeader(byArray, i + this.Audio.Size + j) != 1) continue;
                if ((0xFF & byArray[i + this.Audio.Size]) > 127 || (0xFF & byArray[i + this.Audio.Size]) == 0) continue block0;
                this.audio_streams.add(this.Audio.DTS_saveAnddisplayHeader());
                return;
            }
        }
    }

    public void MPEGAudio(byte[] byArray) {
        for (int i = 0; i < 10000; ++i) {
            if (this.Audio.MPA_parseHeader(byArray, i) < 0 || this.Audio.MPA_parseNextHeader(byArray, i + this.Audio.Size) < 0) continue;
            this.audio_streams.add(this.Audio.MPA_saveAnddisplayHeader());
            return;
        }
    }

    public byte[] loadPES(byte[] byArray, int n) {
        int n2;
        int n3;
        boolean bl;
        int n4;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while (n < byArray.length && (n4 = n + 6 + (!(bl = (0x80 & byArray[n + 6]) == 0) ? 3 + (0xFF & byArray[n + 8]) : 0)) + (n3 = (n2 = (0xFF & byArray[n + 4]) << 8 | 0xFF & byArray[n + 5]) - (!bl ? 3 + (0xFF & byArray[n + 8]) : 0)) <= byArray.length) {
            byteArrayOutputStream.write(byArray, n4, n3);
            n += 6 + n2;
        }
        return byteArrayOutputStream.toByteArray();
    }

    public void loadMPG2(byte[] byArray, int n, boolean bl, boolean bl2, int n2) throws IOException {
        ScanObject scanObject;
        String string;
        int n3;
        this.video = this.msg_1;
        this.audio = this.msg_2;
        Hashtable<String, ScanObject> hashtable = new Hashtable<String, ScanObject>();
        int n4 = 1;
        block7: for (int i = n; i < 500000; i += n4) {
            if (byArray[i] != 0 || byArray[i + 1] != 0 || byArray[i + 2] != 1) {
                n4 = 1;
                continue;
            }
            n3 = 0xFF & byArray[i + 3];
            string = String.valueOf(n3);
            if (n3 == 186) {
                n4 = (0xC0 & byArray[i + 4]) == 0 ? 12 : 14;
                continue;
            }
            if ((0xF0 & n3) == 224) {
                int n5 = n4 = this.nullpacket ? 2048 : 6 + ((0xFF & byArray[i + 4]) << 8 | 0xFF & byArray[i + 5]);
                if (!hashtable.containsKey(string)) {
                    hashtable.put(string, new ScanObject(n3));
                }
                scanObject = (ScanObject)hashtable.get(string);
                scanObject.write(byArray, i + 6 + (!bl2 ? 3 + (0xFF & byArray[i + 8]) : 0), n4 - (!bl2 ? 3 - (0xFF & byArray[i + 8]) : 0));
                continue;
            }
            if ((0xE0 & n3) == 192) {
                n4 = 6 + ((0xFF & byArray[i + 4]) << 8 | 0xFF & byArray[i + 5]);
                if (!hashtable.containsKey(string)) {
                    hashtable.put(string, new ScanObject(n3));
                }
                scanObject = (ScanObject)hashtable.get(string);
                scanObject.write(byArray, i, n4);
                continue;
            }
            if (n3 == 189) {
                boolean bl3;
                n4 = 6 + ((0xFF & byArray[i + 4]) << 8 | 0xFF & byArray[i + 5]);
                int n6 = 0xFF & byArray[i + 8];
                boolean bl4 = bl3 = (4 & byArray[i + 6]) != 0;
                if (n6 == 36 && (0xF0 & byArray[i + 9 + n6]) >>> 4 == 1) {
                    this.text = "SubID 0x" + Integer.toHexString(0xFF & byArray[i + 9 + n6]).toUpperCase();
                    continue;
                }
                if ((!bl2 && !bl || bl && bl3) && ((0xF0 & byArray[i + 9 + n6]) >>> 4 == 2 || (0xF0 & byArray[i + 9 + n6]) >>> 4 == 3)) {
                    this.pics = "SubID 0x" + Integer.toHexString(0xFF & byArray[i + 9 + n6]).toUpperCase();
                    continue;
                }
                if (!bl) {
                    n3 = 0xFF & byArray[i + 9 + n6];
                    string = String.valueOf(n3);
                    byArray[i + 8] = (byte)(4 + n6);
                }
                if (!hashtable.containsKey(string)) {
                    hashtable.put(string, new ScanObject(n3));
                }
                scanObject = (ScanObject)hashtable.get(string);
                scanObject.write(byArray, i, n4);
                continue;
            }
            switch (n3) {
                case 187: 
                case 188: 
                case 190: 
                case 191: 
                case 240: 
                case 241: 
                case 242: 
                case 243: 
                case 244: 
                case 245: 
                case 246: 
                case 247: 
                case 248: 
                case 249: 
                case 250: 
                case 251: 
                case 252: 
                case 253: 
                case 254: 
                case 255: {
                    n4 = 6 + ((0xFF & byArray[i + 4]) << 8 | 0xFF & byArray[i + 5]);
                    continue block7;
                }
                default: {
                    n4 = 1;
                }
            }
        }
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            string = enumeration.nextElement().toString();
            n3 = Integer.parseInt(string);
            scanObject = (ScanObject)hashtable.get(string);
            if ((0xF0 & n3) == 224) {
                try {
                    this.checkVid(scanObject.getData());
                }
                catch (Exception exception) {
                    this.video_streams.add(this.msg_8);
                }
                continue;
            }
            try {
                this.checkPES(scanObject.getData());
            }
            catch (Exception exception) {
                this.audio_streams.add(this.msg_8);
            }
        }
        hashtable.clear();
    }

    public void loadPVA(byte[] byArray, int n) throws IOException {
        ScanObject scanObject;
        String string;
        int n2;
        Hashtable<String, ScanObject> hashtable = new Hashtable<String, ScanObject>();
        while (n < 550000 && n + 8 + (1 & byArray[n + 5] >>> 4) * 4 + (n2 = (0xFF & byArray[n + 6]) << 8 | 0xFF & byArray[n + 7]) <= 700000) {
            int n3 = 0xFF & byArray[n + 2];
            string = String.valueOf(n3);
            if (!hashtable.containsKey(string)) {
                hashtable.put(string, new ScanObject(n3));
            }
            scanObject = (ScanObject)hashtable.get(string);
            switch (n3) {
                case 1: {
                    scanObject.write(byArray, n + 8 + (1 & byArray[n + 5] >>> 4) * 4, n2);
                    break;
                }
                default: {
                    scanObject.write(byArray, n + 8, n2);
                }
            }
            n += 8 + n2;
        }
        this.video = this.msg_1;
        this.audio = this.msg_2;
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            string = enumeration.nextElement().toString();
            scanObject = (ScanObject)hashtable.get(string);
            if (string.equals("1")) {
                try {
                    this.checkVid(scanObject.getData());
                }
                catch (Exception exception) {
                    this.video_streams.add(this.msg_8);
                }
                continue;
            }
            try {
                this.checkPES(scanObject.getData());
            }
            catch (Exception exception) {
                this.audio_streams.add(this.msg_8);
            }
        }
        hashtable.clear();
    }

    public void checkPES(byte[] byArray) {
        this.checkPES(byArray, 0);
    }

    public void checkPES(byte[] byArray, int n) {
        int n2 = n + 8000;
        while (n < n2) {
            int n3;
            if (byArray[n] == 0 && byArray[n + 1] == 0 && byArray[n + 2] == 1 && ((0xE0 & byArray[n + 3]) == 192 || byArray[n + 3] == -67) && byArray[n3 = n + 6 + ((0xFF & byArray[n + 4]) << 8 | 0xFF & byArray[n + 5])] == 0 && byArray[n3 + 1] == 0 && byArray[n3 + 2] == 1) {
                if ((0xE0 & byArray[n + 3]) == 192 && (0xE0 & byArray[n + 3]) == (0xE0 & byArray[n3 + 3])) {
                    this.MPEGAudio(this.loadPES(byArray, n));
                    return;
                }
                if (byArray[n + 3] == -67 && byArray[n + 3] == byArray[n3 + 3]) {
                    byte[] byArray2 = this.loadPES(byArray, n);
                    if (this.AC3Audio(byArray2) < 1) {
                        this.DTSAudio(byArray2);
                    }
                    return;
                }
            }
            ++n;
        }
    }

    public void checkVid(byte[] byArray) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.video = this.msg_7;
        for (int i = 0; i < byArray.length - 630; ++i) {
            if (byArray[i] != 0 || byArray[i + 1] != 0 || byArray[i + 2] != 1 || byArray[i + 3] != -77) continue;
            for (int j = 7; j < 600; ++j) {
                if (byArray[i + j] != 0 || byArray[i + j + 1] != 0 || byArray[i + j + 2] != 1 || byArray[i + j + 3] != -72) continue;
                this.hasVideo = true;
                System.arraycopy(byArray, i, this.vbasic, 0, 12);
                byteArrayOutputStream.write(byArray, i, 20);
                this.video_streams.add(Video.videoformatByte(byteArrayOutputStream.toByteArray()));
                return;
            }
        }
    }

    public void PMTcheck(byte[] byArray, int n) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.video = this.msg_5;
        this.audio = this.msg_5;
        this.text = this.msg_5;
        this.pics = this.msg_5;
        this.pidlist.clear();
        while (n < byArray.length - 1000) {
            if (byArray[n] == 71 && byArray[n + 188] == 71 && byArray[n + 376] == 71) {
                if ((0x30 & byArray[n + 3]) != 16 || byArray[n + 4] != 0 || byArray[n + 5] != 2 || (0xF0 & byArray[n + 6]) != 176) {
                    n += 187;
                } else {
                    int n2;
                    byte[] byArray2;
                    byteArrayOutputStream.write(byArray, n + 4, 184);
                    int n3 = (0x1F & byArray[n + 1]) << 8 | 0xFF & byArray[n + 2];
                    if (byteArrayOutputStream.size() < 188) {
                        n += 188;
                        while (n < byArray.length - 500) {
                            if (byArray[n] == 71 && byArray[n + 188] == 71 && byArray[n + 376] == 71) {
                                if (((0x1F & byArray[n + 1]) << 8 | 0xFF & byArray[n + 2]) != n3 || (0x40 & byArray[n + 1]) != 0 || (0x30 & byArray[n + 3]) != 16) {
                                    n += 187;
                                } else {
                                    byteArrayOutputStream.write(byArray, n + 4, 184);
                                    if (byteArrayOutputStream.size() > 188) break;
                                }
                            }
                            ++n;
                        }
                    }
                    if ((byArray2 = byteArrayOutputStream.toByteArray()).length > 5) {
                        n2 = (0xFF & byArray2[4]) << 8 | 0xFF & byArray2[5];
                        this.pidlist.add("" + n2);
                        this.pidlist.add("" + n3);
                        this.addInfo = this.addInfo + " (SID 0x" + Integer.toHexString(n2).toUpperCase() + " ,PMT 0x" + Integer.toHexString(n3).toUpperCase() + ")";
                    }
                    this.video = "";
                    this.audio = "";
                    this.text = "";
                    this.pics = "";
                    n2 = (0xF & byArray2[2]) << 8 | 0xFF & byArray2[3];
                    int n4 = 8;
                    for (int i = 8; i < n2 - 4 && i < byArray2.length - 6; ++i) {
                        n4 = i;
                        if ((0xE0 & byArray2[i + 1]) != 224) continue;
                        int n5 = (0x1F & byArray2[i + 1]) << 8 | 0xFF & byArray2[i + 2];
                        switch (0xFF & byArray2[i]) {
                            case 1: 
                            case 2: {
                                int n6 = i + 5;
                                i += 4 + (0xFF & byArray2[i + 4]);
                                this.getDescriptor(byArray2, n6, i, n5, 2);
                                this.pidlist.add("" + n5);
                                break;
                            }
                            case 3: 
                            case 4: {
                                int n7 = i + 5;
                                i += 4 + (0xFF & byArray2[i + 4]);
                                this.getDescriptor(byArray2, n7, i, n5, 4);
                                this.pidlist.add("" + n5);
                                break;
                            }
                            case 6: 
                            case 128: 
                            case 129: 
                            case 130: 
                            case 131: {
                                int n8 = i + 5;
                                i += 4 + (0xFF & byArray2[i + 4]);
                                this.getDescriptor(byArray2, n8, i, n5, 6);
                                this.pidlist.add("" + n5);
                                break;
                            }
                            default: {
                                i += 4 + (0xFF & byArray2[i + 4]);
                            }
                        }
                        if (i >= 0) continue;
                        i = n4;
                    }
                    return;
                }
            }
            ++n;
        }
    }

    private void getDescriptor(byte[] byArray, int n, int n2, int n3, int n4) {
        String string = "";
        int n5 = 0;
        try {
            block17: while (n < n2 && n < byArray.length) {
                switch (0xFF & byArray[n]) {
                    case 89: {
                        int n6;
                        int n7;
                        int n8;
                        n4 = 89;
                        n5 = n + 2 + (0xFF & byArray[n + 1]);
                        string = string + "(";
                        for (n8 = n + 2; n8 < n5; n8 += 8) {
                            for (n7 = n8; n7 < n8 + 3; ++n7) {
                                string = string + (char)(0xFF & byArray[n7]);
                            }
                            n7 = 0xFF & byArray[n8 + 3];
                            n6 = (0xFF & byArray[n8 + 4]) << 16 | 0xFF & byArray[n8 + 5];
                            int n9 = (0xFF & byArray[n8 + 6]) << 16 | 0xFF & byArray[n8 + 7];
                            string = string + "_0x" + Integer.toHexString(n7).toUpperCase();
                            string = string + "_p" + n6;
                            string = string + "_a" + n9 + " ";
                        }
                        string = string + ")";
                        break block17;
                    }
                    case 86: {
                        int n6;
                        int n7;
                        int n8;
                        n4 = 86;
                        n5 = n + 2 + (0xFF & byArray[n + 1]);
                        string = string + "(";
                        for (n8 = n + 2; n8 < n5; n8 += 5) {
                            for (n7 = n8; n7 < n8 + 3; ++n7) {
                                string = string + (char)(0xFF & byArray[n7]);
                            }
                            n7 = (0x18 & byArray[n8 + 3]) >>> 3;
                            n6 = 0xFF & byArray[n8 + 4];
                            string = string + "_" + (n7 == 2 ? "s" : "i");
                            string = string + Integer.toHexString((7 & byArray[n8 + 3]) == 0 ? 8 : 7 & byArray[n8 + 3]).toUpperCase();
                            string = string + (n6 < 16 ? "0" : "") + Integer.toHexString(n6).toUpperCase() + " ";
                        }
                        string = string + ")";
                        ++n;
                        n += 0xFF & byArray[n];
                        break;
                    }
                    case 10: {
                        int n8;
                        string = string + "(";
                        for (n8 = n + 2; n8 < n + 5; ++n8) {
                            string = string + (char)(0xFF & byArray[n8]);
                        }
                        string = string + ")";
                        ++n;
                        n += 0xFF & byArray[n];
                        break;
                    }
                    case 106: {
                        string = string + "(AC-3)";
                        ++n;
                        n += 0xFF & byArray[n];
                        break;
                    }
                    case 195: {
                        if ((0xFF & byArray[++n + 1]) == 4) {
                            string = string + "(VPS)";
                            n4 = 195;
                        } else {
                            string = string + "(VBI)";
                        }
                        n += 0xFF & byArray[n];
                        break;
                    }
                    case 82: {
                        n5 = n + 2 + (0xFF & byArray[n + 1]);
                        string = string + "(#" + (0xFF & byArray[n + 2]) + ")";
                        ++n;
                        n += 0xFF & byArray[n];
                        break;
                    }
                    case 5: {
                        int n8;
                        n5 = n + 2 + (0xFF & byArray[n + 1]);
                        string = string + "(";
                        for (n8 = n + 2; n8 < n5; ++n8) {
                            string = string + (char)(0xFF & byArray[n8]);
                        }
                        string = string + ")";
                    }
                    default: {
                        ++n;
                        n += 0xFF & byArray[n];
                    }
                }
                ++n;
            }
            String string2 = "PID: 0x" + Integer.toHexString(n3).toUpperCase();
            switch (n4) {
                case 89: {
                    this.pic_streams.add(string2 + string);
                    break;
                }
                case 86: {
                    this.ttx_streams.add(string2 + string);
                    break;
                }
                case 2: 
                case 195: {
                    this.video_streams.add(string2 + string);
                    break;
                }
                case 4: {
                    this.audio_streams.add(string2 + string);
                    break;
                }
                default: {
                    this.audio_streams.add(string2 + string + "_PD");
                    break;
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.playtime = this.playtime + this.msg_6;
        }
    }

    public int[] getPIDs() {
        int[] nArray = new int[this.pidlist.size()];
        for (int i = 0; i < this.pidlist.size(); ++i) {
            nArray[i] = Integer.parseInt(this.pidlist.get(i).toString());
        }
        return nArray;
    }

    public String getAudioTime(long l) {
        return this.timeformat.format(new Date(l * 8000L / (long)this.Audio.Bitrate));
    }

    public void setBuffer(int n) {
        this.buffersize = n;
    }

    public int testFile(XInputFile xInputFile, boolean bl) {
        long l = xInputFile.length();
        int n = this.testFile(xInputFile, bl, 0L);
        if (n != 0) {
            return n;
        }
        return this.testFile(xInputFile, bl, l / 10L);
    }

    public int testFile(XInputFile xInputFile, boolean bl, long l) {
        this.video_streams.clear();
        this.audio_streams.clear();
        this.ttx_streams.clear();
        this.pic_streams.clear();
        this.video = this.msg_1;
        this.audio = this.msg_2;
        this.text = this.msg_3;
        this.pics = this.msg_4;
        this.addInfo = "";
        this.playtime = "";
        this.hasVideo = false;
        this.nullpacket = false;
        long l2 = 0L;
        this.timeformat.setTimeZone(TimeZone.getTimeZone("GMT+0:00"));
        int n = this.buffersize / 100;
        int n2 = this.buffersize / 50;
        int n3 = this.buffersize / 10;
        int n4 = this.buffersize / 4;
        int n5 = this.buffersize - 65536;
        byte[] byArray = new byte[this.buffersize];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            int n6;
            int n7;
            l2 = xInputFile.length();
            xInputFile.getNewInstance().randomAccessSingleRead(byArray, l);
            for (n7 = 0; n7 < n; ++n7) {
                n6 = this.Audio.WAV_parseHeader(byArray, n7);
                if (n6 <= -1) continue;
                this.Audio.saveHeader();
                if (bl) {
                    this.audio = this.Audio.WAV_displayHeader();
                    this.playtime = this.getAudioTime(l2);
                }
                if (n6 > 0) {
                    return 14;
                }
                if (this.Audio.lMode_extension > 1) break;
                return 15;
            }
            for (n7 = 0; n7 < n; ++n7) {
                if (byArray[n7] != 83 || byArray[n7 + 1] != 80) continue;
                n6 = (0xFF & byArray[n7 + 10]) << 8 | 0xFF & byArray[n7 + 11];
                int n8 = (0xFF & byArray[n7 + 12]) << 8 | 0xFF & byArray[n7 + 13];
                int n9 = (0xFF & byArray[n7 + 12 + n8]) << 8 | 0xFF & byArray[n7 + 13 + n8];
                int n10 = (0xFF & byArray[n7 + 36 + n8]) << 8 | 0xFF & byArray[n7 + 37 + n8];
                if (n8 != n9 - 24 || n9 != n10) continue;
                if (bl) {
                    int n11 = n7 + 14 + n8;
                    int n12 = n11 + 24;
                    block11: for (int i = n11; i < n12; ++i) {
                        switch (0xFF & byArray[i]) {
                            case 1: {
                                ++i;
                                continue block11;
                            }
                            case 2: {
                                i += 24;
                                continue block11;
                            }
                            case 3: 
                            case 4: {
                                i += 2;
                                continue block11;
                            }
                            case 6: {
                                i += 4;
                                continue block11;
                            }
                            case 5: {
                                int n13 = (0xFF & byArray[++i]) << 4 | (0xF0 & byArray[++i]) >>> 4;
                                int n14 = (0xF & byArray[i]) << 8 | 0xFF & byArray[++i];
                                int n15 = (0xFF & byArray[++i]) << 4 | (0xF0 & byArray[++i]) >>> 4;
                                int n16 = (0xF & byArray[i]) << 8 | 0xFF & byArray[++i];
                                this.pics = "up.left x" + n13 + ",y" + n15 + " @ size " + (n14 - n13 + 1) + "*" + (n16 - n15 + 1);
                            }
                        }
                    }
                    byte[] byArray2 = new byte[10 + n6];
                    System.arraycopy(byArray, n7, byArray2, 0, 10 + n6);
                    X.subpicture.picture.decode_picture(byArray2, 10, X.subpicture.isVisible());
                }
                return 16;
            }
            for (n7 = 0; n7 < n5; ++n7) {
                if (byArray[n7] != 71 || byArray[n7 + 188] != 71 || byArray[n7 + 376] != 71 || byArray[n7 + 564] != 71 || byArray[n7 + 752] != 71) continue;
                this.PMTcheck(byArray, n7);
                return 11;
            }
            for (n7 = 0; n7 < n2; ++n7) {
                if (byArray[n7] != 65 || byArray[n7 + 1] != 86 || byArray[n7 + 4] != 85 || byArray[n6 = n7 + 8 + ((0xFF & byArray[n7 + 6]) << 8 | 0xFF & byArray[n7 + 7])] != 65 || byArray[n6 + 1] != 86 || byArray[n6 + 4] != 85) continue;
                if (bl) {
                    this.loadPVA(byArray, n7);
                }
                return 1;
            }
            for (n7 = 0; n7 < n3; ++n7) {
                if (byArray[n7] != 0 || byArray[n7 + 1] != 0 || byArray[n7 + 2] != 1 || byArray[n7 + 3] != -70) continue;
                if ((0xC0 & byArray[n7 + 4]) == 0) {
                    if (bl) {
                        this.loadMPG2(byArray, n7, false, true, n2);
                    }
                    return 2;
                }
                if ((0xC0 & byArray[n7 + 4]) != 64) continue;
                if (bl) {
                    this.loadMPG2(byArray, n7, X.cBox[14].isSelected(), false, n2);
                }
                return 3;
            }
            for (n7 = 0; n7 < n5; ++n7) {
                if (byArray[n7] != 0 || byArray[n7 + 1] != 0 || byArray[n7 + 2] != 1 || (0xF0 & byArray[n7 + 3]) != 224) continue;
                n6 = n7 + 6 + ((0xFF & byArray[n7 + 4]) << 8 | 0xFF & byArray[n7 + 5]);
                if (n6 == n7 + 6 && (0xC0 & byArray[n7 + 6]) == 128 && (0xC0 & byArray[n7 + 8]) == 0) {
                    this.addInfo = this.addInfo + " !!(Vpacketsize=0)";
                    n6 = n7;
                    this.nullpacket = true;
                }
                if (byArray[n6] != 0 || byArray[n6 + 1] != 0 || byArray[n6 + 2] != 1) continue;
                if (bl) {
                    this.loadMPG2(byArray, n7, true, false, n4);
                }
                return 4;
            }
            for (n7 = 0; n7 < n3; ++n7) {
                if (byArray[n7] != 0 || byArray[n7 + 1] != 0 || byArray[n7 + 2] != 1 || (0xE0 & byArray[n7 + 3]) != 192 && (0xFF & byArray[n7 + 3]) != 189 || byArray[n6 = n7 + 6 + ((0xFF & byArray[n7 + 4]) << 8 | 0xFF & byArray[n7 + 5])] != 0 || byArray[n6 + 1] != 0 || byArray[n6 + 2] != 1) continue;
                if ((0xE0 & byArray[n7 + 3]) == 192 && (0xE0 & byArray[n7 + 3]) == (0xE0 & byArray[n6 + 3])) {
                    if (bl) {
                        this.loadMPG2(byArray, n7, true, false, n4);
                    }
                    return 5;
                }
                if ((0xFF & byArray[n7 + 3]) != 189 || byArray[n7 + 3] != byArray[n6 + 3]) continue;
                if (bl) {
                    if (byArray[n7 + 8] == 36 && (0xF0 & byArray[n7 + 9 + 36]) >>> 4 == 1) {
                        this.addInfo = " (TTX)";
                        this.text = "SubID 0x" + Integer.toHexString(0xFF & byArray[n7 + 9 + 36]).toUpperCase();
                    } else {
                        this.loadMPG2(byArray, n7, true, false, n4);
                    }
                }
                return 6;
            }
            block17: for (n7 = 0; n7 < n; ++n7) {
                if (this.Audio.DTS_parseHeader(byArray, n7) > 0) {
                    for (n6 = 0; n6 < 15; ++n6) {
                        if (this.Audio.DTS_parseNextHeader(byArray, n7 + this.Audio.Size + n6) != 1) continue;
                        if ((0xFF & byArray[n7 + this.Audio.Size]) > 127 || (0xFF & byArray[n7 + this.Audio.Size]) == 0) continue block17;
                        if (bl) {
                            this.audio = this.Audio.DTS_saveAnddisplayHeader();
                            this.playtime = this.getAudioTime(l2);
                        }
                        if (n6 == 0) {
                            return 12;
                        }
                        return 13;
                    }
                    if (!X.RButton[7].isSelected()) continue;
                    if (bl) {
                        this.audio = this.Audio.DTS_saveAnddisplayHeader();
                    }
                    this.playtime = this.getAudioTime(l2);
                    return 12;
                }
                if (this.Audio.AC3_parseHeader(byArray, n7) > 0) {
                    for (n6 = 0; n6 < 17; ++n6) {
                        if (this.Audio.AC3_parseNextHeader(byArray, n7 + this.Audio.Size + n6) != 1) continue;
                        if ((0xFF & byArray[n7 + this.Audio.Size]) > 63 || (0xFF & byArray[n7 + this.Audio.Size]) == 0) continue block17;
                        if (bl) {
                            this.audio = this.Audio.AC3_saveAnddisplayHeader();
                            this.playtime = this.getAudioTime(l2);
                        }
                        if (n6 == 0) {
                            return 7;
                        }
                        return 10;
                    }
                    if (!X.RButton[7].isSelected()) continue;
                    if (bl) {
                        this.audio = this.Audio.AC3_saveAnddisplayHeader();
                    }
                    this.playtime = this.getAudioTime(l2);
                    return 7;
                }
                if (this.Audio.MPA_parseHeader(byArray, n7) <= 0 || !X.RButton[7].isSelected() && this.Audio.MPA_parseNextHeader(byArray, n7 + this.Audio.Size) < 0) continue;
                if (bl) {
                    this.audio = this.Audio.MPA_saveAnddisplayHeader();
                    this.playtime = this.getAudioTime(l2);
                }
                return 8;
            }
            for (n7 = 0; n7 < n4; ++n7) {
                if (byArray[n7] != 0 || byArray[n7 + 1] != 0 || byArray[n7 + 2] != 1) continue;
                if (byArray[n7 + 3] == -77) {
                    for (n6 = 7; n6 < 600; ++n6) {
                        if (byArray[n7 + n6] != 0 || byArray[n7 + n6 + 1] != 0 || byArray[n7 + n6 + 2] != 1 || byArray[n7 + n6 + 3] != -72) continue;
                        if (bl) {
                            this.hasVideo = true;
                            System.arraycopy(byArray, n7, this.vbasic, 0, 12);
                            byteArrayOutputStream.write(byArray, n7, 20);
                            this.video_streams.add(Video.videoformatByte(byteArrayOutputStream.toByteArray()));
                        }
                        return 9;
                    }
                    continue;
                }
                if (byArray[n7 + 3] != -72) continue;
                for (n6 = 6; n6 < 20; ++n6) {
                    if (byArray[n7 + n6] != 0 || byArray[n7 + n6 + 1] != 0 || byArray[n7 + n6 + 2] != 1 || byArray[n7 + n6 + 3] != 0) continue;
                    if (bl) {
                        this.video = this.msg_9;
                    }
                    return 9;
                }
            }
        }
        catch (IOException iOException) {
            this.playtime = this.msg_8;
        }
        byArray = null;
        System.gc();
        return 0;
    }

    class ScanObject {
        private ByteArrayOutputStream buf = new ByteArrayOutputStream();
        private int id;
        private int type;

        private ScanObject() {
            this.id = 0;
        }

        private ScanObject(int n) {
            this.id = n;
        }

        private int getType() {
            return this.type;
        }

        private void write(byte[] byArray) throws IOException {
            this.buf.write(byArray);
        }

        private void write(byte[] byArray, int n, int n2) throws IOException {
            this.buf.write(byArray, n, n2);
        }

        private byte[] getData() throws IOException {
            this.buf.flush();
            return this.buf.toByteArray();
        }

        private void reset() {
            this.buf.reset();
        }
    }
}

