/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.dvb.projectx.io;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import net.sourceforge.dvb.projectx.common.Common;

public class IDDBufferedOutputStream
extends BufferedOutputStream {
    long pos = 0L;
    int type = 0;
    String name = "";
    String chaptersname = "";
    boolean sequenceend = false;
    boolean chapters = false;
    byte[][] IddHeader = new byte[][]{{105, 100, 100, 2}, {105, 100, 100, 3}};
    BufferedOutputStream IddOut = null;
    PrintWriter ChaptersOut = null;
    int filenumber = 1;

    public IDDBufferedOutputStream(OutputStream outputStream) {
        super(outputStream);
    }

    public IDDBufferedOutputStream(OutputStream outputStream, int n) {
        super(outputStream, n);
    }

    public synchronized void write(byte[] byArray, int n, int n2) throws IOException {
        block0 : switch (this.type) {
            case 3: {
                if ((0xF0 & byArray[n + 3]) != 224) break;
                for (int i = n + 9 + (0xFF & byArray[8]); i < n + n2 - 3; ++i) {
                    int n3;
                    if (byArray[i] != 0 || byArray[i + 1] != 0 || byArray[i + 2] != 1 || byArray[i + 3] != 0) continue;
                    if (i + 5 >= n + n2 || (n3 = 7 & byArray[i + 5] >>> 3) == 0 || n3 > 3) break block0;
                    this.IddOut.write(this.VdrIndex());
                    this.IddOut.write(n3);
                    this.IddOut.write(this.filenumber);
                    this.IddOut.write(new byte[2]);
                    break block0;
                }
                break;
            }
            case 1: {
                for (int i = n; i < n + n2 - 3; ++i) {
                    if (byArray[i] != 0 || byArray[i + 1] != 0 || byArray[i + 2] != 1) continue;
                    if ((0xFF & byArray[i + 3]) == 179) {
                        this.IddOut.write(179);
                        this.IddOut.write(this.littleEndian(i - n));
                        i += 12;
                        continue;
                    }
                    if ((0xFF & byArray[i + 3]) == 183) {
                        this.IddOut.write(183);
                        this.IddOut.write(this.littleEndian(i - n));
                        this.sequenceend = true;
                        i += 3;
                        continue;
                    }
                    if ((0xFF & byArray[i + 3]) == 184) {
                        this.IddOut.write(184);
                        this.IddOut.write(this.littleEndian(i - n));
                        i += 7;
                        continue;
                    }
                    if (byArray[i + 3] != 0) continue;
                    this.IddOut.write(0);
                    this.IddOut.write(this.littleEndian(i - n));
                    int n4 = 3 & byArray[i + 5] >>> 6 | (0xFF & byArray[i + 4]) << 2;
                    this.IddOut.write(0xFF & n4);
                    this.IddOut.write(n4 >>> 8);
                    this.IddOut.write(7 & byArray[i + 5] >>> 3);
                    i += 8;
                }
                break;
            }
            case 2: {
                if (this.pos == 0L && byArray.length <= 80) break;
                this.IddOut.write(this.littleEndian(0));
            }
        }
        super.write(byArray, n, n2);
        this.pos += (long)n2;
    }

    public synchronized void write(int n) throws IOException {
        super.write(n);
        ++this.pos;
    }

    public byte[] VdrIndex() {
        byte[] byArray = new byte[4];
        for (int i = 0; i < 4; ++i) {
            byArray[i] = (byte)(0xFFL & this.pos >>> i * 8);
        }
        return byArray;
    }

    public void InitVdr(String string, int n) throws IOException {
        this.name = string;
        this.filenumber = n + 1;
        this.type = 3;
        this.IddOut = new BufferedOutputStream(new FileOutputStream(this.name, this.filenumber != 1), 655350);
    }

    public String renameVdrTo(String string, String string2) {
        String string3 = "000" + this.filenumber + ".vdr";
        String string4 = string + string3.substring(string3.length() - 7);
        File file = new File(string4);
        File file2 = new File(string2);
        if (!file2.getName().equals(file.getName()) && file.exists()) {
            file.delete();
        }
        Common.renameTo(file2, file);
        return string4;
    }

    public byte[] littleEndian(int n) {
        byte[] byArray = new byte[8];
        for (int i = 0; i < 8; ++i) {
            byArray[i] = (byte)(0xFFL & this.pos + (long)n >>> i * 8);
        }
        return byArray;
    }

    public void InitIdd(String string, int n) throws IOException {
        this.name = string + ".id";
        this.type = n;
        this.IddOut = new BufferedOutputStream(new FileOutputStream(this.name), 655350);
        this.IddOut.write(this.IddHeader[this.type - 1]);
    }

    public void renameIddTo(File file) {
        String string = file.toString();
        File file2 = new File(string + ".idd");
        File file3 = new File(string + ".m2s.txt");
        if (file.exists()) {
            if (file2.exists()) {
                file2.delete();
            }
            if (new File(this.name).exists()) {
                Common.renameTo(new File(this.name), file2);
            }
        } else {
            new File(this.name).delete();
        }
        if (this.chapters) {
            if (file3.exists()) {
                file3.delete();
            }
            if (new File(this.chaptersname).exists()) {
                Common.renameTo(new File(this.chaptersname), file3);
            }
        }
    }

    public void renameVideoIddTo(String string) {
        File file = new File(string + ".idd");
        if (file.exists()) {
            file.delete();
        }
        Common.renameTo(new File(this.name), file);
    }

    public void deleteIdd() {
        new File(this.name).delete();
        new File(this.chaptersname).delete();
    }

    public void InitChapters(String string) throws IOException {
        this.chaptersname = string + ".chp";
        this.chapters = true;
        this.ChaptersOut = new PrintWriter(new FileOutputStream(this.chaptersname));
    }

    public void addChapter(String string) throws IOException {
        if (!this.chapters) {
            return;
        }
        this.ChaptersOut.println(string);
    }

    public synchronized void close() throws IOException {
        if (this.chapters) {
            this.ChaptersOut.flush();
            this.ChaptersOut.close();
        }
        switch (this.type) {
            case 1: {
                if (!this.sequenceend) {
                    this.IddOut.write(183);
                    this.IddOut.write(this.littleEndian(0));
                }
                this.IddOut.flush();
                this.IddOut.close();
                break;
            }
            case 2: {
                this.IddOut.write(this.littleEndian(0));
            }
            case 3: {
                this.IddOut.flush();
                this.IddOut.close();
            }
        }
        super.close();
    }
}

