/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.dvb.projectx.gui;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import net.sourceforge.dvb.projectx.common.Resource;
import net.sourceforge.dvb.projectx.common.X;

public class StartUp
extends JFrame {
    private static final Color BACKGROUND_COLOR = new Color(224, 224, 224, 224);
    boolean agreement = false;
    JRadioButton disagree;
    JRadioButton agree;
    Listener listener = new Listener();

    public StartUp() {
        this.open(Resource.getString("startup.title"));
    }

    public StartUp(String string) {
        this.open(string);
    }

    protected void open(String string) {
        this.setTitle(string);
        JPanel jPanel = new JPanel();
        jPanel.setBackground(BACKGROUND_COLOR);
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        String[] stringArray = Resource.getStringByLines("terms");
        for (int i = 0; i < stringArray.length; ++i) {
            jPanel.add(new JLabel(stringArray[i]));
        }
        this.disagree = new JRadioButton(Resource.getString("terms.disagree"));
        this.disagree.setActionCommand("disagree");
        this.disagree.setOpaque(false);
        this.agree = new JRadioButton(Resource.getString("terms.agree"));
        this.agree.setActionCommand("agree");
        this.agree.setOpaque(false);
        this.agree.setEnabled(false);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.disagree);
        buttonGroup.add(this.agree);
        jPanel.add(this.disagree);
        jPanel.add(this.agree);
        this.disagree.addActionListener(this.listener);
        this.agree.addActionListener(this.listener);
        JPanel jPanel2 = new JPanel();
        jPanel2.setBackground(BACKGROUND_COLOR);
        jPanel2.setBorder(BorderFactory.createRaisedBevelBorder());
        jPanel2.add(jPanel);
        this.getContentPane().add(jPanel2);
        if (!X.CLI_mode) {
            this.pack();
        }
        this.setLocation(200, 200);
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
    }

    public void set(boolean bl) {
        this.agree.setEnabled(!bl);
        this.agreement = bl;
        this.agree.setSelected(bl);
        if (bl) {
            this.agree.setForeground(Color.green);
        }
    }

    public boolean get() {
        return this.agree.isSelected();
    }

    public void close() {
        this.dispose();
    }

    class Listener
    implements ActionListener {
        Listener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("agree")) {
                if (!StartUp.this.agree.isEnabled()) {
                    return;
                }
                StartUp.this.setVisible(false);
                X.setButton(1, true);
                X.setVisible0(true);
            } else if (string.equals("disagree")) {
                System.exit(0);
            }
        }
    }
}

