/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.dvb.projectx.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;

public class BRMonitor
extends JPanel {
    public Surface surf;

    public BRMonitor() {
        this.setLayout(new BorderLayout());
        this.setVisible(true);
        this.surf = new Surface();
        this.add(this.surf);
    }

    public class Surface
    extends JPanel
    implements Runnable {
        public Thread thread;
        public long sleepAmount = 10000L;
        private int w;
        private int h;
        private BufferedImage bimg;
        private Graphics2D big;
        private Font font = new Font("Times New Roman", 0, 11);
        private int columnInc;
        private int[] pts;
        private int ptNum;
        private int ascent;
        private int descent;
        private int bitrate;
        private int maxbitrate = 0;
        private int minbitrate = 37500;
        private Rectangle graphOutlineRect = new Rectangle();
        private Color graphColor = new Color(46, 139, 87);
        private String usedStr;
        private String timeStr = "00:00:00";
        private boolean first = true;
        private boolean greatgop = false;
        private Color[] GOP = new Color[]{Color.black, Color.cyan, Color.magenta, Color.white, Color.green, Color.red, Color.red, Color.red, Color.yellow};
        private byte[] frame = new byte[0];

        public Surface() {
            this.setBackground(Color.black);
            this.setVisible(true);
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        public Dimension getPreferredSize() {
            return new Dimension(54, 72);
        }

        public void paint(Graphics graphics) {
            if (this.big == null) {
                return;
            }
            graphics.drawImage(this.bimg, 0, 0, this);
        }

        public void refresh() {
            int n;
            int n2;
            int n3;
            if (this.big == null) {
                return;
            }
            this.big.setBackground(this.getBackground());
            this.big.clearRect(0, 0, this.w, this.h);
            this.big.setColor(Color.white);
            this.usedStr = String.valueOf(this.bitrate * 400 / 1000) + "kbps ";
            this.big.drawString(this.usedStr, 4, this.h - this.descent - 10 - this.descent);
            this.big.drawString(this.timeStr, 4, this.h - this.descent);
            this.big.setColor(this.graphColor);
            int n4 = 2;
            int n5 = 2;
            int n6 = this.w - n4 - 2;
            int n7 = this.h - this.descent - 34;
            this.graphOutlineRect.setRect(n4, n5, n6, n7);
            this.big.draw(this.graphOutlineRect);
            int n8 = n7 / 5;
            for (n3 = n5; n3 <= n7 + n5; n3 += n8) {
                this.big.drawLine(n4, n3, n4 + n6, n3);
            }
            n3 = n6 / 5;
            for (n2 = n4; n2 < n6 + n4; n2 += n3) {
                this.big.drawLine(n2, n5, n2, n5 + n7);
            }
            this.big.setColor(Color.red);
            this.big.drawLine(2, 5, 52, 5);
            this.big.setColor(Color.magenta);
            this.big.drawLine(2, 28, 52, 28);
            this.big.setColor(Color.white);
            this.big.drawLine(52, n5 + n7 - this.maxbitrate / 695, 56, n5 + n7 - this.maxbitrate / 695);
            this.big.drawLine(52, n5 + n7 - this.minbitrate / 695, 56, n5 + n7 - this.minbitrate / 695);
            n2 = this.frame.length > 17 ? 17 : this.frame.length;
            for (n = 0; n < n2; ++n) {
                this.big.setColor(this.GOP[0xF & this.frame[n]]);
                if ((0x80 & this.frame[n]) != 0) {
                    this.big.fillRect(2 + n * 3, 40, 2, 5);
                    continue;
                }
                this.big.fillRect(2 + n * 3, 40, 2, 2);
                this.big.fillRect(2 + n * 3, 43, 2, 2);
            }
            if (this.frame.length > 16) {
                this.greatgop = true;
            }
            if (this.greatgop) {
                this.big.setColor(Color.red);
                this.big.fillRect(52, 40, 2, 5);
            }
            if (this.pts == null) {
                this.pts = new int[n6];
                this.ptNum = 0;
            } else {
                this.big.setColor(Color.yellow);
                this.pts[this.ptNum] = n5 + n7 - this.bitrate / 695;
                if (this.pts[this.ptNum] < 1) {
                    this.pts[this.ptNum] = 0;
                }
                n = n4 + n6 - this.ptNum;
                int n9 = 0;
                while (n9 < this.ptNum) {
                    if (n9 != 0) {
                        if (this.pts[n9] != this.pts[n9 - 1]) {
                            this.big.drawLine(n - 1, this.pts[n9 - 1], n, this.pts[n9]);
                        } else {
                            this.big.fillRect(n, this.pts[n9], 1, 1);
                        }
                    }
                    ++n9;
                    ++n;
                }
                if (this.ptNum + 2 == this.pts.length) {
                    for (n = 1; n < this.ptNum; ++n) {
                        this.pts[n - 1] = this.pts[n];
                    }
                    --this.ptNum;
                } else {
                    ++this.ptNum;
                }
            }
        }

        public void start() {
            this.greatgop = false;
            this.maxbitrate = 0;
            this.minbitrate = 37500;
            this.timeStr = "00:00:00";
            this.bitrate = 0;
            this.frame = new byte[0];
            this.thread = new Thread(this);
            this.thread.setPriority(1);
            this.thread.setName("BRMonitor");
            this.thread.start();
        }

        public synchronized void stop() {
            this.thread = null;
            this.notify();
        }

        public void update(int n, byte[] byArray, String string) {
            this.bitrate = n;
            if (this.bitrate > this.maxbitrate) {
                this.maxbitrate = this.bitrate;
            }
            if (this.bitrate < this.minbitrate) {
                this.minbitrate = this.bitrate;
            }
            this.timeStr = string;
            this.frame = byArray;
            this.refresh();
            this.repaint();
        }

        public void run() {
            Thread thread = Thread.currentThread();
            while (this.thread == thread) {
                Dimension dimension = this.getSize();
                if (dimension.width != this.w || dimension.height != this.h) {
                    this.w = dimension.width;
                    this.h = dimension.height;
                    this.bimg = (BufferedImage)this.createImage(this.w, this.h);
                    this.big = this.bimg.createGraphics();
                    this.big.setFont(this.font);
                    FontMetrics fontMetrics = this.big.getFontMetrics(this.font);
                    this.ascent = fontMetrics.getAscent();
                    this.descent = fontMetrics.getDescent();
                }
                if (this.first) {
                    this.refresh();
                    this.repaint();
                    this.first = false;
                }
                try {
                    Thread.sleep(this.sleepAmount);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                    break;
                }
            }
            this.thread = null;
        }
    }
}

