/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.dvb.projectx.common;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.JarURLConnection;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;

public class Resource {
    private static final String PJX_RESOURCE_PREFIX = "pjxresources";
    public static final String workdir = System.getProperty("user.dir");
    public static final String filesep = System.getProperty("file.separator");
    private static Locale locale = null;
    private static ResourceBundle defaultResource = null;
    private static ResourceBundle resource = null;
    static /* synthetic */ Class class$net$sourceforge$dvb$projectx$common$Resource;

    private static ResourceBundle loadResourceBundle(Locale locale) throws MissingResourceException {
        Serializable serializable;
        PropertyResourceBundle propertyResourceBundle = null;
        String string = "pjxresources_" + locale.getLanguage() + ".properties";
        try {
            serializable = new File(workdir + filesep + string);
            if (((File)serializable).exists() && ((File)serializable).canRead()) {
                propertyResourceBundle = new PropertyResourceBundle(new FileInputStream((File)serializable));
                return propertyResourceBundle;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            serializable = (class$net$sourceforge$dvb$projectx$common$Resource == null ? (class$net$sourceforge$dvb$projectx$common$Resource = Resource.class$("net.sourceforge.dvb.projectx.common.Resource")) : class$net$sourceforge$dvb$projectx$common$Resource).getClassLoader().getResource(string);
            propertyResourceBundle = new PropertyResourceBundle(((URL)serializable).openStream());
        }
        catch (Exception exception) {
            throw new MissingResourceException("couldn't find " + string, (class$net$sourceforge$dvb$projectx$common$Resource == null ? (class$net$sourceforge$dvb$projectx$common$Resource = Resource.class$("net.sourceforge.dvb.projectx.common.Resource")) : class$net$sourceforge$dvb$projectx$common$Resource).getName(), string);
        }
        return propertyResourceBundle;
    }

    private Resource() {
    }

    public static void loadLang(String string) {
        try {
            if (new File(string).exists()) {
                BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
                String string2 = null;
                while ((string2 = bufferedReader.readLine()) != null) {
                    if (!string2.startsWith("lang=")) continue;
                    String string3 = string2.substring(5);
                    locale = new Locale(string3, "");
                    try {
                        resource = Resource.loadResourceBundle(locale);
                        break;
                    }
                    catch (MissingResourceException missingResourceException) {
                        resource = defaultResource;
                        break;
                    }
                }
                bufferedReader.close();
            }
        }
        catch (IOException iOException) {
            System.out.println(resource.getString("msg.loadlang.error") + " " + iOException);
        }
    }

    public static void saveLang(PrintWriter printWriter) {
        if (locale != null) {
            printWriter.println("// language");
            printWriter.println("lang=" + locale);
        }
    }

    public static String getString(String string) {
        String string2 = null;
        try {
            string2 = resource.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            try {
                string2 = defaultResource.getString(string);
            }
            catch (MissingResourceException missingResourceException2) {
                System.out.println("ResourceKey '" + string + "' not found in pjxresources");
            }
        }
        if (string2 == null) {
            string2 = "?" + string + "?";
        }
        return string2;
    }

    public static String[] getStringByLines(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(Resource.getString(string), "\n");
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        return arrayList.toArray(new String[0]);
    }

    public static String getString(String string, Object[] objectArray) {
        return MessageFormat.format(Resource.getString(string), objectArray);
    }

    public static String getString(String string, Object object) {
        return MessageFormat.format(Resource.getString(string), object);
    }

    public static String getString(String string, Object object, Object object2) {
        return MessageFormat.format(Resource.getString(string), object, object2);
    }

    public static String getString(String string, Object object, Object object2, Object object3) {
        return MessageFormat.format(Resource.getString(string), object, object2, object3);
    }

    public static String getString(String string, Object object, Object object2, Object object3, Object object4) {
        return MessageFormat.format(Resource.getString(string), object, object2, object3, object4);
    }

    public static String getString(String string, Object object, Object object2, Object object3, Object object4, Object object5) {
        return MessageFormat.format(Resource.getString(string), object, object2, object3, object4, object5);
    }

    public static final void localize(AbstractButton abstractButton, String string) {
        String string2 = Resource.getString(string);
        int n = string2.indexOf(38);
        if (n != -1) {
            char c = string2.charAt(n + 1);
            abstractButton.setMnemonic(c);
            string2 = string2.substring(0, n) + string2.substring(n + 1);
        }
        abstractButton.setText(string2);
    }

    public static JMenu buildLanguageMenu() {
        LangListener langListener = new LangListener();
        JMenu jMenu = new JMenu();
        Resource.localize(jMenu, "language.menu");
        ButtonGroup buttonGroup = new ButtonGroup();
        JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem();
        Resource.localize(jRadioButtonMenuItem, "language.system");
        jRadioButtonMenuItem.addActionListener(langListener);
        jRadioButtonMenuItem.setSelected(locale == null);
        jRadioButtonMenuItem.setActionCommand("system");
        jMenu.add(jRadioButtonMenuItem);
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu.addSeparator();
        Locale[] localeArray = Resource.getAvailableLocales();
        for (int i = 0; i < localeArray.length; ++i) {
            Locale locale = localeArray[i];
            JRadioButtonMenuItem jRadioButtonMenuItem2 = new JRadioButtonMenuItem(locale.getLanguage());
            jRadioButtonMenuItem2.addActionListener(langListener);
            if (Resource.locale != null) {
                jRadioButtonMenuItem2.setSelected(locale.getLanguage().equals(Resource.locale.getLanguage()));
            }
            jRadioButtonMenuItem2.setActionCommand(locale.getLanguage());
            jMenu.add(jRadioButtonMenuItem2);
            buttonGroup.add(jRadioButtonMenuItem2);
        }
        return jMenu;
    }

    private static Locale[] getAvailableLocales() {
        HashSet hashSet = new HashSet();
        String string = Locale.getDefault().getLanguage();
        try {
            Object object;
            URL uRL = ClassLoader.getSystemResource("pjxresources_en.properties");
            if (uRL != null) {
                object = null;
                object = uRL.openConnection();
                if (object != null && object instanceof JarURLConnection) {
                    JarURLConnection jarURLConnection = (JarURLConnection)object;
                    Resource.addAvailableLocalesFromJar(hashSet, jarURLConnection);
                } else {
                    File file = new File(uRL.getFile());
                    File file2 = file.getParentFile();
                    Resource.addAvailableLocalesFromFileSystem(hashSet, file2);
                }
            } else {
                System.err.println("Couldn't find \"pjxresources\"*.properties");
            }
            object = new File(workdir);
            Resource.addAvailableLocalesFromFileSystem(hashSet, (File)object);
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
        return hashSet.toArray(new Locale[0]);
    }

    private static void addAvailableLocalesFromFileSystem(Set set, File file) {
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                File file2 = fileArray[i];
                if (!file2.isFile() || !file2.getName().startsWith(PJX_RESOURCE_PREFIX)) continue;
                try {
                    String string = file2.getName();
                    int n = string.indexOf(95);
                    if (n != -1) {
                        string = string.substring(n + 1);
                    }
                    if ((n = string.indexOf(46)) != -1) {
                        string = string.substring(0, n);
                    }
                    Locale locale = new Locale(string, "");
                    set.add(locale);
                    continue;
                }
                catch (Exception exception) {
                    System.out.println(exception);
                }
            }
        }
    }

    private static void addAvailableLocalesFromJar(Set set, JarURLConnection jarURLConnection) {
        JarFile jarFile = null;
        try {
            jarFile = jarURLConnection.getJarFile();
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
        if (jarFile != null) {
            Enumeration<JarEntry> enumeration = jarFile.entries();
            while (enumeration.hasMoreElements()) {
                JarEntry jarEntry = enumeration.nextElement();
                String string = jarEntry.getName();
                if (!string.startsWith(PJX_RESOURCE_PREFIX)) continue;
                String string2 = string.substring(0, string.length() - ".properties".length());
                int n = string2.indexOf(95);
                if (n != -1) {
                    string2 = string2.substring(n + 1);
                }
                if ((n = string2.indexOf(46)) != -1) {
                    string2 = string2.substring(0, n);
                }
                Locale locale = new Locale(string2, "");
                set.add(locale);
            }
        }
    }

    public static URL getResourceURL(String string) {
        try {
            String string2 = workdir + filesep + string;
            File file = new File(string2);
            if (file.exists() && file.canRead()) {
                return file.toURL();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        string = string.replace('\\', '/');
        return (class$net$sourceforge$dvb$projectx$common$Resource == null ? (class$net$sourceforge$dvb$projectx$common$Resource = Resource.class$("net.sourceforge.dvb.projectx.common.Resource")) : class$net$sourceforge$dvb$projectx$common$Resource).getClassLoader().getResource(string);
    }

    public static URL getLocalizedResourceURL(String string, String string2) {
        Locale locale = null;
        locale = Resource.locale != null ? Resource.locale : Locale.getDefault();
        String string3 = string + filesep + locale.getLanguage() + filesep + string2;
        URL uRL = Resource.getResourceURL(string3);
        if (uRL != null) {
            return uRL;
        }
        return Resource.getResourceURL(string + filesep + string2);
    }

    public static ImageIcon loadIcon(String string) {
        return new ImageIcon(Resource.getResourceURL(string));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        defaultResource = Resource.loadResourceBundle(Locale.ENGLISH);
        try {
            resource = Resource.loadResourceBundle(Locale.getDefault());
        }
        catch (MissingResourceException missingResourceException) {
            resource = defaultResource;
        }
    }

    private static class LangListener
    implements ActionListener {
        private LangListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("system")) {
                Resource.locale = null;
            } else {
                Resource.locale = new Locale(string, "", "");
            }
            JOptionPane.showMessageDialog(null, Resource.getString("msg.new.language"), Resource.getString("msg.infomessage"), 1);
        }
    }
}

