/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.dvb.projectx.common;

import java.awt.Color;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.TimeZone;
import javax.swing.JOptionPane;
import net.sourceforge.dvb.projectx.audio.Audio;
import net.sourceforge.dvb.projectx.common.Resource;
import net.sourceforge.dvb.projectx.common.X;

public final class Common {
    private static final String COLOUR_TABLES_FILENAME = "colours.tbl";
    private static final String AC3_FILENAME = "ac3.bin";
    private static ArrayList AC3list = new ArrayList();
    private static DateFormat time_format_1 = new SimpleDateFormat("HH:mm:ss.SSS");
    private static DateFormat time_format_2 = new SimpleDateFormat("HH:mm:ss:SSS");
    public static final int Unsupported = 0;
    public static final int PVA_TYPE = 1;
    public static final int MPEG1PS_TYPE = 2;
    public static final int MPEG2PS_TYPE = 3;
    public static final int PES_AV_TYPE = 4;
    public static final int PES_MPA_TYPE = 5;
    public static final int PES_PS1_TYPE = 6;
    public static final int ES_AC3_TYPE = 7;
    public static final int ES_MPA_TYPE = 8;
    public static final int ES_MPV_TYPE = 9;
    public static final int ES_AC3_A_TYPE = 10;
    public static final int TS_TYPE = 11;
    public static final int ES_DTS_TYPE = 12;
    public static final int ES_DTS_A_TYPE = 13;
    public static final int ES_RIFF_TYPE = 14;
    public static final int ES_cRIFF_TYPE = 15;
    public static final int ES_SUP_TYPE = 16;
    private static String ftp_server = "192.168.0.5";
    private static String ftp_port = "21";
    private static String ftp_user = "root";
    private static String ftp_password = "dreambox";
    private static String ftp_directory = "/hdd/movie";
    private static String ftp_command = "";

    private Common() {
    }

    public static boolean renameTo(File file, File file2) {
        for (int i = 0; i < 10000; ++i) {
            if (!file.renameTo(file2)) continue;
            return true;
        }
        X.Msg(Resource.getString("common.rename_error1") + " " + file.toString() + " " + Resource.getString("common.rename_error2") + " " + file2.toString(), true);
        X.TextArea.setBackground(new Color(255, 225, 225));
        return false;
    }

    public static boolean renameTo(String string, String string2) {
        return Common.renameTo(new File(string), new File(string2));
    }

    public static int nextBits(byte[] byArray, int n, int n2) {
        int n3 = n >>> 3;
        int n4 = (0xFF & byArray[n3]) << 24 | (0xFF & byArray[n3 + 1]) << 16 | (0xFF & byArray[n3 + 2]) << 8 | 0xFF & byArray[n3 + 3];
        n4 <<= n & 7;
        return n4 >>>= 32 - n2;
    }

    public static String adaptString(int n, int n2) {
        return Common.adaptString(String.valueOf(n), n2);
    }

    public static String adaptString(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer(string.trim());
        while (stringBuffer.length() < n) {
            stringBuffer.insert(0, "0");
        }
        return stringBuffer.toString();
    }

    public static String formatTime_1(long l) {
        time_format_1.setTimeZone(TimeZone.getTimeZone("GMT+0:00"));
        return time_format_1.format(new Date(l));
    }

    public static String formatTime_2(long l, long l2) {
        time_format_2.setTimeZone(TimeZone.getTimeZone("GMT+0:00"));
        String string = time_format_2.format(new Date(l));
        return string.substring(0, string.length() - 3) + Common.adaptString(Integer.parseInt(string.substring(string.length() - 3)) * 90 / (int)l2, 2);
    }

    public static Object[] checkUserColourTable() throws IOException {
        String string;
        URL uRL = Resource.getResourceURL(COLOUR_TABLES_FILENAME);
        if (uRL == null) {
            return null;
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
        ArrayList<String> arrayList = new ArrayList<String>();
        while ((string = bufferedReader.readLine()) != null) {
            if (string.trim().length() == 0 || !string.startsWith("table")) continue;
            arrayList.add(string.substring(string.indexOf("=") + 1).trim());
        }
        bufferedReader.close();
        return arrayList.toArray();
    }

    public static Hashtable getUserColourTable(String string) throws IOException {
        String string2;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        URL uRL = Resource.getResourceURL(COLOUR_TABLES_FILENAME);
        if (uRL == null) {
            return hashtable;
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
        boolean bl = false;
        while ((string2 = bufferedReader.readLine()) != null) {
            if (string2.trim().length() == 0) continue;
            if (string2.startsWith("table")) {
                bl = string2.substring(string2.indexOf("=") + 1).trim().equals(string);
                continue;
            }
            if (!bl) continue;
            if (string2.startsWith("model")) {
                hashtable.put("model", string2.substring(string2.indexOf("=") + 1).trim());
                continue;
            }
            hashtable.put(string2.substring(0, string2.indexOf("=")).trim(), string2.substring(string2.indexOf("=") + 1).trim());
        }
        bufferedReader.close();
        if (!hashtable.isEmpty() && !hashtable.containsKey("model")) {
            hashtable.put("model", "16");
        }
        return hashtable;
    }

    public static void loadAC3() {
        Audio audio = new Audio();
        AC3list.clear();
        try {
            URL uRL = Resource.getResourceURL(AC3_FILENAME);
            if (uRL != null) {
                BufferedInputStream bufferedInputStream = new BufferedInputStream(uRL.openStream());
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                byte[] byArray = new byte[1024];
                int n = -1;
                while ((n = bufferedInputStream.read(byArray, 0, byArray.length)) != -1) {
                    byteArrayOutputStream.write(byArray, 0, n);
                }
                byte[] byArray2 = byteArrayOutputStream.toByteArray();
                X.TextArea.append("\r\n\n" + Resource.getString("ac3.msg.loading.start"));
                int n2 = 0;
                int n3 = 0;
                while (n2 < byArray2.length) {
                    audio.AC3_parseHeader(byArray2, n2);
                    X.TextArea.append("\r\n(" + n3 + ") " + audio.AC3_saveAnddisplayHeader());
                    byte[] byArray3 = new byte[audio.Size];
                    System.arraycopy(byArray2, n2, byArray3, 0, audio.Size);
                    AC3list.add(byArray3);
                    n2 += audio.Size;
                    ++n3;
                }
                byArray2 = null;
            }
        }
        catch (IOException iOException) {
            X.TextArea.append("\r\n" + Resource.getString("ac3.msg.loading.error"));
            AC3list.clear();
        }
        if (AC3list.size() > 0) {
            X.TextArea.append("\r\n" + Resource.getString("ac3.msg.frames", "" + AC3list.size()));
        }
    }

    public static ArrayList getAC3list() {
        return AC3list;
    }

    public static void checkVersion() {
        try {
            String string;
            URL uRL = new URL("http://project-x.sourceforge.net/update/update.txt");
            URLConnection uRLConnection = uRL.openConnection();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
            String string2 = string = bufferedReader.readLine();
            String string3 = null;
            if (string != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
                if (stringTokenizer.hasMoreTokens()) {
                    string2 = stringTokenizer.nextToken();
                }
                if (stringTokenizer.hasMoreTokens()) {
                    string3 = stringTokenizer.nextToken();
                }
            }
            if (string3 != null) {
                string2 = string2 + "\n" + string3;
            }
            JOptionPane.showMessageDialog(X.frame, Resource.getString("help.version.info") + "\n" + string2, Resource.getString("help.version.info.title"), 1);
        }
        catch (Exception exception) {
            X.Msg(Resource.getString("help.version.error") + " " + exception);
        }
    }

    public static void setFTPServer(String string, String string2, String string3, String string4, String string5) {
        ftp_server = string != null ? string : ftp_server;
        ftp_port = string5 != null ? string5 : ftp_port;
        ftp_user = string2 != null ? string2 : ftp_user;
        ftp_password = string3 != null ? string3 : ftp_password;
        ftp_directory = string4 != null ? string4 : ftp_directory;
    }

    public static String getFTP_Server() {
        return ftp_server;
    }

    public static String getFTP_Port() {
        return ftp_port;
    }

    public static String getFTP_User() {
        return ftp_user;
    }

    public static String getFTP_Password() {
        return ftp_password;
    }

    public static String getFTP_Directory() {
        return ftp_directory;
    }

    public static String getFTP_Command() {
        return ftp_command;
    }

    public static void setFTP_Server(String string) {
        ftp_server = string != null ? string : ftp_server;
    }

    public static void setFTP_Port(String string) {
        ftp_port = string != null ? string : ftp_port;
    }

    public static void setFTP_User(String string) {
        ftp_user = string != null ? string : ftp_user;
    }

    public static void setFTP_Password(String string) {
        ftp_password = string != null ? string : ftp_password;
    }

    public static void setFTP_Directory(String string) {
        ftp_directory = string != null ? string : ftp_directory;
    }

    public static void setFTP_Command(String string) {
        ftp_command = string != null ? string : ftp_command;
    }
}

