/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.dvb.projectx.audio;

import java.util.Arrays;
import net.sourceforge.dvb.projectx.audio.Audio;
import net.sourceforge.dvb.projectx.common.Resource;
import net.sourceforge.dvb.projectx.common.X;

public class MPAC {
    private final short[][] alloc27 = new short[][]{{0, 1, 3, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17}, {0, 1, 3, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17}, {0, 1, 3, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17}, {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 17}, {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 17}, {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 17}, {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 17}, {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 17}, {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 17}, {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 17}, {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 17}, {0, 1, 2, 3, 4, 5, 6, 17}, {0, 1, 2, 3, 4, 5, 6, 17}, {0, 1, 2, 3, 4, 5, 6, 17}, {0, 1, 2, 3, 4, 5, 6, 17}, {0, 1, 2, 3, 4, 5, 6, 17}, {0, 1, 2, 3, 4, 5, 6, 17}, {0, 1, 2, 3, 4, 5, 6, 17}, {0, 1, 2, 3, 4, 5, 6, 17}, {0, 1, 2, 3, 4, 5, 6, 17}, {0, 1, 2, 3, 4, 5, 6, 17}, {0, 1, 2, 3, 4, 5, 6, 17}, {0, 1, 2, 3, 4, 5, 6, 17}, {0, 1, 2, 17}, {0, 1, 2, 17}, {0, 1, 2, 17}, {0, 1, 2, 17}};
    private final short[] bal27mp1 = new short[]{4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 2, 2, 2, 2};
    private final short[] getbits = new short[]{0, 5, 7, 3, 10, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16};
    private final short[] grouping = new short[]{0, 3, 5, 0, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private final int[] MPA_48M1L2 = new int[]{0, 768, 1152, 1344, 1536, 1920, 2304, 2688, 3072, 3840, 4608, 5376, 6144, 7680, 9216, 16384};
    private final int STEREO = 0;
    private final int JSTEREO = 1;
    private final int DUAL = 2;
    private final int SINGLE = 3;
    private int maxBitSize = 0;
    private short[] Bal = new short[0];
    private short[][] Allocation;
    private int[] Sizes;
    private int[] BRindex = new int[3];
    private int Restart = 0;
    private int error_flag = 0;
    private Audio Audio = new Audio();

    public MPAC() {
        this.Sizes = this.MPA_48M1L2;
        Arrays.sort(this.Sizes);
        this.maxBitSize = this.Sizes[14];
        this.Bal = this.bal27mp1;
        this.Allocation = this.alloc27;
    }

    public byte[][] modifyframe(byte[] byArray, long[] lArray) {
        int n;
        byte[][] byArray2 = new byte[2][byArray.length];
        for (n = 0; n < 3; ++n) {
            this.BRindex[n] = (int)(0xFL & lArray[17] >>> 4 + (n << 2));
        }
        this.Restart = 0;
        this.error_flag = 0;
        n = (int)lArray[10];
        if (this.Audio.MPA_parseHeader(byArray, 0) != 1 || this.Audio.ID != 1 || this.Audio.Layer != 2 || this.Audio.Sampling_frequency != 48000 || this.Audio.Bitrate < 56000 || this.Audio.Mode == 3 && this.Audio.Bitrate > 192000 || this.Audio.Mode != 3 && this.Audio.Bitrate < 112000) {
            System.arraycopy(byArray, 0, byArray2[0], 0, byArray.length);
            System.arraycopy(byArray, 0, byArray2[1], 0, byArray.length);
            X.Msg(Resource.getString("audio.msg.convert.disabled", "" + (lArray[17] >>> 18)));
            lArray[17] = lArray[17] | 0x1000CL;
            return byArray2;
        }
        this.Audio.MPA_deleteCRC(byArray);
        switch (n) {
            case 1: 
            case 2: 
            case 3: {
                if (this.Audio.Channel == 1) {
                    byArray2 = this.createByteArrays(this.makeTwoChannel(this.createBitArray(byArray), n, 0));
                    break;
                }
                byArray2 = this.adaptSourceFrame(byArray, byArray2, n);
                break;
            }
            case 4: {
                byArray2 = this.Audio.Channel == 2 ? this.createByteArrays(this.splitTwoChannel(this.createBitArray(byArray), n)) : this.adaptSourceFrame(byArray, byArray2, n);
            }
        }
        lArray[17] = lArray[17] & 0xFFFFFFFFFFFF0003L;
        for (int i = 0; i < 3; ++i) {
            lArray[17] = lArray[17] | (long)(this.BRindex[i] << 4 + (i << 2));
        }
        lArray[17] = lArray[17] | (long)(this.Restart << 2);
        if (this.error_flag > 0) {
            X.Msg(Resource.getString("audio.msg.convert.error", "" + this.error_flag, "" + (lArray[17] >>> 18)));
        }
        return byArray2;
    }

    private void setError(int n) {
        this.error_flag |= n;
    }

    private byte[][] adaptSourceFrame(byte[] byArray, byte[][] byArray2, int n) {
        System.arraycopy(byArray, 0, byArray2[0], 0, byArray.length);
        System.arraycopy(byArray, 0, byArray2[1], 0, byArray.length);
        int[] nArray = new int[2];
        nArray[1] = nArray[0] = (0xF0 & byArray[2]) >>> 4;
        if (n < 4) {
            if (nArray[0] == this.BRindex[0]) {
                return byArray2;
            }
            if (nArray[0] > this.BRindex[0]) {
                if (this.BRindex[0] != 0) {
                    this.Restart |= 3;
                }
                this.BRindex[0] = nArray[0];
                return byArray2;
            }
        } else {
            if (nArray[0] == this.BRindex[1] && nArray[1] == this.BRindex[2]) {
                return byArray2;
            }
            if (nArray[0] > this.BRindex[1]) {
                if (this.BRindex[1] != 0) {
                    this.Restart |= 1;
                }
                this.BRindex[1] = nArray[0];
            }
            if (nArray[1] > this.BRindex[2]) {
                if (this.BRindex[2] != 0) {
                    this.Restart |= 2;
                }
                this.BRindex[2] = nArray[1];
            }
            if (this.Restart > 0) {
                return byArray2;
            }
        }
        byte[][] byArray3 = new byte[2][0];
        for (int i = 0; i < 2; ++i) {
            byArray3[i] = new byte[this.Sizes[this.BRindex[i + (n >>> 2)]] >>> 3];
            System.arraycopy(byArray2[i], 0, byArray3[i], 0, byArray2[i].length);
            byte[] byArray4 = byArray3[i];
            byArray4[2] = (byte)(byArray4[2] & 0xF);
            byte[] byArray5 = byArray3[i];
            byArray5[2] = (byte)(byArray5[2] | (byte)this.BRindex[i + (n >>> 2)] << 4);
            if (n < 4) break;
            if (this.BRindex[i + 1] <= 10) continue;
            byArray3[i] = this.createByteArray(this.makeTwoChannel(this.createBitArray(byArray3[i]), 3, i + 1));
        }
        return byArray3;
    }

    private boolean[] createBitArray(byte[] byArray) {
        boolean[] blArray = new boolean[this.maxBitSize];
        for (int i = 0; i < byArray.length; ++i) {
            for (int j = 0; j < 8; ++j) {
                if ((128 >>> j & byArray[i]) == 0) continue;
                blArray[j + (i << 3)] = true;
            }
        }
        return blArray;
    }

    private byte[] createByteArray(boolean[] blArray) {
        int n = this.getSizeFromIndex(blArray) >>> 3;
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < 8; ++j) {
                int n2 = i;
                byArray[n2] = (byte)(byArray[n2] | (blArray[j + (i << 3)] ? 128 >>> j : 0));
            }
        }
        return byArray;
    }

    private byte[][] createByteArrays(boolean[] blArray) {
        int n = this.getSizeFromIndex(blArray) >>> 3;
        byte[][] byArrayArray = new byte[][]{new byte[n], new byte[0]};
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < 8; ++j) {
                byte[] byArray = byArrayArray[0];
                int n2 = i;
                byArray[n2] = (byte)(byArray[n2] | (blArray[j + (i << 3)] ? 128 >>> j : 0));
            }
        }
        return byArrayArray;
    }

    private byte[][] createByteArrays(boolean[][] blArray) {
        int[] nArray = new int[2];
        for (int i = 0; i < 2; ++i) {
            nArray[i] = this.getSizeFromIndex(blArray[i]) >>> 3;
        }
        byte[][] byArrayArray = new byte[][]{new byte[nArray[0]], new byte[nArray[1]]};
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < nArray[i]; ++j) {
                for (int k = 0; k < 8; ++k) {
                    byte[] byArray = byArrayArray[i];
                    int n = j;
                    byArray[n] = (byte)(byArray[n] | (blArray[i][k + (j << 3)] ? 128 >>> k : 0));
                }
            }
        }
        return byArrayArray;
    }

    private int getSizeFromIndex(boolean[] blArray) {
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            n |= blArray[i + 16] ? 8 >>> i : 0;
        }
        n = this.Sizes[n];
        return n;
    }

    private void setBitRateIndex(boolean[] blArray, int n, int n2) {
        if ((n = Arrays.binarySearch(this.Sizes, n)) < 0) {
            // empty if block
        }
        n = Math.abs(n) - 1;
        if (n2 == 0 && n < 7) {
            n = 7;
        }
        if (n2 > 0 && n < 3) {
            n = 3;
        }
        n = this.updateCBRIndex(n, n2);
        for (int i = 0; i < 4; ++i) {
            blArray[i + 16] = (n & 8 >> i) != 0;
        }
    }

    private int updateCBRIndex(int n, int n2) {
        if (this.BRindex[n2] == 0) {
            this.BRindex[n2] = n;
        } else if (this.BRindex[n2] >= n) {
            n = this.BRindex[n2];
        } else {
            this.Restart |= 3 - n2;
            this.BRindex[n2] = n;
        }
        return n;
    }

    private void setChannelMode(boolean[] blArray, int n) {
        n <<= 2;
        for (int i = 0; i < 4; ++i) {
            blArray[i + 24] = (n & 8 >> i) != 0;
        }
    }

    private boolean[] makeTwoChannel(boolean[] blArray, int n, int n2) {
        boolean[] blArray2 = new boolean[this.maxBitSize];
        int n3 = 32;
        int n4 = 32;
        int n5 = this.getSizeFromIndex(blArray);
        System.arraycopy(blArray, 0, blArray2, 0, 32);
        switch (n) {
            case 1: {
                for (int i = 0; i < this.Bal.length; ++i) {
                    System.arraycopy(blArray, n3, blArray2, n4, this.Bal[i]);
                    n3 += this.Bal[i];
                    n4 += this.Bal[i] << 1;
                }
                System.arraycopy(blArray, n3, blArray2, n4, n5 - n3);
                this.setChannelMode(blArray2, 2);
                this.setBitRateIndex(blArray2, n4 += n5 - n3, n2);
                break;
            }
            case 2: 
            case 3: {
                int n6 = this.Bal.length;
                int[] nArray = new int[n6];
                int[] nArray2 = new int[n6];
                try {
                    int n7;
                    int n8;
                    for (n8 = 0; n8 < n6; ++n8) {
                        for (n7 = 0; n7 < this.Bal[n8]; ++n7) {
                            if (!blArray[n3 + n7]) continue;
                            blArray2[n4 + n7] = true;
                            if (n == 2 || n8 < 4) {
                                blArray2[n4 + this.Bal[n8] + n7] = true;
                            }
                            int n9 = n8;
                            nArray[n9] = nArray[n9] | 1 << this.Bal[n8] - 1 - n7;
                        }
                        n3 += this.Bal[n8];
                        n4 += n == 2 || n8 < 4 ? this.Bal[n8] << 1 : this.Bal[n8];
                    }
                    for (n8 = 0; n8 < n6; ++n8) {
                        if (nArray[n8] == 0) continue;
                        for (n7 = 0; n7 < 2; ++n7) {
                            if (!blArray[n3 + n7]) continue;
                            blArray2[n4 + n7] = true;
                            blArray2[n4 + n7 + 2] = true;
                            int n10 = n8;
                            nArray2[n10] = nArray2[n10] | 1 << 1 - n7;
                        }
                        n3 += 2;
                        n4 += 4;
                    }
                    n7 = 0;
                    for (n8 = 0; n8 < n6; ++n8) {
                        if (nArray[n8] == 0) continue;
                        switch (nArray2[n8]) {
                            case 0: {
                                n7 = 18;
                                break;
                            }
                            case 1: 
                            case 3: {
                                n7 = 12;
                                break;
                            }
                            case 2: {
                                n7 = 6;
                            }
                        }
                        System.arraycopy(blArray, n3, blArray2, n4, n7);
                        System.arraycopy(blArray, n3, blArray2, n4 + n7, n7);
                        n3 += n7;
                        n4 += n7 << 1;
                    }
                    for (n8 = 0; n8 < 12; ++n8) {
                        for (n7 = 0; n7 < n6; ++n7) {
                            if (nArray[n7] == 0) continue;
                            short s = this.Allocation[n7][nArray[n7]];
                            short s2 = this.getbits[s];
                            if (this.grouping[s] > 0) {
                                System.arraycopy(blArray, n3, blArray2, n4, s2);
                                n4 += s2;
                                if (n == 2 || n7 < 4) {
                                    System.arraycopy(blArray, n3, blArray2, n4, s2);
                                    n4 += s2;
                                }
                                n3 += s2;
                                continue;
                            }
                            System.arraycopy(blArray, n3, blArray2, n4, 3 * s2);
                            n4 += 3 * s2;
                            if (n == 2 || n7 < 4) {
                                System.arraycopy(blArray, n3, blArray2, n4, 3 * s2);
                                n4 += 3 * s2;
                            }
                            n3 += 3 * s2;
                        }
                    }
                }
                catch (Exception exception) {
                    this.setError(1);
                }
                this.setChannelMode(blArray2, 1 & n);
                this.setBitRateIndex(blArray2, n4, n2);
            }
        }
        return blArray2;
    }

    private boolean[][] splitTwoChannel(boolean[] blArray, int n) {
        boolean[][] blArray2 = new boolean[2][this.maxBitSize];
        System.arraycopy(blArray, 0, blArray2[0], 0, 32);
        System.arraycopy(blArray, 0, blArray2[1], 0, 32);
        int n2 = 32;
        int[] nArray = new int[]{32, 32};
        int n3 = this.Bal.length;
        int[][] nArray2 = new int[2][n3];
        int[][] nArray3 = new int[2][n3];
        int n4 = 32;
        if (this.Audio.Mode == 1) {
            n4 = (this.Audio.Mode_extension + 1) * 4;
        }
        if (n4 == 32) {
            n4 = n3;
        }
        try {
            int n5;
            int n6;
            int n7;
            for (n7 = 0; n7 < n4; ++n7) {
                n6 = 0;
                while (n6 < 2) {
                    for (n5 = 0; n5 < this.Bal[n7]; ++n5) {
                        if (!blArray[n2 + n5]) continue;
                        int[] nArray4 = nArray2[n6];
                        int n8 = n7;
                        nArray4[n8] = nArray4[n8] | 1 << this.Bal[n7] - 1 - n5;
                        blArray2[n6][nArray[n6] + n5] = true;
                    }
                    n2 += this.Bal[n7];
                    int n9 = n6++;
                    nArray[n9] = nArray[n9] + this.Bal[n7];
                }
            }
            for (n7 = n4; n7 < n3; ++n7) {
                for (n6 = 0; n6 < this.Bal[n7]; ++n6) {
                    if (!blArray[n2 + n6]) continue;
                    for (n5 = 0; n5 < 2; ++n5) {
                        int[] nArray5 = nArray2[n5];
                        int n10 = n7;
                        nArray5[n10] = nArray5[n10] | 1 << this.Bal[n7] - 1 - n6;
                        blArray2[n5][nArray[n5] + n6] = true;
                    }
                }
                n2 += this.Bal[n7];
                n6 = 0;
                while (n6 < 2) {
                    int n11 = n6++;
                    nArray[n11] = nArray[n11] + this.Bal[n7];
                }
            }
            for (n7 = 0; n7 < n3; ++n7) {
                for (n6 = 0; n6 < 2; ++n6) {
                    if (nArray2[n6][n7] == 0) continue;
                    for (n5 = 0; n5 < 2; ++n5) {
                        if (!blArray[n2 + n5]) continue;
                        int[] nArray6 = nArray3[n6];
                        int n12 = n7;
                        nArray6[n12] = nArray6[n12] | 1 << 1 - n5;
                        blArray2[n6][nArray[n6] + n5] = true;
                    }
                    n2 += 2;
                    int n13 = n6;
                    nArray[n13] = nArray[n13] + 2;
                }
            }
            n6 = 0;
            for (n7 = 0; n7 < n3; ++n7) {
                for (n5 = 0; n5 < 2; ++n5) {
                    if (nArray2[n5][n7] == 0) continue;
                    switch (nArray3[n5][n7]) {
                        case 0: {
                            n6 = 18;
                            break;
                        }
                        case 1: 
                        case 3: {
                            n6 = 12;
                            break;
                        }
                        case 2: {
                            n6 = 6;
                        }
                    }
                    System.arraycopy(blArray, n2, blArray2[n5], nArray[n5], n6);
                    n2 += n6;
                    int n14 = n5;
                    nArray[n14] = nArray[n14] + n6;
                }
            }
            for (n7 = 0; n7 < 12; ++n7) {
                int n15;
                short s;
                for (n6 = 0; n6 < n4; ++n6) {
                    for (n5 = 0; n5 < 2; ++n5) {
                        if (nArray2[n5][n6] == 0) continue;
                        s = this.Allocation[n6][nArray2[n5][n6]];
                        n15 = this.getbits[s];
                        if (this.grouping[s] > 0) {
                            System.arraycopy(blArray, n2, blArray2[n5], nArray[n5], n15);
                            n2 += n15;
                            int n16 = n5;
                            nArray[n16] = nArray[n16] + n15;
                            continue;
                        }
                        System.arraycopy(blArray, n2, blArray2[n5], nArray[n5], 3 * n15);
                        n2 += 3 * n15;
                        int n17 = n5;
                        nArray[n17] = nArray[n17] + 3 * n15;
                    }
                }
                for (n6 = n4; n6 < n3; ++n6) {
                    if (nArray2[0][n6] == 0) continue;
                    n5 = this.Allocation[n6][nArray2[0][n6]];
                    s = this.getbits[n5];
                    if (this.grouping[n5] > 0) {
                        n15 = 0;
                        while (n15 < 2) {
                            System.arraycopy(blArray, n2, blArray2[n15], nArray[n15], s);
                            int n18 = n15++;
                            nArray[n18] = nArray[n18] + s;
                        }
                        n2 += s;
                        continue;
                    }
                    n15 = 0;
                    while (n15 < 2) {
                        System.arraycopy(blArray, n2, blArray2[n15], nArray[n15], 3 * s);
                        int n19 = n15++;
                        nArray[n19] = nArray[n19] + 3 * s;
                    }
                    n2 += 3 * s;
                }
            }
        }
        catch (Exception exception) {
            this.setError(2);
        }
        for (int i = 0; i < 2; ++i) {
            this.setChannelMode(blArray2[i], 3);
            this.setBitRateIndex(blArray2[i], nArray[i], i + 1);
            if (this.getSizeFromIndex(blArray2[i]) <= this.Sizes[10]) continue;
            blArray2[i] = this.makeTwoChannel(blArray2[i], 3, i + 1);
        }
        return blArray2;
    }
}

