/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.dvb.projectx.audio;

import java.util.Arrays;
import net.sourceforge.dvb.projectx.audio.Audio;
import net.sourceforge.dvb.projectx.audio.MPAD;

public final class CRC {
    private CRC() {
    }

    public static byte[] generateCRC32(byte[] byArray, int n) {
        int n2;
        int[] nArray = new int[]{1, 1, 1, 0, 1, 1, 0, 1, 1, 0, 1, 1, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 1};
        int[] nArray2 = new int[32];
        long l = 0L;
        byte[] byArray2 = new byte[4];
        Arrays.fill(nArray2, 1);
        int n3 = (byArray.length - n) * 8;
        int n4 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            int n5;
            int n6 = n5 = (byArray[n] & 128 >>> n4++) != 0 ? 1 : 0;
            if ((n4 &= 7) == 0) {
                ++n;
            }
            n5 ^= nArray2[31];
            for (int i = 31; i > 0; --i) {
                nArray2[i] = nArray[i] == 1 ? nArray2[i - 1] ^ n5 : nArray2[i - 1];
            }
            nArray2[0] = n5;
        }
        for (n2 = 0; n2 < 32; ++n2) {
            l = l << 1 | (long)nArray2[31 - n2];
        }
        for (n2 = 0; n2 < 4; ++n2) {
            byArray2[n2] = (byte)(0xFFL & l >>> (3 - n2) * 8);
        }
        return byArray2;
    }

    public static int checkCRC16ofAC3(byte[] byArray, int n, int n2) {
        int n3;
        int[] nArray = new int[]{1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1};
        int[] nArray2 = new int[16];
        int n4 = 0;
        int n5 = 0;
        int n6 = (n2 - n) * 8;
        int n7 = ((n2 >>> 1) + (n2 >>> 3) - n) * 8;
        int n8 = 0;
        for (n3 = 0; n3 < n6; ++n3) {
            int n9;
            int n10;
            if (n3 == n7) {
                n5 = 0;
                for (n10 = 0; n10 < 16; ++n10) {
                    n5 = n5 << 1 | nArray2[15 - n10];
                }
                if (n5 != 0) {
                    return 1;
                }
            }
            int n11 = n9 = (byArray[n] & 128 >>> n8++) != 0 ? 1 : 0;
            if ((n8 &= 7) == 0) {
                ++n;
            }
            n9 ^= nArray2[15];
            for (n10 = 15; n10 > 0; --n10) {
                nArray2[n10] = nArray[n10] == 1 ? nArray2[n10 - 1] ^ n9 : nArray2[n10 - 1];
            }
            nArray2[0] = n9;
        }
        for (n3 = 0; n3 < 16; ++n3) {
            n4 = n4 << 1 | nArray2[15 - n3];
        }
        if (n4 != 0) {
            return 2;
        }
        return 0;
    }

    public static int checkCRC16ofMPA(Audio audio, byte[] byArray) {
        int n;
        Object object;
        int[] nArray;
        int n2;
        int n3;
        if (audio.Layer < 2 || audio.Protection_bit == 0) {
            return 0;
        }
        int n4 = (0xFF & byArray[4]) << 8 | 0xFF & byArray[5];
        byArray = audio.MPA_deleteCRC(byArray);
        int n5 = 2;
        int n6 = 16;
        int[] nArray2 = new int[]{32};
        if (audio.Layer == 3) {
            for (n3 = 0; n3 < audio.Bound; ++n3) {
                for (n2 = 0; n2 < audio.Channel; ++n2) {
                    n6 += 4;
                }
            }
            for (n3 = audio.Bound; n3 < audio.Sblimit; ++n3) {
                n6 += 4;
            }
        } else {
            int[][] nArray3 = new int[32][2];
            if (audio.ID == 1) {
                if (audio.Sblimit > 20) {
                    nArray = MPAD.table_b2ab_nbal;
                    object = MPAD.table_b2ab;
                } else {
                    nArray = MPAD.table_b2cd_nbal;
                    object = MPAD.table_b2cd;
                }
            } else {
                nArray = MPAD.table_MPG2_nbal;
                object = MPAD.table_MPG2;
            }
            for (n3 = 0; n3 < audio.Bound; ++n3) {
                for (n2 = 0; n2 < audio.Channel; ++n2) {
                    nArray3[n3][n2] = object[n3][CRC.getBits(byArray, nArray2, nArray[n3])];
                    n6 += nArray[n3];
                }
            }
            for (n3 = audio.Bound; n3 < audio.Sblimit; ++n3) {
                int n7 = object[n3][CRC.getBits(byArray, nArray2, nArray[n3])];
                nArray3[n3][1] = n7;
                nArray3[n3][0] = n7;
                n6 += nArray[n3];
            }
            for (n3 = 0; n3 < audio.Sblimit; ++n3) {
                for (n2 = 0; n2 < audio.Channel; ++n2) {
                    if (nArray3[n3][n2] <= 0) continue;
                    n6 += 2;
                }
            }
        }
        nArray = new int[]{1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1};
        object = new int[16];
        int n8 = 0;
        Arrays.fill((int[])object, 1);
        int n9 = 0;
        for (n = 0; n < n6; ++n) {
            int n10;
            int n11 = n10 = (byArray[n5] & 128 >>> n9++) != 0 ? 1 : 0;
            if ((n9 &= 7) == 0) {
                ++n5;
            }
            n10 ^= object[15];
            for (int i = 15; i > 0; --i) {
                object[i] = nArray[i] == 1 ? (Object)(object[i - 1] ^ n10) : object[i - 1];
            }
            object[0] = (int[])n10;
        }
        for (n = 0; n < 16; ++n) {
            n8 = n8 << 1 | object[15 - n];
        }
        if (n8 != n4) {
            return 1;
        }
        return 0;
    }

    public static int getBits(byte[] byArray, int[] nArray, int n) {
        int n2 = nArray[0] >>> 3;
        int n3 = (0xFF & byArray[n2]) << 24 | (0xFF & byArray[n2 + 1]) << 16 | (0xFF & byArray[n2 + 2]) << 8 | 0xFF & byArray[n2 + 3];
        n3 <<= nArray[0] & 7;
        nArray[0] = nArray[0] + n;
        return n3 >>>= 32 - n;
    }
}

