/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.dvb.projectx.audio;

public class AudioFrameConstants {
    int[] armode = new int[]{0, 1, 2, 3, 3, 4, 4, 5};
    int[] arsample = new int[]{48000, 44100, 32000, 0};
    int[] arbitrate = new int[]{0, 40000, 48000, 56000, 64000, 80000, 96000, 112000, 128000, 160000, 192000, 224000, 256000, 320000, 384000, 448000, 512000, 576000, 640000, 0, 0};
    int[] rpadding = new int[]{0, 1, 1, 4};
    int[] rlayer = new int[]{0, 4, 2, 1};
    int[][] rsample = new int[][]{{22050, 24000, 16000, 0}, {44100, 48000, 32000, 0}};
    int[] rmode = new int[]{1, 2, 4, 8};
    int[] rchnl = new int[]{2, 2, 2, 1};
    int[] rmext = new int[]{1, 2, 4, 8};
    int[] remph = new int[]{1, 2, 3, 4};
    int[][][] rbitrate = new int[][][]{new int[][]{{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 8000, 16000, 24000, 32000, 40000, 48000, 56000, 64000, 80000, 96000, 112000, 128000, 144000, 160000, 0}, {0, 8000, 16000, 24000, 32000, 40000, 48000, 56000, 64000, 80000, 96000, 112000, 128000, 144000, 160000, 0}, {0, 32000, 48000, 56000, 64000, 80000, 96000, 112000, 128000, 144000, 160000, 176000, 192000, 224000, 256000, 0}}, new int[][]{{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 32000, 40000, 48000, 56000, 64000, 80000, 96000, 112000, 128000, 160000, 192000, 224000, 256000, 320000, 0}, {0, 32000, 48000, 56000, 64000, 80000, 96000, 112000, 128000, 160000, 192000, 224000, 256000, 320000, 384000, 0}, {0, 32000, 64000, 96000, 128000, 160000, 192000, 224000, 256000, 288000, 320000, 352000, 384000, 416000, 448000, 0}}};
    int[][] ac3const = new int[][]{{288000000, 160, 192, 224, 256, 320, 384, 448, 512, 640, 768, 896, 1024, 1280, 1536, 1792, 2080, 2304, 2560}, {313469388, 174, 208, 242, 278, 348, 416, 486, 556, 696, 834, 974, 1114, 1392, 1670, 1950, 2228, 2506, 2786}, {432000000, 240, 288, 336, 384, 480, 576, 672, 768, 960, 1152, 1344, 1536, 1920, 2304, 2688, 3120, 3456, 3840}};

    public int[] RiffFormat(byte[] byArray) {
        int[] nArray = new int[10];
        nArray[0] = (8 & byArray[1]) << 1 | (1 & byArray[1]) << 3 | 4 & byArray[3] | (8 & byArray[3]) >>> 2 | 1 & byArray[2];
        nArray[1] = this.rlayer[(6 & byArray[1]) >>> 1];
        nArray[2] = this.rsample[(8 & byArray[1]) >>> 3][(0xC & byArray[2]) >>> 2];
        nArray[3] = this.rmode[(0xC0 & byArray[3]) >>> 6];
        nArray[4] = this.rchnl[(0xC0 & byArray[3]) >>> 6];
        nArray[5] = this.rmext[(0x30 & byArray[3]) >>> 4];
        nArray[6] = this.rbitrate[(8 & byArray[1]) >>> 3][(6 & byArray[1]) >>> 1][(0xF0 & byArray[2]) >>> 4];
        nArray[7] = this.remph[3 & byArray[3]];
        nArray[8] = nArray[1] == 1 ? 4 * (12 * nArray[6] / nArray[2]) : 144 * nArray[6] / nArray[2];
        nArray[8] = nArray[8] / ((8 & byArray[1]) == 0 && (6 & byArray[1]) == 1 ? 2 : 1);
        if ((2 & byArray[2]) != 0) {
            nArray[8] = nArray[8] + this.rpadding[(6 & byArray[1]) >>> 1];
        }
        return nArray;
    }

    public int[] AC3RiffFormat(byte[] byArray) {
        int[] nArray = new int[10];
        nArray[2] = this.arsample[(0xC0 & byArray[4]) >>> 6];
        nArray[4] = this.armode[(0xE0 & byArray[6]) >>> 5];
        nArray[6] = this.arbitrate[(0x3F & byArray[4]) >>> 1];
        nArray[8] = this.ac3const[(0xC0 & byArray[4]) >>> 6][(0x3E & byArray[4]) >>> 1] + ((1 & byArray[4]) != 0 ? 2 : 0);
        return nArray;
    }
}

