/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.dvb.projectx.audio;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Arrays;

public class Audio {
    int ID = 0;
    public int Layer = 0;
    int Protection_bit = 0;
    public int Bitrate = 0;
    public int Sampling_frequency = 0;
    int Padding_bit = 0;
    int Private_bit = 0;
    public int Mode = 0;
    int Mode_extension = 0;
    int Copyright = 0;
    int Original = 0;
    int Channel = 0;
    public int Emphasis = 0;
    public int Size = 0;
    public int Size_base = 0;
    int Bound = 0;
    int Sblimit;
    public double Time_length = 0.0;
    int nID = 0;
    int nLayer = 0;
    int nProtection_bit = 0;
    int nBitrate = 0;
    int nSampling_frequency = 0;
    int nPadding_bit = 0;
    int nPrivate_bit = 0;
    int nMode = 0;
    int nMode_extension = 0;
    int nCopyright = 0;
    int nOriginal = 0;
    int nChannel = 0;
    int nEmphasis = 0;
    int nSize = 0;
    int nSize_base = 0;
    double nTime_length = 0.0;
    int lID = 0;
    int lLayer = 0;
    int lProtection_bit = 0;
    int lBitrate = 0;
    int lSampling_frequency = 0;
    int lPadding_bit = 0;
    int lPrivate_bit = 0;
    int lMode = 0;
    public int lMode_extension = 0;
    int lCopyright = 0;
    int lOriginal = 0;
    int lChannel = 0;
    int lEmphasis = 0;
    int lSize = 0;
    int lSize_base = 0;
    double lTime_length = 0.0;
    int[][][] bitrate_index = new int[][][]{new int[][]{{-1, 8000, 16000, 24000, 32000, 40000, 48000, 56000, 64000, 80000, 96000, 112000, 128000, 144000, 160000, 0}, {-1, 8000, 16000, 24000, 32000, 40000, 48000, 56000, 64000, 80000, 96000, 112000, 128000, 144000, 160000, 0}, {-1, 32000, 48000, 56000, 64000, 80000, 96000, 112000, 128000, 144000, 160000, 176000, 192000, 224000, 256000, 0}}, new int[][]{{-1, 32000, 40000, 48000, 56000, 64000, 80000, 96000, 112000, 128000, 160000, 192000, 224000, 256000, 320000, 0}, {-1, 32000, 48000, 56000, 64000, 80000, 96000, 112000, 128000, 160000, 192000, 224000, 256000, 320000, 384000, 0}, {-1, 32000, 64000, 96000, 128000, 160000, 192000, 224000, 256000, 288000, 320000, 352000, 384000, 416000, 448000, 0}}, new int[][]{{-1, 6000, 8000, 10000, 12000, 16000, 20000, 24000, 28000, 320000, 40000, 48000, 56000, 64000, 80000, 0}, {-1, 6000, 8000, 10000, 12000, 16000, 20000, 24000, 28000, 320000, 40000, 48000, 56000, 64000, 80000, 0}, {-1, 8000, 12000, 16000, 20000, 24000, 32000, 40000, 48000, 560000, 64000, 80000, 96000, 112000, 128000, 0}}};
    int[][] frequency_index = new int[][]{{22050, 24000, 16000, 0}, {44100, 48000, 32000, 0}, {11025, 12000, 8000, 0}};
    double[] time_index = new double[]{0.0, 1.0368E8, 1.0368E8, 3.456E7};
    String[] dID = new String[]{"MPEG-2", "MPEG-1", "MPEG-2.5"};
    String[] dLayer = new String[]{"n.a.", "Layer3", "Layer2", "Layer1"};
    String[] dCRC = new String[]{"noCRC", "CRC"};
    String[] dMode = new String[]{"stereo", "jstereo", "dual", "mono"};
    int[] ac3_frequency_index = new int[]{48000, 44100, 32000, 0};
    int[] ac3_bitrate_index = new int[]{32000, 40000, 48000, 56000, 64000, 80000, 96000, 112000, 128000, 160000, 192000, 224000, 256000, 320000, 384000, 448000, 512000, 576000, 640000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    int[][] ac3_size_table = new int[][]{{128, 160, 192, 224, 256, 320, 384, 448, 512, 640, 768, 896, 1024, 1280, 1536, 1792, 2080, 2304, 2560}, {138, 174, 208, 242, 278, 348, 416, 486, 556, 696, 834, 974, 1114, 1392, 1670, 1950, 2228, 2506, 2786}, {192, 240, 288, 336, 384, 480, 576, 672, 768, 960, 1152, 1344, 1536, 1920, 2304, 2688, 3120, 3456, 3840}};
    String[] bsmod = new String[]{", CM", ", ME", ", K:VI", ", K:HI", ", K:D", ", K:C", ", K:E", ", K:VO"};
    String[] cmixlev = new String[]{"", ", cm-3.0dB", ", cm-4.5dB", ", cm-6.0dB", ", cm-4.5dB"};
    String[] surmixlev = new String[]{"", ", sm-3dB", ", sm-6dB", ", sm 0dB", ", sm-6dB"};
    String[] dsurmod = new String[]{"", ", notDS", ", DS", ""};
    String[] acmod = new String[]{"1+1", "1/0", "2/0", "3/0", "2/1", "3/1", "2/2", "3/2"};
    int[] ac3_channels = new int[]{2, 1, 2, 3, 3, 4, 4, 5};
    String[][] lfe = new String[][]{{".0", ".1"}, {"", "lfe"}};
    int[] dts_frequency_index = new int[]{0, 8000, 16000, 32000, 64000, 128000, 11025, 22050, 44100, 88200, 176400, 12000, 24000, 48000, 96000, 192000};
    int[] dts_bitrate_index = new int[]{32000, 56000, 64000, 96000, 112000, 128000, 192000, 224000, 256000, 320000, 384000, 448000, 512000, 576000, 640000, 768000, 896000, 1024000, 1152000, 1280000, 1344000, 1408000, 1411200, 1472000, 0x177000, 1920000, 2048000, 0x2EE000, 3840000, 4096000, 0, 0};
    String[] dts_acmod = new String[]{"1", "DM", "2/0", "2/0", "2/0", "3/0", "2.1/0", "3.1/0", "2/2", "3/2", "2/2/2", "2/2/2", "3/2/2", "3.1/2/2", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""};
    int[] dts_channels = new int[]{1, 2, 2, 2, 2, 3, 3, 4, 4, 5, 6, 6, 7, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    final int[] WaveChunks = new int[]{1463899717, 1668637984, 1684108385, 1717658484, 1718449184, 1768846196, 1818321516, 1818850164, 1819572340, 1852798053, 1886155636, 1936552044};
    private boolean INTEL = false;
    String[] LSB_mode = new String[]{"F", "X"};
    String[] compression = new String[]{"", "PCM", "MPEG", "MPEG-L3", "AC3"};
    int[] lpcm_frequency_index = new int[]{48000, 96000};
    int[] lpcm_bps_index = new int[]{16, 20, 24, -1};

    public int MPA_parseHeader(byte[] byArray, int n) {
        int n2 = 32;
        if ((0xFF & byArray[n]) != 255 || (0xF0 & byArray[n + 1]) != 240) {
            return -1;
        }
        this.ID = 1 & byArray[n + 1] >>> 3;
        this.Emphasis = 3 & byArray[n + 3];
        if (this.ID == 1 && this.Emphasis == 2) {
            this.ID = 2;
        }
        if ((this.Layer = 3 & byArray[n + 1] >>> 1) < 1) {
            return -2;
        }
        this.Protection_bit = 1 & byArray[n + 1] ^ 1;
        this.Bitrate = this.bitrate_index[this.ID][this.Layer - 1][0xF & byArray[n + 2] >>> 4];
        if (this.Bitrate < 1) {
            return -3;
        }
        this.Sampling_frequency = this.frequency_index[this.ID][3 & byArray[n + 2] >>> 2];
        if (this.Sampling_frequency == 0) {
            return -4;
        }
        this.Padding_bit = 1 & byArray[n + 2] >>> 1;
        this.Private_bit = 1 & byArray[n + 2];
        this.Mode = 3 & byArray[n + 3] >>> 6;
        this.Mode_extension = 3 & byArray[n + 3] >>> 4;
        if (this.Mode == 0) {
            this.Mode_extension = 0;
        }
        this.Bound = this.Mode == 1 ? this.Mode_extension + 1 << 2 : n2;
        this.Channel = this.Mode == 3 ? 1 : 2;
        this.Copyright = 1 & byArray[n + 3] >>> 3;
        this.Original = 1 & byArray[n + 3] >>> 2;
        this.Time_length = this.time_index[this.Layer] / (double)this.Sampling_frequency;
        if (this.ID == 1 && this.Layer == 2) {
            if (this.Bitrate / this.Channel < 32000) {
                return -5;
            }
            if (this.Bitrate / this.Channel > 192000) {
                return -6;
            }
            this.Sblimit = this.Bitrate < 56000 ? (this.Sampling_frequency == 32000 ? 12 : 8) : (this.Bitrate < 96000 ? 27 : (this.Sampling_frequency == 48000 ? 27 : 30));
            if (this.Bound > this.Sblimit) {
                this.Bound = this.Sblimit;
            }
        } else if (this.Layer == 2) {
            this.Sblimit = 30;
        }
        if (this.Layer < 3) {
            if (this.Bound > this.Sblimit) {
                this.Bound = this.Sblimit;
            }
            this.Size_base = 144 * this.Bitrate / this.Sampling_frequency;
            this.Size = this.Size_base + this.Padding_bit;
            return 1;
        }
        this.Sblimit = 32;
        this.Size_base = 12 * this.Bitrate / this.Sampling_frequency * 4;
        this.Size = this.Size_base + 4 * this.Padding_bit;
        return 2;
    }

    public int MPA_parseNextHeader(byte[] byArray, int n) {
        if ((0xFF & byArray[n]) != 255 || (0xF0 & byArray[n + 1]) != 240) {
            return -1;
        }
        this.nID = 1 & byArray[n + 1] >>> 3;
        this.nEmphasis = 3 & byArray[n + 3];
        if (this.nID == 1 && this.nEmphasis == 2) {
            this.nID = 2;
        }
        if ((this.nLayer = 3 & byArray[n + 1] >>> 1) < 1) {
            return -2;
        }
        this.nProtection_bit = 1 & byArray[n + 1] ^ 1;
        this.nBitrate = this.bitrate_index[this.nID][this.nLayer - 1][0xF & byArray[n + 2] >>> 4];
        if (this.nBitrate < 1) {
            return -3;
        }
        this.nSampling_frequency = this.frequency_index[this.nID][3 & byArray[n + 2] >>> 2];
        if (this.nSampling_frequency == 0) {
            return -4;
        }
        this.nPadding_bit = 1 & byArray[n + 2] >>> 1;
        this.nPrivate_bit = 1 & byArray[n + 2];
        this.nMode = 3 & byArray[n + 3] >>> 6;
        this.nMode_extension = 3 & byArray[n + 3] >>> 4;
        if (this.nMode == 0) {
            this.nMode_extension = 0;
        }
        this.nChannel = this.nMode == 3 ? 1 : 2;
        this.nCopyright = 1 & byArray[n + 3] >>> 3;
        this.nOriginal = 1 & byArray[n + 3] >>> 2;
        this.nTime_length = this.time_index[this.nLayer] / (double)this.nSampling_frequency;
        if (this.nID == 1 && this.nLayer == 2) {
            if (this.nBitrate / this.Channel < 32000) {
                return -5;
            }
            if (this.nBitrate / this.Channel > 192000) {
                return -6;
            }
        }
        if (this.nLayer < 3) {
            this.nSize_base = 144 * this.nBitrate / this.nSampling_frequency;
            this.nSize = this.nSize_base + this.nPadding_bit;
            return 1;
        }
        this.nSize_base = 12 * this.nBitrate / this.nSampling_frequency * 4;
        this.nSize = this.nSize_base + 4 * this.nPadding_bit;
        return 2;
    }

    public void saveHeader() {
        this.lID = this.ID;
        this.lLayer = this.Layer;
        this.lProtection_bit = this.Protection_bit;
        this.lBitrate = this.Bitrate;
        this.lSampling_frequency = this.Sampling_frequency;
        this.lPadding_bit = this.Padding_bit;
        this.lPrivate_bit = this.Private_bit;
        this.lMode = this.Mode;
        this.lMode_extension = this.Mode_extension;
        this.lCopyright = this.Copyright;
        this.lOriginal = this.Original;
        this.lChannel = this.Channel;
        this.lEmphasis = this.Emphasis;
        this.lSize = this.Size;
        this.lSize_base = this.Size_base;
        this.lTime_length = this.Time_length;
    }

    public int MPA_compareHeader() {
        if (this.lID != this.ID) {
            return 1;
        }
        if (this.lLayer != this.Layer) {
            return 2;
        }
        if (this.lBitrate != this.Bitrate) {
            return 3;
        }
        if (this.lSampling_frequency != this.Sampling_frequency) {
            return 4;
        }
        if (this.lProtection_bit != this.Protection_bit) {
            return 5;
        }
        if (this.lMode != this.Mode) {
            if (this.Mode + this.lMode < 2) {
                return 6;
            }
            return 7;
        }
        return 0;
    }

    public String MPA_displayHeader() {
        return "" + this.dID[this.lID] + ", " + this.dLayer[this.lLayer] + ", " + this.lSampling_frequency + "Hz, " + this.dMode[this.lMode] + ", " + this.lBitrate / 1000 + "kbps, " + this.dCRC[this.lProtection_bit];
    }

    public String MPA_saveAnddisplayHeader() {
        this.saveHeader();
        return this.MPA_displayHeader();
    }

    public byte[] MPA_deleteCRC(byte[] byArray) {
        if ((byArray[1] & 1) == 1) {
            return byArray;
        }
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, 4);
        System.arraycopy(byArray, 6, byArray2, 4, byArray.length - 6);
        byArray2[1] = (byte)(byArray2[1] | 1);
        return byArray2;
    }

    public int AC3_parseHeader(byte[] byArray, int n) {
        if ((0xFF & byArray[n]) != 11 || (0xFF & byArray[n + 1]) != 119) {
            return -1;
        }
        this.ID = 0;
        this.Emphasis = 0;
        this.Private_bit = 0;
        this.Protection_bit = 1;
        this.Sampling_frequency = this.ac3_frequency_index[3 & byArray[n + 4] >>> 6];
        if (this.Sampling_frequency < 1) {
            return -4;
        }
        this.Bitrate = this.ac3_bitrate_index[0x1F & byArray[n + 4] >>> 1];
        if (this.Bitrate < 1) {
            return -3;
        }
        this.Layer = 7 & byArray[n + 5];
        this.Padding_bit = 1 & byArray[n + 4];
        this.Mode = 7 & byArray[n + 6] >>> 5;
        this.Mode_extension = 0;
        int n2 = (0xFF & byArray[n + 6]) << 8 | 0xFF & byArray[n + 7];
        int n3 = 0;
        if ((this.Mode & 1) > 0 && this.Mode != 1) {
            this.Emphasis = 1 + (3 & byArray[n + 6] >>> 3);
            ++n3;
        }
        if ((this.Mode & 4) > 0) {
            this.Private_bit = 1 + (3 & byArray[n + 6] >>> (n3 > 0 ? 1 : 3));
            ++n3;
        }
        if (this.Mode == 2) {
            this.Mode_extension |= 6 & n2 >>> 10 - 2 * n3;
            ++n3;
        }
        switch (n3) {
            case 0: {
                this.Mode_extension |= 1 & n2 >>> 12;
                break;
            }
            case 1: {
                this.Mode_extension |= 1 & n2 >>> 10;
                break;
            }
            case 2: {
                this.Mode_extension |= 1 & n2 >>> 8;
                break;
            }
            case 3: {
                this.Mode_extension |= 1 & n2 >>> 6;
            }
        }
        this.Channel = this.ac3_channels[this.Mode] + (1 & this.Mode_extension);
        this.Copyright = 0;
        this.Original = 0;
        this.Time_length = 1.3824E8 / (double)this.Sampling_frequency;
        this.Size_base = this.ac3_size_table[3 & byArray[n + 4] >>> 6][0x1F & byArray[n + 4] >>> 1];
        this.Size = this.Size_base + this.Padding_bit * 2;
        return 1;
    }

    public int AC3_parseNextHeader(byte[] byArray, int n) {
        if ((0xFF & byArray[n]) != 11 || (0xFF & byArray[n + 1]) != 119) {
            return -1;
        }
        this.nID = 0;
        this.nEmphasis = 0;
        this.nPrivate_bit = 0;
        this.nProtection_bit = 1;
        this.nSampling_frequency = this.ac3_frequency_index[3 & byArray[n + 4] >>> 6];
        if (this.nSampling_frequency < 1) {
            return -4;
        }
        this.nBitrate = this.ac3_bitrate_index[0x1F & byArray[n + 4] >>> 1];
        if (this.nBitrate < 1) {
            return -3;
        }
        this.nLayer = 7 & byArray[n + 5];
        this.nPadding_bit = 1 & byArray[n + 4];
        this.nMode = 7 & byArray[n + 6] >>> 5;
        int n2 = (0xFF & byArray[n + 6]) << 8 | 0xFF & byArray[n + 7];
        int n3 = 0;
        if ((this.nMode & 1) > 0 && this.nMode != 1) {
            this.nEmphasis = 1 + (3 & byArray[n + 6] >>> 3);
            ++n3;
        }
        if ((this.nMode & 4) > 0) {
            this.nPrivate_bit = 1 + (3 & byArray[n + 6] >>> (n3 > 0 ? 1 : 3));
            ++n3;
        }
        if (this.nMode == 2) {
            this.nMode_extension |= 6 & n2 >>> 10 - 2 * n3;
            ++n3;
        }
        switch (n3) {
            case 0: {
                this.nMode_extension |= 1 & n2 >>> 12;
                break;
            }
            case 1: {
                this.nMode_extension |= 1 & n2 >>> 10;
                break;
            }
            case 2: {
                this.nMode_extension |= 1 & n2 >>> 8;
                break;
            }
            case 3: {
                this.nMode_extension |= 1 & n2 >>> 6;
            }
        }
        this.nChannel = this.ac3_channels[this.Mode] + (1 & this.nMode_extension);
        this.nCopyright = 0;
        this.nOriginal = 0;
        this.nTime_length = 1.3824E8 / (double)this.nSampling_frequency;
        this.nSize_base = this.ac3_size_table[3 & byArray[n + 4] >>> 6][5 & byArray[n + 4] >>> 1];
        this.nSize = this.nSize_base + this.nPadding_bit * 2;
        return 1;
    }

    public int AC3_compareHeader() {
        if (this.lLayer != this.Layer) {
            return 1;
        }
        if (this.lBitrate != this.Bitrate) {
            return 2;
        }
        if (this.lSampling_frequency != this.Sampling_frequency) {
            return 3;
        }
        if (this.lMode != this.Mode) {
            return 4;
        }
        if (this.lMode_extension != this.Mode_extension) {
            return 5;
        }
        return 0;
    }

    public String AC3_displayHeader() {
        return "AC-3" + this.bsmod[this.lLayer] + ", " + this.acmod[this.lMode] + this.lfe[1][1 & this.lMode_extension] + "(" + this.ac3_channels[this.lMode] + this.lfe[0][1 & this.lMode_extension] + ")" + this.dsurmod[this.lMode_extension >>> 1] + this.cmixlev[this.lEmphasis] + this.surmixlev[this.lPrivate_bit] + ", " + this.lSampling_frequency + "Hz, " + this.lBitrate / 1000 + "kbps";
    }

    public String AC3_saveAnddisplayHeader() {
        this.saveHeader();
        return this.AC3_displayHeader();
    }

    public int DTS_parseHeader(byte[] byArray, int n) {
        if (byArray[n] != 127 || byArray[n + 1] != -2 || byArray[n + 2] != -128 || byArray[n + 3] != 1) {
            return -1;
        }
        this.ID = 0;
        this.Emphasis = 0;
        this.Protection_bit = 1;
        this.Sampling_frequency = this.dts_frequency_index[0xF & byArray[n + 8] >>> 2];
        if (this.Sampling_frequency < 1) {
            return -4;
        }
        this.Bitrate = this.dts_bitrate_index[(3 & byArray[n + 8]) << 3 | 7 & byArray[n + 9] >>> 5];
        if (this.Bitrate < 1) {
            return -3;
        }
        this.Layer = 0;
        this.Padding_bit = 0;
        this.Private_bit = 0;
        this.Mode = (0xF & byArray[n + 7]) << 2 | (0xC0 & byArray[n + 8]) >>> 6;
        this.Mode_extension = 0;
        this.Channel = this.dts_channels[this.Mode];
        this.Copyright = 0;
        this.Original = 0;
        this.Size = (1 & byArray[n + 4]) << 6 | (0xFC & byArray[n + 5]) >>> 2;
        this.Size = this.Size + 1 << 5;
        this.Time_length = 90000.0 * (double)this.Size / (double)this.Sampling_frequency;
        this.Size = (3 & byArray[n + 5]) << 12 | (0xFF & byArray[n + 6]) << 4 | (0xF0 & byArray[n + 7]) >>> 4;
        ++this.Size;
        this.Size_base = this.Size;
        return 1;
    }

    public int DTS_parseNextHeader(byte[] byArray, int n) {
        if (byArray[n] != 127 || byArray[n + 1] != -2 || byArray[n + 2] != -128 || byArray[n + 3] != 1) {
            return -1;
        }
        this.nID = 0;
        this.nEmphasis = 0;
        this.nProtection_bit = 1;
        this.nSampling_frequency = this.dts_frequency_index[0xF & byArray[n + 8] >>> 2];
        if (this.nSampling_frequency < 1) {
            return -4;
        }
        this.nBitrate = this.dts_bitrate_index[(3 & byArray[n + 8]) << 3 | 7 & byArray[n + 9] >>> 5];
        if (this.nBitrate < 1) {
            return -3;
        }
        this.nLayer = 0;
        this.nPadding_bit = 0;
        this.nPrivate_bit = 0;
        this.nMode = (0xF & byArray[n + 7]) << 2 | (0xC0 & byArray[n + 8]) >>> 6;
        this.nMode_extension = 0;
        this.nChannel = this.dts_channels[this.nMode];
        this.nCopyright = 0;
        this.nOriginal = 0;
        this.nSize = (1 & byArray[n + 4]) << 6 | (0xFC & byArray[n + 5]) >>> 2;
        this.nSize = this.nSize + 1 << 5;
        this.nTime_length = 90000.0 * (double)this.nSize / (double)this.nSampling_frequency;
        this.nSize = (3 & byArray[n + 5]) << 12 | (0xFF & byArray[n + 6]) << 4 | (0xF0 & byArray[n + 7]) >>> 4;
        ++this.nSize;
        this.nSize_base = this.nSize;
        return 1;
    }

    public int DTS_compareHeader() {
        if (this.lLayer != this.Layer) {
            return 1;
        }
        if (this.lBitrate != this.Bitrate) {
            return 2;
        }
        if (this.lSampling_frequency != this.Sampling_frequency) {
            return 3;
        }
        if (this.lMode != this.Mode) {
            return 4;
        }
        if (this.lMode_extension != this.Mode_extension) {
            return 5;
        }
        if (this.lSize != this.Size) {
            return 6;
        }
        return 0;
    }

    public String DTS_displayHeader() {
        return "DTS, " + this.dts_acmod[this.lMode] + "(" + this.dts_channels[this.lMode] + "), " + this.lSampling_frequency + "Hz, " + (double)this.lBitrate / 1000.0 + "kbps, " + this.lSize + "BpF";
    }

    public String DTS_saveAnddisplayHeader() {
        this.saveHeader();
        return this.DTS_displayHeader();
    }

    private int littleEndian(byte[] byArray, int n, int n2, boolean bl) {
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            n3 |= bl ? (0xFF & byArray[n + i]) << i * 8 : (0xFF & byArray[n + i]) << (n2 - 1 - i) * 8;
        }
        return n3;
    }

    private int littleEndian(int n, int n2) {
        if (!this.INTEL) {
            return n;
        }
        if (n2 == 4) {
            return 0xFF & n >>> 24 | (0xFF & n >>> 16) << 8 | (0xFF & n >>> 8) << 16 | (0xFF & n) << 24;
        }
        return 0xFF & n >>> 8 | (0xFF & n) << 8;
    }

    public int WAV_parseHeader(byte[] byArray, int n) {
        this.INTEL = false;
        if (byArray[n] != 82 || byArray[n + 1] != 73 || byArray[n + 2] != 70) {
            return -1;
        }
        if (byArray[n + 3] == 70) {
            this.INTEL = true;
        } else if (byArray[n + 3] != 88) {
            return -2;
        }
        this.ID = this.INTEL ? 0 : 1;
        this.Emphasis = 0;
        this.Protection_bit = 1;
        Arrays.sort(this.WaveChunks);
        if (this.littleEndian(byArray, n + 8, 4, false) != this.WaveChunks[0]) {
            return -3;
        }
        int n2 = 0;
        int n3 = 0;
        for (int i = n + 12; i < byArray.length - 4; ++i) {
            n2 = this.littleEndian(byArray, i, 4, false);
            if (Arrays.binarySearch(this.WaveChunks, n2) < 0) continue;
            if (n2 == this.WaveChunks[4]) {
                n3 = this.littleEndian(byArray, i + 4, 4, this.INTEL);
                this.Layer = this.littleEndian(byArray, i + 8, 2, this.INTEL);
                this.Channel = this.littleEndian(byArray, i + 10, 2, this.INTEL);
                this.Sampling_frequency = this.littleEndian(byArray, i + 12, 4, this.INTEL);
                this.Bitrate = this.littleEndian(byArray, i + 16, 4, this.INTEL) * 8;
                this.Mode = this.littleEndian(byArray, i + 20, 2, this.INTEL);
                this.Size = this.littleEndian(byArray, i + 22, 2, this.INTEL);
            } else if (n2 == this.WaveChunks[2]) {
                this.Size_base = n3 = this.littleEndian(byArray, i + 4, 4, this.INTEL);
                this.Emphasis = i + 8;
            } else {
                n3 = this.littleEndian(byArray, i + 4, 4, this.INTEL);
            }
            i += n3 + 3;
        }
        if (this.Bitrate < 1 || this.Sampling_frequency < 1 || this.Channel < 1) {
            return -4;
        }
        this.Padding_bit = 0;
        this.Private_bit = 0;
        this.Copyright = 0;
        this.Original = 0;
        this.Time_length = 90000.0 / (double)this.Sampling_frequency;
        switch (this.Layer) {
            case 1: {
                this.Mode_extension = 1;
                return 1;
            }
            case 80: {
                this.Mode_extension = 2;
                return 0;
            }
            case 85: {
                this.Mode_extension = 3;
                return 0;
            }
            case 8192: {
                this.Mode_extension = 4;
                return 0;
            }
        }
        this.Mode_extension = 0;
        return 0;
    }

    public String WAV_displayHeader() {
        return "RIF" + this.LSB_mode[this.lID] + ", " + (this.lMode_extension > 0 ? this.compression[this.lMode_extension] : "tag 0x" + Integer.toHexString(this.Layer)) + ", " + this.lChannel + "-ch, " + this.lSampling_frequency + "Hz, " + this.lSize + "bit, " + (double)this.lBitrate / 1000.0 + "kbps";
    }

    public String WAV_saveAnddisplayHeader() {
        this.saveHeader();
        return this.WAV_displayHeader();
    }

    public byte[] getRiffHeader() {
        byte[] byArray = new byte[]{82, 73, 70, 70, 0, 0, 0, 0, 87, 65, 86, 69, 102, 109, 116, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 100, 97, 116, 97, 0, 0, 0, 0};
        return byArray;
    }

    public void fillRiffHeader(String string) throws IOException {
        RandomAccessFile randomAccessFile = new RandomAccessFile(string, "rw");
        int n = (int)randomAccessFile.length() - 8;
        randomAccessFile.seek(3L);
        if (!this.INTEL) {
            randomAccessFile.write(88);
        }
        randomAccessFile.seek(4L);
        randomAccessFile.writeInt(this.littleEndian(n, 4));
        randomAccessFile.seek(16L);
        randomAccessFile.writeInt(this.littleEndian(16, 4));
        randomAccessFile.writeShort(this.littleEndian(1, 2));
        randomAccessFile.writeShort((short)this.littleEndian(this.lChannel, 2));
        randomAccessFile.writeInt(this.littleEndian(this.lSampling_frequency, 4));
        randomAccessFile.writeInt(this.littleEndian(this.lBitrate / 8, 4));
        randomAccessFile.writeShort((short)this.littleEndian(this.lMode, 2));
        randomAccessFile.writeShort((short)this.littleEndian(this.lSize, 2));
        randomAccessFile.seek(40L);
        randomAccessFile.writeInt(this.littleEndian(n - 36, 4));
        randomAccessFile.close();
    }

    public int LPCM_parseHeader(byte[] byArray, int n) {
        this.INTEL = true;
        this.ID = 0xFF & byArray[n];
        this.Padding_bit = (0xFF & byArray[n + 1]) << 8 | 0xFF & byArray[n + 2];
        this.Layer = 0xFF & byArray[n + 3];
        this.Protection_bit = 1;
        this.Private_bit = 0;
        this.Copyright = 0;
        this.Original = 0;
        this.Size_base = 0;
        this.Size = this.lpcm_bps_index[3 & byArray[n + 4] >>> 6];
        this.Sampling_frequency = this.lpcm_frequency_index[1 & byArray[n + 4] >>> 4];
        this.Channel = 1 + (7 & byArray[n + 4]);
        this.Emphasis = 0xFF & byArray[n + 5];
        this.Mode = this.Channel * this.Size / 8;
        this.Bitrate = this.Channel * this.Sampling_frequency * this.Size;
        if (this.Size < 1) {
            return -1;
        }
        this.Time_length = 90000.0 / (double)this.Sampling_frequency;
        return 0;
    }

    public String LPCM_displayHeader() {
        return "LPCM, DR-" + this.lEmphasis + ", " + this.lChannel + "-ch, " + this.lSampling_frequency + "Hz, " + this.lSize + "bit, " + (double)this.lBitrate / 1000.0 + "kbps";
    }

    public String LPCM_saveAnddisplayHeader() {
        this.saveHeader();
        return this.LPCM_displayHeader();
    }

    public int LPCM_compareHeader() {
        if (this.lChannel != this.Channel) {
            return 1;
        }
        if (this.lSampling_frequency != this.Sampling_frequency) {
            return 2;
        }
        if (this.lSize != this.Size) {
            return 3;
        }
        if (this.lEmphasis != this.Emphasis) {
            return 4;
        }
        return 0;
    }
}

