/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.ftp;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPFileEntryParser;
import org.apache.commons.net.ftp.FTPFileIterator;

public class FTPFileList {
    private LinkedList lines = null;
    private FTPFileEntryParser parser;
    private static final int EMPTY_DIR = -2;

    private FTPFileList(FTPFileEntryParser fTPFileEntryParser) {
        this.parser = fTPFileEntryParser;
        this.lines = new LinkedList();
    }

    public static FTPFileList create(InputStream inputStream, FTPFileEntryParser fTPFileEntryParser) throws IOException {
        FTPFileList fTPFileList = new FTPFileList(fTPFileEntryParser);
        fTPFileList.readStream(inputStream);
        fTPFileEntryParser.preParse(fTPFileList.lines);
        return fTPFileList;
    }

    public FTPFile[] getFiles() {
        return this.iterator().getFiles();
    }

    List getLines() {
        return this.lines;
    }

    FTPFileEntryParser getParser() {
        return this.parser;
    }

    public FTPFileIterator iterator() {
        return new FTPFileIterator(this);
    }

    public FTPFileIterator iterator(FTPFileEntryParser fTPFileEntryParser) {
        return new FTPFileIterator(this, fTPFileEntryParser);
    }

    public void readStream(InputStream inputStream) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        String string = this.parser.readNextEntry(bufferedReader);
        while (string != null) {
            this.lines.add(string);
            string = this.parser.readNextEntry(bufferedReader);
        }
        bufferedReader.close();
    }
}

