#import "GoPodController.h"

@implementation GoPodController

- (void) prefloadImages
{
	NSString* path;
	NSBundle* mainBdl = [NSBundle mainBundle];
	
	path = [mainBdl pathForResource:@"noipod" ofType:@"tif"];
	imageNoiPod = [[NSImage alloc] initWithContentsOfFile:path];
	path = [mainBdl pathForResource:@"capped" ofType:@"tif"];
	imageCapped = [[NSImage alloc] initWithContentsOfFile:path];
	path = [mainBdl pathForResource:@"uncapped" ofType:@"tif"];
	imageUncapped = [[NSImage alloc] initWithContentsOfFile:path];
}


- (void)dealloc
{
	[imageNoiPod dealloc];
	[imageCapped dealloc];
	[imageUncapped dealloc];
    [super dealloc];
}

- (id)init
{
    [super init];
	[self prefloadImages];
    return self;
}

- (void) updateDisplay:(int) state
{
	switch (state) {
		case noiPod:
			[ImageView setImage:imageNoiPod];
			break;
		case uncapped:
			[ImageView setImage:imageUncapped];
			break;
		case capped:
			[ImageView setImage:imageCapped];
			break;
	}
}

- (void) updateCurrentStateAndCloseDevice:(BOOL) toClose
{
	if (detectIpod()) {
		currentState = isCapped();
		if (toClose) closedev(); 
	} else {
		currentState = noiPod;
	}
}


- (void)applicationDidFinishLaunching:(NSNotification *)aNotification
{
	[appWindow setHidesOnDeactivate:FALSE];
	[appWindow setLevel:NSNormalWindowLevel];
	[self updateCurrentStateAndCloseDevice:true];
	[self updateDisplay:currentState];
}

- (IBAction)goAction:(id)sender
{
	unsigned long res; 
		
	[ProgressIndic startAnimation:self];
	if (currentState == noiPod) {
		[self updateCurrentStateAndCloseDevice:true];
		[self updateDisplay:currentState];
		Delay (20, &res);
		[ProgressIndic stopAnimation:self];
		if (currentState == noiPod) NSBeep();
		int r = NSRunInformationalAlertPanel(@"No iPod detected !",@"Please plug an iPod or run the Apple iPod Updater.",@"OK",nil,nil);
	} else {
		[self updateCurrentStateAndCloseDevice:false];
		switch (currentState) {
			case noiPod:
				NSBeep();
				break;
			case uncapped:
				reCap();
				currentState = capped;
				closedev();
				break;
			case capped:
				unCap();
				currentState = uncapped;
				closedev();
				break;
		}
		Delay (20, &res);
		[self updateDisplay:currentState];
		[ProgressIndic stopAnimation:self];
	}
}

@end
