/*
    goPod 1.1 by JiB, Darth Zgul, g-rem, kang & Alf.
    
    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

*/


#include "ipod.h"
#include "gui.h"

extern TGoPod *GoPod;
int detectIpod(void)
{
	int x;
        char test[2];
	for (x=1; x < 10; x++)
	{
	       	char devstring[25];
	       	sprintf(devstring, "\\\\.\\PHYSICALDRIVE%i", x);
		dev = open(devstring, O_RDWR | _O_RAW);

                if (dev == -1)
                       continue;
                lseek(dev, FIRMWARE_START, SEEK_CUR);
		read(dev, buffer, BLOCK_SIZE);

		if (buffer[54]=='S' && buffer[56] == 'T' && buffer[58] == 'O' && buffer [60] == 'P')
		{
			return 1;
		}

		else
	   	{
	    		close(dev);
	   	}
	}
	return 0;
}


int seekChaine(void)
{
	int chaine = 0,block_cap = 950*BLOCK_SIZE;

	lseek(dev, block_cap-FIRMWARE_START, SEEK_CUR);
        while ((block_cap < 800000) && read(dev, buffer, BLOCK_SIZE) != -1)
	{
      		block_cap += BLOCK_SIZE;
      
		for (byte_cap=0; byte_cap<BLOCK_SIZE; byte_cap++)
		{
			int found = 0;
			if ((buffer[byte_cap] == 0x8) && (chaine == 0))
			{
				chaine++;
				found = 1;
			}
			if ((buffer[byte_cap] == 0x0) && (chaine == 1))
			{
				chaine++;
				found = 1;
			}
			if ((buffer[byte_cap] == 0x9F) && (chaine == 2))
			{
				chaine++;
				found = 1;
			}
			if ((buffer[byte_cap] == 0xE5) && (chaine == 3))
			{
				chaine++;
				found = 1;
			}
			if ((buffer[byte_cap] == 0x38) && (chaine == 4))
			{
				chaine++;
				found = 1;
			}
			if ((buffer[byte_cap] == 0x01) && (chaine == 5))
			{
				chaine++;
				found = 1;
			}
			if ((buffer[byte_cap] == 0x90) && (chaine == 6))
			{
				chaine++;
				found = 1;
			}
			if ((buffer[byte_cap] == 0xE5) && (chaine == 7))
			{
				chaine++;
				return 1;
			}
			if (found == 0 && chaine != 0)
			{
				chaine = 0;
			}
		}
	}

	return 0;
}


int isCapped(void)
{
        if(seekChaine())
  	{

		if(buffer[byte_cap+1] == 0x1 && buffer[byte_cap+2] == 0x0)
		{
			return 1;
		}

		if(buffer[byte_cap+1] == 0x0 && buffer[byte_cap+2] == 0x1)
		{
			return 0;
		}
	}

	else
	{
		return -1;
	}
}


void unCap(void)
{
	buffer[byte_cap+1]=0x0;
	buffer[byte_cap+2]=0x1;
	lseek(dev, -BLOCK_SIZE, SEEK_CUR);
	write(dev, buffer, BLOCK_SIZE);
        lseek(dev, -BLOCK_SIZE, SEEK_CUR);
	read(dev, buffer, BLOCK_SIZE);
        if(!(buffer[byte_cap+1] == 0x0 && buffer[byte_cap+2] == 0x1))
		{
			Application->MessageBox("Failed to uncap your iPod.\nYou may have to restore your firmware.", "Failed to uncap", MB_OK);
		}
        else
		{
                        GoPod->GOdetect->Visible = false;
                        GoPod->GOcapped->Visible = false;
                        GoPod->GOuncapped->Visible = true;
		}
}


void reCap(void)
{
	buffer[byte_cap+1]=0x1;
	buffer[byte_cap+2]=0x0;
	lseek(dev, -BLOCK_SIZE, SEEK_CUR);
	write(dev, buffer, BLOCK_SIZE);
        lseek(dev, -BLOCK_SIZE, SEEK_CUR);
	read(dev, buffer, BLOCK_SIZE);
        if(buffer[byte_cap+1] == 0x1 && buffer[byte_cap+2] == 0x0)
		{
                        GoPod->GOdetect->Visible = false;
                        GoPod->GOuncapped->Visible = false;
                        GoPod->GOcapped->Visible = true;
		}
         else
		{
                        Application->MessageBox("Failed to cap your iPod.\nYou may have to restore your firmware.", "Failed to cap", MB_OK);
		}
}
 