/*
    goPod 1.0 by JiB, Darth Zgul, g-rem, kang & Alf.
    
    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

*/


#include <stdio.h>
#include <unistd.h>
#include <fcntl.h>

#define BLOCK_SIZE 512

int dev = 0, block_cap = 0, byte_cap = 0;
unsigned char buffer[BLOCK_SIZE+2];


int detectIpod(void)
{
	int x;
	for (x=1; x < 16; x++)
	{
		char devstring[14];
		sprintf(devstring, "/dev/disk%is2", x);
		dev = open(devstring, O_RDWR);		
		if ((dev !=0) && (dev !=-1))
		{
			read(dev, buffer, BLOCK_SIZE);
  	    
			if (buffer[54]=='S' && buffer[56] == 'T' && buffer[58] == 'O' && buffer [60] == 'P')
			{
				return 1;
			}
		
			else
			{
					close(dev);
			}
		}
	}
	
	return 0;
}


int seekChaine(void) 
{
	int chaine = 0;
	
	lseek(dev, block_cap, SEEK_CUR);
	while ((block_cap < 8388608) && read(dev, buffer, BLOCK_SIZE) != -1)
	{
      		block_cap += BLOCK_SIZE;
      
		for (byte_cap=0; byte_cap<BLOCK_SIZE; byte_cap++) 
		{
			int found = 0;
			if ((buffer[byte_cap] == 0x8) && (chaine == 0)) 
			{
				chaine++;
				found = 1;
			}
			if ((buffer[byte_cap] == 0x0) && (chaine == 1)) 
			{
				chaine++;
				found = 1;
			}
			if ((buffer[byte_cap] == 0x9F) && (chaine == 2)) 
			{
				chaine++;
				found = 1;
			}
			if ((buffer[byte_cap] == 0xE5) && (chaine == 3)) 
			{
				chaine++;
				found = 1;
			}
			if ((buffer[byte_cap] == 0x38) && (chaine == 4)) 
			{
				chaine++;
				found = 1;
			}
			if ((buffer[byte_cap] == 0x01) && (chaine == 5)) 
			{
				chaine++;
				found = 1;
			}
			if ((buffer[byte_cap] == 0x90) && (chaine == 6)) 
			{	
				chaine++;
				found = 1;
			}
			if ((buffer[byte_cap] == 0xE5) && (chaine == 7)) 
			{
				chaine++;
				read(dev, &buffer[BLOCK_SIZE], 2);
				return 1;
			}
			if (found == 0 && chaine != 0) 
			{
				chaine = 0;
			}
		}
	}
			
	return 0;		
}


int isCapped(void) 
{
  	if(seekChaine())
  	{	
		
		if(buffer[byte_cap+1] == 0x1 && buffer[byte_cap+2] == 0x0)
		{
			return 1;
		}
	  
		if(buffer[byte_cap+1] == 0x0 && buffer[byte_cap+2] == 0x1)
		{
			return 0;
		}
	}
	
	else
	{  	
		return -1;
	}	
}


void unCap(void) 
{
	buffer[byte_cap+1]=0x0;
	buffer[byte_cap+2]=0x1;
	lseek(dev, -(BLOCK_SIZE+2)+byte_cap+1, SEEK_CUR);
	write(dev, &buffer[byte_cap+1], 2);
}


void reCap(void) 
{
	buffer[byte_cap+1]=0x1;
	buffer[byte_cap+2]=0x0;
	lseek(dev, -(BLOCK_SIZE+2)+byte_cap+1, SEEK_CUR);
	write(dev, &buffer[byte_cap+1], 2);	
}


int main(int argc, char **argv)
{
	if (!strcmp(argv[1], "detect"))
	{	
		if(detectIpod())
		{
			int test=isCapped();
			
			if(test==1)
			{
				printf("iPod capped.\n");
			}
			if(test==0)
			{
				printf("iPod not capped.\n");
			}
			if(test==-1)
			{
				printf("Error: Unable to determine wether or not your iPod is capped.\n");
			}
		}
			
		else
		{
			printf("iPod not detected.\n");
		}
	}			
	
	if(!strcmp(argv[1], "uncap"))
	{
		if(detectIpod() && isCapped()==1)
		{
			unCap();
		}
			
		else
		{
			printf("Error: Failed to uncap your iPod.\n");
		}
	}
	
	if(!strcmp(argv[1], "cap"))
	{
		if(detectIpod() && isCapped()==0)
		{
			reCap();
		}
			
		else
		{
			printf("Error: Failed to recap your iPod.\n");
		}
	}
			
	close(dev);
	exit(0);
	return 0;
}
