
/* DSP REGISTER AND BUS STORAGE INDEXES FOR LONG REGISTER ARRAY */
/*DD*/
#define REG_X0 0
#define REG_X1 1
#define REG_Y0 2
#define REG_Y1 3
/*DDD*/
#define REG_A0 4
#define REG_A1 5
#define REG_A2 6
#define REG_B0 7
#define REG_B1 8
#define REG_B2 9
/*TTT*/
#define REG_R0 10
#define REG_R1 11
#define REG_R2 12
#define REG_R3 13
#define REG_R4 14
#define REG_R5 15
#define REG_R6 16
#define REG_R7 17
/*NNN*/
#define REG_N0 18
#define REG_N1 19
#define REG_N2 20
#define REG_N3 21
#define REG_N4 22
#define REG_N5 23
#define REG_N6 24
#define REG_N7 25
/*FFF*/
#define REG_M0 26
#define REG_M1 27
#define REG_M2 28
#define REG_M3 29
#define REG_M4 30
#define REG_M5 31
#define REG_M6 32
#define REG_M7 33
/*GGG*/
#define REG_OMR 34
#define REG_SR 35
#define REG_SP 36
#define REG_LA 37
#define REG_LC 38
#define REG_SSTH 39
#define REG_SSTL 54
#define REG_PC 70

/* MEMORY MAPPED REGISTERS AND THEIR ASSOCIATED ADDRESSES */
#define MR_TSR 71 /* TIME SLOT REGISTER FFEE */
#define MR_IPR 72 /* INTERRUPT PRIORITY REGISTER FFFF */
#define MR_BCR 73 /* BUS CONTROL REGISTER FFFE*/
#define MR_STX 74 /* SCI TRANSMIT BYTE FFF6,FFF5,FFF4*/
#define MR_SRX 75 /* SCI RECEIVE BYTE FFF6,FFF5,FFF4*/
#define MR_SCCR 76 /* SCI CLOCK CONTROL REGISTER FFF2 */
#define MR_SSR 77 /* SCI STATUS REGISTER FFF1 */
#define MR_SCR 78 /* SCI CONTROL REGISTER FFF2 */
#define MR_SSITX 79 /* SSI TX REGISTER FFEF */
#define MR_SSIRX 80 /* SSI RX REGISTER FFEF */
#define MR_SSICB 81 /* SSI CRB FFED */
#define MR_SSICA 82 /* SSI CRA FFEC */
#define MR_HTX  83 /* HOST TRANSMIT REGISTER FFEB */
#define MR_HRX  84 /* HOST RECEIVE REGISTER FFEB */
#define MR_HSR  85 /* HOST STATUS REGISTER FFE9 */
#define MR_HCR  86 /* HOST CONTROL REGISTER FFE8 */
#define MR_PCD  87 /* PORT C DATA REGISTER FFE5 */
#define MR_PBD  88 /* PORT B DATA REGISTER FFE4 */
#define MR_PCDDR 89 /* PORT C DATA DIRECTION REGISTER FFE3 */
#define MR_PBDDR 90 /* PORT B DATA DIRECTION REGISTER FFE2 */
#define MR_PCC 91 /* PORT C CONTROL REGISTER */
#define MR_PBC 92 /* PORT B CONTROL REGISTER */
#define MR_SSISR 93 /* SSI STATUS REGISTER FFEE */

#define REG_CYCL 94 
#define REG_ICNT 95

#define HST_ICR 96 /* Host processor Host port map */
#define HST_CVR 97
#define HST_ISR 98
#define HST_IVR 99
#define HST_RXH 100
#define HST_RXM 101
#define HST_RXL 102
#define HST_TXH 103
#define HST_TXM 104
#define HST_TXL 105

#define SCI_SRX 106 /* SCI receive data register */

/* LONG REGISTERS here for display flags only */
#define LONG_X   107 
#define LONG_Y   108 
#define LONG_A   109 
#define LONG_B   110 
#define REG_IL   111 /*INSTRUCTION LATCH*/

#define CNT1     114 
#define CNT2     115 
#define CNT3     116 
#define CNT4     117 
#define MR_STXA  118    /* SCI STXA REGISTER */
#define LAST_DISPLAY 119 /* LAST REGISTER TO DISPLAY +1 */

/*DATA ALU BUSSES*/
#define BUS_DXB 120
#define BUS_DYB 121
#define BUS_ZB 122
#define BUS_MB 123
#define BUS_EB 124
#define BUS_LSA 125
#define BUS_MSA 126
#define BUS_EXA 127
#define BUS_AS0 128
#define BUS_AS1 129
#define BUS_AS2 130
#define BUS_LSP 131
#define BUS_MSP 132
#define BUS_EXT 133
#define BUS_ZBE 134
#define BUS_MBE 135
#define BUS_EBE 136
#define REG_DSL0 137
#define REG_DSL1 138
#define REG_DSL2 139

/*ADDRESS ALU */
#define BUS_LUB 140
#define BUS_HUB 141
#define BUS_LMB 142
#define BUS_HMB 143 
#define BUS_LNB 144
#define BUS_HNB 145
#define BUS_LRB 146
#define BUS_HRB 147
#define BUS_XAB 148
#define BUS_YAB 149
#define BUS_PAB 150
#define BUS_XDB 151
#define BUS_YDB 152
#define BUS_PDB 153
#define BUS_GDB 154
#define BUS_XXXX 155 /* FLAG VALUE FOR PUSH PULL FUNCTIONS */
#define BUS_GONE 156 /* READ TO HERE TO GET RID OF SOMETHING */
#define REG_TMPH 157 /*TEMPORARY ADDRESS HIGH*/
#define REG_TMPL 158 /*TEMPORARY ADDRESS LOW*/

/* NON-DISPLAYED SCI REGISTERS */
#define SCI_RSH 159
#define SCI_TRSH 160 /* timed input file SCI (simple) receive shift value */
#define SCI_ICLK 161 /* SCI INTERNAL CLOCK COUNTER */
#define SCI_RB   162 /* SCI RECEIVE CLOCK COUNT SINCE LAST RECEIVED CHAR */
#define SCI_TB   163 /* SCI TRANSMIT CLOCK COUNT SINCE START OF CHARACTER*/
#define SCI_RTM  164 /* EXTERNALLY DEFINED RECEIVE CLOCK SPACING */
#define SCI_C12BIT 165 /* 12 BIT INTERNAL SERIAL CLOCK */
#define SCI_CPREIN 166 /* SCI INTERNAL CLOCK COUNTER PRESCALER INPUT*/
#define SCI_CPROUT 167 /* SCI INTERNAL CLOCK COUNTER PRESCALER OUTPUT*/
#define SCI_ECLK 168 /* EXTERNAL SCI CLOCK COUNTER */
#define SCI_DATA 169 /* SCI RECEIVE SHIFT REGISTER DATA */
#define SCI_TDATA 170 /* SCI TRANSMIT SHIFT REGISTER DATA */

/* NON-DISPLAYED SSI REGISTERS */
#define SSI_RSH 171
#define SSI_TSH 172
#define SSI_TBIT 173 /* TRANSMIT BIT MASK FOR SSI DATA */
#define SSI_DATA 174 /* SSI RECEIVE SHIFT REGISTER DATA */
#define SSI_TDATA 175 /* SSI TRANSMIT DATA */

/* NON-DISPLAYED HOST REGISTERS */
#define HST_ADDR 176 /* HOST PORT ADDRESS FOR SEQUENTIAL REGISTER ACCESSES */

/* PROGRAM CONTROLLER REGISTERS */
#define ADD_BKIL  177 /* ADDRESS OF DATA IN BACKUP IL */
#define ADD_IL    178 /* ADDRESS OF INSTRUCTION IN IL */
#define ADD_PDB   179 /* ADDRESS OF DATA ON PDB */
#define BUS_PABN  180 /* NEXT PAB VALUE */
#define BUS_XABN  181 /* NEXT XAB VALUE */
#define BUS_YABN  182 /* NEXT YAB VALUE */
#define EXT_IRQA 183
#define EXT_IRQB 184
#define EXT_MODE 185    /* EXTERNAL MODE CONTROL PIN VALUES 0,1,2 OR 3 */
#define EXT_RSET 186
#define IBS_SWITCH 187 /* INTERNAL BUS SWITCH DATA */
#define IL_ACON   188   /* INSTRUCTION LATCH INPUT TO ACON ROM */
#define IL_IBS    189   /* INSTRUCTION LATCH INPUT TO IBS ROM */
#define IL_PAG    190   /* INSTRUCTION LATCH INPUT TO PAG ROM */
#define MR_OBCR  191 /* OLD BCR VALUE PRIOR TO MEMORY UPDATES */
#define PAB_BKIL 192 /* ADDRESS OF INSTRUCTION IN BACKUP IL */
#define PAINB     193 /* INTERRUPT RETURN ADDRESS BUS */
#define PASHB     194 /* STACK HIGH BUS */
#define PINC      195      /* INCREMENTED PAB VALUE */
#define PNEW      196      /* NEW PC VALUE FOR JUMP COMMANDS */
#define POLD      197      /* INSTRUCTION NON-INCREMENTED PC VALUE */
#define REG_BKIL 198 /*BACKUP INSTRUCTION LATCH*/
#define REG_IMM  199 /*IMMEDIATE DATA*/
#define REG_IVEC 200 /* INTERRUPT VECTOR */
#define REG_OMRR 201 /* OLD VALUE OF OMR PRIOR TO MEMORY UPDATES */
#define REG_TLC  202 /*TEMPORARY LOOP COUNTER STORAGE FOR REPEAT INST*/

/* REGISTER VALUES USED BY USER INTERFACE */
#define DISASM_ADD 203 /* ADDRESS USED BY DISASSEMBLE COMMAND */
#define FLG_IEOF 204   /* INPUT END OF FILE FLAG */
#define FLG_IJMP  205   /* INSTRUCTION JUMP */
#define REG_EXEC 206    /* NEXT INSTRUCTION ADDRESS */
#define REG_OMRS 207    /* DELAYED OMR VALUE FOR PIPELINED ADDRESS FORMATION */

/* CURRENT PIN INPUTS AND FORCING DIRECTION */
#define PC_IN    210
#define PC_MODIN 210  /* EXTERNAL PIN VALUES */
#define PC_PAIN  211  /* PORT A INPUTS */
#define PC_PBIN  212  /* PORT B INPUTS */
#define PC_PCIN  213  /* PORT C INPUTS */
#define PC_PDIN  214  /* PORT D INPUTS */

#define PC_IND   215
#define PC_MODID 215 /* IMC DIRECTION */
#define PC_PAID  216  /* PORT A INPUT DIRECTION */
#define PC_PBID  217  /* PORT B INPUTS */
#define PC_PCID  218  /* PORT C INPUT DIRECTION */
#define PC_PDID  219  /* PORT D INPUTS */

/* CURRENT PIN OUTPUTS AND FORCING DIRECTION */
#define PC_OUT   220
#define PC_MDOUT 220 /* external forcing value */
#define PC_PAOUT 221   /* PORT A OUTPUTS */
#define PC_PBOUT 222   /* PORT B OUTPUTS */
#define PC_PCOUT 223   /* PORT C OUTPUTS */
#define PC_PDOUT 224   /* PORT D OUTPUTS */

#define PC_OUTD  225
#define PC_MDOD  225 /* external signal force mask */
#define PC_PAOD  226   /* PORT A OUTPUTS */
#define PC_PBOD  227   /* PORT B OUTPUTS */
#define PC_PCOD  228   /* PORT C OUTPUTS */
#define PC_PDOD  229   /* PORT D OUTPUTS */

/* PREVIOUS PIN INPUTS AND FORCING DIRECTION */
#define PP_IN    230
#define PP_MODIN 230  /* EXTERNAL PIN VALUES */
#define PP_PAIN  231  /* PORT A INPUTS */
#define PP_PBIN  232  /* PORT B INPUTS */
#define PP_PCIN  233  /* PORT C INPUTS */
#define PP_PDIN  234  /* PORT D INPUTS */

#define PP_IND   235
#define PP_MODID 235 /* IMC DIRECTION */
#define PP_PAID  236  /* PORT A INPUT DIRECTION*/
#define PP_PBID  237  /* PORT B INPUTS */
#define PP_PCID  238  /* PORT C INPUT DIRECTION*/
#define PP_PDID  239  /* PORT D INPUTS */

/* PREVIOUS PIN OUTPUTS AND FORCING DIRECTION */
#define PP_OUT   240
#define PP_MDOUT 240 /* external signal force mask */
#define PP_PAOUT 241   /* PORT A OUTPUTS */
#define PP_PBOUT 242   /* PORT B OUTPUTS */
#define PP_PCOUT 243   /* PORT C OUTPUTS */
#define PP_PDOUT 244   /* PORT D OUTPUTS */

#define PP_OUTD  245
#define PP_MDOD  245
#define PP_PAOD  246   /* PORT A OUTPUTS */
#define PP_PBOD  247   /* PORT B OUTPUTS */
#define PP_PCOD  248   /* PORT C OUTPUTS */
#define PP_PDOD  249   /* PORT D OUTPUTS */

#define WADDR_L  260    /* L ADDRESSES (LAST 10) ACCESSED FOR WRITE */
#define WADDR_X  270    /* X ADDRESSES (LAST 10) ACCESSED FOR WRITE */
#define WADDR_Y  280    /* Y ADDRESSES (LAST 10) ACCESSED FOR WRITE */
#define WADDR_P  290    /* P ADDRESSES (LAST 10) ACCESSED FOR WRITE */

#define RADDR_L  300    /* X ADDRESSES (LAST 10) ACCESSED FOR READ */
#define RADDR_X  310    /* X ADDRESSES (LAST 10) ACCESSED FOR READ */
#define RADDR_Y  320    /* Y ADDRESSES (LAST 10) ACCESSED FOR READ */
#define RADDR_P  330    /* P ADDRESSES (LAST 10) ACCESSED FOR READ */

#define BRADDRL  340    /* X ADDRESSES (LAST 10) ACCESSED FOR READ */
#define BRADDRX  350    /* X ADDRESSES (LAST 10) ACCESSED FOR READ */
#define BRADDRY  360    /* Y ADDRESSES (LAST 10) ACCESSED FOR READ */
#define BRADDRP  370    /* P ADDRESSES (LAST 10) ACCESSED FOR READ */
#define BWADDRL  380    /* X ADDRESSES (LAST 10) ACCESSED FOR WRITE */
#define BWADDRX  390    /* X ADDRESSES (LAST 10) ACCESSED FOR WRITE */
#define BWADDRY  400    /* Y ADDRESSES (LAST 10) ACCESSED FOR WRITE */
#define BWADDRP  410    /* P ADDRESSES (LAST 10) ACCESSED FOR WRITE */

#define HADDR    420    /* START OF 20 ADDRESSES FOR HISTORY COMMAND */
#define HADDROP1 440    /* OP CODE 1 FOR HISTORY COMMAND (20 LOCATIONS) */
#define HADDROP2 460    /* OP CODE 2 FOR HISTORY COMMAND (20 LOCATIONS) */

#define DSPRMAX 480 /*MAXIMUM LENGTH OF DSP_R ARRAY*/
#define DSPFMAX 230 /*MAXIMUM LENGTH OF DSP_F ARRAY*/

/* REGISTER NAMES WHICH REQUIRE EXTRA PROCESSING TO DETERMINE EXACT REGISTER */
#define REG_DD  DSPRMAX
#define REG_DDD (DSPRMAX+04)
#define REG_TTT (DSPRMAX+12)
#define REG_NNN (DSPRMAX+20)
#define REG_FFF (DSPRMAX+28)
#define REG_GGG (DSPRMAX+52)
#define REG_D   (DSPRMAX+60)
#define REG_X   (DSPRMAX+62)
#define REG_Y   (DSPRMAX+64)
#define REG_XX  (DSPRMAX+66)
#define REG_YY  (DSPRMAX+70)
#define REG_LLL (DSPRMAX+74)
#define REG_EE  (DSPRMAX+82)
#define REG_SSH (DSPRMAX+102)
#define REG_SSL (DSPRMAX+103)
#define REG_ALONG (DSPRMAX+104)
#define REG_BLONG (DSPRMAX+105)
#define REG_AB  (DSPRMAX+106)
#define REG_BA  (DSPRMAX+107)
#define REG_A   (DSPRMAX+108)
#define REG_B   (DSPRMAX+109)
#define REG_CCR (DSPRMAX+110)
#define REG_MR (DSPRMAX+111)
#define REG_JJJ (DSPRMAX+86)

/* DSP FLAG INDEXES for integer type flags */
/* DECODED DATA ALU INSTRUCTION. THESE MUST STAY IN THIS ORDER */
#define DATA_ALU  1   /* START OF DATA ALU INSTRUCTION DECODE */
#define DALU_INST 1   /* FIRST WORD OF DECODE IS DATA ALU INSTRUCTION */
#define DALU_PASS 2   /* PASS FLAG FOR DATA ALU OPERATION FUNCTION */
#define DALU_S1   3   /* DATA ALU SOURCE REGISTER 1 FOR DATA ALU OP */
#define DALU_S2   4   /* DATA ALU SOURCE REGISTER 2 FOR DATA ALU OP */
#define DALU_DEST 5   /* DATA ALU OP DESTINATION REGISTER */
#define DALU_MPYS 6   /* DATA ALU MULTIPLY SIGN FOR DATA ALU OP */

/* INTERRUPT NUMBERS THESE NEED TO STAY IN THIS ORDER */
#define INT_NMI   7  /* 1E NMI INTERRUPT PENDING LEVEL */
#define INT_SE    8 /*2 STACK ERROR INTERRUPT PENDING LEVEL */
#define INT_TRACE 9 /*4 TRACE INTERRUPT FLAG */
#define INT_SWI  10 /*6 SWI INTERRUPT PENDING LEVEL */
#define INT_IRQA 11 /*8 IRQA INTERRUPT PENDING LEVEL */
#define INT_IRQB 12 /*a IRQB INTERRUPT PENDING LEVEL */
#define INT_HSTC 13 /*0 HOST COMMAND INTERRUPT PENDING LEVEL */
#define INT_HSTR 14 /*20 HOST RECEIVE INTERRUPT PENDING LEVEL */
#define INT_HSTT 15 /*22 HOST TRANSMIT INTERRUPT PENDING LEVEL */
#define INT_SSRE 16 /*e SSI RECEIVE WITH EXCEPTION INTERRUPT PENDING LEVEL */
#define INT_SSR  17 /*c SSI RECEIVE INTERRUPT PENDING LEVEL */
#define INT_SSTE 18 /*12 SSI TRANSMIT WITH EXCEPTION INTERRUPT PENDING LEVEL */
#define INT_SST  19 /*10 SSI TRANSMIT INTERRUPT PENDING LEVEL */
#define INT_SCRE 20 /*16 SCI RECEIVE WITH EXCEPTION INTERRUPT PENDING LEVEL */
#define INT_SCR  21 /*14 SCI RECEIVE INTERRUPT PENDING LEVEL */
#define INT_SCT  22 /*18 SCI TRANSMIT INTERRUPT PENDING LEVEL */
#define INT_SCID 23 /*1a SCI IDLE LINE INTERRUPT PENDING LEVEL */
#define INT_SCTM 24 /*1c SCI TIMER INTERRUPT PENDING LEVEL */


#define ACONPLA   25   /* ACON PLA OUTPUT WORD */
#define AXYPIM    26      /* EXTERNAL X ADDRESS */
#define BBR       27    /* BUS GRANTED TO EXTERNAL BUS REQUEST SIGNAL */
#define BCONT     28    /* EXTERNAL BUS CONTENTION FLAG */
#define BFLAGP    29    /* EXTERNAL P BUS ACCESS REQUEST */
#define BFLAGX    30    /* EXTERNAL X BUS ACCESS REQUEST */
#define BFLAGY    31    /* EXTERNAL Y BUS ACCESS REQUEST */
#define BG_LOCK 32   /* USED TO LOCK OUT BUS GRANT SIGNALS */
#define BGCO       33 /* BUS CONTENTION WAS DUE TO BUS GRANT */
#define BITFUNC   34       /* BIT TEST, SET, OR CLEAR FUNCTION NUMBER FROM PDB5 AND PDB16 */
#define BITSELECT 35       /* BIT SELECTES BY PDB0..4 */
#define BPE       36       /* EXTERNAL P BUS ACCESS THIS MEMORY CYCLE */
#define BRD       37       /* EXTERNAL BUS READ THIS CYCLE */
#define BWR       38       /* EXTERNAL BUS WRITE THIS CYCLE */
#define BYE       39       /* EXTERNAL Y BUS ACCESS THIS MEMORY CYCLE */
#define BXE       40       /* EXTERNAL X BUS ACCESS THIS MEMORY CYCLE */
#define BXYPIR    41       /* INTERNAL MEMORY READ */
#define BXYPIW    42       /* INTERNAL MEMORY WRITE */
#define CCCC      43    /* CONDITION CODE TEST BITS FOR JUMP CC  */
#define CLK_FREE 44     /* FREE-RUNNING CLOCK ALTERNATES 0,1 */
#define CLK_STATE 45    /* EXECUTION CLOCK STATE :PHASE0, PHASE1, etc. */
#define DISASM_MEM 46      /* MEMORY TYPE USED BY DISASSEMBLE COMMAND */
#define DISASMF   47       /* FLAG FOR DISASSEMBLER PAGE DOWN */
#define EDG_IRQA 48 /* LATCHED EDGE MODE IRQA INTERRUPT */
#define EDG_IRQB 49 /* LATCHED EDGE MODE IRQB INTERRUPT */
#define ENA_IRQA 50 /* ENABLE IRQA INTERRUPT FOR EDGE TRIGGER */
#define ENA_IRQB 51 /* ENABLE IRQB INTERRUPT FOR EDGE TRIGGER */
#define FIRST_CYCLE 52  /* FIRST CYCLE OF NEW INSTRUCTION FLAG */
#define FLG_HDELAY   53  /* HOST PORT DELAY COUNTER FOR TRANSFER TO HRX */
#define FLG_BREAK  54 /* BREAKPOINT FLAG */
#define FLG_IPEND 55 /* PENDING INTERRUPT NUMBER */
#define FLG_RE   56 /* ENABLE SCI RECEIVER FUNCTIONS */
#define FLG_REPEAT 57 /* REPEAT MODE FLAG SET BY REPEAT INSTRUCTION */
#define FLG_RESET 58 /* LATCH FOR RESET CONDITION */
#define FLG_RMW 59   /* READ/MODIFY WRITE INSTRUCTION FLAG */
#define FLG_ROE  60 /* RECEIVER OVERRUN ERROR FOR SSI */
#define FLG_SBRK 61 /* SEND SCI BREAK SEQUENCE */
#define FLG_SEQN 62 /* SEQUENCE NUMBER FOR POSITION IN DECODE CASE STATEMENT */
#define FLG_STAT 63 /* EOI,EOR,ILLEGAL INST STATUS FLAG */
#define FLG_STOP 64 /* STOP INSTRUCTION EXECUTION */
#define FLG_STXA 65 /* MULTIDROP SCI ADDRESS FLAG */
#define FLG_SSRR 66 /* SCI STATUS REGISTER READ FLAG */
#define FLG_TE   67 /* ENABLE SCI TRANSMITTER FUNCTIONS */
#define FLG_TUE  68 /* TRANSMIT UNDERRUN ERROR FOR SSI */
#define FLG_WAIT 69 /* WAIT INSTRUCTION EXECUTION */
#define FR_DET_RX 70    /* SSI RECEIVER FRAME DETECT */
#define FR_DET_TX 71    /* SSI TRANSMITTER FRAME DETECT */
#define HDELAY1  72     /* HOST PORT DELAY HTX TO RXH_RXM_RXL */
#define HST_INIT 73      /* HOST PORT ENABLED BY WRITE OF PBC REG */
#define IBS_IMM   74 
#define IBS_RSM   75 
#define IBS_RW    76 
#define IBS_SEQ   77 
#define IBS_XD    78 
#define IBS_XS    79    /* X SOURCE FOR IBS OUTPUT */
#define IBS_YD    80    /* IBS ROM Y DESTINATION */
#define IBS_YS    81 
#define IF0_S     82    /* SSI INPUT FLAG 0 SYNCHRONIZED */
#define IF1_S     83    /* SSI INPUT FLAG 1 SYNCHRONIZED */
#define INT_RESPOND 84 /* LEVEL OF INTERRUPT BEING RESPONDED TO */
#define IV2_FETCH 85 /* FETCH OF INTERRUPT VECTOR 2 IN PROGRESS */
#define MMMRRR    86       /* ADDRESS FIELD */
#define MMMRRRB   87       /* SECOND ADDRESS FIELD FOR X:<ea> & Y:<ea> move */
#define OF0_S 88     /* SSI SYNCHRONIZED OUTPUT FLAG VALUES */
#define OF1_S 89     
#define P_OPCODE  90    /* DATA ALU PARALLEL OPCODE */
#define PAGROM_H  91    /* PAG ROM OUTPUT HIGH */
#define PAGROM_L  92    /* PAG ROM OUTPUT LOW BYTE */
#define PAGROM_S  93    /* PAG ROM SEQUENCE FOR NEXT CYCLE */
#define PAINBD    94       /* DISABLE TRANSFER OF PAINBSRC TO PAINB */
#define PAINBSRC 95  /* SOURCE FOR PAINB (POLD, PNEW, or BUS_PAB)*/
#define PALAT     96    /* PC=LA FLAG */
#define PALC1D    97       /* LOOP COUNT = 1 FLAG */
#define PCC       98    /* CONDITIONAL EXECUTION FLAG */
#define PENDO     99       /* END OF DO LOOP */
#define PENREP    100      /* END OF REPEAT SIGNAL */
#define PEXCNT1 101     /* PEXCNT1 PLA VALUE DURING EXCEPTION PROCESSING */
#define PEXCNT2 102     /* PEXCNT2 PLA VALUE DURING EXCEPTION PROCESSING */
#define PEXC    103     /* EXCEPTION STATE FLAG */
#define PEXCD     104      /* EXCEPTION VECTORS ON BUS */
#define PEXINC  105     /* EXCEPTION VECTOR ADVANCE FLAG */
#define PESTAD  106     /* EXCEPTION STATE ADVANCE FLAG */
#define PINT      107   /* INTERRUPT FLAG FROM INTERRUPT CONTROLLER */
#define PIPECLR 108     /* PIPE CLEAR COUNT */
#define PIVRAB    109      /* FIRST READ OF IV IN NEXT PMEM FETCH */
#define PLNI      110   /* LATCH NEW INSTRUCTION FLAG */
#define PLNIBK    111   /* LATCH INSTRUCTION FROM BACKUP LATCH */
#define PLOOPAG   112      /* GO TO TOP OF DO LOOP FLAG */
#define PMCCEN    113   /* PRCCEN SIGNAL DELAYED 1 CYCLE FOR JUMP TESTS */
#define PMKIND    114      /* PEVRE&PRACPT delayed by 1 cycle */
#define PMKINS   115 /* KILL INSTRUCTION SIGNAL ASSERTED DURING INT PROCESS */
#define PMRKIL    116   /* DISABLE REGISTER TRANSFER FLAG FOR TCC INST */
#define PRACPT  117     /* EXCEPTION ACCEPTED FLAG */
#define PRISD     118   /* REGISTER SOURCE AND DESTINATION FLAGS */
#define PRNEW     119   /* VALID NEW INSTRUCTION LATCHED NEXT CYCLE */
#define PTRACE    120   /* TRACE INTERRUPT FLAG */
#define PTRF0    121 /* TRACE FLAG DELAY LINE */
#define PTRF1     122      /* TRACE FLAG DELAY LINE */
#define PTRF3       123 /* TRACE FLAG DELAY LINE */
#define PUSH      124   /* JSR PUSH FLAG POLD,SR  */
#define P99F6     125 /* ONE OF TRACE INTERRUPT REQUEST SIGNALS */
#define R_FR_CNT 126    /* SSI RECEIVER FRAME COUNTER */
#define R_FR_S 127     /* SSI RECEIVER FRAME COUNT SYNCHRONIZED */
#define R_WL   128  /* SSI RECEIVE WORD LENGTH    */
#define R_WL_CNT  129   /* SSI RECEIVER WORD LENGTH COUNTER */
#define R_WL_S 130   /* SYNCHRONIZED RECEIVER WORD LENGTH */
#define RABXGD    131   /* INDEX FOR DESTINATION REGISTER FROM X OR G BUS */
#define RABXGS    132   /* INDEX FOR SOURCE REGISTER IN X OR G BUS */
#define RABYD     133   /* INDEX FOR DESTINATION REGISTER FROM Y BUS */
#define RABYS     134   /* INDEX FOR SOURCE REGISTER IN Y BUS */
#define RE_S 135     /* SSI RECEIVER ENABLE SYNCHRONIZED */
#define RE_SS 136    /* SSI RECEIVER ENABLE SYNCHRONIZED TWICE */
#define RESET_SSI 137   /* SSI IN PCC RESET CONDITION */
#define RGATE_WNDW 138    /* SSI RECEIVER GATED CLOCK WINDOW */
#define RPHG_CNT 139    /* SSI RECEIVER PHASE GENERATOR COUNT */
#define RX_CLK_SW 140   /* SSI RECEIVER CLOCK SWITCH FLAG */
#define RX_FIRSTSLOT 141 /* SSI RECEIVER FIRST SLOT FLAG */
#define RX_FLAG_EN 142    /* SSI RECEIVER FLAG ENABLE */
#define RX_FR_DEL 143   /* SSI DELAYED RECEIVER FRAME SYNC FOR BIT SYNC */
#define RX_FR_IN   144     /* SSI RECEIVE FRAME PULSE USED INTERNALLY     */
#define RX_FR_OUT 145   /* OUTPUT OF SSI INTERNAL RECEIVE FRAME GENERATOR */
#define RX_FR_S   146   /* SSI RECEIVER FRAME SYNCHRONIZED */
#define RX_FRAME  147   /* SSI RECEIVER FRAME SYNC ACTIVE */
#define RX_RESET 148 /* SSI RECEIVER IN RESET CONDITION */
#define SCI_BRK1 149 /* EXTRA 1 FOLLOWING SCI SEND BREAK */
#define SCI_INCHAR 150 /* TIMED MODE INPUT FILE SCI CHAR BEING RECEIVED */
#define SCI_INTRANS 151 /* SCI TIMED INPUT FILE INPUT CHAR TRANSITION */
#define SCI_PARITY 152 /* SCI TRANSMIT PARITY BIT VALUE */
#define SCI_PCCRESET 153   /* FLAG WHEN SCI IS RESET BY PCC */
#define SCI_PREAMBLE 154 /* SCI ENABLE PREAMBLE OUTPUT FLAG */
#define SCI_SBRK 155 /* SCI TRANSMIT SEND BREAK FLAG */
#define SCI_TBITS 156       /* EXPANDED SCI TRANSMIT BITS (through 171) */
#define SCI_TSHE 172  /* SCI TRANSMIT SHIFT REGISTER EMPTY FLAG */
#define SE_DISABLE 173   /* STACK ERROR DISABLE FLAG FOLLOWING TRANSITION */
#define SEQ_ACON  174    /* ACON SEQ BITS FOR NEXT DECODE INPUT */
#define SEQ_IBS   175    /* IBS SEQ BITS FOR NEXT DECODE INPUT */
#define SEQ_PEXC  176    /* SEQUENCE INPUT FOR PEXCNT1 PLA */
#define SEQ_PAG   177    /* PAG ROM SEQUENCE BITS FOR NEXT DECODE INPUT */
#define SMALLPLA  178    /* SMALL PLA OUTPUT WORD */
#define SSI_FPRESCALE 179  /* SSI FIXED PRESCALE COUNTER  */
#define SSI_IBITCLK 180  /* SSI INTERNAL BIT CLOCK */
#define SSI_RCLK  181    /* SSI RECEIVER CLOCK STATE */
#define SSI_RPHASE 182   /* SSI RECEIVER CLOCK PHASE */
#define SSI_RXSTATE 183  /* SSI RECEIVER STATE */
#define SSI_TCLK  184    /* SSI TRANSMIT CLOCK STATE */
#define SSI_TPHASE 185   /* SSI TRANSMITTER CLOCK PHASE */
#define SSI_TSR 186      /* TIME SLOT REGISTER HAS BEEN WRITTEN TO */
#define SSI_TXSTATE 187  /* SSI TRANSMITTER STATE */
#define SSI_VPRESCALE 188  /* SSI VARIABLE PRESCALE COUNTER */
#define T_FR_CNT 189     /* SSI TRANMSMITTER FRAME COUNTER */
#define T_FR_S 190      /* SSI TRANSMIT FRAME COUNT SYNCHRONIZED */
#define T_WL     191 /* SSI TRANSMIT WORD LENGTH */
#define T_WL_CNT  192    /* SSI TRANSMITTER WORD LENGTH COUNTER */
#define T_WL_S 193    /* SYNCHRONIZED TRANSMITTER WORD LENGTH */
#define TDE_S     194    /* SSI TRANSMIT DATA ENABLE SYNCHRONIZED */
#define TE_S      195    /* SSI TE SYNCHRONIZED ONCE */
#define TE_SS     196    /* SSI TRANSMITTER ENABLED SYNCHRONIZED SECOND TIME */
#define TGATE_WNDW 197     /* SSI TRANSMITTER GATED CLOCK WINDOW */
#define TPHG_CNT 198     /* SSI TRANSMITTER PHASE GENERATOR COUNT */
#define TSR_F 199        /* SYNCHRONIZED TSR FLAG */
#define TX_CLK_SW 200    /* SSI TRANSMIT CLOCK SWITCH FLAG */
#define TX_DATA_EN 201 /* SSI TRANSMITTER DATA ENABLED */
#define TX_FIRSTSLOT 202 /* SSI TRANSMIT FIRST SLOT FLAG */
#define TX_FR_EXT 203    /* SSI EXTERNAL TX FRAME DETECT EDGE */
#define TX_FR_IN   204      /* SSI TRANSMIT FRAME PULSE USED INTERNALLY     */
#define TX_FR_OUT 205     /* OUTPUT OF INTERNAL XMIT FRAME GENERATOR FOR SSI */
#define TX_FR_S   206    /* SSI TRANSMITTER FRAME SYNCHRONIZED */
#define TX_RESET 207     /* SSI TRANSMITTER RESET */
#define WAIT_CNT 208 /* MINIMUM CYCLES IN WAIT STATE COUNTER */


/* BREAKPOINT FLAGS.  THESE MUST REMAIN IN ORDER */
#define BRCOUNTL 210     /* NUMBER OF ADDRESSES IN BRADDR_L */
#define BRCOUNTX 211     /* NUMBER OF ADDRESSES IN BRADDR_X */
#define BRCOUNTY 212     /* NUMBER OF ADDRESSES IN BRADDR_Y */
#define BRCOUNTP 213     /* NUMBER OF ADDRESSES IN BRADDR_P */
#define BWCOUNTL 214     /* NUMBER OF ADDRESSES IN BWADDR_L */
#define BWCOUNTX 215     /* NUMBER OF ADDRESSES IN BWADDR_X */
#define BWCOUNTY 216     /* NUMBER OF ADDRESSES IN BWADDR_Y */
#define BWCOUNTP 217     /* NUMBER OF ADDRESSES IN BWADDR_P */

#define RCOUNT_L 218     /* NUMBER OF ADDRESSES IN RADDR_L */
#define RCOUNT_X 219     /* NUMBER OF ADDRESSES IN RADDR_X */
#define RCOUNT_Y 220     /* NUMBER OF ADDRESSES IN RADDR_Y */
#define RCOUNT_P 221     /* NUMBER OF ADDRESSES IN RADDR_P */
#define WCOUNT_L 222     /* NUMBER OF ADDRESSES IN WADDR_X */
#define WCOUNT_X 223     /* NUMBER OF ADDRESSES IN WADDR_X */
#define WCOUNT_Y 224     /* NUMBER OF ADDRESSES IN WADDR_Y */
#define WCOUNT_P 225     /* NUMBER OF ADDRESSES IN WADDR_P */
#define HCOUNT   226     /* NUMBER OF ADDRESSES IN HADDR */
#define HOFFSET  227     /* OFFSET INTO HADDR WHERE PREVIOUS VECTOR STORED */
#define HADDRCNT 228     /* COUNT OF NUMBER OF WORDS FETCHED PER INSTRUCTION */


/* OTHER DEFINITIONS - NOT ARRAY OFFSETS */
#define REG_ILLEG (-1)
#define REG_NONE (-2)
#define BUS_NONE (-2)

#define FIRST_PASS 1
#define SECOND_PASS 2
#define PR_NORM 0 /* FIRST STEP OF NORMAL PROCESSING SEQUENCE */
#define PR_RESET 1 /* START OF RESET PROCESSING */

/* DEFINITIONS ASSOCIATED WITH MEMORY AND REGISTER FLAGS */
#define LMEM 0 /* L MEMORY MAP FLAG FOR MEMORY FETCHES */
#define PMEM 1 /* P MEMORY MAP FLAG FOR MEMORY FETCHES */
#define PBMEM 2 /* P MEMORY BOOTSTRAP ROM 0-1F */
#define XMEM 3 /* X MEMORY MAP FLAG  FOR MEMORY FETCHES */
#define YMEM 4 /* Y MEMORY MAP FLAG FOR MEMORY FETCHES */

#define WRIT_BRK 1 /* WRITE IO FILE BREAK MEMORY FLAG BIT */
#define READ_BRK 2 /* READ IO FILE BREAK MEMORY FLAG BIT */
#define MEM_EXT 1 /* EXTERNAL MEMORY FLAG BIT */
#define MEM_SPEC 2 /* SPECIAL PROCESSING MEMORY LOCATION */
#define MEM_NONE 4 /* NON-EXISTANT MEMORY FLAG BIT */
#define WR_PROT 8 /* WRITE PROTECT MEMORY FLAG BIT */
#define BLOCKUSED 1 /* MEMORY BLOCK IS MODIFIED (NOT ALL FILLED WITH ONE VALUE) */
#define ON_DISK 2 /* MEMORY HAS BEEN PAGED OUT TO DISK */

/* GLOBAL STATUS FLAG BIT DEFINITIONS FOR FLG_STAT FIELDS */
#define GEOI 1 /* END OF INSTRUCTION */
#define GEOR 2 /* AT END OF 1 REPEAT CYCLE OF INSTRUCTION */
#define GILLEG 4 /* ILLEGAL OP CODE */
/* STATUS REGISTER BIT POSITION MASKS */
#define BIT_C 0x000001l /* CARRY BIT POSITION */
#define BIT_V 0x000002l /* OVERFLOW BIT POSITION */
#define BIT_Z 0x000004l /* ZERO BIT POSITION */
#define BIT_N 0x000008l /* NEGATIVE BIT POSITION */
#define BIT_U 0x000010l /* UNNORMALIZED BIT */
#define BIT_E 0x000020l /* EXTENSION BIT */
#define BIT_L 0x000040l /* LIMIT BIT */
#define BIT_LF 0x08000l /* LOOP FLAG */
#define BIT_T 0x2000l   /* TRACE FLAG */
/* PERIPHERAL INTERFACE FUNCTION DEFINITIONS */
#define PARITY_N 4 /* NO PARITY BIT */
#define PARITY_E 2 /* EVEN PARITY */
#define PARITY_O 3 /* ODD PARITY */
#define PARITY_0 0 /* FORCE PARITY BIT TO 0 */
#define PARITY_1 1 /* FORCE PARITY BIT TO 1 */
#define IDLE    (-2L) /* SCI IDLE FLAG */
#define BREAK   (-3L) /* SCI BREAK FLAG */ 

/* CLOCK PHASE FLAGS FOR DSPEXEC INSTRUCTION EXECUTION */
#define PHASE0 0
#define P0BCONT 1
#define PHASE1 2
#define PHASE2 3
#define P2WAIT 4  /* WAIT STATE WHILE EXECUTING EXTERNAL ACCESS WAIT CYCLES */
#define PHASE3 5

#define DSP56000 0  /* device numbers available for device type */
#define DSP56001 1


