;********************************************************
;														*
;	#@M16C START UP KIT MONITER S/W	 Ver1.00		*
;														*
;	FILENAME: mon30ram.h								*
;	VER		: 1.00.00									*
;	CPU		: M16C										*
;	FUNCTION: Header file of M16C start_up kit moniter	*
;				(1) RAM define							*
;	SPEC	:											*
;	OPTION	: "PDB" 0 : for KDB30						*
;					1 : for PDB30						*
;			  "DBG" 0 : for Normal use					*
;					1 : for DEBUG of moniter			*
;														*
;	CRAETE	: 1999.3.1									*
;														*
; 	Copyright(c) 1995-1999 MITSUBISHI ELECTRIC Co. 		*
; 	and MITSUBISHI ELECTRIC SEMICONDUCTOR SYSTEM Co.	*
;	All Rights Reserved.								*
;														*
;********************************************************
;---------------------------------------
;	for user program [42Byte]
;---------------------------------------
; ----- user register -----			; <bank-0>
wusr_r0:		.BLKW		1		; [R0]
wusr_r1:		.BLKW		1		; [R1]
wusr_r2:		.BLKW		1		; [R2]
wusr_r3:		.BLKW		1		; [R3]
wusr_a0:		.BLKW		1		; [A0]
wusr_a1:		.BLKW		1		; [A1]
wusr_fb:		.BLKW		1		; [FB]
;								; <bank-1>
wusr_r0b:		.BLKW		1		; [R0]
wusr_r1b:		.BLKW		1		; [R1]
wusr_r2b:		.BLKW		1		; [R2]
wusr_r3b:		.BLKW		1		; [R3]
wusr_a0b:		.BLKW		1		; [A0]
wusr_a1b:		.BLKW		1		; [A1]
wusr_fbb:		.BLKW		1		; [FB]
;
wusr_usp:		.BLKW		1		; [USP]
wusr_isp:		.BLKW		1		; [ISP]
wusr_sb:		.BLKW		1		; [SB]
wusr_intbl:		.BLKW		1		; [INTB(L)]
wusr_intbh:		.BLKW		1		; [INTB(H)]
; ----- user program save/load -----
busr_pcl:		.BLKB		1		; Program count(L) [SP]-4
busr_pcm:		.BLKB		1		; Program count(M) [SP]-3
busr_flgl:		.BLKB		1		; FLG(L) [SP]-2
busr_flgpch:	.BLKB		1		; FLG/Program count(H) [SP]-1
;---------------------------------------
;	for serial i/f[10Byte]
;---------------------------------------
brcv_dat:		.BLKB		1		; Receive data
bsnd_buf:		.BLKB		1		; Send data buffer
brcv_buf:		.BLKB		12		; Receive data Buffer
;---------------------------------------
;	for special area[18Byte]
;---------------------------------------
wspc_r0:		.BLKW		1		; [R0]
wspc_r1:		.BLKW		1		; [R1]
wspc_r2:		.BLKW		1		; [R2]
wspc_r3:		.BLKW		1		; [R3]
wspc_a0:		.BLKW		1		; [A0]
wspc_a1:		.BLKW		1		; [A1]
wspc_isp:		.BLKW		1		; [ISP]
;
bspc_pcl:		.BLKB		1		; Program count(L) [SP]-4
bspc_pcm:		.BLKB		1		; Program count(M) [SP]-3
bspc_flgl:		.BLKB		1		; FLG(L) [SP]-2
bspc_flgpch:	.BLKB		1		; FLG/Program count(H) [SP]-1
;---------------------------------------
;	inner data	(WORD)
;---------------------------------------
; ----- control main -----
wmoj_req:		.BLKW		1		; module REQ
wrst_inf:		.BLKW		1		; Reset information
wsnd_cntl:		.BLKW		1		; Send control information
wrcv_cntl:		.BLKW		1		; Receive control information
werr_inf:		.BLKW		1		; ERR informationm
wnow_cmd:		.BLKW		1		; Current command(2Byte)
wrcv_cnt:		.BLKW		1		; Receive data count
; ----- for comannd -----
wreg_no:		.BLKW		1		; Register select No.(ASCII)[XREG]
wdump_len:		.BLKW		1		; DUMP length [DUMP]
wdwnh_len:		.BLKW		1		; DWNH length [DWNH]
wmove_len:		.BLKW		1		; MOVE length [MOVE]
wfill_cnt:		.BLKW		1		; FILL repeat times [FILL]
wfill_dat:		.BLKW		1		; FILL data
wstep_cnt:		.BLKW		1		; step number[STEP]
wpass_cnt:		.BLKW		1		; pulse count[GPB]
wisp_bkup:		.BLKW		1		; ISP save work[STEP/GB]
; ----- work -----
wh2asc_wk:		.BLKW		2		; HEX->ASCII exchange work
;---------------------------------------
;	inner data	(Byte)
;---------------------------------------
; ----- control main -----
brcv_cmd1:		.BLKB		1		; CMD1(H) save
bnow_code:		.BLKB		1		; Current receive code(ASCII/BIN)
bstage_no:		.BLKB		1		; Process phase No. in commnad
bcmd_type:		.BLKB		1		; Type of receive command
; ----- for command -----
bdump_adr:		.BLKB		4		; DUMP TOP address[DUMP]
bdwnh_adr:		.BLKB		4		; DWNH TOP address[DWNH]
bfill_adr:		.BLKB		4		; FILL TOP address[DWNH]
bgo_adr:		.BLKB		4		; GOaddress[GO]
bgb_adr:		.BLKB		4		; GB/GPB address[GB][GPB]
bstep_acnt:		.BLKB		4		; step number save(ASCII)[STEP]
bpb_adrbuf:		.BLKB		4		; PB/GPB address save[PB][GPB]
bpb0_adr:		.BLKB		4		; PB0 address[PB]
bpb1_adr:		.BLKB		4		; PB1 address[PB]
badr_edit:		.BLKB		4		; address match address[*]
bmove_srcadr:	.BLKB		4		; MOVE src address[MOVE]
bmove_dstadr:	.BLKB		4		; MOVE src address[MOVE]
brtn_sts:		.BLKB		1		; execute status[*]
bbps_data:		.BLKB		1		; Transfer speed[BAUD]
bstp_data:		.BLKB		1		; Stop bit[BAUD]
bbrk_mod:		.BLKB		1		; Break mode[BM]
bdump_size:		.BLKB		1		; DUMP data size[DUMP]
bfill_size:		.BLKB		1		; FILL data size[FILL]
bbrk_inf:		.BLKB		1		; Break trigger[STOP]
bchksum:		.BLKB		1		; Checksum data(HEX)[*]
bpb_sw:			.BLKB		1		; PB SW(ASCII)[PB]
bpb_cntl:		.BLKB		1		; PB control information PB]
bspot_sw:		.BLKB		1		; snap break SW[GPB]
bfm_mod:		.BLKB		1		; FREE/SAMPLING mode[FM]
bled_sw:		.BLKB		1		; LED output enable SW[*]
; ----- for moniter  <-> user  I/F-----
bmon_bk:		.BLKB		1		; LED output backup
; ----- for special page -----
bbk_flgl:		.BLKB		1		; FLG(L) save
bbk_flgh:		.BLKB		1		;     (H)
bspc_no:		.BLKB		1		; Special pageNO
bspc_stepmd:	.BLKB		1		; Special page(STEP)mode
; ----- for calcuration parameter -----
bdat_ascbuf:	.BLKB		6		; ASCII code(6Byte)
bdat_16buf:		.BLKB		4		; HEX data(4Byte)
bstart_adr:		.BLKB		4		;  TOP address(4Byte)
bchksum_buf:	.BLKB		1		; Lower 8-bit SUM
dumy2:			.BLKB		1		;
; ----- work -----
badr_awk:		.BLKB		6		;  TOP address(ASCII) save
									;  ->(6 order ASCII data work)
blen_awk:		.BLKB		4		;  length / times (ASCII) save
									;  -> (4 order ASCII data work)
bsum_awk:		.BLKB		2		; Receive checksum save work[DWNH]
bchk_wk:		.BLKB		1		; judgement save work[DUMP]
;---------------------------------------
;	Additional area
;---------------------------------------
M_CM0:			.BLKB		1
M_CM1:			.BLKB		1
MU_CM0:			.BLKB		1
MU_CM1:			.BLKB		1


;---------------------------------------
;	for PDB30
;---------------------------------------
.IF PDB==ON
brrmb_adr6:		.BLKB		1			; RRMBaddress(ASCII)6  order
brrmb_adr5:		.BLKB		1			;  " 5 order
brrmb_adr4:		.BLKB		1			;  " 4 order
brrmb_adr3:		.BLKB		1			;  " 3 order
brrmb_adr2:		.BLKB		1			;  " 2 order
brrmb_adr1:		.BLKB		1			;  " 1 order
POOL:			.BLKB		1

.ENDIF



;
;********************************************************
;														*
;	FILENAME: mon30ram.h								*
;														*
; 	Copyright(c) 1995-1999 MITSUBISHI ELECTRIC Co. 		*
; 	and MITSUBISHI ELECTRIC SEMICONDUCTOR SYSTEM Co.	*
;	All Rights Reserved.								*
;														*
;********************************************************
