	INCLUDE PAGE.INC
	SUBTTL	VGA BIOS Module K
;****************************************************************
;
;	$Workfile:   vgak.asm  $
; 
; 	Copyright 1989, 1990 Quadtel Corporation.
; 	All rights reserved.
; 
;	Contents:
;	This module contains the character tables for creating
;	characters in graphics modes and for down loading
;	character sets.
;
; 	Modification History:
; 	$Log:   M:/vcs/vga/vgak.asv  $
;      
;         Rev 1.2   23 Jul 1991 20:52:02   dale
;      A compile option was added for font placement.
;      
;         Rev 1.1   03 Jun 1991 17:01:42   Darryl
;      $UPDATE:VGA BIOS core revision 11 modifications.
;      VGA BIOS modifications for core hook support.
;      $
;      
;         Rev 1.0   21 Dec 1990 11:00:56   Darryl
;      Initial checkin to VCS.
;
;	01/02/90  This module was changed from VGAJ to VGAK. This
;		  was done so the fonts would be at the end of the
;		  BIOS, allowing variable size fonts for VGAEDIT.
;
;	07/08/89  Speed optimizations made to the core VGA BIOS.
;		  No code changes to this module.
;
;****************************************************************

	.XLIST
	INCLUDE VGADATA.INC
	include	config.inc
	.LIST

	%OUT	Assembling VGA BIOS Module K

VGA_Segment SEGMENT PUBLIC byte
;VGA_Segment SEGMENT PUBLIC PARA

	PUBLIC	C8x8_Character_Set
	PUBLIC	C8x8_Character_Set_High
	PUBLIC	C8x14_Character_Set
	PUBLIC	C8x16_Character_Set
	PUBLIC	Mono_9x14_Characters
	PUBLIC	Mono_9x16_Characters

	ASSUME	CS:VGA_Segment
	ASSUME	DS:NOTHING
	ASSUME	ES:NOTHING

BEGIN = $
;****************************************************************
;   This is the 8x8 bit character set
;****************************************************************

IF ($-BEGIN) MOD 16
	ORG	($-BEGIN)+16-(($-BEGIN) MOD 16) + F8x8
ELSE
        ORG     ($-BEGIN) + F8x8
ENDIF

C8x8_Character_Set LABEL WORD
C8x8_Character_Set_High EQU WORD PTR $ + 1024
	INCLUDE C8x8SET.INC

;****************************************************************
;   This is the 8x14 bit character set
;****************************************************************

IF ($-BEGIN) MOD 16
	ORG	($-BEGIN)+16-(($-BEGIN) MOD 16) + F8x14
ELSE
        ORG     ($-BEGIN) + F8x14
ENDIF

;(99)C8x14_Character_Set LABEL WORD
;(99)	INCLUDE C8x14SET.INC

;****************************************************************
;    This is the 9x14 bit character set update table.
;****************************************************************

IF ($-BEGIN) MOD 16
	ORG	($-BEGIN)+16-(($-BEGIN) MOD 16) + F9x14
ELSE
        ORG     ($-BEGIN) + F9x14
ENDIF

Mono_9x14_Characters LABEL WORD
	INCLUDE C9x14SET.INC
;	DB	00

;****************************************************************
;    This is the 8x16 bit character set.
;****************************************************************

IF ($-BEGIN) MOD 16
	ORG	($-BEGIN)+16-(($-BEGIN) MOD 16)	 + F8x16
ELSE
        ORG     ($-BEGIN) + F8x16
ENDIF

C8x14_Character_Set LABEL WORD		;(99)

C8x16_Character_Set LABEL WORD
	INCLUDE C8x16SET.INC

;****************************************************************
;    This is the 9x16 bit character set update table.
;****************************************************************

IF ($-BEGIN) MOD 16
	ORG	($-BEGIN)+16-(($-BEGIN) MOD 16) + F9x16
ELSE
        ORG     ($-BEGIN) + F9x16
ENDIF

Mono_9x16_Characters LABEL WORD
	INCLUDE C9x16SET.INC
;	DB	00

if TSRFONT eq NO
		public	bold_16
bold_16		label	byte

	%OUT	Assembling BOLD_16 Font
	include	bold_16.fnt

endif
		public	romsize
romsize		label	byte

;****************************************************************

VGA_Segment ENDS

	END
