title		Extended Alternate Select Functions

;****************************************************************
;
;	$Workfile:   xaltsel.asm  $
; 
; 
;	Contents:
;
; 	Modification History:
; 	$Log:   M:/vcs/vga/64xx/xaltsel.asv  $
;      
;      
;****************************************************************
cgroup		group	VGA_Segment

	.XLIST
	include		config.inc
	include		font.inc
	include		biosdata.inc
	include		options.inc
	include		argframe.inc
	include		struc.inc

	INCLUDE VGADATA.INC
	.LIST

	%OUT	Assembling REGTBL

VGA_Segment	SEGMENT PUBLIC BYTE

	ASSUME	CS:VGA_Segment
	ASSUME	DS:bios_data
	ASSUME	ES:NOTHING

;
; utilities
	extrn	setscr		:near
	extrn	getscr		:near
	extrn	getreg		:near	; get an indexed register
	extrn   pgm_ext         :near
	extrn	set_option	:near
	extrn	get_tbl_ptr	:near	; locate parm table
	extrn	get_crtc_addr	:near	; return CRTC address in DX
	extrn	vs_enable	:near
	extrn	vs_disable	:near
	extrn	xmode_regs	:near
	extrn	GetScanLineCode	:near	; Get 200/350/400/480 line
	extrn	GetModeTblPtr	:near	; Get pointers to mode tbl
	extrn	GetMemSize	:near	; Return memory size in AL
	extrn	Determine_Analog_Monitor:near ;Read monitor type
	extrn	GetChipType	:near
	extrn	avga_confbyte	:byte

ifdef  (XGA_BUG)
	extrn	Is_Chip_Unlocked:near
endif  ;(XGA_BUG)


;------------------------------------------------------------------------

xas_tbl		label word
	dw	offset cgroup:inq_vga_type	; 80
	dw	offset cgroup:inq_bios_ver	; 81
	dw	offset cgroup:inq_ga_ver	; 82
	dw	offset cgroup:null_xas		; 83
	dw	offset cgroup:null_xas		; 84
	dw	offset cgroup:inq_memory	; 85
	dw	offset cgroup:null_xas		; 86
	dw	offset cgroup:null_xas		; 87
	dw	offset cgroup:null_xas		; 88
	dw	offset cgroup:null_xas		; 89
	dw	offset cgroup:null_xas		; 8a
	dw	offset cgroup:null_xas		; 8b
	dw	offset cgroup:null_xas		; 8c
	dw	offset cgroup:null_xas		; 8d
	dw	offset cgroup:null_xas		; 8e
	dw	offset cgroup:null_xas		; 8f
	dw	offset cgroup:null_xas		; 90
	dw	offset cgroup:null_xas		; 91
	dw	offset cgroup:null_xas		; 92
	ifdef (ALP_NEW)
	dw	offset cgroup:null_xas		; 93
	else	; (ALP_NEW)
	dw	offset cgroup:set_force8	; 93
	endif	; (ALP_NEW)
	dw	offset cgroup:null_xas		; 94
	dw	offset cgroup:null_xas		; 95
	dw	offset cgroup:null_xas		; 96
	dw	offset cgroup:null_xas		; 97
	dw	offset cgroup:null_xas		; 98
	dw	offset cgroup:null_xas		; 99
	dw	offset cgroup:raven_inq_options	; 9A
	dw	offset cgroup:null_xas		; 9B		
	dw	offset cgroup:null_xas		; 9C		
	dw	offset cgroup:null_xas		; 9D		
	dw	offset cgroup:null_xas		; 9E		
;v1.00B1dw	offset cgroup:SetMemClk		; 9E  v0.051
	dw	offset cgroup:null_xas		; 9F		
	dw	offset cgroup:inq_mode		; A0		
	dw	offset cgroup:ReadMonitorIDGender ; A1
ifdef (MONTYPE)
	dw	offset cgroup:mon_type		; A2
else  (MONTYPE)
	dw	offset cgroup:null_xas		; A2
endif	;MONTYPE
if (HIGHREFRESHVGA eq YES)
	dw	offset cgroup:highrefresh	; A3		
endif	;(HIGHREFRESHVGA eq YES)
ifdef  (MONTYPE_VERT)
	dw	offset cgroup:vert_montype	; A4
endif	;(MONTYPE_VERT)
	dw	offset cgroup:null_xas		; A5
	dw	offset cgroup:null_xas		; A6		
	dw	offset cgroup:null_xas		; A7		
	dw	offset cgroup:null_xas		; A8
	dw	offset cgroup:null_xas		; A9
	dw	offset cgroup:null_xas		; AA		
	dw	offset cgroup:null_xas		; AB		
	dw	offset cgroup:null_xas		; AC
	dw	offset cgroup:null_xas		; AD		
	dw	offset cgroup:GetHighRefresh	; AE  v1.10A3
	dw	offset cgroup:SetHighRefresh	; AF  v1.10A3
XAS_MAX		equ	($ - xas_tbl)/type(xas_tbl) + 80h


;-----------------------------------------------------------------------
;
;	ext_alt_sel()
;
;	Function:
;	   Perform extended alternate selection functions.
;
;	Input:
;	   ah = 12h
;	   al = options
; 	   bl = 80h inquire vga type
; 		81h inquire bios version
; 		82h inquire Raven Design Revision Code
; 		83h inquire S/C version (not supported in Raven)
; 		84h inquire user options
; 		85h inquire installed memory
; 	     	86h set video state (not supported in Raven)
; 	     	87h set fast/slow mode (not supported in Raven)
; 		89h set reverse video for both text & graphics (panel only)
; 		8Ah set frame color (not supported in Raven)
; 		8Bh set bold mode (panel only)
; 		8Ch set attribute emulation (panel only)
; 		8Dh set internal palette lock (panel only)
; 		8Eh set panel look-up table (panel only)
; 		8Fh set expanded mode (panel only)
; 		90h vertical position control (panel only)
; 		91h horizontal display control (not supported in Raven)
; 	     	92h set display mode (simulscan added)
; 		93h force 8 bit operation
; 		94h power save
; 		95h set RGB weighting 
; 		96h set skip font load when switch display device
;	        97h full height cursor (panel only)
; 	        98h inquire extended user options (Stingray compatibility only)
; 	        99h set hardware expanded text mode (not supported in Raven)
;		9ah reserved
;		9bh voltage_operation 
;		9ch set_panel_type
;		9dh set_panel_freq
;		a0h query video mode availability
;		a1h return monitor ID and gender
;		a2h set monitor type
;		a3h enable/disable high refresh mode (5410 only)
;		a4h set monitor type via vertical params
; 
; 	Returns:
;	   (cf) = 0 if successful
;	   (cf) = 1 if function not supported
; 	   See individual functions for OTHER output parameters.
; 
; 	Remarks:
; 	   1. Individual functions perform the return. 
;	   2. On input parameter in (al) the user has the capability of 
;	      finding out whether a requested option is available by setting
;	      bit 7 of (al) and making the inquiry.  Values of 0ffh or 0 
;	      returned in (al), after the INT 10h call, will tell the user 
;	      whether that option is, respectively, available or not.
;
;-----------------------------------------------------------------------
ext_alt_sel	proc	near
		public	ext_alt_sel

ifdef (XGA_BUG)
	 	call	Is_Chip_Unlocked	; is chip there?
		je	continue_parse		; yes, allow vesa calls
		jmp	not_supported		; no, block it
continue_parse:
endif ;(XGA_BUG)

		cmp	bl,XAS_MAX	 
		jb	in_range	; go if function is in range
		jmp	not_supported	; else, just return to caller

in_range:
		mov	si,bx
		and	si,07Fh
		shl	si,1
		jmp	cs:xas_tbl[si]	; jump to the function
ext_alt_sel	endp


null_xas	proc	near
		public	null_xas

		jmp	not_supported	; not supported function

null_xas	endp

;-----------------------------------------------------------------------
;
;       Return Video Mode Availability
;
;	Input:
;	   bl = a0 return mode avalibility
;	   al = mode# requested
;	Returns:
;	   ah[0] = video mode supported (1=supported, 0=not supported)
;	   ah[1] = crt display (1=enabled, 0=disabled)
;	   ah[2] = panel display (1=enabled, 0=disabled)
;	   ah[7:6] = monitor ID
;
;	   ds:si = pointer to standard video parmeters
;			(FFFF:FFFF if not available)
;	   es:di = pointer to supplemental video parmeters
;			(FFFF:FFFF if not available)
;-----------------------------------------------------------------------
inq_mode	proc	near
		public	inq_mode

;		mov	bx,0ffffh	; return ptr to suppl parm tbl
		mov	si,0ffffh	; return ptr to suppl parm tbl
		mov	w_ds[bp],si	; want to return ds:si = ffff:ffff
		mov	w_si[bp],si	; if std parm doesn't exist
		mov	w_es[bp],si	; want to return es:di = ffff:ffff
		mov	w_di[bp],si	; if suppl parm doesn't exist

		mov	cl,01h		; assume mode supported

	push	ds
	push	ax

;gdl:03/09/92 Don't return modes 08 through 0C as supported.
	cmp	al,08h
	jb	inq_modeLookup
	cmp	al,0Ch
	jbe	im_not_supported
inq_modeLookup:

	mov	bx,dx

	call	GetScanLineCode
	call	GetModeTblPtr
	cmp	si,0FFFFh
	je	im_not_supported
	mov	w_ds[bp],ds	; return pointer to
	mov	w_si[bp],si	; standard parm table
	cmp	di,0FFFFh
	je	im_not_supported
	mov	w_es[bp],es	; return pointer to
	mov	w_di[bp],di	; supplemental parm table
ifdef (MODE_OPTIMIZATION)
	extrn	set_refresh_and_pixel_depth:near
	mov	w_bx[bp],offset set_refresh_and_pixel_depth
endif	;(MODE_OPTIMIZATION)
im_not_supported:
	pop	ax
	pop	ds
	cmp	si,0FFFFh
	je	im_nsupport	; no, exit

	cmp	al,13h		; extd mode ?
	jbe	inq_mode_done	; no, suppl parm tbl does not exist

;++ Check memory requirements, monitor type, etc.

		jmp	short inq_mode_done

im_nsupport:	and	cl,0feh		; mode not supported
inq_mode_done:
		mov	ah,cl		; prepare to return value
		jmp	supported	; and return

inq_mode	endp

;-----------------------------------------------------------------------
;
;       Read monitor ID/Gender
;
;	Input:
;	   bl = a1 Read monitor ID and gender from 15-pin connector
;	Returns:
;	   bh = monitor ID
;	   bl = monitor gender
;		
;-----------------------------------------------------------------------
ReadMonitorIDGender	proc	near

	call	Determine_Analog_Monitor	;bl=0/1/2

ifdef (MONTYPE_VERT)
	mov	al,MONTYPE_VERT	;Get monitor type
else  ;(MONTYPE_VERT)
	mov	al,MONTYPE	;Get monitor type
endif ;(MONTYPE_VERT)
;5434(13){	call	get_option	;AL = option value
	mov	al, SP_OPT1
	call	getscr
	mov	al, ah
	shr	al, 1
	shr	al, 1	
;5434(13) }
	mov	bh,0Fh		;Assume no monitor attached
	cmp	bl,02h
	je	ReadMonIDGenDone

	mov	bh,0Ah		;Assume color/1024 capable
ifdef (MONTYPE_VERT)
	test	al,002h		;1024 modes available in max frequency field?
	jnz	ReadMonIDGenCheck
else  ;(MONTYPE_VERT)
	cmp	al,MONNEC2A
	je	ReadMonIdGenNo1024
	cmp	al,MONVGA
	jne	ReadMonIdGenCheck
ReadMonIdGenNo1024:
endif ;(MONTYPE_VERT)
	mov	bh,0Eh		;Assume color/no 1024
ReadMonIdGenCheck:
	sub	bh,bl		;0Ah -> 09h, 0Eh -> 0Dh if gray-scale attached
				;0Ah -> 0Ah, 0Eh -> 0Eh if color attached
ReadMonIDGenDone:
	mov	w_bx[bp],bx

	jmp	supported	; and return

ReadMonitorIDGender	endp

ifdef MONTYPE
;-----------------------------------------------------------------------
;
;       Set Monitor Type
;
;	Input:
;	   bl = a2 Set monitor type
;	   al = monitor type to set
;	Returns:
;
;	   nothing
;
; 	Remarks:
;		If MONTYPE_VERT is defined, a call to the old monitor type
;	must be converted into the new storage scheme.  The table below holds
;	the values for each montype, two bytes each.  The first represents
;	the argument for al, the second has the value for BH.
;		
;-----------------------------------------------------------------------
ifdef  (MONTYPE_VERT)
mt_convrt_tbl:
;v0.082db	000h,000h,002h,003h,001h,000h,002h,000h
	db	000h,000h,002h,007h,001h,000h,002h,000h	;v0.082
;5434(13+)db	002h,001h,003h,012h,003h,022h,003h,032h
	db	002h,001h,003h,012h,003h,022h,013h,032h
endif  ;(MONTYPE_VERT)
mon_type	proc	near
		public	mon_type


ifdef (ALP_NEW)
;CTH Set the horizontal montype status into scratch register
	PUSH	AX
	MOV	CL, AL
	MOV	AL, MONTYPE_R
	CALL	getscr
	AND	AH, NOT MONTYPE_M
	SHL	CL, MONTYPE_S
	AND	CL, MONTYPE_M
	OR	AH, CL
	CALL	setscr
	POP	AX
endif	; (ALP_NEW)


ifdef  (MONTYPE_VERT)
	mov	si,offset mt_convrt_tbl	; SI points to table entry
	shl	al,1
	xor	ah,ah
	add	si,ax
	lods	byte ptr cs:[si]	; AL = argument for new montype
;5434(13+){
	mov	ch, al
	and	ch, 0f0h		;keep 1280*1024 monitor type
	and	al, 0fh			;keep max. resolution value
;5434(13+){
	
	push	ax			; CL[4] has value of 640 x 480 freq
;5434(13) {
	mov	al, SP_OPT2
	call	getscr

ifdef (ALP_NEW)
	shl	ah, 4
else	; (ALP_NEW)
	shr	ah, 1
	shr	ah, 1
endif	; (ALP_NEW)
	mov	cl, ah
	and	cl, 10h			;CL[4] has value of 640x480 freq
		
;	mov	al,HIGHREF
;	call	get_option
;	mov	cl,004h
;	shl	al,cl
;	mov	cl,al
;5434(13) }
	pop	ax
	or	al,cl			; or 640 x 480 freq into argument

	mov	bh,byte ptr cs:[si]	; BH = argument for new montype
ifdef (ALP_NEW)
	jmp	short pgm_vert_montype
else	; (ALP_NEW)
	jmp	short vert_montype
endif	; (ALP_NEW)

else   ;(MONTYPE_VERT)
;	mov	ah,MONTYPE	;Set monitor type
;	call	set_option

endif  ;(MONTYPE_VERT)
	jmp	supported	; and return
mon_type	endp
endif	;MONTYPE

ifdef (ALP_NEW)

ifdef  (MONTYPE_VERT)
;-----------------------------------------------------------------------
;
;       Vertical_Monitor_Type()
;
;	Input:
;	   BL = 0a4h Set monitor type (Vertical)
;
;	   AL[3:0] = Maximum Vertical Resolution
;	     000h = 480 scan lines
;	     001h = 600 scan lines
;	     002h = 768 scan lines
;	     003h = 1024 scan lines
;	     004h - 00Fh = Reserved
;
;	   AL[7:4] = 640 x 480 Frequency
;	     000h = 60Hz
;	     001h = 75Hz
;	     002h - 00Fh = Reserved
;	    
;	   BH[3:0] = 800 x 600 Frequency
;	     000h = 56Hz
;	     001h = 60Hz
;	     002h = 72Hz
;	     003h = 75Hz
;	     004h - 00Fh = Reserved
;
;	   BH[7:4] = 1024 x 768 Frequency
;	     000h = 87iHz
;	     001h = 60Hz
;	     002h = 70Hz
;	     003h = 72Hz
;	     004h = 76Hz			(Ignored in CL-GD542x)
;	     005h - 00Fh = Reserved
;
;	   CH[7:4] = 1280 x 1024 Frequency	(supported in 543x)
;	     000h = 87iHz
;	     001h = 60Hz
;	     002h = 70Hz
;	     003h - 00Fh = Reserved
;
;	   CH[3:0] = Reserved
;	   CL = Reserved
;	   DX = Reserved
;
;	Returns:
;	   nothing
;		
; 	Remarks:
;		The following areas will be needed to be checked for other
;	chipset implementations of this new montype concept.  The default 
;	scratch pad registers will change, the montype mode check code has to
;	be modified along with the montype data in the supplemental structure,
;	the info call (09A) must use the new bit locations and be able to 
;	convert the scratch pad definitions into horizontal terms, the new
;	int 10h call to set vertical montype must be coded, the reading of the
;	eeprom must be modified to use all the new bits, the old horizontal
;	montype int 10h call must be modified to convert into vertical 
;	scratch pad definitions, and a complete seach of the BIOS must be 
;	made to ensure that decisions based on montype wont be mal-effected.
;		
;-----------------------------------------------------------------------
vert_montype proc near
	public	vert_montype
;
	CALL	pgm_vert_montype
;
	MOV	AL, MONTYPE_R
	CALL	getscr
	AND	AH, NOT MONTYPE_M	; CLEAR
	setreg
	jmp	supported		; and return
vert_montype endp
;-----------------------------------------------------------------------
; pgm_vert_montype : set vertical montype into scratch registers
;	
;	INPUT	: 
;
;	   AL[3:0] = Maximum Vertical Resolution
;	     000h = 480 scan lines
;	     001h = 600 scan lines
;	     002h = 768 scan lines
;	     003h = 1024 scan lines
;	     004h - 00Fh = Reserved
;
;	   AL[7:4] = 640 x 480 Frequency
;	     000h = 60Hz
;	     001h = 72Hz
;	     002h - 00Fh = Reserved
;	    
;	   BH[3:0] = 800 x 600 Frequency
;	     000h = 56Hz
;	     001h = 60Hz
;	     002h = 72Hz
;	     003h - 00Fh = Reserved
;
;	   BH[7:4] = 1024 x 768 Frequency
;	     000h = 87iHz
;	     001h = 60Hz
;	     002h = 70Hz
;	     003h = 72Hz
;	     004h = 76Hz			(Ignored in CL-GD542x)
;	     005h - 00Fh = Reserved
;
;	   CH[7:4] = 1280 x 1024 Frequency	(supported in 543x)
;	     000h = 87iHz
;	     001h = 60Hz
;	     002h = 70Hz
;	     003h - 00Fh = Reserved
;
;	   CH[3:0] = Reserved
;	   CL = Reserved
;	   DX = Reserved
;
;	OUTPUT	: NONE
;
;
;-----------------------------------------------------------------------
pgm_vert_montype proc near
	MOV	BL, AL			; Save AL into BL
	MOV	AH, MONTYPE_VERT1_R	; Select scratch index (SR0Ah)
					; for 1280x1K & Highref
	AND	AL, 01FH
	ROL	AL, 4			; Shift it into position
	SHR	CH, 3			; Shift into position
	AND	CH, 00EH		; Get valid bits for 1280x1K
	OR	AL, CH			; Put into AH
;
	PUSH	BX			; Save BX
	MOV	BH, MONTYPE_VERT1_M
	CALL	set_option
	POP	BX			; Restore BX
;
	MOV	AH, MONTYPE_VERT_R	; Select scratch index (SR09h)
					; for 1Kx768 & 800x600
	MOV	AL, BH			; Save BH into AH
	AND	AL, 0F0H		; Get the Valid Bits Only
	SHL	AL, 1
	AND	BH, 00FH		; Get the Valid Bits Only
	SHL	BH, 2
	OR	AL, BH
	MOV	BH, MONTYPE_VERT_M
	CALL	set_option
;
	ret
pgm_vert_montype endp
;
endif	;(MONTYPE_VERT)

else	; (ALP_NEW)

ifdef  (MONTYPE_VERT)
;-----------------------------------------------------------------------
;
;       Vertical_Monitor_Type()
;
;	Input:
;	   BL = 0a4h Set monitor type (Vertical)
;
;	   AL[3:0] = Maximum Vertical Resolution
;	     000h = 480 scan lines
;	     001h = 600 scan lines
;	     002h = 768 scan lines
;	     003h = 1024 scan lines
;	     004h - 00Fh = Reserved
;
;	   AL[7:4] = 640 x 480 Frequency
;	     000h = 60Hz
;	     001h = 72Hz
;	     002h - 00Fh = Reserved
;	    
;	   BH[3:0] = 800 x 600 Frequency
;	     000h = 56Hz
;	     001h = 60Hz
;	     002h = 72Hz
;	     003h - 00Fh = Reserved
;
;	   BH[7:4] = 1024 x 768 Frequency
;	     000h = 87iHz
;	     001h = 60Hz
;	     002h = 70Hz
;	     003h = 72Hz
;	     004h = 76Hz			(Ignored in CL-GD542x)
;	     005h - 00Fh = Reserved
;
;	   CH[7:4] = 1280 x 1024 Frequency	(supported in 543x)
;	     000h = 87iHz
;	     001h = 60Hz
;	     002h = 70Hz
;	     003h - 00Fh = Reserved
;
;	   CH[3:0] = Reserved
;	   CL = Reserved
;	   DX = Reserved
;
;	Returns:
;	   nothing
;		
; 	Remarks:
;		The following areas will be needed to be checked for other
;	chipset implementations of this new montype concept.  The default 
;	scratch pad registers will change, the montype mode check code has to
;	be modified along with the montype data in the supplemental structure,
;	the info call (09A) must use the new bit locations and be able to 
;	convert the scratch pad definitions into horizontal terms, the new
;	int 10h call to set vertical montype must be coded, the reading of the
;	eeprom must be modified to use all the new bits, the old horizontal
;	montype int 10h call must be modified to convert into vertical 
;	scratch pad definitions, and a complete seach of the BIOS must be 
;	made to ensure that decisions based on montype wont be mal-effected.
;		
;-----------------------------------------------------------------------
vert_montype proc near
	mov	cl,bh			; BH = 1024 x 768 request
	and	cl,0F0h
	cmp	cl,030h			; is request > 72 Hz?
	jbe	skip_76Hz_fix		; no, forget fixup
	and	bh,00Fh			; yes, maximum is 72hz, so set it
	or	bh,030h			; instead
;cth	or	bh,002h			; instead
skip_76Hz_fix:

	push	ax			; use AL[4] to set high refresh
	push	bx
;5434(13){
	shl	al, 1
	shl	al, 1			; shift to bit6
	mov	ah,SP_OPT2
	mov	bh, 40h
	call	set_option
	pop	bx
	pop	ax
;5434(13+)
	mov	cl,2
	and	al,003h			; AL[1:0] = max vert resolution
	shl	al, cl			; move to bit3:2
	mov	cl, 4
	shr	ch, cl
	and	ch,03h			; bit1:0 = 1280x1024 freg
	or	al, ch
	mov	ah,bh
	mov	cl, 4
	shl	ah,cl
	and	ah,030h			; CH[5:4] = 800 x 600 freq
	or	al,ah			; AL[5:4,3:2]=800x600,max vert res
	shl	bh,1
	shl	bh,1
	and	bh,0C0h			; BH[7:6] = 1024 x 768 freq
	or	al,bh			; AL[7:6,5:4,3:2,1:0]=1kx768,8x6,mvr,1280x1k
;5434(13){
;	shl	al, 1
;	shl	al, 1
	mov	bh, 0ffh
	mov	ah,SP_OPT1
	call	set_option
;5434(13) }
	jmp	supported		; and return
vert_montype endp
endif	;(MONTYPE_VERT)

endif	; (ALP_NEW)

if (HIGHREFRESHVGA eq YES)

ifdef (ALP_NEW)
;-----------------------------------------------------------------------
;
;       Set Refresh Type
;
;	Input:
;	   bl = a3 Set High/Low VGA refresh
;	   al = enable/disable
;	Returns:
;	   nothing
;
;-----------------------------------------------------------------------
highrefresh	proc	near
		public	highrefresh

		mov	bh, 001h		; mask bit
		mov	ah,HIGHREF_R
		call	set_option

		jmp	supported	; and return

highrefresh	endp

else	; (ALP_NEW)

;-----------------------------------------------------------------------
;
;       Set Refresh Type
;
;	Input:
;	   bl = a3 Set High/Low VGA refresh
;	   al = enable/disable
;	Returns:
;	   nothing
;
;-----------------------------------------------------------------------
highrefresh	proc	near
		public	highrefresh

		ror	al, 1
		ror	al, 1		; shift to bit6
		mov	bh, 40h		; mask bit
		mov	ah,HIGHREF_R
		call	set_option

		jmp	supported	; and return

highrefresh	endp
endif	; (ALP_NEW)

endif	;(HIGHREFRESHVGA eq YES)

;-----------------------------------------------------------------------
;
;	Inquire VGA Type
;
;	Input:
;	   bl = 80 inquire vga type
;
;	Returns:
;	   (cf)  = 0
;	   al = 0 = no extended alternate select support
;		1 = Eagle I
;		2 = Eagle II
;		3 = Stingray
;	  	4 = Eagle III
;	        5 = Raven
;		6 = Merlion
;	   ah = capabilities mask
; 		bit 0 = not applicable (set to 0)
; 		bit 1 = GD6340 support
; 		bit 2 = reverse video support (1)
; 		bit 3 = hardware expanded text support (1)
; 		bit 4 = EL panel support (0)
; 		bit 5 = not applicable (0)
; 		bit 6 = gas plasma panel support (0)
; 		bit 7 = LCD panel support (1)
;	   bl = silicon revision number
;		0-7fh silicon revision
;	 	80h   silicon revision number not available
;
;	Description: 
;	   This function provides a mechanism for software to determine the
;	   type of Cirrus Logic VGA controller and its corresponding hardware
;	   capabilities.
;
;--------------------------------------------------------------------
inq_vga_type	proc	near
		call	get_crtc_addr
		mov	al,027h
		call	getreg
		and	ah,0FCh

		mov	al,032h		;CL-GD5430
		cmp	ah,0A8h		;CL-GD5434's Id = A8h
		jne	Not5434
		mov	al,031h
Not5434:
		xor	ah,ah
		xor	bh,bh
		mov	bl,BIOS_CHIP_REV; chip rev
		mov	w_bx[bp],bx	; save return value on stack
		jmp	supported	; and return
inq_vga_type	endp

;-----------------------------------------------------------------------
;
;	Inquire BIOS Version
;
;	Input:
;	   bl = 81 inquire bios version
;
;	Returns:
;	   ah = Major version number
;	   al = Minor version number
;	   (cf) = 0
;
;	Description: 
;	   This function provides a mechanism for software to determine the
;	   BIOS version number.
;
;--------------------------------------------------------------------
inq_bios_ver	proc	near
		public	inq_bios_ver

		mov	ax,BIOS_VER	; bios version
		jmp	supported	; and return
inq_bios_ver	endp

;-----------------------------------------------------------------------
;
;	Inquire Design Revision Code
;
;	Input:
;	   bl = 82h inquire Design Revision Code
;
;	Returns:
;	   (cf) = 0
;	   (al) = Design Revision Code
;
;	Description: 
;	   This function provides a mechanism for software to determine the
;	   design revision code.  Raven should read back 08xh.
;
;-----------------------------------------------------------------------
inq_ga_ver	proc	near
		public	inq_ga_ver

		call	get_crtc_addr
		mov	al,027h
		call	getreg
		and	ah,3		; mask off revision # only
		mov	al,ah		; design revision code in (al)
		jmp	supported	; and return
inq_ga_ver	endp

ifdef (ALP_NEW)

;-----------------------------------------------------------------------
;
;	Inquire User Options
;
;	Input:
;	   bl = 9Ah inquire user options
;
;	Returns:
;	   (cf) = 0
;	   (ax) as user options defined below:
;
;		ax[0] 	= vertical position control
;		  0 = displayed at middle
;		  1 = displayed at the top of the panel
;		ax[1] 	= reserved
;		ax[4:2] = monitor type
;		ax[7:5] = reserved
;		ax[8]   = display mode (0=panel,1=CRT)
;		ax[9]   = expand mode disabled
;		ax[10]	= 8 bit operation enabled
;		ax[11]  = text mode reverse video disabled
;		ax[12]  = reserved
;		ax[13]  = bold disabled
;		ax[14]  = n/a (set to 0)
;		ax[15]  = n/a (set to 0)
;
;	BX = Contains the options word
;
;	bits[2:0]   = Contrast Enhancement (see function definition)
;	bits[5:3]   = RGB Weighting (see function definition)
;	bit [6]     = reserved
;	bit [7]     = Graphics reverse video (0=enable, 1=disable)
;	bit [8]     = reserved
;	bit [9]	    = Simulscan (0=enable, 1=disable)
;	bit [10]    = reserved
;	bit [11]    = Inhibit Font Load (0=enable, 1=disable)
;
;
;	CX = Contains the options word
;
;	bits [5:0]  = Power Timer (minutes)
;	bits [7:6]  = resereved
;	bits [10:8] = Power Save (see function definition)
;
;	Description: 
;	   This function is the way that an application determines the current
;	   state of the user options.  If MONTYPE_VERT is defined, the table
;	   below is used to figure out what horizontal montype is being used,
;	   based on the new vertical montype storage scheme.  It represents
;	   the compacted representation of vertical montype.
;
;-----------------------------------------------------------------------
	public mt_compare_tbl
mt_compare_tbl:
	db	32h,68h		;Monitor Type 7
	db	30h,48h		;Monitor Type 6
	db	30h,28h		;Monitor Type 5
	db	20h,04h		;Monitor Type 4
	db	20h,00h		;Monitor Type 3
	db	10h,00h		;Monitor Type 2
	db	20h,1Ch		;Monitor Type 1
	db	00h,00h		;Monitor Type 0

raven_inq_options	proc	near
;
	MOV	AL, SP_OPT1
	CALL	getscr
	MOV	CH, AH
	SHR	CH, 2
	AND	CH, 07H
	SHR	AH, 1
	AND	AH, 070H
	OR	CH, AH
;
	MOV	AL, SP_OPT2
	CALL	getreg
	MOV	CL, AH
;
	AND	CX, NOT 01H	; Clear HIGHREF bit
	MOV	w_cx[bp], CX	; Save return value on stack
;
	MOV	CH, AH
	ROR	CH, 2
	AND	CH, 40H		; Preserve HIGHREF bit only

;v0.083{
	push	cx
	call	user_inq	; returns ah=SP_OPT2, al=SP_OPT1
	mov	cx,8
	mov	si,offset mt_compare_tbl
CompareLoop:
	cmp	ah,cs:[si]	; Compacted code equal to tbl entry?
	jnz	short AdjustSi
	cmp	al,cs:[si+1]
	jz	short MatchFound
AdjustSi:
	add	si,2
	loop	CompareLoop
	xor	ah,ah
	jmp	short CompareDone
MatchFound:
	dec	cx
	mov	ah,cl
CompareDone:
	pop	cx
	shl	ah,2
	mov	cl,ah

;xxx	MOV	AL, SP_OPT4
;xxx	CALL	getreg		; get horizontal montype
;xxx	AND	AH, 070H	; valid bits only
;xxx	SHR	AH, 2		; shift to bit2
;xxx	MOV	CL, AH
;v0.083}

	MOV	AX, CX		; Save return value on stack
	jmp	short supported	; and return

raven_inq_options	endp

else	; (ALP_NEW)

;-----------------------------------------------------------------------
;
;	Inquire User Options
;
;	Input:
;	   bl = 9Ah inquire user options
;
;	Returns:
;	   (cf) = 0
;	   (ax) as user options defined below:
;
;		ax[0] 	= vertical position control
;		  0 = displayed at middle
;		  1 = displayed at the top of the panel
;		ax[1] 	= reserved
;		ax[4:2] = monitor type
;		ax[7:5] = reserved
;		ax[8]   = display mode (0=panel,1=CRT)
;		ax[9]   = expand mode disabled
;		ax[10]	= 8 bit operation enabled
;		ax[11]  = text mode reverse video disabled
;		ax[12]  = reserved
;		ax[13]  = bold disabled
;		ax[14]  = n/a (set to 0)
;		ax[15]  = n/a (set to 0)
;
;	BX = Contains the options word
;
;	bits[2:0]   = Contrast Enhancement (see function definition)
;	bits[5:3]   = RGB Weighting (see function definition)
;	bit [6]     = reserved
;	bit [7]     = Graphics reverse video (0=enable, 1=disable)
;	bit [8]     = reserved
;	bit [9]	    = Simulscan (0=enable, 1=disable)
;	bit [10]    = reserved
;	bit [11]    = Inhibit Font Load (0=enable, 1=disable)
;
;
;	CX = Contains the options word
;
;	bits [5:0]  = Power Timer (minutes)
;	bits [7:6]  = resereved
;	bits [10:8] = Power Save (see function definition)
;
;	Description: 
;	   This function is the way that an application determines the current
;	   state of the user options.  If MONTYPE_VERT is defined, the table
;	   below is used to figure out what horizontal montype is being used,
;	   based on the new vertical montype storage scheme.  It represents
;	   the compacted representation of vertical montype.
;
;-----------------------------------------------------------------------
ifdef  (MONTYPE_VERT)
	Public mt_compare_tbl
mt_compare_tbl:
;5434(13+)	db	000h,038h,004h,008h,018h,06Ch,0ACh,0ECh
	db	000h,038h,004h,008h,018h,06Ch,0ACh,0EDh
endif	 ;(MONTYPE_VERT)
raven_inq_options	proc	near

		call	user_inq	; returns al=SP_OPT1, ah=SP_OPT2
		mov	bh,ah		; 8/16 bit in bh[0](al=SR09,ah=SR0A)
		and	bh,1		; mask off the rest
		xor	bh,1		; and flip the definition
		shl	bh,1		; move it to [2]
		shl	bh,1
  ifdef  (MONTYPE_VERT)
		and	ah,0040h
  else	 ;(MONTYPE_VERT)
		and	ah,not 004h
  endif	 ;(MONTYPE_VERT)
		or	ah,bh		; and or it back in to return value
		xor	bx,bx
		mov	w_bx[bp],bx	; save return value on stack
  ifdef  (MONTYPE_VERT)
		mov	ch,al		; CH[4:3] = AL[5:4], 800 x 600 freq
		and	ch,0F0h		; CH[6:5] = AL[7:6], 1024 x 768 freq
		shr	ch,1
;5434(13+){		xor	cl,cl
		mov	cl, al
		and	cl, 3
		shl	cl, 1
		shl	cl, 1
		shl	cl, 1
		shl	cl, 1		;CL[5:4] = 1280 x 1024 freg
;5434(13+)}
		mov	w_cx[bp],cx	; save return value on stack

		;
		; BL[4:2] = conversion of vertical montype to the 
		; horizontal montype
		;
		mov	cx,8		; set loop counter to 8
		mov	si,offset mt_compare_tbl
;5434(13+)		and	al,not 003h	; AL[7:2] = compacted code
cmp_loop_head:
		cmp	al,cs:[si]	; Compacted code equal to tbl entry?
		je	found_old_montype  ; yes, we're done
		inc	si		; no, inc ptr and
		loop	cmp_loop_head	; try again
found_old_montype:			
		;
		; if loop counter has expired, will just store a zero.  It
		; really doesn't matter because a non-match indicates that
		; the system is using the advanced vertical montype and will
		; not need the compatable horizontal montype.
		;
		sub	si,offset mt_compare_tbl
		mov	bx,si		; CL[2:0] = horizontal montype
		and	bl,007h		; mask it
		mov	cl,2 		; and place it in [4:2] for info 
		shl	bl,cl		; return value

		and	al,00Ch		; AL[6:5] = maximum freqency
		inc	cx
		shl	al,cl
		or	al,bl		; AL[4:2] = horizontal montype
  else   ;(MONTYPE_VERT)
		xor	cx,cx
		mov	w_cx[bp],cx	; save return value on stack
  endif  ;(MONTYPE_VERT)
		jmp	short supported	; and return

raven_inq_options	endp

endif	; (ALP_NEW)

;v1.10A3{
;-----------------------------------------------------------------------
; GetHighRefresh:
;-----------------------------------------------------------------------
extrn	Detect72Hz75Hz:near

GetHighRefresh	proc	near
	and	al,0FEh
	call	Detect72Hz75Hz
	jz	DoneGetHighRef
	or	al,01h
DoneGetHighRef:
	jmp	supported	
GetHighRefresh	endp

;-----------------------------------------------------------------------
; SetHighRefresh:
;-----------------------------------------------------------------------
SetHighRefresh	proc	near
	push	ax
	mov	bl,al
	mov	al,14h
	mov	dx,3C4h
	call	getreg
	and	ah,07h
	test	bl,01h
	jz	PgmSR14	
	or	ah,08h
PgmSR14:
	out	dx,ax
	pop	ax
	jmp	supported	
SetHighRefresh	endp
;v1.10A3}

comment	%				;v1.00B1
;-----------------------------------------------------------------------
;
; SetMemClk : It will take the user iuput to reprogram Memory Clock
;
;	INPUT	: BH = 0 - 3Fh	
;	OUTPUT	: NONE
;	REMARKS	: AX,DX,BH corrupted; but they will be recovered during
;		  INT 10h exit.
;-----------------------------------------------------------------------
;v0.051	{
SetMemClk	proc	near
	cmp	al,2			; Is it sub-function 2?
	jnz	short not_supported	; No, exit
	mov	dx,Sequencer		; get SR address
	mov	al,1Fh			; SR1F[6:0]
	call	getreg			; Get it
	and	ah,0C0h			; Save b7 & b6
	and	bh,NOT 0C0h		; clear BH b7 & b6
	or	ah,bh			; New value
	setreg
	jmp	supported	
SetMemClk	endp
;v0.051	}
%
;-----------------------------------------------------------------------
;
;	Input:	none
;	Returns: ah = 3ce/bch
;		 al = 3ce/bbh
;	Remarks: clears all the reserved bits
;-----------------------------------------------------------------------
user_inq	proc	near

		mov	al,SP_OPT1	; get scratch pad SP_OPT1 in (cl)
		call	getscr		; get value
		mov	cl,ah           ; save value
		mov	al,SP_OPT2      ; get scratch pad SP_OPT2 in (ch)
		call	getscr          ; get value
		mov	ch,ah           ; save it
		mov	ax,cx           ; put it in return register
     ifdef (MONTYPE_VERT)
;xxx		and     ax,7fFFh        ; make sure reserved bits are set to 0
		and	ax,0FEFCh	;xxx
     else  ;(MONTYPE_VERT)
		and     ax,7f1Fh        ; make sure reserved bits are set to 0
     endif ;(MONTYPE_VERT)
		ret

user_inq	endp

;-----------------------------------------------------------------------
;
;	Inquire Installed Memory
;
;	Input:
;	   bl = 85h inquire installed memory
;
;	Returns:
;	   al = installed memory in 64k units
;	   (cf) = 0
;
; 	Description: 
;	   This function is the way that an application determines the amount 
;	   of video memory present.  In Raven the amount of video memory is
;	   always 256k.
;
;-----------------------------------------------------------------------
inq_memory	proc	near
		public	inq_memory

		call	GetMemSize	; returns video memory present
		jmp	short supported	; and return

inq_memory	endp


page
;-----------------------------------------------------------------------
;
;	Force 8 Bit Operation
;
; 	Input:
; 	   bl = 93h Force 8 bit
; 	   al = 0 - Allow 16 bit operation
; 		1 - Force 8 bit operation
; 
; 	Returns:
; 	   (cf) = 0
; 
;	Description: 
;	   This option forces 8 bit operation in an environment where 16 bit
;	   operation is possible.  Takes effect immediately.
;
;-----------------------------------------------------------------------
	public	set_force8
	extrn	program_SCR	:near

set_force8	proc	near
		public	set_force8
;5434(13)		mov	ah,FORCE8	; option number (AH=option,AL=arg)
		xor	al,1		; flip the arg for terminator
		test	cs:avga_confbyte,008h	; is it a local bus design?
		jz	allow_8bit_operation	; no, allow user request
		mov	al,001h			; yes, always force 16bit
allow_8bit_operation:
		mov	bl, al			;value
		mov	bh, 1			;bit0 mask
		push	bx
		mov	al, SP_OPT2		;scratch reg. index
		call	program_SCR
;
		pop	bx
		xor	bl, 1			;reverse definition HW bit
		ror	bl, 1
		ror	bl, 1			;shift to bit 6
		mov	bh, 40h			;bit6 mask
		mov	al, 8			;reg. index
		call	program_SCR
;
supported:	clc				; supported return code
		ret

not_supported:	stc
		ret

set_force8	endp

COMMENT %
;-----------------------------------------------------------------------
;
;	can_be_always()
;
;	Function:
;               Always returns
;	Input:
;	   AH=option number
;	   AL=argument
;	      AL->0 Enable Option
;	      AL->1 Disable Option
;
;	Returns:
;	   AL=argument for pgm_hdw_generic

;	Remarks:
;	   This routine only provides a ret
;
;-----------------------------------------------------------------------
can_be_always	proc	near
		public	can_be_always

        	ret

can_be_always	endp

;-----------------------------------------------------------------------
;	Remarks:
;	   This routine only provides a ret
;-----------------------------------------------------------------------
pgm_hdw_null	proc	near
		public	pgm_hdw_null

		ret

pgm_hdw_null	endp


;-----------------------------------------------------------------------
;
;	do_xaltsel()
;
;	Function:
;	   To set the Extended Alternate Select Option.
;
;	Input:
;	   ah = option number.
;	   al = argument.
;
;	Returns:
;	   Nothing.
;
;	Remarks:
;	   None.
;-----------------------------------------------------------------------
do_xaltsel	proc	near
		public	do_xaltsel

		test	al,80h		; check if function available?
		jz	l2		; nope

		and	al,not 80h	; clear is available bit
		push	ax		; save argument
		call	get_optproc	; get pointer to "can_be" function
					; in (bx), pointer to "prg hardware"
					; in (di)
		pop	ax		; recover argument

		call	bx		; call can_be_proc

		or	al,80h
		cmp	b_al[bp],al	; is result argument same as caller?
		jne	not_avail	; nope
		mov	al,0ffh		; available = 0ffh
		jmp	short supported	; done

not_avail:
		xor	al,al		; not available = 0
		jmp	short supported	; return NC for supported

l2:		call	set_option	; set it
		call	bx		; can be?  Returns AL=arg for pgm_hdw
		call	di		; program the hardware

supported:	clc			; supported return code
		jmp	short xas_exit	; done

not_supported:	stc			; not supported return code

xas_exit:	ret			; return to caller

do_xaltsel	endp

%


;-----------------------------------------------------------------------
;
;	wait_vretrace()
;
;	Function:
;	   Selects for a number of frames to occur. When the routine exits,
;	     controller is within the vertical retrace period.
;
;	Input:
;	   BL=number of frames.
;
;	Returns:
;	   Nothing.
;
;	Remarks:
;
;-----------------------------------------------------------------------
wait_vretrace	proc	near
		public	wait_vretrace

		push	ax		; save ax
		push	cx		; cx
		push	dx		; dx

		call	get_crtc_addr   ; get 3x4 address
		add	dl,6		; 3?a

		xor	bh,bh		; initialize counter
wait_begin:	xor	cx,cx		; count
wait_vsync:	in	al,dx	  	; wait for vsync
		test	al,08h		; in vsync ?
		loopnz	wait_vsync	; no

		xor	cx,cx		; count
wait_vsyncx:	in	al,dx		; wait for display enable
		test	al,08h		; display enabled ?
		loopz	wait_vsyncx		; no

		inc	bh	  	; next frame
		cmp	bh,bl		; more frames?
		jne	wait_begin	; yup

		pop	dx		; restore dx
		pop	cx		; and cx
		pop	ax		; recover ax

		ret			; return to caller
wait_vretrace	endp

VGA_Segment		ends
		end
