GenericVGA	equ	0			;CHIP_FAMILY
CONDOR		equ	GenericVGA+1
AVGA		equ	CONDOR+1

;GenericVGA	equ	0			;CHIP_TYPE
CL6410		equ	5			;5
CL5410		equ	CL6410 + 1		;6
CL6420		equ	CL5410 + 1		;7
CL6412		equ	CL6420 + 1		;8
CL6416		equ	CL6412 + 1		;9
AVGA1		equ	10h
AVGA2		equ	AVGA1+1
AVGA2m		equ	AVGA2+1			;5420
AVGA3		equ	AVGA2m+1		;5422
AVGA3l		equ	AVGA3+1			;5424
AVGA3b		equ	AVGA3l+1		;5426
AVGA2mr1	equ	AVGA3b+1		;5420r1
AVGA34		equ	AVGA2mr1+1		;5402r1
ALC1L		equ	AVGA34+1		;##5434(3)##
ALC2		equ	20h

NSTAR		equ	40h

REV_AA		equ	0
REV_AB		equ	REV_AA + 1
REV_AC		equ	REV_AB + 1
REV_AD		equ	REV_AC + 1
REV_AE		equ	REV_AD + 1
REV_AF		equ	REV_AE + 1
REV_AG		equ	REV_AF + 1

REV_BA		equ	10h
REV_BB		equ	REV_BA +1
REV_BC		equ	REV_BB +1
REV_BD		equ	REV_BC +1
REV_BE		equ	REV_BD +1

BIOS_46e8	equ	0
BIOS_48K	equ 	BIOS_46e8 + 1
BIOS_3c3	equ 	BIOS_48k  + 1
BIOS_3c3_BOLD	equ 	BIOS_3c3  + 1
BIOS_46e9	equ	BIOS_3c3_BOLD + 1

   PEACOCK	equ	NO   		; no peacock support

MONVGA		equ 	0		;0 = 8512/8513 VGA monitor
MON8514		equ	1		;1 = 8514/8507 1024i monitor
MONNEC2A	equ	2		;2 = NEC 2A-type monitor
MONNECII	equ	3		;3 = NEC II-type monitor
MONNEC3D	equ	4		;4 = NEC 3D-type monitor
MONSONY1304	equ	5		;5 = Sony CPD-1304-type monitor
MONNEC4D	equ	6		;6 = NEC 4D-type monitor
MONNEC5D	equ	7		;7 = NEC 5D-type monitor

SEQIDX	equ	3C4h
GFXIDX	equ	3CEh
CRTIDX	equ	3D4h
PELMASK	equ	3C6h


;
; debugging stuff
;
if IOMEM eq YES
   READ_INT	equ	60h		; don't use when BASIC is running
   WRITE_INT	equ	61h		; don't use when BASIC is running
   READ1_INT	equ	62h		; don't use when BASIC is running
   WRITE1_INT	equ	63h		; don't use when BASIC is running

   MEMIO       	equ	YES
endif

;
; default options
;
   include	chipdef.inc

;
; Enable Customer Options
;
if BIOS_PRODUCT eq BIOS_46e8
   BIOS_LEN	equ	08000h
   VSEnable	equ	46E8h
endif

if BIOS_PRODUCT eq BIOS_3c3
   BIOS_LEN	equ	08000h
   VSEnable	equ	3C3h
endif

if BIOS_PRODUCT eq BIOS_48k
   BIOS_LEN	equ	0c000h
   VSEnable	equ	46E8h
   TSRFONT	equ	NO
endif

if BIOS_PRODUCT eq BIOS_3c3_BOLD
   BIOS_LEN	equ	0c000h
   VSEnable	equ	3C3h
   TSRFONT	equ	NO
endif

if BIOS_PRODUCT eq BIOS_46e9
   BIOS_LEN	equ	08000h
   VSEnable	equ	46E9h
endif


;*if CODE_NAME	eq	NSTAR
;*   NOR_STAR	equ	YES
;*endif


;------------------------------------------------------------------------

BIOS_DATE	equ '06/28/94'

;------------------------------------------------------------------------

	PRODUCT_ID	equ	'RV'
	CHIP_FAMILY	equ	AVGA
	BIOS_CHIP_REV	equ	CHIP_REV
	BIOS_VER	equ	0110h
	;
	; 1.10a - 54xx3CMB/54xx-03c - XGA Fix, LOCAL_BUS_WAKE is off,
	;         MICROCHANNEL_ADAPTER
	; 1.10b - 54xx46MB - Index Preserve Fix, Special 1280 & 1K 60Hz mode,
	;	  vesa_sync_pol, highref_clk2, 01/12/93, new year signon
	;
;**	BIOS_VER_INCRE	equ	'a'	; incremental change 'a' - 'z'
;	BETA_VER	equ	1
;	ALPHA_VER	equ	3
IFDEF (PCI)
	BIOS_MSG	equ	'CL-GD543x PCI VGA'
ELSE ;PCI
	BIOS_MSG	equ	'CL-GD543x VGA'
ENDIF ;PCI
	cProductName	equ 	'54xx'

	ALP_NEW		equ	YES

	VESAVBEVERSION	equ	102h	;VESA VBE v1.2
	MODEDIRECTCOLOR	equ	YES
	MODE14TEXT	equ	YES


	Bold_Text	equ	NO
	NUM_PANEL_TYPES	equ	0	; number of panel type supported
	CL_SAVE_RESTORE	equ	YES	; do complete CL VGA save/restore

	MAXMEMSIZE		equ	1024
	HIGHREFRESHVGA	equ	YES	; Do 72Hz/84Hz VGA modes.
	MONTYPE_SIGNAL	equ	YES	; alternate int15h call for montype
	SAVE_EXT_IDX 	equ 	YES	; Preserve indicies on BIOS call exit

	;
	; The following OPTIONS are for chipset bug fixes
	;
;***	PROG_46E8_BUG	     equ YES	; hack BIOS (make 1.01 a1 for 5424 testing)
	SCROLL_BANDWIDTH_BUG equ NO	; AVGA3/512K 256c mode scroll bug
	INT13_FLOPPY_WAKE    equ NO	; DMA transfer bug fixup
	COMPASS_METHOD       equ NO	; Use COMPASS aproach or int 60h?
	LOCAL_BUS_WAKE 	     equ NO	; 3C3h GD5424 special wake up code

	;
	; The following equates are DEFINED to save space/customization
	;
;**	REMOVE_MEMORY_TEST   equ  YES	; no memory test in post
	REMOVE_DAC_TEST      equ  YES   ; no DAC test in post
	MODE_OPTIMIZATION    equ  YES	; New Mode Engine Design
;**	MICROCHANNEL_ADAPTER equ  YES	; POST turns off chnl 0 via 094h/102h

	;
	; The following equates are DEFINED for BIOS 1.10 bug fixes
	;
	XGA_BUG		     equ  YES   ;BIOS isnt std VGA when chip is asleep
;	SPECIAL_1280_MODE    equ  YES	;Horiz blank >= 4usec & 1024x768x60Hz
	ADD_NEW_MONTYPE	     equ  YES	;Function 0A4h is added
	XGA_VXD_BUG	     equ  YES	;SR00 = 03h every setmode

ifndef 	(SAVE_EXT_IDX)
	SAVE_EXT_IDX 	     equ  NO
endif

ifndef (SUSPEND_MCLK_BUG)
	SUSPEND_MCLK_BUG     equ NO
endif

ifndef (LOCAL_BUS_WAKE)
  LOCAL_BUS_WAKE equ NO
endif

ifndef	MEMCLK_FIXUP
        MEMCLK_FIXUP	     equ  NO
endif

ifndef	WRITE_DAC_SLOWLY
  WRITE_DAC_SLOWLY equ	NO
endif

	IRQ2VERTINT	equ YES

ifndef READ_INT
   READ_INT	equ	60h
endif

ifndef WRITE_INT
   WRITE_INT	equ	61h
endif

ifndef READ1_INT
   READ1_INT	equ	62h
endif

ifndef WRITE1_INT
   WRITE1_INT	equ	63h
endif

ifndef	CPU
   CPU		equ	186
endif

ifndef	Sign_On
   Sign_On	equ	Cirrus_Msg
endif

ifndef	C3bx
   C3bx		equ	Grey
endif

ifndef EXT_MODES
   EXT_VIDMODES	equ	YES		; support extended VGA modes
endif

ifndef	ISDISP_CL
   ISDISP_CL	equ	YES
endif

ifndef	CURPOS_CL
;**   CURPOS_CL	equ	0500h		; where to display CL message
   CURPOS_CL_ROW equ	05h		; where to display CL message
   CURPOS_CL_COL equ	00h		; where to display CL message
endif

ifndef	ISDISP_CUST
   ISDISP_CUST	equ	NO
endif

ifndef FASTTTY
   FASTTTY	equ	YES			; mode 3 fast tty
endif

ifndef	MEMIO
   MEMIO	equ	NO
endif

ifndef	SCR_IN_MEM
   SCR_IN_MEM	equ	NO			; r/w scr pad at INT 66h
endif

ifndef TSRFONT
   TSRFONT	equ	YES
endif

ifndef BIOS
   BIOS		equ	ROM
endif

ifndef CL_SAVE_RESTORE
   CL_SAVE_RESTORE	equ	YES
endif

ifndef NOSYNC_RESET
   NOSYNC_RESET	equ	NO		; don't need reset to change clocks
endif

ifndef HAS_PAGED_MODES
   HAS_PAGED_MODES equ YES		; extended modes uses paged modes
endif

ifndef BOLD_Text
   BOLD_Text	equ	YES
endif

ifndef SETMODE_SIGNAL
;gdl:02/14/92 Do this for everything
   SETMODE_SIGNAL	equ	YES	; INT 15h notification in SETMODE
endif

ifndef MONTYPE_SIGNAL
   MONTYPE_SIGNAL	equ	NO
endif

ifndef SysBoldFontSignal
   SysBoldFontSignal	equ	NO	; INT 15h query for bold font (AX=448Fh)
endif

ifndef EXTENDEDMODES
   EXTENDEDMODES	equ	YES	;Include all extended modes
endif

;
; generic options
;
ifndef MCLK_INV_NOTREQ			;MCLK inversion not required
   MCLK_INV_NOTREQ	equ	NO
endif

if (MCLK_INV_NOTREQ eq YES)			;MCLK inversion not required
   MCLK_INV_BIT		equ	00h
else
   MCLK_INV_BIT		equ	80h
endif

ifndef SR1_5_IN_VSYNC
  SR1_5_IN_VSYNC 	equ	NO
endif

ifndef FLUSHFIFO_IN_CRTC
  FLUSHFIFO_IN_CRTC 	equ 	NO
endif


;---------------
;
; Things to do because of options
;

ifndef NUM_PANEL_TYPES
   NUM_PANEL_TYPES	equ	0	; number of panel type supported
   PANEL_SUPPORT	equ	NO
endif

;if (Sleep_46E8 eq NO)
;   Boundary	equ	On_Word		; 16 wide rom, 286 system
;endif

ifndef BIOS_Len
    BIOS_Len	equ	08000h
endif

ifndef MODE100COL
   MODE100COL	equ	YES
endif	;MODE100COL

ifndef MODE132COL
   MODE132COL	equ	YES
endif	;MODE132COL

ifndef MODE256COLOR
   MODE256COLOR	equ	YES
endif	;MODE256COLOR

ifndef MODE256CBUG
   MODE256CBUG	equ	NO
endif	;MODE256CBUG

ifndef MODEDIRECTCOLOR
   MODEDIRECTCOLOR	equ	NO
endif	;MODEDIRECTCOLOR

ifndef MODE14TEXT
	MODE14TEXT	equ	NO
endif	;MODE14TEXT

ifndef PROG_46E8_BUG
   PROG_46E8_BUG	equ	NO
endif

ifdef ALPHA_VER
	ALPHA_BETA_MSG	equ <'',((ALPHA_VER / 10)+'0'),((ALPHA_VER mod 10)+'0')>
else	;ALPHA_VER
 ifdef BETA_VER
	ALPHA_BETA_MSG	equ <'',((BETA_VER / 10)+'0'),((BETA_VER mod 10)+'0')>
 else	;BETA_VER
	ALPHA_BETA_MSG	equ '   '
 endif	;BETA_VER
endif	;ALPHA_VER

ifndef BIOS_VER_INCRE
   BIOS_VER_INCRE	equ	NO
endif

if CPU ge 186
   .186
else
   .8086
endif

ifndef	Boundary
   if BIOS eq ROM
      Boundary	equ	On_Byte
   elseif BIOS eq RAM
      if CPU ge 386
	 Boundary	equ	On_DWord
      elseif CPU ge 286
	 Boundary	equ	On_Word
      else
	 Boundary	equ	On_Byte
      endif
   endif
endif

bgn_code_seg	macro

cgroup		group	VGA_Segment

if Boundary eq On_Byte
VGA_Segment		segment	word public 'code'
elseif Boundary eq On_Word
VGA_Segment		segment	word public 'code'
elseif Boundary eq On_DWord
VGA_Segment		segment	dword public 'code'
endif
		endm

end_code_seg	macro
VGA_Segment		ends
		endm
;
; user's of shft_r and shft_l must be prepared to have cl destroyed
; on calls where the shift count is 4 or larger.
;
shft_r		macro	op,cnt
   if CPU ge 186
		shr	op,cnt
   elseif cnt ge 4
		mov	cl,cnt
		shr	op,cl
   else
		rept	cnt
		shr	op,1
		endm
   endif
		endm

shft_l		macro	op,cnt
   if (CPU eq 186) or (CPU eq 286) or (CPU eq 386)
		shl	op,cnt
   elseif cnt ge 4
		mov	cl,cnt
		shl	op,cl
   else
		rept	cnt
		shl	op,1
		endm
   endif
		endm

setreg		macro
if MEMIO eq YES
		int	WRITE_INT
else
		out	dx,ax
endif
		endm

set1reg		macro
if MEMIO eq YES
		int	WRITE1_INT
else
		out	dx,al
endif
		endm


set1reg_1 	macro
if MEMIO eq YES
		push	ax
		lodsb
		int	WRITE1_INT
		pop	ax
else
		outsb
endif
		endm


get1reg		macro
if MEMIO eq YES
		int	READ1_INT
else
		in	al,dx
endif
		endm


set1regrep	macro
		local	loop@
if MEMIO eq YES
		push	ax
loop@:		lodsb
		int	WRITE1_INT
		loop	loop@
		pop	ax
else
		rep	outsb
endif
		endm


setregrep	macro
		local	loop@
if MEMIO eq YES
		push	ax
loop@:
		lodsw
		int	WRITE_INT
		loop	loop@
		pop	ax
else
		rep	outsw
endif
		endm
