/* code to initialize a vga card (Western Digital) */

/*#define TRIDENT	/**/
/*#define PARADISE	/**/
/*#define WD90C30		/**/




#include "addr.h"
/* should do these with inp/outp */
static unsigned char *vga = (unsigned char *)(AD_8IO+0x3c0);
static unsigned char *crt = (unsigned char *)(AD_8IO+0x3d0);
static unsigned char *pos = (unsigned char *)(AD_8IO+0x102);
static unsigned char *enable = (unsigned char *)(AD_8IO+0x46e8);
static unsigned short *mem = (unsigned short *)(AD_8ME+0xb8000); /**/

static int state = 0;
static int ansi = 0;	/* in ansi mode */


vga_init()
{
int i,j;
unsigned char x;
unsigned char *a;
unsigned short tmp ;
extern unsigned char vga_font[],vga_palette[];


	state = ansi = 0;
	/* check to see if we are already initialized */

	tmp = *mem;
	*mem = 0xaa55;
	if(*mem == 0xaa55){
		*mem = tmp;
		goto vga_ok;
	}

	*enable = 0x10;
	*pos = 0x01;
	*enable = 0x0f;

#ifdef TRIDENT
	vga[4] = 0xb; vga[5] = 0;       /* switch to old mode */
	vga[4] = 0xd; vga[5] = 0x05;            /* CRT mode */
	vga[4] = 0xe; vga[5] = 0x0;
	vga[4] = 0xf; vga[5] = 0x0;
	vga[4] = 0x1e; vga[5] = 0x0;
#endif


	crt[8] = 0x29;
	crt[9] = 0x00;

#ifdef WD90C30
	vga[2] = 0x63;	/* set mode WS90C30, clock pins are different */
#endif
#ifdef PARADISE
	vga[2] = 0x67;		/* PVGA1 */
#endif

	/* synchronous reset on */
	vga[4] = 0x00; vga[5] = 0x01;

	/* load sequencer registers */
	vga[4] = 1; vga[5] = 0;
	vga[4] = 2; vga[5] = 3;
	vga[4] = 3; vga[5] = 0;
	vga[4] = 4; vga[5] = 2;
#ifdef WD90C30
	vga[4] = 0x06; vga[5] = 0x48;	/* enable PR21-35 */
/*
	vga[4] = 0x07 ; vga[5] = 0xf8;
	vga[4] = 0x08 ; vga[5] = 0x0;
	vga[4] = 0x09 ; vga[5] = 0x0;
	vga[4] = 0x10 ; vga[5] = 0xc5;
	vga[4] = 0x11 ; vga[5] = 0x6d;
	vga[4] = 0x12 ; vga[5] = 0x4;
	vga[4] = 0x13 ; vga[5] = 0x80;
	vga[4] = 0x14 ; vga[5] = 0x0;
	vga[4] = 0x15 ; vga[5] = 0x0;
*/
	vga[14] = 0x14; vga[15] = 0x0;
#endif


	/* synchronous reset off */
	vga[4] = 0x00; vga[5] = 0x03;
	
	/* unprotect CRT registers */
	crt[4] = 17; crt[5] = crt[5] & 0x7f;
	
	/* load CRT registers */
	crt[4] = 0; crt[5] = 0x5f;
	crt[4] = 1; crt[5] = 0x4f;
	crt[4] = 2; crt[5] = 0x50;
	crt[4] = 3; crt[5] = 0x82;
	crt[4] = 4; crt[5] = 0x55;
	crt[4] = 5; crt[5] = 0x81;
	crt[4] = 6; crt[5] = 0xbf;
	crt[4] = 7; crt[5] = 0x1f;
	crt[4] = 8; crt[5] = 0x0;
	crt[4] = 9; crt[5] = 0x4f;
	crt[4] = 10; crt[5] = 0xd;
	crt[4] = 11; crt[5] = 0xe;
	crt[4] = 12; crt[5] = 0x00;
	crt[4] = 13; crt[5] = 0x00;
	crt[4] = 14; crt[5] = 0x0;
	crt[4] = 15; crt[5] = 0x0;
	crt[4] = 16; crt[5] = 0x9c;
	crt[4] = 17; crt[5] = 0x8e;
	crt[4] = 18; crt[5] = 0x8f;
	crt[4] = 19; crt[5] = 0x28;
	crt[4] = 20; crt[5] = 0x1f;
	crt[4] = 21; crt[5] = 0x96;
	crt[4] = 22; crt[5] = 0xb9;
	crt[4] = 23; crt[5] = 0xa3;

#ifdef WD90C30
	crt[4] = 0x29; crt[5] = 0x85; /* enable PR11-PR1A */
	crt[4] = 0x2f; crt[5] = 0x02;
#endif

	/* write regular graphics controller registers */
	vga[14] = 0; vga[15] = 0x00;
	vga[14] = 1; vga[15] = 0x00;
	vga[14] = 2; vga[15] = 0x00;
	vga[14] = 3; vga[15] = 0x00;
	vga[14] = 4; vga[15] = 0x00;
	vga[14] = 5; vga[15] = 0x10;
	vga[14] = 6; vga[15] = 0xe;
	vga[14] = 7; vga[15] = 0x00;
	vga[14] = 8; vga[15] = 0xff;

#ifdef PARADISE
	/* write PVGA1 extended registers */
	vga[14] = 15; vga[15] = 0x5;	/* unprotect */
	vga[14] = 9; vga[15] = 0x0;
	vga[14] = 10; vga[15] = 0x0;
	vga[14] = 11; vga[15] = 0x0;
	vga[14] = 12; vga[15] = 0x0;
	vga[14] = 13; vga[15] = 0x0;
	vga[14] = 14; vga[15] = 0x0;
#endif



	/* write attribute registers */
	x = crt[10]; vga[0] = 0; vga[0] = 0x00;
	x = crt[10]; vga[0] = 1; vga[0] = 0x01;
	x = crt[10]; vga[0] = 2; vga[0] = 0x02;
	x = crt[10]; vga[0] = 3; vga[0] = 0x03;
	x = crt[10]; vga[0] = 4; vga[0] = 0x04;
	x = crt[10]; vga[0] = 5; vga[0] = 0x05;
	x = crt[10]; vga[0] = 6; vga[0] = 0x14;
	x = crt[10]; vga[0] = 7; vga[0] = 0x07;
	x = crt[10]; vga[0] = 8; vga[0] = 0x38;
	x = crt[10]; vga[0] = 9; vga[0] = 0x39;
	x = crt[10]; vga[0] = 10; vga[0] = 0x3a;
	x = crt[10]; vga[0] = 11; vga[0] = 0x3b;
	x = crt[10]; vga[0] = 12; vga[0] = 0x3c;
	x = crt[10]; vga[0] = 13; vga[0] = 0x3d;
	x = crt[10]; vga[0] = 14; vga[0] = 0x3e;
	x = crt[10]; vga[0] = 15; vga[0] = 0x3f;
	x = crt[10]; vga[0] = 16; vga[0] = 0x0c;
	x = crt[10]; vga[0] = 17; vga[0] = 0x00;
	x = crt[10]; vga[0] = 18; vga[0] = 0x0f;
	x = crt[10]; vga[0] = 19; vga[0] = 0x08;
	x = crt[10]; vga[0] = 20; vga[0] = 0x00;
	x = crt[10]; vga[0] = 0x20;


	/* load DAC */
	vga[8] = 0;
	for(i=0;i<(256*3);i++){
		vga[9] = vga_palette[i];
	}

	/* load font */
	vga[4] = 2; vga[5] = 0x04;	/* modify plane 2 */
/*	vga[14] = 4; vga[5] = 0x02;	/* read plane 2 */
/*	vga[14] = 0xb; vga[15] = 0x30;	/* turn on virtual memory */
	a = (unsigned char *)mem;
	/* fonts for 0-127 */
	for(i=0;i<128;i++){
		for(j=0;j<16;j+=2){
			*a = vga_font[i*16+j];
			vga[2] = 0x47;	/* high 64k */
			*a = vga_font[i*16+j+1];
			vga[2] = 0x67;
			a += 2;
			
		}
		for(j=0;j<8;j++){
			*a = 0xff;
			vga[2] = 0x47;	/* high 64k */
			*a = 0xff;
			vga[2] = 0x67;
			a += 2;
		}
	}
	/* repeat for 128-255 */
	for(i=0;i<128;i++){
		for(j=0;j<16;j+=2){
			*a = vga_font[i*16+j];
			vga[2] = 0x47;	/* high 64k */
			*a = vga_font[i*16+j+1];
			vga[2] = 0x67;
			a += 2;
		}
		for(j=0;j<8;j++){
			*a = 0xff;
			vga[2] = 0x47;	/* high 64k */
			*a = 0xff;
			vga[2] = 0x67;
			a += 2;
		}
	}
	vga[4] = 0x02; vga[5] = 0x03;	/* plane 1/2 */
/*	vga[14] = 4; vga[5] = 0x00;	/* read plane 0 */
/*	vga[14] = 0xb; vga[15] = 0x00;	/* regular mapping */

#ifdef WD90C30
	vga[2] = 0x63;		/* WD90C30 */
#endif
#ifdef PARADISE
	vga[2] = 0x67;		/* PVGA1 */
#endif

	tmp = *mem;
	*mem = 0xaa55;
	if(*mem != 0xaa55)
		return(-1);

vga_ok:
	vga_clear(0,2000);
	vga_setcursor(0);
	vga_setmem(0);

	return(0);

}



/*
	emulate a VT100/VT52 terminal
	states
		0	- normal
		1	- escape sequence
		2	- first character of cursor movement
		3	- secon character of cursor movement
		'['	- ansi sequence,
			(esc)'['[p1[';'p2['l'p3...]].
		'#'	- special modes
		'('	- g0 character set sequence
		')'	- g1 character set sequence

	---
	we use hardware scrolling, but have to deal with the last
	page in memory differently, because the character generator 
	doesn't roll over the addresses from 0x4000->0x0000.
*/

vga_putc(c)
unsigned char c;
{
int loc,base;
int i;
static int top=1,bott=25;
static int verb=0;
static int row,col;
static int parm[10];
static int np;
static int sloc=0,sattr=0x07;
static int attr = 0x07;

	c &= 0x7f;
	base  = vga_getmem();
	loc = vga_getcursor() - base;

	switch (state) {
		case 0:
			if(verb){
				if(c == '\026'){
					verb = 0;
					return;
				}
				vga_set(base+loc,c << 8 | attr);
					if((loc % 80) != 79)
						loc++;
				break;
			}else {
				if(c == '\026'){
					verb = 1;
					return;
				}
			}
			switch(c){
				case '\033':
					state = 1; 
					return;
				case '\n':
				case '\013':
				case '\014':
					loc += 80;
					break;
				case '\r':
					loc -= loc % 80;
					break;
				case '\b':
					loc --;
					break;
				case '\t':
					if(loc % 8)
						loc += loc % 8;
					else
						loc += 8;
					break;
				case '\007':	/* bell */
					break;
				default:
					vga_set(base+loc,c << 8 | attr);
					if((loc % 80) != 79)
						loc++;
					break;
			}
			break;
		case 1:
			switch(c){
				case 'A':/* up */
					loc -= 80;
					loc %= 2000;
					break;
				case 'B':/* down */
					loc += 80;
					loc %= 2000;
					break;
				case 'C':/* right */
					if((loc+1) % 80) loc++ ;
					break;
				case 'c':/* reset */
					base = loc = 0;
					attr = 0x07;
					state = 0;
					ansi = 0;
					top = 1;
					bott = 25;
					vga_clear(0,2000);
					break;
				case 'D':/* left (vt52), index (ansi) */
					if(ansi){
						loc += 80;
					}else{
						if(loc % 80) loc--; 
					}
					break;
				case 'E':/* next line (ansi) */
					if(ansi){
						loc -= loc % 80;
						loc += 80;
					}
				case 'H':/* home (vt52), tab stop (ansi) */
					if(!ansi) loc = 0;
					break;
				case 'I':/* reverse line feed */
					loc -= 80;
					break;
				case 'J':/* CEOS */
					vga_clear(base+loc,base+2000);
					break;
				case 'K':/* CEOL */
					vga_clear(base+loc,base+(loc+80)-((loc+80) % 80));
					break;
				case 'M':/* reverse index (ansi) */
					if(ansi)
						loc -= 80;
					break;
				case '[':/* ansi lead-in */
					state = c;
					ansi = 1;	/* we have seen ansi */
					np = 0;
					parm[0] = 0;
					parm[1] = 0;
					return;
				case '(':/* character set G0 commands (ansi )*/
				case ')':/* character set G1 commands (ansi )*/
				case '#':/* line size commands (ansi )*/
					state = c;
					return;
					break;
				case 'Y':/* cursor */
					state = 2;
					return;
				case '7':/* save cursor and attr. (ansi) */
					sloc = loc;
					sattr = attr;
					break;
				case '8':/* restore cursor and attr. (ansi) */
					loc = sloc;
					attr = sattr;
					break;
				case '<':/* enter ansi mode */
					ansi = 1;
					break;
				case 'F':/* graphics char set */
				case 'G':/* ascii char set */
				case 'Z':/* identify */
				case '=':/* alt. keypad mode */
				case '>':/* exit alt. keypad */
				default:/* whatever is left */
					break;
			}
			break;
		case 2:
			row = c - ' ';	/* minus space */
			state++;
			return;
		case 3:
			col = c - ' ';	/* minus space */
			loc = (row * 80) + col;
			break;
		case '[':
			switch(c){
				case '?':	/* hmm */
					return;
				case ';': 	/* parameter seperator */
					np++;
					parm[np] = 0;
					return;
				case '0':	/* parameters */
				case '1':
				case '2':
				case '3':
				case '4':
				case '5':
				case '6':
				case '7':
				case '8':
				case '9':
					parm[np] = parm[np]*10 + (c - '0');
					return;
				case 'A':/* cursor up */
					parm[0] = parm[0] ? parm[0] : 1;
					while(parm[0]--){
						loc -= 80;
						loc %= 2000;
					}
					break;
				case 'B':/* cursor down */
					parm[0] = parm[0] ? parm[0] : 1;
					while(parm[0]--){
						loc += 80;
						loc %= 2000;
					}
					break;
				case 'C':/* cursor right */
					parm[0] = parm[0] ? parm[0] : 1;
					while(parm[0]--){
						if((loc+1) % 80) loc++ ;
					}
					break;
				case 'c':/* identify */
					break;
				case 'D':/* cursor left */
					parm[0] = parm[0] ? parm[0] : 1;
					while(parm[0]--){
						if(loc % 80) loc--; 
					}
					break;
				case 'H':/* cursor movement */
				case 'f':/* cursor movement */
					parm[0] = (parm[0]?parm[0]:1)%26;
					parm[1] = (parm[1]?parm[1]:1)%81;
					loc = (parm[0]-1)*80 + (parm[1]-1);
					break;
				case 'h':/* set mode */
				case 'l':/* reset mode */
					break;
				case 'm':/* character attribute */
					for(i=0;i<np+1;i++)
						switch(parm[i]){
							case 0: /* normal */
								attr = 0x07;
								break;
							case 1: /*bold*/
								attr |= 0x0f;
								break;
							case 4: /*underscore*/
								attr |= 0x01;
								break;
							case 5:	/* blink */
								attr |= 0x87;
								break;
							case 7:
								attr = 0x70;
								break;
							default:
								break;
						}
					break;
				case 'n':/* report */
					break;
				case 'K':/* erase in line */
					switch(parm[0]){
						case 0:
							vga_clear(base+loc,base+(loc+80)-((loc+80) % 80));
							break;
						case 1:
							vga_clear(base+loc - (loc%80),base+loc+1);
							break;
						case 2:
							vga_clear(base+loc - (loc%80),base+(loc+80)-((loc+80) % 80));
							break;
						default: break;
					}
					break;
				case 'J':/* erase in display */
					switch(parm[0]){
						case 0:
							vga_clear(base+loc,base+2000);
							break;
						case 1:
							vga_clear(base+0,base+loc+1);
							break;
						case 2:
							vga_clear(base+0,base+2000);
							break;
						default: break;
					}
					break;
				case 'r':/* scrolling region */
					top = parm[0]?parm[0]:1;
					bott = parm[1]?parm[1]:1;
					break;
				case 'q':/* LEDS */
				case 'g':/* tab stops */
				case 'y':/* confidence tests */
				default: 
					break;
			}
			break;
		case '#':
		case '(':
		case ')':
			switch(c){
				case 'A':/* UK */
				case 'B':/* ASCII */
				case '0':/* special graphics */
				case '1':/* alt. character set */
				case '2':/* alt. character set */
				case '3':/* dbl height top */
				case '4':/* dbl height bottom */
				case '5':/* sgl width single height */
				case '6':/* dbl width single height */
				case '8':/* confidence test */
				default:
					break;
			}
			break;
		default:
			break;
	} /* switch (state) */

	state = 0;

	while( loc >= (bott*80)){
		base += 80;
		if(base > (179*80))
			base -= (179*80);
		vga_clear(base+1920,base+2000);
		loc -= 80;
	}
	while( loc < ((top-1)*80) ){
		base -= 80;
		if(base < 0)
			base += (179*80);
		vga_clear(base,base+80);
		loc += 80;
	}

	vga_setcursor(loc+base);
	vga_setmem(base);

	return;

}

/*
	clear a region of display memory
*/
vga_clear(s,e)
register int s,e;
{
register int i;

	for(i=s;i<e;i++)
		vga_set(i,0x2007);
}

/*
	set a value in display memory 
*/
vga_set(addr,val)
register int addr;
register int val;
{
unsigned short x;
	
/*
	x = val & 0xff << 8;
	x |= val & 0xff >> 8;
*/
	x = val;

	addr %= 0x4000;
	mem[addr] = x;
	if(addr >= (179*80))
		mem[addr - (179*80)] = x;
	if(addr < 2000)
		mem[addr + (179*80)] = x;
}
vga_setcursor(loc)
int loc;
{
	crt[4] = 0x0e; crt[5] = loc >> 8;
	crt[4] = 0x0f; crt[5] = loc;
}
vga_getcursor()
{
int loc;
	crt[4] = 0x0e; loc = crt[5] << 8;
	crt[4] = 0x0f; loc |= crt[5];
	return(loc);
}
vga_setmem(loc)
int loc;
{
	crt[4] = 0x0c; crt[5] = loc >> 8;
	crt[4] = 0x0d; crt[5] = loc;
}
vga_getmem()
{
int loc;
	crt[4] = 0x0c; loc = crt[5] << 8;
	crt[4] = 0x0d; loc |= crt[5];
	return(loc);
}
