#define COM1	(0x3f8)
#define COM2	(0x2f8)
#define COM3	(0x3e8)
#define COM4	(0x2e8)
#define PORT	COM1

#include "globram.h"
#include "io.h"

unsigned long hex8(),hex6(),hex4(),hex2(),hex();
unsigned long gethex8(),gethex6(),gethex4(),gethex2(),gethex();

extern int printer;

#define DELAY(n)	{ int x=n; while(--x) ;}

gets(s)
char *s;
{
	while(1){
		*s = getchar();
		if(*s == '\n' || *s == '\r')
			break;
		s++;
	}
	*s = '\0';
}
puts(s)
char *s;
{
	while(*s)
		putchar(*s++);
}
getchar()
{
char c;
	c = inchar(globram->console);
	if(c == '\r')
		c = '\n';
	putchar(c);
	return(c);
}
instat(n)
int n;
{
int port;
char c;
	switch(n){
		case 0: return(kbd_stat());
		case 1: port = COM1; break;
		case 2: port = COM2; break;
		case 3: port = COM3; break;
		case 4: port = COM4; break;
		default: port = COM1; break;
	}
	
	if(inp(port+5) & 0x01){
		c = inp(port+0) & 0x7f;
		return(c);
	}
	return(0);
}

inchar(n)
register int n;
{
register int c;
	while(!(c=instat(n)))
		;
	return(c);
}
putchar(c)
char c;
{
	if(c == '\n') putchar('\r');
	outchar(globram->console,c);
	if(printer) prt_putc(c);
}
outchar(n,c)
int n;
char c;
{
int port;
char x;
	switch(n){
		case 0: vga_putc(c); return;
		case 1: port = COM1; break;
		case 2: port = COM2; break;
		case 3: port = COM3; break;
		case 4: port = COM4; break;
		case 5: prt_putc(c); return;
		default: port = COM1; break;
	}
	while(!(inp(port+5) & 0x20))
		;
	outp(port+0,c);
}
init(n)
int n;
{
int port;
int v;
	switch(n){
		case 0: v = vga_init(); kbd_init(); return(v);
		case 1: port = COM1; break;
		case 2: port = COM2; break;
		case 3: port = COM3; break;
		case 4: port = COM4; break;
		case 5: return(prt_init()); 
		default: port = COM1; break;
	}
	outp(port+3,0x80);
	outp(port+0,0x0c);
	outp(port+1,0x00);
	outp(port+3,0x03);
	return(0);
}
modemctl(n,s,c)
int n;
unsigned s,c;		/* set, clear bits */
{
int port;
	switch(n){
		case 1: port = COM1; break;
		case 2: port = COM2; break;
		case 3: port = COM3; break;
		case 4: port = COM4; break;
		default: port = COM1; break;
	}
	if(c) outp(port+4,inp(port+4)&~c);
	if(s) outp(port+4,inp(port+4)|s);

	return(inp(port+4));
}
modemstat(n)
int n;
{
int port;
	switch(n){
		case 1: port = COM1; break;
		case 2: port = COM2; break;
		case 3: port = COM3; break;
		case 4: port = COM4; break;
		default: port = COM1; break;
	}
	return(inp(port+6));
}

baud(n,br)
int n,br;
{
int port;
unsigned int x;
	switch(n){
		case 1: port = COM1; break;
		case 2: port = COM2; break;
		case 3: port = COM3; break;
		case 4: port = COM4; break;
		default: port = COM1; break;
	}
	x = FREQ / ( 16 * br);
	outp(port+3,inp(port+3)|0x80);
	outp(port+0,x);
	outp(port+1,x>>8);
	outp(port+3,inp(port+3)&~0x80);
}

puthex8(x)
unsigned x;
{
	puthex4(x>>16);
	puthex4(x);
}
puthex4(x)
unsigned x;
{
	puthex2(x>>8);
	puthex2(x);
}
puthex2(c)
unsigned char c;
{
	puthex(c>>4);
	puthex(c);
}
puthex(c)
unsigned char c;
{
	c &= 0xf;
	if(c > 9)
		putchar(c-10+'A');
	else
		putchar(c+'0');
}
getline(s,n)
char *s;
int n;
{
	while(--n){
		*s = getchar() & 0x7f;
		if(*s == '\n' || *s == '\r')
			break;
		s++;
	}
	*s = '\0';
}
unsigned long hex8(cp)
char **cp;
{
unsigned long val;
	val = hex4(cp) << 16;
	val |= hex4(cp) ;
	return(val);
}
unsigned long hex6(cp)
char **cp;
{
unsigned long val;
	val = hex2(cp) << 16;
	val |= hex4(cp) ;
	return(val);
}
unsigned long hex4(cp)
char **cp;
{
unsigned long val;
	val = hex2(cp) << 8;
	val |= hex2(cp) ;
	return(val);
}
unsigned long hex2(cp)
char **cp;
{
unsigned long val;
	val = hex(cp) << 4;
	val |= hex(cp) ;
	return(val);
}
unsigned long hex(cp)
char **cp;
{
	if( **cp >= 'A' && **cp <= 'F' )
		return(*(*cp)++ - 'A' + 10);
	else if( **cp >= 'a' && **cp <= 'f' )
		return(*(*cp)++ - 'a' + 10);
	else if( **cp >= '0' && **cp <= '9' )
		return(*(*cp)++ - '0');
	else
		return(0);
}
unsigned long hexv(cp)
char **cp;
{
unsigned long val;

	val = 0;
	while( (**cp >= 'A' && **cp <= 'F')
		|| (**cp >= 'a' && **cp <= 'f')
		|| (**cp >= '0' && **cp <= '9') ){
		val <<= 4;
		val |= hex(cp);
	}
	return(val);
		
}
unsigned long gethex8()
{
unsigned long val;
	val = gethex4() << 16;
	val |= gethex4() ;
	return(val);
}
unsigned long gethex6()
{
unsigned long val;
	val = gethex2() << 16;
	val |= gethex4() ;
	return(val);
}
unsigned long gethex4()
{
unsigned long val;
	val = gethex2() << 8;
	val |= gethex2() ;
	return(val);
}
unsigned long gethex2()
{
unsigned long val;
	val = gethex() << 4;
	val |= gethex() ;
	return(val);
}
unsigned long gethex()
{
char c;
	if( c >= 'A' && c <= 'F' )
		return(c - 'A' + 10);
	else if( c >= 'a' && c <= 'f' )
		return(c - 'a' + 10);
	else if( c >= '0' && c <= '9' )
		return(c - '0');
	else
		return(0);
}

