; *******************************************************************
; * Amstrad CPC emulator v5.1i                                      *
; * (c) 1991-96 Bernd Schmidt                                       *
; *                                                                 *
; *******************************************************************

	IDEAL

PUBLIC rambase,amsdos,basic,rom7,rom6,rom5,haver5,haver6,haver7
PUBLIC DoScr,inp,outp,memmap,normramseg,sysstat,scrbase
PUBLIC intreq,ffcount
PUBLIC cleanup
PUBLIC ReDrawCount,RedrawScreen,RedrawArea,RethinkCRTC,colmode,SetColors
PUBLIC crtcvgaoff,writevgaoff
PUBLIC ClearCRTCDBuf,reset,multimodeon,modezones,modeffoff
PUBLIC PCRTC_Mode,SetPCsCRTC
PUBLIC lsmode,doublelin,asyncff,clearff,emulr,realtime,fancyrlt
PUBLIC GetPrtState,DoJoystick

PUBLIC SBinstalled,SBport,usesound,PSGcount,psgregmod,psgregs,gusint,sbirq,sbdma
PUBLIC cpctype,quietcas,germkey,DMAblocklen
EXTRN SB_shutdown:PROC,SB_reset:PROC,DoSound:PROC,RethinkPSG:PROC
EXTRN SB_Pause:PROC,SB_continue:PROC,SOUND_Cleanup:PROC

EXTRN  inpFB:PROC,outFA:PROC,outFB:PROC
EXTRN  CloseDisk:PROC,fha:WORD

EXTRN simz80:PROC,sz80l:PROC,interrupt:PROC,sz80gb:PROC
EXTRN simstack:WORD,sAFx:WORD,sBCx:WORD,sDEx:WORD,sHLx:WORD,ix:WORD,iy:WORD
EXTRN srF:WORD,srFhi:WORD,srI:WORD,imode:WORD,sIFF1:BYTE,sIFF2:BYTE
EXTRN intflag:WORD,simz80l:PROC,intspeed:WORD,NormISpeed:WORD
EXTRN imode:WORD

PUBLIC MenuScr,MenuItems,MenuVars,FixPrefs,CPCKtb
PUBLIC RestoreScreen,ResetScreen,OpenTextScr,PutChar

PUBLIC LoadSnap,SaveSnap

; *** Code from files.asm
EXTRN GetDirs:PROC,GetSnapDir:PROC,SelFile:PROC,SelSnap:PROC,GetSaveSnapName:PROC
EXTRN InitTape:PROC,CloseTape:PROC

; *** Data from files.asm
EXTRN snapdir:BYTE,snaname:BYTE,snapha:WORD

; *** Code from misc.asm
EXTRN LoadROMs:PROC,Menu:PROC,ClearKeyMap:PROC,Video:PROC,MyKeyInt:PROC,SetLEDs:PROC

; *** Data from misc.asm
EXTRN KeyMatrix:BYTE,EngNormTab:BYTE,FrnNormTab:BYTE,GerNormTab:BYTE

EXTRN ColorTab:DWORD,ColorTabA:DWORD

; *** Code from comp386.asm
EXTRN UnpackArea:PROC,PackArea:PROC

P386

GROUP   DGROUP _stack,_data

      INCLUDE "macros.inc"

SEGMENT _text PAGE PUBLIC 'CODE'
ASSUME CS:_text
ASSUME DS:DGROUP

start:
      ;  STARTUPCODE
	MOV     DX,DGROUP
	MOV     DS,DX
	MOV     DX,SEG stck
	MOV     SS,DX
	MOV     DX,OFFSET stckend
	MOV     SP,DX

	XOR     EAX,EAX
	XOR     EBX,EBX
	XOR     ECX,ECX
	XOR     EDX,EDX
	XOR     ESI,ESI
	XOR     EDI,EDI
	XOR     EBP,EBP

	MOV     [fha],0ffffh
	MOV     [snapha],0ffffh

	CALL    GetDirs

	CALL    GetOldKeyInt
	CALL    GetOld8253Int

	CALL    GetScrMode

	CALL    OpenPrinter

	MOV     DX,OFFSET prefname        ; load prefs
	MOV     AX,3d00h
	INT     21h
	JC      cleanup
	MOV     BX,AX
	MOV     AH,3Fh
	MOV     DX,OFFSET CPEPrefs
	MOV     CX,42
	INT     21h
	MOV     AH,3Fh
	MOV     DX,OFFSET joystuff
	MOV     CX,8
	INT     21h
	MOV     AH,3Eh
	INT     21h

	CALL    InitRamSegs
	CALL    LoadROMs
	CALL    FixPrefs

	MOV     AX,CS
	MOV     DS,AX
	MOV     DX,OFFSET MyKeyInt
	MOV     AX,2509h
	INT     21h                     ; set interrupt
	MOV     AX,DGROUP
	MOV     DS,AX

	MOV     AX,[normramseg]
	MOV     ES,AX

	MOV     [NormISpeed],1
	MOV     [intspeed],1

	CALL    Set8253Int

	CALL    SB_reset
	CALL    InitHardware
	CALL    reset

	JMP     simz80

cleanup:
	CALL    SB_shutdown
	;CALL    Sound_Cleanup
	CALL    CloseTape
	CALL    CloseDisk
	CALL    DisableInt
	CALL    Res8253Int
	CALL    SetOldMode
	CALL    ClosePrinter
	CALL    CleanupEMM
	EXITCODE

GetOldKeyInt:
	MOV     AX,3509h
	INT     21h
	MOV     [oldintseg],ES
	MOV     [oldintadd],BX
	RET

DisableInt:
	PUSHAD
	MOV     DX,[oldintadd]
	MOV     AX,[oldintseg]
	MOV     DS,AX
	MOV     AX,2509h
	INT     21h                     ; set interrupt
	MOV     AX,DGROUP
	MOV     DS,AX
	POPAD
	RET

GetOld8253Int:
	MOV     AX,3508h
	INT     21h
	MOV     [old8253seg],ES
	MOV     [old8253add],BX
	RET

Set8253Int:
	MOV     AX,CS
	MOV     DS,AX
	MOV     DX,OFFSET My8253Int
	MOV     AX,2508h
	INT     21h
	CLI
	MOV     AX,DGROUP
	MOV     DS,AX

	MOV     DX,43h
	MOV     AL,36h
	OUT     DX,AL
	MOV     DX,40h
	MOV     AX,[timerval]
	OUT     DX,AL
	MOV     AL,AH
	OUT     DX,AL
	STI
	RET

Res8253Int:
	CLI
	MOV     DX,43h
	MOV     AL,36h
	OUT     DX,AL
	MOV     DX,40h
	MOV     AL,000h
	OUT     DX,AL
	MOV     AL,000h
	OUT     DX,AL

	MOV     AX,[old8253seg]
	MOV     DX,[old8253add]
	MOV     DS,AX
	MOV     AX,2508h
	INT     21h
	MOV     AX,DGROUP
	MOV     DS,AX
	STI
	RET

My8253Int:
	PUSH    DS
	PUSH    EAX

	PUSH    DGROUP
	POP     DS

	CALL    My8253Handler

	MOV     AX,[timerval]
	ADD     [timercount],AX
	JNC     M8253_Ret
	POP     EAX
	POP     DS
	JMP     [old8253]

M8253_Ret:
	MOV     AL,20h
	OUT     20h,AL
	POP     EAX
	POP     DS
	IRET

LABEL old8253 DWORD
old8253add  dw    0
old8253seg  dw    0

My8253Handler:
	PUSH    EAX
	PUSH    DS
	PUSH    DX

	MOV     AX,DGROUP
	MOV     DS,AX

	CMP     [resetting],0
	JNE     MII_NotInt

	CMP     [doingems],0
	JNE     MII_NotInt

	CMP     [ffcount],5
	JNE     MII_CheckRHitEnd
	MOV     DX,3dah
	IN      AL,DX
	AND     AL,8h
	MOV     [PCRTC_HITVB],AL
	JE      MII_CheckRHit_noff
	MOV     [PCRTC_VR2CNT],0
	JMP     MII_CheckRHitEnd
MII_CheckRHit_noff:
	CMP     [PCRTC_VR2CNT],20
	JNC     MII_CheckRHitEnd
	INC     [PCRTC_VR2CNT]
MII_CheckRHitEnd:

	DEC     [intcount]
	JNS     MII_intcountok
	MOV     AX,[intspeed]
	ADD     [intcount],AX
MII_intcountok:
	CMP     [intcount],0
	JNE     MII_NotInt

	CMP     [multimodeon],0
	JNE     MII_ExactOverride
	CMP     [permitmm],0
	JE      MII_Exact_NoOverride
	CMP     [lastmodechg],6
	JC      MII_ExactOverride
MII_Exact_NoOverride:
	CMP     [exactint],0
	JNE     MII_ExactInt
MII_ExactOverride:
	MOV     AX,[intflag]            ; check if last int has been
	AND     AX,4000h                ; processed by simz80
	JZ      MII_ExactInt
	MOV     [omitnextint],2
MII_ExactInt:

	CMP     [permitmm],0
	JE      MII_MMEnd
	MOV     AX,[modeinprogr]
	CMP     AX,0
	JE      MII_NoModeIP
	MOV     [omitnextint],2
	JMP     MII_MMEnd
MII_NoModeIP:
	CMP     [multimodeon],0
	JE      MII_MMEnd
	MOV     AX,[mozoctdn]
	OR      AX,AX
	JZ      MII_NoZoneChgHappened
	DEC     [mozoctdn]
	JNZ     MII_NoZoneChgHappened
	MOV     [mmintsignal],1
MII_NoZoneChgHappened:
	XOR     EAX,EAX
	MOV     AX,[ffcount]
	MOV     AL,[EAX+modeffoff]
	MOV     DL,[EAX+modezones]
	CMP     DL,[videomode]
	JE      MII_MMEnd
	MOV     DL,[videomode]
	MOV     [EAX+modezones],DL
	MOV     [modezochgd],1
MII_MMEnd:

	CMP     [multimodeon],0
	JE      MII_StillMM
	MOV     DX,[WORD PTR modezones]
	CMP     [WORD PTR modezones+2],DX
	JNE     MII_StillMM
	CMP     [WORD PTR modezones+4],DX
	JNE     MII_StillMM
	OR      [intflag],1
	MOV     [RedrawCount],10
	MOV     [multimodeon],41h
MII_StillMM:

	CMP     [omitnextint],0
	JE      MII_NoOmit
	DEC     [omitnextint]
	JMP     MII_NotInt
MII_NoOmit:

	OR      [intflag],4000h

	DEC     [ffcount]
	JNS     MII_noff
	MOV     AX,[lastdbuf]
	OR      AX,AX
	JE      MII_nodbuf
	CMP     AX,1
	JNE     MII_decdbuf
	OR      [intflag],8
MII_decdbuf:
	DEC     [lastdbuf]
	CMP     [xchgdbuf],0
	JE      MII_nodbuf
	CMP     [lastdbuf],22
	JNE     MII_nodbuf
	CALL    SetNewScrBase
MII_nodbuf:
	MOV     [ffcount],5
	OR      [intflag],8000h
MII_noff:

	CMP     [permitmm],0
	JE      MII_NoMultiModePermitted
	MOV     AL,[lastmodechg]
	INC     AL
	CMP     AL,10
	JNE     MII_MuMo_ALOK
	DEC     AL
MII_MuMo_ALOK:
	CMP     AL,7
	JNE     MII_MuMo_WBackAL
	CMP     [multimodeon],0
	JNE     MII_MuMo_WBackAL
	OR      [intflag],1
	MOV     [RedrawCount],1
MII_MuMo_WBackAL:
	MOV     [lastmodechg],AL
MII_NoMultiModePermitted:

	MOV     DX,0
	MOV     AX,4
	CMP     [asyncff],0
	JE      MII_syncok
	INC     AX
;       CMP     [fancyrlt],0
;       JE      MII_syncok
;       MOV     AX,3
MII_syncok:
	CMP     [ffcount],AX
	JNE     MII_FF4End
	MOV     DX,1
	MOV     AX,[ffly_dec_std]
	MOV     [ffly_dec],AX
MII_FF4End:
	MOV     [ffly],DX

MII_NotInt:
	CMP     [PCRTC_MODE],2                  ; MODE = 2 (adjust 50Hz)?
	JNE     MII_FF3End
	CMP     [ffcount],1
	JNE     MII_FF3End
	CMP     [CRTCkyfo],0
	JNE     MII_FF3End
	CLI
	MOV     AX,[PCRTC_VT1]
	MOV     DX,[PCRTC_VR1]
	INC     AL
	INC     DX
	CMP     [PCRTC_HITVB],0
	JNE     MII_VidValsOK
	DEC     AL
	DEC     DX
	CMP     [PCRTC_VR2CNT],20
	JC      MII_VidValsOK
	ADD     AL,4
	ADD     DX,4
MII_VidValsOK:
	PUSH    DX
	PUSH    AX
	MOV     DX,3d4h
	MOV     AL,6h
	OUT     DX,AL
	POP     AX
	INC     DX
	OUT     DX,AL

	MOV     DX,3d4h
	MOV     AL,10h
	OUT     DX,AL
	INC     DX
	POP     AX
	OUT     DX,AL
	DEC     DX
	MOV     AL,7
	OUT     DX,AL
	INC     DX
	IN      AL,DX
	ADD     AH,AH
	ADD     AH,AH
	PUSH    CX
	MOV     CL,AH
	SHL     CL,4
	AND     CL,80h
	AND     AH,4
	AND     AL,7bh
	OR      AL,AH
	OR      AL,CL
	OUT     DX,AL
	POP     CX

MII_FF3End:
	STI
	POP     DX
	POP     DS
	POP     EAX
	RET

DoJoystick:
	CMP     [usejoy],0
	JE      DJOY_End
	CMP     [ffcount],0
	JNE     DJOY_End
	PUSHAD
	MOV     DX,201h
	IN      AL,DX
	XOR     ESI,ESI
	XOR     EDI,EDI
	CLI
	XOR     AX,AX
	OUT     DX,AL

DJOY_l: IN      AL,DX
	AND     AL,3
	JZ      DJOY_lend
	BT      AX,0
	JNC     DJOY_notx
	INC     ESI
DJOY_notx:
	BT      AX,1
	JNC     DJOY_noty
	INC     EDI
DJOY_noty:
	JMP     DJOY_l
DJOY_lend:
	IN      AL,DX
	STI
	MOV     CL,[KeyMatrix+9]
	OR      CL,03fh
	CMP     SI,[joyr]
	JNC     DJOY_notright
	XOR     CL,4
DJOY_notright:
	CMP     [joyl],SI
	JNC     DJOY_notleft
	XOR     CL,8
DJOY_notleft:
	CMP     DI,[joyu]
	JNC     DJOY_notup
	XOR     CL,1
DJOY_notup:
	CMP     [joyd],DI
	JNC     DJOY_notdn
	XOR     CL,2
DJOY_notdn:
	AND     AL,48
	AND     CL,0CFh
	OR      CL,AL
	MOV     [KeyMatrix+9],CL
	POPAD
DJOY_End:
	RET

GetScrMode:
	MOV     AH,0FH
	CALL    Video
	PUSH    AX
	MOV     AX,1130H
	MOV     BH,0
	MOV     DL,0
	CALL    Video
	POP     AX
	MOV     DH,AH
	CMP     DL,25
	SBB     AH,AH
	INC     AH
	MOV     [OldVideo],AX
	RET

SetOldMode:
	MOV     AX,[OldVideo]
	MOV     BX,40h
	MOV     ES,BX
	MOV     BL,20H
	CMP     AL,7            ; smMono
	JNE     @@1
	MOV     BL,30H

@@1:    AND     [BYTE PTR ES:10h],0CFH     ; Equipmentbyte
	OR      [ES:10h],BL
	AND     [BYTE PTR ES:87h],0FEH     ; CrtInfo
	PUSH    AX
	MOV     AH,0
	CALL    Video
	POP     AX
	OR      AH,AH
	JE      @@2
	MOV     AX,1112H
	MOV     BL,0
	CALL    Video
	MOV     AX,1130H
	MOV     BH,0
	MOV     DL,0
	CALL    Video
	CMP     DL,42
	JNE     @@2
	OR      [BYTE PTR ES:87h],1
	MOV     AH,1
	MOV     CX,600H
	CALL    Video
	MOV     AH,12H
	MOV     BL,20H
	CALL    Video
@@2:
	RET

OpenTextScr:
	MOV     AL,[PCRTC_MODE]
	MOV     [tssavedmode],AL
	MOV     [PCRTC_MODE],0

	MOV     AX,3
	CALL    Video
	PUSH    ES
	PUSH    0B800h
	POP     ES
	MOV     CX, 02000h ; whatever
	XOR     AX,AX
	REP     STOSW
	POP     ES
	PUSH    0B800h
	POP     FS
	RET

PutChar:
	MOV     [FS:EDX*2],AX
	RET

RestoreScreen:
	PUSH    AX
	MOV     AL,[tssavedmode]
	MOV     [PCRTC_MODE],AL
	POP     AX
ResetScreen:
	CALL    ClearCRTCDBuf
	MOV     [scrtype],0ffffh
	CALL    SetPCsCRTC
	CALL    RedrawScreen
	RET

FixPrefs:
	CMP     [havejoy],0f00bh
	JNE     FPRF_JoyCalibrated
	MOV     [havejoy],0ffffh

        push ax ;
        push dx ;May be not necesary
        push cx ;

        mov dx, 201h
        mov cx, 0FFFFh
        out dx, al
joybu:  in al, dx
        test al, 1
        jz isjoy
        loop joybu

isjoy:  or cx, cx
        pop cx ;
        pop dx ;Idem
        pop ax ;

        jz FPRF_nojoy

	CMP     [joyr],4
	JNC     FPRF_JoyCalibrated
FPRF_nojoy:
	MOV     [havejoy],0
FPRF_JoyCalibrated:
	CMP     [SBinstalled],0
	JNE     FPRF_DontClearSB
	MOV     [usesound],0
FPRF_DontClearSB:
	MOV     BP,[havejoy]
	AND     [usejoy],BP

	MOV	SI,OFFSET EngNormTab
	CMP	[germkey],0
	JE	SHORT FPRF_FixMap
	MOV	SI,OFFSET FrnNormTab
	CMP	[germkey],1
	JE	SHORT FPRF_FixMap
	MOV	SI,OFFSET GerNormTab
FPRF_FixMap:
	PUSH	ES			; Replace keyboard
	PUSH    SEG amsdos
	POP     ES
	MOV	DI,[CPCKtb]
	MOV	CX,0FAh/2
	REP	MOVSW
	POP	ES

	RET

InitHardware:
	MOV     [CRTCkyfo],0
	MOV     [ffly],0
	MOV     [scrbase],0ffffh
	MOV     [colmode],0
	MOV     [PCRTC_MODE],0
	MOV     [scrtype],0
	CALL    InitTape
	RET

reset:  CALL    SB_Pause
        PUSH    40h
	POP     FS
	CLI
	MOV     AL,[FS:17h]
	OR      AL,96
	XOR     AL,64
	MOV     [FS:17h],AL
	SHR     AL,4
	AND     AL,7
	AND     [BYTE PTR FS:97h],0f8h
	OR      [FS:97h],AL
	STI

	MOV     [resetting],1

	CALL    ClearKeyMap
	CALL    SetLEDs

	MOV     [WORD PTR sysstat],9
	MOV     [memstate],9
	MOV     [romnum],0
	MOV     [doingems],0
	CALL    InitCRTC
	CALL    RethinkMemMap
	CALL    ResetRAMState
	CALL    RethinkRamState
	MOV     sPC,0
	InitPCSeg
	MOV     [sIFF1],0
	MOV     [sIFF2],0
	MOV     [intreq],0
	MOV     [imode],1
	MOV     [omitnextint],2
	MOV     [intflag],0
	MOV     [simstack],0

	MOV     [resetting],0
	XOR     EBP,EBP
        CALL    SB_continue

	RET

InitCRTC:
	MOV     BP,OFFSET CRTCregs
	MOV     [DWORD PTR BP],08e2e283fh
	MOV     [DWORD PTR BP+4],01e190026h
	MOV     [DWORD PTR BP+8],00000700h
	MOV     [DWORD PTR BP+12],00c00030h

	MOV     [crtcvgaoff],0FFFFh
	MOV     [crtcvgaoff+2],0FFFFh
	MOV     [crtcvgaoff+4],0FFFFh
	MOV     [crtcvgaoff+6],00000h
	CALL    GenWriteVGAoff
	MOV     [crtcscrheight],25
	MOV     [crtcscrwidth],40
	MOV     [scroff],0
	MOV     [scrbase],0C000h
	MOV     [vgascroll],0
	MOV     [scrtype],0ffffh

	MOV     [mmintsignal],0
	MOV     [videomode],1
	MOV     [newvidmode],1
	MOV     [WORD PTR modezones],0101h
	MOV     [WORD PTR modezones+2],0101h
	MOV     [WORD PTR modezones+4],0101h
	MOV     [WORD PTR oldmzones],0101h
	MOV     [WORD PTR oldmzones+2],0101h
	MOV     [WORD PTR oldmzones+4],0101h
	MOV     [lastmodechg],9
	MOV     [multimodeon],0
	MOV     [modeinprogr],0
	MOV     [modezochgd],0
	MOV     [mozoctdn],0

	CALL    InitScroff
	CALL    SetPCsCRTC
	CALL    GenByteMode
	CALL    GenLatchTables
	RET

ClearCRTCDbuf:                    ; adjusts crtcvgaoff so that all except current
	PUSH    sFree
	PUSH    BP
	MOV     sFree,[scrbase]   ; bank have to be redrawn
	SHR     sFree,14
	MOV     BP,[EsFree*2+crtcvgaoff]
	MOV     [crtcvgaoff],0FFFFh
	MOV     [crtcvgaoff+2],0FFFFh
	MOV     [crtcvgaoff+4],0FFFFh
	MOV     [crtcvgaoff+6],0FFFFh
	MOV     [EsFree*2+crtcvgaoff],BP
	POP     BP
	POP     sFree
	CALL    GenWriteVGAoff
	RET

GenWriteVGAoff:
	PUSHAW
	XOR     BX,BX
	XOR     DH,DH
	MOV     CX,4
GWVO_Loop:
	MOV     AX,0ffffh
	MOV     DL,[BX+ramstate]
	CMP     DL,4
	JNC     GWVO_AXOK
	MOV     AX,[EDX*2+crtcvgaoff]
GWVO_AXOK:
	MOV     [EBX*2+writevgaoff],AX
	INC     BX
	LOOP    GWVO_Loop
	POPAW
	RET

RedrawArea:
	CMP     [multimodeon],0
	JNE     RDA_SimpleMinded
	PUSHAW                    ; AX: vga offset; ES: readseg; CX: len
	PUSH    DS                ; SI: first addr
	PUSH    ES
	PUSH    ES
	MOV     DX,AX
	ADD     DX,[vgascroll]

	MOV     BX,SEG ScrAdConv
	MOV     FS,BX
	MOV     BP,SI
	AND     BP,3fffh
	ADD     BP,BP
	ADD     BP,OFFSET ScrAdConv

	LES     BX,[scradd]
	ADD     BH,[videomode]
	POP     DS
RDA_Loop1:
	LODSB
	XLAT    [ES:0]
	MOV     DI,[FS:BP]
	ADD     DI,DX
	STOSB

	ADD     BP,2
	LOOP    RDA_Loop1
	POP     ES
	POP     DS
	POPAW
	RET

RDA_SimpleMinded:
	PUSHAW
	MOV     BP,SI
	MOV     sFree,AX
RDA_SimpleLoop:
	PUSH    BP
	PUSH    sFree
	MOVZX   AX,[ES:BP]
	CALL    DoScr
	POP     sFree
	POP     BP
	INC     BP
	LOOP    RDA_SimpleLoop
	POPAW
	RET

MACRO   argh1
	LODSB
	XLAT    [ES:0]
	STOSB
ENDM

MACRO argh2
      argh1
      argh1
ENDM

MACRO argh3
      argh2
      argh2
ENDM

MACRO argh4
      argh3
      argh3
ENDM

MACRO argh5
      argh4
      argh4
ENDM

RDS_UnfoldedLoop:
	argh5
	argh5
	argh5
	argh5
	argh5
	argh5
	argh5
	argh5
	argh5
	argh5
	argh5
	argh5
	argh5
	argh5
	argh5
	argh5
	argh5
	argh5
	argh5
	argh5
	argh5
	argh5
	argh5
	argh5
	argh5
	argh5
	argh5
	argh5
	argh5
	argh5
	argh5
	argh5
	argh1
RDS_ULByteCnt:
	argh1
RDS_ULZero:
	JMP     RDS_Loop

RedrawScreen:
	CMP     [multimodeon],0
	JNE     RDS_SimpleMinded
	PUSHAW
	PUSH    DS
	PUSH    ES
	MOV     BP,SEG ScrAdList
	MOV     FS,BP
	MOV     BP,ES
	MOV     SI,[scrbase]
	SHR     SI,4
	ADD     BP,SI
	LES     BX,[scradd]
	ADD     BH,[videomode]
	MOV     DI,[scrbase]
	SHR     DI,14
	MOV     DI,[EDI*2+crtcvgaoff]
	ADD     DI,[vgascroll]
	MOV     DS,BP
	MOV     BP,OFFSET ScrAdList

RDS_Loop:
	MOV     SI,[FS:BP]
	MOV     AX,[FS:BP+2]

	ADD     BP,4
	OR      SI,SI
	JS      RDS_End
	ADD     AX,AX
	ADD     AX,AX                   ; LODSB /XLAT ES/STOSB = 4 bytes
	NEG     AX
	ADD     AX,OFFSET RDS_ULZero
	JMP     AX

RDS_End:
	POP     ES
	POP     DS
	POPAW
RDS_Ret:
	RET

RDS_SimpleMinded:
	PUSHAW
	PUSH    DS
	MOV     BP,[scrbase]
	MOV     DI,BP                    ; DI: CPC screen addr
	ADD     DI,3fffh
	SHR     BP,14
	MOV     BP,[EBP*2+crtcvgaoff]
	ADD     BP,[vgascroll]           ; BP: VGA Screen offset
	MOV     CX,04000h                ; CX: counter
	MOV     SI,07ffeh                ; SI: offset to ScrAdConv
	LFS     BX,[scradd]              ; FS:BX 0a000:SColOff
	PUSH    SEG ScrAdConv
	POP     DS
	STD
RDS_Easy_Loop:
	MOV     DX,[DS:SI+OFFSET ByteMode]
	MOVZX   AX,[ES:DI]
	ADD     AX,DX
	ADD     AX,BX
	MOV     AL,[FS:EAX]              ; read latch

	LODSW                            ; read converted VGA addr
	ADD     AX,BP
	MOV     [FS:EAX],AL              ; write latch
	DEC     DI
	LOOP    RDS_Easy_Loop
	CLD
	POP     DS
	POPAW
	RET

DoScr:                                  ; in sFree vga offset, BP cpc addr
	PUSH    SEG ScrAdConv
	POP     FS
	ADD     BP,BP
	BTR     BP,15
	ADD     sFree,[FS:BP]           ; assumed: OFFSET ScrAdConv == 0
	ADD     sFree,[vgascroll]
	ADD     BP,OFFSET ByteMode
	ADD     AX,[FS:BP]
	LFS     BP,[scradd]
	ADD     BP,AX
	MOV     AL,[FS:BP]
	MOV     [FS:sFree],AL
	RET

RethinkCRTC:
	PUSH    sFree        ; 1: GenScrAdConv, 2: ClearCRTCDBuf, 4: Redraw
	XOR     sFree,sFree  ; 8: SetPCsCRTC, 16: InitScroff
	PUSH    AX           ; 64: SetNewScrBase, 128: GenByteMode
	PUSH    BP           ; 32768: only scroll
	MOV     BP,[WORD PTR CRTCregs+12]
	ROL     BP,8
	ADD     BP,BP
	MOV     AX,BP
	ADD     BP,BP
	AND     AX,7FEh
	AND     BP,0C000h

	CMP     AX,[scroff]     ; ********** has the screen offset changed?
	JE      CRTC_nonewscroff
	XCHG    [scroff],AX
	SUB     AX,[scroff]
	AND     AX,7feh
	MOV     [oldscroff],AX
	OR      sFree,8007h
	CMP     [multimodeon],0
	JE      CRTC_nonewscroff
	OR      sFree,128
CRTC_nonewscroff:
	CMP     BP,[scrbase]    ; ********** has the screen base changed?
	JE      CRTC_nonewbase

	OR      sFree,64
	AND     sFree,7fffh
	MOV     [lastdbuf],25
	PUSH    BX
	PUSH    DX
	MOV     BX,[scrbase]
	MOV     [scrbase],BP
	SHR     BP,14
	MOV     DX,[EBP*2+crtcvgaoff]
	OR      DX,DX
	JNS     CRTC_newscrbase_end
CRTC_newscrbase_rd:
	SHR     BX,14
	MOV     DX,[EBX*2+crtcvgaoff]
	MOV     [crtcvgaoff],0ffffh
	MOV     [crtcvgaoff+2],0ffffh
	MOV     [crtcvgaoff+4],0ffffh
	MOV     [crtcvgaoff+6],0ffffh
	CMP     [permitdbuf],0
	JE      CRTC_dbufforbidden
	MOV     [EBX*2+crtcvgaoff],DX
CRTC_dbufforbidden:
	XOR     DX,4000h
	MOV     [EBP*2+crtcvgaoff],DX
	CALL    GenWriteVGAoff
	OR      sFree,4
CRTC_newscrbase_end:
	POP     DX
	POP     BX
CRTC_nonewbase:
	MOV     AX,[sysstat]    ; ********** has the mode changed?
	AND     AX,3
	MOV     AL,[MoTable+EAX]
	CMP     AL,[videomode]
	JE      CRTC_NoNewMode
	CMP     [multimodeon],0
	JNE     CRTC_Mode_MultiIsOn

	MOV     [videomode],AL
	AND     sFree,7fffh
	OR      sFree,86h
	JMP     CRTC_NoNewMode
CRTC_Mode_MultiIsOn:
	NOP                     ; Bug!
CRTC_NoNewMode:
	TEST    [multimodeon],40h ; ********* did one of the modezones change?
	JZ      CRTC_DontDoMMChg
	AND     [multimodeon],0BFh
	PUSH    EAX
	MOV     EAX,[DWORD PTR modezones]
	SUB     EAX,[DWORD PTR oldmzones]
	JNZ     CRTC_ModeChgCorrect
	MOV     AX,[WORD PTR modezones+4]
	SUB     AX,[WORD PTR oldmzones+4]
CRTC_ModeChgCorrect:
	POP     EAX
	JZ      CRTC_DontDoMMChg
	MOV     AX,[WORD PTR modezones]
	MOV     [WORD PTR oldmzones],AX
	MOV     AX,[WORD PTR modezones+2]
	MOV     [WORD PTR oldmzones+2],AX
	MOV     AX,[WORD PTR modezones+4]
	MOV     [WORD PTR oldmzones+4],AX
	MOV     [modeinprogr],1
	AND     sFree,7fffh
	OR      sFree,86h
	MOV     AX,[WORD PTR modezones]
	CMP     AX,[WORD PTR modezones+1]
	JNE     CRTC_DontDoMMChg
	CMP     AX,[WORD PTR modezones+2]
	JNE     CRTC_DontDOMMChg
	CMP     AX,[WORD PTR modezones+4]
	JNE     CRTC_DontDoMMChg
	MOV     [multimodeon],0
CRTC_DontDoMMChg:
	MOV     AL,[BYTE PTR CRTCregs+1]
	CMP     AL,[crtcscrwidth]; ********* has the screen width changed?
	JE      CRTC_nonewwidth
	CMP     AL,128
	JC      CRTC_NewWidth_OK
	MOV     AL,40
CRTC_NewWidth_OK:
	MOV     [crtcscrwidth],AL
	AND     sFree,7fffh
	OR      sFree,1eh
	CMP     [multimodeon],0
	JE      CRTC_nonewwidth
	OR      sFree,80h
CRTC_nonewwidth:
	MOV     AL,[BYTE PTR CRTCregs+6]
	CMP     AL,[crtcscrheight]; ******** has the screen height changed?
	JE      CRTC_nonewheight
	MOV     [crtcscrheight],AL
	AND     sFree,7fffh
	OR      sFree,1ch
	CMP     [multimodeon],0
	JE      CRTC_nonewheight
	OR      sFree,80h
CRTC_nonewheight:
	CMP     [spcrtcflag],0  ; ********** has one of the special regs changed?
	JE      CRTC_SFLAG0
	CMP     [spcrtcflag],2
	JNE     CRTC_SFLAG1
	OR      sFree,96h
CRTC_SFLAG1:
	MOV     [spcrtcflag],0
	AND     sFree,7fffh
	OR      sFree,8
CRTC_SFLAG0:

	TEST    sFree,8000h        ;******* Well, now we can do the necessary
	JZ      CRTC_NotJustScroll ;******* steps...
	CMP     [crtccareful],0
	JNE     CRTC_NotJustScroll
	CALL    JustScrollIt
	OR      sFree,sFree
	JE      CRTC_Rethought
	NOP
CRTC_NotJustScroll:
	TEST    sFree,16
	JZ      CRTC_DontInitScroff
	CALL    InitScroff
CRTC_DontInitScroff:
	TEST    sFree,1
	JZ      CRTC_DontGenScrAdConv
	CALL    GenScrAdConv
CRTC_DontGenScrAdConv:
	TEST    sFree,2
	JZ      CRTC_DontClearCRTCDBuf
	CALL    ClearCRTCDBuf
CRTC_DontClearCRTCDBuf:
	TEST    sFree,8
	JZ      CRTC_DontSetPCsCRTC
	CALL    SetPCsCRTC
CRTC_DontSetPCsCRTC:
	TEST    sFree,64
	JZ      CRTC_NoNewBaseAddr
	CALL    SetNewScrBase
CRTC_NoNewBaseAddr:
	TEST    sFree,128
	JZ      CRTC_DontGenByteMode
	MOV     [modeinprogr],1
	CALL    GenByteMode
CRTC_DontGenByteMode:
	TEST    sFree,4
	JZ      CRTC_DontRedraw
	MOV     [modeinprogr],1
	CALL    RedrawScreen
CRTC_DontRedraw:
CRTC_Rethought:
	CMP     [modeinprogr],0
	JE      CRTC_RTEnd
	MOV     [modeinprogr],0
 ;       AND     [intflag],0bfffh
CRTC_RTEnd:
	POP     BP
	POP     AX
	POP     sFree
	RET

JustScrollIt:
	MOV     AX,[oldscroff]
	MOVZX   BP,[crtcscrwidth]
	ADD     BP,BP
	CMP     AX,BP
	JE      JSIT_scrollup
	CMP     AX,2
	JE      JSIT_scrolllf
	CMP     AX,7feh
	JE      JSIT_scrollrt
	NEG     AX
	AND     AX,7feh
	CMP     AX,BP
	JE      JSIT_scrolldn
	JMP     JSIT_NotJustScroll
JSIT_scrollup:
	CALL    GenScrAdConv
	CALL    ClearCRTCDBuf
	CALL    ScrollUp
	JMP     JSIT_Rethought
JSIT_scrolldn:
	CALL    GenScrAdConv
	CALL    ClearCRTCDBuf
	CALL    ScrollDn
	JMP     JSIT_Rethought
JSIT_scrollrt:
	CALL    GenScrAdConv
	CALL    ClearCRTCDBuf
	CALL    ScrollLf        ; Ich krieg's nie richtig hin!
	JMP     JSIT_Rethought
JSIT_scrolllf:
	CALL    GenScrAdConv
	CALL    ClearCRTCDBuf
	CALL    ScrollRt
JSIT_Rethought:
	XOR     sFree,sFree
	JMP     JSIT_Ret
JSIT_NotJustScroll:
	AND     sfree,7fffh
JSIT_Ret:
	RET

ScrollLf:
	PUSHAW
	PUSH    DS
	PUSH    ES
	CMP     [useVGAroll],0
	JE      SCLF_Conventional
	ADD     [vgascroll],2
	CALL    SetNewScrBase
	JMP     SCLF_blitted
SCLF_Conventional:
	MOVZX   AX,[BYTE PTR CRTCRegs+9]
	INC     AX
	MOVZX   CX,[crtcscrwidth]
	ADD     CX,CX
	MUL     CX
	MOVZX   CX,[crtcscrheight]
	MUL     CX
	MOV     CX,AX
	SUB     CX,2

	MOV     DI,[scrbase]
	SHR     DI,14
	MOV     DI,[EDI*2+crtcvgaoff]
	ADD     DI,[vgascroll]
	MOV     SI,DI
	ADD     SI,2

	MOV     AX,0A000h
	MOV     DS,AX
	MOV     ES,AX

	REP     MOVSB
SCLF_blitted:
	PUSH    SS
	POP     DS

	POP     ES
	PUSH    ES

	PUSH    GS
	MOV     DI,ES
	MOV     AX,[scrbase]
	SHR     AX,4
	ADD     DI,AX
	MOV     GS,DI                   ; GS: Rambase

	MOVZX   CX,[BYTE PTR CRTCRegs+9]; CX: Loop1 (8 lines/char)
	INC     CX
	MOV     AX,[scrbase]
	SHR     AX,14
	MOV     BP,[EAX*2+crtcvgaoff]   ; BP: Vgaoffset
	ADD     BP,[vgascroll]
	LES     BX,[scradd]             ; ES: BX = A000:FD00
	ADD     BH,[videomode]
	MOV     DI,SEG ScrAdConv
	MOV     FS,DI                   ; FS: ScrAdConv
	MOV     SI,[scroff]
	MOVZX   DI,[crtcscrwidth]
	ADD     SI,DI
	ADD     SI,DI
	SUB     SI,2
	AND     SI,7ffh                 ; SI: CPC addr
SLF_Loop1:
	PUSH    SI
	PUSH    CX
	MOVZX   CX,[crtcscrheight]
SLF_Loop2:
	MOV     DI,[FS:ESI*2+ScrAdConv]
	MOV     AL,[GS:SI]
	XLAT    [ES:0]
	ADD     DI,BP
	MOV     [ES:DI],AL

	MOV     DI,[FS:ESI*2+ScrAdConv+2]
	MOV     AL,[GS:SI+1]
	XLAT    [ES:0]
	ADD     DI,BP
	MOV     [ES:DI],AL

	MOVZX   AX,[crtcscrwidth]
	ADD     AX,AX
	MOV     DI,SI
	ADD     SI,AX
	AND     SI,7ffh
	AND     DI,3800h
	ADD     SI,DI

	LOOP    SLF_Loop2
	POP     CX
	POP     SI
	ADD     SI,800h
	AND     SI,3fffh
	LOOP    SLF_Loop1
	POP     GS
SCLF_End:
	POP     ES
	POP     DS
	POPAW
	RET

ScrollRt:
	PUSHAW
	PUSH    DS
	PUSH    ES
	CMP     [useVGAroll],0
	JE      SCRT_Conventional
	SUB     [vgascroll],2
	CALL    SetNewScrBase
	JMP     SCRT_blitted
SCRT_Conventional:
	MOVZX   AX,[BYTE PTR CRTCRegs+9]
	INC     AX
	MOVZX   CX,[crtcscrwidth]
	ADD     CX,CX
	MUL     CX
	MOVZX   CX,[crtcscrheight]
	MUL     CX
	MOV     CX,AX
	SUB     CX,2
	MOV     SI,CX

	MOV     DI,[scrbase]
	SHR     DI,14
	MOV     DI,[EDI*2+crtcvgaoff]
	ADD     DI,[vgascroll]
	ADD     SI,DI
	MOV     DX,DI
	ADD     DI,AX
	DEC     DI
	DEC     SI

	MOV     AX,0A000h
	MOV     DS,AX
	MOV     ES,AX

	STD
	REP     MOVSB
	CLD
SCRT_blitted:
	MOV     AX,DGROUP
	MOV     DS,AX
	POP     ES
	PUSH    ES

	PUSH    GS
	MOV     DI,ES
	MOV     AX,[scrbase]
	SHR     AX,4
	ADD     DI,AX
	MOV     GS,DI                   ; GS: Rambase

	MOVZX   CX,[BYTE PTR CRTCRegs+9]; CX: Loop1 (8 lines/char)
	INC     CX
	MOV     AX,[scrbase]
	SHR     AX,14
	MOV     BP,[EAX*2+crtcvgaoff]   ; BP: Vgaoffset
	ADD     BP,[vgascroll]
	LES     BX,[scradd]             ; ES: BX = A000:FD00
	ADD     BH,[videomode]
	MOV     DI,SEG ScrAdConv
	MOV     FS,DI                   ; FS: ScrAdConv
	MOV     SI,[scroff]             ; SI: CPC addr
SRT_Loop1:
	PUSH    SI
	PUSH    CX
	MOVZX   CX,[crtcscrheight]
SRT_Loop2:
	MOV     DI,[FS:ESI*2+ScrAdConv]
	MOV     AL,[GS:SI]
	XLAT    [ES:0]
	ADD     DI,BP
	MOV     [ES:DI],AL
	MOV     DI,[FS:ESI*2+ScrAdConv+2]
	MOV     AL,[GS:SI+1]
	XLAT    [ES:0]
	ADD     DI,BP
	MOV     [ES:DI],AL

	MOVZX   AX,[crtcscrwidth]
	ADD     AX,AX
	MOV     DI,SI
	ADD     SI,AX
	AND     SI,7ffh
	AND     DI,3800h
	ADD     SI,DI

	LOOP    SRT_Loop2
	POP     CX
	POP     SI
	ADD     SI,800h
	AND     SI,3fffh
	LOOP    SRT_Loop1
	POP     GS
SCRT_End:
	POP     ES
	POP     DS
	POPAW
	RET

ScrollDn:
	CMP     [useVGAroll],0
	JE      SCDN_Conventional
	PUSHAW
	MOVZX   AX,[BYTE PTR CRTCRegs+9]
	INC     AX
	MOVZX   CX,[crtcscrwidth]
	ADD     CX,CX
	MUL     CX
	ADD     [vgascroll],AX

	CALL    SetNewScrBase
	MOV     CX,AX
	MOV     SI,[scrbase]
	SHR     SI,14
	MOV     SI,[ESI*2+crtcvgaoff]
	ADD     SI,[vgascroll]
	MOVZX   BX,[crtcscrheight]
	DEC     BX
	MUL     BX
	ADD     SI,AX
	MOV     DX,SI
	ADD     DX,CX
	PUSH    DS
	PUSH    ES
	CALL    RedrawScreenPart
	POP     ES
	POP     DS
	POPAW
	RET
SCDN_Conventional:
	PUSHAW
	PUSH    DS
	POP     FS
	PUSH    DS
	PUSH    ES
	MOVZX   AX,[BYTE PTR CRTCRegs+9]
	INC     AX
	MOVZX   CX,[crtcscrwidth]
	ADD     CX,CX
	MUL     CX
	MOV     BX,AX                   ; BX: character line length (VGA)
	MOVZX   CX,[crtcscrheight]
	MUL     CX
	SUB     AX,BX
	MOV     CX,AX
	MOV     SI,BX

	MOV     DI,[scrbase]
	SHR     DI,14
	MOV     DI,[EDI*2+crtcvgaoff]
	ADD     DI,[vgascroll]
	ADD     SI,DI

	MOV     AX,0A000h
	MOV     DS,AX
	MOV     ES,AX

	REP     MOVSB
	MOV     DX,SI
	MOV     SI,DI

	MOV     AX,DGROUP
	MOV     DS,AX
	POP     ES
	PUSH    ES
	CALL    RedrawScreenPart

	POP     ES
	POP     DS
	POPAW
	RET

ScrollUp:
	CMP     [useVGAroll],0
	JE      SCUP_Conventional
	PUSHAW
	MOVZX   AX,[BYTE PTR CRTCRegs+9]
	INC     AX
	MOVZX   CX,[crtcscrwidth]
	ADD     CX,CX
	MUL     CX
	SUB     [vgascroll],AX

	CALL    SetNewScrBase
	MOV     SI,[scrbase]
	SHR     SI,14
	MOV     SI,[ESI*2+crtcvgaoff]
	ADD     SI,[vgascroll]
	MOV     DX,SI
	ADD     DX,AX
	PUSH    DS
	PUSH    ES
	CALL    RedrawScreenPart
	POP     ES
	POP     DS
	POPAW
	RET
SCUP_Conventional:
	PUSHAW
	PUSH    DS
	POP     FS
	PUSH    DS
	PUSH    ES
	MOVZX   AX,[BYTE PTR CRTCRegs+9]
	INC     AX
	MOVZX   CX,[crtcscrwidth]
	ADD     CX,CX
	MUL     CX
	MOV     BX,AX                   ; bx one character line height
	MOVZX   CX,[crtcscrheight]
	MUL     CX

	MOV     SI,AX
	DEC     SI
	SUB     SI,BX
	MOV     CX,AX
	SUB     CX,BX

	MOV     DI,[scrbase]
	SHR     DI,14
	MOV     DI,[EDI*2+crtcvgaoff]
	ADD     DI,[vgascroll]
	PUSH    DI
	ADD     SI,DI
	ADD     DI,AX
	DEC     DI

	MOV     AX,0A000h
	MOV     DS,AX
	MOV     ES,AX

	STD
	REP     MOVSB
	CLD
	POP     SI
	MOV     DX,SI
	ADD     DX,BX

	MOV     AX,DGROUP
	MOV     DS,AX
	POP     ES
	PUSH    ES
	CALL    RedrawScreenPart

	POP     ES
	POP     DS
	POPAW
	RET

RedrawScreenPart:                       ; in: SI VGA start off to be redrawn
	MOV     BP,SEG ScrAdList        ;     DX end offset to be redrawn
	MOV     FS,BP
	SUB     SI,[vgascroll]
	MOV     BP,ES
	MOV     DI,[scrbase]
	SHR     DI,4
	ADD     BP,DI
	LES     BX,[scradd]
	ADD     BH,[videomode]
	MOV     DI,[scrbase]
	SHR     DI,14
	MOV     DI,[EDI*2+crtcvgaoff]
	MOV     DS,BP
	MOV     BP,OFFSET ScrAdList
RDSP_SeekListPosition:
	MOV     AX,[FS:BP+2]
	ADD     BP,4
	ADD     DI,AX
	CMP     DI,SI
	JC      RDSP_SeekListPosition
	SUB     DI,AX
	MOV     CX,DI
	SUB     BP,4
	ADD     DI,[SS:vgascroll]
	SUB     DX,[SS:vgascroll]

RDSP_Loop:
	CMP     CX,DX
	JNC     RDSP_End
	MOV     SI,[FS:BP]
	MOV     AX,[FS:BP+2]
	ADD     CX,AX
	ADD     AX,AX
	ADD     AX,AX                   ; LODSB /XLAT ES/STOSB = 4 bytes
	NEG     AX
	ADD     BP,4
	ADD     AX,OFFSET RDSP_ULZero
	JMP     AX

RDSP_End:
	RET

RDSP_UnfoldedLoop:
	argh5
	argh5
	argh5
	argh5
	argh5
	argh5
	argh5
	argh5
	argh5
	argh5
	argh5
	argh5
	argh5
	argh5
	argh5
	argh5
	argh5
	argh5
	argh5
	argh5
	argh5
	argh5
	argh5
	argh5
	argh5
	argh5
	argh5
	argh5
	argh5
	argh5
	argh5
	argh5
	argh1
RDSP_ULByteCnt:
	argh1
RDSP_ULZero:
	JMP     RDSP_Loop

InitScroff:
	MOV     [crtccareful],0
	PUSHAD
	MOV     BX,SEG Scrofftab         ; BX       = ScrOffTab (A0)
	MOV     FS,BX
	MOV     BX,OFFSET Scrofftab      ; CH outer = D7 (7)
	MOV     CH,[BYTE PTR CRTCregs+9]
	INC     CH
	MOV     AX,0       ; line offset ; AX outer = D0
	CMP     [BYTE PTR CRTCregs+1],0
	JE      ISC_AllNull
ISC_Loop1:
	MOV     DX,AX                    ; DX       = D1
	MOV     CL,[BYTE PTR CRTCregs+6]                    ; CL outer = D6 (24)
	MOV     SI,2048                  ; SI       = D4 (2048)
	CMP     CL,0
	JNE     ISC_Loop2
	MOV     CL,1
ISC_Loop2:
	PUSH    CX
	MOVZX   BP,[BYTE PTR CRTCregs+1]
	ADD     BP,BP
	SUB     SI,BP
	JNC     ISC_NoCarryInSI
	NEG     SI
	SUB     BP,SI
	XOR     SI,SI
	MOV     [crtccareful],1
ISC_NoCarryInSI:
	OR      BP,BP
	JZ      ISC_BPIsZero
	MOV     CX,DX                    ; CX       = D2
ISC_Loop3:
	CMP     CX,32000
	JC      ISC_CX_OK
	MOV     [WORD PTR FS:BX],32768
	JMP     ISC_CX_CONT
ISC_CX_OK:
	CMP     BX,32768
	JNC     ISC_OopsRet
	MOV     [FS:BX],CX
ISC_CX_CONT:
	ADD     BX,2
	INC     CX
	DEC     BP
	JNE     ISC_Loop3
ISC_BPIsZero:
	MOVZX   CX,[BYTE PTR CRTCregs+9]
	INC     CX
	PUSH    AX
	MOVZX   AX,[crtcscrwidth]
	ADD     AX,AX
ISC_IncDXLoop:
	ADD     DX,AX
	LOOP    ISC_IncDXLoop
	POP     AX
	POP     CX
	DEC     CL
	JNE     ISC_Loop2
	OR      SI,SI
	JZ      ISC_invisiOK
	JS      ISC_invisiOK
ISC_Loop4:
	CMP     BX,32768
	JNC     ISC_OopsRet2
	MOV     [WORD PTR FS:BX],32768 ; invisible bytes
	ADD     BX,2
	DEC     SI
	JNE     ISC_Loop4
ISC_invisiOK:
	PUSH    CX
	MOVZX   CX,[crtcscrwidth]
	ADD     AX,CX
	ADD     AX,CX
	POP     CX
	DEC     CH
	JNE     ISC_Loop1
ISC_Loop5:
	CMP     BX,32768
	JNC     ISC_Ret
	MOV     [WORD PTR FS:BX],32768 ; invisible bytes
	ADD     BX,2
	JMP     ISC_Loop5
ISC_OopsRet:
	POP     CX
ISC_Ret:
	POPAD
	CALL    GenScrAdConv
	RET

ISC_OopsRet2:
	JMP     ISC_Ret
	RET

ISC_AllNull:
	MOV     [WORD PTR FS:BX],32768
	INC     BX
	INC     BX
	INC     AX
	CMP     AX,16384
	JNE     ISC_AllNull
	POPAD
	CALL    GenScrAdConv
	RET

GenScrAdConv:
	PUSHAW
	PUSH    ES
	PUSH    DS
	MOV     AX,[scroff]
	NEG     AX
	AND     AX,07feh
	MOV     BX,AX
	ADD     BX,BX
	SHR     AX,1
	PUSH    SEG ScroffTab
	POP     DS
	PUSH    SEG ScrAdConv
	POP     ES
	MOV     CX,8
	MOV     SI,OFFSET ScroffTab
	MOV     DI,OFFSET ScrAdConv
GSAC_LoopA:
	PUSH    CX
	PUSH    SI
	PUSH    SI
	ADD     SI,BX
	MOV     CX,400h
	SUB     CX,AX
	REP     MOVSD
	POP     SI
	MOV     CX,AX
	REP     MOVSD
	POP     SI
	ADD     SI,1000h
	POP     CX
	LOOP    GSAC_LoopA

	MOV     CX,DGROUP
	MOV     DS,CX
	MOV     CX,SEG ScrAdList
	MOV     ES,CX
	MOV     DI,OFFSET ScrAdList

	MOV     SI,[scroff]             ; offset
	MOVZX   DX,[crtcscrwidth]
	ADD     DX,DX
	CMP     DX,0
	JE      GSAC_End
	MOVZX   BP,[crtcscrheight]
	MOV     CX,BP
	CMP     CX,0
	JE      GSAC_End
	MOV     BL,[BYTE PTR CRTCregs+9]
GSAC_CalcLines:
	ADD     CX,BP
	DEC     BL
	JNE     GSAC_CalcLines

	MOV     BX,0                    ; char scan line
	MOV     BP,0                    ; char line offs

GSAC_Loop2:
	MOV     AX,SI
	ADD     AX,BP
	STOSW
	MOV     AX,800h
	SUB     AX,SI
	CMP     AX,DX
	JNC     GSAC_NoCarry
	STOSW
	NEG     AX
	ADD     AX,DX
	XCHG    AX,BP
	STOSW
	XCHG    AX,BP
	STOSW
	JMP     GSAC_FinishLine
GSAC_NoCarry:
	MOV     AX,DX
	STOSW
GSAC_FinishLine:
	CMP     BL,[BYTE PTR CRTCregs+9]
	JE      GSAC_NewRasterChar
	INC     BX
	ADD     BP,800h
	JMP     GSAC_Loop2End
GSAC_NewRasterChar:
	ADD     SI,DX
	AND     SI,7feh
	XOR     BX,BX
	XOR     BP,BP
GSAC_Loop2End:
	LOOP    GSAC_Loop2
GSAC_End:

	MOV     [DWORD PTR ES:DI],0ffffffffh
	CMP     [crtccareful],1
	JNE     GSAC_Ret
	MOV     DI,OFFSET ScrAdList+2
	MOV     DX,0
	MOV     CX,4
GSAC_CarefulLoop:
	MOV     AX,[ES:DI]
	OR      AX,AX
	JS      GSAC_CarefulEnd
	ADD     DX,AX
	CMP     DX,4000h
	JNC     GSAC_CarefulEnd
	ADD     DI,CX
	JMP     GSAC_CarefulLoop
GSAC_CarefulEnd:
	SUB     DI,2
	MOV     [DWORD PTR ES:DI],0ffffffffh
GSAC_Ret:
	POP     DS
	POP     ES
	POPAW
	RET

GenByteMode:
	CMP     [multimodeon],0
	JNE     GBYM_NotSoSimple
	PUSHAW
	PUSH    ES
	PUSH    SEG ByteMode
	POP     ES
	MOV     DI,OFFSET ByteMode
	MOV     CX,2000h
	XOR     EAX,EAX
	MOV     AH,[videomode]
	ROL     EAX,16
	MOV     AH,[videomode]
	REP     STOSD
	XOR     EAX,EAX
	POP     ES
	POPAW
	RET
GBYM_NotSoSimple:
	CMP     [crtcscrwidth],0
	JE      GBYM_Ret
	CMP     [crtcscrheight],0
	JE      GBYM_Ret
	PUSHAW
	PUSH    ES
	MOV     DH,[BYTE PTR CRTCregs+9]
	INC     DH                        ; DH = MaxScanLine
	MOV     AL,[crtcscrheight]
	MUL     DH
	MOV     SI,AX                     ; SI = screen height
	MOVZX   AX,[BYTE PTR CRTCregs+4]
	SUB     AL,[BYTE PTR CRTCregs+7]
	MUL     DH
	MOV     BX,AX
	MOVZX   AX,[BYTE PTR CRTCregs+5]
	AND     AX,1fh
	ADD     BX,AX                     ; BX = first line in scrmem
	ADD     BX,5
	MOV     DL,52
	MOV     DI,OFFSET ByteMode+7ffeh
	PUSH    SEG ByteMode
	POP     ES
	MOV     CX,3fffh
	MOV     SI,[scroff]
	STD
GBYM_Loop:
	MOV     AX,CX
	SUB     AX,SI
	AND     AX,07feh
	PUSH    DX
	MOV     DL,[crtcscrwidth]
	ADD     DL,DL
	DIV     DL
	POP     DX
	MUL     DH

	MOV     BP,CX
	SHR     BP,11
	ADD     AX,BP
	ADD     AX,BX
	DIV     DL
	XOR     AH,AH
	MOV     AH,[EAX+OFFSET modezones]
	XOR     AL,AL
	STOSW
	DEC     CX
	JNS     GBYM_Loop
	CLD
	POP     ES
	POPAW
GBYM_Ret:
	RET

outp:   BT      AX,14
	JC      OUT_noCRTC
	BT      AX,9
	JC      OUT_End
	BT      AX,8
	JC      OUT_CRTC_wr
	CALL    outCRTCreg
	JMP     OUT_End
OUT_CRTC_wr:
	CALL    outCRTCwr
	JMP     OUT_End
OUT_noCRTC:

	BT      AX,11
	JC      OUT_noPIO
	PUSH    AX
	AND     AH,3
	CMP     AH,0
	JNE     OUT_NotPIOa
	CALL    out8255a
	JMP     OUT_PIOend
OUT_NotPIOa:
	CMP     AH,1
	JNE     OUT_NotPIOb
	CALL    out8255b
	JMP     OUT_PIOend
OUT_NotPIOb:
	CMP     AH,2
	JNE     OUT_NotPIOc
	CALL    out8255c
	JMP     OUT_PIOend
OUT_NotPIOc:
	CALL    out8255control
OUT_PIOEnd:
	POP     AX
	JMP     OUT_noGary
OUT_noPIO:

	BT      AX,15
	JC      OUT_noGary
	PUSH    AX
	CALL    outga
	POP     AX
OUT_noGary:

	BT      AX,10
	JC      OUT_noDiskStuff
	PUSH    AX
	BT      AX,8
	JC      OUT_Disk_cmd
	CALL    outFA
	JMP     OUT_Disk_End
OUT_Disk_Cmd:
	CALL    outFB
OUT_Disk_End:
	POP     AX
OUT_NoDiskStuff:

	BT      AX,13
	JC      OUT_noROMnum
	PUSH    AX
	CALL    outROMnum
	POP     AX
OUT_noROMnum:
	BT      AX,12
	JC      OUT_noprinter
	PUSH    AX
	CALL    outPrinter
	POP     AX
OUT_noprinter:
OUT_end:
	RET

outROMnum:
	MOV     AH,0
	CMP     AX,[romnum]
	JE      outROM_old
	MOV     [romnum],AX
	CALL    RethinkMemMap
outROM_old:
	RET

outCRTCreg:
	MOV     [CRTCregnum],AL
	RET

outCRTCwr:
	MOVZX   BP,[BYTE PTR CRTCregnum]
	MOV     [BYTE PTR BP+CRTCregs],AL
	CMP     BP,1
	JE      CRTC_NewWidth
	CMP     BP,6
	JE      CRTC_NewHeight
	CMP     BP,7
	JE      CRTC_NewSyncPos
	CMP     BP,9
	JE      CRTC_NewMaxSLin
	CMP     BP,12
	JC      CRTC_nonewparms
	CMP     BP,14
	JNC     CRTC_nonewparms
	MOV     BP,[CRTCregs+12]
	ROL     BP,8
	ADD     BP,BP
	MOV     AX,BP
	ADD     BP,BP
	AND     AX,7FEh
	AND     BP,0C000h

	CMP     AX,[scroff]
	JNE     CRTC_setintcount
	CMP     BP,[scrbase]
	JE      CRTC_nonewparms
	JMP     CRTC_setintcount
CRTC_NewHeight:
	CMP     AL,[crtcscrheight]
	JE      CRTC_nonewparms
	JMP     CRTC_setintcount

CRTC_NewWidth:
	CMP     AL,[crtcscrwidth]
	JE      CRTC_nonewparms
	JMP     CRTC_setintcount
CRTC_setintcount:
	MOV     [ReDrawCount],20
	OR      [intflag],1
CRTC_nonewparms:
	RET
CRTC_NewSyncPos:
	CMP     [crtcsyncpos],AL
	JE      CRTC_nonewparms
	MOV     [crtcsyncpos],AL
	MOV     [ReDrawCount],20
	OR      [intflag],1
	MOV     [spcrtcflag],1
	RET
CRTC_NewMaxSLin:
	CMP     [crtcmaxslin],AL
	JE      CRTC_nonewparms
	MOV     [crtcmaxslin],AL
	MOV     [ReDrawCount],20
	OR      [intflag],1
	MOV     [spcrtcflag],2
	RET

out8255a:
	BT      [WORD PTR control8255],4
	JC      o8255aend
	MOV     [port8255a],AL
	MOV     sFree,[WORD PTR port8255c]
	SHR     sFree,6
	AND     sFree,3
	JE      inactivepsg
	CMP     sFree,3
	JE      latchpsg
	CMP     sFree,2
	JE      writepsg
o8255aend:
	RET

out8255b:
	MOV     [port8255b],AL
	RET

out8255c:
	PUSH    DX
	PUSH    AX
	XOR     DL,DL
	BT      [WORD PTR control8255],0
	JC      o8255clin
	OR      DL,15
o8255clin:
	BT      [WORD PTR control8255],3
	JC      o8255chin
	OR      DL,240
o8255chin:
	OR      [port8255c],DL
	XOR     [port8255c],DL
	AND     AL,DL
	OR      [port8255c],AL
	MOV     AH,[port8255c]
	SHR     AH,4
	AND     AH,2
	MOV     BP,DX
	CLI
	MOV     DX,61h
	IN      AL,DX
	AND     AL,0fch
	OR      AL,AH
	OUT     DX,AL
	STI

	POP     AX
	POP     DX
	AND     BP,0C0h
	JZ      inactivepsg
	MOV     sFree,AX
	SHR     sFree,6
	AND     sFree,3
	JE      inactivepsg
	CMP     sFree,3
	JE      latchpsg
	CMP     sFree,2
	JE      writepsg
	RET

out8255control:
	BT      AX,7
	JNC     out8255control_SF
	MOV     [control8255],AL
	CALL    UpdatePIOA
	CALL    UpdatePIOC
	RET
out8255control_SF:
	BT      AX,0
	JC      o8255cSFset
	PUSH    AX
	SHR     AL,1
	AND     AX,7
	XOR     BP,BP
	TEST    AX,4                      ; check whether that half is
	JZ      o8255cSFcBPok             ; in output mode
	MOV     BP,3
o8255cSFcBPok:
	BT      [WORD PTR control8255],BP
	JC      o8255cSFnores
	BTR     [WORD PTR port8255c],AX
	MOV     AL,[port8255c]
	CALL    out8255c
o8255cSFnores:
	POP     AX
	RET
o8255cSFset:
	PUSH    AX
	SHR     AL,1
	AND     AX,7
	XOR     BP,BP
	TEST    AX,4                      ; check whether that half is
	JZ      o8255cSFsBPok             ; in output mode
	MOV     BP,3
o8255cSFsBPok: ; don't you love cryptic identifiers?
	BT      [WORD PTR control8255],BP
	JC      o8255cSFnoset
	BTS     [WORD PTR port8255c],AX
	MOV     AL,[port8255c]
	CALL    out8255c
o8255cSFnoset:
	POP     AX
	RET

inactivepsg:
	RET

writepsg:
	MOV     BP,[WORD PTR psgregnum]
	AND     BP,00Fh
	MOV     AL,[port8255a]
	MOV     [BP+OFFSET psgregs],AL
	MOV     [BYTE PTR BP+OFFSET psgregmod],255
	CALL    DoSound
	CALL    UpdatePIOA
	RET

latchpsg:
	MOV     AL,[port8255a]
	AND     AL,15
	MOV     [psgregnum],AL
	CALL    UpdatePIOA
	RET

outga:  MOV     BP,AX
	SHR     BP,6
	AND     BP,3
	AND     AL,3Fh
	CMP     [BYTE PTR BP+rgsgarr],AL
	JE      outga_end
	MOV     [BYTE PTR (BP+rgsgarr)],AL
	CMP     BP,2
	JNE     outga1
	CMP     AL,[memstate]
	JE      outga_end
	MOV     [memstate],AL
	AND     [memstate],0Efh
	AND     AL,10h
	JZ      outga_nocli
  ;      MOV     AX,[intspeed]
  ;      MOV     [intcount],AX
	MOV     [intreq],0
outga_nocli:
	CALL    RethinkMemMap
	InitPCSeg
	CALL    RethinkMode
	JMP     outga_end
outga1: CMP     BP,1
	JE      ga_setcol
	CMP     BP,0
	JE      outga_colreg
	CMP     BP,3
	JE      RethinkRamState
	JMP     outga_end
outga_colreg:
	MOV     [BYTE PTR rgsgarr+1],255
outga_end:
	RET

ga_setcol:
	PUSH    AX
	PUSH    EBX
	PUSH    DX
	MOV     AL,[BYTE PTR rgsgarr]
	CMP     AL,17
	JNC     ga_sc_end
	AND     AX,1Fh         ; *?*
	MOV     BL,[BYTE PTR (rgsgarr+1)]
	AND     BX,01Fh
	MOV     [EAX+OFFSET garrcols],BL
	CMP     [colmode],0
	JE      ga_normcols
	MOV     EBX,[EBX*4+ColorTabA]
	JMP     ga_colsok
ga_normcols:
	MOV     EBX,[EBX*4+ColorTab]
ga_colsok:
	CMP     [EAX*4+OFFSET CMap],EBX
	JE      ga_sc_end
	MOV     [EAX*4+OFFSET CMap],EBX

ga_sc_norm:
	CLI
	MOV     DX,3c8h
	OUT     DX,AL
	MOV     DX,3c9h
	ROR     EBX,8
	MOV     AL,BH
	OUT     DX,AL
	ROL     EBX,8
	MOV     AL,BH
	OUT     DX,AL
	MOV     AL,BL
	OUT     DX,AL
	STI
ga_sc_end:
	POP     DX
	POP     EBX
	POP     AX
	RET

SetColors:
	PUSH    AX
	PUSH    EBX
	PUSH    DX
	XOR     EAX,EAX
	XOR     EBX,EBX

	MOV     AX,16
SCL_Loop:
	PUSH    AX
	MOV     BL,[EAX+OFFSET garrcols]
	AND     BX,01Fh
	CMP     [colmode],0
	JE      SCL_normcols
	MOV     EBX,[EBX*4+ColorTabA]
	JMP     SCL_colsok
SCL_normcols:
	MOV     EBX,[EBX*4+ColorTab]
SCL_colsok:
	MOV     [EAX*4+OFFSET CMap],EBX
	CLI
	MOV     DX,3c8h
	OUT     DX,AL
	MOV     DX,3c9h
	ROR     EBX,8
	MOV     AL,BH
	OUT     DX,AL
	ROL     EBX,8
	MOV     AL,BH
	OUT     DX,AL
	MOV     AL,BL
	OUT     DX,AL
	STI
	XOR     EBX,EBX
	POP     AX
	DEC     AX
	JNS     SCL_Loop

	POP     DX
	POP     EBX
	POP     AX
	RET

SetEGARegs:
	MOV     BX,0
SCL_EGAloop:
	MOV     AX,1000h
	PUSH    BX
	CALL    Video
	POP     BX
	ADD     BX,101h
	CMP     BH,10h
	JNE     SCL_EGAloop
	MOV     AX,1001h
	CALL    Video
	RET

SetNewScrBase:
	CMP     [vgascroll],0C001h
	JC      SNSB_AllOK
	MOV     [vgascroll],06000h
	MOV     [SNSBRedraw],1
SNSB_AllOK:
	PUSH    BX
	PUSH    AX
	PUSH    DX
	CLI
	MOV     BX,[scrbase]
	SHR     BX,14
	MOV     BX,[WORD PTR EBX*2+crtcvgaoff]
	CMP     [xchgdbuf],0
	JE      SNSB_DontExchange
	CMP     [lastdbuf],24
	JC      SNSB_DontExchange
	XOR     BX,4000h
SNSB_DontExchange:
	ADD     BX,[vgascroll]
	MOV     DX,3d4h
	MOV     AL,0ch
	OUT     DX,AL
	INC     DX
	MOV     AL,BH
	OUT     DX,AL
	DEC     DX
	MOV     AL,0dh
	OUT     DX,AL
	MOV     AL,BL
	INC     DX
	OUT     DX,AL
	STI
	MOV     BX,SColOff
	ADD     BX,[vgascroll]
	MOV     [WORD PTR scradd],BX
	POP     DX
	POP     AX
	POP     BX
	CALL    GenLatchTables
	CMP     [SNSBRedraw],0
	JE      SNSB_Ret
	MOV     [SNSBRedraw],0
	CALL    RedrawScreen
SNSB_Ret:
	RET

SetPCsCRTC:
	MOV     [CRTCkyfo],1
	PUSHAW
	CMP     [PCRTC_MODE],0          ; Mode = 50Hz?
	JNE     SPCC_HeightL25
	CMP     [crtcscrwidth],41
	JC      SPCC_WidthL40
	CALL    OpenLongScr
	CALL    SetNewScrBase
	CALL    GenLatchTables
	JMP     SPCC_ScrOpen
SPCC_WidthL40:
	MOV     AL,[crtcscrheight]
	MOV     AH,[crtcmaxslin]
	INC     AH
	MUL     AH
	CMP     AX,201
	JC      SPCC_HeightL25
	CALL    OpenLongScr
	CALL    SetNewScrBase
	CALL    GenLatchTables
	JMP     SPCC_ScrOpen
SPCC_HeightL25:
	CALL    OpenScr
	CALL    SetNewScrBase
	CALL    GenLatchTables
SPCC_ScrOpen:

	MOV     AL,[crtcscrwidth]
	CMP     AL,0
	JE      SPCC_WidthOK
	CLI
	MOV     DX,3d4h
	PUSH    AX
	MOV     AL,13h
	OUT     DX,AL
	INC     DX
	IN      AL,DX
	POP     AX
	OUT     DX,AL
	STI

	CMP     AL,50
	JNC     SPCC_WidthOK

	ADD     AL,AL
	DEC     AL
	DEC     DX
	PUSH    AX
	MOV     AL,1
	CLI
	OUT     DX,AL
	INC     DX
	IN      AL,DX
	POP     AX
	OUT     DX,AL
	STI
SPCC_WidthOK:
	CMP     [PCRTC_MODE],0
	JE      SPCC_NoMode0
	MOV     DX,3d4h
	MOV     AL,10h
	CLI
	OUT     DX,AL
	PUSH    CX
	PUSH    DX
	MOV     CL,[BYTE PTR CRTCregs+9]
	INC     CL
	MOV     AL,[BYTE PTR CRTCregs+7]
	MUL     CL
	ADD     AX,AX
	ADD     AX,3
	MOV     [PCRTC_VR1],AX
	POP     DX
	INC     DX
	OUT     DX,AL
	DEC     DX
	MOV     AL,7
	OUT     DX,AL
	INC     DX
	IN      AL,DX
	ADD     AH,AH
	ADD     AH,AH
	MOV     CL,AH
	SHL     CL,4
	AND     CL,80h
	AND     AH,4
	AND     AL,07bh
	OR      AL,AH
	OR      AL,CL
	OUT     DX,AL
	STI
	POP     CX

	MOV     DX,3d4h
	MOV     AL,15h
	CLI
	OUT     DX,AL
	INC     DX
	MOV     AX,[PCRTC_VR1]
	SUB     AX,30
	OUT     DX,AL

	DEC     DX
	MOV     AL,7
	OUT     DX,AL
	INC     DX
	IN      AL,DX
	ADD     AH,AH
	ADD     AH,AH
	ADD     AH,AH
	PUSH    AX
	AND     AH,8h
	AND     AL,0F7h
	OR      AL,AH
	OUT     DX,AL
	STI
	DEC     DX
	MOV     AL,9h
	CLI
	OUT     DX,AL
	INC     DX
	POP     AX
	IN      AL,DX
	AND     AL,0DFh
	ADD     AH,AH
	AND     AH,20h
	OR      AL,AH
	OUT     DX,AL
	STI
SPCC_NoMode0:
	MOV     AL,[crtcscrheight]
	CMP     AL,0
	JE      SPCC_HeightOK
	PUSH    AX
	MOV     AL,12h
	MOV     DX,3d4h
	CLI
	OUT     DX,AL
	POP     AX

	PUSH    BX
	MOVZX   BX,[BYTE PTR CRTCregs+9]
	AND     BL,7
	INC     BL
	PUSH    DX
	XOR     AH,AH
	MUL     BX
	CMP     AX,100h
	JC      SPCC_HeightLess256
	MOV     AX,100h
SPCC_HeightLess256:
	POP     DX
	POP     BX
	CMP     [doublelinmode],0
	JE      SPCC_DontDouble
	ADD     AX,AX
SPCC_DontDouble:
	DEC     AX
	MOV     DX,3d5h
	OUT     DX,AL
	STI

	PUSH    AX
	MOV     AL,7
	MOV     DX,3d4h
	CLI
	OUT     DX,AL
	POP     AX

	MOV     DX,3d5h
	IN      AL,DX
	AND     AL,0bdh

	ADD     AH,AH
	AND     AH,2
	OR      AL,AH

	OUT     DX,AL
SPCC_HeightOK:
SPCC_End:
	POPAW
	STI
	MOV     [CRTCkyfo],0
	RET

inp:    CMP     AH,0F4h
	JE      inpioA
	CMP     AH,0F5h
	JE      inpioB
	CMP     AH,0F6h
	JE      inpioC
	CMP     AH,0FBh
	JE      inpFB
	RET

UpdatePIOA:
	BT      [WORD PTR control8255],4
	JNC     UPIA_Ret
	BT      [WORD PTR port8255c],7
	JC      UPIA_Ret
	PUSH    AX
	CALL    readpsg
	MOV     [port8255a],AL
	POP     AX
UPIA_Ret:
	RET

inpioA: ;MOV     AL,[port8255c]
	;BT      AX,7
	;JNC     readpsg
	CALL    UpdatePIOA
	MOV     AL,[port8255a]
	RET

readpsg:
	CMP     [psgregnum],14
	JE      readpsgext
	MOVZX   BP,[psgregnum]
	MOV     AL,[BYTE PTR BP+psgregs]
	RET

readpsgext:
	PUSH    BX                           ; *?*
	MOV     BL,[port8255c]
	AND     BX,15
	MOV     AL,[BX+KeyMatrix]
	CMP     BL,9
	JNE     rpex_nojoy0
	MOV     BH,AL
	AND     BH,12
	JNE     rpex_jhok0
	OR      AL,12
rpex_jhok0:
	MOV     BH,AL
	AND     BH,3
	JNE     rpex_jvok0
	OR      AL,3
rpex_jvok0:
rpex_nojoy0:
	CMP     BL,6
	JNE     rpex_nojoy1
	MOV     BH,AL
	AND     BH,12
	JNE     rpex_jhok1
	OR      AL,12
rpex_jhok1:
	MOV     BH,AL
	AND     BH,3
	JNE     rpex_jvok1
	OR      AL,3
rpex_jvok1:
rpex_nojoy1:
	POP     BX
	RET

inpioB: MOV     AL,01Eh     ; Firmenname: AMSTRAD, Freq: 50HZ
	OR      AL,[BYTE PTR ffly]
	PUSH    AX
	CMP     [clearff],0
	JE      inpioB_end
	MOV     AX,[ffly_dec]
	OR      AX,AX
	JE      inpiob_end
	DEC     AX
	MOV     [ffly_dec],AX
	JNE     inpiob_end
	MOV     [ffly],0
inpiob_end:
	POP     AX
	OR      AL,[prtstate]
	RET

UpdatePIOC:
	MOV     AL,[port8255c]
	BT      [WORD PTR control8255],0
	JC      inpioc_lowok
	AND     AL,240
	OR      AL,0
inpioc_lowok:
	BT      [WORD PTR control8255],3
	JC      inpioc_hiok
	AND     AL,15
	OR      AL,0
inpioc_hiok:
	MOV     [port8255c],AL
	RET
inpioC:
	MOV     AL,[port8255c]
	RET

RethinkMode:
	PUSHAW
	MOV     BP,[WORD PTR sysstat]
	AND     BP,3
	MOV     AL,[MoTable+BP]
	CMP     [permitmm],0
	JNE     RTM_MultiModePoss
	CMP     AL,[videomode]
	JE      RTM_End
	MOV     [RedrawCount],1
	OR      [intflag],1
	MOV     [newvidmode],AL
	JMP     RTM_End
RTM_MultiModePoss:
	CMP     [multimodeon],0
	JE      RTM_NoMultiModeOn
	CMP     AL,[videomode]
	JE      RTM_End
	MOV     [videomode],AL
	MOV     [newvidmode],AL
	MOVZX   AX,[BYTE PTR ffcount]
	MOVZX   AX,[EAX+OFFSET modeffoff]
	MOV     DL,[EAX+OFFSET modezones]
	CMP     [modezochgd],0
	JNE     RTM_ModeZonesChgd
	CMP     [mmintsignal],0
	JNE     RTM_ModeZonesChgd
	CMP     [mozoctdn],0
	JNE     RTM_ModeZonesChgd
	CMP     [videomode],DL
	JE      RTM_End
RTM_ModeZonesChgd:
	MOV     [modezochgd],0                  ; acknowledged
	MOV     DL,[videomode]
	MOV     [EAX+modezones],DL
	MOV     AX,[WORD PTR modezones]
	CMP     AX,[WORD PTR oldmzones]
	JNZ     RTM_DefinitelyChanged
	MOV     AX,[WORD PTR modezones+2]
	CMP     AX,[WORD PTR oldmzones+2]
	JNZ     RTM_DefinitelyChanged
	MOV     AX,[WORD PTR modezones+4]
	CMP     AX,[WORD PTR oldmzones+4]
	JNZ     RTM_DefinitelyChanged
	MOV     [mozoctdn],0
	MOV     [mmintsignal],0
	JMP     RTM_End
RTM_DefinitelyChanged:
	CMP     [mmintsignal],0
	JE      RTM_ActivateInt
	MOV     [mmintsignal],0
	MOV     [RedrawCount],20
	OR      [intflag],1
	OR      [multimodeon],40h
	JMP     RTM_End
RTM_ActivateInt:
	CMP     [mozoctdn],0
	JNE     RTM_End
	MOV     [mozoctdn],18
	JMP     RTM_End
RTM_NoMultiModeOn:
	CMP     AL,[newvidmode]
	JE      RTM_End
	CMP     [lastmodechg],6
	JC      RTM_SwitchToMulti
	MOV     [newvidmode],AL
	MOV     [lastmodechg],0
	JMP     RTM_End
RTM_SwitchToMulti:
	MOV     AH,[newvidmode]
	MOV     [modezones],AH
	MOV     [modezones+1],AH
	MOV     [modezones+2],AH
	MOV     [modezones+3],AH
	MOV     [modezones+4],AH
	MOV     [modezones+5],AH
	MOV     [multimodeon],41h
	OR      [intflag],1
	MOV     [videomode],AL
	MOV     sFree,[ffcount]
	MOVZX   sFree,[modeffoff+sFree]
	MOV     [modezones+sFree],AL    ; could be improved
	MOV     [RedrawCount],1
RTM_End:
	POPAW
	RET

OpenScr:
	CMP     [scrtype],1
	JE      OS_DontReopen
	CMP     [scrtype],2
	JNE     OS_OpenIt
	CMP     [PCRTC_MODE],0
	JNE     OS_DontReopen
OS_OpenIt:
	MOV     [scrtype],1
	MOV     AX,0Eh
	CALL    Video
	MOV     [doublelinmode],1

	CLI
	MOV     DX,3ceh
	MOV     AL,6
	OUT     DX,AL
	INC     DX
	IN      AL,DX
	AND     AL,3
	OUT     DX,AL

	MOV     DX,3d4h
	MOV     AL,11h
	OUT     DX,AL
	INC     DX
	IN      AL,DX
	AND     AL,7fh
	OUT     DX,AL
	STI

	CALL    SetColors
	CALL    SetEGAregs
	CALL    GenLatchTables
	CALL    RedrawScreen
OS_DontReopen:
	CMP     [PCRTC_MODE],0
	JE      OS_Ret
	MOV     [scrtype],2
	PUSH    DX

	CLI
	MOV     DX,3d4h
	MOV     AL,6h
	OUT     DX,AL
	INC     DX
	MOV     AX,[PCRTC_VT1]
	OUT     DX,AL

	MOV     DX,3d4h
	MOV     AL,7h
	OUT     DX,AL
	INC     DX
	MOV     AL,0BAh
	OUT     DX,AL

	MOV     DX,3d4h
	MOV     AL,11h
	OUT     DX,AL
	INC     DX
	IN      AL,DX
	MOV     AH,AL
	AND     AH,0F0h
	AND     AL,00Fh
	SUB     AL,2
	JNC     OS_VREndOK
	XOR     AL,AL
OS_VREndOK:
	OR      AL,AH
	OUT     DX,AL

	MOV     DX,3d4h
	MOV     AL,0h
	OUT     DX,AL
	INC     DX
	MOV     AL,62h
	OUT     DX,AL

	MOV     DX,3d4h
	MOV     AL,16h
	OUT     DX,AL
	INC     DX
	MOV     AL,10h
	OUT     DX,AL

	POP     DX
OS_Ret:
	STI
	RET

OpenLongScr:
	CMP     [scrtype],3
	JE      OLS_Ret
	MOV     [scrtype],3
	MOV     AX,[lsmode]
	CALL    Video
	CALL    SetColors
	CALL    SetEGAregs
	CALL    GenLatchTables
	CALL    RedrawScreen

	MOV     DX,3d4h
	MOV     AL,11h
	OUT     DX,AL
	INC     DX
	IN      AL,DX
	AND     AL,7fh
	OUT     DX,AL

	MOV     AX,[doublelin]
	MOV     [doublelinmode],AX
	CMP     AX,0
	JE      OLS_Ret
	CLI
	MOV     DX,3d4h
	MOV     AL,9h
	OUT     DX,AL
	INC     DX
	IN      AL,DX
	OR      AL,80h
	OUT     DX,AL
OLS_Ret:
	STI
	RET

GenLatchTables:
	PUSHAW
	MOV     DX,03CEh
	MOV     AX,0            ; Latch 2 & 3 auf 0 setzen
	OUT     DX,AX
	MOV     AX,0001h
	OUT     DX,AX
	MOV     AX,0003h
	OUT     DX,AX     ; Funktionsauswahl: Bits ersetzen
	MOV     AX,0205h  ; Schreibmodus
	OUT     DX,AX

	MOV     AX,0A000h
	MOV     FS,AX
	MOV     SI,255
	MOV     BX,SI
	ADD     BX,[WORD PTR scradd]
GLAT_Loop0:
	MOV     CL,[SI+m0cols]
	MOV     AL,[FS:BX]
	MOV     AX,00F08h
	OUT     DX,AX     ; Bitmaske C0
	MOV     [FS:BX],CL
	MOV     AL,[FS:BX]
	SHR     CL,4
	MOV     AX,0F008h
	OUT     DX,AX
	MOV     [FS:BX],CL
	DEC     BX
	DEC     SI
	JNS     GLAT_Loop0

	MOV     DX,03CEh
	MOV     AX,0            ; Latch 2 & 3 auf 0 setzen
	OUT     DX,AX
	MOV     AX,0C01h
	OUT     DX,AX
	MOV     AX,0003h
	OUT     DX,AX     ; Funktionsauswahl: Bits ersetzen
	MOV     AX,0205h  ; Schreibmodus
	OUT     DX,AX

	MOV     SI,255
	MOV     BX,SI
	ADD     BX,[WORD PTR scradd]
	ADD     BX,256
GLAT_Loop1:
	MOV     CX,[WORD PTR ESI*2+m1cols]
	MOV     AL,[FS:BX]
	MOV     AX,03008h
	OUT     DX,AX     ; Bitmaske C0
	MOV     [FS:BX],CL

	MOV     AL,[FS:BX]
	SHR     CX,4
	MOV     AX,0C008h
	OUT     DX,AX
	MOV     [FS:BX],CL

	MOV     AL,[FS:BX]
	SHR     CX,4
	MOV     AX,00308h
	OUT     DX,AX
	MOV     [FS:BX],CL

	MOV     AL,[FS:BX]
	SHR     CX,4
	MOV     AX,00C08h
	OUT     DX,AX
	MOV     [FS:BX],CL

	DEC     BX
	DEC     SI
	JNS     GLAT_Loop1

	MOV     DX,03CEh
	MOV     AX,0003h
	OUT     DX,AX     ; Funktionsauswahl: Bits ersetzen
	MOV     AX,0
	OUT     DX,AX
	MOV     AX,0E01h
	OUT     DX,AX
	MOV     AX,0FF08h
	OUT     DX,AX
	MOV     AX,00005h
	OUT     DX,AX

	MOV     SI,255
	MOV     BX,SI
	ADD     BX,[WORD PTR scradd]
	ADD     BX,512
GLAT_Loop2:
	MOV     AX,SI
 ;      MOV     AH,[FS:BX]
	MOV     [FS:BX],AL
	DEC     BX
	DEC     SI
	JNS     GLAT_Loop2

	MOV     AX,0105h
	OUT     DX,AX
	POPAW
	RET

 ; ******************************************************** printer support

OpenPrinter:
	MOV     DX,[lptnum]
	DEC     DX
	JS      OPPR_End
	MOV     AH,1
	INT     17h
;        MOV     [prinha],0ffffh
;        MOV     DX,OFFSET lptname
;        MOV     AX,[lptnum]
;        ADD     AL,'0'
;        MOV     [EDX+3],AL
;        MOV     AX,3d01h
;        INT     21h
;        JC      OPPR_End
;        MOV     [prinha],AX
OPPR_End:
	RET

ClosePrinter:
;        MOV     BX,[prinha]
;        CMP     BX,0ffffh
;        JE      CLPR_End
;        MOV     AH,3eh
;        INT     21h
;CLPR_End:
	RET

outPrinter:
	PUSHAW
	TEST    AL,80h
	JZ      PRIN_Oops
	AND     AL,7fh
	MOV     DX,[lptnum]
	DEC     DX
	JS      PRIN_Oops
	MOV     AH,0
	INT     17h
	CALL    GetPrtState
PRIN_Oops:
	POPAW
	RET

GetPrtState:
	PUSHAW
	MOV     AH,2
	MOV     DX,[lptnum]
	DEC     DX
	JS      GPRS_NoPrinter
	INT     17h
	SHR     AH,1
	AND     AH,40h
	XOR     AH,40h
	MOV     [prtstate],AH
	POPAW
	RET

GPRS_NoPrinter:
	MOV     [prtstate],40h
	MOV     [lptnum],0
	POPAW
	RET

 ; ******************************************************** RAM banking

InitRAMSegs:
	PUSH    ES
	MOV     [haveEMM],0
	CMP     [useems],0
	JE      IRAS_noEMS
	MOV     AX,3567h
	INT     21h
	CMP     [DWORD PTR ES:10],'XMME'
	JNE     IRAS_noEMS
	CMP     [DWORD PTR ES:14],'0XXX'
	JNE     IRAS_noEMS
	MOV     AH,41h
	INT     67h
	CMP     AH,0
	JNE     IRAS_noEMS
	MOV     [normramseg],BX
	MOV     AH,43h
	MOV     BX,8
	INT     67h
	CMP     AH,0
	JNE     IRAS_noEMS
	MOV     [haveEMM],1
	MOV     [emmha],DX
	MOV     BX,0
	MOV     AX,4400h
	INT     67h
	MOV     BX,1
	MOV     AX,4401h
	INT     67h
	MOV     BX,2
	MOV     AX,4402h
	INT     67h
	MOV     BX,3
	MOV     AX,4403h
	INT     67h
	JMP     IRAS_End
IRAS_noEMS:
	MOV     [normramseg],SEG rambase
IRAS_End:
	POP     ES
	RET

CleanupEMM:
	CMP     [haveEMM],0
	JE      CEMM_Ret
	MOV     AH,45h
	MOV     DX,[emmha]
	INT     67h
CEMM_Ret:
	RET

ResetRAMState:
	PUSH    EAX
	MOV     EAX,[DWORD PTR ramstatetab]
	MOV     [DWORD PTR ramstate],EAX
	MOV     EAX,[DWORD PTR ramstatetab+4]
	MOV     [DWORD PTR ramstate+4],EAX
	POP     EAX
	RET

RethinkRamState:
	CMP     [haveEMM],0
	JNE     RTRS_EMM
	PUSHAD
	PUSH    ES

	MOV     AL,[BYTE PTR sysstat+1]
	AND     AX,7
	MOV     [BYTE PTR sysstat+1],AL
	ADD     AX,AX
	ADD     AX,AX
	ADD     AX,AX
	MOV     SI,AX
	ADD     SI,OFFSET ramstatetab
	MOV     DI,OFFSET ramstate
	MOV     CX,8
RTRS_Loop:
	LODSB
	CMP     AL,[DI]
	JE      RTRS_Equal
	MOV     AH,[DI]
	CALL    ExBanks
RTRS_Equal:
	INC     DI
	LOOP    RTRS_Loop
	POP     ES
	POPAD
	CALL    GenWriteVGAoff
	RET
RTRS_EMM:
	PUSHAW
	MOV     [doingems],1
	MOV     AL,[BYTE PTR sysstat+1]
	AND     AX,7
	MOV     [BYTE PTR sysstat+1],AL
	ADD     AX,AX
	ADD     AX,AX
	ADD     AX,AX
	MOV     SI,AX
	ADD     SI,OFFSET ramstatetab
	MOV     DI,OFFSET ramstate

	XOR     BH,BH
	MOV     BL,[SI]
	MOV     AX,4400h
	MOV     DX,[emmha]
	PUSH    SI
	INT     67h
	POP     SI

	XOR     BH,BH
	MOV     BL,[SI+1]
	MOV     AX,4401h
	MOV     DX,[emmha]
	PUSH    SI
	INT     67h
	POP     SI

	XOR     BH,BH
	MOV     BL,[SI+2]
	MOV     AX,4402h
	MOV     DX,[emmha]
	PUSH    SI
	INT     67h
	POP     SI

	XOR     BH,BH
	MOV     BL,[SI+3]
	MOV     AX,4403h
	MOV     DX,[emmha]
	PUSH    SI
	INT     67h
	POP     SI

	LODSD
	MOV     [DS:DI],EAX
	LODSD
	MOV     [DS:DI+4],EAX
	XOR     EAX,EAX
	POPAW
	CALL    GenWriteVGAoff
	MOV     [omitnextint],2
	MOV     [doingems],0
	RET

ExBanks:                ; IN: AL = Bank1, AH = Bank2 / corrects RamState
	PUSH    SI
	PUSH    DI
	PUSH    CX
	CALL    GetBankAddr
	XCHG    AL,AH
	PUSH    ES
	POP     FS
	MOV     SI,DI
	CALL    GetBankAddr
	MOV     CX,1000h
	PUSH    EAX
	PUSH    DX
	MOV     DX,4
EXBA_ExLoop:
	MOV     EAX,[ES:DI]
	XCHG    EAX,[FS:SI]
	STOSD
	ADD     SI,DX
	LOOP    EXBA_ExLoop
	POP     DX
	POP     EAX
	MOV     CX,8
	MOV     SI,OFFSET ramstate
EXBA_Correct:
	CMP     [SI],AL
	JNE     EXBA_NotAL
	MOV     [SI],AH
	JMP     EXBA_CorrectL
EXBA_NotAL:
	CMP     [SI],AH
	JNE     EXBA_CorrectL
	MOV     [SI],AL
EXBA_CorrectL:
	INC     SI
	LOOP    EXBA_Correct
	POP     CX
	POP     DI
	POP     SI
	RET

GetBankAddr:            ; IN: AL = Bank / OUT: ES:DI Bankaddr
	PUSH    DS
	POP     ES
	PUSH    CX
	MOV     DI,OFFSET ramstate
	MOV     CX,8
	REPNE   SCASB
	SUB     DI,OFFSET ramstate+1
	CMP     DI,4
	JC      GBAD_Lo
	AND     DI,3
	ROR     DI,2
	PUSH    SEG hiram
	POP     ES
	JMP     GBAD_End
GBAD_Lo:
	ROR     DI,2
	PUSH    SEG rambase
	POP     ES
GBAD_End:
	POP     CX
	RET

RethinkMemMap:
	MOV     BP,[normramseg]
	BT      [sysstat],2
	JC      RMM_LOK
	MOV     BP,SEG amsdos
RMM_LOK:
	MOV     [memmap],BP
RMM_TestUpper:
	MOV     BP,[normramseg]
	MOV     [memmap+2],BP
	MOV     [memmap+4],BP

	BT      [sysstat],3
	JC      RMM_UOK

        CMP     [haver5],0
        JE      RMM_No5
        CMP     [romnum],5
        JNE     RMM_No5
        MOV     BP,SEG rom5
        SUB     BP,0C00h
        JMP     RMM_UOK
RMM_No5:

        CMP     [haver6],0
        JE      RMM_No6
        CMP     [romnum],6
        JNE     RMM_No6
        MOV     BP,SEG rom6
        SUB     BP,0C00h
        JMP     RMM_UOK
RMM_No6:

        CMP     [haver7],0
        JE      RMM_No7
        CMP     [romnum],7
        JNE     RMM_No7
        MOV     BP,SEG rom7
        SUB     BP,0C00h
        JMP     RMM_UOK
RMM_No7:

	MOV     BP,SEG basic
	SUB     BP,0C00h
RMM_UOK:
	MOV     [memmap+6],BP

	RET

 ; **************************************************************** Snapshots

LoadSnap:
	PUSHAD
	MOV     [snapha],0ffffh
	MOV     DX,OFFSET snapdir
	MOV     AX,3d02h
	INT     21h
	JC      LOSN_End
	MOV     [snapha],AX

	MOV     BX,AX
	MOV     AH,3fh
	MOV     CX,256
	MOV     DX,OFFSET SnapBuffer
	INT     21h
	JC      LOSN_Close
	CMP     [DWORD PTR SnapBuffer+4],'ANS ' ; check file id
	JNE     LOSN_Close
	CMP     [DWORD PTR SnapBuffer],'- VM'
	JNE     LOSN_Close
	CMP     [BYTE PTR SnapBuffer+10h],1   ; snapshot version (1/2)?
	JE      LOSN_Ver1
	CMP     [BYTE PTR SnapBuffer+10h],2
	JE      LOSN_Ver2
	JMP     LOSN_Close

LOSN_Ver2:

LOSN_Ver1:
	CALL    reset

	POPAD                                 ; read Z80 registers
	MOV     AX,[SnapBuffer+11h]
	ROL     AX,8
	MOV     sBC,[SnapBuffer+13h]
	MOV     sDE,[SnapBuffer+15h]
	MOV     nsHL,[SnapBuffer+17h]
	MOV     sPC,[SnapBuffer+23h]
	PUSHAD

	MOV     AL,[BYTE PTR SnapBuffer+19h]
	MOV     [BYTE PTR srF],AL
	AND     AL,80h
	MOV     [BYTE PTR srFhi],AL
	MOV     AL,[BYTE PTR SnapBuffer+1Ah]
	MOV     [BYTE PTR srI],AL
	MOV     AL,[BYTE PTR SnapBuffer+1Bh]
	MOV     [sIFF1],AL
	MOV     AL,[BYTE PTR SnapBuffer+1Ch]
	MOV     [sIFF2],AL
	MOV     AX,[SnapBuffer+1Dh]
	MOV     [ix],AX
	MOV     AX,[SnapBuffer+1Fh]
	MOV     [iy],AX
	MOV     AX,[SnapBuffer+21h]
	MOV     [simstack],AX
	MOVZX   AX,[BYTE PTR SnapBuffer+25h]
	MOV     [imode],AX
	MOV     AX,[SnapBuffer+26h]
	ROL     AX,8
	MOV     [sAFx],AX
	MOV     AX,[SnapBuffer+28h]
	MOV     [sBCx],AX
	MOV     AX,[SnapBuffer+2Ah]
	MOV     [sDEx],AX
	MOV     AX,[SnapBuffer+2Ch]
	MOV     [sHLx],AX

	MOV     BX,0                            ; set gary
LOSN_SetCols:
	MOV     AL,[BYTE PTR EBX+SnapBuffer+2Fh]
	MOV     [BYTE PTR rgsgarr],BL
	MOV     [BYTE PTR rgsgarr+1],AL
	CALL    ga_setcol
	INC     BX
	CMP     BX,17
	JNE     LOSN_SetCols
	MOV     AL,[BYTE PTR SnapBuffer+2eh]
	MOV     [BYTE PTR rgsgarr],AL
	MOV     AL,[BYTE PTR SnapBuffer+40h]
	MOV     [BYTE PTR rgsgarr+2],AL
	MOV     AL,[BYTE PTR SnapBuffer+41h]
	MOV     [BYTE PTR rgsgarr+3],AL

	MOV     AL,[BYTE PTR SnapBuffer+42h]             ; set CRTC
	MOV     [CRTCregnum],AL
	PUSH    ES
	PUSH    DS
	POP     ES
	MOV     SI,OFFSET SnapBuffer+43h
	MOV     DI,OFFSET CRTCregs
	MOV     CX,9
	REP     MOVSW

	MOV     AL,[BYTE PTR SnapBuffer+55h]
	MOV     [BYTE PTR romnum],AL
	MOV     AL,[BYTE PTR SnapBuffer+56h]
	MOV     [port8255a],AL
	MOV     AL,[BYTE PTR SnapBuffer+57h]
	MOV     [port8255b],AL
	MOV     AL,[BYTE PTR SnapBuffer+58h]
	MOV     [port8255c],AL
	MOV     AL,[BYTE PTR SnapBuffer+59h]
	MOV     [control8255],AL
	MOV     AL,[BYTE PTR SnapBuffer+5Ah]
	MOV     [psgregnum],AL
	MOV     SI,OFFSET SnapBuffer+5Bh
	MOV     DI,OFFSET PSGregs
	MOV     CX,8
	REP     MOVSW
	POP     ES

	MOV     BX,[snapha]                     ; read the RAM
	PUSH    DS
	PUSH    [normramseg]
	POP     DS
	MOV     DX,OFFSET rambase
	MOV     CX,32768
	MOV     AH,3fh
	INT     21h
	ADD     DX,CX
	MOV     AH,3fh
	INT     21h
	POP     DS

	MOV     BP,0                            ; now we can use all the new
LOSN_SetPSG:                                    ; values
	PUSH    BP
	CALL    DoSound
	POP     BP
	INC     BP
	CMP     BP,14
	JNE     LOSN_SetPSG

	CALL    RethinkMemMap
	CALL    RethinkRamState
	POPAD
	InitPCSeg
	PUSHAD
	MOV     [multimodeon],0
	MOV     AL,[BYTE PTR sysstat]
	AND     AX,3
	MOV     AL,[EAX+MoTable]
	MOV     [videomode],AL
	MOV     [spcrtcflag],2
	CALL    RethinkCRTC
	CALL    GenByteMode
	MOV     [scrtype],0ffffh
	MOV     [omitnextint],2
	MOV     [intflag],0
LOSN_Close:
	MOV     BX,[snapha]
	MOV     AH,3Eh
	INT     21h
LOSN_End:
	POPAD
	RET

SaveSnap:
	PUSH    ES
	PUSHAD
	CALL    GetSaveSnapName

	CMP     [snaname],0
	JE      SASN_End

	MOV     [snapha],0ffffh
	MOV     DX,OFFSET snapdir
	MOV     AX,3c00h
	XOR     CX,CX
	INT     21h
	JC      SASN_End
	MOV     [snapha],AX

	MOV     DX,OFFSET SnapBuffer
	MOV     [DWORD PTR EDX],'- VM'
	MOV     [DWORD PTR EDX+4],'ANS '
	MOV     [BYTE PTR EDX+10h],1    ; snapshot version must be 1

	POPAD
	ROL     AX,8                              ; read Z80 registers
	MOV     [SnapBuffer+11h],AX
	ROL     AX,8
	MOV     [SnapBuffer+13h],sBC
	MOV     [SnapBuffer+15h],sDE
	MOV     [SnapBuffer+17h],nsHL
	MOV     [SnapBuffer+23h],sPC
	PUSHAD

	MOV     AL,[BYTE PTR srF]
	AND     AL,7fh
	OR      AL,[BYTE PTR srFhi]
	MOV     [BYTE PTR SnapBuffer+19h],AL
	MOV     AL,[BYTE PTR srI]
	MOV     [BYTE PTR SnapBuffer+1Ah],AL

	MOV     AL,[sIFF1]
	MOV     [BYTE PTR SnapBuffer+1Bh],AL
	MOV     AL,[sIFF2]
	MOV     [BYTE PTR SnapBuffer+1Ch],AL
	MOV     AX,[ix]
	MOV     [SnapBuffer+1Dh],AX
	MOV     AX,[iy]
	MOV     [SnapBuffer+1Fh],AX
	MOV     AX,[simstack]
	MOV     [SnapBuffer+21h],AX
	MOV     AX,[imode]
	MOV     [BYTE PTR SnapBuffer+25h],AL
	MOV     AX,[sAFx]
	ROL     AX,8
	MOV     [SnapBuffer+26h],AX
	MOV     AX,[sBCx]
	MOV     [SnapBuffer+28h],AX
	MOV     AX,[sDEx]
	MOV     [SnapBuffer+2Ah],AX
	MOV     AX,[sHLx]
	MOV     [SnapBuffer+2Ch],AX

	MOV     BX,0                            ; set gary
SASN_SetCols:
	MOV     AL,[BYTE PTR EBX+garrcols]
	MOV     [BYTE PTR EBX+SnapBuffer+02Fh],AL
	INC     BX
	CMP     BX,17
	JNE     SASN_SetCols
	MOV     AL,[BYTE PTR rgsgarr]
	MOV     [BYTE PTR SnapBuffer+2eh],AL
	MOV     AL,[BYTE PTR rgsgarr+2]
	MOV     [BYTE PTR SnapBuffer+40h],AL
	MOV     AL,[BYTE PTR rgsgarr+3]
	MOV     [BYTE PTR SnapBuffer+41h],AL

	MOV     AL,[CRTCregnum]
	MOV     [BYTE PTR SnapBuffer+42h],AL             ; set CRTC
	PUSH    ES
	PUSH    DS
	POP     ES
	MOV     DI,OFFSET SnapBuffer+43h
	MOV     SI,OFFSET CRTCregs
	MOV     CX,9
	REP     MOVSW

	MOV     AL,[BYTE PTR romnum]
	MOV     [BYTE PTR SnapBuffer+55h],AL
	MOV     AL,[port8255a]
	MOV     [BYTE PTR SnapBuffer+56h],AL
	MOV     AL,[port8255b]
	MOV     [BYTE PTR SnapBuffer+57h],AL
	MOV     AL,[port8255c]
	MOV     [BYTE PTR SnapBuffer+58h],AL
	MOV     AL,[control8255]
	MOV     [BYTE PTR SnapBuffer+59h],AL
	MOV     AL,[psgregnum]
	MOV     [BYTE PTR SnapBuffer+5Ah],AL
	MOV     DI,OFFSET SnapBuffer+5Bh
	MOV     SI,OFFSET PSGregs
	MOV     CX,8
	REP     MOVSW
	POP     ES

	MOV     [SnapBuffer+06bh],64
	MOV     [SnapBuffer+06ch],0

	MOV     BX,[snapha]
	MOV     CX,256
	MOV     DX,OFFSET SnapBuffer
	MOV     AX,4000h
	INT     21h

	PUSH    DS
	PUSH    [normramseg]
	POP     DS
	MOV     DX,OFFSET rambase
	MOV     CX,32768
	MOV     AH,40h
	INT     21h
	ADD     DX,CX
	MOV     AH,40h
	INT     21h
	POP     DS

	MOV     BX,[snapha]
	MOV     AH,3Eh
	INT     21h
SASN_End:
	POPAD
	POP     ES
	CALL    GetSnapDir
	RET
ENDS

SEGMENT _data PAGE PUBLIC 'DATA'

haver5  dw 0
haver6  dw 0
haver7  dw 0

prefname db 'prefs.cpe',0

SnapBuffer dw 256 DUP (?)

CPCKTb   dw 0

LABEL MenuScr BYTE
	db '               CPE Preferences                                                  '
	db '                                                                                '
	db '  Green monitor                                                                 '
	db '  Use sound card                                                                '
	db '  Use joystick                                                                  '
	db '  Real-time CPC                                                                 '
	db '  Frame fly asynchronous to vertical retrace                                    '
	db '  Clear frame fly bit after read                                                '
	db '  Emulate R register                                                            '
	db '  Permit double buffering                                                       '
	db '  Double buffering: Exchange pages                                              '
	db '  Exact interrupts                                                              '
	db '  Permit VGA scrolling                                                          '
	db '  Permit multimode                                                              '
	db '  Try slowdown for exact realtime (experimental)                                '
	db 80 DUP (' ')
	db 80 DUP (' ')
	db 80 DUP (' ')
	db 80 DUP (' ')
	db 80 DUP (' ')
	db 80 DUP (' ')
	db 80 DUP (' ')
	db 80 DUP (' ')
	db 80 DUP (' ')
	db 80 DUP (' ')
	db 80 DUP (' ')
	db 80 DUP (' ')
	db 80 DUP (' ')
	db 80 DUP (' ')
	db 80 DUP (' ')

MenuItems   dw 13

LABEL CPEPrefs WORD
lsmode      dw 52h
doublelin   dw 1
germkey     dw 0
SBInstalled dw 0ffffh
SBport      dw 220h
lptnum      dw 1
PCRTC_VT1   dw 62h                   ; cpc zones moving down
cpctype     dw 3
bogoval     dw 0
bogoval2    dw 0
bogoval3    dw 0
bogoval4    dw 0
useems      dw 0ffffh
LABEL sbirq WORD
gusint      dw 0bh
sbdma       dw 01h
DMAblocklen dw 0f0h
quietcas    dw 0
bogoval5    dw 0

LABEL MenuVars WORD
colmode     dw 0
usesound    dw 0ffffh
usejoy      dw 0
realtime    dw 0
asyncff     dw 0
clearff     dw 0
emulr       dw 0ffffh
permitdbuf  dw 0ffffh
xchgdbuf    dw 0
exactint    dw 0ffffh
useVGAroll  dw 0ffffh
permitMM    dw 0ffffh
fancyrlt    dw 0

PCRTC_VR1    dw   1e0h
PCRTC_MODE   db   0
PCRTC_HITVB  db   0
PCRTC_VR2CNT db   0
tssavedmode  db   0

LABEL joystuff WORD
joyr        dw 0
joyu        dw 0
joyl        dw 0
joyd        dw 0

havejoy     dw 0f00bh

MoTable db 0,1,2,0

LABEL m1cols BYTE

 DB 0,0,0,2,0,32,0,34,2,0,2,2,2,32,2,34
 DB 32,0,32,2,32,32,32,34,34,0,34,2,34,32,34,34
 DB 0,1,0,3,0,33,0,35,2,1,2,3,2,33,2,35
 DB 32,1,32,3,32,33,32,35,34,1,34,3,34,33,34,35
 DB 0,16,0,18,0,48,0,50,2,16,2,18,2,48,2,50
 DB 32,16,32,18,32,48,32,50,34,16,34,18,34,48,34,50
 DB 0,17,0,19,0,49,0,51,2,17,2,19,2,49,2,51
 DB 32,17,32,19,32,49,32,51,34,17,34,19,34,49,34,51
 DB 1,0,1,2,1,32,1,34,3,0,3,2,3,32,3,34
 DB 33,0,33,2,33,32,33,34,35,0,35,2,35,32,35,34
 DB 1,1,1,3,1,33,1,35,3,1,3,3,3,33,3,35
 DB 33,1,33,3,33,33,33,35,35,1,35,3,35,33,35,35
 DB 1,16,1,18,1,48,1,50,3,16,3,18,3,48,3,50
 DB 33,16,33,18,33,48,33,50,35,16,35,18,35,48,35,50
 DB 1,17,1,19,1,49,1,51,3,17,3,19,3,49,3,51
 DB 33,17,33,19,33,49,33,51,35,17,35,19,35,49,35,51
 DB 16,0,16,2,16,32,16,34,18,0,18,2,18,32,18,34
 DB 48,0,48,2,48,32,48,34,50,0,50,2,50,32,50,34
 DB 16,1,16,3,16,33,16,35,18,1,18,3,18,33,18,35
 DB 48,1,48,3,48,33,48,35,50,1,50,3,50,33,50,35
 DB 16,16,16,18,16,48,16,50,18,16,18,18,18,48,18,50
 DB 48,16,48,18,48,48,48,50,50,16,50,18,50,48,50,50
 DB 16,17,16,19,16,49,16,51,18,17,18,19,18,49,18,51
 DB 48,17,48,19,48,49,48,51,50,17,50,19,50,49,50,51
 DB 17,0,17,2,17,32,17,34,19,0,19,2,19,32,19,34
 DB 49,0,49,2,49,32,49,34,51,0,51,2,51,32,51,34
 DB 17,1,17,3,17,33,17,35,19,1,19,3,19,33,19,35
 DB 49,1,49,3,49,33,49,35,51,1,51,3,51,33,51,35
 DB 17,16,17,18,17,48,17,50,19,16,19,18,19,48,19,50
 DB 49,16,49,18,49,48,49,50,51,16,51,18,51,48,51,50
 DB 17,17,17,19,17,49,17,51,19,17,19,19,19,49,19,51
 DB 49,17,49,19,49,49,49,51,51,17,51,19,51,49,51,51

 DB 0,0,0,1,0,16,0,17,1,0,1,1,1,16,1,17
 DB 16,0,16,1,16,16,16,17,17,0,17,1,17,16,17,17
 DB 0,2,0,3,0,18,0,19,1,2,1,3,1,18,1,19
 DB 16,2,16,3,16,18,16,19,17,2,17,3,17,18,17,19
 DB 0,32,0,33,0,48,0,49,1,32,1,33,1,48,1,49
 DB 16,32,16,33,16,48,16,49,17,32,17,33,17,48,17,49
 DB 0,34,0,35,0,50,0,51,1,34,1,35,1,50,1,51
 DB 16,34,16,35,16,50,16,51,17,34,17,35,17,50,17,51
 DB 2,0,2,1,2,16,2,17,3,0,3,1,3,16,3,17
 DB 18,0,18,1,18,16,18,17,19,0,19,1,19,16,19,17
 DB 2,2,2,3,2,18,2,19,3,2,3,3,3,18,3,19
 DB 18,2,18,3,18,18,18,19,19,2,19,3,19,18,19,19
 DB 2,32,2,33,2,48,2,49,3,32,3,33,3,48,3,49
 DB 18,32,18,33,18,48,18,49,19,32,19,33,19,48,19,49
 DB 2,34,2,35,2,50,2,51,3,34,3,35,3,50,3,51
 DB 18,34,18,35,18,50,18,51,19,34,19,35,19,50,19,51
 DB 32,0,32,1,32,16,32,17,33,0,33,1,33,16,33,17
 DB 48,0,48,1,48,16,48,17,49,0,49,1,49,16,49,17
 DB 32,2,32,3,32,18,32,19,33,2,33,3,33,18,33,19
 DB 48,2,48,3,48,18,48,19,49,2,49,3,49,18,49,19
 DB 32,32,32,33,32,48,32,49,33,32,33,33,33,48,33,49
 DB 48,32,48,33,48,48,48,49,49,32,49,33,49,48,49,49
 DB 32,34,32,35,32,50,32,51,33,34,33,35,33,50,33,51
 DB 48,34,48,35,48,50,48,51,49,34,49,35,49,50,49,51
 DB 34,0,34,1,34,16,34,17,35,0,35,1,35,16,35,17
 DB 50,0,50,1,50,16,50,17,51,0,51,1,51,16,51,17
 DB 34,2,34,3,34,18,34,19,35,2,35,3,35,18,35,19
 DB 50,2,50,3,50,18,50,19,51,2,51,3,51,18,51,19
 DB 34,32,34,33,34,48,34,49,35,32,35,33,35,48,35,49
 DB 50,32,50,33,50,48,50,49,51,32,51,33,51,48,51,49
 DB 34,34,34,35,34,50,34,51,35,34,35,35,35,50,35,51
 DB 50,34,50,35,50,50,50,51,51,34,51,35,51,50,51,51

LABEL m0cols BYTE
 DB 0,8,128,136,2,10,130,138,32,40,160,168,34,42,162,170
 DB 4,12,132,140,6,14,134,142,36,44,164,172,38,46,166,174
 DB 64,72,192,200,66,74,194,202,96,104,224,232,98,106,226,234
 DB 68,76,196,204,70,78,198,206,100,108,228,236,102,110,230,238
 DB 1,9,129,137,3,11,131,139,33,41,161,169,35,43,163,171
 DB 5,13,133,141,7,15,135,143,37,45,165,173,39,47,167,175
 DB 65,73,193,201,67,75,195,203,97,105,225,233,99,107,227,235
 DB 69,77,197,205,71,79,199,207,101,109,229,237,103,111,231,239
 DB 16,24,144,152,18,26,146,154,48,56,176,184,50,58,178,186
 DB 20,28,148,156,22,30,150,158,52,60,180,188,54,62,182,190
 DB 80,88,208,216,82,90,210,218,112,120,240,248,114,122,242,250
 DB 84,92,212,220,86,94,214,222,116,124,244,252,118,126,246,254
 DB 17,25,145,153,19,27,147,155,49,57,177,185,51,59,179,187
 DB 21,29,149,157,23,31,151,159,53,61,181,189,55,63,183,191
 DB 81,89,209,217,83,91,211,219,113,121,241,249,115,123,243,251
 DB 85,93,213,221,87,95,215,223,117,125,245,253,119,127,247,255

	EVEN

 ; CPC-Ports
 ; ************************************************ CRTC 6845
	    EVEN
CRTCregnum  db    ?,?           ; BCxx
CRTCregs    dw    9 DUP (?)     ; BDxx/BFxx 18 regs of video controller
crtccareful dw    0             ; set for over-overscan (bytes twice on screen)
crtcscrwidth db   ?             ; copy of CRTC reg 1
crtcscrheight db  ?             ; copy of CRTC reg 6
crtcmaxslin db    ?             ; copy of CRTC reg 9
crtcsyncpos db    ?             ; copy OF CRTC reg 7
crtcvgaoff  dw    0ffffh,0ffffh,0ffffh,0h ; which CPC bank goes to which VGA bank
writevgaoff dw    0ffffh,0ffffh,0ffffh,0ffffh ; same thing, but reflecting RAM banking
lastdbuf    dw    0             ; to disable double buffering after, say, 10 interrupts or so
scrbase     dw    0C000h        ; extract from CRTC regs 12/13
scroff      dw    0             ;  "       "    "    "     "
oldscroff   dw    0             ; used for scrolling in RethinkCRTC
scrtype     dw    0             ; 1,2: normal/normal 50Hz; 3: extended
doublelinmode dw  0             ; active screen uses double lines
spcrtcflag  dw    0             ;
CRTCkyfo    dw    0             ; Keep Your Fingers Off - don't modify regs during int
vgascroll   dw    0             ; circular VGA scroll offset

videomode   db    0             ; CPC mode 0,1,2 - for fullscr modes only
newvidmode  db    0             ; change that has not been brought to the screen
lastmodechg db    0             ; count ints since last mdchg
multimodeon db    0             ; flag for no multimode set
modezochgd  dw    0
modezones   db    0,0,0,0,0,0   ; which mode is active in which zone?
oldmzones   db    0,0,0,0,0,0
modeffoff   db    4,3,2,1,0,5
modeinprogr dw    0
scradd      dd    0a000fd00h
mozoctdn    dw    0
mmintsignal dw    0

SNSBRedraw  dw    0             ; redraw after setnewscreenbase

 ; ************************************************ 8255, PSG
	    EVEN
port8255a   db    ?   ; F4
port8255b   db    ?   ; F5
port8255c   db    ?   ; F6
control8255 db    ?   ; F7

po8255a     db    ?
po8255c     db    ?

psgregnum   db    ?,?
psgregs     dw    128 DUP (?)
psgregmod   dw    128 DUP (?)
PSGcount    dw    0

prtstate    db    0,0

 ; ************************************************ GATE ARRAY
	    EVEN
romnum      dw    ?             ; this is the DFxx port
rgsgarr     dw    ?             ; 7Fxx 4  regs of gate array
sysstat     dw    ?   ; 7Fxx this and the last line MUST be kept together
memstate    db    0,0
ramstate    db    0,1,2,3,4,5,6,7

ramstatetab db    0,1,2,3,4,5,6,7
	    db    0,1,2,7,4,5,6,3
	    db    4,5,6,7,0,1,2,3
	    db    0,3,2,7,4,5,6,1
	    db    0,4,2,3,1,5,6,7
	    db    0,5,2,3,4,1,6,7
	    db    0,6,2,3,4,5,1,7
	    db    0,7,2,3,4,5,6,1

memmap      dw    SEG amsdos,SEG rambase,SEG rambase,SEG rambase

haveEMM     dw    0
normramseg  dw    0
emmha       dw    0
doingems    dw    0

garrcols    dw    10 DUP (?)

CMap        dd    34 DUP (?)

 ; ************************************************ Interrupts
	    EVEN
intcount    dw    ?
intreq      dw    ?
ffly        dw    ?
ffcount     dw    ?
omitnextint dw    0
resetting   dw    0
ReDrawCount dw    ?

 ; ************************************************ cleanup area
oldintadd   dw    0             ; 86 interrupt torture
oldintseg   dw    0
oldnoiadd   dw    0
oldnoiseg   dw    0
timercount  dw    0
timerval    dw    0f84h
OldVideo    dw    3

ffly_dec_std dw   2
ffly_dec     dw   0

ENDS

SEGMENT _stack PARA STACK 'STACK'

TapeBuffer  dw    800h DUP (?)
TapeLoadBuf dw    800h DUP (?)

stck    dw 1000 dup (?)
stckend dw ?

ENDS

SEGMENT SEGSCROFF PRIVATE PARA
Scrofftab dw    4000H DUP (?)
ENDS
SEGMENT SEGRAM PRIVATE PARA USE32
rambase db      65536 DUP (?)
ENDS
SEGMENT SEGHIRAM PRIVATE PARA USE32
hiram   db      65536 DUP (?)
ENDS
SEGMENT SEGLOROM PRIVATE PARA
amsdos  db      16386 DUP (?)
ENDS
SEGMENT SEGBASIC PRIVATE PARA
basic   db      16386 DUP (?)
ENDS
SEGMENT SEGROM5 PRIVATE PARA
rom5    db      16386 DUP (?)
ENDS
SEGMENT SEGROM6 PRIVATE PARA
rom6    db      16386 DUP (?)
ENDS
SEGMENT SEGROM7 PRIVATE PARA
rom7    db      16386 DUP (?)
ENDS

SEGMENT SEGADCONV PRIVATE PARA
ScrAdConv dw 4000H DUP (?)
ByteMode  dw 4000H DUP (?)
ENDS

SEGMENT SEGADLIST PRIVATE PARA
ScrAdList dw 800H DUP (?)
ENDS
	END
