/* -------------------------------------------------------------------------- */
/*                                                                            */
/* (C) Copyright D.C.Devenport 1997. All right reserved.                      */
/*                                                                            */
/* THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY      */
/* KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE        */
/* IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR      */
/* PURPOSE.                                                                   */
/*                                                                            */
/* This code, and no part of this code, may not be used in any                */
/* commercial or for-profit venture without the express written               */
/* permission of D.C.Devenport. (DDevenp666@aol.com)                          */
/*                                                                            */
/* Credit must be given within any program that uses any of this code         */
/* OR in the accompanying documentation. (And mail me a copy :) )             */
/*                                                                            */
/*----------------------------------------------------------------------------*/
#include <stdlib.h>
#include <stdio.h>


void Reset6502();

void Do6502Instructions();

void Dump6502(FILE * FileHandle);

/*
// bit values for the processor flags - not used, just for reference
#define CARRYFLAG       1
#define ZEROFLAG        2
#define INTERRUPTFLAG   4
#define DECIMALFLAG     8
#define BREAKFLAG       16
#define UNUSEDFLAG      32
#define OVERFLOWFLAG    64
#define SIGNFLAG        128
*/

// setbits
#define SETIFLAG   (Processor.IFlag=4)

// ALWAYS Set Processor.CFlag to 1, if not ASL,LSR,ROL,ROR need changing
// Processor.CFlag uses SET below...

#define SET(Flg)   ((Flg)=1)
#define UNSET(Flg) ((Flg)=0)
#define SETFLAG(Test,Flag) Flag=(Test)
#define SETZ(Byte)  Processor.ZFlag=!(Byte)


// stack operations - always in normal RAM
#define PUSH(Byte) AddressSpace[0x100+(Processor.StackPointer--)]=Byte
#define POP(Byte)  Byte=AddressSpace[0x101+(Processor.StackPointer++)]

// break flag is always set, except when pushed on the stack during an
// Interrupt/NMI
// Break flag (16) is always set, and also the unused flag (32)
#define MAKESTATUSREG ((Processor.NFlag) | \
                       (Processor.VFlag<<6) | \
                         48 | \
                       (Processor.DFlag<<3) | \
                       (Processor.IFlag) | \
                       (Processor.ZFlag<<1) | \
                       Processor.CFlag)

// Break flag is cleared here, only on this 1 occasion
#define MAKEIRQSTATUSREG ((Processor.NFlag) | \
                          (Processor.VFlag<<6) | \
                           32 | \
                          (Processor.DFlag<<3) | \
                          (Processor.IFlag) | \
                          (Processor.ZFlag<<1) | \
                          Processor.CFlag)
