/* -------------------------------------------------------------------------- */
/*                                                                            */
/* (C) Copyright D.C.Devenport 1997. All right reserved.                      */
/*                                                                            */
/* THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY      */
/* KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE        */
/* IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR      */
/* PURPOSE.                                                                   */
/*                                                                            */
/* This code, and no part of this code, may not be used in any                */
/* commercial or for-profit venture without the express written               */
/* permission of D.C.Devenport. (DDevenp666@aol.com)                          */
/*                                                                            */
/* Credit must be given within any program that uses any of this code         */
/* OR in the accompanying documentation. (And mail me a copy :) )             */
/*                                                                            */
/*----------------------------------------------------------------------------*/
#include <i86.h>
#include <conio.h>

#include "bbc.h"
#include "modex.h"

static struct Mode46PaletteType
{
  const char * LPaletteAddress, * RPaletteAddress;
  int Age;
  BYTE CurrentPalette[NUMCOLS];
} Mode46PalTable[TABLESIZE]=
{
  { (char *) 0xac400, (char *) 0xac500, 0, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } },
  { (char *) 0xac600, (char *) 0xac700, 0, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } },
  { (char *) 0xac800, (char *) 0xac900, 0, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } },
  { (char *) 0xaca00, (char *) 0xacb00, 0, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } },
  { (char *) 0xacc00, (char *) 0xacd00, 0, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } },
  { (char *) 0xace00, (char *) 0xacf00, 0, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } },
  { (char *) 0xad000, (char *) 0xad100, 0, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } },
  { (char *) 0xad200, (char *) 0xad300, 0, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } },
  { (char *) 0xad400, (char *) 0xad500, 0, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } },
  { (char *) 0xad600, (char *) 0xad700, 0, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } }
};

static int    Mode46TableOffset=0;


void ClearMode46Colours()
{
  int CountX,CountY;
    for (CountY=0; CountY<TABLESIZE; CountY++)
    {
        for (CountX=0; CountX<16; CountX++)
          Mode46PalTable[CountY].CurrentPalette[CountX]=17;
      Mode46PalTable[CountY].Age=0;
    }
  Mode46TableOffset=0;
}


void AgeMode46()
{
  int CountY;
    for (CountY=0; CountY<TABLESIZE; CountY++)
       Mode46PalTable[CountY].Age>>=1;
}


void DisplayMode4Screen()
{
// mode1, 0xff mask, access to all planes

    if (OldColoursChanged)
      Mode46ChangeColours();

  Mode46PalTable[Mode46TableOffset].Age++;
  ModeXLookup =(DWORD) Mode46PalTable[Mode46TableOffset].LPaletteAddress;
  ModeXLookup2=(DWORD) Mode46PalTable[Mode46TableOffset].RPaletteAddress;

  Plot10K();
}

void DisplayMode4Row()
{
// mode1, 0xff mask, access to all planes

    if (OldColoursChanged)
      Mode46ChangeColours();

  Mode46PalTable[Mode46TableOffset].Age++;
  ModeXLookup =(DWORD) Mode46PalTable[Mode46TableOffset].LPaletteAddress;
  ModeXLookup2=(DWORD) Mode46PalTable[Mode46TableOffset].RPaletteAddress;

  Plot40Row();
}


void DisplayMode6Screen()
{
// mode1, 0xff mask, access to all planes

    if (OldColoursChanged)
      Mode46ChangeColours();

  Mode46PalTable[Mode46TableOffset].Age++;
  ModeXLookup =(DWORD) Mode46PalTable[Mode46TableOffset].LPaletteAddress;
  ModeXLookup2=(DWORD) Mode46PalTable[Mode46TableOffset].RPaletteAddress;

  Plot8K();
}



const struct MODE4 // A byte is ABCDEFGH
{
  char Mask1;
  char Pixels1[0x80];
  char Mask2;
  char Pixels2[0x80];
  char Mask3;
  char Pixels3[0x80];
  char Mask4;
  char Pixels4[0x80];
} Mode4Table[]=
{
// LEFT PIXELS

  { // colour 0
    0xc0, // every combination of A in top nibble as Pixels
      { 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
        0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f,
        0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17,
        0x18, 0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x1e, 0x1f,
        0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27,
        0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f,
        0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37,
        0x38, 0x39, 0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f,
        0x40, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47,
        0x48, 0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f,
        0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57,
        0x58, 0x59, 0x5a, 0x5b, 0x5c, 0x5d, 0x5e, 0x5f,
        0x60, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67,
        0x68, 0x69, 0x6a, 0x6b, 0x6c, 0x6d, 0x6e, 0x6f,
        0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77,
        0x78, 0x79, 0x7a, 0x7b, 0x7c, 0x7d, 0x7e, 0x7f },

    0x30, // every combination of B as Pixels 0x00-0xff
      { 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
        0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f,
        0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17,
        0x18, 0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x1e, 0x1f,
        0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27,
        0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f,
        0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37,
        0x38, 0x39, 0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f,
        0x80, 0x81, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87,
        0x88, 0x89, 0x8a, 0x8b, 0x8c, 0x8d, 0x8e, 0x8f,
        0x90, 0x91, 0x92, 0x93, 0x94, 0x95, 0x96, 0x97,
        0x98, 0x99, 0x9a, 0x9b, 0x9c, 0x9d, 0x9e, 0x9f,
        0xa0, 0xa1, 0xa2, 0xa3, 0xa4, 0xa5, 0xa6, 0xa7,
        0xa8, 0xa9, 0xaa, 0xab, 0xac, 0xad, 0xae, 0xaf,
        0xb0, 0xb1, 0xb2, 0xb3, 0xb4, 0xb5, 0xb6, 0xb7,
        0xb8, 0xb9, 0xba, 0xbb, 0xbc, 0xbd, 0xbe, 0xbf },

    0x0c, // every combination of C as Pixels 0x00-0xff
      { 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
        0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f,
        0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17,
        0x18, 0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x1e, 0x1f,
        0x40, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47,
        0x48, 0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f,
        0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57,
        0x58, 0x59, 0x5a, 0x5b, 0x5c, 0x5d, 0x5e, 0x5f,
        0x80, 0x81, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87,
        0x88, 0x89, 0x8a, 0x8b, 0x8c, 0x8d, 0x8e, 0x8f,
        0x90, 0x91, 0x92, 0x93, 0x94, 0x95, 0x96, 0x97,
        0x98, 0x99, 0x9a, 0x9b, 0x9c, 0x9d, 0x9e, 0x9f,
        0xc0, 0xc1, 0xc2, 0xc3, 0xc4, 0xc5, 0xc6, 0xc7,
        0xc8, 0xc9, 0xca, 0xcb, 0xcc, 0xcd, 0xce, 0xcf,
        0xd0, 0xd1, 0xd2, 0xd3, 0xd4, 0xd5, 0xd6, 0xd7,
        0xd8, 0xd9, 0xda, 0xdb, 0xdc, 0xdd, 0xde, 0xdf },

    0x03, // every combination of D as Pixels 0x00-0xff
      { 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
        0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f,
        0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27,
        0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f,
        0x40, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47,
        0x48, 0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f,
        0x60, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67,
        0x68, 0x69, 0x6a, 0x6b, 0x6c, 0x6d, 0x6e, 0x6f,
        0x80, 0x81, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87,
        0x88, 0x89, 0x8a, 0x8b, 0x8c, 0x8d, 0x8e, 0x8f,
        0xa0, 0xa1, 0xa2, 0xa3, 0xa4, 0xa5, 0xa6, 0xa7,
        0xa8, 0xa9, 0xaa, 0xab, 0xac, 0xad, 0xae, 0xaf,
        0xc0, 0xc1, 0xc2, 0xc3, 0xc4, 0xc5, 0xc6, 0xc7,
        0xc8, 0xc9, 0xca, 0xcb, 0xcc, 0xcd, 0xce, 0xcf,
        0xe0, 0xe1, 0xe2, 0xe3, 0xe4, 0xe5, 0xe6, 0xe7,
        0xe8, 0xe9, 0xea, 0xeb, 0xec, 0xed, 0xee, 0xef }
  },
  { // colour 1
    0xc0, // every combination of A as Pixels 0x00-0xff
      { 0x80, 0x81, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87,
        0x88, 0x89, 0x8a, 0x8b, 0x8c, 0x8d, 0x8e, 0x8f,
        0x90, 0x91, 0x92, 0x93, 0x94, 0x95, 0x96, 0x97,
        0x98, 0x99, 0x9a, 0x9b, 0x9c, 0x9d, 0x9e, 0x9f,
        0xa0, 0xa1, 0xa2, 0xa3, 0xa4, 0xa5, 0xa6, 0xa7,
        0xa8, 0xa9, 0xaa, 0xab, 0xac, 0xad, 0xae, 0xaf,
        0xb0, 0xb1, 0xb2, 0xb3, 0xb4, 0xb5, 0xb6, 0xb7,
        0xb8, 0xb9, 0xba, 0xbb, 0xbc, 0xbd, 0xbe, 0xbf, 
        0xc0, 0xc1, 0xc2, 0xc3, 0xc4, 0xc5, 0xc6, 0xc7,
        0xc8, 0xc9, 0xca, 0xcb, 0xcc, 0xcd, 0xce, 0xcf,
        0xd0, 0xd1, 0xd2, 0xd3, 0xd4, 0xd5, 0xd6, 0xd7,
        0xd8, 0xd9, 0xda, 0xdb, 0xdc, 0xdd, 0xde, 0xdf, 
        0xe0, 0xe1, 0xe2, 0xe3, 0xe4, 0xe5, 0xe6, 0xe7,
        0xe8, 0xe9, 0xea, 0xeb, 0xec, 0xed, 0xee, 0xef, 
        0xf0, 0xf1, 0xf2, 0xf3, 0xf4, 0xf5, 0xf6, 0xf7,
        0xf8, 0xf9, 0xfa, 0xfb, 0xfc, 0xfd, 0xfe, 0xff },

    0x30, // every combination of B as Pixels 0x00-0xff
      { 0x40, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47,
        0x48, 0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f,
        0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57,
        0x58, 0x59, 0x5a, 0x5b, 0x5c, 0x5d, 0x5e, 0x5f,
        0x60, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67,
        0x68, 0x69, 0x6a, 0x6b, 0x6c, 0x6d, 0x6e, 0x6f,
        0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77,
        0x78, 0x79, 0x7a, 0x7b, 0x7c, 0x7d, 0x7e, 0x7f,
        0xc0, 0xc1, 0xc2, 0xc3, 0xc4, 0xc5, 0xc6, 0xc7,
        0xc8, 0xc9, 0xca, 0xcb, 0xcc, 0xcd, 0xce, 0xcf,
        0xd0, 0xd1, 0xd2, 0xd3, 0xd4, 0xd5, 0xd6, 0xd7,
        0xd8, 0xd9, 0xda, 0xdb, 0xdc, 0xdd, 0xde, 0xdf, 
        0xe0, 0xe1, 0xe2, 0xe3, 0xe4, 0xe5, 0xe6, 0xe7,
        0xe8, 0xe9, 0xea, 0xeb, 0xec, 0xed, 0xee, 0xef, 
        0xf0, 0xf1, 0xf2, 0xf3, 0xf4, 0xf5, 0xf6, 0xf7,
        0xf8, 0xf9, 0xfa, 0xfb, 0xfc, 0xfd, 0xfe, 0xff },

    0x0c, // every combination of C as Pixels 0x00-0xff
      { 0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27,
        0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f,
        0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37,
        0x38, 0x39, 0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f,
        0x60, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67,
        0x68, 0x69, 0x6a, 0x6b, 0x6c, 0x6d, 0x6e, 0x6f,
        0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77,
        0x78, 0x79, 0x7a, 0x7b, 0x7c, 0x7d, 0x7e, 0x7f,
        0xa0, 0xa1, 0xa2, 0xa3, 0xa4, 0xa5, 0xa6, 0xa7,
        0xa8, 0xa9, 0xaa, 0xab, 0xac, 0xad, 0xae, 0xaf,
        0xb0, 0xb1, 0xb2, 0xb3, 0xb4, 0xb5, 0xb6, 0xb7,
        0xb8, 0xb9, 0xba, 0xbb, 0xbc, 0xbd, 0xbe, 0xbf, 
        0xe0, 0xe1, 0xe2, 0xe3, 0xe4, 0xe5, 0xe6, 0xe7,
        0xe8, 0xe9, 0xea, 0xeb, 0xec, 0xed, 0xee, 0xef, 
        0xf0, 0xf1, 0xf2, 0xf3, 0xf4, 0xf5, 0xf6, 0xf7,
        0xf8, 0xf9, 0xfa, 0xfb, 0xfc, 0xfd, 0xfe, 0xff },

    0x03, // every combination of D as Pixels 0x00-0xff
      { 0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17,
        0x18, 0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x1e, 0x1f,
        0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37,
        0x38, 0x39, 0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f,
        0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57,
        0x58, 0x59, 0x5a, 0x5b, 0x5c, 0x5d, 0x5e, 0x5f,
        0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77,
        0x78, 0x79, 0x7a, 0x7b, 0x7c, 0x7d, 0x7e, 0x7f,
        0x90, 0x91, 0x92, 0x93, 0x94, 0x95, 0x96, 0x97,
        0x98, 0x99, 0x9a, 0x9b, 0x9c, 0x9d, 0x9e, 0x9f,
        0xb0, 0xb1, 0xb2, 0xb3, 0xb4, 0xb5, 0xb6, 0xb7,
        0xb8, 0xb9, 0xba, 0xbb, 0xbc, 0xbd, 0xbe, 0xbf, 
        0xd0, 0xd1, 0xd2, 0xd3, 0xd4, 0xd5, 0xd6, 0xd7,
        0xd8, 0xd9, 0xda, 0xdb, 0xdc, 0xdd, 0xde, 0xdf, 
        0xf0, 0xf1, 0xf2, 0xf3, 0xf4, 0xf5, 0xf6, 0xf7,
        0xf8, 0xf9, 0xfa, 0xfb, 0xfc, 0xfd, 0xfe, 0xff },
  },

// RIGHT PIXELS

  { // colour 0
    0xc0, // every combination of E as Pixels 0x00-0xff
      { 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
        0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17,
        0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27,
        0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37,
        0x40, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47,
        0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57,
        0x60, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67,
        0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77,
        0x80, 0x81, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87,
        0x90, 0x91, 0x92, 0x93, 0x94, 0x95, 0x96, 0x97,
        0xa0, 0xa1, 0xa2, 0xa3, 0xa4, 0xa5, 0xa6, 0xa7,
        0xb0, 0xb1, 0xb2, 0xb3, 0xb4, 0xb5, 0xb6, 0xb7,
        0xc0, 0xc1, 0xc2, 0xc3, 0xc4, 0xc5, 0xc6, 0xc7,
        0xd0, 0xd1, 0xd2, 0xd3, 0xd4, 0xd5, 0xd6, 0xd7,
        0xe0, 0xe1, 0xe2, 0xe3, 0xe4, 0xe5, 0xe6, 0xe7,
        0xf0, 0xf1, 0xf2, 0xf3, 0xf4, 0xf5, 0xf6, 0xf7 },  

    0x30, // every combination of F as Pixels 0x00-0xff
      { 0x00, 0x01, 0x02, 0x03, 0x08, 0x09, 0x0a, 0x0b,
        0x10, 0x11, 0x12, 0x13, 0x18, 0x19, 0x1a, 0x1b,
        0x20, 0x21, 0x22, 0x23, 0x28, 0x29, 0x2a, 0x2b,
        0x30, 0x31, 0x32, 0x33, 0x38, 0x39, 0x3a, 0x3b,
        0x40, 0x41, 0x42, 0x43, 0x48, 0x49, 0x4a, 0x4b,
        0x50, 0x51, 0x52, 0x53, 0x58, 0x59, 0x5a, 0x5b,
        0x60, 0x61, 0x62, 0x63, 0x68, 0x69, 0x6a, 0x6b,
        0x70, 0x71, 0x72, 0x73, 0x78, 0x79, 0x7a, 0x7b,
        0x80, 0x81, 0x82, 0x83, 0x88, 0x89, 0x8a, 0x8b,
        0x90, 0x91, 0x92, 0x93, 0x98, 0x99, 0x9a, 0x9b,
        0xa0, 0xa1, 0xa2, 0xa3, 0xa8, 0xa9, 0xaa, 0xab,
        0xb0, 0xb1, 0xb2, 0xb3, 0xb8, 0xb9, 0xba, 0xbb,
        0xc0, 0xc1, 0xc2, 0xc3, 0xc8, 0xc9, 0xca, 0xcb,
        0xd0, 0xd1, 0xd2, 0xd3, 0xd8, 0xd9, 0xda, 0xdb,
        0xe0, 0xe1, 0xe2, 0xe3, 0xe8, 0xe9, 0xea, 0xeb,
        0xf0, 0xf1, 0xf2, 0xf3, 0xf8, 0xf9, 0xfa, 0xfb },

    0x0c, // every combination of G as Pixels 0x00-0xff
      { 0x00, 0x01, 0x04, 0x05, 0x08, 0x09, 0x0c, 0x0d,
        0x10, 0x11, 0x14, 0x15, 0x18, 0x19, 0x1c, 0x1d,
        0x20, 0x21, 0x24, 0x25, 0x28, 0x29, 0x2c, 0x2d,
        0x30, 0x31, 0x34, 0x35, 0x38, 0x39, 0x3c, 0x3d,
        0x40, 0x41, 0x44, 0x45, 0x48, 0x49, 0x4c, 0x4d,
        0x50, 0x51, 0x54, 0x55, 0x58, 0x59, 0x5c, 0x5d,
        0x60, 0x61, 0x64, 0x65, 0x68, 0x69, 0x6c, 0x6d,
        0x70, 0x71, 0x74, 0x75, 0x78, 0x79, 0x7c, 0x7d,
        0x80, 0x81, 0x84, 0x85, 0x88, 0x89, 0x8c, 0x8d,
        0x90, 0x91, 0x94, 0x95, 0x98, 0x99, 0x9c, 0x9d,
        0xa0, 0xa1, 0xa4, 0xa5, 0xa8, 0xa9, 0xac, 0xad,
        0xb0, 0xb1, 0xb4, 0xb5, 0xb8, 0xb9, 0xbc, 0xbd,
        0xc0, 0xc1, 0xc4, 0xc5, 0xc8, 0xc9, 0xcc, 0xcd,
        0xd0, 0xd1, 0xd4, 0xd5, 0xd8, 0xd9, 0xdc, 0xdd,
        0xe0, 0xe1, 0xe4, 0xe5, 0xe8, 0xe9, 0xec, 0xed,
        0xf0, 0xf1, 0xf4, 0xf5, 0xf8, 0xf9, 0xfc, 0xfd },

    0x03, // every combination of H as Pixels 0x00-0xff
      { 0x00, 0x02, 0x04, 0x06, 0x08, 0x0a, 0x0c, 0x0e,
        0x10, 0x12, 0x14, 0x16, 0x18, 0x1a, 0x1c, 0x1e,
        0x20, 0x22, 0x24, 0x26, 0x28, 0x2a, 0x2c, 0x2e,
        0x30, 0x32, 0x34, 0x36, 0x38, 0x3a, 0x3c, 0x3e,
        0x40, 0x42, 0x44, 0x46, 0x48, 0x4a, 0x4c, 0x4e,
        0x50, 0x52, 0x54, 0x56, 0x58, 0x5a, 0x5c, 0x5e,
        0x60, 0x62, 0x64, 0x66, 0x68, 0x6a, 0x6c, 0x6e,
        0x70, 0x72, 0x74, 0x76, 0x78, 0x7a, 0x7c, 0x7e,
        0x80, 0x82, 0x84, 0x86, 0x88, 0x8a, 0x8c, 0x8e,
        0x90, 0x92, 0x94, 0x96, 0x98, 0x9a, 0x9c, 0x9e,
        0xa0, 0xa2, 0xa4, 0xa6, 0xa8, 0xaa, 0xac, 0xae,
        0xb0, 0xb2, 0xb4, 0xb6, 0xb8, 0xba, 0xbc, 0xbe,
        0xc0, 0xc2, 0xc4, 0xc6, 0xc8, 0xca, 0xcc, 0xce,
        0xd0, 0xd2, 0xd4, 0xd6, 0xd8, 0xda, 0xdc, 0xde,
        0xe0, 0xe2, 0xe4, 0xe6, 0xe8, 0xea, 0xec, 0xee,
        0xf0, 0xf2, 0xf4, 0xf6, 0xf8, 0xfa, 0xfc, 0xfe },
  },
  { // colour 1
    0xc0, // every combination of E as Pixels 0x00-0xff
      { 0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f,
        0x18, 0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x1e, 0x1f,
        0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f,
        0x38, 0x39, 0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f,
        0x48, 0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f,
        0x58, 0x59, 0x5a, 0x5b, 0x5c, 0x5d, 0x5e, 0x5f,
        0x68, 0x69, 0x6a, 0x6b, 0x6c, 0x6d, 0x6e, 0x6f,
        0x78, 0x79, 0x7a, 0x7b, 0x7c, 0x7d, 0x7e, 0x7f,
        0x88, 0x89, 0x8a, 0x8b, 0x8c, 0x8d, 0x8e, 0x8f,
        0x98, 0x99, 0x9a, 0x9b, 0x9c, 0x9d, 0x9e, 0x9f,
        0xa8, 0xa9, 0xaa, 0xab, 0xac, 0xad, 0xae, 0xaf,
        0xb8, 0xb9, 0xba, 0xbb, 0xbc, 0xbd, 0xbe, 0xbf,
        0xc8, 0xc9, 0xca, 0xcb, 0xcc, 0xcd, 0xce, 0xcf,
        0xd8, 0xd9, 0xda, 0xdb, 0xdc, 0xdd, 0xde, 0xdf,
        0xe8, 0xe9, 0xea, 0xeb, 0xec, 0xed, 0xee, 0xef,
        0xf8, 0xf9, 0xfa, 0xfb, 0xfc, 0xfd, 0xfe, 0xff },

    0x30, // every combination of F as Pixels 0x00-0xff
      { 0x04, 0x05, 0x06, 0x07, 0x0c, 0x0d, 0x0e, 0x0f,
        0x14, 0x15, 0x16, 0x17, 0x1c, 0x1d, 0x1e, 0x1f,
        0x24, 0x25, 0x26, 0x27, 0x2c, 0x2d, 0x2e, 0x2f,
        0x34, 0x35, 0x36, 0x37, 0x3c, 0x3d, 0x3e, 0x3f,
        0x44, 0x45, 0x46, 0x47, 0x4c, 0x4d, 0x4e, 0x4f,
        0x54, 0x55, 0x56, 0x57, 0x5c, 0x5d, 0x5e, 0x5f,
        0x64, 0x65, 0x66, 0x67, 0x6c, 0x6d, 0x6e, 0x6f,
        0x74, 0x75, 0x76, 0x77, 0x7c, 0x7d, 0x7e, 0x7f,
        0x84, 0x85, 0x86, 0x87, 0x8c, 0x8d, 0x8e, 0x8f,
        0x94, 0x95, 0x96, 0x97, 0x9c, 0x9d, 0x9e, 0x9f,
        0xa4, 0xa5, 0xa6, 0xa7, 0xac, 0xad, 0xae, 0xaf,
        0xb4, 0xb5, 0xb6, 0xb7, 0xbc, 0xbd, 0xbe, 0xbf,
        0xc4, 0xc5, 0xc6, 0xc7, 0xcc, 0xcd, 0xce, 0xcf,
        0xd4, 0xd5, 0xd6, 0xd7, 0xdc, 0xdd, 0xde, 0xdf,
        0xe4, 0xe5, 0xe6, 0xe7, 0xec, 0xed, 0xee, 0xef,
        0xf4, 0xf5, 0xf6, 0xf7, 0xfc, 0xfd, 0xfe, 0xff },

    0x0c, // every combination of G as Pixels 0x00-0xff
      { 0x02, 0x03, 0x06, 0x07, 0x0a, 0x0b, 0x0e, 0x0f,
        0x12, 0x13, 0x16, 0x17, 0x1a, 0x1b, 0x1e, 0x1f,
        0x22, 0x23, 0x26, 0x27, 0x2a, 0x2b, 0x2e, 0x2f,
        0x32, 0x33, 0x36, 0x37, 0x3a, 0x3b, 0x3e, 0x3f,
        0x42, 0x43, 0x46, 0x47, 0x4a, 0x4b, 0x4e, 0x4f,
        0x52, 0x53, 0x56, 0x57, 0x5a, 0x5b, 0x5e, 0x5f,
        0x62, 0x63, 0x66, 0x67, 0x6a, 0x6b, 0x6e, 0x6f,
        0x72, 0x73, 0x76, 0x77, 0x7a, 0x7b, 0x7e, 0x7f,
        0x82, 0x83, 0x86, 0x87, 0x8a, 0x8b, 0x8e, 0x8f,
        0x92, 0x93, 0x96, 0x97, 0x9a, 0x9b, 0x9e, 0x9f,
        0xa2, 0xa3, 0xa6, 0xa7, 0xaa, 0xab, 0xae, 0xaf,
        0xb2, 0xb3, 0xb6, 0xb7, 0xba, 0xbb, 0xbe, 0xbf,
        0xc2, 0xc3, 0xc6, 0xc7, 0xca, 0xcb, 0xce, 0xcf,
        0xd2, 0xd3, 0xd6, 0xd7, 0xda, 0xdb, 0xde, 0xdf,
        0xe2, 0xe3, 0xe6, 0xe7, 0xea, 0xeb, 0xee, 0xef,
        0xf2, 0xf3, 0xf6, 0xf7, 0xfa, 0xfb, 0xfe, 0xff },

    0x03, // every combination of H as Pixels 0x00-0xff
      { 0x01, 0x03, 0x05, 0x07, 0x09, 0x0b, 0x0d, 0x0f,
        0x11, 0x13, 0x15, 0x17, 0x19, 0x1b, 0x1d, 0x1f,
        0x21, 0x23, 0x25, 0x27, 0x29, 0x2b, 0x2d, 0x2f,
        0x31, 0x33, 0x35, 0x37, 0x39, 0x3b, 0x3d, 0x3f,
        0x41, 0x43, 0x45, 0x47, 0x49, 0x4b, 0x4d, 0x4f,
        0x51, 0x53, 0x55, 0x57, 0x59, 0x5b, 0x5d, 0x5f,
        0x61, 0x63, 0x65, 0x67, 0x69, 0x6b, 0x6d, 0x6f,
        0x71, 0x73, 0x75, 0x77, 0x79, 0x7b, 0x7d, 0x7f,
        0x81, 0x83, 0x85, 0x87, 0x89, 0x8b, 0x8d, 0x8f,
        0x91, 0x93, 0x95, 0x97, 0x99, 0x9b, 0x9d, 0x9f,
        0xa1, 0xa3, 0xa5, 0xa7, 0xa9, 0xab, 0xad, 0xaf,
        0xb1, 0xb3, 0xb5, 0xb7, 0xb9, 0xbb, 0xbd, 0xbf,
        0xc1, 0xc3, 0xc5, 0xc7, 0xc9, 0xcb, 0xcd, 0xcf,
        0xd1, 0xd3, 0xd5, 0xd7, 0xd9, 0xdb, 0xdd, 0xdf,
        0xe1, 0xe3, 0xe5, 0xe7, 0xe9, 0xeb, 0xed, 0xef,
        0xf1, 0xf3, 0xf5, 0xf7, 0xf9, 0xfb, 0xfd, 0xff }
  }
};

#define MODE46NUMCOLS 2

void Mode46ChangeColours()
{
  char * ScreenPtr, * ScreenPtr2;
  int CountY,Count,MinAge,OldestOffset,COffset,Colour;

  MinAge=512;
  OldestOffset=0;
    for (CountY=0; CountY<TABLESIZE; CountY++)
    {
        if (Mode46PalTable[CountY].CurrentPalette[0]==LogicalColours[0] &&
            Mode46PalTable[CountY].CurrentPalette[8]==LogicalColours[8])
        {
          Mode46TableOffset=CountY;
          return;
        }

        if (Mode46PalTable[CountY].Age<MinAge)
        {
          MinAge=Mode46PalTable[CountY].Age;
          OldestOffset=CountY;
        }
    }

  Mode46TableOffset=OldestOffset;
// ScreenPtr now points the to screen table
  ScreenPtr =Mode46PalTable[Mode46TableOffset].LPaletteAddress;
  ScreenPtr2=Mode46PalTable[Mode46TableOffset].RPaletteAddress;


  outpw(0x03ce,0x0205); // write mode 2
  outp(0x03ce,0x08); // bit mask register index

    for (Colour=0; Colour<MODE46NUMCOLS; Colour++)
    {
      COffset=Colour<<3; // *8
        if (LogicalColours[COffset]!=Mode46PalTable[Mode46TableOffset].CurrentPalette[COffset])
        {
          Mode46PalTable[Mode46TableOffset].CurrentPalette[COffset]=LogicalColours[COffset];
          COffset=LogicalColours[COffset];
        
          outp(0x03cf,Mode4Table[Colour].Mask1); // bit mask register
            for (Count=0;Count<0x80;Count++)
            {
              // left
              Byte=*(ScreenPtr+Mode4Table[Colour].Pixels1[Count]);
              (*(ScreenPtr+Mode4Table[Colour].Pixels1[Count]))=COffset;
              // right
              Byte=*(ScreenPtr2+Mode4Table[Colour+2].Pixels1[Count]);
              (*(ScreenPtr2+Mode4Table[Colour+2].Pixels1[Count]))=COffset;
            }

          outp(0x03cf,Mode4Table[Colour].Mask2); // bit mask register
            for (Count=0;Count<0x80;Count++)
            {
              Byte=*(ScreenPtr+Mode4Table[Colour].Pixels2[Count]);
              (*(ScreenPtr+Mode4Table[Colour].Pixels2[Count]))=COffset;

              Byte=*(ScreenPtr2+Mode4Table[Colour+2].Pixels2[Count]);
              (*(ScreenPtr2+Mode4Table[Colour+2].Pixels2[Count]))=COffset;
            }

          outp(0x03cf,Mode4Table[Colour].Mask3); // bit mask register
            for (Count=0;Count<0x80;Count++)
            {
              Byte=*(ScreenPtr+Mode4Table[Colour].Pixels3[Count]);
              (*(ScreenPtr+Mode4Table[Colour].Pixels3[Count]))=COffset;

              Byte=*(ScreenPtr2+Mode4Table[Colour+2].Pixels3[Count]);
              (*(ScreenPtr2+Mode4Table[Colour+2].Pixels3[Count]))=COffset;
            }

          outp(0x03cf,Mode4Table[Colour].Mask4); // bit mask register
            for (Count=0;Count<0x80;Count++)
            {
              Byte=*(ScreenPtr+Mode4Table[Colour].Pixels4[Count]);
              (*(ScreenPtr+Mode4Table[Colour].Pixels4[Count]))=COffset;

              Byte=*(ScreenPtr2+Mode4Table[Colour+2].Pixels4[Count]);
              (*(ScreenPtr2+Mode4Table[Colour+2].Pixels4[Count]))=COffset;
            }
        }
    }
  outp(0x03cf,0xff); // bit mask register
  outpw(0x03ce,0x0105); // write mode 1
  OldColoursChanged=FALSE;
}
