/* -------------------------------------------------------------------------- */
/*                                                                            */
/* (C) Copyright D.C.Devenport 1997. All right reserved.                      */
/*                                                                            */
/* THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY      */
/* KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE        */
/* IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR      */
/* PURPOSE.                                                                   */
/*                                                                            */
/* This code, and no part of this code, may not be used in any                */
/* commercial or for-profit venture without the express written               */
/* permission of D.C.Devenport. (DDevenp666@aol.com)                          */
/*                                                                            */
/* Credit must be given within any program that uses any of this code         */
/* OR in the accompanying documentation. (And mail me a copy :) )             */
/*                                                                            */
/*----------------------------------------------------------------------------*/
#include <ctype.h>
#include <stdio.h>
#include <string.h>
#include "bbc.h"
#include "fs.h"

char DirectoryLetter[2];
char BBCFileName[256];

static struct SaveArgType
{ 
  WORD FileNameAddress;
  WORD LoadAddress;
  WORD D;
  WORD ExecAddress;
  WORD D1;
  WORD StartAddress;
  WORD D2;
  WORD EndAddress;
  WORD D3;
};

static struct LoadArgType
{ 
  WORD FileNameAddress;
  WORD LoadAddress;
  WORD D;
  WORD ExecAddress;
  WORD D1;
  WORD Length;
  WORD D2;
  WORD Attributes;
  WORD D3;
};

static union FileArgType
{
  struct SaveArgType Save;
  struct LoadArgType Load;
} * FS;


void OSFILE()
{
  FS=(union FileArgType *) &AddressSpace[ (Processor.YReg<<8)+Processor.XReg ];

  ParseName(GetVectoredFSString((Processor.YReg<<8)+Processor.XReg,0));

  Processor.CFlag=0; // no text to display
  Processor.VFlag=0; // no error

    switch (Processor.AReg)
    {
      case 0 : // save block of memory
               SaveFile();
               break;
      case 0xff : // load named file, if exec lo=0 use address in perameter
                  // block, else use the files load address
               LoadFile();
               break;

      case 1 : // write info in perameter block to catalogue entry for file
      case 2 : // write load address only for an existing file
      case 3 : // write exec address only for an existing file
      case 4 : // write the attributes only for an existing file
      case 5 : // Read files catalogue info to perameter block,
               // file type returned in A
      case 6 : // delete named file
               FatalError("Not yet added OSFILE command %.2x",Processor.AReg);

      default : FatalError("Unknown OSFILE command %.2x",Processor.AReg);
    }
}


static WORD GetHex(FILE * F)
{
  WORD Num=0;
  char Ch;

    do // skip past all spaces
    {
      Ch=fgetc(F);
    }
    while (Ch==' ' && !feof(F));

    do
    {
        if (Ch>='0' && Ch<='9')
        {
          Num<<=4;
          Num+=(Ch-'0');
        }
        else if (Ch>='A' && Ch<='F')
        {
          Num<<=4;
          Num+=(Ch-'A')+0xa;
        }
      Ch=toupper(fgetc(F));
    } while (Ch!=' ' && !feof(F));

  return Num;
}


static void ParseName(char * OriginalName)
{
  char * From=BBCFileName,*To=BBCFileName;
  int AddDirectory=1;

  strcpy(BBCFileName,OriginalName);

    while (*From!=0 && *From!=' ')
    {
      *To=*From;
        if (*From=='.')
          AddDirectory=0;
        else if (*From!=':' &&  *From!='?' && *From!='$')
          To++;
      From++;
    }
  *To=0;

    if (AddDirectory)
    {
      char S[256];

      strcpy(S,BBCFileName);
      strcpy(BBCFileName,DirectoryLetter);
      strcat(BBCFileName,S);
    }
}


static void LoadFile()
{
  char  S[1024];

  WORD  Load,Exec;
  FILE * F;
  char  Ch;

  strcpy(S,BBCFileName);
  strcat(S,".inf");

  F=fopen(S,"rt");
    if (F==NULL)
    {
      FSError(0xd6);
      return;
    }

    do // skip past name
    {
      Ch=fgetc(F);
    } while (Ch!=' ');

  Load=GetHex(F);

  Exec=GetHex(F);
  fclose(F);

    if ((FS->Load.ExecAddress & 0xff)==0) // use address supplied
      Load=FS->Load.LoadAddress;

    if (Load>0x7fff)
      return;

  F=fopen(BBCFileName,"rb");
    if (F==NULL)
    {
      FSError(0xd6);
      return;
    }

  fread(&AddressSpace[Load],1,0x8000-Load,F);
  fclose(F);
}


void SaveFile()
{
  char S[1024];
  WORD Length;

  FILE * F;

  Length=FS->Save.EndAddress-FS->Save.StartAddress;


  strcpy(S,BBCFileName);
  strcat(S,".inf");

  F=fopen(S,"wt");
    if (F==NULL)
      FatalError("FILE : %s not created",S);

  fprintf(F,"%s %.4x %.4x %.4x\n",BBCFileName,
          FS->Save.StartAddress,
          FS->Save.ExecAddress,
          Length);
  fclose(F);

  F=fopen(BBCFileName,"wb");
    if (F==NULL)
      FatalError("FILE : %s not created",BBCFileName);

  fwrite(&AddressSpace[FS->Save.StartAddress],1,Length,F);
  fclose(F);

}


int ExecFile() // assumes Y<<8+X points to filename
{
  char  S[1024];

  WORD  Load,Exec;
  FILE * F;
  char  Ch;

  ParseName(GetFSString((Processor.YReg<<8)+Processor.XReg));

  strcpy(S,BBCFileName);
  strcat(S,".inf");

  F=fopen(S,"rt");
    if (F==NULL)
      return 0;

    do // skip past name
    {
      Ch=fgetc(F);
    } while (Ch!=' ');

  Load=GetHex(F);

  Exec=GetHex(F);
  fclose(F);

    if (Load>0x7fff)
      return 0;

  F=fopen(BBCFileName,"rb");
    if (F==NULL)
      return 0;

  fread(&AddressSpace[Load],1,0x8000-Load,F);
  fclose(F);

  Processor.PC.WordValue=Exec;
  return 1;
}
