/* -------------------------------------------------------------------------- */
/*                                                                            */
/* (C) Copyright D.C.Devenport 1998. All right reserved.                      */
/*                                                                            */
/* THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY      */
/* KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE        */
/* IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR      */
/* PURPOSE.                                                                   */
/*                                                                            */
/* This code, and no part of this code, may not be used in any                */
/* commercial or for-profit venture without the express written               */
/* permission of D.C.Devenport. (BeebInC@aol.com)                             */
/*                                                                            */
/* Credit must be given within any program that uses any of this code         */
/* OR in the accompanying documentation. (And mail me a copy :) )             */
/*                                                                            */
/*----------------------------------------------------------------------------*/
#include <i86.h>
#include <conio.h>

#include "bbc.h"
#include "modex.h"

static struct Mode1PaletteType
{
  const char * PaletteAddress;
  int Age;
  BYTE CurrentPalette[NUMCOLS];
} Mode1PalTable[TABLESIZE]=
{
  { (char *) 0xab000, 0, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } },
  { (char *) 0xab100, 0, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } },
  { (char *) 0xab200, 0, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } },
  { (char *) 0xab300, 0, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } },
  { (char *) 0xab400, 0, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } },
  { (char *) 0xab500, 0, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } },
  { (char *) 0xab600, 0, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } },
  { (char *) 0xab700, 0, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } },
  { (char *) 0xab800, 0, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } },
  { (char *) 0xab900, 0, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } }
};

static int    Mode1TableOffset=0;


void ClearMode1Colours()
{
  int CountX,CountY;
    for (CountY=0; CountY<TABLESIZE; CountY++)
    {
        for (CountX=0; CountX<16; CountX++)
          Mode1PalTable[CountY].CurrentPalette[CountX]=17;
      Mode1PalTable[CountY].Age=0;
    }
  Mode1TableOffset=0;
}


void AgeMode1()
{
  int CountY;
    for (CountY=0; CountY<TABLESIZE; CountY++)
       Mode1PalTable[CountY].Age>>=1;
}


void DisplayMode1Screen()
{
// mode1, 0xff mask, access to all planes

    if (ColoursChanged)
      Mode1ChangeColours();

  Mode1PalTable[Mode1TableOffset].Age+=256;
  ModeXLookup=(DWORD) Mode1PalTable[Mode1TableOffset].PaletteAddress;
  Plot20K();
}

void DisplayMode1Row()
{
// mode1, 0xff mask, access to all planes

    if (ColoursChanged)
    {
      Mode1ChangeColours();
      ModeXLookup=(DWORD) Mode1PalTable[Mode1TableOffset].PaletteAddress;
    }

  Mode1PalTable[Mode1TableOffset].Age+=4;
  Plot80Row();
}

void DisplayMode1Line()
{
// mode1, 0xff mask, access to all planes

    if (ColoursChanged)
    {
      Mode1ChangeColours();
      ModeXLookup=(DWORD) Mode1PalTable[Mode1TableOffset].PaletteAddress;
    }

  Mode1PalTable[Mode1TableOffset].Age++;
  Plot80Row();
}


const struct MODE1 // A screen memory byte is in the format of ABCDABCD
{
  char Colours1[0x40];
  char Colours2[0x40];
  char Colours3[0x40];
  char Colours4[0x40];

} Mode1Table[]=
{
  { // colour 0
    // every combination of A as colour 0
      { 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
        0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17,
        0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27,
        0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37,
        0x40, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47,
        0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57,
        0x60, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67,
        0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77 },

    // every combination of B as colour 0
      { 0x00, 0x01, 0x02, 0x03, 0x08, 0x09, 0x0a, 0x0b,
        0x10, 0x11, 0x12, 0x13, 0x18, 0x19, 0x1a, 0x1b,
        0x20, 0x21, 0x22, 0x23, 0x28, 0x29, 0x2a, 0x2b,
        0x30, 0x31, 0x32, 0x33, 0x38, 0x39, 0x3a, 0x3b,
        0x80, 0x81, 0x82, 0x83, 0x88, 0x89, 0x8a, 0x8b,
        0x90, 0x91, 0x92, 0x93, 0x98, 0x99, 0x9a, 0x9b,
        0xa0, 0xa1, 0xa2, 0xa3, 0xa8, 0xa9, 0xaa, 0xab,
        0xb0, 0xb1, 0xb2, 0xb3, 0xb8, 0xb9, 0xba, 0xbb },

    // every combination of C as Pixels
      { 0x00, 0x01, 0x04, 0x05, 0x08, 0x09, 0x0c, 0x0d,
        0x10, 0x11, 0x14, 0x15, 0x18, 0x19, 0x1c, 0x1d,
        0x40, 0x41, 0x44, 0x45, 0x48, 0x49, 0x4c, 0x4d,
        0x50, 0x51, 0x54, 0x55, 0x58, 0x59, 0x5c, 0x5d,
        0x80, 0x81, 0x84, 0x85, 0x88, 0x89, 0x8c, 0x8d,
        0x90, 0x91, 0x94, 0x95, 0x98, 0x99, 0x9c, 0x9d,
        0xc0, 0xc1, 0xc4, 0xc5, 0xc8, 0xc9, 0xcc, 0xcd,
        0xd0, 0xd1, 0xd4, 0xd5, 0xd8, 0xd9, 0xdc, 0xdd },

    // every combination of D as Pixels
      { 0x00, 0x02, 0x04, 0x06, 0x08, 0x0a, 0x0c, 0x0e,
        0x20, 0x22, 0x24, 0x26, 0x28, 0x2a, 0x2c, 0x2e,
        0x40, 0x42, 0x44, 0x46, 0x48, 0x4a, 0x4c, 0x4e,
        0x60, 0x62, 0x64, 0x66, 0x68, 0x6a, 0x6c, 0x6e,
        0x80, 0x82, 0x84, 0x86, 0x88, 0x8a, 0x8c, 0x8e,
        0xa0, 0xa2, 0xa4, 0xa6, 0xa8, 0xaa, 0xac, 0xae,
        0xc0, 0xc2, 0xc4, 0xc6, 0xc7, 0xca, 0xcc, 0xce,
        0xe0, 0xe2, 0xe4, 0xe6, 0xe8, 0xea, 0xec, 0xee }
  },

  { // colour 1
    // every combination of A as Pixels
      { 0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f,
        0x18, 0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x1e, 0x1f,
        0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f,
        0x38, 0x39, 0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f,
        0x48, 0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f,
        0x58, 0x59, 0x5a, 0x5b, 0x5c, 0x5d, 0x5e, 0x5f,
        0x68, 0x69, 0x6a, 0x6b, 0x6c, 0x6d, 0x6e, 0x6f,
        0x78, 0x79, 0x7a, 0x7b, 0x7c, 0x7d, 0x7e, 0x7f },

    // every combination of B as Pixels
      { 0x04, 0x05, 0x06, 0x07, 0x0c, 0x0d, 0x0e, 0x0f,
        0x14, 0x15, 0x16, 0x17, 0x1c, 0x1d, 0x1e, 0x1f,
        0x24, 0x25, 0x26, 0x27, 0x2c, 0x2d, 0x2e, 0x2f,
        0x34, 0x35, 0x36, 0x37, 0x3c, 0x3d, 0x3e, 0x3f,
        0x84, 0x85, 0x86, 0x87, 0x8c, 0x8d, 0x8e, 0x8f,
        0x94, 0x95, 0x96, 0x97, 0x9c, 0x9d, 0x9e, 0x9f,
        0xa4, 0xa5, 0xa6, 0xa7, 0xac, 0xad, 0xae, 0xaf,
        0xb4, 0xb5, 0xb6, 0xb7, 0xbc, 0xbd, 0xbe, 0xbf },
        
    // every combination of C as Pixels
      { 0x02, 0x03, 0x06, 0x07, 0x0a, 0x0b, 0x0e, 0x0f,
        0x12, 0x13, 0x16, 0x17, 0x1a, 0x1b, 0x1e, 0x1f,
        0x42, 0x43, 0x46, 0x47, 0x4a, 0x4b, 0x4e, 0x4f,
        0x52, 0x53, 0x56, 0x57, 0x5a, 0x5b, 0x5e, 0x5f,
        0x82, 0x83, 0x86, 0x87, 0x8a, 0x8b, 0x8e, 0x8f,
        0x92, 0x93, 0x96, 0x97, 0x9a, 0x9b, 0x9e, 0x9f,
        0xc2, 0xc3, 0xc6, 0xc7, 0xca, 0xcb, 0xce, 0xcf,
        0xd2, 0xd3, 0xd6, 0xd7, 0xda, 0xdb, 0xde, 0xdf },

    // every combination of D as Pixels
      { 0x01, 0x03, 0x05, 0x07, 0x09, 0x0b, 0x0d, 0x0f,
        0x21, 0x23, 0x25, 0x27, 0x29, 0x2b, 0x2d, 0x2f,
        0x41, 0x43, 0x45, 0x47, 0x49, 0x4b, 0x4d, 0x4f,
        0x61, 0x63, 0x65, 0x67, 0x69, 0x6b, 0x6d, 0x6f,
        0x81, 0x83, 0x85, 0x87, 0x89, 0x8b, 0x8d, 0x8f,
        0xa1, 0xa3, 0xa5, 0xa7, 0xa9, 0xab, 0xad, 0xaf,
        0xc1, 0xc3, 0xc5, 0xc7, 0xc9, 0xcb, 0xcd, 0xcf,
        0xe1, 0xe3, 0xe5, 0xe7, 0xe9, 0xeb, 0xed, 0xef }
  },

  { // colour 2
    // every combination of A as Pixels
      { 0x80, 0x81, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87,
        0x90, 0x91, 0x92, 0x93, 0x94, 0x95, 0x96, 0x97,
        0xa0, 0xa1, 0xa2, 0xa3, 0xa4, 0xa5, 0xa6, 0xa7,
        0xb0, 0xb1, 0xb2, 0xb3, 0xb4, 0xb5, 0xb6, 0xb7,
        0xc0, 0xc1, 0xc2, 0xc3, 0xc4, 0xc5, 0xc6, 0xc7,
        0xd0, 0xd1, 0xd2, 0xd3, 0xd4, 0xd5, 0xd6, 0xd7,
        0xe0, 0xe1, 0xe2, 0xe3, 0xe4, 0xe5, 0xe6, 0xe7,
        0xf0, 0xf1, 0xf2, 0xf3, 0xf4, 0xf5, 0xf6, 0xf7 },

    // every combination of B as Pixels
      { 0x40, 0x41, 0x42, 0x43, 0x48, 0x49, 0x4a, 0x4b,
        0x50, 0x51, 0x52, 0x53, 0x58, 0x59, 0x5a, 0x5b,
        0x60, 0x61, 0x62, 0x63, 0x68, 0x69, 0x6a, 0x6b,
        0x70, 0x71, 0x72, 0x73, 0x78, 0x79, 0x7a, 0x7b,
        0xc0, 0xc1, 0xc2, 0xc3, 0xc8, 0xc9, 0xca, 0xcb,
        0xd0, 0xd1, 0xd2, 0xd3, 0xd8, 0xd9, 0xda, 0xdb,
        0xe0, 0xe1, 0xe2, 0xe3, 0xe8, 0xe9, 0xea, 0xeb,
        0xf0, 0xf1, 0xf2, 0xf3, 0xf8, 0xf9, 0xfa, 0xfb },

    // every combination of C as Pixels
      { 0x20, 0x21, 0x24, 0x25, 0x28, 0x29, 0x2c, 0x2d,
        0x30, 0x31, 0x34, 0x35, 0x38, 0x39, 0x3c, 0x3d,
        0x60, 0x61, 0x64, 0x65, 0x68, 0x69, 0x6c, 0x6d,
        0x70, 0x71, 0x74, 0x75, 0x78, 0x79, 0x7c, 0x7d,
        0xa0, 0xa1, 0xa4, 0xa5, 0xa8, 0xa9, 0xac, 0xad,
        0xb0, 0xb1, 0xb4, 0xb5, 0xb8, 0xb9, 0xbc, 0xbd,
        0xe0, 0xe1, 0xe4, 0xe5, 0xe8, 0xe9, 0xec, 0xed,
        0xf0, 0xf1, 0xf4, 0xf5, 0xf8, 0xf9, 0xfc, 0xfd },

    // every combination of D as Pixels
      { 0x10, 0x12, 0x14, 0x16, 0x18, 0x1a, 0x1c, 0x1e,
        0x30, 0x32, 0x34, 0x36, 0x38, 0x3a, 0x3c, 0x3e,
        0x50, 0x52, 0x54, 0x56, 0x58, 0x5a, 0x5c, 0x5e,
        0x70, 0x72, 0x74, 0x76, 0x78, 0x7a, 0x7c, 0x7e,
        0x90, 0x92, 0x94, 0x96, 0x98, 0x9a, 0x9c, 0x9e,
        0xb0, 0xb2, 0xb4, 0xb6, 0xb8, 0xba, 0xbc, 0xbe,
        0xd0, 0xd2, 0xd4, 0xd6, 0xd8, 0xda, 0xdc, 0xde,
        0xf0, 0xf2, 0xf4, 0xf6, 0xf8, 0xfa, 0xfc, 0xfe }
  },

  { // colour 3
    // every combination of A as Pixels
      { 0x88, 0x89, 0x8a, 0x8b, 0x8c, 0x8d, 0x8e, 0x8f,
        0x98, 0x99, 0x9a, 0x9b, 0x9c, 0x9d, 0x9e, 0x9f,
        0xa8, 0xa9, 0xaa, 0xab, 0xac, 0xad, 0xae, 0xaf,
        0xb8, 0xb9, 0xba, 0xbb, 0xbc, 0xbd, 0xbe, 0xbf,
        0xc8, 0xc9, 0xca, 0xcb, 0xcc, 0xcd, 0xce, 0xcf,
        0xd8, 0xd9, 0xda, 0xdb, 0xdc, 0xdd, 0xde, 0xdf,
        0xe8, 0xe9, 0xea, 0xeb, 0xec, 0xed, 0xee, 0xef,
        0xf8, 0xf9, 0xfa, 0xfb, 0xfc, 0xfd, 0xfe, 0xff },

    // every combination of B as Pixels
      { 0x44, 0x45, 0x46, 0x47, 0x4c, 0x4d, 0x4e, 0x4f,
        0x54, 0x55, 0x56, 0x57, 0x5c, 0x5d, 0x5e, 0x5f,
        0x64, 0x65, 0x66, 0x67, 0x6c, 0x6d, 0x6e, 0x6f,
        0x74, 0x75, 0x76, 0x77, 0x7c, 0x7d, 0x7e, 0x7f,
        0xc4, 0xc5, 0xc6, 0xc7, 0xcc, 0xcd, 0xce, 0xcf,
        0xd4, 0xd5, 0xd6, 0xd7, 0xdc, 0xdd, 0xde, 0xdf,
        0xe4, 0xe5, 0xe6, 0xe7, 0xec, 0xed, 0xee, 0xef,
        0xf4, 0xf5, 0xf6, 0xf7, 0xfc, 0xfd, 0xfe, 0xff },

    // every combination of C as Pixels
      { 0x22, 0x23, 0x26, 0x27, 0x2a, 0x2b, 0x2e, 0x2f,
        0x32, 0x33, 0x36, 0x37, 0x3a, 0x3b, 0x3e, 0x3f,
        0x62, 0x63, 0x66, 0x67, 0x6a, 0x6b, 0x6e, 0x6f,
        0x72, 0x73, 0x76, 0x77, 0x7a, 0x7b, 0x7e, 0x7f,
        0xa2, 0xa3, 0xa6, 0xa7, 0xaa, 0xab, 0xae, 0xaf,
        0xb2, 0xb3, 0xb6, 0xb7, 0xba, 0xbb, 0xbe, 0xbf,
        0xe2, 0xe3, 0xe6, 0xe7, 0xea, 0xeb, 0xee, 0xef,
        0xf2, 0xf3, 0xf6, 0xf7, 0xfa, 0xfb, 0xfe, 0xff },

    // every combination of D as Pixels
      { 0x11, 0x13, 0x15, 0x17, 0x19, 0x1b, 0x1d, 0x1f,
        0x31, 0x33, 0x35, 0x37, 0x39, 0x3b, 0x3d, 0x3f,
        0x51, 0x53, 0x55, 0x57, 0x59, 0x5b, 0x5d, 0x5f,
        0x71, 0x73, 0x75, 0x77, 0x79, 0x7b, 0x7d, 0x7f,
        0x91, 0x93, 0x95, 0x97, 0x99, 0x9b, 0x9d, 0x9f,
        0xb1, 0xb3, 0xb5, 0xb7, 0xb9, 0xbb, 0xbd, 0xbf,
        0xd1, 0xd3, 0xd5, 0xd7, 0xd9, 0xdb, 0xdd, 0xdf,
        0xf1, 0xf3, 0xf5, 0xf7, 0xf9, 0xfb, 0xfd, 0xff }
  }
};

#define MODE1NUMCOLS 4

void Mode1ChangeColours()
{ 
  const BYTE Mode1ColourOffset[]={ 0, 2, 8, 0xa };
  char * ScreenPtr;
  int TableOffset,Count,MinAge,Colour,OldestOffset,COffset,MatchOffset,MatchCount,
      NumberMatched;

  OldestOffset=0;
  MinAge=512;
  MatchOffset=0;
  MatchCount=0;
    for (TableOffset=0; TableOffset<TABLESIZE; TableOffset++)
    {
      NumberMatched=0;
        for (Colour=0; Colour<MODE1NUMCOLS; Colour++)
        {
          COffset=Mode1ColourOffset[Colour];

            if (Mode1PalTable[TableOffset].CurrentPalette[COffset]==
                                           LogicalColours[COffset])
              NumberMatched++;
        }

        if (NumberMatched==MODE1NUMCOLS)
        {
          Mode1TableOffset=TableOffset; // table exists, cool!
          return;
        }
        else if (NumberMatched>MatchCount)
        {
          MatchCount=NumberMatched;
          MatchOffset=TableOffset;
        }

        if (Mode1PalTable[TableOffset].Age<MinAge)
        {
          MinAge=Mode1PalTable[TableOffset].Age;
          OldestOffset=TableOffset;
        }
    }

  Mode1TableOffset=OldestOffset;
// ScreenPtr now points the to screen table
  ScreenPtr=Mode1PalTable[Mode1TableOffset].PaletteAddress;
    if (MatchCount>0 && Mode1TableOffset!=MatchOffset) // copy a palette across
    {
      char * To, * From;

      To=ScreenPtr;
      From=Mode1PalTable[MatchOffset].PaletteAddress;
        for (Count=0; Count<256; Count++)
          *(To++)=*(From++);

        for (Colour=0; Colour<MODE1NUMCOLS; Colour++)
        {
          COffset=Mode1ColourOffset[Colour];
            
          Mode1PalTable[Mode1TableOffset].CurrentPalette[COffset]=
                  Mode1PalTable[MatchOffset].CurrentPalette[COffset];
        }
    }


  outpw(0x03ce,0x0205); // write mode 2

  outp(0x3ce,8); // bit mask index register

    for (Colour=0; Colour<MODE1NUMCOLS; Colour++)
    {
      COffset=Mode1ColourOffset[Colour];

//        if (LogicalColours[COffset]!=Mode1PalTable[Mode1TableOffset].CurrentPalette[COffset])
        {
          Mode1PalTable[Mode1TableOffset].CurrentPalette[COffset]=LogicalColours[COffset];
          COffset=LogicalColours[COffset];

          outp(0x03cf,0xc0); // bit mask register
            for (Count=0;Count<0x40;Count++)
            {
              Byte=*(ScreenPtr+Mode1Table[Colour].Colours1[Count]);
              (*(ScreenPtr+Mode1Table[Colour].Colours1[Count]))=COffset;
            }
          outp(0x03cf,0x30); // bit mask register
            for (Count=0;Count<0x40;Count++)
            {
              Byte=*(ScreenPtr+Mode1Table[Colour].Colours2[Count]);
              (*(ScreenPtr+Mode1Table[Colour].Colours2[Count]))=COffset;
            }
          outp(0x03cf,0x0c); // bit mask register
            for (Count=0;Count<0x40;Count++)
            {
              Byte=*(ScreenPtr+Mode1Table[Colour].Colours3[Count]);
              (*(ScreenPtr+Mode1Table[Colour].Colours3[Count]))=COffset;
            }
          outp(0x03cf,0x03); // bit mask register
            for (Count=0;Count<0x40;Count++)
            {
              Byte=*(ScreenPtr+Mode1Table[Colour].Colours4[Count]);
              (*(ScreenPtr+Mode1Table[Colour].Colours4[Count]))=COffset;
            }
        }
    }
  outp(0x03cf,0xff); // bit mask register
  outpw(0x03ce,0x0105); // write mode 1
  ColoursChanged=FALSE;
}
