/* -------------------------------------------------------------------------- */
/*                                                                            */
/* (C) Copyright D.C.Devenport 1998. All right reserved.                      */
/*                                                                            */
/* THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY      */
/* KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE        */
/* IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR      */
/* PURPOSE.                                                                   */
/*                                                                            */
/* This code, and no part of this code, may not be used in any                */
/* commercial or for-profit venture without the express written               */
/* permission of D.C.Devenport. (BeebInC@aol.com)                             */
/*                                                                            */
/* Credit must be given within any program that uses any of this code         */
/* OR in the accompanying documentation. (And mail me a copy :) )             */
/*                                                                            */
/*----------------------------------------------------------------------------*/
#include <i86.h>
#include <conio.h>
#include <stdio.h>
#include "bbc.h"
#include "sysvia.h"
#include "matrix.h"
#include "key.h"
#include "6502.h"
#include "modexc.h"

// [PA4-PA6] [PA0-PA3]
// [PA7] = keypress state
// CA2 - keypress pulse on here
// BREAK KEY WIRED DIRECTLY TO RESET LINE

BYTE SHIFTLock,CAPSLock,MotorLED,Drive02LED,Drive13LED;
volatile int NumberOfKeysPressed=0,ExtraKeysPressed=0;

static volatile BYTE KeyBoardMatrix[8][0x10];
static volatile int DoRowScan=0;

void ResetKeyboard()
{
  short CountX,CountY;

  // do not clear the links (row 0)
  
    for (CountX=1; CountX<8; CountX++)
        for (CountY=0; CountY<10; CountY++)
          KeyBoardMatrix[CountX][CountY]=0;
  NumberOfKeysPressed=0;
}


void BBCKey(BYTE Flag,BYTE Key)
{
  BYTE Old=KeyBoardMatrix[Key>>4][Key & 0xf];

  KeyBoardMatrix[Key>>4][Key & 0xf]=Flag;
    if (Old!=Flag)
    {
        if (!Old)
        {
            if ((Key>>4)>0)
              NumberOfKeysPressed++;
            else
              ExtraKeysPressed++;
        }
        else
        {
            if ((Key>>4)>0)
              NumberOfKeysPressed--;
            else
              ExtraKeysPressed--;
        }
    }

    if ((Key>>4)>0)
      SetSysCA2(Flag);
}


BYTE ReadKeyboard(BYTE Key)
{
  Key&=0x7f;

    if ((Key & 0xf)>=0xa) // illegal values dealt with.... not pressed
    {                     // they also clear the interrupt line (probably)...
        if ((Key & 0xf)==0xf)
          DoRowScan=1;
      return (Key);
    }

    if (KeyBoardMatrix[Key>>4][Key & 0xf]>0)
      Key|=0x80;

//    if (DoRowScan)
    {
        if  ( (KeyBoardMatrix[1][Key & 0xf]) ||
              (KeyBoardMatrix[2][Key & 0xf]) ||
              (KeyBoardMatrix[3][Key & 0xf]) ||
              (KeyBoardMatrix[4][Key & 0xf]) ||
              (KeyBoardMatrix[5][Key & 0xf]) ||
              (KeyBoardMatrix[6][Key & 0xf]) ||
              (KeyBoardMatrix[7][Key & 0xf]) )
          SetSysCA2(2); // special case!
    }
  DoRowScan=0;

  return(Key);
}


void CAPSLockOn()
{
  CAPSLock=CAPS_ON;
}

void CAPSLockOff()
{
  CAPSLock=CAPS_OFF;
}

void SHIFTLockOn()
{
  SHIFTLock=SHIFT_ON;
}

void SHIFTLockOff()
{
  SHIFTLock=SHIFT_OFF;
}

void DumpMatrix(FILE * FileHandle)
{
  short CountX,CountY;
    for (CountX=0; CountX<8; CountX++)
    {
        for (CountY=0; CountY<=10; CountY++)
        {
          fprintf(FileHandle,"%2x  ",KeyBoardMatrix[CountX][CountY]);
        }
      fprintf(FileHandle,"\n");
    }

  fprintf(FileHandle,"Keys pressed %d  Extra Keys pressed %d  DoRowScan %d\n",
          NumberOfKeysPressed,ExtraKeysPressed,DoRowScan);

}




/*
  if (Processor.PC.ByteValue.Hi<0x80)
  {
    FILE * F=fopen("KEY.LOG","at+");
    fprintf(F,"Key read %2x ",Key);
    Dump6502(F);
    fclose(F);
  }
*/

/*
        if (Flag)
        {
          // transition (1)-to+
            if (NumberOfKeysPressed==1)
              SetSysCA2(Flag);
        }
        else
        {
          // transition (0)+to-
            if (NumberOfKeysPressed==0) 
              SetSysCA2(Flag);
        }
*/
