/* -------------------------------------------------------------------------- */
/*                                                                            */
/* (C) Copyright D.C.Devenport 1998. All right reserved.                      */
/*                                                                            */
/* THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY      */
/* KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE        */
/* IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR      */
/* PURPOSE.                                                                   */
/*                                                                            */
/* This code, and no part of this code, may not be used in any                */
/* commercial or for-profit venture without the express written               */
/* permission of D.C.Devenport. (BeebInC@aol.com)                             */
/*                                                                            */
/* Credit must be given within any program that uses any of this code         */
/* OR in the accompanying documentation. (And mail me a copy :) )             */
/*                                                                            */
/*----------------------------------------------------------------------------*/
#include <string.h>
#include "6502.h"
#include "bbc.h"
#include "fs.h"

static FILE * TextFile=NULL;
static int ReturnAReg;

#define TEXTMSGRETURNAREG AddressSpace[0xb5]

static struct FSErrorType
{
  WORD Number;
  char * String;
} ErrorTable[]=
{
  { 0xbd,"Not enabled" },
  { 0xbe,"Catalogue full" },
  { 0xbf,"Can't extend" },
  { 0xc0,"Too many open files" },
  { 0xc1,"File read only" },
  { 0xc2,"File open" },
  { 0xc3,"File locked" },
  { 0xc4,"File exists" },
  { 0xc5,"Drive fault" },
  { 0xc6,"Disc full" },
  { 0xc7,"Disc" },
  { 0xc8,"Disc changed" },
  { 0xc9,"Disc read only" },
  { 0xca,"Bad sum" },
  { 0xcb,"Bad option" },
  { 0xcc,"Bad filename" },
  { 0xcd,"Bad drive" },
  { 0xce,"Bad directory" },
  { 0xcf,"Bad attribute" },
  { 0xd6,"File not found" },
  { 0xdb,"Syntax" },
  { 0xdd,"Channel" },
  { 0xde,"EOF" },
  { 0xfc,"Bad address" },
  { 0xfe,"Bad command" },
  { 0xffff,"" }
};

void FSError(BYTE ErrorNumber)
{
  BYTE C=0;
    while (ErrorTable[C].Number!=0xffff &&
           (BYTE) ErrorTable[C].Number!=ErrorNumber)
      C++;

    if (ErrorTable[C].Number==0xffff)
      FatalError("Unknown FS Error number %2x",ErrorNumber);

  AddressSpace[0x100]=0;
  AddressSpace[0x101]=ErrorNumber;
  strcpy(&AddressSpace[0x102],ErrorTable[C].String);

  SETVFLAG;
}

char * GetFSString(WORD Address)
{
  static char S[256];
  int Offset=0;
  union WordField A;

  A.WordValue=Address;

    while (AddressSpace[A.WordValue]==' ')
      A.WordValue++; // skip spaces

    if (AddressSpace[A.WordValue]!='"')
    {
        while (AddressSpace[A.WordValue]!=0x0d && AddressSpace[A.WordValue]!=0)
    //           && (QuotesExist<2))
        {
          S[Offset++]=AddressSpace[A.WordValue];
            if (AddressSpace[A.WordValue]==' ')
            {
                while (AddressSpace[A.WordValue+1]==' ')
                  A.WordValue++;
            }
          A.WordValue++;
        }
    }
    else
    {
      A.WordValue++;  // skip "

        while (AddressSpace[A.WordValue]!='"')
        {
          S[Offset++]=AddressSpace[A.WordValue];
          A.WordValue++;
        } 

    }
  S[Offset]=0;

  return (S);
}


char * GetVectoredFSString(WORD Address,BYTE AOffset)
{
  union WordField A;

  A.WordValue=(AddressSpace[Address+1]<<8)+AddressSpace[Address]+AOffset;

  return (GetFSString(A.WordValue));
}


BYTE DoAFileTextChar()
{
  int Char;

  Processor.CFlag=1; // displaying text
    if (TextFile==NULL)
      TextFile=fopen(TEXTFILENAME,"rt");

    if (TextFile!=NULL)
    {
      Char=fgetc(TextFile);
        if (!feof(TextFile))
        {
            if (Char==0xa)
              return (0x0d);
          return Char;
        }
     }

    if (TextFile!=NULL)
      fclose(TextFile);
  remove(TEXTFILENAME);

    if (ReturnAReg!=USEDEFAULTAREG)
      TEXTMSGRETURNAREG=ReturnAReg;

  Processor.CFlag=0;
  return 0; // no more chars
}


void MakeTextFile(char * S,int AReg)
{
    if (TextFile!=NULL)
      fclose(TextFile);
  TextFile=fopen(TEXTFILENAME,"wt");
    if (TextFile==NULL)
      return;

  ReturnAReg=AReg;

  fprintf(TextFile,S);
  fclose(TextFile);
  TextFile=NULL;
  Processor.CFlag=1; // display text
}

