/* -------------------------------------------------------------------------- */
/*                                                                            */
/* (C) Copyright D.C.Devenport 1998. All right reserved.                      */
/*                                                                            */
/* THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY      */
/* KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE        */
/* IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR      */
/* PURPOSE.                                                                   */
/*                                                                            */
/* This code, and no part of this code, may not be used in any                */
/* commercial or for-profit venture without the express written               */
/* permission of D.C.Devenport. (BeebInC@aol.com)                             */
/*                                                                            */
/* Credit must be given within any program that uses any of this code         */
/* OR in the accompanying documentation. (And mail me a copy :) )             */
/*                                                                            */
/*----------------------------------------------------------------------------*/
#include <stdio.h>
#include <stdlib.h>
#include "6845crtc.h"
#include "bbc.h"
#include "modex.h"
#include "sysvia.h"
#include "videoula.h"


WORD ScreenStartAddress;
WORD CursorStartAddress;
BYTE LinesToSkipFromScreenTop;
BYTE CharacterRowsToDisplay;
BYTE ScanLinesInACharacterRow;
BYTE CursorBlinkingEnabled;
BYTE CursorOnFlag,CursorBlinkCounter=25,DefaultCursorBlinkingCounter;
BYTE CursorStartOffset,CursorEndOffset;
BYTE InterlaceModeOn;

BYTE ProcessorCyclesPerScreenRow=128; // fixed constant
BYTE ScreenWidthInMemoryBytes;
DWORD ScreenWidthExtraInMemoryBytes;
DWORD ScreenWidthHalfExtraInMemoryBytes;
BYTE HorizontalSyncPositionInMemoryBytes; // ignored
BYTE HorizontalSyncPulseWidth;  // ignored
BYTE VerticalSyncPulseWidth;

BYTE VerticalTotalInCharacters; // includes V-BLANK time
BYTE VerticalSyncPosition;

static BYTE AddressRegister; // index into RegisterValues6845[]
BYTE RegisterValues6845[NUMREGS6845];


void ResetCRTC()
{
  CursorBlinkCounter=16;
  // default timing values are from mode 0
  RegisterValues6845[0]=127;
  RegisterValues6845[1]=80;
  RegisterValues6845[2]=98;
  RegisterValues6845[3]=0x28;
  RegisterValues6845[4]=38;
  RegisterValues6845[5]=0;
  RegisterValues6845[6]=32;
  RegisterValues6845[7]=34;
}


char ReadCRTC(WORD Address)
{
  Address&=1; // now the correct register
    if (Address==0)  // reading the address register
      return (AddressRegister);

  // reading a register value
  return (RegisterValues6845[AddressRegister]);
}


void WriteCRTC(WORD Address,BYTE Value)
{
  Address&=1;
    if (Address==0) // set the address register
    { 
      AddressRegister=Value;
      return;
    }
  // setting a register value
  RegisterValues6845[AddressRegister]=Value;

  // do logic here so dont have to do in display routine
    switch (AddressRegister)
    {
      case 0  : // now fixed to 128 - it works!
                break;
      case 1  : // screen width in bytes (screen memory byte)
                ScreenWidthInMemoryBytes=Value;
                ScreenWidthExtraInMemoryBytes=80-Value;
                ScreenWidthHalfExtraInMemoryBytes=(40-Value)<<1;
                break;
      case 2  : HorizontalSyncPositionInMemoryBytes=Value;
                break;
      case 3  : HorizontalSyncPulseWidth=Value & 15;
                VerticalSyncPulseWidth=Value>>4;
                break;
      case 4  : VerticalTotalInCharacters=Value+1;
                break;
      case 5  : // number of display lines to skip from top of screen
                LinesToSkipFromScreenTop=Value & 7;
                break;
      case 6  : // number of character rows on screen
                  if ((!DoScanLines) && (Value>32))
                    CharacterRowsToDisplay=32; // clip it!
                  else
                    CharacterRowsToDisplay=Value;
                break;
      case 7  : VerticalSyncPosition=Value; 
                break;
      case 8  : InterlaceModeOn=Value & 1;
                break;
      case 9  : // scan lines per character (use only in modes 0-6)
                // skip (R9-7) extra scan lines before the next row
                // Colour extra scan lines black!
                ScanLinesInACharacterRow=Value+1;
                break;

      case 10 : // R10= bit 6 enables cursor blinking
                // bit 5 =0 blink every 16 v blanks
                //       =1 blink every 32 v blanks
                // bits 4-0 = cursor start line

                CursorBlinkingEnabled=(Value & 64)>0;
                  if (TeleTextModeOn)
                    DefaultCursorBlinkingCounter=25;
                  else if (Value & 32)
                    DefaultCursorBlinkingCounter=64;
                  else
                    DefaultCursorBlinkingCounter=32;

                CursorStartOffset=Value & 31;
                break;

      case 11 : // R11= cursor end line (use only in modes 0-6)
                CursorEndOffset=Value & 31;
                break;
      case 12 : // screen start/8 hi 6 bit register
                RegisterValues6845[AddressRegister]=(Value & 0x3f);
                // fall thru
      case 13 : // screen start/8 lo
                CalcNewCRTC();
                break;
      case 14 : // cursor pos hi/8
                RegisterValues6845[AddressRegister]=(Value & 0x3f);
                // fall thru
      case 15 : // cursor pos lo/8
                CalcNewCRTC();
                break;
      case 16 : // light pen hi - ignore - set in SYSVIA
      case 17 : // light pen lo - ignore - set in SYSVIA
      default : ; //nothing not even an error... (should be tho..)
    }
}


void CalcNewCRTC()
{
    ScreenStartAddress=(RegisterValues6845[12]<<8)+
                        RegisterValues6845[13];
    CursorStartAddress=(RegisterValues6845[14]<<8)+
                        RegisterValues6845[15];

      if (TeleTextModeOn)
      {
        // if mode 7
        ScreenStartAddress^=0x2000;
        ScreenStartAddress=(ScreenStartAddress+0x7400);
        CursorStartAddress^=0x2000;
        CursorStartAddress=(CursorStartAddress+0x7400);
      }
      else
      {
        // graphic modes
        ScreenStartAddress<<=3;
        DefaultModeXScreenStart=(DWORD) &AddressSpace[ScreenStartAddress];
        DefaultModeXWrap=(DWORD) (0x8000-ScreenStartAddress);
        CursorStartAddress<<=3;
          if (CursorStartAddress>=0x8000)
            CursorStartAddress=ScreenStart+
                               (CursorStartAddress & 0x7fff);
      }
}


void DumpCRTC(FILE * FileHandle)
{
  short C;
  fprintf(FileHandle,"6845 registers:\n");
    for (C=0; C<NUMREGS6845; C++)
      fprintf(FileHandle,"R%2d = %x\n",C,RegisterValues6845[C]);
}
