#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <signal.h>

#include "manager.h"
#include "text.h"
#include "6502P.h"
#include "dis6502.h"
#include "6522.h"
#include "unix_io.h"

#define pushb(val) writebq(SP + 0x100, val); SP--
#define pullb()    (SP++, readbq(SP + 0x100))

#define pushw(val) pushb((val) / 0x100); pushb((val) & 0xff)

static unsigned char ZN_mask[256] =
{
0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,
0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,
0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,
0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,
0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,
0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,
0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,
0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80
};


int debug = 0;
int do_irq = 0;

/* #define STATS */
#ifdef STATS
int stats[256];
void pstats() {
    int i;
    for (i=0; i<256; i++) {
	printf("0x%02x %6d\n", i, stats[i]);
    }
}
#endif

int main(int argc, char **argv) {
    extern char *optarg;
    time_t time = 0;
    int i, c;
    register byte SP;
    register byte X, Y;
    register word PC;
    register byte A;
    register word P;
    register int count_down = 1;
#ifdef STATS
    memset(stats, 0, sizeof(int) * 256);
    signal(SIGINT, pstats);
#endif

    while (-1 != (c = getopt(argc, argv, "dD:"))) {
	switch (c) {
	case 'd':
	    debug = 1;
	    break;
	case 'D':
	    chdir(optarg);
	    break;
	case '?':
	case 'h':
	    puts("beeb [-d] [-D directory]");
	    return 1;
	}
    }

    /* initialise our modules */
    for (i = 0; i < N_MODULES; i++) {
	module[i]->init();
    }
    init_screen();

    A = 0x00;
    X = 0x00;
    Y = 0x00;
    P = P_U | P_B | P_I;
    SP = 0x00;
    T = 0;
    PC=readw(0xFFFC);

    for (;;) {
#ifdef DEBUG
	if (debug) {
	    disassemble(PC, A, X, Y, SP, P);
	}
#endif
#include "opcodes.h"

#if defined(USER_VIA) || defined(SYSTEM_VIA)
	if (do_irq) {
	    if (!get_I()) {
		clr_B();

		/*
		  printf("Interrupt generated at &%X, P=&%X\n", PC, P);
		  debug=1;
		  */
	    
		pushw(PC);
		pushb(P);
		set_I();
		PC = readwq(0xFFFE);
		do_irq = 0;
	    } else {
		do_irq = 0;
	    }
	}
#endif

	if (--count_down == 0) {
	    static int t1 = 0;
	    static int t2 = 777;
	    static int last = 0;

	    /* time for something interesting! */
	    t1 -= last;
	    t2 -= last;

	    if (t1 <= 0) {
		update_sysvia_k();
		t1 += 300;
	    }

	    if (t2 <= 0) {
		update_sysvia_t();
		t2 += 4000;
	    }

	    count_down = t1 < t2 ? t1 : t2;
	    last = count_down;
	}
	
    }

    return 0;
}
