#include <signal.h>
#include <unistd.h>
#include <sys/time.h>
#include <errno.h>

/* ARGSUSED */
void sig_alarm(int x) {
    static int i = 0;

    printf("%d\n", i++);
    if (i == 100)
	exit(0);
}

int main() {
    int i;
    struct itimerval ival;
    struct sigaction siga;

    siga.sa_handler = sig_alarm;
    siga.sa_mask = 0;
    siga.sa_flags = 0;
    siga.sa_restorer = NULL;
    sigaction(SIGALRM, &siga, NULL);

    ival.it_value.tv_sec = 0;
    ival.it_value.tv_usec = 1000000/50;
    ival.it_interval.tv_sec = 0;
    ival.it_interval.tv_usec = 1000000/50;
    
    if (-1 == setitimer(ITIMER_REAL, &ival, NULL)) {
	perror("setitimer()");
	return 1;
    }

    for(;;) {
	pause();
    }

    return 0;
}
