#include <stdio.h>
#include <string.h>
#include "gba.h"
#include "hvl_replay.h"

//extern u32 animcounter;
extern int8 *pcmptr0;
extern uint8 *tunesadr[];
extern u32 AGBinput;			//from vdc.s
extern u32 AGBkeys;				//from vdc.s, one shot presses.

//asm calls
void waitFrame(void);			//vdc.s
void soundInit(void);			//vdc.s
void setupIRQ(void);			//vdc.s


void playerCallback(void);
void selectTune(int);
void waitforframe(void);

int tunes;					//total number of tunes
int selectedtune=0;
int playing=0;
int dummy0, dummy1;


#define FREQ 31600
struct hvl_tune *tune;


void C_entry() {

	tunes = 10;
	setupIRQ();
	soundInit();

	selectTune(10);
	while(1)
	{
		waitforframe();
	}
}


void playerCallback() {
	int8 *buf1, *buf2;
	if(playing)
	{
		buf1 = pcmptr0;
		buf2 = &pcmptr0[wavbufsize*2];
    	hvl_DecodeFrame( tune, (int8 *) buf1, (int8 *) buf2, 1, mixbufsize );
	}
	else
	{
		memset(pcmptr0, 0, 512*4);
	}
}

void selectTune(int i) {
	selectedtune = i;
	playing=0;
//	animcounter=0;
	tune = hvl_LoadTune(tunesadr[i], FREQ, 4 );
//	hvl_InitSubsong( tune, 0 );
	playing=1;
}


void waitforframe(void) {
	waitFrame();
	if( (!playing) || (selectedtune==10)) return;
	if(tune->ht_SongEndReached) {
		selectedtune++;
		if(selectedtune > tunes) selectedtune = 0;
		selectTune(selectedtune);
	}
}
