	AREA rom_code, CODE, READONLY
	ENTRY

	INCLUDE equates.h

	IMPORT |Image$$RO$$Base|
	IMPORT |Image$$RO$$Limit|
	IMPORT |Image$$RW$$Base|
	IMPORT |Image$$RW$$Limit|
	IMPORT |Image$$ZI$$Base|
	IMPORT |Image$$ZI$$Limit|
 [ BUILD = "DEBUG"
	IMPORT |zzzzz$$Base|
 ]

	IMPORT C_entry			;from main.c

	EXPORT tunesadr
;------------------------------------------------------------
 	b __main

	DCB 36,255,174,81,105,154,162,33,61,132,130,10,132,228,9,173
	DCB 17,36,139,152,192,129,127,33,163,82,190,25,147,9,206,32
	DCB 16,70,74,74,248,39,49,236,88,199,232,51,130,227,206,191
	DCB 133,244,223,148,206,75,9,193,148,86,138,192,19,114,167,252
	DCB 159,132,77,115,163,202,154,97,88,151,163,39,252,3,152,118
	DCB 35,29,199,97,3,4,174,86,191,56,132,0,64,167,14,253
	DCB 255,82,254,3,111,149,48,241,151,251,192,133,96,214,128,37
	DCB 169,99,190,3,1,78,56,226,249,162,52,255,187,62,3,68
	DCB 120,0,144,203,136,17,58,148,101,192,124,99,135,240,60,175
	DCB 214,37,228,139,56,10,172,114,33,212,248,7
	DCB "HivelyPlayer"	;title
	DCB "AHXD"			;gamecode
	DCB "00"			;maker
	DCB 0x96			;fixed value
	DCB 0				;unit code
	DCB 0				;device type
	DCB 0,0,0,0,0,0,0	;unused
	DCB 0				;version
	DCB 0xEE			;complement check
	DCW 0				;unused
;----------------------------------------------------------
__main
;----------------------------------------------------------
	b %F0
	% 28			;multiboot struct
0
	[ BUILD = "DEBUG"
		mov r0, #0x10	;usr mode
		msr cpsr_f, r0
	]

	ldr	sp,=0x3007f00
	LDR	r5,=|Image$$RO$$Limit| ;r5=pointer to IWRAM code

	ldr r0,=|Image$$RO$$Limit|
 [ BUILD = "DEBUG"
	ldr r1,=|zzzzz$$Base|
 |
	ldr r1,=|Image$$RW$$Limit|
 ]
	add r1,r1,r0

	adr lr,_3
	tst lr,#0x2000000
	beq _3				;running from cart?
		add r5,r5,#0x6000000		;RW code ptr=8xxxxxx

		ldr r1,=|Image$$RO$$Base|+4	;copy rom code to exram
		add r0,r1,#0x6000000
		ldr r3,=|Image$$RO$$Limit|
_2		cmp r1,r3
		ldrcc r2, [r0], #4
		strcc r2, [r1], #4
		bcc _2
		sub pc,lr,#0x6000000	;jump to exram copy
_3
	LDR	r1, =|Image$$RW$$Base|
	LDR	r3, =|Image$$ZI$$Base| ; Zero init base => top of initialized data
_0	CMP	r1, r3
	LDRCC	r2, [r5], #4		;copy RW code to IWRAM
	STRCC	r2, [r1], #4
	BCC	_0
	LDR	r1, =|Image$$ZI$$Limit| ; Top of zero init segment
	MOV	r2, #0
_1	CMP	r3, r1 ; Zero init
	STRCC	r2, [r3], #4
	BCC	_1

 [ DEBUG
	ldr r0,=PCE_RAM
	cmp r1,r0		;sanity check - make sure iwram code fits in iwram
giveup	bhi giveup
 ]


	ldr r1,=C_entry
	bx r1
;----------------------------------------------------------

tunesadr
	DCD HVL_MOD_01,HVL_MOD_02,HVL_MOD_03,HVL_MOD_04,HVL_MOD_05,HVL_MOD_06
	DCD HVL_MOD_07,HVL_MOD_08,HVL_MOD_09,HVL_MOD_10,HVL_MOD_11

	LTORG

HVL_MOD_01
	INCBIN tunes/ahx.90210
HVL_MOD_02
	INCBIN tunes/ahx.a_few_hours_2_deadline
HVL_MOD_03
	INCBIN tunes/ahx.a_higher_x
HVL_MOD_04
	INCBIN tunes/ahx.a_new_beginning
HVL_MOD_05
	INCBIN tunes/ahx.a_new_beginning_ii
HVL_MOD_06
	INCBIN tunes/ahx.acideffect
HVL_MOD_07
	INCBIN tunes/ahx.aftermath
HVL_MOD_08
	INCBIN tunes/ahx.alternative
HVL_MOD_09
	INCBIN tunes/ahx.amanda
HVL_MOD_10
	INCBIN tunes/ahx.asia_chiphop
HVL_MOD_11
	INCBIN tunes/ahx.hero's

	

	END
