-- Assembled by the RiFT bundler

rift_codegameevent=function()
return function(R)
	R=R or {}

	-- These are the recorded events
	local GameEvent = {}

	function GameEvent:new(data)
		local o={
			data=data,
		}
		setmetatable(o,self)
		self.__index=self
		return o
	end

	function GameEvent:getData()
		return self.data
	end

	function GameEvent:__tostring()
		local str = "{"
		local doComma = false
		for k,v in pairs(self.data) do
			if doComma then
				str = str .. ","
			end
			-- TODO: add quotes
			if type(v) == "string" then
				str = str .. k .. '="' .. v .. '"'
			elseif type(v) == "number" then
				str = str .. k .. "=" .. tostring(v)
			end
			doComma = true
		end
		str = str .. "}"
		return str
	end

	R.GameEvent = GameEvent
end

end

rift_fontsysfont=function()
--- Functions to handle System font data.
-- These are system fonts, so use the standard print function.
-- @module gfx.sysfont
-- @author Decca, Mantratronic
return function(R)
    R=R or {}

    --- Overwrite the current system font
    -- @tparam table font Font data (RLE, or RAW)
    R.sysfontLoad=function(font)
        if font.rle then
            R._sysfontLoadRLE(font)
        else
            R._sysfontLoadRAW(font)
        end
    end

    --- Load Font Data
    -- @tparam table font Font data (RLE)
    -- @local
    R._sysfontLoadRLE=function(font)
        local str=font.rle
        local o=tonumber(str:sub(1,5),16) -- get (o)ffset
        local w=tonumber(str:sub(6,7),16)*8-1 -- get (w)idth
        local e=str:sub(8,str:len()) -- remove header to get (e)ncoded data
        local d = "" -- (d)ecoded data
        for m, c in e:gmatch("(%u+)([^%u]+)") do -- decode rle, (m)atch & (c)ounter
            d = d .. m .. (m:sub(-1):rep(c))  
        end
        local y=0
        for x = 1,#d,1 do -- write to mem
            local c=string.byte(d:sub(x,x))-65 -- get (c)olor value
            poke4(o+y,c) y=y+1
            if w>0 and y>w then y=0 o=o+1024 end
        end
    end

    --- Load Font Data
    -- @tparam table font Font data (RAW)
    -- @local
    R._sysfontLoadRAW=function(font)
        local str=font.raw
        local tnb=tonumber
        local o=tnb(str:sub(1,5),16) -- get (o)ffset
        local w=tnb(str:sub(6,7),16)*8-1 -- get (w)idth
        local d=str:sub(8,str:len()) -- remove header to get (d)ata
        local y=0
        for x = 1,#d,1 do -- write to mem
        local c=tnb(d:sub(x,x),16) -- get (c)olor value
        poke4(o+y,c) y=y+1
            if w>0 and y>w then y=0 o=o+1024 end
        end
    end
end
  

end

rift_partsintro=function()
R=R or {}
R2=R2 or {}

rift_demopart()(R)
rift_3d2engine()(R2)
rift_3d2scene()(R2)
rift_3d2model()(R2)
rift_3d2mesh()(R2)
rift_3d2actor()(R2)
rift_3d2skeleton()(R2)
rift_3d2v3()(R2)
rift_3d2m44()(R2)
rift_3d2quaternion()(R2)
rift_3d2material()(R2)
rift_gfxticmctile2()(R)

local setRGB, setPalette, setPaletteScaled = rift_codepalette()(R)
local makeTileModelsAndActors, getTilesPosStart, getTilesPosFloor = rift_codeactorstiles()(R2)
local gfxRiftLogo, palRiftLogo = rift_codegfxriftlogo()(R)
local GFX_RIFT_LOGO

local TextTicker = rift_codetextticker()()
local quadShadedLit, triShadedLit, makeLinearPalMap, fnChoosePalMapIndexUnitNegToPos, fnChoosePalMapIndexUnitFacing = rift_codematerialflatlitpalettemap()(R2)

local mPi,mSin,mCos,mMin,mMax=math.pi,math.sin,math.cos,math.min,math.max
local mTau=mPi * 2

local ENGINE, CAMERA, SCENE
local ACTOR_TILES, ACTOR_TILES_POS_START, ACTOR_TILES_POS_FLOOR

local LIGHT

local TEXT_TICKER = TextTicker:new({
	'            "O Disaster"            '
})

return R.DemoPart:new({
	tic=function(pMetrics)
		if pMetrics.isFirstRun then
			vbank(0)
			setRGB(0,0,0,0)
	
			vbank(1)
			setRGB(1,255,255,0)
			setRGB(2,255,0,0)

			ENGINE = R2.Engine:new()
			CAMERA = R2.Camera:new(R2.V3:new(0,0,4), R2.Quaternion:newFromEuler(0,0,0))
			SCENE = R2.Scene:new(CAMERA)
			LIGHT = R2.V3:new(0,0,1)
			LIGHT:normalize()

			local palMapW = makeLinearPalMap(1, 5)
			local palMapR = makeLinearPalMap(6, 10)
			local palMapB = makeLinearPalMap(11, 15)
			
			--			local choosePalMapIndex = fnChoosePalMapIndexUnitNegToPos(#palMap)
			local choosePalMapIndexW = fnChoosePalMapIndexUnitFacing(#palMapW)
			local choosePalMapIndexR = fnChoosePalMapIndexUnitFacing(#palMapR)
			local choosePalMapIndexB = fnChoosePalMapIndexUnitFacing(#palMapB)
	
			ENGINE:setMaterial("quadFlatLit-w", quadShadedLit(LIGHT, palMapW, choosePalMapIndexW))
			ENGINE:setMaterial("quadFlatLit-r", quadShadedLit(LIGHT, palMapR, choosePalMapIndexR))
			ENGINE:setMaterial("quadFlatLit-b", quadShadedLit(LIGHT, palMapB, choosePalMapIndexB))
			
			GFX_RIFT_LOGO = R.TicMcTile:new(gfxRiftLogo, true, 4, 0,0, 128,80)

			vbank(1)
			for i,rgb in ipairs({
				{166, 37, 77},
				{242, 53, 113},
				{88, 21, 41},
				{13, 07, 05},
				{94, 92, 23},
				{165, 165, 40},
				{249, 249, 61},
			}) do
				setRGB(i, rgb[1] *.8, rgb[2] *.8, rgb[3] *.8)
				setRGB(i+8, rgb[1], rgb[2], rgb[3])
			end

			ACTOR_TILES = makeTileModelsAndActors(ENGINE, SCENE)
			ACTOR_TILES_POS_START = getTilesPosStart()
			ACTOR_TILES_POS_FLOOR = getTilesPosFloor()
		end

		if keyp(1) then -- "a" (for asteroids)
			return "secret"
		end

		local progress = pMetrics.progress

		if progress < .8 and pMetrics.tics %100 == 0 then
			sfx(2, 30, 10, 2, 6)
		end

		vbank(1)

		local logoX, logoY = 58,28
		local logoW, logoH = 120, 75
		local effectPix = {}

		vbank(0)
		cls()
		if progress < .2 then
			local rgbScale = progress / .2
			setPaletteScaled("wrb", rgbScale, 0,0,0)
		else
			setPalette("wrb")
		end

		local zeroTime = .5
		local oneTime = .8
		local factorZero = 0
		local factorOne = 0
		if progress >= oneTime then
			factorOne = (progress - oneTime) / (1-oneTime)
		elseif progress <= zeroTime then
			factorZero = (zeroTime - progress) / zeroTime
		else
			factorZero = 0
		end
		factorZero = R.smoothStep(factorZero, 0, 1)
		factorOne = R.smoothStep(factorOne, 0, 1)
	
		for i, actor in ipairs(ACTOR_TILES) do
			local r1 = ((i+7)^4.3)%1 * 10 * factorZero + mPi/2 * factorOne
			local r2 = ((i+8)^4.6)%1 * 12 * factorZero
			local r3 = ((i+9)^4.9)%1 * 15 * factorZero

			local a = ((i+10)^7.2 % 1) * mTau
			local dx = (3 * factorZero)
			local dy = (2 * factorZero)
			local x = math.sin(a) * dx * math.sin(r3 + r2) * 2
			local y = math.cos(a) * dy * math.sin(r1 + r3) * 2
			local z = 0
--			actor:setRotation(R2.Quaternion:newFromEuler(progress * mPi * 4,0,0))
			local pos = ACTOR_TILES_POS_START[i] * (1-factorOne) + R2.V3:new(x,y,z) + ACTOR_TILES_POS_FLOOR[i] * factorOne
--			local a = mSin(progress*3 * i * (1-factorOne))
			actor:setRotation(R2.Quaternion:newFromEuler(r1,r2,r3))
			actor:setPosition(pos)
		end

--		CAMERA:setPosition(R2.V3:new(0,0,3) * factorOne)

		SCENE:render(ENGINE)
		for y=0,logoH do
			effectPix[y] = {}
			for x=0,logoW do
				effectPix[y][x] = pix(logoX+x, logoY+y)
			end
		end

		vbank(1)
		cls()

		GFX_RIFT_LOGO:draw(logoX, logoY)
		for x=0,logoW do
			local topH = nil
			local xD = logoX+x
			for y=0,logoH do
				local yD = logoY+y
				local p = pix(xD, yD)
				if p>0 then
					if topH == nil then
						topH = yD
					end

					if effectPix[y][x] > 0 then
						pix(xD, yD, p + 8)
					end
				end
			end
			if topH ~= nil then
--				pix(xD,topH,6)
			end
		end

		if progress > .6 then
			TEXT_TICKER:render(0,120, "center", 15)
			
			if pMetrics.tics % 3 == 0 then
				TEXT_TICKER:tick()
			end
		end
	end,
	cleanup=function()
	end,
})


end

rift_3d2camera=function()
return function(R)
	R=R or {}

	local Camera={}

	local mTan, mRad, mPi = math.tan, math.rad, math.pi

    -- pos V3
    -- rot Quaternion
    -- up V3
	function Camera:new(pos, rot, up)	-- ?fov, near, far (aspect?)?
		local o={
			pos=pos and pos or R.V3:new(0,0,0),
			rot=rot and rot or R.Quaternion:identity(),
            up=up and up or R.V3:new(0,1,0),
			fov = 60,	-- degrees
			near = .01,
			far = 1000,
			-- matWorldToView is a cached [matWorldToCamera -> matCameraToView]
			matWorldToView,
			matWorldToCamera,
			matCameraToView,
		}
		setmetatable(o,self)
		self.__index=self
		return o
	end

	function Camera.newM44OrthogonalProj(b,t,l,r,n,f)
		return R.M44:new(
			2 / (r-l), 0,0,0,
			0, 2 / (t-b), 0, 0,
			0, 0, 2 / (n-f), 0,
			(l+r)/(l-r), (t+b)/(b-t), (f+n)/(n-f), 1
		)
	end
	
	function Camera.newM44PersProj(fov, near, far)
		local scale = 1 / mTan(mRad(fov * .5))
		local range = near - far
		return R.M44:new(
			scale, 0, 0, 0,
			0, scale, 0, 0,
			0, 0, far / range, far * near / range,
			0, 0, -1, 0
		)
	end

	function Camera:setPosition(pos)
		self.pos = pos
		self.matWorldToCamera = nil
		self.matWorldToView = nil
	end

	function Camera:setRotation(q)
		self.rot = q
		self.matWorldToCamera = nil
		self.matWorldToView = nil
	end

	function Camera:setFOV(fov)
		self.fov = fov
		self.matCameraToView = nil
		self.matWorldToView = nil
	end

	function Camera:getMatWorldToView()
		if not self.matWorldToView then
			self.matWorldToView = self:getMatCameraToView() * self:getMatWorldToCamera()
		end

		return self.matWorldToView
	end

	function Camera:getMatWorldToCamera()
		if not self.matWorldToCamera then
			-- #TODO: Optimise...
			local matWorldToCamera = R.M44:new(
				1,0,0,0,
				0,1,0,0,
				0,0,1,0,
				0,0,0,1
			)
			-- TODO: Invert rotation?
			matWorldToCamera = R.M44.rotateByQuaternion(matWorldToCamera, self.rot)
			matWorldToCamera.m03 = -self.pos.x
			matWorldToCamera.m13 = -self.pos.y
			matWorldToCamera.m23 = -self.pos.z
			self.matWorldToCamera = matWorldToCamera
		end
		return self.matWorldToCamera
	end

	function Camera:getMatCameraToView()
		if not self.matCameraToView then
			self.matCameraToView = Camera.newM44PersProj(self.fov, self.near, self.far)
		end

		return self.matCameraToView
	end

	R.Camera = Camera
end

--[[
function R.NewM44LookAt(from,to,up)
	--[[
	THIS WAS COMMENTED OUT
	-- https://www.scratchapixel.com/lessons/mathematics-physics-for-computer-graphics/lookat-function/framing-lookat-function.html
	local forward=from:subC(to)
	forward:normal()
	local right=up:cross(forward)
	right:normal()
	local newUp=forward:cross(right)
	return R.M44:new({
		{right.e[1],newUp.e[1],forward.e[1],from.e[1]},
		{right.e[2],newUp.e[2],forward.e[2],from.e[2]},
		{right.e[3],newUp.e[3],forward.e[3],from.e[3]},
		{0,0,0,1}
	})
	--]]

	--[[
	local z=(to:subC(from)):normalC()
	local x=up:cross(z):normalC()
	local y=z:cross(x):normalC()
	return R.M44:new({
		{x.e[1],x.e[2],x.e[3],-x:dot(from)},
		{y.e[1],y.e[2],y.e[3],-y:dot(from)},
		{z.e[1],z.e[2],z.e[3],-z:dot(from)},
		{0,0,0,1},
	})
end

--]]

end

rift_partsoutro=function()
R=R or {}
R2=R2 or {}

rift_demopart()(R)
rift_3d2engine()(R2)
rift_3d2scene()(R2)
rift_3d2model()(R2)
rift_3d2mesh()(R2)
rift_3d2actor()(R2)
rift_3d2skeleton()(R2)
rift_3d2v3()(R2)
rift_3d2m44()(R2)
rift_3d2quaternion()(R2)
rift_3d2material()(R2)
rift_gfxticmctile2()(R)
local makeModelAsteroid = rift_code3d2modelasteroid()(R2)
local setRGB, setPalette, setPaletteScaled, setPaletteAsteroids = rift_codepalette()(R)
local gfxAsteroid, palAsteroid = rift_codegfxasteroid()(R)
local GFX_ASTEROID

local gfxHatching, palHatching = rift_codegfxhatching()(R)
local GFX_HATCHING

local TextTicker = rift_codetextticker()()
local quadShadedLit, triShadedLit, makeLinearPalMap, fnChoosePalMapIndexUnitNegToPos, fnChoosePalMapIndexUnitFacing = rift_codematerialflatlitpalettemap()(R2)

local mPi,mSin,mCos=math.pi,math.sin,math.cos
local mMin,mMax=math.min,math.max
local mTau=mPi * 2

local ENGINE, CAMERA, SCENE
local ACTORS = {}
local LIGHT

local TEXT_TICKER = TextTicker:new({
	"Dedicated to the brave souls",
	"of the O-Disaster Force",
	"who gave their lives in the service of space security",
	"",
	"To honour their memory",
	"press 'a' during this presentation",
	"for an interactive battle against the asteroids",
	"",
	"",
	"RiFT at Revision 2025",
	"may the demolition be with you",
})

function astTextured(sSrc,chromakey,sx,sy,sw,sh,pixelmode,lightVec)
	pixelmode = pixelmode or 2  -- 8: 1bpp, 4 = 2bpp, 2 = 4bpp
	local cRange = 5

	return R2.Material:new():setFnTransform(function(d, psView, psWorld)
		return {
			v1=psView[d.v1], v2=psView[d.v2], v3=psView[d.v3],
			t1=d.t1,t2=d.t2,t3=d.t3,
			normal = R2.V3.normal(psWorld[d.v1], psWorld[d.v2], psWorld[d.v3])
		}
	end):setFnDistance(function(d)
		return (d.v1.z+d.v2.z+d.v3.z)/3
	end):setFnDraw(function(d)
		-- This needs figuring out (which points) and cleaning...
		local st1x, st1y = sx + d.t1.x * sw, sy + d.t1.y * sh
		local st2x, st2y = sx + d.t2.x * sw, sy + d.t2.y * sh
		local st3x, st3y = sx + d.t3.x * sw, sy + d.t3.y * sh

		local angle = R2.V3.dot(d.normal, lightVec)
		local cAdd = cRange*angle

		for i=1,15 do
			local c = mMin(mMax(i+cAdd,1),15)
			poke4(0x3FF0*2+i,c)
		end

		local oldPixelMode = peek4(0x3ffc*2)
		poke4(0x3FFC*2,pixelmode) -- set pixel mode
		ttri(
			d.v1.x,d.v1.y,d.v2.x,d.v2.y,d.v3.x,d.v3.y,
			st1x, st1y, st2x, st2y, st3x, st3y,
			sSrc,
			chromakey,
			d.v1.z,d.v2.z,d.v3.z
		)
		poke4(0x3FFC,oldPixelMode) -- reset pixel mode

		for i=1,15 do
			poke4(0x3FF0*2+i,i)
		end
	end)
end

local function drawStars(t)
	local a = t
	for i=0,200 do
		local y = i%128
		local ax,ay = (i+3)^5.2+a, (i+6)^7.2+a
		local s,c = mSin(ax)-mCos(ay), mCos(ax)+mSin(ay)
		if c > 0 then
			pix(120+s*100,y,2+i%10)
		end
	end
end

return R.DemoPart:new({
	bdr=function(y, pMetrics)
		vbank(0)
		local sc = .5+(mCos(y/136 * mPi - pMetrics.progress * 15))^2*.5
		if y%2==0 then
			sc = .6
		end
		sc=1
		if pMetrics.progress < .2 then
			sc = sc * (pMetrics.progress / .2)
		elseif pMetrics.progress > .8 then
			sc = sc * (mMax(1-((pMetrics.progress-.8) / .2),0))
		end
		setRGB(0, 0, 0, 0)
		local r, g, b = 130, 80, 200
		setRGBSpread(1,15, 40*sc,40*sc,40*sc, r*sc,g*sc,b*sc)
	end,
	tic=function(pMetrics)
		if pMetrics.isFirstRun then
			vbank(0)

			local hatchTexX, hatchTexY = 0,0 --64, 64
			GFX_ASTEROID = R.TicMcTile:new(gfxAsteroid, true, 2, 0,0, 128,128)

			ENGINE = R2.Engine:new()
			CAMERA = R2.Camera:new(R2.V3:new(0,0,20), R2.Quaternion:newFromEuler(0,0,0))
			SCENE = R2.Scene:new(CAMERA)
			LIGHT = R2.V3:new(0,-1,1)
			LIGHT:normalize()

			local palMap = makeLinearPalMap(1, 15)
			local choosePalMapIndex = fnChoosePalMapIndexUnitNegToPos(#palMap)
			ENGINE:setMaterial("triFlatLit", triShadedLit(LIGHT, palMap, choosePalMapIndex))
			ENGINE:setMaterial("triTextured", astTextured(2,0,0,0,128,128,2,LIGHT))
			ENGINE:setMaterial("line", R2.Material.line(15))

			local model = makeModelAsteroid()
			local modelID = ENGINE:addModel(model)
			
			ACTORS["asteroid"] = SCENE:newActor(modelID, R2.V3:new(0,0,0), "miRoot")

			vbank(1)
			setRGB(1, 255,255,255)
		end

		local ax = mSin(pMetrics.progress * mPi * 6)
		local ay = mCos(pMetrics.progress * mPi * 4.5)
		local az = mCos(mPi + pMetrics.progress * mPi * 9)
		LIGHT:set(ax,ay,az)
		LIGHT:normalize()

		local actor = ACTORS["asteroid"]
		local yaw = 2 --pMetrics.progress * mPi * 1.2
		local roll = -pMetrics.progress * mPi * 5
		local pitch = 1 --pMetrics.progress * mPi * 3.5
		actor:setRotation(R2.Quaternion:newFromEuler(pitch,yaw,roll))
		actor:setPosition(R2.V3:new(0,0,0))
		actor:setSkins({"default"})
		if pMetrics.progress < .1 then
			actor:setSkins({"outline"})
		elseif pMetrics.progress < .15 then
			skinSwitch = (pMetrics.progress * 200)//1 % 2
			if skinSwitch == 0 then
				actor:setSkins({"outline"})
			elseif skinSwitch == 1 then
				actor:setSkins({"outline", "flatLit"})
			end
		elseif pMetrics.progress < .2 then
			actor:setSkins({"flatLit"})
		elseif pMetrics.progress < .25 then
			skinSwitch = (pMetrics.progress * 200)//1 % 2
			if skinSwitch == 0 then
				actor:setSkins({"flatLit"})
			elseif skinSwitch == 1 then
				actor:setSkins({"default", "outline"})
			end
		end

		CAMERA:setPosition(R2.V3:new(0, 0, 36))
--		CAMERA:setPosition(R2.V3:new(0, 0, 60-pMetrics.progress * 40))
--		CAMERA:setRotation(R2.Quaternion:newFromEuler(0, pMetrics.progress * 40, 0))

		vbank(1)
		GFX_ASTEROID:draw(0, 0)

		if pMetrics.progress > .7 then
			scale = mMin((pMetrics.progress-.7)/.2, 1)
			circ(32,64,scale*100,0)
			circ(90,40,scale*60,0)
			circ(16,80,scale*60,0)
		end

		vbank(0)
		cls()
--		drawStars(pMetrics.progress)
		SCENE:render(ENGINE)

		vbank(1)
		cls()

		if pMetrics.progress > .2 and pMetrics.progress < .65 then
			TEXT_TICKER:render(0,16, "center", 1)
			
			if pMetrics.tics % 3 < 2 then
				TEXT_TICKER:tick()
			end
		end
	end,
	cleanup=function()
	end,
})

end

rift_3d2m44=function()
return function(R)
    R=R or {}

	local M44 = {}

--	local mSqrt = math.sqrt

	function M44:new(m00,m01,m02,m03, m10,m11,m12,m13, m20,m21,m22,m23, m30,m31,m32,m33)
		local o={
			m00=m00,m01=m01,m02=m02,m03=m03,
            m10=m10,m11=m11,m12=m12,m13=m13,
            m20=m20,m21=m21,m22=m22,m23=m23,
            m30=m30,m31=m31,m32=m32,m33=m33
		}
		setmetatable(o,self)
		self.__index=self
		return o
	end

    function M44.identity()
        return M44:new(1,0,0,0, 0,1,0,0, 0,0,1,0, 0,0,0,1)
    end

	function M44:__tostring()
		return string.format(
            "M44\n%.3f %.3f %.3f %.3f\n%.3f %.3f %.3f %.3f\n%.3f %.3f %.3f %.3f\n%.3f %.3f %.3f %.3f",
            self.m00,self.m01,self.m02,self.m03,
            self.m10,self.m11,self.m12,self.m13,
            self.m20,self.m21,self.m22,self.m23,
            self.m30,self.m31,self.m32,self.m33
        )
	end

    function M44:clone()
        return M44:new(
            self.m00,self.m01,self.m02,self.m03,
            self.m10,self.m11,self.m12,self.m13,
            self.m20,self.m21,self.m22,self.m23,
            self.m30,self.m31,self.m32,self.m33
        )
    end

    function M44.__add(u, v)
        return M44:new(
            u.m00+v.m00,u.m01+v.m01,u.m02+v.m02,u.m03+v.m03,
            u.m10+v.m10,u.m11+v.m11,u.m12+v.m12,u.m13+v.m13,
            u.m20+v.m20,u.m21+v.m21,u.m22+v.m22,u.m23+v.m23,
            u.m30+v.m30,u.m31+v.m31,u.m32+v.m32,u.m33+v.m33
        )
    end

    function M44.__sub(u, v)
        return M44:new(
            u.m00-v.m00,u.m01-v.m01,u.m02-v.m02,u.m03-v.m03,
            u.m10-v.m10,u.m11-v.m11,u.m12-v.m12,u.m13-v.m13,
            u.m20-v.m20,u.m21-v.m21,u.m22-v.m22,u.m23-v.m23,
            u.m30-v.m30,u.m31-v.m31,u.m32-v.m32,u.m33-v.m33
        )
    end

    -- Is this efficient?
    -- (or scale and then assign to metatable?)
    function M44:scale(n)
        self.m00,self.m01,self.m02,self.m03 = self.m00*n,self.m01*n,self.m02*n,self.m03*n
        self.m10,self.m11,self.m12,self.m13 = self.m10*n,self.m11*n,self.m12*n,self.m13*n
        self.m20,self.m21,self.m22,self.m23 = self.m20*n,self.m21*n,self.m22*n,self.m23*n
        self.m30,self.m31,self.m32,self.m33 = self.m30*n,self.m31*n,self.m32*n,self.m33*n
    end

    function M44.__mul(u, v)
        return M44:new(
            u.m00*v.m00+u.m01*v.m10+u.m02*v.m20+u.m03*v.m30, u.m00*v.m01+u.m01*v.m11+u.m02*v.m21+u.m03*v.m31, u.m00*v.m02+u.m01*v.m12+u.m02*v.m22+u.m03*v.m32, u.m00*v.m03+u.m01*v.m13+u.m02*v.m23+u.m03*v.m33,
            u.m10*v.m00+u.m11*v.m10+u.m12*v.m20+u.m13*v.m30, u.m10*v.m01+u.m11*v.m11+u.m12*v.m21+u.m13*v.m31, u.m10*v.m02+u.m11*v.m12+u.m12*v.m22+u.m13*v.m32, u.m10*v.m03+u.m11*v.m13+u.m12*v.m23+u.m13*v.m33,
            u.m20*v.m00+u.m21*v.m10+u.m22*v.m20+u.m23*v.m30, u.m20*v.m01+u.m21*v.m11+u.m22*v.m21+u.m23*v.m31, u.m20*v.m02+u.m21*v.m12+u.m22*v.m22+u.m23*v.m32, u.m20*v.m03+u.m21*v.m13+u.m22*v.m23+u.m23*v.m33,
            u.m30*v.m00+u.m31*v.m10+u.m32*v.m20+u.m33*v.m30, u.m30*v.m01+u.m31*v.m11+u.m32*v.m21+u.m33*v.m31, u.m30*v.m02+u.m31*v.m12+u.m32*v.m22+u.m33*v.m32, u.m30*v.m03+u.m31*v.m13+u.m32*v.m23+u.m33*v.m33
        )
    end

    function M44.transpose(m)
        return M44:new(
            m.m00,m.m10,m.m20,m.m30,
            m.m01,m.m11,m.m21,m.m31,
            m.m02,m.m12,m.m22,m.m32,
            m.m03,m.m13,m.m23,m.m33
       )
    end

    function M44.multiplyVec3(m44, vec3)
        local x,y,z = vec3.x,vec3.y,vec3.z
        return R.V3:new(
            x*m44.m00 + y*m44.m01 + z*m44.m02 + m44.m03,
            x*m44.m10 + y*m44.m11 + z*m44.m12 + m44.m13,
            x*m44.m20 + y*m44.m21 + z*m44.m22 + m44.m23
        )
    end

    function M44.rotateByQuaternion(m44, q)
        q = R.Quaternion.cloneNormalized(q)
        
        local x, y, z, w = q.x, q.y, q.z, q.w

        -- Get a temporary 3x3 rotation matrix from the quaternion
        local r00, r01, r02 = 1 - 2*y*y - 2*z*z, 2*x*y - 2*w*z, 2*x*z + 2*w*y
        local r10, r11, r12 = 2*x*y + 2*w*z, 1 - 2*x*x - 2*z*z, 2*y*z - 2*w*x
        local r20, r21, r22 = 2*x*z - 2*w*y, 2*y*z + 2*w*x, 1 - 2*x*x - 2*y*y

        return M44:new(
            m44.m00*r00 + m44.m01*r10 + m44.m02*r20, m44.m00*r01 + m44.m01*r11 + m44.m02*r21, m44.m00*r02 + m44.m01*r12 + m44.m02*r22, m44.m03,
            m44.m10*r00 + m44.m11*r10 + m44.m12*r20, m44.m10*r01 + m44.m11*r11 + m44.m12*r21, m44.m10*r02 + m44.m11*r12 + m44.m12*r22, m44.m13,
            m44.m20*r00 + m44.m21*r10 + m44.m22*r20, m44.m20*r01 + m44.m21*r11 + m44.m22*r21, m44.m20*r02 + m44.m21*r12 + m44.m22*r22, m44.m23,
            m44.m30, m44.m31, m44.m32, m44.m33
        )
    end

    R.M44 = M44
end

end

rift_partstestticmctile=function()
R=R or {}

rift_demopart()(R)

rift_gfxticmctile2()(R)
local gfxFaceRains, palFaceRains = rift_codegfxfacerains()(R)
local GFX_FACE_RAINS

local gfxFaceLogg, palFaceLogg = rift_codegfxfacelogg()(R)
local GFX_FACE_LOGG

local gfxRiftLogo, palRiftLogo = rift_codegfxriftlogo()(R)
local GFX_RIFT_LOGO

local gfxHatching, palHatching = rift_codegfxhatching8x8()(R)
local GFX_HATCHING

local isSprites = true
local T=0

return R.DemoPart:new({
    tic=function(pMetrics)
        if pMetrics.isFirstRun then
            setRGB(0, 255, 0, 0)
            setRGB(1, 255, 255, 0)
            setRGB(2, 255, 0, 255)
            setRGB(3, 0, 255, 0)
			GFX_FACE_RAINS = R.TicMcTile:new(gfxFaceRains, true, 2, 0,0, 64,64)
			GFX_FACE_LOGG = R.TicMcTile:new(gfxFaceLogg, true, 2, 256,0, 64,64)
--			GFX_RIFT_LOGO = R.TicMcTile:new(gfxRiftLogo, true, 4, 0,64, 128,64)
        end

        cls()

        rectb(0,0,239,127,12)
        GFX_FACE_RAINS:draw(128, 0)
		GFX_FACE_LOGG:draw(128, 64)
--		GFX_RIFT_LOGO:draw(150, 32)

--        poke4(0x3FFC*2, 4)--GFX_HATCHING.blitSegment)
        local drawFromVRAM = false
        if drawFromVRAM then
            local w,h = 128,128
            local dx0,dy0,dx1,dy1 = 0,0,w,h
            local sx0,sy0,sx1,sy1 = 0,0,w,h
            local sSrc = 0 -- (1 is map, but needs map layout)
            ttri(
                dx0,dy0, dx1,dy0, dx0,dy1,
                sx0,sy0, sx1,sy0, sx0,sy1,
                sSrc,
                -1
            )            
            ttri(
                dx1,dy0, dx1,dy1, dx0,dy1,
                sx1,sy0, sx1,sy1, sx0,sy1,
                sSrc,
                -1
            )
        end

        print("ABCDEV ALL GOOD")
        T=T+1
    end,
    cleanup=function()
    end,
})


end

rift_partsasteroids=function()
R=R or {}

rift_demopart()(R)
rift_codevector()
rift_codepixplane()
rift_codedrawingpixplane()
rift_codegamelogic()(R)

local vecDefFont = rift_codevectorfontasteroids()
local vecDefShip, vecDefAsteroid, vecDefUFO, vecDefBullet = rift_codevectorasteroidsgame()()
local setRGB, setPalette, setPaletteScaled, setPaletteAsteroids = rift_codepalette()(R)

local PIXPLANES
local FN_PIXPLANES_MELT = makeFnAcrossPixplanes("pp1[srcA]=pp1[srcA]*.7")
local FN_PIXPLANES_TO_SCREEN = makeFnAcrossPixplanes("poke4(destA, math.min(pp1[srcA],15))")

local DotDraw={}
local d=6
for y=-d,d do
	for x=-d,d do
		local p = 1-((x*x+y*y)^.7)/d
		if p>0 then
			p=(p^4)*1.5
			DotDraw[#DotDraw+1] = {x,y,p}
		end
	end
end

local GAME_LOGIC
local screenXSc = 1

local mRandom = math.random

return R.DemoPart:new({
	tic=function(pMetrics)
		if pMetrics.isFirstRun then
			GAME_LOGIC = R.GameLogic:new()
			GAME_LOGIC:startReplay(
				{{y=32,x=168,e="a",t=0,s=3,r=151},{y=10,x=48,e="a",t=0,s=3,r=189},{y=30,x=18,e="a",t=0,s=3,r=354},{y=99,x=158,e="a",t=0,s=3,r=276},{e="b",t=65,b=2},{e="b",t=83,b=1},{e="b",t=87,b=3},{e="b",t=101,b=2},{e="b",t=104,b=0},{e="b",t=114,b=2},{e="b",t=122,b=0},{e="b",t=124,b=2},{e="b",t=131,b=0},{e="b",t=133,b=1},{e="b",t=137,b=0},{e="b",t=155,b=1},{e="b",t=164,b=2},{e="b",t=176,b=0},{e="b",t=178,b=1},{e="b",t=180,b=0},{e="b",t=184,b=2},{e="b",t=192,b=3},{e="b",t=194,b=1},{e="b",t=202,b=0},{e="b",t=203,b=8},{e="b",t=204,b=0},{e="b",t=211,b=1},{e="b",t=214,b=5},{e="b",t=215,b=4},{e="b",t=236,b=0},{e="b",t=247,b=4},{e="b",t=250,b=1},{e="b",t=256,b=0},{e="b",t=261,b=8},{e="b",t=262,b=0},{e="b",t=273,b=2},{e="b",t=282,b=0},{e="b",t=298,b=8},{e="b",t=299,b=0},{e="b",t=301,b=4},{e="b",t=308,b=0},{e="b",t=309,b=8},{e="b",t=310,b=0},{e="b",t=320,b=8},{e="b",t=321,b=0},{e="b",t=334,b=2},{e="b",t=340,b=0},{e="b",t=346,b=8},{e="b",t=347,b=0},{e="b",t=354,b=4},{e="b",t=356,b=0},{e="b",t=359,b=8},{e="b",t=360,b=0},{e="b",t=367,b=1},{e="b",t=378,b=0},{e="b",t=387,b=8},{e="b",t=388,b=0},{e="b",t=390,b=4},{e="b",t=397,b=0},{e="b",t=399,b=8},{e="b",t=400,b=0},{e="b",t=402,b=4},{e="b",t=409,b=8},{e="b",t=410,b=0},{e="b",t=419,b=8},{e="b",t=420,b=0},{e="b",t=424,b=4},{e="b",t=426,b=0},{e="b",t=439,b=4},{e="b",t=448,b=12},{e="b",t=449,b=0},{e="b",t=457,b=2},{e="b",t=459,b=3},{e="b",t=462,b=1},{e="b",t=466,b=0},{e="b",t=474,b=8},{e="b",t=475,b=0},{e="b",t=478,b=4},{e="b",t=495,b=0},{e="b",t=497,b=8},{e="b",t=498,b=1},{e="b",t=501,b=0},{e="b",t=526,b=8},{e="b",t=527,b=0},{e="b",t=534,b=8},{e="b",t=535,b=0},{e="b",t=541,b=1},{e="b",t=546,b=3},{e="b",t=553,b=2},{e="b",t=557,b=0},{e="b",t=559,b=8},{e="b",t=560,b=0},{e="b",t=566,b=4},{e="b",t=573,b=12},{e="b",t=574,b=4},{e="b",t=575,b=0},{e="b",t=580,b=4},{e="b",t=584,b=0},{e="b",t=589,b=8},{e="b",t=590,b=4},{e="b",t=595,b=0},{e="b",t=601,b=8},{e="b",t=602,b=0},{e="b",t=613,b=10},{e="b",t=614,b=0},{e="b",t=617,b=4},{e="b",t=618,b=5},{e="b",t=622,b=13},{e="b",t=623,b=5},{e="b",t=630,b=13},{e="b",t=631,b=5},{e="b",t=637,b=4},{e="b",t=640,b=8},{e="b",t=641,b=0},{e="b",t=648,b=4},{e="b",t=654,b=5},{e="b",t=657,b=13},{e="b",t=658,b=5},{e="b",t=661,b=1},{e="b",t=663,b=0},{e="b",t=666,b=5},{e="b",t=668,b=1},{e="b",t=669,b=0},{e="b",t=670,b=8},{e="b",t=671,b=0},{e="b",t=680,b=1},{e="b",t=684,b=0},{e="b",t=687,b=2},{e="b",t=688,b=10},{e="b",t=689,b=2},{e="b",t=698,b=0},{e="b",t=707,b=8},{e="b",t=708,b=0},{e="b",t=721,b=10},{e="b",t=722,b=2},{e="b",t=733,b=3},{e="b",t=738,b=0},{e="b",t=751,b=2},{e="b",t=754,b=3},{e="b",t=757,b=11},{e="b",t=758,b=3},{e="b",t=762,b=2},{e="b",t=764,b=0},{e="b",t=767,b=8},{e="b",t=768,b=0},{e="b",t=770,b=2},{e="b",t=772,b=3},{e="b",t=774,b=2},{e="b",t=777,b=0},{e="b",t=780,b=8},{e="b",t=781,b=0},{e="b",t=790,b=8},{e="b",t=791,b=0},{e="b",t=795,b=2},{e="b",t=799,b=10},{e="b",t=800,b=0},{e="b",t=809,b=8},{e="b",t=810,b=0},{e="b",t=812,b=5},{e="b",t=816,b=1},{e="b",t=817,b=3},{e="b",t=834,b=10},{e="b",t=835,b=0},{e="b",t=843,b=4},{e="b",t=846,b=12},{e="b",t=847,b=4},{e="b",t=856,b=0},{e="b",t=860,b=4},{e="b",t=863,b=0},{e="b",t=867,b=8},{e="b",t=868,b=0},{e="b",t=874,b=1},{e="b",t=878,b=0},{e="b",t=881,b=4},{e="b",t=882,b=12},{e="b",t=883,b=4},{e="b",t=893,b=0},{e="b",t=895,b=8},{e="b",t=896,b=0},{e="b",t=898,b=4},{e="b",t=906,b=12},{e="b",t=907,b=4},{e="b",t=915,b=5},{e="b",t=923,b=13},{e="b",t=924,b=5},{e="b",t=927,b=0},{e="b",t=933,b=9},{e="b",t=934,b=1},{e="b",t=941,b=0},{e="b",t=943,b=8},{e="b",t=944,b=0},{e="b",t=945,b=2},{e="b",t=953,b=0},{e="b",t=956,b=9},{e="b",t=957,b=1},{e="b",t=965,b=9},{e="b",t=966,b=1},{e="b",t=972,b=0},{e="b",t=975,b=8},{e="b",t=976,b=0},{e="b",t=985,b=8},{e="b",t=986,b=0},{e="b",t=988,b=2},{e="b",t=1001,b=3},{e="b",t=1004,b=1},{e="b",t=1007,b=0},{e="b",t=1009,b=8},{e="b",t=1010,b=0},{e="b",t=1020,b=8},{e="b",t=1021,b=0}}
			)

			PIXPLANES=initPixplanes()
			vbank(0)
			setPaletteAsteroids()
		end

		local pixplaneGame = PIXPLANES[1]

		local renderlist, soundList, event = GAME_LOGIC:tic()

		for _, asteroid in ipairs(renderlist.asteroids) do
			local vecDrawDef=vectorTransformPoints(vecDefAsteroid, asteroid.x,asteroid.y, asteroid.size * screenXSc, asteroid.size, asteroid.r)
			ppVectorDraw(pixplaneGame, vecDrawDef, DotDraw)
		end

		if renderlist.isRecording then
			ppVecFontPrint(pixplaneGame, vecDefFont, 210, 10, "Record", 7, DotDraw)
		end

		ppVecFontPrint(pixplaneGame, vecDefFont, 10, 10, string.format("%05d", renderlist.score), 10, DotDraw)

		if  renderlist.state == "gameover" then
			ppVecFontPrint(pixplaneGame, vecDefFont, 80, 60, "GAME OVER", 10, DotDraw)
		else
			if renderlist.isReady then 
				ppVecFontPrint(pixplaneGame, vecDefFont, 106, 50, "READY", 10, DotDraw)
			end
		end

		for _, bullet in ipairs(renderlist.bullets) do
			local vecDrawDef = vectorTransformPoints(vecDefBullet, bullet.x,bullet.y, 1, 1, 0)
			ppVectorDraw(pixplaneGame, vecDrawDef, DotDraw)
		end

		local ship = renderlist.ship
		local shipScale = 6
		local vecDrawDef = vectorTransformPoints(vecDefShip, ship.x, ship.y, shipScale * screenXSc, shipScale, ship.r)
		ppVectorDraw(pixplaneGame, vecDrawDef, DotDraw)

		vbank(0)
		local persist = .6 + mRandom()*.2
		copyPixplaneToScreenAndDecay(pixplaneGame, persist)

		for _, sound in ipairs(soundList) do
			if sound == "shoot" then
				sfx(0)
			elseif sound == "asteroid-split" then
				sfx(1, 10 + mRandom(0, 5), -1, 1)
			elseif sound == "explode" then
				sfx(1, 2, -1, 1)
			elseif sound == "thud-0" then
				sfx(2, 30, -1, 2, 6)
			elseif sound == "thud-1" then
				sfx(2, 28, -1, 2, 6)
			end
		end
	end,
	cleanup=function()
		GAME_LOGIC = nil
	end,
})

end

rift_code3d2modelfigure=function()
return function(R)

	local mPI = math.pi

	-- style: "regular", "outline"
	local function makeMeshTemplate(type, style, scx, scy, scz, texFaceID)
		local verts={{-1,1,-1},{1,1,-1},{1,-1,-1},{-1,-1,-1},{-1,1,1},{1,1,1},{1,-1,1},{-1,-1,1}}
		local quads={{1,2,3,4},{6,5,8,7},{5,1,4,8},{2,6,7,3},{5,6,2,1},{4,3,7,8}}
		local tx,ty,tz=0,0,0
		local dx,dy,dz=1,1,1
		if type == "pelvis" then
			dx,dy,dz=2,.5,.6
		elseif type == "legHigh" then
			ty=-1
			dx,dy,dz=.8,1.7,.5
			local w=1.2
			verts={{-w,1,-1},{w,1,-1},{1,-1,-1},{-1,-1,-1},{-w,1,1},{w,1,1},{1,-1,1},{-1,-1,1}}
		elseif type == "legLow" then
			ty=-1
			dx,dy,dz=.5,1.5,.5
		elseif type == "foot" then
			ty,tz=-1,-.5
			dx,dy,dz=.4,.2,1
		elseif type == "torso" then
			ty=1
			dx,dy,dz=2,2.7,.8
			local w=1.3
			verts={{-w,1,-1},{w,1,-1},{1,-1,-1},{-1,-1,-1},{-w,1,1},{w,1,1},{1,-1,1},{-1,-1,1}}
		elseif type == "head" then
			ty=1
			dx,dy,dz=1,1,.8
			local w1=1.2
			local w2=1.1
			verts={{-w1,1,-1},{w1,1,-1},{w2,-1,-1},{-w2,-1,-1},{-w1,1,1},{w1,1,1},{w2,-1,1},{-w2,-1,1}}
		elseif type == "armHigh" then
			ty=-1
			dx,dy,dz=.5,1.3,.5
			local w=1.3
			verts={{-w,1,-1},{w,1,-1},{1,-1,-1},{-1,-1,-1},{-w,1,1},{w,1,1},{1,-1,1},{-1,-1,1}}
		elseif type == "armLow" then
			ty=-1
			dx,dy,dz=.4,1.4,.4
		elseif type == "hand" then
			ty,tz=-1,-1
			dx,dy,dz=.4,.5,.1
		end
		dx,dy,dz = dx*scx,dy*scy,dz*scz

		local mesh=R.Mesh:new()
		for _,v in ipairs(verts) do
			mesh:addVertex(nil, R.V3:new((v[1]+tx)*dx, (v[2]+ty)*dy, (v[3]+tz)*dz))
		end

		for i,t in ipairs(quads) do
			mesh:addRenderable("quadFlatLit", {v1=t[1],v2=t[2],v3=t[3],v4=t[4]})

			if style == "outline" then
				mesh:addRenderable("line", {v1=t[1],v2=t[2]})
				mesh:addRenderable("line", {v1=t[2],v2=t[4]})
				mesh:addRenderable("line", {v1=t[3],v2=t[4]})
				mesh:addRenderable("line", {v1=t[3],v2=t[1]})
			end
		end

		if type == "pelvis" then
			mesh:addVertex("jLeftHip", R.V3:new((-.5+tx)*dx,(-1.5+ty)*dy,0))
			mesh:addVertex("jRightHip", R.V3:new((.5+tx)*dx,(-1.5+ty)*dy,0))
			mesh:addVertex("jWaist", R.V3:new(0,(1.5+ty)*dy,0))
		elseif type == "legHigh" then
			mesh:addVertex("jKnee", R.V3:new(0,(-1.2+ty)*dy,0))
		elseif type == "legLow" then
			mesh:addVertex("jAnkle", R.V3:new(0,(-1.2+ty)*dy,0))
		elseif type == "torso" then
			mesh:addVertex("jNeck", R.V3:new(0,(1.2+ty)*dy,0))
			mesh:addVertex("jLeftShoulder", R.V3:new((1.3+tx)*dx,(.75+ty)*dy,0))
			mesh:addVertex("jRightShoulder",R.V3:new((-1.3+tx)*dx,(.75+ty)*dy,0))
			mesh:addVertex("jLogo", R.V3:new(0,(.25+ty)*dy,1.05*dz))
		elseif type == "armHigh" then
			mesh:addVertex("jElbow", R.V3:new(0,(-1.2+ty)*dy,0))
		elseif type == "armLow" then
			mesh:addVertex("jWrist", R.V3:new(0,(-1.2+ty)*dy,0))
		elseif type == "head" then
			mesh:addVertex("jFace", R.V3:new(0,1*dy,1.05*dz))
		end

		return mesh
	end

	local function makeMeshLogo(sc)
		local mesh=R.Mesh:new()

		local verts={{-1,1,0},{1,1,0},{1,-1,0},{-1,-1,0}}
		for _,v in ipairs(verts) do
			mesh:addVertex(nil, R.V3:new(v[1]*sc, v[2]*sc, 0))
		end
		mesh:addRenderable("quadTexChest", {v1=1,v2=2,v3=3,v4=4})

		return mesh
	end

	local function makeMeshFace(sc, texFaceID)
		local mesh=R.Mesh:new()

		local verts={{-1.1,1,0},{1,1,0},{1,-1,0},{-1.1,-1,0}}
		for _,v in ipairs(verts) do
			mesh:addVertex(nil, R.V3:new(v[1]*sc, v[2]*sc, 0))
		end
		mesh:addRenderable(texFaceID, {v1=1,v2=2,v3=3,v4=4})

		return mesh
	end

	-- style: nil, outline
	local function makeModelFigure(style, scx, scy, scz, texFaceID)
		local model=R.Model:new()

		style = style or "regular"
		texFaceID = texFaceID or "quadTexFace"

		model:addMeshTemplate("mtPelvis",makeMeshTemplate("pelvis", style, scx, scy, scz))
		model:addMeshTemplate("mtLegHigh", makeMeshTemplate("legHigh", style, scx, scy, scz))
		model:addMeshTemplate("mtLegLow", makeMeshTemplate("legLow", style, scx, scy, scz))
		model:addMeshTemplate("mtFoot", makeMeshTemplate("foot", style, scx, scy, scz))
		model:addMeshTemplate("mtTorso", makeMeshTemplate("torso", style, scx, scy, scz))
		model:addMeshTemplate("mtHead", makeMeshTemplate("head", style, scz, scz, scz))
		model:addMeshTemplate("mtArmHigh", makeMeshTemplate("armHigh", style, scx, scy, scz))
		model:addMeshTemplate("mtArmLow", makeMeshTemplate("armLow", style, scx, scy, scz))
		model:addMeshTemplate("mtHand", makeMeshTemplate("hand", style, scx, scy, scz))
		model:addMeshTemplate("mtLogo", makeMeshLogo(scx*2, scy*2, scz*2))
		model:addMeshTemplate("mtFace", makeMeshFace(scx*.85, texFaceID))
	
		model:addMeshInstance("miPelvis",nil,"mtPelvis",R.Quaternion:newFromEuler(0,0,0))
		model:addMeshInstance("miLeftLegHigh",{"miPelvis","jLeftHip"},"mtLegHigh",R.Quaternion:newFromEuler(0,0,0))
		model:addMeshInstance("miLeftLegLow",{"miLeftLegHigh","jKnee"},"mtLegLow",R.Quaternion:newFromEuler(0,0,0))
		model:addMeshInstance("miLeftFoot",{"miLeftLegLow","jAnkle"},"mtFoot",R.Quaternion:newFromEuler(0,0,0))
		model:addMeshInstance("miRightLegHigh",{"miPelvis","jRightHip"},"mtLegHigh",R.Quaternion:newFromEuler(0,0,0))
		model:addMeshInstance("miRightLegLow",{"miRightLegHigh","jKnee"},"mtLegLow",R.Quaternion:newFromEuler(0,0,0))
		model:addMeshInstance("miRightFoot",{"miRightLegLow","jAnkle"},"mtFoot",R.Quaternion:newFromEuler(0,0,0))
		model:addMeshInstance("miTorso",{"miPelvis","jWaist"},"mtTorso",R.Quaternion:newFromEuler(0,mPI,0))
		model:addMeshInstance("miHead",{"miTorso","jNeck"},"mtHead",R.Quaternion:newFromEuler(0,0,0))
		model:addMeshInstance("miLeftArmHigh",{"miTorso","jLeftShoulder"},"mtArmHigh",R.Quaternion:newFromEuler(0,0,mPI*.5))
		model:addMeshInstance("miLeftArmLow",{"miLeftArmHigh","jElbow"},"mtArmLow",R.Quaternion:newFromEuler(0,0,0))
		model:addMeshInstance("miLeftHand",{"miLeftArmLow","jWrist"},"mtHand",R.Quaternion:newFromEuler(0,0,0))
		model:addMeshInstance("miRightArmHigh",{"miTorso","jRightShoulder"},"mtArmHigh",R.Quaternion:newFromEuler(0,0,-mPI*.5))
		model:addMeshInstance("miRightArmLow",{"miRightArmHigh","jElbow"},"mtArmLow",R.Quaternion:newFromEuler(0,0,0))
		model:addMeshInstance("miRightHand",{"miRightArmLow","jWrist"},"mtHand",R.Quaternion:newFromEuler(0,0,0))
		model:addMeshInstance("miLogo",{"miTorso","jLogo"},"mtLogo",R.Quaternion:newFromEuler(0,0,0))
		model:addMeshInstance("miFace",{"miHead","jFace"},"mtFace",R.Quaternion:newFromEuler(0,0,0))
		
		return model
	end


	local function constrainSkeleton(actor)
		local skeleton = actor.skeleton
		skeleton:setJointRange({"miPelvis","jLeftHip"},.05,.4,.1,.3,-.1,.25)
		skeleton:setJointRange({"miLeftLegHigh","jKnee"},-.4,.4,0,0,0,0)
		skeleton:setJointRange({"miLeftLegLow","jAnkle"},-.1,.3,.1,.15,0,.1)
		skeleton:setJointRange({"miPelvis","jRightHip"},.05,.4,-.1,-.3,.1,-.25)
		skeleton:setJointRange({"miRightLegHigh","jKnee"},-.4,.4,0,0,0,0)	
		skeleton:setJointRange({"miRightLegLow","jAnkle"},-.1,.3,-.1,.15,0,.1)
		skeleton:setJointRange({"miPelvis","jWaist"},-.35,.4,0,.25,0,.25)
		skeleton:setJointRange({"miTorso","jNeck"},.15,.3,0,.4,0,.15)	
		skeleton:setJointRange({"miTorso","jLeftShoulder"},0,.2,-.4,.45,-.1,.5)
		skeleton:setJointRange({"miLeftArmHigh","jElbow"},-.45,.45,0,.1,0,0)
		skeleton:setJointRange({"miLeftArmLow","jWrist"},-.45,.35,0,.2,0,.15)
		skeleton:setJointRange({"miTorso","jRightShoulder"},0,.2,.4,-.45,.1,-.5)
		skeleton:setJointRange({"miRightArmHigh","jElbow"},-.45,.45,0,.1,0,0)
		skeleton:setJointRange({"miRightArmLow","jWrist"},-.45,.35,0,.2,0,.15)
	end

	return makeModelFigure, constrainSkeleton
end

end

rift_codegfxfacerains=function()
local pal = "07F800cKBMBMCNFHCNFBLODDFPONHHFPPNMFHHKAPAHIDHLEGFCBHJHJCGDPGLDNFJMBEGKGPDHPOHPEPEPEPEJALCMGFMGGIDDMDHF0"
local gfx = "0800020AAF2A3EFJFFEFAEF5AEF4JAAF4JAAF4JAAEF2JJAAEF4EJK5FK6JK6GK14GJK27GBK6FK6GK6JK13GJK15A2F2AAFBFFGFBAF5BAGF4BAGF4AAGF4AAGGF2BAAF4BA5EF2A4EFFA5FFA12MPPA2EFBA4F2JKA2FBAFFJFK5FJK5FFK5AAFJK3PDAFFK2A2EFFKKFBAAFFKKBA2F2K6FGK5GFK5FFK3GFAAK2FFAMPKKFFBA2KKFFAAEFKF2A2EF2BA3FFBA4FFA13PPDA6EFBA2KGF2A2FFAEFA6MP2EFAP4EFMPAMDPEFPAAPAPANPAMPAPPMEAMPAMPPFBMDAAPPEFA3P3DAEFP4DAAPPAAPDFKPPAAMDJKPPEAADFKPPEAAPEKPDA2PDAAEBFBPPAFBAMP3AAMP4KFMPAAPPKGMDAAPPKFMAABPPKBPAABPPAMPA2MPAPPEFEBAP2DA3P4AFBPMDAPDFBPAPAAPFBPAPDAPHADAPDABDPAAMDEFPPA3FBPPAPEFBAAEFPFFBA2FPBFBABAFPF2AF2PEF5PF6MHFBF3MHFGF6BPAF4APEKAEFBMHFJFEFBPLGJF2BPDFKFBFAPPEKFFAAPDFKFFAMPDFKFAPEF3KBPAF3GFNDEFBAGJOPEFBFKFMPEF2KBPPAFEFKFMPAAFFKFMPDAFFBAAEFBPA3EFFPFAEAEFEPF2AF2PF5BPF6PF3EFNDF3JFNDFFNPF4EBPHFFJKEFMPHFJKEFBP4EF2NP2EF6EF4KKEF3JKKFFBMDDEKGFBPADFKKOPPAAFKP2A2FKPPFBAAFK2GA2FFKKGA2FFKKGA2FJKBMMDEFFKFMAPEFJKFAAPPLKKFA2P2KFAAEFPPFFA2JKKFFA2JKKGFA2JKKF4PHFKGFFNPEBKGFNPDFBP4EFBP2HF2BF6BKKF4BKKGF3BEF2K3AFFJK3AFFJK3AF3K2AF3JKKEF2GJKKF2JGJKKAF2GJK3GA2FK2GA2JK2GA2JK2FBAAEK2FFA2FKGFFBAAEKKFFBAABGJFFBAFFKFA2JK2GA2JK2GA2JK2BAAEFKKFA2FFKKBAAEFFJKEAAEFFKKFFAEFFGJK3F2BK3GFFAK3GFFAK2F3AKKGF3AKKGJF2BKKGJGF2KKGJF2AEF2GFKKAF2GF2AF4JFAF4KGAF3JKGAEF3KKAEF3KKAEF3KKF2BF10KFFEFFJKKFBEF2KKFBAAF2JFFA5FFAMPDAAF2A4F3EF2KF6KKGFFBFFKKF2BEFGF2AAEFA5FFAAMPDAFFA4F2KKFJF2BF2JF2AFGF4AJKF4AJKGF3AKKF3BAKKF3BAKKF3BAAEF2K2AEF3JGAAF3JGPAF3KKPAF3JKPAEF2JFPDAF4PDAF4GF2EAAF9JF13GF6GF10JKJF4JGF2AABF2JF13GF15JF6JFGKGF5JGF3K2F2BAJGF3BAJGF3AAKKF3APKGF3APFGF2BAPF4AMPF4AMP0"

return function(R)
    return gfx, pal
end

end

rift_code3d2modelasteroid=function()
return function(R)
	local mSqrt, mRand = math.sqrt, math.random

	local function midpointV3(v1, v2)
		return R.V3:new((v1.x + v2.x) / 2, (v1.y + v2.y) / 2, (v1.z + v2.z) / 2)
	end

	local function shiftV3(m, v)
		for _,squidgeV3 in ipairs({R.V3:new(6, -4, 2), R.V3:new(-4, 3, 5), R.V3:new(2, -3, -6)}) do
			local diffV3 = v - squidgeV3
			local len = diffV3:length()
			if len < 10 then
				local mul = m*((10-len)/10)
				v = v + R.V3:new(m, m, m)
			end
		end
		v = v + R.V3:new(mRand(), mRand(), mRand())
		return v
	end

	local function getName(k1, k2)
		if k1 <= k2 then
			return k1 .. "-" .. k2
		end
		return k2 .. "-" .. k1
	end

	local function makeMeshTemplateAsteroid()
		local sc = 8
		local phi = (1 + mSqrt(5)) / 2

		local verts = {
			{1, phi, 0},
			{1, -phi, 0},
			{-1, phi, 0},
			{-1, -phi, 0},
			{phi, 0, 1},
			{phi, 0, -1},
			{-phi, 0, 1},
			{-phi, 0, -1},
			{0, 1, phi},
			{0, 1, -phi},
			{0, -1, phi},
			{0, -1, -phi}
		}

		for _,v in ipairs(verts) do
			v[1] = v[1] * sc
			v[2] = v[2] * sc
			v[3] = v[3] * sc
		end

		local tris = {
			{1,9,5}, {1,5,6}, {1,6,10}, {1,10,3}, {1,3,9},
			{4,11,7},{4,2,11}, {4,12,2}, {4,8,12}, {4,7,8},
			{9,11,5}, {5,2,6}, {6,12,10}, {10,8,3}, {3,7,9},
			{9,7,11}, {5,11,2}, {6,2,12}, {10,12,8}, {3,8,7},
		}
	
		local mesh=R.Mesh:new()
		for _,v in ipairs(verts) do
			mesh:addVertex(nil, shiftV3(3, R.V3:new(v[1], v[2], v[3])))
		end
	
		local extraVs = {}
		for i,t in ipairs(tris) do
			local midpoint12Name = getName(t[1], t[2])
			local midpoint23Name = getName(t[2], t[3])
			local midpoint31Name = getName(t[3], t[1])
			local m12 = extraVs[midpoint12Name]
			local m23 = extraVs[midpoint23Name]
			local m31 = extraVs[midpoint31Name]
			local v1 = verts[t[1]]
			local v2 = verts[t[2]]
			local v3 = verts[t[3]]

            if m12 == nil then
				m12 = mesh:addVertex(nil, shiftV3(-1, midpointV3(R.V3:new(v1[1], v1[2], v1[3]), R.V3:new(v2[1], v2[2], v2[3]))))
				extraVs[midpoint12Name] = m12
			end
			if m23 == nil then
				m23 = mesh:addVertex(nil, shiftV3(-1, midpointV3(R.V3:new(v2[1], v2[2], v2[3]), R.V3:new(v3[1], v3[2], v3[3]))))
				extraVs[midpoint23Name] = m23
			end
			if m31 == nil then
				m31 = mesh:addVertex(nil, shiftV3(-1, midpointV3(R.V3:new(v3[1], v3[2], v3[3]), R.V3:new(v1[1], v1[2], v1[3]))))
				extraVs[midpoint31Name] = m31
			end

			count = 0
			for k,v in pairs(extraVs) do
				count = count + 1
			end

			-- Default skin:
			local matName = "triTextured"
			mesh:addRenderable(matName, {v1=m12,v2=m23,v3=m31, t1={x=0,y=0},t2={x=1,y=0},t3={x=.5,y=1}})
			mesh:addRenderable(matName, {v1=t[1],v2=m12,v3=m31, t1={x=0,y=1},t2={x=1,y=1},t3={x=.5,y=0}})
			mesh:addRenderable(matName, {v1=t[2],v2=m23,v3=m12, t1={x=1,y=0},t2={x=1,y=1},t3={x=0,y=.5}})
			mesh:addRenderable(matName, {v1=t[3],v2=m31,v3=m23, t1={x=1,y=1},t2={x=1,y=0},t3={x=0,y=.5}})

			matName = "triFlatLit"
			local skinID = "flatLit"
			mesh:addRenderable(matName, {v1=m12,v2=m23,v3=m31, t1={x=0,y=0},t2={x=1,y=0},t3={x=.5,y=1}}, skinID)
			mesh:addRenderable(matName, {v1=t[1],v2=m12,v3=m31, t1={x=0,y=1},t2={x=1,y=1},t3={x=.5,y=0}}, skinID)
			mesh:addRenderable(matName, {v1=t[2],v2=m23,v3=m12, t1={x=1,y=0},t2={x=1,y=1},t3={x=0,y=.5}}, skinID)
			mesh:addRenderable(matName, {v1=t[3],v2=m31,v3=m23, t1={x=1,y=1},t2={x=1,y=0},t3={x=0,y=.5}}, skinID)

			-- #TODO This is likely over drawing multiple times
			mesh:addRenderable("line", {v1=t[1],v2=m12}, "outline")
			mesh:addRenderable("line", {v1=m12,v2=t[2]}, "outline")
			mesh:addRenderable("line", {v1=t[2],v2=m23}, "outline")
			mesh:addRenderable("line", {v1=m23,v2=t[3]}, "outline")
			mesh:addRenderable("line", {v1=t[3],v2=m31}, "outline")
			mesh:addRenderable("line", {v1=m31,v2=t[1]}, "outline")
			mesh:addRenderable("line", {v1=m12,v2=m23}, "outline")
			mesh:addRenderable("line", {v1=m23,v2=m31}, "outline")
		end
		
		return mesh
	end

	local function makeModel()
		local model=R.Model:new()

		model:addMeshTemplate("mtAsteroid", makeMeshTemplateAsteroid())
		model:addMeshInstance("miRoot",nil,"mtAsteroid",R.Quaternion:newFromEuler(0,0,0))

		return model
	end

	return makeModel
end

end

rift_codevector=function()
rift_codedrawing()

local S,C,ATAN2,SQRT=math.sin,math.cos,math.atan2,math.sqrt
local MIN,MAX=math.min,math.max

-- vector definition:
-- POINT = {x=.,y=.}
-- CHAIN = {ps={POINT,POINT,...},loop=true}    // l=loop
-- VECTOR = {chains={CHAIN,CHAIN,...},bbox={}} -- not everything needs a bbox (needed for letter spacing)

-- def is in unit space (-1 to 1)
-- isLoop joins first and last points
-- c is colour
function ppVectorDraw(pixplane, vectorDef, dots)
    for _, chain in ipairs(vectorDef.chains) do
        local ps=chain.ps
        local firstP, prevP = ps[1], ps[1]
        for i=2,#ps do
            local p=ps[i]
            ppDrawLine(pixplane, prevP.x,prevP.y,p.x,p.y, dots)
            prevP=p
        end
        if chain.loop then
            ppDrawLine(pixplane, prevP.x,prevP.y,firstP.x,firstP.y, dots)    
        end
    end
end


function ppVectorDrawWithWarp(pixplane, vectorDef, x, y, fnWarp, dots)
    for _, chain in ipairs(vectorDef.chains) do
        local ps = chain.ps
        local firstPx = fnWarp(x+ps[1].x, y+ps[1].y)
        local prevPx = firstPx
        for i=2,#ps do
            local p=ps[i]
            local px = fnWarp(x+p.x, y+p.y)
            ppDrawLine(pixplane, prevPx.x,prevPx.y,px.x,px.y, dots)
            prevPx=px
        end
        if chain.loop then
            ppDrawLine(pixplane, prevPx.x,prevPx.y,firstPx.x,firstPx.y, dots)    
        end
    end
end

-- includes a rotation (expensive if we don't need it)
function vectorTransformPoints(vectorDef, x, y, scX, scY, r)
    local vectorDefOut = {chains={},bbox=nil}
    for _, chain in ipairs(vectorDef.chains) do
        local psIn = chain.ps
        local psOut = {}
        for i=1,#psIn do
            local p=psIn[i]
            local a=ATAN2(p.y,p.x)+r
            local d=SQRT(p.x^2+p.y^2)
            table.insert(psOut, {
                x=x+C(a)*d*scX,
                y=y+S(a)*d*scY,
            })
        end
        table.insert(vectorDefOut.chains, {ps=psOut, loop=chain.loop})
    end
    return vectorDefOut
end

-- Precalc to convert our vector-point font into a vector definition
function vectorLetterToDef(letterDef)
    local chains = {}
    local chain = {ps={},loop=false}
    local xLow,xHigh=0,0
    for _, pos in ipairs(letterDef) do
        if pos == 0 then
            table.insert(chains, chain)
            chain = {ps={},loop=false}
        else
            local x=((pos-1)%3/2 - .5) * .6    -- Slimness of characters!
            local y=(pos-1)//3/4 - .5
            xLow = MIN(xLow, x)
            xHigh = MAX(xHigh, x)

            -- (#TODO: lwidth)
            table.insert(chain.ps, {
                x=x,
                y=y,
            })
        end
    end

    -- Add anything left in the chain...
    table.insert(chains, chain)

    -- recentre chains...
    local w=xHigh-xLow
    local xShift = w/2
    for _, chain in ipairs(chains) do
        for _, p in ipairs(chain.ps) do
            p.x = p.x + xLow - xShift
        end
    end

    return {chains=chains,bbox={w=w,h=1}}
end

function vecfontConvertToDefs(vecFont)
    local defs = {}
    for k,v in pairs(vecFont) do
        defs[k] = vectorLetterToDef(v)
    end
    return defs
end

function ppVecFontPrint(pixplane, vecFont, x, y, str, sc, dots)
    local xStart = x
    local scX, scY = sc, sc
    for i=1,#str do
        local letter = str:sub(i,i)
        if letter == "\n" then
            x = xStart
            y = y + 1.5 * scY
        elseif letter == " " then
            x = x + .5 * scX
        else
            local def = vecFont[letter]
            if def then
                local defT = vectorTransformPoints(def, x, y, scX, scY, 0)
                ppVectorDraw(pixplane, defT, dots)
                x = x + (def.bbox.w + .35) * scX
            end
        end
    end
    return x-xStart
end

function ppVecFontPrintWithWarp(pixplane, vecFont, str, fnWarp, dots)
    local x0 = 0
    local x = x0
    local y = 0
    for i=1,#str do
        local letter = str:sub(i,i)
        if letter == "\n" then
            x = x0
            y = y + 1.5
        elseif letter == " " then
            x = x + .5
        else
            local def = vecFont[letter]
            if def then
                ppVectorDrawWithWarp(pixplane, def, x, y, fnWarp, dots)
                x = x + def.bbox.w + .35
            end
        end
    end
    return x-x0 -- TODO: fix for newlines
end

function vectorDraw(vectorDef, c)
    for _, chain in ipairs(vectorDef.chains) do
        local ps=chain.ps
        local firstP, prevP = ps[1], ps[1]
        for i=2,#ps do
            local p=ps[i]
            line(prevP.x,prevP.y,p.x,p.y, c)
            prevP=p
        end
        if chain.loop then
            line(prevP.x,prevP.y,firstP.x,firstP.y, c)    
        end
    end
end

function vecFontPrint(vecFont, x, y, str, sc, c)
    local xStart = x
    local scX, scY = sc * .6, sc
    for i=1,#str do
        local letter = str:sub(i,i)
        if letter == "\n" then
            x = xStart
            y = y + 1.5 * scY
        elseif letter == " " then
            x = x + .5 * scX
        else
            local def = vecFont[letter]
            if def then
                local defT = vectorTransformPoints(def, x, y, scX, scY, 0)
                vectorDraw(defT, c)
                x = x + (def.bbox.w) * scX + 2
            end
        end
    end
    return x-xStart
end

end

rift_demorunner=function()
--- Functions to control demo timing and coordinate parts
-- @module demo.demorunner
-- @author jtruk
return function(R)
    R=R or {}
	rift_soundmusic()(R)
	rift_sysmath()(R)

	R.DemoRunner={}

	--- Create a new DemoRunner object.
	function R.DemoRunner:new()
		local o={
			isShowDebug=false,
			parts={},
			currentPart=nil,
			isPartFirstRun=true,
			prevMusicFrame=0,
			cuedMusic=nil,
			musicFrames=0,
			prevFrameBDRms=nil,
		}
		setmetatable(o,self)
		self.__index=self
		return o
	end

	--- Add a demo part that runs for a number of tics.
	-- @tparam DemoPart part
	-- @tparam ?int tics (default=100)
    function R.DemoRunner:addPartTics(part, tics)
		tics=tics or 100
        self.parts[#self.parts+1]={type='tics',part=part,tics=tics}
    end

	--- Add a demo part that runs for [frames] music frames.
	-- @tparam DemoPart part
	-- @tparam int frames (default=1)
	function R.DemoRunner:addPartMusic(part, frames)
		frames=frames or 1
        self.parts[#self.parts+1]={type='music',part=part,frames=frames}
    end

	--- Cue a track to start.
	-- @tparam int track
	function R.DemoRunner:addCueMusic(track, frame)
		frame = frame or -1
        self.parts[#self.parts+1]={type='cue-music',track=track,frame=frame}
    end

	--- Cue a track to stop at this point.
	function R.DemoRunner:addStopMusic()
        self.parts[#self.parts+1]={type='stop-music'}
    end

	--- Switch the debug display on or off.
	-- @tparam bool flag
	function R.DemoRunner:setShowDebug(flag)
		self.isShowDebug=flag
	end

	--- Run the demorunner (call this once per tic).
	-- @treturn value isExit - currently always returns non-false. true for natural exit, or exitSignal if supplied by a part.
	function R.DemoRunner:run()
		if self.currentPart==nil then
			-- do preboots...
			for i=1,#self.parts do
				local part=self.parts[i]
				-- yuk
				if part.part and part.part.preboot then
					part.part.preboot()
				end
			end

			self.currentPart=1
		end

		-- Repeat over the non-frame ending operations.
		-- Also manage exiting.
		repeat
			local partDef = self.parts[self.currentPart]
			local partHasEnded, exitRunnerSignal = self:doCurrentPart(partDef)

			-- cleanup...
			if partHasEnded or exitRunnerSignal then
				if partDef.part and partDef.part.cleanup then
					partDef.part.cleanup()
				end
			end

			if exitRunnerSignal then
				return exitRunnerSignal
			end

			if partHasEnded then
				self.currentPart = self.currentPart+1
				if self.currentPart > #self.parts then
					return true
				end

				self.isPartFirstRun = true
			end
		until(true)
	end

	--- Run the demorunner (call this once per tic).
	-- @local
	-- @tparam DemoPart partDef
	-- @treturn {partHasEnded, exitRunnerSignal}
	--
	-- partHasEnded -> Natural end to this part - move on to next demopart.
	-- exitRunnerSignal -> non-false if we should end the demorunner. If it's false then keep running through demoparts as normal.
	function R.DemoRunner:doCurrentPart(partDef)
		if partDef.type=='cue-music' then
			self.cuedMusic={track=partDef.track,frame=partDef.frame}
			return true,false
		elseif partDef.type=='stop-music' then
			music()
			return true,false
		end

		local part=partDef.part

		local partMetrics={
			isFirstRun=self.isPartFirstRun,
			isLastRun=false,
			progress=0,
			musFrameProgress=nil,
		}

		partMetrics.ticsTotal=R.getTics()
		if partMetrics.isFirstRun then
			self.startTics=partMetrics.ticsTotal
			self.musicFrames=0
		end
		partMetrics.tics=partMetrics.ticsTotal-self.startTics

		local musPos=R.music.getPos()
		local musMeta=R.music.getTrackMeta(musPos.track)
		local isEndOfPart=false

		if partMetrics.isFirstRun and self.cuedMusic then
			music(self.cuedMusic.track,self.cuedMusic.frame)
			musPos.pattern=self.cuedMusic.frame
			self.prevMusicFrame=self.cuedMusic.frame
			self.cuedMusic=nil
		end

		if partDef.type == 'tics' then
			partMetrics.progress = partMetrics.tics/partDef.tics
			partMetrics.isLastRun = partMetrics.progress>=1
		elseif partDef.type == 'music' then
			-- #TODO: This won't work if we're jumping music frames
			if musPos.pattern ~= self.prevMusicFrame then
				self.musicFrames = self.musicFrames+1

				partMetrics.isLastRun = self.musicFrames>=partDef.frames
			end

			local elapsed = partMetrics.tics/60
			local rowsDone = elapsed*musMeta.rowsPerSec
			local frames, frameProgress=math.modf(rowsDone / musMeta.rows)
			partMetrics.musFrameProgress=frames+frameProgress
			
			-- This is the actual music progress:
			-- #TODO~: Sync if this falls behind?
--			partMetrics.musFrameProgress=self.musicFrames+musPos.row/64
			partMetrics.progress = partMetrics.musFrameProgress / partDef.frames
			self.prevMusicFrame=musPos.pattern
		end
		
		partMetrics.progress = R.clamp(partMetrics.progress,0,1)

		local ts=time()
		-- Return non-false from a tic() to end this part. Return anything other than true to end the entire runner loop, for an abort or secret part :)
		local exitRunnerSignal = part.tic(partMetrics)
		local elapsed = time()-ts

		-- This means extra function calls when debugging on each scanline, which is suboptimal!
		if not part.bdr then
			self.prevFrameBDRms=nil
			BDR=nil
		elseif self.isShowDebug==false then
			-- run as optimally as possible...
			BDR=function(y)
				part.bdr(y,partMetrics)
			end
		else
			-- NB The palette switch sets vbank to 1 behind the user's back - not ideal
			--	But I don't think we have access to the current vbank id to reset it
			--  Assume vbank=0 is desirable for exit
			--  #TODO: Maybe wrap vbank() call to track it?
			local stashPal={}
			local debugPal={64,64,64,255,255,255,255,64,128}

			BDR=function(y)
				if y==0 then
					ts=time()
				end

				if y==140 then
					-- Unstash palette (see stashing below)
					for i=1,#stashPal do
						poke(0x3fc0+i+2,stashPal[i])
					end
				end

				part.bdr(y,partMetrics)

				-- Switch to alternate palette for rendering the debug info...
				if y>=132 and y<=139 then
					vbank(1)
					if y==132 then
						-- stash palette
						for i=1,#debugPal do
							stashPal[i]=peek(0x3fc0+i+2)
						end
					end

					for i=1,#debugPal do
						poke(0x3fc0+i+2,debugPal[i])
					end
				end

				if y==143 then	-- Final BDR line - get frame time
					self.prevFrameBDRms=time()-ts
				end
			end
		end

		self.isPartFirstRun=false
		
		if self.isShowDebug then
			vbank(1)
			rect(0,128,240,136,1)
			rect(0,128,partMetrics.progress*240,136,3)
			print(string.format("T:%.1f", R.getTimeMS()/1000),2,129,2,true)
			print(string.format("TIC:%d", R.getTics()),50,129,2,true)
			-- NB: This is the previous frame's BDR time!
			local prevFrameBDRms=(self.prevFrameBDRms==nil) and 0 or self.prevFrameBDRms
			local allTime=elapsed+prevFrameBDRms
			print(string.format("FR:%2d(%2d/%2d)", allTime//1, elapsed//1, prevFrameBDRms//1),100,129,2,true)
			local musText=musPos.track==255 and "M: (none)" or string.format("M:%02d-%02d-%02d", musPos.track, musPos.pattern, musPos.row)
			print(musText,180,129,2,true)
			local doTimeBar=function(x,h)
				local ySt=127-h
				line(x,ySt,x,127,1)
				rect(x+1,ySt,10,h+1,8)
				line(x+11,ySt,x+11,127,15)
			end
			doTimeBar(20*6,allTime)
			doTimeBar(23*6,elapsed)
			doTimeBar(26*6,prevFrameBDRms)
		end

		return partMetrics.isLastRun, exitRunnerSignal
	end
end

end

rift_partsflightfractalus=function()
R=R or {}

rift_demopart()(R)
rift_code3d()
rift_3d2engine()(R)
rift_3d2scene()(R)
rift_3d2model()(R)
rift_3d2mesh()(R)
rift_3d2actor()(R)
rift_3d2material()(R)
rift_3d2skeleton()(R)
rift_3d2v3()(R)
rift_3d2m44()(R)
rift_3d2quaternion()(R)
rift_codepixplane()
rift_codedrawingpixplane()
local makeModelShip = rift_code3d2modelship()(R)

local mSin,mCos,mPi=math.sin,math.cos,math.pi

local PIXPLANES
--local FN_PIXPLANES_MELT = ppGetDefaultFnMelt()
--local FN_PIXPLANES_TO_SCREEN = makeFnAcrossPixplanes("poke4(destA, math.min(pp1[srcA],15))")
local FN_PIXPLANES_MELT = makeFnAcrossPixplanes("pp1[srcA]=pp1[srcA]*.4")
local FN_PIXPLANES_TO_SCREEN = makeFnAcrossPixplanes("poke4(destA, math.min(pp1[srcA],15))")

local DOTS = ppGetDefaultDots()
local DOTS_FG = rift_codedotsship()
local PIXPLANE_FG

local ENGINE, CAMERA, SCENE
local ACTOR_SHIP

local matLine = R.Material.line(15)
local fnDraw = matLine.fnDraw
matLine.fnDraw = function(d)
    ppDrawLine(PIXPLANE_FG, d.v1.x,d.v1.y, d.v2.x,d.v2.y, DOTS_FG)
end

return R.DemoPart:new({
    preboot=function()
    end,
    bdr=function(y, pMetrics)
        vbank(0)
        local r = y/140
        setRGBSpread(1,15, 30,60*r,20, 60 + pMetrics.progress * 190,255 * r,20+200*r)
    end,
	tic=function(pMetrics)
        if pMetrics.isFirstRun then
            PIXPLANES=initPixplanes()
            PIXPLANE_FG=PIXPLANES[2]

            ENGINE = R.Engine:new()
            CAMERA = R.Camera:new(R2.V3:new(0,0,20), R.Quaternion:newFromEuler(0,0,0))
            SCENE = R.Scene:new(CAMERA)

            ENGINE:setMaterial("line", matLine)

            local model = makeModelShip()
			local modelID = ENGINE:addModel(model)
			
			ACTOR_SHIP = SCENE:newActor(modelID, R.V3:new(0,0,0), "miRoot")
            ACTOR_SHIP:setSkins({"outline"})

            vbank(0)
            setRGB(0,0,0,0)
            setRGBSpread(1,15, 10,60,20, 60,255,20)

            vbank(1)
            setRGBSpread(1,15, 30,30,30, 255,255,255)
        end

        local pixplaneBG=PIXPLANES[1]

        ppDefaultPixplanesMelt(FN_PIXPLANES_MELT, {pixplaneBG}, pMetrics.tics)
        ppDefaultPixplanesMelt(FN_PIXPLANES_MELT, {PIXPLANE_FG}, pMetrics.tics)

        local t = pMetrics.progress * 100
        local transX=mSin(t*.08)*.8+mSin(t*.05)*.6
        local transY=mSin(t*.15)*1
        local lerpTilt = 0
        if pMetrics.progress > 0.7 then
            lerpTilt = ((pMetrics.progress - .7)/(.3))^1.5
            transY = transY + lerpTilt * 15
        end

        local transZ=t*1.4
        for z=0,20,2 do
            local points={}
            for x=-20,20 do
                local y=4+(x^3+z^5)%20/9
                table.insert(points, {x=x,y=y,z=z})
            end

            local transZ=(z-transZ)%20
            if transZ == 0 then -- crashes if this is 0
                transZ = 0.01
            end
            transformPoints(points, transX*3,transY*2,transZ, 0,0,0)
            projectPoints(points)

            local lastP=points[1]
            for i=2,#points do
                local p=points[i]
                ppDrawLine(pixplaneBG, lastP.x,lastP.y,p.x,p.y, DOTS)
                lastP=p
            end
        end

        ACTOR_SHIP:setPosition(R.V3:new(-transX*6+lerpTilt*10,transY*3,-20))
        ACTOR_SHIP:setRotation(R.Quaternion:newFromEuler(lerpTilt * mPi,0,mSin(t/8)*.3))
        SCENE:render(ENGINE)

        vbank(0)
        FN_PIXPLANES_TO_SCREEN({pixplaneBG})
        vbank(1)
        FN_PIXPLANES_TO_SCREEN({PIXPLANE_FG})
	end,
})

end

rift_partsflightlinetunnel=function()
R=R or {}

rift_demopart()(R)
rift_3d2engine()(R)
rift_3d2scene()(R)
rift_3d2model()(R)
rift_3d2mesh()(R)
rift_3d2actor()(R)
rift_3d2material()(R)
rift_3d2skeleton()(R)
rift_3d2v3()(R)
rift_3d2m44()(R)
rift_3d2quaternion()(R)
rift_codepixplane()
rift_codedrawingpixplane()
local makeModelShip = rift_code3d2modelship()(R)

local mSin,mCos=math.sin,math.cos
local RANDOM=math.random
local CHRFLAG=true
local CHRARR={}
local CHPARR={}

local PIXPLANES
--local FN_PIXPLANES_MELT = ppGetDefaultFnMelt()
--local FN_PIXPLANES_TO_SCREEN = makeFnAcrossPixplanes("poke4(destA, math.min(pp1[srcA],15))")
local FN_PIXPLANES_MELT = makeFnAcrossPixplanes("pp1[srcA]=pp1[srcA]*.2")
local FN_PIXPLANES_TO_SCREEN = makeFnAcrossPixplanes("poke4(destA, math.min(pp1[srcA],15))")
local DOTS_BG = ppGetDefaultDots()
local DOTS_FG=rift_codedotsship()

local PIXPLANE_FG

local ENGINE, CAMERA, SCENE
local ACTOR_SHIP

local matLine = R.Material.line(15)
local fnDraw = matLine.fnDraw
matLine.fnDraw = function(d)
    ppDrawLine(PIXPLANE_FG, d.v1.x,d.v1.y, d.v2.x,d.v2.y, DOTS_FG)
end

local mPi = math.pi
local mSin = math.sin

return R.DemoPart:new({
    bdr=function(y, pMetrics)
        vbank(0)
        local r = y/140
        setRGBSpread(1,15, 60,10,20, 255,60+r*100,20)
    end,
    tic=function(pMetrics)
        if pMetrics.isFirstRun then
            PIXPLANES=initPixplanes()
            PIXPLANE_FG=PIXPLANES[2]

            ENGINE = R.Engine:new()
            CAMERA = R.Camera:new(R2.V3:new(0,0,20), R.Quaternion:newFromEuler(0,0,0))
            SCENE = R.Scene:new(CAMERA)

            ENGINE:setMaterial("line", matLine)

            local model = makeModelShip()
			local modelID = ENGINE:addModel(model)
			
			ACTOR_SHIP = SCENE:newActor(modelID, R.V3:new(0,0,0), "miRoot")
            ACTOR_SHIP:setSkins({"outline"})

            vbank(0)
            setRGB(0,0,0,0)
            setRGBSpread(1,15, 60,10,20, 255,60,20)

            vbank(1)
            setRGBSpread(1,15, 30,30,30, 255,255,255)
         end

         local progress = pMetrics.progress
         local pixplaneBG = PIXPLANES[1]
 
         ppDefaultPixplanesMelt(FN_PIXPLANES_MELT, {pixplaneBG}, pMetrics.tics)
         ppDefaultPixplanesMelt(FN_PIXPLANES_MELT, {PIXPLANE_FG}, pMetrics.tics)
 
        local t = progress * 100
        local musicRow=peek(0x13ffe)
        
        local angle=t/2
        
        local points={}
        local xshift=angle%10
        for x=-14,6 do -- -18,6
            for y=-2,2 do
                for z=-2,2 do
                    table.insert(points, {x=x+xshift,y=y,z=z})
                end
            end
        end

        local rotZ
        if pMetrics.progress < .25 then
            rotZ=1.6
        elseif pMetrics.progress < .5 then
            rotZ=0.6+angle/8
        elseif pMetrics.progress < .75 then
            rotZ=-1.1
        else
            rotZ=-1.1+angle/16
        end

        transformPoints(points, 0,0,3, angle/8,0,rotZ)
        projectPoints(points)

        local chramt=250
        local chp2=RANDOM()*2//1
        local pa=5
        --for i=0,1 do
        -- JTRUK: not sure what CHRFLAG is doing - think I messed this up
        if(pMetrics.tics%4<0.1) then CHRFLAG=false end
        if pMetrics.tics%4==0 and CHRFLAG==false then 
            for i=1,chramt do
                CHRARR[i]=(RANDOM()*(#points-6)+5)//1
                CHPARR[i]=(RANDOM()*3)//1
            end
            CHRFLAG=true
        end
--        CHRFLAG=false

        for i=1,#CHRARR do
            local chr=CHRARR[i]
            local chp=CHPARR[i]

            if chp==0 then pa=1
            elseif chp==1 and chr%25~=0 and chr%25<21 then pa=5
            elseif chp==2 then pa=25
            else pa=25 end

            if chr%5==0 then pa=-1 end
            if musicRow%4>1 then CHRFLAG=true end
            if chr+pa<#points then
                local p1=points[chr]
                local p2=points[chr+pa]
                ppDrawLine(pixplaneBG, p1.x,p1.y,p2.x,p2.y, DOTS_BG)
            end
        end


        --ACTOR_SHIP:setPosition(R.V3:new(0,5+mSin(t*.1)*5,3+mSin(t*.06)-30))
        --ACTOR_SHIP:setRotation(R.Quaternion:newFromEuler(angle*.4,0,rotZ))
--        ACTOR_SHIP:setRotation(R.Quaternion:newFromEuler(0,mPi/2-rotZ,angle*.4))
--        ACTOR_SHIP:setRotation(R.Quaternion:newFromEuler(0,0,mSin(pMetrics.progress*mPi)*.2))
        local xShift = 0
        if progress < .25 then
            xShift = -(1-progress/.25)^1.1*50
        end
        ACTOR_SHIP:setPosition(R.V3:new(
            mSin(progress*mPi*6)*4-20 + xShift,
            mSin(progress*mPi*4)*5,
            mSin(progress*mPi*3)*5-60
        ))
        ACTOR_SHIP:setRotation(R.Quaternion:newFromEuler(0,-mPi/2,mPi+rotZ))
        CAMERA:setRotation(R.Quaternion:newFromEuler(0,0,rotZ))
        SCENE:render(ENGINE)

        vbank(0)
        FN_PIXPLANES_TO_SCREEN({pixplaneBG})
        vbank(1)
        FN_PIXPLANES_TO_SCREEN({PIXPLANE_FG})
	end,
})

end

rift_3d2model=function()
return function(R)
	R=R or {}

	local Model={}

	function Model:new(rootMeshID)
		local o={
			meshTemplates={},	-- We can use a meshTemplate multiple times in our mesh tree
			meshTree={},		-- The skeleton... id -> [quaternion, distance, meshID, children]
			meshLookup={},		-- meshID -> mesh in meshTree (saves us searching it all)
		}
		setmetatable(o,self)
		self.__index=self
		return o
	end

	function Model:__tostring()
		return string.format("Model(no representation yet)")
	end

	-- meshID can/should be an indexable ID
	function Model:addMeshTemplate(id,mesh)
		self.meshTemplates[id]=mesh
	end

	-- parentRef: {meshInstanceID,jointID} or nil
	function Model:addMeshInstance(id,parentRef,meshID,quaternion)
		local meshInstance={
			meshID=meshID,
			quaternion=quaternion,
			children={},
		}

		id = (id == nil and #self.meshInstances+1) or id
		if parentRef == nil then
			-- this is a root node (special case - should it be?)
			self.meshTree[id] = meshInstance
			self.meshLookup[id] = self.meshTree[id]
		else
			local parentMeshNode = self.meshLookup[parentRef[1]]
			parentMeshNode.children[id]={meshInstance=meshInstance,joint=parentRef[2]}
			self.meshLookup[id] = parentMeshNode.children[id].meshInstance
		end
	end

	-- rootNodeID ~> suggest "root", but I think we could use this to do morphing / other things?
	function Model:addToRenderlist(engine, scene, position, modelQuaternion, skeleton, rootNodeID, skinIDs, actorData, renderlist)
		local meshInstance = self.meshTree[rootNodeID]

		self:_addSelfAndChildrenToRenderlist(engine, scene, position, modelQuaternion, rootNodeID, meshInstance, skeleton, skinIDs, actorData, renderlist)
	end

	function Model:_addSelfAndChildrenToRenderlist(engine, scene, basePosition, baseQuaternion, meshInstanceID, meshInstance, skeleton, skinIDs, actorData, renderlist)
		local meshQuaternion = R.Quaternion.multiply(baseQuaternion, meshInstance.quaternion)
		local meshTemplate = self.meshTemplates[meshInstance.meshID]

		meshTemplate:addToRenderlist(engine, scene, basePosition, meshQuaternion, skinIDs, actorData, renderlist)
		
		for childID, childNode in pairs(meshInstance.children) do
			local jointQuaternion = skeleton:getJoint({meshInstanceID, childNode.joint})
			if jointQuaternion == nil then
				jointQuaternion = R.Quaternion:newFromEuler(0,0,0)
			end

			local childPosition = basePosition + R.Quaternion.rotateV3(meshQuaternion, meshTemplate:vertex(childNode.joint))
			local childQuaternion = R.Quaternion.multiply(meshQuaternion, jointQuaternion)

			self:_addSelfAndChildrenToRenderlist(engine, scene, childPosition, childQuaternion, childID, childNode.meshInstance, skeleton, skinIDs, actorData, renderlist)
		end
	end

	R.Model = Model
end

end

rift_3d2quaternion=function()
return function(R)
	R=R or {}

	local Quaternion = {}
	
	local mSqrt,mSin,mCos = math.sqrt,math.sin,math.cos

	-- References:
	-- https://imadr.me/rotations-with-quaternions/
	-- https://github.com/topameng/CsToLua
	-- https://carbon-for-lua.readthedocs.io/en/stable/Classes/Math.Quaternion/

	function Quaternion:new(x,y,z,w)
		local o={
			x=x,y=y,z=z,w=w,
		}
		setmetatable(o,self)
		self.__index=self
		return o
	end

	function Quaternion:__tostring()
		return string.format("Q(%.3f,%.3f,%.3f->%.3f)",self.x,self.y,self.z,self.w)
	end

	function Quaternion.identity()
		return Quaternion:new(0,0,0,1)
	end

	-- axis is type v3
	--[[
	function Quaternion:newFromAxisAngle(v3, angle)
		local halfAngle = angle / 2
		local sinHalfA = mSin(halfAngle)
		return Quaternion:new(
			v3.x * sinHalfA,
			v3.y * sinHalfA,
			v3.z * sinHalfA,
			mCos(halfAngle)
		)
	end
	--]]

	function Quaternion:newFromEuler(rx, ry, rz)
		local cx,cy,cz,sx,sy,sz = mCos(rx/2),mCos(ry/2),mCos(rz/2),mSin(rx/2),mSin(ry/2),mSin(rz/2)
		return Quaternion:new(
			sx*cy*cz + cx*sy*sz,
			cx*sy*cz - sx*cy*sz,
			cx*cy*sz - sx*sy*cz,
			cx*cy*cz + sx*sy*sz
		)
	end
	
	function Quaternion:clone()
		return Quaternion:new(self.x,self.y,self.z,self.w)
	end

	function Quaternion:assign(x,y,z,w)
		self.x,self.y,self.z,self.w = x,y,z,w
	end
	
	function Quaternion.length(q)
		return mSqrt(q.x*q.x + q.y*q.y + q.z*q.z + q.w*q.w)
	end

	function Quaternion.imaginaryLength(q)
		return mSqrt(q.x*q.x + q.y*q.y + q.z*sqelf.z)
	end

	function Quaternion.cloneNormalized(q)
		local l = Quaternion.length(q)
		if l == 0 then
			return Quaternion:new(0,0,0,0)
		end
		return Quaternion:new(q.x/l,q.y/l,q.z/l,q.w/l)
	end

	function Quaternion:normalize()
		local l = Quaternion.length(self)
		if l == 0 then
			self.x,self.y,self.z,self.w = 0,0,0,0
		end
		self.x,self.y,self.z,self.w = self.x/l,self.y/l,self.z/l,self.w/l
	end

	function Quaternion:scale(s)
		self.x,self.y,self.z,self.w = self.x*s,self.y*s,self.z*s,self.w*s		
	end

	function Quaternion:invert()
		self.x,self.y,self.z,self.w = -self.x,-self.y,-self.z,self.w
	end

	-- aka conjugate
	function Quaternion:cloneInvert()
		return Quaternion:new(-self.x,-self.y,-self.z,self.w)
	end

	function Quaternion.multiply(q1, q2)
		local q1x,q1y,q1z,q1w,q2x,q2y,q2z,q2w = q1.x,q1.y,q1.z,q1.w,q2.x,q2.y,q2.z,q2.w
		return Quaternion:new(
			q1w*q2x + q1x*q2w + q1y*q2z - q1z*q2y,
			q1w*q2y - q1x*q2z + q1y*q2w + q1z*q2x,
			q1w*q2z + q1x*q2y - q1y*q2x + q1z*q2w,
			q1w*q2w - q1x*q2x - q1y*q2y - q1z*q2z
		)
	end

	function Quaternion.rotateV3(q, v3)
		local v = Quaternion.multiply(
			Quaternion.multiply(q, Quaternion:new(v3.x,v3.y,v3.z,0)),
			q:cloneInvert()
		)
		return R.V3:new(v.x,v.y,v.z)
	end

	--[[ #TODO: Does this work?
function quat_rotate(q, v)
	local w, x, y, z = q[1], q[2], q[3], q[4]
    local vx, vy, vz = v[1], v[2], v[3]
    
    -- Quaternion multiplication
    local qw = -x * vx - y * vy - z * vz
    local qx =  w * vx + y * vz - z * vy
    local qy =  w * vy + z * vx - x * vz
    local qz =  w * vz + x * vy - y * vx

    -- Return the rotated vector
    return {
        -qw * x + qx * w - qy * z + qz * y,
        -qw * y + qx * z + qy * w - qz * x,
        -qw * z - qx * y + qy * x + qz * w
    }
end
	]]--

	Quaternion.__eq = function(a,b)
		return Quaternion.dot(a, b) > 0.999999
	end

	R.Quaternion = Quaternion
end

end

rift_sysmath=function()
--- Helpers for Maths - clamps and easing
-- @module sys.math

return function(R)
    R=R or {}

    --- Clamp a value
    -- @param v A value
    -- @param min The lower bound
    -- @param max The upper bound
    R.clamp=function(v,min,max)
        return math.min(math.max(v,min),max)
    end

    --- Linear Interpolation bewteen two values
    -- @param t Time (0-1)
    -- @param v0 The value at T=0
    -- @param v1 The value at T=1
    R.lerp=function(t,v0,v1)
        return (1-t)*v0+t*v1
    end

    --- Quadratic Bézier
    -- @param t Time (0-1)
    -- @param v0 The value at T=0
    -- @param v1 The mid-value modifier
    -- @param v2 The value at T=1
    R.qBezier=function(t,v0,v1,v2)
        local tInv=1-t
        return (tInv*tInv*v0)+(tInv*t*v1)+(t*t*v2)
    end

    --- Cubic Bézier
    -- @param t Time (0-1)
    -- @param v0 The value at T=0
    -- @param v1 The first mid-value modifier
    -- @param v2 The second mid-value modifier
    -- @param v3 The value at T=1
    R.cBezier=function(t,v0,v1,v2,v3)
        local tInv=1-t
        return (tInv*tInv*tInv*v0)+(3*tInv*tInv*t*v1)+(3*tInv*t*t*v2)+(t*t*t*v3)
    end

    --- Smoothstep Easing function
    -- @param t Time (0-1)
    -- @param e0 The value at T=0
    -- @param e1 The value at T=1
    R.smoothStep=function(t,e0,e1)
        local s = (t-e0)/(e1-e0)
        local x = R.clamp(s,0,1)
        return e0 + (x * x * (3.0 - 2.0 * x))*(e1-e0)
    end

    --- Smootherstep Easing function
    -- @param t Time (0-1)
    -- @param e0 The value at T=0
    -- @param e1 The value at T=1
    R.smootherStep=function(t,e0,e1)
        local s = (t-e0)/(e1-e0)
        local x = R.clamp(s,0,1)
        return e0 + (x * x * x * (3.0 * x * (2.0 * x - 5.0) + 10.0))*(e1-e0)
    end
end

end

rift_codegfxasteroid=function()
local pal = "07F800cKBMBMCNFHCNFBLODDFPONHHFPPNMFHHKAPAHIDHLEGFCBHJHJCGDPGLDNFJMBEGKGPDHPOHPEPEPEPEJALCMGFMGGIDDMDHF0"
local gfx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

return function(R)
    return gfx, pal
end

end

rift_game=function()
return function(R)
	R=R or {}

	rift_codegamelogic()(R)

	local Game

	R.Game = Game

	local mCos, mSin, mAtan2, mSqrt, mPi = math.cos, math.sin, math.atan2, math.sqrt, math.pi
	local mAbs, mRandom = math.abs, math.random
	local mTau = mPi * 2

	rift_codevector()
	rift_codepixplane()
	rift_codedrawingpixplane()
	
	local vecDefFont = rift_codevectorfontasteroids()
	local vecDefShip, vecDefAsteroid, vecDefUFO, vecDefBullet = rift_codevectorasteroidsgame()()
	local setRGB, setPalette, setPaletteScaled, setPaletteAsteroids = rift_codepalette()(R)
	
	local PIXPLANES
	local FN_PIXPLANES_MELT = makeFnAcrossPixplanes("pp1[srcA]=pp1[srcA]*.7")
	local FN_PIXPLANES_TO_SCREEN = makeFnAcrossPixplanes("poke4(destA, math.min(pp1[srcA],15))")

	local DotDraw={}
	local d=6
	for y=-d,d do
		for x=-d,d do
			local p = 1-((x*x+y*y)^.7)/d
			if p>0 then
				p=(p^4)*1.5
				DotDraw[#DotDraw+1] = {x,y,p}
			end
		end
	end
	
	local Game={}
	local PIXPLANES = {}

	local screenXSc = 1

	function Game:new()
		local o={
			isFirstRun = true,
			logic = R.GameLogic:new(),
		}
		setmetatable(o,self)
		self.__index=self
		return o
	end

	function Game:tic()
		if self.isFirstRun then
			PIXPLANES=initPixplanes()
			vbank(0)
			cls()
			setPaletteAsteroids()

			vbank(1)
			cls()

			self.isFirstRun = false
		end

		local pixplaneGame=PIXPLANES[1]
		local renderlist, soundList, event = self.logic:tic()

		for _, asteroid in ipairs(renderlist.asteroids) do
			local vecDrawDef=vectorTransformPoints(vecDefAsteroid, asteroid.x,asteroid.y, asteroid.size * screenXSc, asteroid.size, asteroid.r)
			ppVectorDraw(pixplaneGame, vecDrawDef, DotDraw)
		end

		if renderlist.ufo then
			local ufo = renderlist.ufo
			local scale = 6 + ufo.size * 4
			local vecDrawDef=vectorTransformPoints(vecDefUFO, ufo.x,ufo.y, scale * screenXSc, scale, 0)
			ppVectorDraw(pixplaneGame, vecDrawDef, DotDraw)
		end

		if renderlist.isRecording then
			ppVecFontPrint(pixplaneGame, vecDefFont, 210, 10, "Record", 7, DotDraw)
		end

		ppVecFontPrint(pixplaneGame, vecDefFont, 10, 10, string.format("%05d", renderlist.score), 12, DotDraw)

		if  renderlist.state == "gameover" then
			ppVecFontPrint(pixplaneGame, vecDefFont, 104, 45, "GAME OVER", 12, DotDraw)
		else
			if renderlist.isReady then 
				ppVecFontPrint(pixplaneGame, vecDefFont, 112, 45, "READY", 12, DotDraw)
			end
		end

		for _, bullet in ipairs(renderlist.bullets) do
			local vecDrawDef=vectorTransformPoints(vecDefBullet, bullet.x,bullet.y, 1, 1, 0)
			ppVectorDraw(pixplaneGame, vecDrawDef, DotDraw)
		end

		local ship = renderlist.ship
		local shipScale = 6
		local vecDrawDef=vectorTransformPoints(vecDefShip, ship.x, ship.y, shipScale * screenXSc, shipScale, ship.r)
		ppVectorDraw(pixplaneGame, vecDrawDef, DotDraw)

		vbank(0)
		local persist = .6 + mRandom()*.2
		copyPixplaneToScreenAndDecay(pixplaneGame, persist)

		vbank(1)
		cls()
		for _, sound in ipairs(soundList) do
			if sound == "shoot" then
				sfx(0)
			elseif sound == "asteroid-split" then
				sfx(1, 10 + mRandom(0, 5), -1, 1)
			elseif sound == "explode" then
				sfx(1, 2, -1, 1)
			elseif sound == "thud-0" then
				sfx(2, 30, -1, 2, 6)
			elseif sound == "thud-1" then
				sfx(2, 28, -1, 2, 6)
			end
		end

		if event == "gameover" then
			local recording = self.logic:getRecording()
			local str = ""
			local doComma = false
			for _,event in ipairs(recording) do
				if doComma then
					str = str .. ",\n"
				end
				str = str .. tostring(event)
				doComma = true
			end
			str = "{" .. str .. "}"
			trace(str)
		end
	end
	
	R.Game = Game
end

end

rift_partsprelaunch=function()
local R2 = {}	-- hack!

rift_demopart()(R)
rift_syssys()(R)
rift_syscatmullrom()(R)
rift_3d2engine()(R2)
rift_3d2scene()(R2)
rift_3d2model()(R2)
rift_3d2mesh()(R2)
rift_3d2actor()(R2)
rift_3d2material()(R2)
rift_3d2skeleton()(R2)
rift_3d2v3()(R2)
rift_3d2m44()(R2)
rift_3d2quaternion()(R2)
local makeModelShip = rift_code3d2modelship()(R2)
local makeModelFigure, constrainSkeleton = rift_code3d2modelfigure()(R2)
local makeModelIrisDoor = rift_code3d2modelirisdoor()(R2)
local setRGB, setPalette = rift_codepalette()(R)
local materialRedFlashingLight = rift_codematerialredflashinglight()(R2)
local quadShadedLit, triShadedLit, makeLinearPalMap, fnChoosePalMapIndexUnitNegToPos, fnChoosePalMapIndexUnitFacing, quadTunnelLight, triTunnelLight = rift_codematerialflatlitpalettemap()(R2)

local mSin, mCos = math.sin, math.cos
local mPi = math.pi
local mTau = mPi * 2
local mMin, mMax = math.min, math.max

local scrTexX, scrTexY, scrTexW, scrTexH = 0,0,64,64

local ENGINE_BG, ENGINE_FG, CAMERA, SCENE_FG, LIGHT
local ACTORS = {}
local N_IRIS_BLADES = 10

local camSpline = R.CatmullRomSpline:new()
camSpline:setValueInterpolater(
	function(t, v0, v1, v2, v3)
		return {
			pos = R2.V3:new(
				R.catmullRom(t, v0.pos.x, v1.pos.x, v2.pos.x, v3.pos.x),
				R.catmullRom(t, v0.pos.y, v1.pos.y, v2.pos.y, v3.pos.y),
				R.catmullRom(t, v0.pos.z, v1.pos.z, v2.pos.z, v3.pos.z)
			),
			fov = R.catmullRom(t, v0.fov, v1.fov, v2.fov, v3.fov),
		}
	end
)
camSpline:addValue(0, {pos=R2.V3:new(-3,3,30), fov=40})
camSpline:addValue(.6, {pos=R2.V3:new(5,0,20), fov=100})
camSpline:addValue(.8, {pos=R2.V3:new(5,0,20), fov=80})
camSpline:addValue(1, {pos=R2.V3:new(0,10,-10), fov=80})

return R.DemoPart:new({
	tic=function(pMetrics)
		if pMetrics.isFirstRun then
			vbank(1)
			setRGB(0,0,0,0)
			setRGBSpread(1,8, 40,40,40, 255,255,255)
			setRGBSpread(10,15, 10,10,120, 60,60,255)

			CAMERA = R2.Camera:new(R2.V3:new(0,0,20), R2.Quaternion:newFromEuler(0,0,0))
			LIGHT = R2.V3:new(0,-1,1)
			LIGHT:normalize()
			ENGINE_FG = R2.Engine:new()
			ENGINE_BG = R2.Engine:new()
			SCENE_FG = R2.Scene:new(CAMERA)
			SCENE_BG = R2.Scene:new(CAMERA)

			local palMapBgW = makeLinearPalMap(1, 8)
			local choosePalMapBgIndexW = fnChoosePalMapIndexUnitNegToPos(#palMapBgW)
			local palMapFgW = makeLinearPalMap(1, 8)
			local choosePalMapFgIndexW = fnChoosePalMapIndexUnitNegToPos(#palMapFgW)
			local palMapWindow = makeLinearPalMap(10, 15)
			local choosePalMapIndexWindow = fnChoosePalMapIndexUnitNegToPos(#palMapWindow)
	
			ENGINE_BG:setMaterial("quadFlatLit", quadShadedLit(LIGHT, palMapBgW, choosePalMapBgIndexW))
			ENGINE_BG:setMaterial("triFlatLit", triShadedLit(LIGHT, palMapBgW, choosePalMapBgIndexW))
			ENGINE_BG:setMaterial("quadTunnelLight", quadTunnelLight(palMapWindow, choosePalMapIndexWindow))
			ENGINE_BG:setMaterial("triTunnelLight", triTunnelLight(palMapWindow, choosePalMapIndexWindow))

			ENGINE_FG:setMaterial("quadFlatLit", quadShadedLit(LIGHT, palMapFgW, choosePalMapFgIndexW))
			ENGINE_FG:setMaterial("triFlatLit", triShadedLit(LIGHT, palMapFgW, choosePalMapFgIndexW))
			ENGINE_FG:setMaterial("triFlatLit-glass",  triShadedLit(LIGHT, palMapWindow, choosePalMapIndexWindow))
			ENGINE_FG:setMaterial("quadTunnelLight", quadTunnelLight(palMapWindow, choosePalMapIndexWindow))

			ENGINE_FG:setMaterial("quadTexChest", R2.Material.quadTextured(2,-1, 64,0,64+64,64))
			ENGINE_FG:setMaterial("quadTexFace", R2.Material.quadTextured(2,-1, 0,0,64,64))
			ENGINE_FG:setMaterial("quadTexScr1", R2.Material.quadTextured(2,-1, scrTexX,scrTexY,scrTexX+scrTexW,scrTexY+scrTexH))

			local model = makeModelIrisDoor(N_IRIS_BLADES)
			local modelID = ENGINE_BG:addModel(model)
			ACTORS["iris-door"] = SCENE_BG:newActor(modelID, R2.V3:new(0,0,-40), "miRoot")
			ACTORS["iris-door"]:setVisible(false)
			ACTORS["iris-door"].data = {colofs = 0}

			local model = makeModelShip()
			local modelID = ENGINE_FG:addModel(model)			
			ACTORS["ship"] = SCENE_FG:newActor(modelID, R2.V3:new(0,0,0), "miRoot")
			ACTORS["ship"].data = {colofs = 0}

			local model = makeModelFigure("regular", .3, .3, .3)
			local modelFigureID = ENGINE_FG:addModel(model)
			
			ACTORS["figure1"] = SCENE_FG:newActor(modelFigureID, R2.V3:new(0,0,0), "miPelvis")
			constrainSkeleton(ACTORS["figure1"])
			ACTORS["figure2"] = SCENE_FG:newActor(modelFigureID, R2.V3:new(0,0,0), "miPelvis")
			constrainSkeleton(ACTORS["figure2"])
		end
	
		local progress = pMetrics.progress

		local fadeBG = 0
		if progress > .9 then
			fadeBG = 1-((progress - .9)/.1)
		elseif progress > .7 then
			fadeBG = 1
		elseif progress > .5 then
			fadeBG = (progress - .5)/.2
		end

		vbank(0)
		setRGB(0,0,0,0)
		setRGBSpread(1,8, 40*fadeBG,40*fadeBG,90*fadeBG, 255*fadeBG,255*fadeBG,255*fadeBG)
		setRGBSpread(10,15, 10*fadeBG,10*fadeBG,120*fadeBG, 255*fadeBG,60*fadeBG,255*fadeBG)

		local shipZ = 0
		if progress > .8 then
			shipZ = ((progress - .8)/.2)^2 * -60
		end

		local shipRotY = mPi - mPi * mMin(progress * 2, 1)
		local actor = ACTORS["ship"]
		actor:setRotation(R2.Quaternion:newFromEuler(0,shipRotY,0))
		actor:setPosition(R2.V3:new(0,0,shipZ))
		local rotWing = mPi*.2 - mMin(mMax((progress - .3) * 3, 0), 1) * mPi*.2
		local rotWingTip = mPi*.4 - mMin(mMax((progress - .4) * 5, 0), 1) * mPi*.4
		local rotHood = mPi*.6 - mMin(mMax((progress - .1) * 4, 0), 1.08) * mPi*.6
		actor.skeleton:setJoint({"miRoot","jWindscreen"}, R2.Quaternion:newFromEuler(rotHood,0,0))
		actor.skeleton:setJoint({"miRoot","jWingLeft"}, R2.Quaternion:newFromEuler(-rotWing,0,0))
		actor.skeleton:setJoint({"miWingLeft","jWingTip"}, R2.Quaternion:newFromEuler(0,0,-rotWingTip))
		actor.skeleton:setJoint({"miRoot","jWingRight"}, R2.Quaternion:newFromEuler(-rotWing,0,0))
		actor.skeleton:setJoint({"miWingRight","jWingTip"}, R2.Quaternion:newFromEuler(0,0,rotWingTip))

		for i,id in pairs({"figure1","figure2"}) do
			local actor = ACTORS[id]
			local skeleton = actor.skeleton
			local d = -12+5*(i-1)
			local x = mSin(shipRotY) * d
			local y = (i-1) * 1 - .5
			local z = mCos(shipRotY) * d + shipZ

			actor:setPosition(R2.V3:new(x,y,z))
			actor:setRotation(R2.Quaternion:newFromEuler(1,shipRotY,0))
			skeleton:setJointWithRange({"miPelvis","jWaist"},-.2,0,0)
			skeleton:setJointWithRange({"miPelvis","jLeftHip"}, .6,-.7,0)
			skeleton:setJointWithRange({"miLeftLegHigh","jKnee"},-.3,0,0)
			skeleton:setJointWithRange({"miLeftLegLow","jAnkle"},.4,0,0)
			skeleton:setJointWithRange({"miPelvis","jRightHip"}, .6,-.7,0)
			skeleton:setJointWithRange({"miRightLegHigh","jKnee"},-.3,0,0)
			skeleton:setJointWithRange({"miRightLegLow","jAnkle"},.4,0,0)
			skeleton:setJointWithRange({"miTorso","jLeftShoulder"}, 0,0,0)
			skeleton:setJointWithRange({"miLeftArmHigh","jElbow"}, 0,-.5,0)
			skeleton:setJointWithRange({"miTorso","jRightShoulder"}, -.2,.3,1)
			skeleton:setJointWithRange({"miRightArmHigh","jElbow"}, 0,0,0)
		end

		camSplineValue = camSpline:getValue(pMetrics.progress)
		CAMERA:setPosition(camSplineValue.pos)
		CAMERA:setFOV(camSplineValue.fov)

		LIGHT:set(mSin(progress*7),mSin(progress * 10),-1)
		LIGHT:normalize()

		if progress > .35 then
			local door = ACTORS["iris-door"]
			door:setVisible(true)
			if progress > .5 then
				local angle = mMin((progress - .7),.2) * mPi
				for i=1,N_IRIS_BLADES do
					local jName = "j-"..i
					door.skeleton:setJoint({"miRoot",jName}, R2.Quaternion:newFromEuler(0,0,angle))
				end
			end
		end

		vbank(0)
		cls(0)
		SCENE_BG:render(ENGINE_BG)

		vbank(1)
		cls(0)
		SCENE_FG:render(ENGINE_FG)
	end,
	cleanup=function()
		vbank(0)
		cls()
	end,
})

end

rift_partslaunch=function()
local R2 = {}	-- hack!

rift_demopart()(R)
rift_syssys()(R)
rift_3d2engine()(R2)
rift_3d2scene()(R2)
rift_3d2model()(R2)
rift_3d2mesh()(R2)
rift_3d2actor()(R2)
rift_3d2material()(R2)
rift_3d2skeleton()(R2)
rift_3d2v3()(R2)
rift_3d2m44()(R2)
rift_3d2quaternion()(R2)
rift_syscatmullrom()(R)
local makeModelShip = rift_code3d2modelship()(R2)
local makeModelTunnel = rift_code3d2modelshiptunnelrgb()(R2)
local makeModelScreen = rift_code3d2modelscreen()(R2)
local setRGB, setPalette, _, _, hslToRgb = rift_codepalette()(R)
local quadShadedLit, triShadedLit, makeLinearPalMap, fnChoosePalMapIndexUnitNegToPos, fnChoosePalMapIndexUnitFacing, quadTunnelLight, triTunnelLight = rift_codematerialflatlitpalettemap()(R2)

local FN_PIXPLANES_MELT = makeFnAcrossPixplanes("pp1[srcA]=pp1[srcA]*.2")
local FN_PIXPLANES_TO_SCREEN = makeFnAcrossPixplanes("poke4(destA, math.min(pp1[srcA],15))")
local PIXPLANES
local DOTS_FG = rift_codedotsship()
local PIXPLANE_FG

local mPi, mSin, mCos, mMin, mMax, mRand = math.pi,  math.sin, math.cos, math.min, math.max, math.random
local mTau = mPi * 2

local scr3Dw, scr3Dh = 24, 2
local scrTexX, scrTexY, scrTexW, scrTexH = 0,0,scr3Dw*10,scr3Dh*10
-- #TODO: hack!
scrTexX = scrTexW
scrTexW = -scrTexW

local ENGINE, CAMERA, LIGHT, SCENE_BG, SCENE_FG
local ACTORS = {}
local ACTOR_TUNNELS = {}
local ACTORS_SCREENS = {}

local tunnelSpline = R.CatmullRomSpline:new()
tunnelSpline:setValueInterpolater(
	function(t, v0, v1, v2, v3)
		return R2.V3:new(
			R.catmullRom(t, v0.x, v1.x, v2.x, v3.x),
			R.catmullRom(t, v0.y, v1.y, v2.y, v3.y),
			R.catmullRom(t, v0.z, v1.z, v2.z, v3.z)
		)
	end
)
tunnelSpline:addValue(0, R2.V3:new(0,0,0))
tunnelSpline:addValue(.4, R2.V3:new(-30,-80,0))
tunnelSpline:addValue(.6, R2.V3:new(30,-30,0))
tunnelSpline:addValue(1, R2.V3:new(0,100,0))

local materialRedFlashingLight = rift_codematerialredflashinglight()(R2)

local matLine = R2.Material.line(15)
local fnDraw = matLine.fnDraw
matLine.fnDraw = function(d)
    ppDrawLine(PIXPLANE_FG, d.v1.x,d.v1.y, d.v2.x,d.v2.y, DOTS_FG)
end

return R.DemoPart:new({
	tic=function(pMetrics)
		if pMetrics.isFirstRun then
            PIXPLANES = initPixplanes()
            PIXPLANE_FG = PIXPLANES[1]

			vbank(0)
			for i=0,14 do
				local r,g,b = hslToRgb(i/15, .5, .5)
				setRGB(i+1, r,g,b)
			end

			ENGINE = R2.Engine:new()
			LIGHT = R2.V3:new(0,-1,1)
			LIGHT:normalize()
			CAMERA = R2.Camera:new(R2.V3:new(0,0,20), R2.Quaternion:newFromEuler(0,0,0))
			SCENE_BG = R2.Scene:new(CAMERA)
			SCENE_FG = R2.Scene:new(CAMERA)

			local palMapW = makeLinearPalMap(1, 5)
			local palMapWindow = makeLinearPalMap(11, 15)
			local choosePalMapIndexW = fnChoosePalMapIndexUnitNegToPos(#palMapW)
			local choosePalMapIndexWindow = fnChoosePalMapIndexUnitNegToPos(#palMapWindow)
	
			ENGINE:setMaterial("quadFlatLit", quadShadedLit(LIGHT, palMapW, choosePalMapIndexW))
			ENGINE:setMaterial("triFlatLit", triShadedLit(LIGHT, palMapW, choosePalMapIndexW))
			ENGINE:setMaterial("triFlatLit-glass",  triShadedLit(LIGHT, palMapWindow, choosePalMapIndexWindow))
			ENGINE:setMaterial("quadFlatLit-exhaust", R2.Material.quadFlatLit(6,10,LIGHT))

			local palMapBgR = makeLinearPalMap(7, 8)
			local choosePalMapBgIndexR = fnChoosePalMapIndexUnitNegToPos(#palMapBgR)
			ENGINE:setMaterial("warningLight", quadShadedLit(LIGHT, palMapBgR, choosePalMapBgIndexR))

			ENGINE:setMaterial("quadTexScr1", R2.Material.quadTextured(2,-1, scrTexX,scrTexY,scrTexX+scrTexW,scrTexY+scrTexH))
            ENGINE:setMaterial("line", matLine)

			local palMap = makeLinearPalMap(1, 15)
			local choosePalMapIndex = fnChoosePalMapIndexUnitNegToPos(#palMap)
			ENGINE:setMaterial("triTunnelLight", triTunnelLight(palMap, choosePalMapIndex))
			ENGINE:setMaterial("quadTunnelLight", quadTunnelLight(palMap, choosePalMapIndex))
			
			local model = makeModelShip()
			local modelID = ENGINE:addModel(model)
			
			ACTORS["ship"] = SCENE_FG:newActor(modelID, R2.V3:new(0,0,0), "miRoot")
			ACTORS["ship"].data={colofs=0}

			local modelTunnel = makeModelTunnel()
			local modelTunnelID = ENGINE:addModel(modelTunnel)
			local modelScreen = makeModelScreen(scr3Dw,scr3Dh)
			local modelScreenID = ENGINE:addModel(modelScreen)

			for i=1,20 do
				ACTOR_TUNNELS[#ACTOR_TUNNELS+1] = SCENE_BG:newActor(modelTunnelID, R2.V3:new(0,0,0), "miRoot")
			end
		end

		local progress = pMetrics.progress

		local camZ = (progress/2*2000)
		local camPos = tunnelSpline:getValue(camZ/1000) + R2.V3:new(0,0,100)
		CAMERA:setPosition(camPos)

		local shipActor = ACTORS["ship"]
		if progress > .5 then
			isOutline = true
		end

		local shipPos = tunnelSpline:getValue((camZ + 40)/1000) + R2.V3:new(0,0,50)
		shipActor:setPosition(shipPos)
		local yaw = mSin(progress * mPi * 1.5) * .06
		local roll = mSin(progress * mPi * 5) * .5
		local pitch = mSin(progress * mPi * 3.5) * .08
		shipActor:setRotation(R2.Quaternion:newFromEuler(pitch,yaw,roll))

		local tunnelZ = camZ + 100
		local nextTunnelZ = (tunnelZ//10)*10
		for i,actor in ipairs(ACTOR_TUNNELS) do
			local splinePos = tunnelSpline:getValue(nextTunnelZ/1000)
			actor:setPosition(R2.V3:new(splinePos.x, splinePos.y, -nextTunnelZ + tunnelZ))
			actor.data = {colofs = nextTunnelZ//10}
			local rotate = progress * 3
			if nextTunnelZ % 20 < 10 then
				rotate = -rotate
			end
			actor:setRotation(R2.Quaternion:newFromEuler(0,0,rotate))
			nextTunnelZ = nextTunnelZ + 10
		end

		--[[
		local splinePos = tunnelSpline:getValue(tunnelProgress)
		local shipX, shipY = splinePos.x, splinePos.y
		local shipZ = tunnelProgress * scaleZ

		actor:setPosition(R2.V3:new(shipX + mRand()*.2, shipY + mRand()*.5, shipZ))

		local splinePosCam = tunnelSpline:getValue(progress - .03)
		CAMERA:setPosition(R2.V3:new(splinePosCam.x, splinePosCam.y + 10, shipZ + 60))
		CAMERA.pos = R2.V3:new(0, -10 - progress * 3, shipZ + 20)
		CAMERA:setRotation(R2.Quaternion:newFromEuler(0,0,-mSin(progress * mPi * 4)*mSin(progress*mPi)))
		--]]
		--[[
		local shipZ = -(.1+progress)^3 * 1000
		local splinePos = tunnelSpline:getValue(-shipZ / 1000)
		local shipX, shipY = splinePos.x, splinePos.y


		-- Our spline runs over a unit, so use that to space the segments
		-- make the tunnel 100 units long
		local shipViewFrom = shipZ
		local shipViewTo = shipViewFrom - 100
		for i=1,#ACTOR_TUNNELS do
			local tunnelZ = 10 * (-shipViewFrom//10) + i * 10
			local splinePos = tunnelSpline:getValue(tunnelZ / 1000)
			local actor = ACTOR_TUNNELS[i]
			actor:setPosition(R2.V3:new(0,0,-tunnelZ) + splinePos)
			local tunnelRotate = mSin(tunnelZ*.006) + progress * 10
			if i%2==1 then
				tunnelRotate = -tunnelRotate
			end
			actor:setRotation(R2.Quaternion:newFromEuler(0,0,tunnelRotate))

--			if i%4==0 then
--				ACTORS_SCREENS[i//4]:setPosition(R2.V3:new(0,25,-tunnelZ) + splinePos)
--			end
		end
		
--]]

		vbank(0)
		cls()
		SCENE_BG:render(ENGINE)

		vbank(1)
		if isOutline then
			setRGBSpread(1,15, 30,30,30, 255,255,255)
			ACTORS["ship"]:setSkins({"outline"})
	        ppDefaultPixplanesMelt(FN_PIXPLANES_MELT, {PIXPLANE_FG}, pMetrics.tics)
			SCENE_FG:render(ENGINE)

			FN_PIXPLANES_TO_SCREEN({PIXPLANE_FG})
		else
			setRGBSpread(1,5, 0,0,0, 255,255,255)
			setRGBSpread(6,10, 120,10,10, 255,60,60)
			setRGBSpread(11,15, 10,10,120, 60,60,255)
			cls()
			ACTORS["ship"]:setSkins({"default"})
			SCENE_FG:render(ENGINE)
		end

		local text = ""
		if progress > .3  and pMetrics.tics % 10 < 5 then
			if progress < .35 then
				text = "ENGAGE"
			elseif progress < .4 then
				text = "QUADRASCAN"
			elseif progress < .45 then
				text = "SHIELD"
			elseif progress < .5 then
				text = "NOW!"
			end
			local w=print(text, 0, 150, 0, false, 2)
			print(text, scrTexX+(scrTexW-w*1.4)/2, 20, 10, false, 3)
		end
	end,

	cleanup=function()
		vbank(0)
		cls()
	end,
})

end

rift_uimouse=function()
return function(R)
    R=R or {}

    R.Mouse={}

	function R.Mouse:new()
		local o={
			last=nil,
            now=nil,
		}
		setmetatable(o,self)
		self.__index=self
		return o
	end

    function R.Mouse:update()
        self.last=self.now
        local x,y,lb,mb,rb,sx,sy=mouse()
        self.now={
            x=x,y=y,
            lb=lb,mb=mb,rb=rb,
            sx=sx,sy=sy,
        }
        local lastLb,lastMb,lastRb=false,false,false
        if self.last~=nil then
            lastLb,lastMb,lastRb=self.last.lb,self.last.mb,self.last.rb
        end

        self.now.lbp=self.now.lb and not lastLb
        self.now.mbp=self.now.mb and not lastMb
        self.now.rbp=self.now.rb and not lastRb
        return self.now
    end
end

end

rift_codegameship=function()
local mSin, mCos = math.sin, math.cos
local mMax=math.max

GameShip={}
function GameShip:new(x,y,r)
    local o={
        x=x,
        y=y,
        r=r,
        dx=0,
        dy=0,
        reloaded=0,
    }
    setmetatable(o,self)
    self.__index=self
    return o
end

function GameShip:rotate(r)
    self.r = self.r + r
end

function GameShip:accelerate(a)
    self.dx = self.dx + mSin(self.r) * a
    self.dy = self.dy - mCos(self.r) * a
end

function GameShip:move()
    local slowFactor = 0.97
    self.x = (self.x + self.dx)%240
    self.y = (self.y + self.dy)%128
    self.dx = self.dx * slowFactor
    self.dy = self.dy * slowFactor

    self.reloaded = mMax(self.reloaded - 1, 0)
end

-- {hasFired, moveAngle, moveSpeed}
function GameShip:tryShooting()
    if self.reloaded > 0 then
        return false
    end
    
    self.reloaded = 10
    return true
end

function GameShip:getMovement()
    local a = math.atan2(self.dy, self.dx)

    return a, math.sqrt(self.dx^2 + self.dy^2)
end

end

rift_code3d2modelship=function()
return function(R)

	local noseZ = 15
	local windscreenZ = -4
	local windscreenH = 2
	local shipH = 1
	local shipW = 3
	local wingAttachZ = -10

	local wingTipZ = -5

	--				7  8	11   12
	-- 1_____ 2             13   14
	-- / 3__4 \     9  10   
	--5/      \6

	local outlines = {
		{1,2},{2,6},{6,4},{4,3},{3,5},{5,1},
		{6,10},{10,14},{5,9},{9,13},{13,14}
	}

	local function makeMeshTemplateShipBody()
		local x1,x2,x3 = .6,.7,1
		local yh,ym,yb = 1*shipH,.3,-1
		local zb,zm,zf = 1,0,-.95
		local verts= {
			{-x2,yh,zb},
			{x2,yh,zb},
			{-x1,ym,zb},
			{x1,ym,zb},
			{-x3,yb,zb},
			{x3,yb,zb},
			{-x3,yh,zm},
			{x3,yh,zm},
			{-x3,yb,zm},
			{x3,yb,zm},
			{0,ym,zf},
			{0,ym,zf},
			{-x1,yb,zf},
			{x1,yb,zf},
		}
		local tris={{1,3,5},{1,2,3},{2,4,3},{2,6,4},{3,9,5},{4,10,6}}
		local quads={
			{1,7,9,5},{2,8,10,6},{3,9,10,4},{7,8,10,9},{1,7,8,2},
			{8,12,14,10},{7,11,13,9},{11,12,14,13}
		}
		local tx,ty,tz=0,0,-.3
		local dx,dy,dz=shipW,2,15

		local mesh=R.Mesh:new()
		for _,v in ipairs(verts) do
			mesh:addVertex(nil, R.V3:new((v[1]+tx)*dx, (v[2]+ty)*dy, (v[3]+tz)*dz))
		end

		for i,t in ipairs(tris) do
			local material = "triFlatLit"
			
			mesh:addRenderable(material, {v1=t[1],v2=t[2],v3=t[3]})
		end

		for i,t in ipairs(quads) do
			local material = "quadFlatLit"
			
			mesh:addRenderable(material, {v1=t[1],v2=t[2],v3=t[3],v4=t[4]})
		end
		
		for i,t in ipairs(outlines) do
			mesh:addRenderable("line", {v1=t[1],v2=t[2]}, "outline")
		end

		mesh:addVertex("jWindscreen", R.V3:new(0,shipH+2,windscreenZ))
		mesh:addVertex("jWingLeft", R.V3:new(-shipW,0,wingAttachZ))
		mesh:addVertex("jWingRight", R.V3:new(shipW,0,wingAttachZ))
		
		return mesh
	end


	local function makeMeshTemplateShipWindscreen()
		local dx,dy,dz=shipW,windscreenH,noseZ
		local tx,ty,tz=0,1,0
		local verts = {
			{-1,-1,0},
			{1,-1,0},
			{0,-1,-1},

			{-1,0,0},
			{1,0,0},
			{0,-.3,-.5},
		}

		local tris={{4,5,6}, {2,5,3}, {5,6,3}, {1,4,3}, {4,6,3}, {1,2,4}, {5,4,2}}

		local mesh=R.Mesh:new()
		for _,v in ipairs(verts) do
			mesh:addVertex(nil, R.V3:new((tx+v[1])*dx, (ty+v[2]*dy), (tz+v[3]*dz)))
		end
	
		for i,t in ipairs(tris) do
			mesh:addRenderable("triFlatLit-glass", {v1=t[1],v2=t[2],v3=t[3]})

			-- This is too many lines (maybe)...
			mesh:addRenderable("line", {v1=t[1],v2=t[2]}, "outline")
			mesh:addRenderable("line", {v1=t[2],v2=t[3]}, "outline")
			mesh:addRenderable("line", {v1=t[3],v2=t[1]}, "outline")
		end
		
		return mesh
	end

	local function makeMeshTemplateShipWing(xMult)
		local dx,dy,dz=15,1,10
		local tx,ty,tz=0,0,0
		local verts = {
			{0,0,-.5},
			{0,1,1.2},
			{0,-1,1.2},
			{-.3,-.3,1},
		}

		local tris={{1,2,3}, {1,4,3}, {2,4,1}, {2,3,4}}

		local mesh=R.Mesh:new()
		for _,v in ipairs(verts) do
			mesh:addVertex(nil, R.V3:new((tx + v[1]) *dx * xMult, (ty+v[2])*dy, (tz+v[3])*dz))
		end
	
		for i,t in ipairs(tris) do
			if xMult > 0 then
				mesh:addRenderable("triFlatLit", {v1=t[1],v2=t[2],v3=t[3]})
			else
				mesh:addRenderable("triFlatLit", {v3=t[1],v2=t[2],v1=t[3]})
			end

			-- This is too many lines (maybe)...
			mesh:addRenderable("line", {v1=t[1],v2=t[2]}, "outline")
			mesh:addRenderable("line", {v1=t[2],v2=t[3]}, "outline")
			mesh:addRenderable("line", {v1=t[3],v2=t[1]}, "outline")
		end

		mesh:addVertex("jWingTip", R.V3:new(0,-dy*.1,dz*.9))
		return mesh
	end
	
	local function makeMeshTemplateShipWingTip(xMult)
		local dx,dy,dz=15,1,15
		local tx,ty,tz=0,0,0
		local verts = {
			{0,1,.2},
			{0,-1,.2},
			{-.3,-.3,0},
			{-1,-1,1},
			{-.5,-.6,.8},
		}

		local tris={{1,2,3}, {1,4,3}, {1,4,2}, {2,3,4}}

		local mesh=R.Mesh:new()
		for _,v in ipairs(verts) do
			mesh:addVertex(nil, R.V3:new((tx+v[1]*dx) * xMult, (ty+v[2])*dy, (tz+v[3])*dz))
		end
	
		for i,t in ipairs(tris) do
			if xMult > 0 then
				mesh:addRenderable("triFlatLit", {v1=t[1],v2=t[2],v3=t[3]})
			else
				mesh:addRenderable("triFlatLit", {v3=t[1],v2=t[2],v1=t[3]})
			end

			-- This is too many lines (maybe)...
			mesh:addRenderable("line", {v1=t[1],v2=t[2]}, "outline")
			mesh:addRenderable("line", {v1=t[2],v2=t[3]}, "outline")
			mesh:addRenderable("line", {v1=t[3],v2=t[1]}, "outline")
		end

		for _,verts in ipairs({{-.95,-.95,1}, {-.3,-.3,0}, {0,-1,.2}, {-.45,-1,.6}}) do
			local v = R.V3:new(xMult*verts[1]*dx, verts[2]*dy, verts[3]*dz)
			local v1 = mesh:addVertex(nil, v + R.V3:new(-.5,0,0))
			local v2 = mesh:addVertex(nil, v + R.V3:new(0,-.5,0))
			local v3 = mesh:addVertex(nil, v + R.V3:new(.5,0,0))
			local v4 = mesh:addVertex(nil, v + R.V3:new(0,.5,0))
			mesh:addRenderable("quadTunnelLight", {v1=v1,v2=v2,v3=v3,v4=v4,l=0})
		end

		return mesh
	end

	local function makeModel()
		local model=R.Model:new()

		model:addMeshTemplate("mtBody", makeMeshTemplateShipBody())
        model:addMeshInstance("miRoot",nil,"mtBody",R.Quaternion:newFromEuler(0,0,0))
		model:addMeshTemplate("mtWindscreen", makeMeshTemplateShipWindscreen())
        model:addMeshInstance("miWindscreen",{"miRoot","jWindscreen"},"mtWindscreen",R.Quaternion:newFromEuler(0,0,0))
		model:addMeshTemplate("mtWingLeft", makeMeshTemplateShipWing(1))
        model:addMeshInstance("miWingLeft",{"miRoot","jWingLeft"},"mtWingLeft",R.Quaternion:newFromEuler(0,0,0))
		model:addMeshTemplate("mtWingTipLeft", makeMeshTemplateShipWingTip(1))
        model:addMeshInstance("miWingTipLeft",{"miWingLeft","jWingTip"},"mtWingTipLeft",R.Quaternion:newFromEuler(0,0,0))
		model:addMeshTemplate("mtWingRight", makeMeshTemplateShipWing(-1))
        model:addMeshInstance("miWingRight",{"miRoot","jWingRight"},"mtWingRight",R.Quaternion:newFromEuler(0,0,0))
		model:addMeshTemplate("mtWingTipRight", makeMeshTemplateShipWingTip(-1))
        model:addMeshInstance("miWingTipRight",{"miWingRight","jWingTip"},"mtWingTipRight",R.Quaternion:newFromEuler(0,0,0))

		return model
	end

	return makeModel
end

end

rift_codematerialflat=function()
return function(R2)

	function triFlat(c)
		return R2.Material:new():setFnTransform(function(d, psView, psWorld)
			return {
				v1=psView[d.v1], v2=psView[d.v2], v3=psView[d.v3]
			}
		end):setFnDistance(function(d)
			return (d.v1.z+d.v2.z+d.v3.z)/3
		end):setFnDraw(function(d)
			local a = 0x3ff0*2
			poke4(a,c)
			ttri(
				d.v1.x,d.v1.y,d.v2.x,d.v2.y,d.v3.x,d.v3.y,
				0,0,1,0,1,1,
				1,
				-1,
				d.v1.z,d.v2.z,d.v3.z
			)
			poke4(a,0)
		end)
	end

	function quadFlat(c)
		return R2.Material:new():setFnTransform(function(d, psView, psWorld)
			return {
				v1=psView[d.v1], v2=psView[d.v2], v3=psView[d.v3], v4=psView[d.v4],
			}
		end):setFnDistance(function(d)
			return (d.v1.z+d.v2.z+d.v3.z+d.v4.z)/3
		end):setFnDraw(function(d)
			local a = 0x3ff0*2
			poke4(a,c)
			ttri(
				d.v1.x,d.v1.y,d.v2.x,d.v2.y,d.v3.x,d.v3.y,
				0,0,1,0,1,1,
				1,
				-1,
				d.v1.z,d.v2.z,d.v3.z
			)
			ttri(
				d.v3.x,d.v3.y,d.v4.x,d.v4.y,d.v1.x,d.v1.y,
				0,0,1,0,1,1,
				1,
				-1,
				d.v3.z,d.v4.z,d.v1.z
			)
			poke4(a,0)
		end)
	end

    return triFlat, quadFlat
end

end

rift_3d2engine=function()
-- Gonna try for right-handed coordinate system
-- Y:up=positive, X:right=positive, Z:out-of-screen=positive
return function(R)
	R=R or {}

	local Engine={}

	function Engine:new()	
		local o={
			models={},
			materials={},
			viewportXC=120,
			viewportYC=68,
			viewportScale=80,
		}
		setmetatable(o,self)
		self.__index=self
		return o
	end

	function Engine:addModel(model)
		local id = #self.models + 1
		self.models[id]=model
		return id
	end

	function Engine:getModel(modelID)
		return self.models[modelID]
	end

	function Engine:setMaterial(materialID, material)
		self.materials[materialID]=material
	end

	function Engine:material(materialID)
		return self.materials[materialID]		
	end

	-- transforms a 3D projected vector into a 2D screen position, retaining z so that we can use it for depth sorting
	function Engine:transformForViewport(v)
		local zD = 1/v.z
		return R.V3:new(
			self.viewportXC - self.viewportScale * (v.x * zD),
			self.viewportYC - self.viewportScale * (v.y * zD),
			v.z
		)
	end

	R.Engine = Engine
end

end

rift_codegfxhatching=function()
local pal = "07F800cKBMBMCNFHCNFBLODDFPONHHFPPNMFHHKAPAHIDHLEGFCBHJHJCGDPGLDNFJMBEGKGPDHPOHPEPEPEPEJALCMGFMGGIDDMDHF0"
local gfx = "0800020E7O7E7O7E7O7E7O7E7O7E7O7E7O7E7O7E7O7E7O7E7O7E7O7E7O7E7O7E7O7E7O7E7O7E7O7E7O7E7O7E7O7E7O7E7O7E7O7E7O7E7O7E7O7E7O7E7O7E7O7E7O7E7O7E7O7E7O7E7O7E7O7E7O7E7O7E7O7E7O7E7O7E7O7E7O7E7O7E7O7E7O7E7O7E7O7E7O7E7O7E7O7E7O7E7O7E7O7E7O7E7O7E7O7E7O7E7O7E7O7E7O7E7O7E7O7E7O7E7O7E7O7E7O7E7O7E7O7E7O7E7O7E7O7E7O7E7O7E7O7E7O7E7O7E7O7E7O7E7O7E7O7E7O7E7O7E7O7E7O7E7O7E7O7E7O7E7O7E7O7E7O7E7O7E7O7E7O7E7O7E7O7E7O7E7O7E7O7E7O7E7O7E7O7E7O7E7O7E7O7E7O7E7O7E7O7E7O7E7O7E7O7E7O7E7O7E7O7E7O7E7O7E7O7E7O7E7O7E7O7E7O7E7O7E7O7E7O7E7O7E7O7E7O7E7O7"

return function(R)
    return gfx, pal
end

end

rift_codepixplane=function()
-- `pixplane` is an experiment in using 2D accumulator 'surfaces' to aggregate pixel operations before copying them to the screen

-- First stab: I'll make some things that I think will be reasonably optimal, but not too convoluted.
-- (this 'documentation' needs work!)
-- Possibly contraversial:
--  - The planes are 256x128, not 240x136. This might make the maths faster (or be an unnecessary optimisation)
-- Usage
-- - initPixplanes: create a number of zeroed planes (not worrying about memory excess for now)
-- - makeFnAcrossPixplanes(yourFn, step): returns a function that runs through each pixel of a plane (with step, use 1 for all),
--      calling your function (this does 240x128)
--  Making the function is likely to be expensive, so do this in advance
-- to set a pixel:
--  pixplane[y<<8|x]=value

-- We'll set up a bunch of permanent pixplanes and not worry about what space this takes (memory is cheap?)
-- An empty table indicates a new pixplane
local PIXPLANES={{}, {}, {}, {}, {}, {}, {}, {}}

-- This function will be expensive...
function initPixplanes()
    for id = 1,#PIXPLANES do
        fillPixplane(PIXPLANES[id], 0)
    end
    return PIXPLANES
end

-- We create a 256 wide * 128 high buffer, which is not quite screen size, but probably means the maths can be faster
-- (Check whether a y-table of rows is faster bitplane[x][y]... I'm expecting it won't be)
-- 0-239 / 0-135 is drawn
function fillPixplane(pixplane, value)
    for o=0,0x7fff do
        pixplane[o]=value
    end
end

-- Call the function that is returned from this like: fn(PIXPLANES)
-- Your function should us 'srcA' as the accessor (i.e. pixplane[a])
-- e.g. melt pixels
-- perPixelCode: " pp1[srcA] = pp1[srcA]>>1" ..
-- e.g. to screen
-- perPixelCode: " poke4(destA, pp1[srcA] + pp2[srcA])" ..
function makeFnAcrossPixplanes(perPixelCode)
    -- Creates alias string ("local pp1,pp2...=pps[1],pps[2]...")
    local pixPlaneAlias1 = ""
    local pixPlaneAlias2 = "="
    for i=1,#PIXPLANES do
        local separator = (i>1) and "," or ""
        pixPlaneAlias1 = pixPlaneAlias1 .. separator .. "pp" .. i
        pixPlaneAlias2 = pixPlaneAlias2 .. separator .. "pps[" .. i .. "]"
    end

    local code =
        " return function(pps,stepX,stepY,offsetX,offsetY)" ..
            " local " .. pixPlaneAlias1 .. pixPlaneAlias2 ..
            " stepX,stepY = (stepX and stepX or 1), (stepY and stepY or 1)" ..
            " offsetX,offsetY = (offsetX and offsetX or 0), (offsetY and offsetY or 0)" ..
            " for y=offsetY,127,stepY do" ..
                " local destA=240*y+offsetX" ..
                " for x=offsetX,239,stepX do" ..
                    " local srcA=y*256+x" ..
                    " " .. perPixelCode ..
                    " destA=destA+stepX" ..
                " end" ..
            " end" ..
        " end"
    local fn, err = load(code)
    if err then
        trace(err)
        return nil
    end
    local ok, fnPCall = pcall(fn)
    if not ok then
        return nil
    end
    return fnPCall
end


-- This can be optimised by turning a string into a pcall function?
--[[ scrapyard code...
function copyAggregatorToScreen(fnBpMath,srcX0,srcY0,destX0,destY0,w,h,fnClip)    
    -- Reclip w and h to be our max extents...
    local srcX1, srcY1 = srcX0+w-1, srcY0+h-1
    local destY=destY0
    for srcY=srcY0,srcY1 do
        local srcAddr0=srcY*256
        local srcAddr1=srcAddr0+w
        local destAddr=(destY*240)
        for srcAddr=srcAddr0,srcAddr1 do
            poke4(destAddr, BITPLANES[1][srcAddr])
            destAddr=destAddr+1
        end
        destY=destY+1
    end
end
--]]

-- The above is confusing as hell... I'll do something simpler and maybe meet in the middle?
-- persistance = 0 - 1, where 0 is no persistance (emptying) and 1 is full persistance
-- Does a max cap...
function copyPixplaneToScreenAndDecay(pixplane, persistance)
    local mMin = math.min
    for y=0,127 do
        local srcPix=y*256
        local destPix=y*240
        for x=0,240 do
            local v = pixplane[srcPix]
            poke4(destPix, mMin(v,15))
            pixplane[srcPix]=v*persistance
            destPix = destPix + 1
            srcPix = srcPix + 1
        end
    end
end

end

rift_codegfxcabinet=function()
local pal = "07F800cKBMBMCNFHCNFBLODDFPONHHFPPNMFHHKAPAHIDHLEGFCBHJHJCGDPGLDNFJMBEGKGPDHPOHPEPEPEPEJALCMGFMGGIDDMDHF0"
local gfx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

return function(R)
    return gfx, pal
end

end

rift_code3d2modelirisdoor=function()
return function(R)

	local mPi, mSin, mCos = math.pi, math.sin, math.cos
	local mTau = mPi * 2

	local function makeMeshTemplateFrame(sc, nBlades)
		local mesh=R.Mesh:new()
		local sc = 40

		local sci=sc *.7
		local sco=sc * 1.5
		local zFrame = .1
		local vix0y0 = mesh:addVertex(nil, R.V3:new(-sci,-sci,zFrame))
		local vix1y0 = mesh:addVertex(nil, R.V3:new(sci,-sci,zFrame))
		local vix1y1 = mesh:addVertex(nil, R.V3:new(sci,sci,zFrame))
		local vix0y1 = mesh:addVertex(nil, R.V3:new(-sci,sci,zFrame))
		local vox0y0 = mesh:addVertex(nil, R.V3:new(-sco,-sco,zFrame))
		local vox1y0 = mesh:addVertex(nil, R.V3:new(sco,-sco,zFrame))
		local vox1y1 = mesh:addVertex(nil, R.V3:new(sco,sco,zFrame))
		local vox0y1 = mesh:addVertex(nil, R.V3:new(-sco,sco,zFrame))
		mesh:addRenderable("quadFlatLit", {v1=vox0y0,v2=vox1y0,v3=vix1y0,v4=vix0y0})
		mesh:addRenderable("quadFlatLit", {v4=vox0y1,v3=vox1y1,v2=vix1y1,v1=vix0y1})
		mesh:addRenderable("quadFlatLit", {v1=vox0y0,v2=vix0y0,v3=vix0y1,v4=vox0y1})
		mesh:addRenderable("quadFlatLit", {v4=vox1y0,v3=vix1y0,v2=vix1y1,v1=vox1y1})

		for i=1,nBlades do
			local angle = i/nBlades * mTau
			local x = -mSin(angle) * sc
			local y = mCos(angle) * sc
			local jName = "j-"..i
			mesh:addVertex(jName, R.V3:new(x,y,0))
		end		
		return mesh
	end

	local function makeMeshTemplateSegment(sc)
		local sc = 40
		local verts={{0,0,0},{0,-2,.1},{.6,0,0}}
		local dx,dy,dz = sc,sc,0

		local mesh=R.Mesh:new()
		for _,v in ipairs(verts) do
			mesh:addVertex(nil, R.V3:new(v[1]*dx, v[2]*dy, v[3]*dz))
		end
	
		local triVerts={{-.05,0}, {.05,0}, {0,-.1}}
		for i=-.8,0,.2 do
			local v = R.V3:new(0,i*dy,1)
			local v1 = mesh:addVertex(nil, v + R.V3:new(triVerts[1][1]*dx, triVerts[1][2]*dy, 0))
			local v2 = mesh:addVertex(nil, v + R.V3:new(triVerts[2][1]*dx, triVerts[2][2]*dy, 0))
			local v3 = mesh:addVertex(nil, v + R.V3:new(triVerts[3][1]*dx, triVerts[3][2]*dy, 0))
			mesh:addRenderable("triTunnelLight", {v1=v1,v2=v2,v3=v3,l=i*10//1})
		end

		mesh:addRenderable("triFlatLit", {v1=1,v2=2,v3=3})
		return mesh
	end

	local function makeModel(nBlades)
		local sc = 40
		local model = R.Model:new()

		model:addMeshTemplate("mtFrame", makeMeshTemplateFrame(sc, nBlades))
		model:addMeshInstance("miRoot",nil,"mtFrame",R.Quaternion:newFromEuler(0,0,0))

		model:addMeshTemplate("mtSegment", makeMeshTemplateSegment(sc))
		for i=1,nBlades do
			local angle = i/nBlades * mTau
			local miName = "miSegment-"..i
			local jName = "j-"..i
			model:addMeshInstance(miName, {"miRoot", jName}, "mtSegment", R.Quaternion:newFromEuler(0,0,angle))
		end

		return model
	end

	return makeModel
end

end

rift_partscontrolroomstart=function()
local R2 = {}	-- hack!

rift_demopart()(R)
rift_syssys()(R)
rift_syscatmullrom()(R)
rift_3d2engine()(R2)
rift_3d2scene()(R2)
rift_3d2model()(R2)
rift_3d2mesh()(R2)
rift_3d2actor()(R2)
rift_3d2material()(R2)
rift_3d2skeleton()(R2)
rift_3d2v3()(R2)
rift_3d2m44()(R2)
rift_3d2quaternion()(R2)
rift_codevector()
local setRGB, setPalette, setPaletteScaled = rift_codepalette()(R)
local drawSun = rift_codedrawsun()
local controlRoomLayout, setTeleportIn = rift_codecontrolroomlayout()(R2)
local vecDefShip, vecDefAsteroid, vecDefUFO, vecDefBullet = rift_codevectorasteroidsgame()()

local mPi = math.pi
local mSin, mCos, mTau = math.sin, math.cos, mPi * 2
local ALERT_TIME = .7

local camSpline = R.CatmullRomSpline:new()
camSpline:setValueInterpolater(
	function(t, v0, v1, v2, v3)
		return {
			pos = R2.V3:new(
				R.catmullRom(t, v0.pos.x, v1.pos.x, v2.pos.x, v3.pos.x),
				R.catmullRom(t, v0.pos.y, v1.pos.y, v2.pos.y, v3.pos.y),
				R.catmullRom(t, v0.pos.z, v1.pos.z, v2.pos.z, v3.pos.z)
			),
			fov = R.catmullRom(t, v0.fov, v1.fov, v2.fov, v3.fov),
			rot = R2.Quaternion:newFromEuler(
				R.catmullRom(t, v0.rot.x, v1.rot.x, v2.rot.x, v3.rot.x),
				R.catmullRom(t, v0.rot.y, v1.rot.y, v2.rot.y, v3.rot.y),
				R.catmullRom(t, v0.rot.z, v1.rot.z, v2.rot.z, v3.rot.z)
			),
		}
	end
)
camSpline:addValue(0, {pos=R2.V3:new(0,0,4), fov=60, rot={x=0,y=0,z=0}})
camSpline:addValue(.2, {pos=R2.V3:new(0,0,2), fov=60, rot={x=-.2,y=-.1,z=0}})
camSpline:addValue(.5, {pos=R2.V3:new(-1.5,0,2), fov=60, rot={x=0,y=.5,z=0}})
camSpline:addValue(1, {pos=R2.V3:new(0,0,2), fov=60, rot={x=0,y=0,z=0}})

local function poseSit(actor, ts, iOfs)
	local skeleton = actor.skeleton
	skeleton:setJointWithRange({"miPelvis","jLeftHip"}, 1,-.4,0)
	skeleton:setJointWithRange({"miPelvis","jRightHip"}, 1,-.4,0)
	skeleton:setJointWithRange({"miRightLegHigh","jKnee"}, 0,0,1)
	skeleton:setJointWithRange({"miLeftLegHigh","jKnee"}, 0,0,1)
	neckX, neckY, neckZ = mSin(ts*10 + iOfs)*.4-.7, mSin(ts*5 + iOfs), mSin(ts*7 + iOfs)
	if ts < ALERT_TIME then
	elseif ts < ALERT_TIME + .05 then
		local shift = ((ts - ALERT_TIME) / .05)
		local nShift = (1 - shift)
		neckX, neckY, neckZ = neckX * nShift + -1 * shift, neckY * nShift + 0 * shift, neckZ * nShift + 0 * shift
	else
		neckX, neckY, neckZ = -1, 0, 0
	end
	skeleton:setJointWithRange({"miTorso","jNeck"}, neckX, neckY, neckZ)
	skeleton:setJointWithRange({"miTorso","jRightShoulder"}, 1,0,-.4)
	skeleton:setJointWithRange({"miTorso","jLeftShoulder"}, 1,0,-.4)
	skeleton:setJointWithRange({"miLeftArmHigh","jElbow"}, 0,.5,0)
	skeleton:setJointWithRange({"miRightArmHigh","jElbow"}, 0,.5,0)
end

local CONTROL_ROOM

return R.DemoPart:new({
	tic=function(pMetrics)
		local scrTexX = 0
		local scrTexY = 0
		local scrTexW = 120
		local scrTexH = 120 * 2/3
		if pMetrics.isFirstRun then
			vbank(0)
			setPalette("wrb")

			CONTROL_ROOM = controlRoomLayout(scrTexX,scrTexY,scrTexW,scrTexH)

			local e1palMapW = makeLinearPalMap(1, 5)
			local e1choosePalMapIndexW = fnChoosePalMapIndexUnitNegToPos(#e1palMapW)
		end

		local progress = pMetrics.progress
		setTeleportIn(progress * 2)

		local rgbScale = 1
		if progress < .2 then
			rgbScale = progress / .2
			vbank(0)
			setPaletteScaled("wrb", 1, 0,0,0)

			vbank(1)
			setPaletteScaled("wryb", rgbScale, 0,0,0)
		elseif progress > .9 then
			rgbScale = (1 - progress) / .1

			vbank(0)
			setPaletteScaled("wrb", rgbScale, 0,0,0)

			vbank(1)
			setPaletteScaled("wryb", rgbScale, 80,0,0)
		else
			vbank(0)
			setPalette("wrb")

			vbank(1)
			setPalette()
		end

		for i,actor in ipairs(CONTROL_ROOM.actors) do
			poseSit(actor, progress, i*.2)
		end

		vbank(0)
		rect(scrTexX, scrTexY, scrTexW, scrTexH, 3)
		rect(scrTexX + 3, scrTexY + 3, scrTexW - 6, scrTexH - 6, 1)
		if progress < ALERT_TIME  then
			drawSun(scrTexX+scrTexW/2, scrTexY+scrTexH/2, 30, 5,1)
			--[[
			for i=0,5 do
				circ(
					scrTexX+scrTexW/2 + scrTexW/4*mSin(progress*10+i),
					scrTexY+scrTexH/2 + scrTexH/4*mSin(progress*16+i),
					15-i,10+i
				)
			end
			--]]
		else
			local flash = progress * 25 % 1
			if flash < .5 then
				local x =scrTexX+scrTexW*.05
				local y = scrTexY+scrTexH*.3
				print("ALERT",x+3,y+3,7,true,4)
				print("ALERT",x,y,9,true,4)
			else
				local vecDrawDef = vectorTransformPoints(vecDefAsteroid, 64,40, 35,35, progress * 8)
				vectorDraw(vecDrawDef, 10)
			end
		end

        CONTROL_ROOM.light:set(0, mSin(progress * 8), 1)
        CONTROL_ROOM.light:normalize()

		vbank(1)
		cls()
		camSplineValue = camSpline:getValue(progress)
		CONTROL_ROOM.camera:setPosition(camSplineValue.pos)
		CONTROL_ROOM.camera:setFOV(camSplineValue.fov)
		CONTROL_ROOM.camera:setRotation(camSplineValue.rot)
		CONTROL_ROOM.sceneFG:render(CONTROL_ROOM.engineFG)

		vbank(0)
		cls()
		drawSun(160,50,35,5,0)
		CONTROL_ROOM.sceneBG:render(CONTROL_ROOM.engineBG)
	end,
	cleanup=function()
		vbank(0)
		cls()
	end,
})

end

rift_demopart=function()
--- A section of a demo (usually viewed for a few seconds upwards, or one/multiple frames of music)
-- @module demo.demopart
-- @author jtruk
return function(R)
    R=R or {}

	R.DemoPart={}

	--- Create a new DemoPart object.
    -- @tparam {tab}
    -- preboot (func) ()
    -- cleanup (func) ()
    -- tic (func) (partMetrics)
    -- partMetrics={
    --  isFirstRun
    --  isLastRun,
    --  progress
    --  musFrameProgress
    -- }
    -- bdr (func) (y, partMetrics)
	function R.DemoPart:new(o)
		setmetatable(o,self)
		self.__index=self
		return o
	end

    --[[
    function R.DemoPart:setPos(pos)
        self.pos=pos
    end
    --]]
end

end

rift_3d2actor=function()
return function(R)
	R=R or {}

    -- actor -> link to model, (root matrix + joints state) + (anim state - overrides joint state?)

	local Actor={}

	-- rootNodeID can change for different animations?
	function Actor:new(modelID, pos, rootNodeID)
		local o={
			modelID = modelID,
			isVisible = true,
			skeleton = R.Skeleton:new(),
			skinIDs = {"default"},
			pos = pos,
			rot = R.Quaternion:identity(),
			rootNodeID = rootNodeID,
			data = nil,
		}
		setmetatable(o,self)
		self.__index=self
		return o
	end

	function Actor:setSkins(skinIDs)
		self.skinIDs = skinIDs
	end

	function Actor:setVisible(isVisible)
		self.isVisible = isVisible
	end

	function Actor:setPosition(vec3)
		self.pos = vec3
	end

	function Actor:getPosition()
		-- Improve
		return R2.V3:new(self.pos.x, self.pos.y, self.pos.z)
	end

	function Actor:rotate(q)
		self.rot = R.Quaternion.multiply(self.rot, q)
	end

	function Actor:setRotation(q)
		self.rot = q
	end

	function Actor:addToRenderlist(engine, scene, renderlist)
        if not self.isVisible then
			return
		end

		local model=engine:getModel(self.modelID)

		-- #TODO (pass this through instead?)
		-- local modelMat = R.Matrix:newFromQuaternion(self.rot)
		-- modelMat:translate(self.pos)

		-- TODO: draw all root nodes, rather than specifying rootNodeID? Or continue to allow specific setting?
        model:addToRenderlist(engine, scene, self.pos, self.rot, self.skeleton, self.rootNodeID, self.skinIDs, self.data, renderlist)
	end

	R.Actor = Actor
end

end

rift_codegfxhatching8x8=function()
local pal = "07F800cKBMBMCNFHCNFBLODDFPONHHFPPNMFHHKAPAHIDHLEGFCBHJHJCGDPGLDNFJMBEGKGPDHPOHPEPEPEPEJALCMGFMGGIDDMDHF0"
local gfx = "0800008I3A3H3A3I3A3H3A3I3A3H3A3I3A3H3A3"

return function(R)
    return gfx, pal
end

end

rift_codegameufo=function()
local mSin, mCos = math.sin, math.cos

GameUFO={}
function GameUFO:new(x,y,dx,dy,size)
	local o={
		x=x,
		y=y,
		dx=dx,
		dy=dy,
		size=size,	-- 0 or 1
	}
	setmetatable(o,self)
	self.__index=self
	return o
end

-- returns nil or event:
-- {e='exit'}
function GameUFO:move()
	local newX = self.x + self.dx
	local newY = self.y + self.dy
	if self.dx > 0 and newX >= 240 then
		return {e='exit'}
	elseif self.dx < 0 and newX < 0 then
		return {e='exit'}
	end

	local event = nil
	if self.dy > 0 and newY >= 100 then
		newY = 100
		self.dy = -math.random(1,6)/4
		event = {e='dir', y=newY, dy=self.dy}
	elseif self.dy < 0 and newY < 20 then
		newY = 20
		self.dy = math.random(1,6)/4
		event = {e='dir', y=newY, dy=self.dy}
	end

	self.x = newX%240
	self.y = newY%128
	return event
end

end

rift_codegfxfacelogg=function()
local pal = "07F800cKBMBMCNFHCNFBLODDFPONHHFPPNMFHHKAPAHIDHLEGFCBHJHJCGDPGLDNFJMBEGKGPDHPOHPEPEPEPEJALCMGFMGGIDDMDHF0"
local gfx = "0800020AF3GKKAF4KKAF4JKAF3JKKAF3JKKEF3JKKEF3K2EF3K7GK6GK6GK6GK6GK6GK6GJK2FJKGJK2JK6JK6JK6JK6JK6JK5GJK5GJKGFK3JF3AKKF4AKGF4AKKGF3AKKGF3AKKGF3BK2F3BK2F3BEF3KKGEFFJK2GEFFJK2FEFFK3FEFFK3GFKFK3F3KGMPPF2BPPIKJF4JJF4JF6JF4GFJF6JF6JFFP3DJFFKCICPHFFGGF4GFFGF6GF6GFJF4GF6GF6GMP3FFNPICIKJKKF3BJK2GFFBFK2GFFBFK3FFBJK3FFBFK3FKFPPDJKF2KCPPEF5PDFGFHFNDF3PDPEF2BP2F2BAFPDFFAMPFMHFAAPPFNHAEEAPFNDA3MFAAIAPFFAPPDAMEFAP2DMHFMP2DMHP4DNHFP3HNIKP2DHNJKPDMPENKKFFPACAAFFBDAMPPAFNDMP2APNDMP2DFNHMP3KCHNP3KGHNMP2KKHBPDMPFJFMPF6MHFNEF2BPMPAEF2P3DAFFMPFPPAAFNDFPABBANHFDA3MHFFNLAAK2FNHK3GFBPK3GFFPK3F2PJKKF3MLK3FFNHK3FFBPK4FAAINKKFFBFFPKKFFAFFDJKBAAENHJKF2KNEJK3GPGK4NDK4CPIJK3HCAAFK2PFFEFFKGMFFAFFKGNHBAAEKGBHKF2KKJPJK5MHK4GCPIK4AAOHFJK3NHFJK3PEFFK3PF3KKGPFFK3ODFFK3NHFFK3PEF4MJK2F2BPJKKF3MPJKF3JMPPF2K2GFJK6JK6JK5GKGMDFK3BPHFK2BPPEFK2PPEJFK2F2KFK2FFJKFK2FFJKFJKKFAF3K4FMDJK3FNPEK3FBPPEK2FGBPPK2FKF2K2FKGFFKKGFKGFFKKF3AFK2GDF2KKGPEF2KGPDF3PPDGF4JK2F2K6GK6GJK5GJK5GJK5FJKJK2GBJKJKKGFAJK3GBMJK3FBAJK3FBEJK3FBEBEFMPEFFMEGBPDEADJGFFAAMEJKFFBMPEJKKFBAPFJKKGFAAFJKKGFBAFJK2FBAFFBPDFBEABMPEJBDDAAFFJGMPDEFFKGBPAEFKKGBAAFJKKGFAEFJKKGFAEFK2GFJK5GFK5GEJK2GKGAFJKKGKGDEJK3GAEFK3GBEFK3GBEFK3GJKKFGFBEJKKFGF3KKFKF3KKGKKGFFK4GF3K3BF2K3F2KGK2F2K2GF3K3FFBF4BEMP2AP2AAPPHBAMEJGFEBFBFJK2F3K4GF2JK2F3K3FFBEF4EP2AP2DDAENPPAAEFEBFJGBF2K2GFFJK4FBEFJFKKGF2JFKKGF2KFKKFFJKKJKKFFJK4FEK3F3K3F3K2JKFFKFJGKKGFKF2JGFBKF2JF2KGF5KKF5KKGF4KKGF3JKKGF3KFK4GFJK3GFBFK3F2JK2F3K3GF2K4F2K5GFK7FJK4FEFJK3GF2K3F4K2GF2JK3F2K4FJK13FJKKJGFKEFJGF2KF2GF2KF5JKF5KKF4JKKGF3JK2F3JKK0"

return function(R)
    return gfx, pal
end

end

rift_codedrawsun=function()
local function drawSun(x,y,r, cfg, cbg)
	local w = r*2
	circ(x,y,r,cfg)
	for _,c in ipairs(
		{{y=-.3,h=.1}, {y=-.1,h=.15}, {y=.1,h=.2}, {y=.35,h=.25}, {y=.65,h=.3}}
	) do
		rect(x-w,y+c.y*r, w*2,c.h*r, cbg)
	end
end

return drawSun

end

rift_codecontrolroomlayout=function()
return function(R2)    
    local makeTileModelsAndActors, _, getTilesPosFloor = rift_codeactorstiles()(R2)
    local quadShadedLit, triShadedLit, makeLinearPalMap, fnChoosePalMapIndexUnitNegToPos, fnChoosePalMapIndexUnitFacing = rift_codematerialflatlitpalettemap()(R2)
    local makeModelFigure, constrainSkeleton = rift_code3d2modelfigure()(R2)
    local makeModelChair = rift_code3d2modelchair()(R2)
    local makeModelScreen = rift_code3d2modelscreen()(R2)
    
    local TELEPORT_IN = 0

    local matFlickerLine = R2.Material.line(15)
    local fnDraw = matFlickerLine.fnDraw
    matFlickerLine.fnDraw = function(d)
        local s = 30 + TELEPORT_IN * 200
        local doDraw = d.v1.y > s and d.v1.y < s + 15
        if doDraw then
            fnDraw(d)
        end
    end
    
    local function matFlickerQuadFlatLit(light)
        local mat = R2.Material.quadFlatLit(1,6,light)
        local fnDraw = mat.fnDraw
        mat.fnDraw = function(d)
            local doDraw = d.v1.y < 40 + TELEPORT_IN * 200
            if doDraw then
                fnDraw(d)
            end
        end
        return mat
    end
    
    local mPi = math.pi
    local mSin, mCos, mTau = math.sin, math.cos, mPi * 2
    
    local function setTeleportIn(v)
        TELEPORT_IN = v
    end

    local function contolRoomLayout(scrTexX,scrTexY,scrTexW,scrTexH)
        local data = {}

        data.light = R2.V3:new(0,-1,1)
        data.light:normalize()
        data.camera = R2.Camera:new(R2.V3:new(0,0,0), R2.Quaternion:newFromEuler(0,0,0))

        data.engineFG = R2.Engine:new()
        data.sceneFG = R2.Scene:new(data.camera)    
        data.engineBG = R2.Engine:new()
        data.sceneBG = R2.Scene:new(data.camera)    

        local palMapFgW = makeLinearPalMap(1, 5)
        local choosePalMapIndexFgW = fnChoosePalMapIndexUnitNegToPos(#palMapFgW)

        data.engineFG:setMaterial("quadTexChest", R2.Material.quadTextured(2,-1, 64,0,64,64))
        data.engineFG:setMaterial("quadTexFace", R2.Material.quadTextured(2,-1, 0,0,64,64))
        data.engineFG:setMaterial("quadFlatLit", quadShadedLit(data.light, palMapFgW, choosePalMapIndexFgW))
        data.engineFG:setMaterial("quadTexScr1", R2.Material.quadTextured(2,-1, scrTexX,scrTexY,scrTexW,scrTexH))
        data.engineFG:setMaterial("line", matFlickerLine)

        local palMapW = makeLinearPalMap(1, 5)
        local palMapR = makeLinearPalMap(6, 10)
        local palMapB = makeLinearPalMap(11, 15)
        local choosePalMapIndexW = fnChoosePalMapIndexUnitNegToPos(#palMapW)
        local choosePalMapIndexR = fnChoosePalMapIndexUnitNegToPos(#palMapR)
        local choosePalMapIndexB = fnChoosePalMapIndexUnitNegToPos(#palMapB)

        data.engineBG:setMaterial("quadFlatLit-w", quadShadedLit(data.light, palMapW, choosePalMapIndexW))
        data.engineBG:setMaterial("quadFlatLit-r", quadShadedLit(data.light, palMapR, choosePalMapIndexR))
        data.engineBG:setMaterial("quadFlatLit-b", quadShadedLit(data.light, palMapB, choosePalMapIndexB))

        data.actorTiles = makeTileModelsAndActors(data.engineBG, data.sceneBG)
        actorTilesPosFloor = getTilesPosFloor()
        for i, actor in ipairs(data.actorTiles) do
            actor:setRotation(R2.Quaternion:newFromEuler(mPi/2,0,0))
            actor:setPosition(actorTilesPosFloor[i])
        end

        local model = makeModelFigure("outline", .1, .1, .1)
        local modelFigureID = data.engineFG:addModel(model)
        model = makeModelChair(.1)
        local modelChairID = data.engineFG:addModel(model)
        
        data.actors = {}
        data.actorChairs = {}
        for i=-2,2 do
            local pos = R2.V3:new(i, -.5, -.5)
            local rotY = (i%2 == 0 and -.4 or .4)
            local actor = data.sceneFG:newActor(modelFigureID, pos, "miPelvis")
            constrainSkeleton(actor)
            actor:setRotation(R2.Quaternion:newFromEuler(.2, rotY, 0))
            data.actors[#data.actors+1] = actor

            pos = pos + R2.V3:new(0, 0, 0)
            local actor = data.sceneFG:newActor(modelChairID, pos, "miSeat")
            actor:setRotation(R2.Quaternion:newFromEuler(.2, rotY, 0))
            data.actorChairs[#data.actorChairs+1] = actor    
        end

        data.actorScreens = {}
        local model = makeModelScreen(.4,.3)
        local modelID = data.engineFG:addModel(model)
        for i=-3,3 do
            local pos = R2.V3:new(i*.8, 1, -1)
            local actor = data.sceneFG:newActor(modelID, pos, "miRoot")
            local rotY = mPi + (i%2 == 0 and -.5 or .5)
            actor:setRotation(R2.Quaternion:newFromEuler(-.4, rotY, 0))
            data.actorScreens[#data.actorScreens+1] = actor            
        end

        return data
    end

    return contolRoomLayout, setTeleportIn
end

end

rift_codematerialredflashinglight=function()
return function(R2)
    local mMin = math.min
    local mSin = math.sin

    local material = R2.Material:new():setFnTransform(function(d,ps)
        return {v=ps[d.v],ofs=d.ofs}
    end):setFnDistance(function(d)
        return d.v.z
    end):setFnDraw(function(d)
        local r = mMin(100 / d.v.z^.5, 5)
        local c = mSin(d.ofs + time()*0.01 + d.v.z*.001) * 3
        if c>0 then
            circ(d.v.x,d.v.y,r,7+c)
        else
            circ(d.v.x,d.v.y,r,0)
            circb(d.v.x,d.v.y,r,1)
        end
    end)
    
    return material
end

end

rift_code3d2modeltile=function()
return function(R)

    -- type = {"l" (large), "hw" (halfwidth), "h" (half), "th" (thin), "hh" (halfheight, 2/5 width)}
	local function makeMeshTemplateTile(type)
		local verts={{-1,1,-1},{1,1,-1},{1,-1,-1},{-1,-1,-1},{-1,1,1},{1,1,1},{1,-1,1},{-1,-1,1}}
		local quads={{1,2,3,4},{6,5,8,7},{5,1,4,8},{2,6,7,3},{5,6,2,1},{4,3,7,8}}

		local dx,dy,dz=.5,.5,.05
	
		if type == "hw" then
            dx, dy = dx*.45, dy
        elseif type == "h" then
            dx, dy = dx*.45, dy*.45
        elseif type == "th" then
            dx, dy = dx*.18, dy*.45
        elseif type == "hh" then
            dx, dy = dx*.4, dy*.45 -- NB + gap width?
		end

		local mesh=R.Mesh:new()
		for _,v in ipairs(verts) do
			mesh:addVertex(nil, R.V3:new(v[1]*dx, v[2]*dy, v[3]*dz))
		end
	
		for i,t in ipairs(quads) do
			mesh:addRenderable("quadFlatLit-r", {v1=t[1],v2=t[2],v3=t[3],v4=t[4]}, "r")
			mesh:addRenderable("quadFlatLit-w", {v1=t[1],v2=t[2],v3=t[3],v4=t[4]}, "w")
			mesh:addRenderable("quadFlatLit-b", {v1=t[1],v2=t[2],v3=t[3],v4=t[4]}, "b")
		end
		
		return mesh
	end

	local function makeModel(type)
		local model = R.Model:new()

		model:addMeshTemplate("mtTile", makeMeshTemplateTile(type))
        model:addMeshInstance("miRoot",nil,"mtTile",R.Quaternion:newFromEuler(0,0,0))

		return model
	end

	return makeModel
end

end

rift_partsflightwormhole=function()
R=R or {}

rift_demopart()(R)
rift_3d2engine()(R)
rift_3d2scene()(R)
rift_3d2model()(R)
rift_3d2mesh()(R)
rift_3d2actor()(R)
rift_3d2material()(R)
rift_3d2skeleton()(R)
rift_3d2v3()(R)
rift_3d2m44()(R)
rift_3d2quaternion()(R)
rift_codepixplane()
rift_code3d()
rift_codedrawingpixplane()
local makeModelShip = rift_code3d2modelship()(R)

local mSin,mCos,mPi,mAbs=math.sin,math.cos,math.pi,math.abs
local mTau = mPi * 2

local PIXPLANES
--local FN_PIXPLANES_MELT = ppGetDefaultFnMelt()
--local FN_PIXPLANES_TO_SCREEN = makeFnAcrossPixplanes("poke4(destA, math.min(pp1[srcA],15))")
local FN_PIXPLANES_MELT = makeFnAcrossPixplanes("pp1[srcA]=pp1[srcA]*.2")
local FN_PIXPLANES_TO_SCREEN = makeFnAcrossPixplanes("poke4(destA, math.min(pp1[srcA],15))")

local DOTS = ppGetDefaultDots()
local DOTS_FG = rift_codedotsship()
local PIXPLANE_FG

local ENGINE, CAMERA, SCENE
local ACTOR_SHIP

local matLine = R.Material.line(15)
local fnDraw = matLine.fnDraw
matLine.fnDraw = function(d)
    ppDrawLine(PIXPLANE_FG, d.v1.x,d.v1.y, d.v2.x,d.v2.y, DOTS_FG)
end

return R.DemoPart:new({
    preboot=function()
    end,
    bdr=function(y,pMetrics)
        local t = pMetrics.progress
        vbank(0)
        local r0=30
        local r1=150+(1-t) * 100 * (1-mAbs(y-68)/68)
        local g0=0
        local g1=100-t*70
        local b0=60-t*60
        local b1=80+t*70
        setRGBSpread(1,15, r0,g0,b0, r1*(1-t)^1.1,g1*(1-t),(b1*t^2))
    end,
	tic=function(pMetrics)
        if pMetrics.isFirstRun then
            PIXPLANES=initPixplanes()
            PIXPLANE_FG=PIXPLANES[2]
    
            ENGINE = R.Engine:new()
            CAMERA = R.Camera:new(R2.V3:new(0,0,20), R.Quaternion:newFromEuler(0,0,0))
            SCENE = R.Scene:new(CAMERA)
    
            ENGINE:setMaterial("line", matLine)
    
            local model = makeModelShip()
            local modelID = ENGINE:addModel(model)
            
            ACTOR_SHIP = SCENE:newActor(modelID, R.V3:new(0,0,0), "miRoot")
            ACTOR_SHIP:setSkins({"outline"})
                
            vbank(0)
            setRGB(0,0,0,0)

            vbank(1)
            setRGBSpread(1,15, 30,30,30, 255,255,255)
        end

        local pixplaneWormhole=PIXPLANES[1]

        ppDefaultPixplanesMelt(FN_PIXPLANES_MELT, {pixplaneWormhole}, pMetrics.tics)
        ppDefaultPixplanesMelt(FN_PIXPLANES_MELT, {PIXPLANE_FG}, pMetrics.tics)

        local t=pMetrics.progress * 85 -- crashes if this is 100?!
        local transX=mSin(t*.08)*.8+mSin(t*.05)*.8
        local transY=mCos(t*.1)*.6
        local transZ=t*1.4
        local progress = pMetrics.progress

        for z=1,20 do
            local points={}
          
            for theta=0,6 do
                local fadeT = .5
                local a = mTau * theta/6 + progress * z
                if  progress < fadeT then
                    points[#points+1] = {x=mSin(a)*10, y=mCos(a)*10, z=z}
                else
                    local d = (10 - (progress-fadeT)*2 * 10)
                    points[#points+1] = {x=mSin(a)*d, y=mCos(a)*d, z=z}
                end
            end

            local transZ=(z-transZ)%20
            transformPoints(points, transX*3,transY*2,transZ, 0,0,0)
            projectPoints(points)
          
            local lastP=points[1]
           
            for i=2,#points do
                local p=points[i]          
                ppDrawLine(pixplaneWormhole, lastP.x,lastP.y,p.x,p.y, DOTS)
                lastP=p
            end
        end

        local transZ=1.5
        if progress>.7 then
            transX=100
            transZ=1
        elseif progress>.5 then
            transZ=1.5+(1+(progress-.5))^30
        elseif progress<.2 then
            transZ=1.5+((progress-.2)*10)
        end

        ACTOR_SHIP:setPosition(R.V3:new(-transX*10-15,transY*20+3,-20*transZ-10))
        ACTOR_SHIP:setRotation(R.Quaternion:newFromEuler(0,0,mCos(t*.1)*1))
        SCENE:render(ENGINE)

        vbank(0)        
        FN_PIXPLANES_TO_SCREEN({pixplaneWormhole})

        vbank(1)        
        FN_PIXPLANES_TO_SCREEN({PIXPLANE_FG})
	end,
})

end

rift_codetextticker=function()
return function()
	local TextTicker={}

    -- #TODO: align (if needed)
    local function printLine(x0, y0, wholeLine, len, yLine, align, showCursor, colour)
        local w = print(wholeLine,0,140,1,false,1)
        local x = x0
        local y = y0 + (yLine-1)*10
        if align == "center" then
            x = x + 120-w/2
        end

        local text = wholeLine:sub(1, len)
        local printW = print(text,x,y,colour)
        if showCursor then
            rect(x + printW, y, 4, 6, colour)
        end
    end
    

	function TextTicker:new(texts)	
		local o={
			texts=texts,
            cursorX=1,
            cursorY=1,
		}
		setmetatable(o,self)
		self.__index=self
		return o
	end

	function TextTicker:tick()
        self.cursorX = self.cursorX+1

        if self.cursorY <= #self.texts then
            if self.cursorX > #self.texts[self.cursorY] then
                self.cursorX = 1
                self.cursorY = self.cursorY + 1
            end
        end
    end

	function TextTicker:render(x,y, align, colour)
        for i=1,self.cursorY-1 do
            local textLine = self.texts[i]
            printLine(x, y, textLine, #textLine, i, align, false, colour)
        end
        if self.cursorY <= #self.texts then
            local textLine = self.texts[self.cursorY]
            local textShow = textLine:sub(1, self.cursorX)
            printLine(x, y, textLine, self.cursorX, self.cursorY, align, true, colour)
        end
    end

	return TextTicker
end

end

rift_soundmusic=function()
return function(R)
    R=R or {}

    R.music={}

    -- These are hard reset here, otherwise, you can call music() and these may or may not update for a frame
    --  because music() doesn't necessarily start immediately
    poke(0x13FFc,0)
    poke(0x13FFd,0)
    poke(0x13FFe,0)

    R.music.getPos=function()
        return {
            track=peek(0x13FFc),
            pattern=peek(0x13FFd),
            row=peek(0x13ffe),
        }
    end

    -- (https://github.com/nesbox/TIC-80/wiki/RAM#music-tracks)
    -- NB Some swizzling required here because there are signed values to decode...
    R.music.getTrackMeta=function(track)
        local aTrack=0x13E64+track*51
        local tempo=peek(aTrack+48)
        tempo = (tempo&128)>0 and (150-(256-tempo)) or (150+tempo)
        local rows=64-peek(aTrack+49)
        local speed=peek(aTrack+50)
        speed = (speed&128)>0 and (6-(256-speed)) or (6+speed)

        local bpm=(6*tempo)/speed
        
        return {
            tempo=tempo,
            rows=rows,
            speed=speed,
            bpm=bpm,
            rowsPerSec=bpm/(60/4)
        }
    end

    --[[
    Looks like it's possible to poke track and pattern, when music is running, but not row?
    R.music.setPos=function(track,pattern,row)
        poke(0x13FFc,track)
        poke(0x13FFd,pattern)
        poke(0x13ffe,row)
    end
    --]]
end

end

rift_code3d2modelshiptunnelrgb=function()
return function(R)

	local mPi, mSin, mCos = math.pi, math.sin, math.cos
	local mTau = mPi * 2
	local sc = 80

	local function makeMeshTemplateTunnel(nLights)
		local mesh=R.Mesh:new()

		local ri = sc * .97
		local ro = sc
		local am = 0
		local ad = mTau/nLights
		for l = 0, nLights-1 do
			local a1 = ad *l
			local a2 = a1 + .08
			local xi1 = mCos(a1) * ri
			local yi1 = mSin(a1) * ri
			local xi2 = mCos(a2) * ri
			local yi2 = mSin(a2) * ri
			local xo1 = mCos(a1) * ro
			local yo1 = mSin(a1) * ro
			local xo2 = mCos(a2) * ro
			local yo2 = mSin(a2) * ro

			local v1id = mesh:addVertex(nil, R.V3:new(xi1, yi1, 0))
			local v2id = mesh:addVertex(nil, R.V3:new(xi2, yi2, 0))
			local v3id = mesh:addVertex(nil, R.V3:new(xo2, yo2, 0))
			local v4id = mesh:addVertex(nil, R.V3:new(xo1, yo1, 0))
			mesh:addRenderable("quadTunnelLight", {v1=v1id,v2=v2id,v3=v3id,v4=v4id,l=l})
		end

		return mesh
	end

	return
		function()	 
			local model=R.Model:new()

			model:addMeshTemplate("mtTunnel", makeMeshTemplateTunnel(20))
			model:addMeshInstance("miRoot",nil,"mtTunnel",R.Quaternion:newFromEuler(0,0,0))

			return model
		end
end

end

rift_syssys=function()
--- Helpers for System level functions
-- @module sys.sys

return function(R)
    R=R or {}

    rift_uimouse()(R)

    local mouse=R.Mouse:new()
    local mouseState=nil
    local tics=0
    local startTime=nil
    local _clip={x=0,y=0,w=240,h=136}

    --- Exit immediately if a specified key is pressed.
    -- Useful for some (not-latest) versions of TIC where CTRL-C is erroneously disabled.
    --
    -- [!] Call at the start of the TIC loop.
    -- @param key The key to break on, defaults to 51 (ESC). [Keycodes here](https://github-wiki-see.page/m/nesbox/TIC-80/wiki/key) e.g. 48 is spacebar.
    -- @usage
        -- function TIC()
        --    R.tryBreak()
        --    ...
        -- end
    R.tryBreak=function(key)
        key=key or 51
        if keyp(key) then
            exit()
        end
    end

    --- Removes the mouse cursor from the screen.
    --
    -- [!] Call at the start of the TIC loop.
    R.hideMouse=function()
        poke(0x3FFB,0)
    end

    --- Returns the number of times the TIC loop has been run.
    --
    -- [!] Wrap your TIC loop in R.ticWrap to use this.
    R.getTics=function()
        return tics
    end

    --- Returns the time in milliseconds since the first TIC loop.
    --
    -- [!] Wrap your TIC loop in R.ticWrap to use this.
    R.getTimeMS=function()
        return time()-startTime
    end

    --- Enables some system level tracking, and mouse state support.
    -- @usage
        -- R.ticWrap(function() 
        --  -- your usual tic loop
        -- end)
    R.ticWrap=function(tic)
        return function()
            if startTime==nil then
                startTime=time()
            end

            mouseState=mouse:update()
            tic()
            tics=tics+1
        end
    end

    --- Returns the mouse state.
    --
    -- [!] Wrap your TIC loop in R.ticWrap to use this.
    function R.getMouse()
        return mouseState
    end

    --- Wrappers for TIC's clip functionality.
    -- This wrapping allows us (and system calls) to check the currently set clip area.
    --
    -- [!] Mixing this with the regular, unwrapped 'clip()' will cause confusion!
    function R.clearClip()
        _clip={x=0,y=0,w=240,h=136}
        clip()
    end

    --- Wrappers for TIC's clip functionality.
    -- This wrapping allows us (and system calls) to check the currently set clip area.
    --
    -- [!] Mixing this with the regular, unwrapped 'clip()' will cause confusion!
    -- @param x top
    -- @param y left
    -- @param w width
    -- @param h height
    function R.setClip(x,y,w,h)
        _clip={x=x,y=y,w=w,h=h}
        clip(x,y,w,h)
    end

    --- Wrappers for TIC's clip functionality.
    -- This wrapping allows us (and system calls) to check the currently set clip area.
    --
    -- [!] Mixing this with the regular, unwrapped 'clip()' will cause confusion!
    -- @return {x,y,w,h}
    function R.getClip()
        return _clip
    end
end

end

rift_3d2material=function()
-- NB triangles and quads are clockwise for front-facing
-- 1\    1__2
-- | \   |  |
-- 3__2  4__3
return function(R)
	R=R or {}

	local Material={}

	-- Interface isn't right for this - ensure all of these are set
	function Material:new()
		local o={
			fnTransform = nil,
            fnDistance = nil,
            fnDraw = nil,
			order = 0,
		}
		setmetatable(o,self)
		self.__index=self
		return o
	end

	-- chainable
	function Material:setFnTransform(fnTransform)
		self.fnTransform=fnTransform
		return self
	end

	-- chainable
	function Material:setFnDistance(fnDistance)
		self.fnDistance=fnDistance
		return self
	end

	-- chainable
	function Material:setFnDraw(fnDraw)
		self.fnDraw=fnDraw
		return self
	end
	
	function Material.triFlatLit(ciLow,ciHigh, lightVec)
		local ciMid,ciRangeHalf=(ciLow+ciHigh)/2,(ciHigh-ciLow)/2

		return Material:new():setFnTransform(function(d, psView, psWorld)
			return {
				v1=psView[d.v1], v2=psView[d.v2], v3=psView[d.v3],
				normal = R2.V3.normal(psWorld[d.v1], psWorld[d.v2], psWorld[d.v3])
			}
		end):setFnDistance(function(d)
			return (d.v1.z+d.v2.z+d.v3.z)/3
		end):setFnDraw(function(d)
			local angle = R.V3.dot(d.normal, lightVec)
			local ci = ciMid + ciRangeHalf*angle
			tri(d.v1.x,d.v1.y,d.v2.x,d.v2.y,d.v3.x,d.v3.y,ci)
		end)
	end

	-- Assumes the quad is a plane!
	-- function generator...
	-- we can change lightVec after it has been sent in here (ensure it is normalised)
	function Material.quadFlatLit(ciLow, ciHigh, lightVec)
		local ciMid,ciRangeHalf=(ciLow+ciHigh)/2,(ciHigh-ciLow)/2

		return Material:new():setFnTransform(function(d,ps)
			return {v1=ps[d.v1],v2=ps[d.v2],v3=ps[d.v3],v4=ps[d.v4]}
		end):setFnDistance(function(d)
			return (d.v1.z+d.v2.z+d.v3.z+d.v4.z)/4
		end):setFnDraw(function(d)
			local normal = R.V3.normal(d.v1,d.v2,d.v3)
			local angle = R.V3.dot(normal, lightVec)
			local ci = ciMid + ciRangeHalf*angle
			tri(d.v1.x,d.v1.y,d.v2.x,d.v2.y,d.v3.x,d.v3.y,ci)
			tri(d.v3.x,d.v3.y,d.v4.x,d.v4.y,d.v1.x,d.v1.y,ci)
		end)
	end

	function Material.triTextured(sSrc,chromakey,sx,sy,sw,sh,pixelmode,palMap,hackBackface)
		pixelmode = pixelmode or 2  -- 8: 1bpp, 4 = 2bpp, 2 = 4bpp
		palMap = palMap or {}
		return Material:new():setFnTransform(function(d,ps,psWorld)
			return {
				v1=ps[d.v1],v2=ps[d.v2],v3=ps[d.v3], t1=d.t1,t2=d.t2,t3=d.t3,
			}
		end):setFnDistance(function(d)
			return (d.v1.z+d.v2.z+d.v3.z)/3
		end):setFnDraw(function(d)
			if hackBackface then
				--[[
				normal = R2.V3.normal(d.v1, d.v2, d.v3)
				if normal.z > 0 then
					return
				end
				--]]
			end

			-- This needs figuring out (which points) and cleaning...
			local st1x, st1y = sx + d.t1.x * sw, sy + d.t1.y * sh
			local st2x, st2y = sx + d.t2.x * sw, sy + d.t2.y * sh
			local st3x, st3y = sx + d.t3.x * sw, sy + d.t3.y * sh

			local oldPixelMode = peek4(0x3FFC*2)
			poke4(0x3FFC*2,pixelmode) -- set pixel mode
			for i=0,#palMap do
				poke4(0x3FF0*2+i,palMap[i])
			end
			ttri(
				d.v1.x,d.v1.y,d.v2.x,d.v2.y,d.v3.x,d.v3.y,
				st1x, st1y, st2x, st2y, st3x, st3y,
				sSrc,
				chromakey,
				d.v1.z,d.v2.z,d.v3.z
			)
			poke4(0x3FFC*2,oldPixelMode) -- reset pixel mode
			for i=0,#palMap do
				poke4(0x3FF0*2+i,i)
			end
		end)
	end

	function Material.quadTextured(sSrc,chromakey,sx,sy,sw,sh,pixelmode,palMap)
		pixelmode = pixelmode or 2  -- 8: 1bpp, 4 = 2bpp, 2 = 4bpp
		palMap = palMap or {}
		return Material:new():setFnTransform(function(d, psView)
			return {v1=psView[d.v1],v2=psView[d.v2],v3=psView[d.v3],v4=psView[d.v4]}
		end):setFnDistance(function(d)
			return (d.v1.z+d.v2.z+d.v3.z+d.v4.z)/4
		end):setFnDraw(function(d)
			-- clockwise...
			local sx0,sx1,sy0,sy1 = sx,sx+sw,sy,sy+sh
			local oldPixelMode = peek4(0x3FFC*2)
			for i=0,#palMap do
				poke4(0x3FF0*2+i,palMap[i])
			end
			poke4(0x3FFC*2,pixelmode) -- set pixel mode
			ttri(
				d.v1.x,d.v1.y,d.v2.x,d.v2.y,d.v3.x,d.v3.y,
				sx0,sy0,sx1,sy0,sx1,sy1,
				sSrc,
				chromakey,
				d.v1.z,d.v2.z,d.v3.z
			)
			ttri(
				d.v3.x,d.v3.y,d.v4.x,d.v4.y,d.v1.x,d.v1.y,
				sx1,sy1,sx0,sy1,sx0,sy0,
				sSrc,
				chromakey,
				d.v3.z,d.v4.z,d.v1.z
			)
			poke4(0x3FFC*2,oldPixelMode) -- reset pixel mode
			for i=0,#palMap do
				poke4(0x3FF0*2+i,i)
			end
		end)
	end

	function Material.line(colour)
		return Material:new():setFnTransform(function(d,ps)
			return {v1=ps[d.v1],v2=ps[d.v2]}
		end):setFnDistance(function(d)
			return (d.v1.z+d.v2.z)/2
		end):setFnDraw(function(d)
			line(d.v1.x,d.v1.y,d.v2.x,d.v2.y,colour)
		end)
	end
	
	R.Material = Material
end

end

rift_3d2v3=function()
return function(R)
    R=R or {}

	local V3 = {}

	local mSqrt = math.sqrt

	function V3:new(x,y,z)
		local o={
			x=x,y=y,z=z
		}
		setmetatable(o,self)
		self.__index=self
		return o
	end

	function V3:__tostring()
		return string.format("V3(%.3f,%.3f,%.3f)",self.x,self.y,self.z)
	end

	function V3:set(x, y, z)
		self.x, self.y, self.z = x, y, z
	end

	function V3:length()
		return mSqrt(self.x*self.x + self.y*self.y + self.z*self.z)
	end

	function V3:scale(d)
		self.x,self.y,self.z = self.x*d,self.y*d,self.z*d
	end

	function V3.scaleV3(v, d)
		return V3:new(v.x*d, v.y*d, v.z*d)
	end

	function V3:normalize()
		local len = self:length()
		if len == 0 then
			len = 0.001
		end
		self:scale(1/len)
	end

	function V3.normalizeV3(v)
		local len = v:length()
		if len == 0 then
			len = 0.001
		end
		return V3.scaleV3(v, 1/len)
	end

	function V3.__add(u, v)
		return V3:new(u.x+v.x, u.y+v.y, u.z+v.z)
	end

	function V3.__sub(u, v)
		return V3:new(u.x-v.x, u.y-v.y, u.z-v.z)
	end
	
	function V3.__mul(v, m)
		return V3:new(v.x*m, v.y*m, v.z*m)
	end

	function V3.__unm(v)
		return V3:new(-v.x, -v.y, -v.z)
	end

	function V3.cross(u,v)
		-- #TODO: not sure if local is optimal here
		local ux,uy,uz = u.x,u.y,u.z
		local vx,vy,vz = v.x,v.y,v.z
		return V3:new(uy*vz - uz*vy, uz*vx - ux*vz, ux*vy - uy*vx)
	end

	function V3.dot(u,v)
		return u.x*v.x + u.y*v.y + u.z*v.z
	end
	
	function V3.normal(v1,v2,v3)
		return R.V3.normalizeV3(V3.cross(v2 - v1, v3 - v2))
	end

	R.V3 = V3
end

end

rift_codevectorasteroidsgame=function()
local mSin, mCos, mPi = math.sin, math.cos, math.pi

local vecDefShip = {
    chains={
        {
            ps={{x=0,y=-1}, {x=.7,y=1}, {x=0,y=.6}, {x=-.7,y=1}},
            loop=true
        }
    },
    bbox=nil,
}

local vecDefAsteroid = {
    chains={
	    {
            ps={
                {x=-.9,y=-.6}, {x=-.6,y=-1}, {x=0,y=-.7}, {x=.5,y=-.9}, {x=1,y=-.7}, {x=.8,y=0}, {x=1,y=.3}, {x=.3,y=1}, {x=-.4,y=.9}, {x=-1,y=.6}
            },
            loop=true
        }
    },
    bbox=nil,
}

local vecDefUFO = {
    chains={
        {
            ps={
                {x=-.4,y=-.2},
                {x=-.2, y=-.5},
                {x=.2, y=-.5},
                {x=.4, y=-.2},
                {x=1, y=.2},
                {x=.4, y=.6},
                {x=-.4, y=.6},
                {x=-1, y=.2},
                {x=-.4, y=-.2},
                {x=.4, y=-.2},
                {x=1, y=.2},
                {x=-1, y=.2},
            },
            loop=false
        }
    },
    bbox=nil,
}

local bulletSize = .6
local r=.85 * bulletSize
local vecDefBullet = {
    chains={
	    {
            ps={
                {x=0,y=-1},
                {x=r,y=-r},
                {x=1,y=0},
                {x=r,y=r},
                {x=0,y=1},
                {x=-r,y=r},
                {x=-1,y=0},
                {x=-r,y=-r},
            },
            loop=true
        }
    },
    bbox=nil,
}

return function()
    return vecDefShip, vecDefAsteroid, vecDefUFO, vecDefBullet
end

end

rift_codeactorstiles=function()
return function(R2)
	local tileDefs = rift_codetiledefs()(1)
	local makeModelTile = rift_code3d2modeltile()(R2)

	local actors = {}
	local actorsPosStart = {}
	local actorsPosFloor = {}

	local function makeTileModelsAndActors(engine, scene)
		local modelForTileType = {}
		for _, tileTypeCode in ipairs({"l", "hw", "h", "th", "hh"}) do
			local model = makeModelTile(tileTypeCode)
			local modelID = engine:addModel(model)
			modelForTileType[tileTypeCode] = modelID
		end
		
		for _, tileDef in ipairs(tileDefs) do
			local modelID = modelForTileType[tileDef.t]
			local pos = R2.V3:new(-tileDef.x,-tileDef.y,0)
			local actor = scene:newActor(modelID, pos, "miRoot")
			actor:setSkins({tileDef.c})

			actors[#actors+1] = actor
			actorsPosStart[#actorsPosStart+1] = pos
			actorsPosFloor[#actorsPosFloor+1] = R2.V3:new(-tileDef.x, -1, -tileDef.y-1)
		end

		return actors
	end

	local function getActorsPosStart()
		return actorsPosStart
	end
	
	local function getActorsPosFloor()
		return actorsPosFloor
	end

	return makeTileModelsAndActors, getActorsPosStart, getActorsPosFloor
end

end

rift_partsmorph=function()
R=R or {}

rift_demopart()(R)
rift_3d2engine()(R)
rift_3d2scene()(R)
rift_3d2model()(R)
rift_3d2mesh()(R)
rift_3d2actor()(R)
rift_3d2material()(R)
rift_3d2skeleton()(R)
rift_3d2v3()(R)
rift_3d2m44()(R)
rift_3d2quaternion()(R)
rift_codepixplane()
rift_codedrawingpixplane()
rift_codevector()
rift_codegameship()
rift_codegameasteroid()

local makeModelShip = rift_code3d2modelship()(R)

--local vecDefFont = rift_codevectorfontasteroids()
local vecDefShip, vecDefAsteroid, vecDefUFO, vecDefBullet = rift_codevectorasteroidsgame()()

local ASTEROIDS = {}
local GAME_SHIP = GameShip:new(120,120,0)
local PIXPLANES
local FN_PIXPLANES_MELT = makeFnAcrossPixplanes("pp1[srcA]=pp1[srcA]*.7")
local FN_PIXPLANES_TO_SCREEN = makeFnAcrossPixplanes("poke4(destA, math.min(pp1[srcA],15))")
local FN_PIXPLANES_FLIGHT_MELT = makeFnAcrossPixplanes("pp1[srcA]=pp1[srcA]*.4")
local FN_PIXPLANES_FLIGHT_TO_SCREEN = makeFnAcrossPixplanes("poke4(destA, math.min(pp1[srcA],15))")

local PIXPLANE_GAME
local PIXPLANE_FLIGHT

local mSin, mCos = math.sin, math.cos
local mPi = math.pi

local DotDraw={}
local d=6
for y=-d,d do
	for x=-d,d do
		local p = 1-((x*x+y*y)^.7)/d
		if p>0 then
			p=(p^4)*1.5
			DotDraw[#DotDraw+1] = {x,y,p}
		end
	end
end

local DOTS_FG = rift_codedotsship()
local matLine = R.Material.line(15)
local fnDraw = matLine.fnDraw
matLine.fnDraw = function(d)
    ppDrawLine(PIXPLANE_FLIGHT, d.v1.x,d.v1.y, d.v2.x,d.v2.y, DOTS_FG)
end

return R.DemoPart:new({
	tic=function(pMetrics)
		if pMetrics.isFirstRun then
			PIXPLANES=initPixplanes()
			vbank(0)
			setRGB(0,30,50,40)
			setRGBSpread(1,15, 25,35,30, 255,255,255)

			vbank(1)
            setRGBSpread(1,15, 30,30,30, 255,255,255)

			for i=1, 10 do	
				local size=1/math.random(1,4)
				ASTEROIDS[i] = GameAsteroid:new(
					math.random() * 240, math.random() * 136, 0,
					math.random() * 2 - 1, math.random() * 2 - 1, math.random() *.1,
					size
				)
			end

            ENGINE = R.Engine:new()
            CAMERA = R.Camera:new(R2.V3:new(0,0,20), R.Quaternion:newFromEuler(0,0,0))
            SCENE = R.Scene:new(CAMERA)

            ENGINE:setMaterial("line", matLine)

            local model = makeModelShip()
			local modelID = ENGINE:addModel(model)
			
			ACTOR_SHIP = SCENE:newActor(modelID, R.V3:new(0,0,0), "miRoot")
            ACTOR_SHIP:setSkins({"outline"})

			PIXPLANE_FLIGHT = PIXPLANES[1]
			PIXPLANE_GAME = PIXPLANES[2]
		end

		local scale = 5 + (1-pMetrics.progress) * 25

		local shipX = mSin(pMetrics.progress * mPi * 2)
		local shipY = 1 - pMetrics.progress
		local shipR =  mSin(pMetrics.progress * mPi * 2) * .6

		GAME_SHIP.x = 120 - shipX * 30
		GAME_SHIP.y = 68 + shipY * 68
		GAME_SHIP.r = shipR

		local vecDrawDef=vectorTransformPoints(vecDefShip, GAME_SHIP.x%240,GAME_SHIP.y, scale, scale, GAME_SHIP.r)
		ppVectorDraw(PIXPLANE_FLIGHT, vecDrawDef, DotDraw)
		ppVectorDraw(PIXPLANE_GAME, vecDrawDef, DotDraw)

		vbank(0)
		local persist = .6 + math.random()*.2
		copyPixplaneToScreenAndDecay(PIXPLANE_GAME, persist)

		vbank(1)
        ACTOR_SHIP:setPosition(R.V3:new(shipX * (1+pMetrics.progress) * 30, shipY * -60, -40 + pMetrics.progress * -200))
--        ACTOR_SHIP:setRotation(R.Quaternion:newFromEuler(mPi/2, mSin(pMetrics.progress * 4 * mPi), mPi))
		ACTOR_SHIP:setRotation(R.Quaternion:newFromEuler(mPi/2,GAME_SHIP.r,-mPi/4))
		SCENE:render(ENGINE)

        ppDefaultPixplanesMelt(FN_PIXPLANES_FLIGHT_MELT, {PIXPLANE_FLIGHT}, pMetrics.tics)
        FN_PIXPLANES_FLIGHT_TO_SCREEN({PIXPLANE_FLIGHT})

		local r = (.5+math.sin(pMetrics.progress * mPi * 30)*.5)*100
		circ(120 - shipX * 30, 68 + shipY * 68, r, 0)
	end,
	cleanup=function()
		vbank(1)
		cls()
	end,
})

end

rift_syscatmullrom=function()
--- Helpers for Maths - catmull-rom
-- @module sys.math

return function(R)
    R=R or {}

    local CatmullRomSpline={}

    local mMax, mMin = math.max, math.min

	function CatmullRomSpline:new()
		local o={
			values={},
            -- We can override this to get, for example, a vector value
            -- By default, it returns a single 'float'
            fnValueInterpolater = function(t, v0, v1, v2, v3)
                return R.catmullRom(t, v0, v1, v2, v3)
            end,
		}
		setmetatable(o,self)
		self.__index=self
		return o
	end

    -- NB You must add these in order! (#TODO: we could supply a sort function)
	function CatmullRomSpline:addValue(time, value)
		self.values[#self.values+1] = {t=time, v=value}
	end

    function getValueIndexV1(t, values)
        for i=2,#values do
            if t <= values[i].t then
                return i-1
            end
        end
        return #values
    end

    function CatmullRomSpline:setValueInterpolater(fnValueInterpolater)
        self.fnValueInterpolater = fnValueInterpolater
    end

    function CatmullRomSpline:getValue(time)
        local values = self.values

        local p1 = getValueIndexV1(time, values)
		local p0 = mMax(p1 - 1, 1)
		local p2 = mMin(p1 + 1, #values)
		local p3 = mMin(p1 + 2, #values)

		local t1 = values[p1].t
		local t2 = values[p2].t

		local t = (time - t1) / (t2 - t1)
        return self.fnValueInterpolater(t, values[p0].v, values[p1].v, values[p2].v, values[p3].v)
    end

    -- @param t Time (0-1)
    -- @param v0 The value at T=0
    -- @param v1 The first mid-value modifier
    -- @param v2 The second mid-value modifier
    -- @param v3 The value at T=1
    R.catmullRom = function(t, v0, v1, v2, v3)
        return 0.5 * (
            (2 * v1) +
            (-v0 + v2) * t +
            (2 * v0 - 5 * v1 + 4 * v2 - v3) * t * t +
            (-v0 + 3 * v1 - 3 * v2 + v3) * t * t * t
        )
    end

    R.CatmullRomSpline = CatmullRomSpline
end

end

rift_codegamelogic=function()
return function(R)
	R=R or {}

	local mCos, mSin, mAtan2, mSqrt, mPi = math.cos, math.sin, math.atan2, math.sqrt, math.pi
	local mAbs, mRandom = math.abs, math.random
	local mTau = mPi * 2

    rift_codegameship()
	rift_codegameasteroid()
	rift_codegamebullet()
    rift_codegameufo()
	rift_codegameevent()(R)
		
	local asteroidScale = 4

	local BITMAP_GAS = 0x1
	local BITMAP_TURN_AC = 0x2
	local BITMAP_TURN_CC = 0x4
	local BITMAP_SHOOT = 0x8
	
	local function isShipAsteroidCollision(ship, asteroid)
		local shipScale = 5
		if (ship.x - asteroid.x)^2 + (ship.y - asteroid.y)^2 < (asteroidScale*asteroid.size)^2 + shipScale^2 then
			return true
		end
		return false
	end
	
	local function isBulletAsteroidCollision(bullet, asteroid)
		if (bullet.x - asteroid.x)^2 + (bullet.y - asteroid.y)^2 < (asteroidScale*asteroid.size)^2 then
			return true
		end
		return false
	end

	local GameLogic={}

	function GameLogic:new()
		local o={
			isFirstRun = true,
			level = 1,
			gameTics = 0,
			state = "play",
			stateTics = 0,
			isRecording = true,
			recording = {},
			lastPlayerButtons = 0,
			ship,
			asteroids,
			bullets, 
			thudTime,
			thudTimeMax,
			thudType,
			ufo,
		}
		setmetatable(o,self)
		self.__index=self
		return o
	end

	function GameLogic:startRecording()
		self.isRecording = true
		self.recording = {}
	end

	-- receives a table, which is converted into events
	function GameLogic:startReplay(data)
		self.isRecording = false
		self.recording = {}
		for _,event in ipairs(data) do
			self.recording[#self.recording+1] = R.GameEvent:new(event)
		end
	end

	function GameLogic:addAsteroid(x,y,r,size)
		if self.isRecording then
			self.recording[#self.recording+1] = R.GameEvent:new({e="a", t=self.gameTics, x=x, y=y, r=r, s=size})
		end
		self.asteroids[#self.asteroids+1] = GameAsteroid:new(x,y,mTau*r/360,size)
	end

	function GameLogic:initNewLevel()
		local shipX, shipY = 120, 68
		self.ship = GameShip:new(shipX, shipY, 0)
		self.asteroids = {}
		self.bullets = {}
		self.ufo = nil
		self.lastPlayerButtons = 0
		self.thudTime = 0
		self.thudTimeMax = 50
		self.thudType = 0

		if self.isRecording then
			for i=1, self.level+3 do
				local x, y
				local r, s = mRandom(360), 3
				repeat	-- keep doing this until we find a spot that isn't super close to the ship
					x = mRandom(10,230)
					y = mRandom(10,118)
					if mAbs(x - shipX) > 30 and mAbs(y - shipY) > 30 then
						break
					end
				until(false)

				self:addAsteroid(x,y,r,s)
			end
		end
	end

	function GameLogic:initNewGame()
		self.level = 1
		self.score = 0
		self:initNewLevel()
	end

	-- returns a render list
	-- {
	--  state: (string),
    --  isRecording: (bool),
    -- 	score: (int),
	-- 	ship: {x,y,r}
	-- 	asteroids: {x,y,r,size}
	-- 	bullets: {x,y}
	-- }
	-- and a sound list
    -- and an event (nil, "gameover")
	function GameLogic:tic()
		local isReady = false
        local event = nil
		local cueState = nil
		local soundList = {}

		if self.state == "play" then
			if self.gameTics == 0 then
				self:initNewGame()
			elseif self.stateTics == 0 then
				self:initNewLevel()
			end

			local eventUFOdir = nil
			if not self.isRecording then
				while(#self.recording > 0) do
					local event = self.recording[1]:getData()
					if event.t > self.gameTics then
						break
					end

					table.remove(self.recording, 1)	-- pop it off

					if event.e == "a" then
						local x,y,r,s = event.x, event.y, event.r, event.s
						self:addAsteroid(x,y,r,s)
					elseif event.e == "b" then
						self.lastPlayerButtons = event.b
					elseif event.e == "u" then
						local x,y,dx,dy,size = event.x, event.y, event.dx, event.dy, event.s
						self.ufo = GameUFO:new(x, y, dx, dy, size)
					elseif event.e == "ud" then
						eventUFOdir = event
					end
				end
			end

			if self.stateTics < 50 then
				isReady = true
			else
				local turn = (btn(2) and -1 or 0) + (btn(3) and 1 or 0)

				local playerButtons = 0
				if self.isRecording then
					playerButtons =
						(btn(0) and BITMAP_GAS or 0)
						+ ((turn < 0) and BITMAP_TURN_AC or 0)
						+ ((turn > 0) and BITMAP_TURN_CC or 0)
						+ (keyp(48) and BITMAP_SHOOT or 0)

					if playerButtons ~= self.lastPlayerButtons then
						self.recording[#self.recording+1] = R.GameEvent:new({e="b", t=self.gameTics, b=playerButtons})
						self.lastPlayerButtons = playerButtons
					end

					if self.isRecording and keyp(21) and self.ufo == nil then
						local size = key(64) and 1 or 0
						local x = 0
						local dx = 1 - size * .5
						if mRandom() < .5 then
							x = 239
							dx = -dx
						end
						local y = 68 + ((mRandom() < .5) and 1 or -1) * mRandom(40)
						local dy = ((mRandom() < .5) and 1 or -1) * math.random(1,6)/4
						self.ufo = GameUFO:new(x, y, dx, dy, size)
						self.recording[#self.recording+1] = R.GameEvent:new({e="u", t=self.gameTics, x=x, y=y, dx=dx, dy=dy, s=size})
					end
				else
					-- pop off all recorded events that are before the current time... (Careful; we shouldn't skip tics or this will go very wrong!)
					playerButtons = self.lastPlayerButtons
				end

				if playerButtons & BITMAP_TURN_AC > 0 then
					self.ship:rotate(-0.1)
				end
				if playerButtons & BITMAP_TURN_CC > 0 then
					self.ship:rotate(0.1)
				end
				if playerButtons & BITMAP_GAS > 0 then
					self.ship:accelerate(0.1)
				end
				if (playerButtons & BITMAP_SHOOT > 0) and self.ship:tryShooting() then
					-- Add the ship movement to the bullet movement
					-- (ship may not be moving in the direction it is facing)
					local shipAngle, shipSpeed = self.ship:getMovement()
					-- Not sure why sin and cos are flipped here. Not worth figuring out just now...
					local shotSpeed = 2
					local xFire = mCos(shipAngle) * shipSpeed + mSin(self.ship.r) * shotSpeed
					local yFire = mSin(shipAngle) * shipSpeed - mCos(self.ship.r) * shotSpeed

					local angle = mAtan2(yFire, xFire)
					local speed = mSqrt(xFire^2 + yFire^2)

					self.bullets[#self.bullets+1] = GameBullet:new(self.ship.x, self.ship.y, angle, speed)
					soundList[#soundList+1] = "shoot"
				end

				self.ship:move()
				
				for _, asteroid in ipairs(self.asteroids) do
					asteroid:move()
				end

				if self.ufo then
					local event = self.ufo:move()
					if event then
						if event.e == 'exit' then
							self.ufo = nil
						elseif event.e == 'dir' then
							if self.isRecording then
								self.recording[#self.recording+1] = R.GameEvent:new({e="ud", t=self.gameTics, y=event.y, dy=event.dy})
							else
								self.ufo.y, self.ufo.dy = eventUFOdir.y, eventUFOdir.dy
							end
						end
					end
				end

				local spawnAsteroids = {}
				local scoring = {100, 50, 20}
				for i, bullet in ipairs(self.bullets) do
					if not bullet:isAlive() then
						table.remove(self.bullets, i)
					else
						bullet:decay()
						bullet:move()
					end
				end

				-- check collisions...
				for asteroidID, asteroid in ipairs(self.asteroids) do
					if isShipAsteroidCollision(self.ship, asteroid) then
						cueState = "gameover"
						event = "gameover"
						soundList[#soundList+1] = "explode"						
					end

					for _, bullet in ipairs(self.bullets) do
						if isBulletAsteroidCollision(bullet, asteroid) then
							bullet.alive = 0
							self.score = self.score + scoring[asteroid.size]

							table.remove(self.asteroids, asteroidID)

							if asteroid.size > 1 then
								spawnAsteroids[#spawnAsteroids+1] = {asteroid=asteroid, bulletR=bullet.r}
							end

							soundList[#soundList+1] = "asteroid-split"
						end
					end
				end

				for _, spawnAsteroid in ipairs(spawnAsteroids) do
					-- split into two smaller asteroids
					local asteroid = spawnAsteroid.asteroid
					local bulletR = spawnAsteroid.bulletR
					local rd = (asteroid.dr - bulletR) / 2

					self.asteroids[#self.asteroids+1] = GameAsteroid:new(asteroid.x, asteroid.y, asteroid.dr - rd, asteroid.size - 1)
					self.asteroids[#self.asteroids+1] = GameAsteroid:new(asteroid.x, asteroid.y, asteroid.dr + rd, asteroid.size - 1)
				end

				if #self.asteroids == 0 then
					cueState = "leveldone"
				end
			end

			self.thudTime = self.thudTime + 1
			if self.thudTime > self.thudTimeMax then
				self.thudTime = 0
				if self.thudTimeMax > 10 then
					self.thudTimeMax = self.thudTimeMax - 1
				end

				soundList[#soundList+1] = "thud-" .. self.thudType
				self.thudType = 1 - self.thudType
			end

			self.gameTics = self.gameTics + 1
		elseif self.state == "leveldone" then
			if self.stateTics > 50 then
				self.level = self.level + 1
				cueState = "play"
			end
		elseif self.state == "gameover" then
			if self.stateTics > 200 then
				self.isRecording = not self.isRecording
				if self.isRecording then
					self.recording = {}
				end
				self.gameTics = 0
				cueState = "play"
			end
		end

		local renderlist = {
			state = self.state,
            isRecording = self.isRecording,
			isReady = isReady,
            score = self.score,
			ship = {x=self.ship.x, y=self.ship.y, dx=self.ship.dx, dy=self.ship.dy, r=self.ship.r},
			asteroids = {},
			bullets = {},
		}

		for _, asteroid in ipairs(self.asteroids) do
			renderlist.asteroids[#renderlist.asteroids+1] = {x=asteroid.x, y=asteroid.y, size=asteroid.size*asteroidScale, r=asteroid.vr + asteroid.dr}
		end

		if self.ufo then
			renderlist.ufo = {x=self.ufo.x, y=self.ufo.y, size=self.ufo.size}
		end

		for _, bullet in ipairs(self.bullets) do
			renderlist.bullets[#renderlist.bullets+1] = {x=bullet.x, y=bullet.y}
		end

		if cueState then
			self.state = cueState
			self.stateTics = 0
		else
			self.stateTics = self.stateTics + 1
		end

		return renderlist, soundList, event
	end
	
    function GameLogic:getRecording()
        return self.recording
    end

	R.GameLogic = GameLogic
end

end

rift_code3d2modelscreen=function()
return function(R)
	local function makeMeshTemplateScreen(w,h)        
        local verts={{-w,h,0},{w,h,0},{w,-h,0},{-w,-h,0}}
		local quads={{1,2,3,4}}

		local mesh=R.Mesh:new()
		for _,v in ipairs(verts) do
			mesh:addVertex(nil, R.V3:new(v[1], v[2], v[3]))
		end
        
        mesh:addRenderable("quadTexScr1", {v1=1,v2=2,v3=3,v4=4})
		return mesh
	end

    local function makeModelScreen(w,h)
        local model=R.Model:new()

        model:addMeshTemplate("mtScreen", makeMeshTemplateScreen(w,h))
        model:addMeshInstance("miRoot",nil,"mtScreen",R.Quaternion:newFromEuler(0,0,0))

        return model
    end

    return makeModelScreen
end

end

rift_codedrawing=function()
local mAbs=math.abs
local mSin,mCos,mPi=math.sin,math.cos,math.pi
local FN_CLIP=function(x,y) return x>=0 and x<=255 and y>=0 and y<=127 end
local CAM={x=0,y=0,z=0}

function setRGB(i,r,g,b)
	local a=16320+i*3
	poke(a,r)
	poke(a+1,g)
	poke(a+2,b)
end

-- ci0 -> ci1 inclusive (and same for r,g,b)
function setRGBSpread(ci0,ci1, r0,g0,b0, r1,g1,b1)
	local ciSpread = ci1-ci0
	local rSpread,gSpread,bSpread = r1-r0, g1-g0, b1-b0
	for nc=0,ciSpread do
		local factor= nc / ciSpread
		setRGB(ci0+nc, r0+rSpread*factor, g0+gSpread*factor, b0+bSpread*factor)
	end
end

function setRGBGradient(r, g, b)
	for i=0,15 do
		local a=16320+i*3
		local v=i/15*255
		setRGB(i,r*v)
		setRGB(i,g*v)
		setRGB(i,b*v)
	end
end

function setCam(x,y,z)
	CAM={x=x,y=y,z=z}
end

function doBlur(tics)
    -- JTRUK: I don't think this is as it was
    local t=tics*.25
    for i=t%2,32640,1.9 do poke4(i,i/4e8+t%1) end
end

function setClipFn(fn)
	FN_CLIP=fn
end

function clearClip()
	FN_CLIP=function(x,y) return x>=0 and x<=255 and y>=0 and y<=127 end
end

function drawline(x, y, x2, y2, cbase,cbump)
	local w=x2-x
	local h=y2-y
	local dx1,dy1,dx2,dy2=0,0,0,0
	if (w<0) then dx1=-1 elseif (w>0) then dx1=1 end
	if (h<0) then dy1=-1 elseif (h>0) then dy1=1 end
	if (w<0) then dx2=-1 elseif (w>0) then dx2=1 end
	local longest=mAbs(w)
	local shortest=mAbs(h)
	if longest<shortest then
		longest=mAbs(h)
		shortest=mAbs(w)
		if h<0 then dy2=-1 elseif h>0 then dy2=1 end
		dx2=0
	end
	local numerator=longest/2
	for i=0,longest do
		if FN_CLIP(x,y) then
			pxadd(x,y,cbase,cbump)
--			pxadd(x+1,y,cbase,cbump)
--			pxadd(x,y+1,cbase,cbump)
--			pxadd(x+1,y+1,cbase,cbump)
		end
		numerator=numerator+shortest
		if numerator>longest then
			numerator=numerator-longest
			x=x+dx1
			y=y+dy1
		else
			x=x+dx2
			y=y+dy2
		end
	end
end

function pxadd(x,y, cbase,cbump)
	addPx(x//1,y//1,cbase)
end

function drawSpaceship(x,y,z, rotX,rotY,rotZ, c)
	local points={
		{x=-.5,y=0,z=0},
		{x=.35,y=0,z=0},
		{x=.5,y=0,z=.4},
		{x=.5,y=mSin(mPi*2/3)*.4,z=mCos(mPi*2/3)*.4},
		{x=.5,y=mSin(mPi*4/3)*.4,z=mCos(mPi*4/3)*.4},
	}
	local lines={
		{1,3},
		{1,4},
		{1,5},
		{2,3},
		{2,4},
		{2,5},
		{3,4},
		{4,5},
		{5,3},
	}
	
	transformPoints(points, x-CAM.x,y-CAM.y,z-CAM.z, rotX,rotY,rotZ)
	projectPoints(points)
	for i,l in ipairs(lines) do
		drawline(points[l[1]].x,points[l[1]].y,points[l[2]].x,points[l[2]].y, c,1)
	end
end

function drawTower(x,y,z, rotX,rotY,rotZ, c)
	local points={
		{x=-.2,y=-.5,z=-.2},
		{x=.2,y=-.5,z=-.2},
		{x=-.2,y=.5,z=-.2},
		{x=.2,y=.5,z=-.2},
		{x=-.2,y=-.5,z=.2},
		{x=.2,y=-.5,z=.2},
		{x=-.2,y=.5,z=.2},
		{x=.2,y=.5,z=.2},
	}
	local lines={
		{1,2},{2,3},{3,4},{4,1},
		{5,6},{6,7},{7,8},{8,5},
	}
	
	transformPoints(points, x-CAM.x,y-CAM.y,z-CAM.z, rotX,rotY,rotZ)
	projectPoints(points)
	for i,l in ipairs(lines) do
		drawline(points[l[1]].x,points[l[1]].y,points[l[2]].x,points[l[2]].y, c,1)
	end
end

end

rift_gfxticmctile2=function()
--- Functions to handle TicMcTile data
-- @module gfx.TicMcTile
-- @author Decca, Mantratronic, jtruk
return function(R)
	R=R or {}
	
	local toNum = tonumber

	-- the rle-decoder
	-- receives a string and pushes into VRAM
	-- dest = nil: take the value from the data
	-- tiles: 0x4000, sprites: 0x8000. Each 128x128x4bits
	-- tiles (0-255) or sprites (256-511)
	-- https://github.com/nesbox/TIC-80/wiki/blit-segment
	-- NB writeAddr is doubled for poke4
	local function toVRAM(str, writeAddr)
		writeAddr = writeAddr or toNum(str:sub(1,5),16)
		local w = toNum(str:sub(6,7),16)*8-1 -- get (w)idth
		local e = str:sub(8,str:len()) -- remove header to get (e)ncoded data
		local data = "" -- decoded data
		for m, c in e:gmatch("(%u+)([^%u]+)") do -- decode rle, (m)atch & (c)ounter
			data = data .. m .. (m:sub(-1):rep(c))  
		end
		
		local y = 0
		for x = 1,#data,1 do -- write to mem
			local c = string.byte(data:sub(x,x))-65 -- get (c)olor value
			poke4(writeAddr + y, c)
			y = y + 1
			if y > w then
				y = 0
				writeAddr = writeAddr + 1024
			end
		end
	end

	local TicMcTile = {}

	-- isTiles: 0=tiles, 1=sprites
	-- addrOffset: 0x0 - 0x2000
	-- bitsPerPixel: 1 (1c), 2 (4c), 4 (16c)
	-- returns (writeAddr, blitSegment) - both corrected for tile/sprite
	local blitSegmentForBPP = {
		[4]={[0] = {[0]=2}, [1] = {[0]=3}},
		[2]={[0] = {[0]=4, [1]=5}, [1] = {[0]=6, [1]=7}},
		[1]={[0] = {[0]=8, [1]=9, [2]=10, [3]=11}, [1] = {[0]=12, [1]=13, [2]=14, [3]=15}},
	}
	function getAddrAndBlit(isSprites, bitsPerPixel, addrOffset)
		local writeAddr = (isSprites and 0x6000 or 0x4000) + addrOffset
		local page = 0	-- not sure how this fits in!
		local blitSegment = blitSegmentForBPP[bitsPerPixel][isSprites and 1 or 0][page]
		return writeAddr, blitSegment
	end

	-- isSprites: tiles=false/sprites=true
	function TicMcTile:new(gfxData, isSprites, bitsPerPixel, xTiles0, yTiles0, w, h)
		xTiles0 = xTiles0 or 0
		yTiles0 = yTiles0 or 0
		w = w or 128
		h = h or 128
		-- Change this for bitsPerPixel
		local addrOffset = xTiles0 * 16 + yTiles0 * 512
		local addr, blitSegment = getAddrAndBlit(isSprites, bitsPerPixel, addrOffset)
		toVRAM(gfxData, addr*2)
		local o={
			bitsPerPixel = bitsPerPixel,
			blitSegment = blitSegment,	
			isSprites = isSprites,
			xSrcAddr = 0,
			xTiles0 = xTiles0,
			yTiles0 = yTiles0,
			xTilesW = w//8,
			yTilesH = h//8,
		}
		setmetatable(o,self)
		self.__index=self
		return o
	end

	function TicMcTile:draw(x, y)
		local blitSegment = self.blitSegment
--		local t = self.isSprites and 1 or 0
--		local r = 0 -- range

		--[[
		if blitSegment == 2 and r>0 then
			r=0
		elseif blitSegment == 4 and r>16 then
			r=16
		end

		if self.isSprites then
			s = r + (128 * blitSegment)			
		else
			s = r
		end

		s = 16 --self.xTiles0
		--]]

		local stride = 8
		if self.bitsPerPixel == 4 then
			stride = 16
		else
			stride = 32
		end

		local oldBlitSegment = peek4(2*0x3ffc)
		poke4(2*0x3ffc, blitSegment)
		for dy = 0, self.yTilesH-1 do
			local srcSprite = (self.yTiles0 + dy) * stride + self.xTiles0
			for dx = 0, self.xTilesW-1 do
				spr(srcSprite, x + dx*8, y + dy*8)
				srcSprite = srcSprite + 1
			end
		end
		poke4(2*0x3ffc, oldBlitSegment)
	end
	
	R.TicMcTile = TicMcTile
end


  --[[
  
  -- the viewer
  m=2 -- mode
  t=0 -- tiles/sprites
  r=0 -- range
  
  function draw()
	if m==2 and r>0 then r=0 end
	if m==4 and r>16 then r=16 end
	if t==0 then s=r else s=r+(128*m) end
	poke4(2*0x03ffc,m)
	cls(0)
	for y = 0,128-8,8 do
	  for x = 0,(m*64)-8,8 do
		spr(s,x+56,y+4) s=s+1
	  end
	end
	rect(184,2,56,132,00)
	rectb(54,2,132,132,10)
	print("Tiles",4-(t*32),4,15)
	print("Sprites",-40+(t*44),4,15)
	print("Page: "..(r//16),4,12,15)
	print("Mode: "..m,4,20,15)
	print("CTRL\n toggle\n Tiles or\n Sprites",4,32,10,false,1,true)
	print("Up/Down\n switch\n color\n mode",4,62,10,false,1,true)
	print("Left/Right\n switch\n pages",4,92,10,false,1,true)
	print("TAB\n display\n system font",4,116,10,false,1,true)
	for c = 0,15,1 do
	  rect(208,(c*8)+4,8,8,c)
	  print(c,218,(c*8)+6,15,false,1,true)
	end
  end
  
  -- call the viewer
  draw()
  
  -- system font demo - https://github.com/nesbox/TIC-80/wiki/system-font
  offy=4
  offx=65
  
  function font()
	cls()
	print("SYSTEM",0,5,12)
	print("FONT",0,12,12)
	print("CTRL\n back to\n Tiles or\n Sprites",0,24,10,false,1,true)
	for x = 0,15 do
	  off = x*16
	  print(string.format("%+3s",off),offx-20,x*8+offy+1,14,true,1, true)
	  for y =0,15 do
		char = y*16+x
		rect(x*11+offx,y*8+offy,8,7,15)
		print(string.char(char),x*11+offx,y*8+offy,12)
	  end
	end
  end
  
  function TIC()
	if btnp(00,60,6) and m<8 then m=m*2 draw() end
	if btnp(01,60,6) and m>2 then m=m//2 draw() end 
	if btnp(03,60,6) and r<48 then r=r+16 draw() end
	if btnp(02,60,6) and r>0 then r=r-16 draw() end 
	if keyp(63,60,6) then t=1-t draw() end
	if keyp(49,60,6) then t=1-t font() end
  end
  --]]

end

rift_codefontasteroids6x7=function()
-- title:  ASTEROIDS 6x7
-- author: Decca / RiFT
return {
	name="ASTEROIDS 6x7",
	rle="28E08beA15BABABABA2BA4FAFAFA10KAPBKAKAPBKA4CAHADAGAHACA4FAEACACABAFA4EAKAOBJAJAGBA3BABABA10EACABABACAEA4BACAEAEACABA6EAOAPBOAEA8CAHACA14BABA10HA18BA4EAEACACABABA4PAJANALAJAPA4CADACACACAHA4PAJAEACABAPA4PAIAEAIAIAPA4EAGAFAFAPAEA4PABAPAIAEADA4EACABAPAJAPA4PAIAEAEACACA4PAJAPAJAJAPA4PAJAPAIAEACA8BA2BA10BA2BABA6EACAPBCAEA8HA2HA8EAIAPBIAEA4HAMAGACA2CA4OABBFBNABAOA4GAJAJAPAJAJA4PAJAHAJAJAPA4PABABABABAPA4HAJAJAJAJAHA4PABAPABABAPA4PABAPABABABA4PAJABANAJAPA4JAJAPAJAJAJA4HACACACACAHA4IAIAIAJAKAMA4JAFADAFAJAJA4BABABABABAPA4BBLBFB6A3JALALANANAJA4PAJAJAJAJAPA4PAJAJAPABABA4PAJAJAJAFALA4PAJAJAPAFAJA4PABAPAIAIAPA4PBEAEAEAEAEA4JAJAJAJAJAPA4JAJAJAJAJAGA4B5FBLB2A3JAJAJAGAJAJA4JAJAJAGACACA4PAIAEACABAPA4DABABABABADA4BABACACAEAEA4DACACACACADA4EAKABBA19HA4CACACA12PAIAPAJAPA4BAPAJAJAJAPA6PABABABAPA4IAPAJAJAJAPA6PAJAPABAPA4GACAHACACACA6PAJAJAPAIAPA2BAPAJAJAJAJA4BA2BABABABA4IA2IAIAJAKAMA2BAJAFALAJAJA4BABABABABADA6PBFBFBFBFBA5PAJAJAJAJA6PAJAJAJAPA6PAJAJAJAPABA4PAJAJAJAPAIA4HABABABABA6PABAPAIAPA4CAHACACACACA6JAJAJAJAPA6JAJAJAJAGA6B3FBLB2A5JAJAGAJAJA6JAJAJAPAIAPA4PAIAGABAPA4MACABABACAMA4BABABABABABA4DAEAIAIAEADA20",
}

end

rift_partsgreetz=function()
local R=R or {}
local R2 = {}	-- hack!

rift_demopart()(R)
rift_syssys()(R)
rift_syscatmullrom()(R)
rift_3d2engine()(R2)
rift_3d2scene()(R2)
rift_3d2model()(R2)
rift_3d2mesh()(R2)
rift_3d2actor()(R2)
rift_3d2material()(R2)
rift_3d2skeleton()(R2)
rift_3d2v3()(R2)
rift_3d2m44()(R2)
rift_3d2quaternion()(R2)
rift_gfxticmctile2()(R)
local makeModelCabinet = rift_code3d2modelcabinet()(R2)
local setRGB, setPalette = rift_codepalette()(R)
local gfxCabinet, palCabinet = rift_codegfxcabinet()(R)
local quadShadedLit, triShadedLit, makeLinearPalMap, fnChoosePalMapIndexUnitNegToPos, fnChoosePalMapIndexUnitFacing = rift_codematerialflatlitpalettemap()(R2)
local triFlat, quadFlat = rift_codematerialflat()(R2)

rift_codegamelogic()(R)
local vecDefShip, vecDefAsteroid, vecDefUFO, vecDefBullet = rift_codevectorasteroidsgame()()

local mPi = math.pi
local mTau = mPi * 2
local mSin, mCos = math.sin, math.cos

rift_demopart()(R)
rift_codevector()

rift_codepixplane()
rift_codedrawingpixplane()

local vecfontDefs=rift_codevectorfontasteroids()
local setRGB, setPalette, setPaletteScaled, setPaletteAsteroids = rift_codepalette()(R)

local greetz={
  "Abyss",
  "Ate Bit",
  "Attention Whore",
  "Atlantis",
  "Alcatraz",
  "Bus Error",
  "Booze Design",
  "Darklite",
  "Dekadence",
  "Desire",
  "Exceed",
  "Fairlight",
  "Haujobb",
  "Hooy-Program",
  "Insane",
  "Ivory Labs",
  "Limp Ninja",
  "Logicoma",
  "Loonies",
  "Marquee Design",
  "Moods Plateau",
  "Nuance",
  "Oftenhide",
  "Quadtrip",
  "Razor 1911",
  "Slipstream",
  "SMFX",
  "Spectrals",
  "Spreadpoint",
  "Teadrinker",
  "TEK",
  "TPOLM",
  "TUHB",
  "Torment",
  "Trepaan",
  "AND YOU!",
}

local PIXPLANES
--local FN_PIXPLANES_MELT = makeFnAcrossPixplanes("pp1[srcA]=pp1[srcA]*.1")
--local FN_PIXPLANES_TO_SCREEN = makeFnAcrossPixplanes("poke4(destA, math.min(pp1[srcA],15))")

local FN_PIXPLANES_MELT = makeFnAcrossPixplanes("pp1[srcA]=pp1[srcA]*.2")
local FN_PIXPLANES_TO_SCREEN = makeFnAcrossPixplanes("poke4(destA, math.min(pp1[srcA],15))")

local cabSpline = R.CatmullRomSpline:new()
cabSpline:setValueInterpolater(
	function(t, v0, v1, v2, v3)
		return {
			pos = R2.V3:new(
				R.catmullRom(t, v0.pos.x, v1.pos.x, v2.pos.x, v3.pos.x),
				R.catmullRom(t, v0.pos.y, v1.pos.y, v2.pos.y, v3.pos.y),
				R.catmullRom(t, v0.pos.z, v1.pos.z, v2.pos.z, v3.pos.z)
			),
			rot = R2.Quaternion:newFromEuler(
				R.catmullRom(t, v0.rot.x, v1.rot.x, v2.rot.x, v3.rot.x),
				R.catmullRom(t, v0.rot.y, v1.rot.y, v2.rot.y, v3.rot.y),
				R.catmullRom(t, v0.rot.z, v1.rot.z, v2.rot.z, v3.rot.z)
			),
			sc = {
				x = R.catmullRom(t, v0.sc.x, v1.sc.x, v2.sc.x, v3.sc.x),
				y = R.catmullRom(t, v0.sc.y, v1.sc.y, v2.sc.y, v3.sc.y),
			}
		}
	end
)
cabSpline:addValue(0, {pos=R2.V3:new(0,-4,-6.5), rot=R2.V3:new(.222,0,0), sc={x=100,y=50}})
cabSpline:addValue(.05, {pos=R2.V3:new(0,-2,-20), rot=R2.V3:new(0,0,0), sc={x=60,y=0}})
cabSpline:addValue(.1, {pos=R2.V3:new(0,0,-50), rot=R2.V3:new(0,0,0), sc={x=60,y=0}})
cabSpline:addValue(.2, {pos=R2.V3:new(15,0,-35), rot=R2.V3:new(0,-1.4,0), sc={x=60,y=0}})
cabSpline:addValue(.3, {pos=R2.V3:new(0,-5,-20), rot=R2.V3:new(.3,0,0), sc={x=0,y=0}})
cabSpline:addValue(.4, {pos=R2.V3:new(-15,0,-30), rot=R2.V3:new(0,1,0), sc={x=-60,y=0}})
cabSpline:addValue(.5, {pos=R2.V3:new(0,-9,-20), rot=R2.V3:new(-.3,0,.3), sc={x=0,y=0}})
cabSpline:addValue(.6, {pos=R2.V3:new(15,0,-30), rot=R2.V3:new(.3,-1,-.2), sc={x=0,y=0}})
cabSpline:addValue(.7, {pos=R2.V3:new(0,-8,-20), rot=R2.V3:new(-.3,0,.2), sc={x=0,y=0}})
cabSpline:addValue(.8, {pos=R2.V3:new(-8,5,-30), rot=R2.V3:new(0,1,0), sc={x=-60,y=0}})
cabSpline:addValue(.9, {pos=R2.V3:new(0,2,-25), rot=R2.V3:new(.5,0,0), sc={x=0,y=0}})
cabSpline:addValue(1, {pos=R2.V3:new(0,-2.5,-20), rot=R2.V3:new(.5,0,0), sc={x=0,y=0}})

local DOTS = ppGetDefaultDots()

local scrTexX,scrTexY,scrTexW,scrTexH = 128,0,240-128,80

local ENGINE, CAMERA, LIGHT, SCENE
local ACTOR_CABINET = nil

local DotDraw={}
local d=6
for y=-d,d do
	for x=-d,d do
		local p = 1-((x*x+y*y)^.7)/d
		if p>0 then
			p=(p^5)*3
			DotDraw[#DotDraw+1] = {x,y,p}
		end
	end
end


local function getFnTextWarp(i, progress)
	local t = progress - i * .02
	if t < 0 or t > 1 then
		return function(x, y)
			return {x=0,y=0}
		end
	end
	local sc = math.sin(t*mTau)*2
	t = t * 5
	local a = (10+i)^5.1+t
	local s = math.sin(a)
	local c = math.cos(a)
	return function(x, y)
		x = x + t * 2
		local x = (x*10 - t) * sc - 40
		local y = (y*10 - t) * sc
		return {x=(120 + (i^4.9)%100 - 50 + s * x - c * y), y=68 + c * x + s * y}
	end
end

local GFX_CABINET
local GAME_LOGIC

local snapshot = {}

local mMin = math.min


return R.DemoPart:new({
	bdr=function(y, pMetrics)
		local progress = pMetrics.progress
		vbank(0)
		local r0 = 100 * y/150
		local r1 = 150 - mSin(progress * 5) * 100
		local g1 = 100 + mSin(progress * 8) * 100
		local b0 = 50 - mSin(progress * 7) * 50
		local b1 = 255-100*y/150
		setRGBSpread(1,15, r0,25,55, 160,g1,b1)
	end,
	tic=function(pMetrics)
		if pMetrics.isFirstRun then
			-- capture
			local remap = {
				[0]=12,
				[1]=15,[2]=15,[3]=1,[4]=1,
				[5]=13,[6]=13,[7]=14,[8]=14,
				[9]=5,[10]=5,[11]=11,[12]=11,
				[13]=11,[14]=6,[15]=6,
			}

			for y = 0, scrTexW do
				snapshot[y] = {}
				for x = 0, scrTexW do
					local xS, yS = 240 * x/scrTexW, 136 * y/scrTexH
					snapshot[y][x] = remap[pix(xS,yS)]
				end
			end

			GAME_LOGIC = R.GameLogic:new()
			GAME_LOGIC:startReplay(
				{{y=32,x=168,e="a",t=0,s=3,r=151},{y=10,x=48,e="a",t=0,s=3,r=189},{y=30,x=18,e="a",t=0,s=3,r=354},{y=99,x=158,e="a",t=0,s=3,r=276},{e="b",t=65,b=2},{e="b",t=83,b=1},{e="b",t=87,b=3},{e="b",t=101,b=2},{e="b",t=104,b=0},{e="b",t=114,b=2},{e="b",t=122,b=0},{e="b",t=124,b=2},{e="b",t=131,b=0},{e="b",t=133,b=1},{e="b",t=137,b=0},{e="b",t=155,b=1},{e="b",t=164,b=2},{e="b",t=176,b=0},{e="b",t=178,b=1},{e="b",t=180,b=0},{e="b",t=184,b=2},{e="b",t=192,b=3},{e="b",t=194,b=1},{e="b",t=202,b=0},{e="b",t=203,b=8},{e="b",t=204,b=0},{e="b",t=211,b=1},{e="b",t=214,b=5},{e="b",t=215,b=4},{e="b",t=236,b=0},{e="b",t=247,b=4},{e="b",t=250,b=1},{e="b",t=256,b=0},{e="b",t=261,b=8},{e="b",t=262,b=0},{e="b",t=273,b=2},{e="b",t=282,b=0},{e="b",t=298,b=8},{e="b",t=299,b=0},{e="b",t=301,b=4},{e="b",t=308,b=0},{e="b",t=309,b=8},{e="b",t=310,b=0},{e="b",t=320,b=8},{e="b",t=321,b=0},{e="b",t=334,b=2},{e="b",t=340,b=0},{e="b",t=346,b=8},{e="b",t=347,b=0},{e="b",t=354,b=4},{e="b",t=356,b=0},{e="b",t=359,b=8},{e="b",t=360,b=0},{e="b",t=367,b=1},{e="b",t=378,b=0},{e="b",t=387,b=8},{e="b",t=388,b=0},{e="b",t=390,b=4},{e="b",t=397,b=0},{e="b",t=399,b=8},{e="b",t=400,b=0},{e="b",t=402,b=4},{e="b",t=409,b=8},{e="b",t=410,b=0},{e="b",t=419,b=8},{e="b",t=420,b=0},{e="b",t=424,b=4},{e="b",t=426,b=0},{e="b",t=439,b=4},{e="b",t=448,b=12},{e="b",t=449,b=0},{e="b",t=457,b=2},{e="b",t=459,b=3},{e="b",t=462,b=1},{e="b",t=466,b=0},{e="b",t=474,b=8},{e="b",t=475,b=0},{e="b",t=478,b=4},{e="b",t=495,b=0},{e="b",t=497,b=8},{e="b",t=498,b=1},{e="b",t=501,b=0},{e="b",t=526,b=8},{e="b",t=527,b=0},{e="b",t=534,b=8},{e="b",t=535,b=0},{e="b",t=541,b=1},{e="b",t=546,b=3},{e="b",t=553,b=2},{e="b",t=557,b=0},{e="b",t=559,b=8},{e="b",t=560,b=0},{e="b",t=566,b=4},{e="b",t=573,b=12},{e="b",t=574,b=4},{e="b",t=575,b=0},{e="b",t=580,b=4},{e="b",t=584,b=0},{e="b",t=589,b=8},{e="b",t=590,b=4},{e="b",t=595,b=0},{e="b",t=601,b=8},{e="b",t=602,b=0},{e="b",t=613,b=10},{e="b",t=614,b=0},{e="b",t=617,b=4},{e="b",t=618,b=5},{e="b",t=622,b=13},{e="b",t=623,b=5},{e="b",t=630,b=13},{e="b",t=631,b=5},{e="b",t=637,b=4},{e="b",t=640,b=8},{e="b",t=641,b=0},{e="b",t=648,b=4},{e="b",t=654,b=5},{e="b",t=657,b=13},{e="b",t=658,b=5},{e="b",t=661,b=1},{e="b",t=663,b=0},{e="b",t=666,b=5},{e="b",t=668,b=1},{e="b",t=669,b=0},{e="b",t=670,b=8},{e="b",t=671,b=0},{e="b",t=680,b=1},{e="b",t=684,b=0},{e="b",t=687,b=2},{e="b",t=688,b=10},{e="b",t=689,b=2},{e="b",t=698,b=0},{e="b",t=707,b=8},{e="b",t=708,b=0},{e="b",t=721,b=10},{e="b",t=722,b=2},{e="b",t=733,b=3},{e="b",t=738,b=0},{e="b",t=751,b=2},{e="b",t=754,b=3},{e="b",t=757,b=11},{e="b",t=758,b=3},{e="b",t=762,b=2},{e="b",t=764,b=0},{e="b",t=767,b=8},{e="b",t=768,b=0},{e="b",t=770,b=2},{e="b",t=772,b=3},{e="b",t=774,b=2},{e="b",t=777,b=0},{e="b",t=780,b=8},{e="b",t=781,b=0},{e="b",t=790,b=8},{e="b",t=791,b=0},{e="b",t=795,b=2},{e="b",t=799,b=10},{e="b",t=800,b=0},{e="b",t=809,b=8},{e="b",t=810,b=0},{e="b",t=812,b=5},{e="b",t=816,b=1},{e="b",t=817,b=3},{e="b",t=834,b=10},{e="b",t=835,b=0},{e="b",t=843,b=4},{e="b",t=846,b=12},{e="b",t=847,b=4},{e="b",t=856,b=0},{e="b",t=860,b=4},{e="b",t=863,b=0},{e="b",t=867,b=8},{e="b",t=868,b=0},{e="b",t=874,b=1},{e="b",t=878,b=0},{e="b",t=881,b=4},{e="b",t=882,b=12},{e="b",t=883,b=4},{e="b",t=893,b=0},{e="b",t=895,b=8},{e="b",t=896,b=0},{e="b",t=898,b=4},{e="b",t=906,b=12},{e="b",t=907,b=4},{e="b",t=915,b=5},{e="b",t=923,b=13},{e="b",t=924,b=5},{e="b",t=927,b=0},{e="b",t=933,b=9},{e="b",t=934,b=1},{e="b",t=941,b=0},{e="b",t=943,b=8},{e="b",t=944,b=0},{e="b",t=945,b=2},{e="b",t=953,b=0},{e="b",t=956,b=9},{e="b",t=957,b=1},{e="b",t=965,b=9},{e="b",t=966,b=1},{e="b",t=972,b=0},{e="b",t=975,b=8},{e="b",t=976,b=0},{e="b",t=985,b=8},{e="b",t=986,b=0},{e="b",t=988,b=2},{e="b",t=1001,b=3},{e="b",t=1004,b=1},{e="b",t=1007,b=0},{e="b",t=1009,b=8},{e="b",t=1010,b=0},{e="b",t=1020,b=8},{e="b",t=1021,b=0}}
			)

			vbank(0)
			setRGB(0,0,0,0)
			PIXPLANES=initPixplanes()

			vbank(1)
			setRGB(1, 42, 45, 51)
			setRGB(2, 14, 68, 120)
			setRGB(3, 7, 107,193)
			setRGB(4, 146, 135, 207)
			setRGB(5, 173, 179, 182)
			setRGB(6, 250,250,250)
			setRGB(7, 0,0,0)
			setRGB(8, 190,35,20)
			setRGB(9, 217,206,31)
			setRGB(10, 82,145,198)
			setRGB(11, 213,217,219)
			setRGB(12, 0,0,0)
			setRGB(13, 80,80,80)
			setRGB(14, 120,120,120)
			setRGB(15, 20,20,20)

			ENGINE = R2.Engine:new()
			CAMERA = R2.Camera:new(R2.V3:new(0,0,0), R2.Quaternion:newFromEuler(0,0,0))
			LIGHT = R2.V3:new(0,-1,1)
			LIGHT:normalize()
			SCENE = R2.Scene:new(CAMERA) 

			ENGINE:setMaterial("triFlat", triFlat(12))
			ENGINE:setMaterial("quadFlat", quadFlat(12))

			ENGINE:setMaterial("triSideart", R2.Material.triTextured(2,-1, 2,0,48,122,4, {[0] = 7}, true))
			ENGINE:setMaterial("quadMarquee", R2.Material.quadTextured(2,-1, 96,0,32,112,4, {[0] = 7}))
			ENGINE:setMaterial("quadControlPanel", R2.Material.quadTextured(2,-1, 48,0,48,96,4, {[0] = 7}))
		
			local matScreen = R2.Material.quadTextured(2,-1, scrTexX,scrTexY,scrTexW,scrTexH, 4, {[0] = 7})
			matScreen.order = 1
			ENGINE:setMaterial("quadScreen", matScreen)

			local model = makeModelCabinet()
			local modelID = ENGINE:addModel(model)
			local pos = R2.V3:new(0, -10, 0)
			local actor = SCENE:newActor(modelID, pos, "miRoot")
			ACTOR_CABINET = actor

			GFX_CABINET = R.TicMcTile:new(gfxCabinet, true, 4, 0,0,128,128)
		end

		local progress = pMetrics.progress

		vbank(0)
		GFX_CABINET:draw(0,0)
		if progress < .2 then
			for y = 0, scrTexW do
				for x = 0, scrTexW do
					local xS, yS = 240 * x/scrTexW, 136 * y/scrTexH
					pix(scrTexX + x, scrTexY + y, snapshot[y][x])
				end
			end
		else
			local creditProgress = (progress - .2)/.8
			local creditPages = {
				{y=12,credits={{t="Direction", s=2}, {t="Code", s=2}, {t="JTRUK", s=3}}},
				{y=12,credits={{t="Art", s=2}, {t="Font", s=2}, {t="Decca", s=3}}},
				{y=4,credits={{t="", s=2}, {t="Code", s=2}, {t="Dave84", s=3}}},
				{y=12,credits={{t="Music", s=2}, {t="Code", s=2}, {t="Enfys", s=3}}},
				{y=4,credits={{t="", s=2}, {t="Music", s=2}, {t="Gasman", s=3}}},
				{y=4,credits={{t="Tools", s=2}, {t="JTRUK Decca", s=2}, {t="Mantratronic", s=2}, {t="Jynx", s=2}}},
				{y=12,credits={{t="RiFT", s=2}, {t="For", s=2}, {t="Revision", s=3}}},
			}
			rect(scrTexX,scrTexY,scrTexW,scrTexH,1)

			iCredit = 1 + (creditProgress * #creditPages)//1
			local creditPage = creditPages[mMin(iCredit, #creditPages)]
			for i,credit in ipairs(creditPage.credits) do
				local text = credit.t
				local w = print(text,0,140,10,false,credit.s)
				local x = scrTexX + (scrTexW - w)/2 + 3
				local y = creditPage.y+(i-1)*20
				print(text,x,y,3,false,credit.s)
				print(text,x-2,y-2,9,false,credit.s)
			end
		end

		vbank(1)
		cls()

		local actor = ACTOR_CABINET
		actor:setSkins({"screen"})
		local splineValues = cabSpline:getValue(progress)

		local slerpTo = 1
		if progress < .05 then
			slerpTo = progress/.05
		end
		local slerpFrom = 1-slerpTo

--		actor:setPosition(R2.V3:new(0,-9,-20))
--		actor:setRotation(R2.Quaternion:newFromEuler(0,progress * mPi * 2,0))

		actor:setPosition(splineValues.pos)
		actor:setRotation(splineValues.rot)
		if splineValues.pos.z < -15 then
			actor:setSkins({"default", "screen"})
		end

		CAMERA:setPosition(R2.V3:new(0,0,0))
		SCENE:render(ENGINE)

		local pixplane=PIXPLANES[1]

		vbank(0)
		ppDefaultPixplanesMelt(FN_PIXPLANES_MELT, {pixplane}, pMetrics.tics)

		local pages = (#greetz//6)+1
		local iPage = (progress * pages)//1
		for i=1,6 do
			local iGreet = iPage * 6 + i
			if iGreet <= #greetz then
				ppVecFontPrint(pixplane, vecfontDefs,
					50 + mSin(progress*10 + iGreet) * 10, 10+(i-1)*20 + mSin(progress*15 + iGreet) * 3,
					greetz[iGreet], 13, DotDraw)
			end
		end

		local renderlist, soundList, event = GAME_LOGIC:tic()
		local screenXSc = 1
		local ship = renderlist.ship -- orient everything around the ship!
		local zoom = 2
		local centreX, centreY = 120 + splineValues.sc.x, 68 + splineValues.sc.y
		local camSlip = 10
		local camOffsetX, camOffsetY = centreX - ship.x * zoom, centreY - ship.y * zoom
		camOffsetX, camOffsetY = camOffsetX + ship.dx * camSlip * zoom, camOffsetY + ship.dy * camSlip * zoom

		for _, asteroid in ipairs(renderlist.asteroids) do
			asteroidScale = asteroid.size * zoom
			local vecDrawDef=vectorTransformPoints(vecDefAsteroid, asteroid.x * zoom + camOffsetX, asteroid.y * zoom + camOffsetY, asteroidScale * screenXSc, asteroidScale, asteroid.r)
			ppVectorDraw(pixplane, vecDrawDef, DotDraw)
		end

		for _, bullet in ipairs(renderlist.bullets) do
			local vecDrawDef = vectorTransformPoints(vecDefBullet, bullet.x * zoom + camOffsetX, bullet.y * zoom + camOffsetY, zoom, zoom, 0)
			ppVectorDraw(pixplane, vecDrawDef, DotDraw)
		end

		local starScale = .1 * zoom 
		for i=0,40 do
			local x = ((i+1000)^4.6)%240
			local y = ((i+1500)^3.9)%128
			local vecDrawDef = vectorTransformPoints(vecDefBullet, x * zoom + camOffsetX, y * zoom + camOffsetY, starScale, starScale, 0)
			ppVectorDraw(pixplane, vecDrawDef, DotDraw)
		end

		local shipScale = 6 * zoom
		local vecDrawDef = vectorTransformPoints(vecDefShip, ship.x * zoom + camOffsetX, ship.y * zoom + camOffsetY, shipScale * screenXSc, shipScale, ship.r)
		ppVectorDraw(pixplane, vecDrawDef, DotDraw)

		FN_PIXPLANES_TO_SCREEN({pixplane})
	end,
	cleanup=function()
		vbank(0)
		cls()
	end,
})

	

end

rift_codedrawfuji=function()
return function(x,y,w,h,cbg,c1,c2)
--	rect(x,y,w,h,cbg)
	local pw = 6
	local wh, pwh = w/2, pw/2

	local y0 = h * .2
	local y1 = h * .6
	local y2 = h * .6
	local y4 = h * .8
	local x1d = w * .08
	local x2d = w * .22
	local x3d = w * .4
	rect(x+wh-pwh,y+y0,pw,y4-y0,c1)

	tri(x+wh+x1d,y+y0, x+wh+x1d,y+y2, x+wh+x2d,y+y1, c2)
	tri(x+wh+x1d,y+y2, x+wh+x2d,y+y1, x+wh+x3d,y+y4, c2)

	tri(x+wh-x1d,y+y0, x+wh-x1d,y+y2, x+wh-x2d,y+y1, c2)
	tri(x+wh-x1d,y+y2, x+wh-x2d,y+y1, x+wh-x3d,y+y4, c2)
end

end

rift_codedotsship=function()
local dots = {}
local d=2
for y=-d,d do
	for x=-d,d do
		local p = 1-((x*x+y*y)^.7)/d
		if p>0 then
			p=(p^3)
			dots[#dots+1] = {x,y,p}
		end
	end
end

return dots

end

rift_codegamebullet=function()
local mSin, mCos = math.sin, math.cos

GameBullet={}
function GameBullet:new(x,y,r,speed)
	local o={
		x=x,
		y=y,
		r=r,
		speed=speed,
		alive=60,
	}
	setmetatable(o,self)
	self.__index=self
	return o
end

function GameBullet:move()
	self.x = (self.x + mCos(self.r) * self.speed)%240
	self.y = (self.y + mSin(self.r) * self.speed)%128
end

function GameBullet:isAlive()
	return self.alive > 0
end

function GameBullet:decay()
	self.alive = self.alive - 1
end

end

rift_codegfxriftlogo=function()
local pal = "07F800cPDPDPDGKFCNECPFDBHIFFBJCNAHAFAOFMFHBFKFKICJPJPNDJCGDPGLDNFJMBEGKGPDHPOHPEPEPEPEJALCMGFMGGIDDMDHF0"

local gfx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

return function(R)
    return gfx, pal
end

end

rift_partsfaketogame=function()
R=R or {}

rift_demopart()(R)

return R.DemoPart:new({
	tic=function(pMetrics)
        return "secret"
	end,
	cleanup=function()
	end,
})


end

rift_partswrithe=function()
local ENGINE, CAMERA, LIGHT, SCENE
local ACTORS = {}

local R2 = {}	-- hack!

rift_demopart()(R)
rift_syssys()(R)
rift_3d2engine()(R2)
rift_3d2scene()(R2)
rift_3d2model()(R2)
rift_3d2mesh()(R2)
rift_3d2actor()(R2)
rift_3d2material()(R2)
rift_3d2skeleton()(R2)
rift_3d2v3()(R2)
rift_3d2m44()(R2)
rift_3d2quaternion()(R2)
local drawFuji = rift_codedrawfuji()
local makeModelFigure, constrainSkeleton = rift_code3d2modelfigure()(R2)
local quadShadedLit, triShadedLit, makeLinearPalMap, fnChoosePalMapIndexUnitNegToPos, fnChoosePalMapIndexUnitFacing = rift_codematerialflatlitpalettemap()(R2)

local vecfontDefs = rift_codevectorfontasteroids()

local FN_PIXPLANES_MELT = makeFnAcrossPixplanes("pp1[srcA]=pp1[srcA]*.5")
local FN_PIXPLANES_TO_SCREEN = makeFnAcrossPixplanes("poke4(destA, math.min(pp1[srcA],15))")
local DOTS = rift_codedotsship()

local gfxHatching, palHatching = rift_codegfxhatching()(R)
local GFX_HATCHING

local gfxFaceRains, palFaceRains = rift_codegfxfacerains()(R)
local GFX_FACE_RAINS

local gfxFaceLogg, palFaceLogg = rift_codegfxfacelogg()(R)
local GFX_FACE_LOGG

local mSin, mCos, mPi = math.sin, math.cos, math.pi

function poseWrite(actor, ts)
	local skeleton = actor.skeleton
	actor:rotate(R2.Quaternion:newFromEuler(math.sin(ts*.01)*.004,math.sin(ts*.012)*.008,math.sin(ts*.005)*.006))

	skeleton:setJoint({"miPelvis","jWaist"}, R2.Quaternion:newFromEuler(-.1+math.sin(-ts*.02)*1,math.sin(ts*.03)*.7,math.sin(ts*.023)*.4))
	skeleton:setJoint({"miTorso","jLeftShoulder"}, R2.Quaternion:newFromEuler(mPi*.4+math.sin(ts*.03)*2,-1+math.sin(ts*.05)*1,math.sin(ts*.02)*.2))
	skeleton:setJoint({"miLeftArmHigh","jElbow"}, R2.Quaternion:newFromEuler(1.2+math.sin(ts*.025)*1.2,-mPi*.2+math.sin(ts*.06)*.3,0))
	skeleton:setJoint({"miLeftArmLow","jWrist"}, R2.Quaternion:newFromEuler(math.sin(ts*.02)*0.8,math.sin(ts*.05)*0.8,math.sin(ts*.04)*0.8))
	skeleton:setJoint({"miTorso","jRightShoulder"}, R2.Quaternion:newFromEuler(mPi*.4+math.sin(ts*.04)*2,1+math.sin(ts*.04)*1,-math.sin(ts*.02)*.2))
	skeleton:setJoint({"miRightArmHigh","jElbow"}, R2.Quaternion:newFromEuler(1.2+math.sin(ts*.035)*1.2,-mPi*.2-math.sin(ts*.03)*.3,0))
	skeleton:setJoint({"miRightArmLow","jWrist"}, R2.Quaternion:newFromEuler(math.sin(ts*.02)*0.8,-math.sin(ts*.05)*0.8,-math.sin(ts*.04)*0.8))
	skeleton:setJoint({"miTorso","jNeck"}, R2.Quaternion:newFromEuler(math.sin(ts*.015)*.5,math.sin(ts*.02),math.sin(ts*.03)*.4))
	skeleton:setJoint({"miPelvis","jLeftHip"}, R2.Quaternion:newFromEuler(mPi*.2+math.sin(ts*.03)*1.4,mPi*.2+math.sin(ts*.03)*.5,math.sin(mPi+ts*.025)*.5))
	skeleton:setJoint({"miLeftLegHigh","jKnee"}, R2.Quaternion:newFromEuler(-mPi*.5-math.sin(ts*.05)*.8,0,0))
	skeleton:setJoint({"miLeftLegLow","jAnkle"}, R2.Quaternion:newFromEuler(math.sin(ts*.05)*.7,0,0))
	skeleton:setJoint({"miPelvis","jRightHip"}, R2.Quaternion:newFromEuler(mPi*.2+math.sin(mPi+ts*.04)*1.4,math.sin(mPi+ts*.025)*.5,math.sin(mPi+ts*.02)*.5))
	skeleton:setJoint({"miRightLegHigh","jKnee"}, R2.Quaternion:newFromEuler(-mPi*.5-math.sin(mPi+ts*.06)*.8,0,0))
	skeleton:setJoint({"miRightLegLow","jAnkle"}, R2.Quaternion:newFromEuler(-math.sin(ts*.05)*.7,0,0))
end

local lines={
	"Cres",
	"Vsta",
	"Plls",
	"Hgia",
	"Itna",
	"Erpa",
}

local scores={
	9999,
	7800,
	2600,
	2025,
	1979,
	1337,
}

local actorTs1 = 0
local actorTs2 = 0

return R.DemoPart:new({
	tic=function(pMetrics)
		if pMetrics.isFirstRun then
			PIXPLANES=initPixplanes()
			
			ENGINE = R2.Engine:new()
			CAMERA = R2.Camera:new(R2.V3:new(0,0,0), R2.Quaternion:newFromEuler(0,0,0))
			LIGHT = R2.V3:new(0,-1,1)
			LIGHT:normalize()
			SCENE = R2.Scene:new(CAMERA)    

			GFX_FACE_RAINS = R.TicMcTile:new(gfxFaceRains, true, 2, 0,64, 64,64)
			GFX_FACE_LOGG = R.TicMcTile:new(gfxFaceLogg, true, 2, 64,64, 64,64)

--			function TicMcTile:new(gfxData, isSprites, bitsPerPixel, addrOffset, xTiles0, yTiles0, w, h)

			ENGINE:setMaterial("quadTexChest", R2.Material.quadTextured(2,-1, 64,0,64+64,64))
			ENGINE:setMaterial("quadTexFace", R2.Material.quadTextured(2,-1, 0,0,64,64))

			local palMap = makeLinearPalMap(1, 15)
			local choosePalMapIndex = fnChoosePalMapIndexUnitNegToPos(#palMap)
			ENGINE:setMaterial("quadFlatLit", quadShadedLit(LIGHT, palMap, choosePalMapIndex))

			local runnerModel = makeModelFigure("regular", 1, 1, 1)
			local modelID = ENGINE:addModel(runnerModel)
			local actor = SCENE:newActor(modelID, R2.V3:new(5,0,-9), "miPelvis")
			constrainSkeleton(actor)
			ACTORS["figure1"] = actor
			actor:setRotation(R2.Quaternion:newFromEuler(0,mPi,0))

			local actor = SCENE:newActor(modelID, R2.V3:new(-5,0,0), "miPelvis")
			constrainSkeleton(actor)
			ACTORS["figure2"] = actor
			actor:setRotation(R2.Quaternion:newFromEuler(0,mPi,0))

			vbank(1)
			setRGBSpread(1,15, 10,15,30, 240,245,255)
		end

		local progress = pMetrics.progress
		local actor1 = ACTORS["figure1"]
		local actor2 = ACTORS["figure2"]

		LIGHT:set(0, mSin(progress * 8), 1)
		LIGHT:normalize()
		
		poseWrite(actor1, actorTs1)
		poseWrite(actor2, actorTs2)
		actor1:setRotation(R2.Quaternion:newFromEuler(progress*8,progress*16,progress*4))
		actor2:setRotation(R2.Quaternion:newFromEuler(progress*12,progress*6,progress*8))
		actor1:setPosition(R2.V3:new(10-progress*10,progress*6-4,-9+progress*20))
		actor2:setPosition(R2.V3:new(-10+progress*12,-progress*4+7,-progress*8))

		actorTs1 = actorTs1 + 2 * (1 - progress)
		actorTs2 = actorTs2 + 1.7 * (1 - progress)
	
		vbank(1)
		cls()
		print("X", 16,8,7, true, 7)

		vbank(0)
		local r1l, g1l, b1l = 80,0,40
		local r1h, g1h, b1h = 200,150,40
		local r2l, g2l, b2l = 0,0,180
		local r2h, g2h, b2h = 40,0,0
		local rl = r1l + (r2l - r1l) * progress
		local gl = g1l + (g2l - g1l) * progress
		local bl = b1l + (b2l - b1l) * progress
		local rh = r1h + (r2h - r1h) * progress
		local gh = g1h + (g2h - g1h) * progress
		local bh = b1h + (b2h - b1h) * progress
		setRGB(0, 0,0,0)
		setRGBSpread(1,15, rl,gl,bl, rh,gh,bh)

		cls()
		CAMERA:setPosition(R2.V3:new(
			0, -- -10 + progress * 10,
			0, ---10 + progress * 10,
			25 -- + progress * 60
		))
		CAMERA:setRotation(R2.Quaternion:newFromEuler(0,0,progress*3))
		SCENE:render(ENGINE)
		
		vbank(1)
		cls()
		if progress > .5 then
			hiscoreProgress = (progress - .5)/.5

			local pixplane=PIXPLANES[1]
	        ppDefaultPixplanesMelt(FN_PIXPLANES_MELT, {pixplane}, pMetrics.tics)

			local textSize = 11
			local textY = 12
			ppVecFontPrint(pixplane, vecfontDefs, 85, textY, "HI SCORES", textSize, DOTS)

			for i=1,#lines do
				local l = string.format("%04d", math.min(scores[i],((scores[i]+10000)*hiscoreProgress)//1)).." "..lines[i]
				local scale = 5
				ppVecFontPrint(pixplane, vecfontDefs, 85, textY + 10 + i * 16, l, textSize, DOTS)
			end
			FN_PIXPLANES_TO_SCREEN(PIXPLANES)
		end
	end,
})

end

rift_partsrunning=function()
local ENGINE_BG, ENGINE_FG
local SCENE_BG, SCENE_FG
local CAMERA, LIGHT
local ACTOR1
local ACTOR2
local ACTOR_TUNNELS = {}

local R2 = {}	-- hack!

rift_demopart()(R)
rift_syssys()(R)
rift_sysmath()(R)
rift_syscatmullrom()(R)
rift_3d2engine()(R2)
rift_3d2scene()(R2)
rift_3d2model()(R2)
rift_3d2mesh()(R2)
rift_3d2actor()(R2)
rift_3d2material()(R2)
rift_3d2skeleton()(R2)
rift_3d2v3()(R2)
rift_3d2m44()(R2)
rift_3d2quaternion()(R2)
rift_gfxticmctile2()(R)
local makeModelFigure, constrainSkeleton = rift_code3d2modelfigure()(R2)
local makeModelTunnel = rift_code3d2modelfiguretunnel()(R2)
local setRGB, setPalette, setPaletteScaled = rift_codepalette()(R)
local TextTicker = rift_codetextticker()()
local quadShadedLit, triShadedLit, makeLinearPalMap, fnChoosePalMapIndexUnitNegToPos, fnChoosePalMapIndexUnitFacing = rift_codematerialflatlitpalettemap()(R2)
local drawFuji = rift_codedrawfuji()

local gfxHatching, palHatching = rift_codegfxhatching()(R)
local GFX_HATCHING

local gfxFaceRains, palFaceRains = rift_codegfxfacerains()(R)
local GFX_FACE_RAINS

local gfxFaceLogg, palFaceLogg = rift_codegfxfacelogg()(R)
local GFX_FACE_LOGG

local mPi = math.pi
local mSin = math.sin
local mMin, mMax = math.min, math.max

local timeSpline = R.CatmullRomSpline:new()
timeSpline:addValue(0, 1)
timeSpline:addValue(.25, 1)
timeSpline:addValue(.4, 0.25)
timeSpline:addValue(.55, 0.25)
timeSpline:addValue(.6, 1)
timeSpline:addValue(.75, 0.25)
timeSpline:addValue(.8, 0.25)
timeSpline:addValue(.85, 1)
timeSpline:addValue(1, 1)

local camSpline = R.CatmullRomSpline:new()
camSpline:setValueInterpolater(
	function(t, v0, v1, v2, v3)
		return {
			pos = R2.V3:new(
				R.catmullRom(t, v0.pos.x, v1.pos.x, v2.pos.x, v3.pos.x),
				R.catmullRom(t, v0.pos.y, v1.pos.y, v2.pos.y, v3.pos.y),
				R.catmullRom(t, v0.pos.z, v1.pos.z, v2.pos.z, v3.pos.z)
			),
			fov = R.catmullRom(t, v0.fov, v1.fov, v2.fov, v3.fov),
		}
	end
)
camSpline:addValue(0, {pos=R2.V3:new(0,1,0), fov=20})
camSpline:addValue(.15, {pos=R2.V3:new(0,7,0), fov=80})
camSpline:addValue(.3, {pos=R2.V3:new(0,7,0), fov=80})
camSpline:addValue(.35, {pos=R2.V3:new(-7,11,0), fov=40})
camSpline:addValue(.5, {pos=R2.V3:new(-7,11,-3), fov=40})
camSpline:addValue(.55, {pos=R2.V3:new(-3,8,0), fov=60})
camSpline:addValue(.65, {pos=R2.V3:new(0,8,0), fov=80})
camSpline:addValue(.7, {pos=R2.V3:new(3,10,0), fov=40})
camSpline:addValue(.85, {pos=R2.V3:new(3,10,-3), fov=40})
camSpline:addValue(.9, {pos=R2.V3:new(0,5,0), fov=80})
camSpline:addValue(.95, {pos=R2.V3:new(0,5,0), fov=80})
camSpline:addValue(1, {pos=R2.V3:new(-4.5,9,0), fov=10})

local actorSplines = R.CatmullRomSpline:new()
actorSplines:setValueInterpolater(
	function(t, v0, v1, v2, v3)
		return {
			actor1 = {
				x = R.catmullRom(t, v0.actor1.x, v1.actor1.x, v2.actor1.x, v3.actor1.x),
				y = R.catmullRom(t, v0.actor1.y, v1.actor1.y, v2.actor1.y, v3.actor1.y),
			},
			actor2 = {
				x = R.catmullRom(t, v0.actor2.x, v1.actor2.x, v2.actor2.x, v3.actor2.x),
				y = R.catmullRom(t, v0.actor2.y, v1.actor2.y, v2.actor2.y, v3.actor2.y),
			},
		}
	end
)
actorSplines:addValue(0, {actor1={x=-.6,y=0}, actor2={x=-.6,y=0}})
actorSplines:addValue(.25, {actor1={x=-.6,y=0}, actor2={x=-.6,y=-.4}})
actorSplines:addValue(.6, {actor1={x=-.5,y=.9}, actor2={x=-.6,y=-.9}})
actorSplines:addValue(.75, {actor1={x=-.5,y=.9}, actor2={x=-.6,y=0}})
actorSplines:addValue(1, {actor1={x=-.6,y=0}, actor2={x=-.6,y=0}})


local PROGRESS = 0

local TEXT_TICKER1 = TextTicker:new({"Cmdr. Rains", "Pilot", " (highly decorated)"})
local TEXT_TICKER2 = TextTicker:new({"Cmdr. Logg", "Gunner", " (first order)"})

function runnerPose(actor, basePos, ts, speed)
	local skeleton = actor.skeleton
	local leftA = ts*speed
	local rightA = ts*speed + mPi
	local bounce = math.abs(math.sin(leftA))
	actor:setPosition(basePos + R2.V3:new(0,bounce*1,0))
	skeleton:setJointWithRange({"miPelvis","jLeftHip"}, math.sin(leftA),-.1,.5)
	skeleton:setJointWithRange({"miLeftLegHigh","jKnee"}, math.sin(leftA-1.2),-.2,.2)
	skeleton:setJointWithRange({"miLeftLegLow","jAnkle"}, math.sin(leftA-.25)*.3,-.5,-.1)
	skeleton:setJointWithRange({"miPelvis","jRightHip"}, math.sin(rightA),-.1,.4)
	skeleton:setJointWithRange({"miRightLegHigh","jKnee"}, math.sin(rightA-1.2),-.2,.2)
	skeleton:setJointWithRange({"miRightLegLow","jAnkle"}, math.sin(rightA-.25)*.3,.5,.1)
	skeleton:setJointWithRange({"miPelvis","jWaist"}, 1-math.sin(bounce)*.6,math.sin(leftA)*.3,math.sin(leftA)*.2)
	skeleton:setJointWithRange({"miTorso","jNeck"}, -.5-math.sin(bounce)*.3,-math.sin(leftA)*.3,math.sin(leftA)*.4)
	skeleton:setJointWithRange({"miTorso","jLeftShoulder"}, math.sin(leftA+1)*.5,math.sin(leftA+1)*.4+.6,math.sin(leftA+1)*.3-.3)
	skeleton:setJointWithRange({"miLeftArmHigh","jElbow"}, math.sin(leftA)*.1,0,0)
--	skeleton:setJointWithRange({"miLeftArmLow","jWrist"}, math.sin(leftA)*.5,0,0)
	skeleton:setJointWithRange({"miTorso","jRightShoulder"}, math.sin(rightA+1)*.5,math.sin(rightA+1)*.4+.6,math.sin(rightA+1)*.3-.3)
	skeleton:setJointWithRange({"miRightArmHigh","jElbow"}, math.sin(rightA)*.1,0,0)
--	skeleton:setJointWithRange({"miRightArmLow","jWrist"}, 0,0,1)
end


local function paletteRemap(map)
	local a = 0x3ff0*2
	for k,v in pairs(map) do
		poke4(a + k, v)
	end
end

local function faceTextured(sx,sy,sw,sh)
	local mat = R2.Material.quadTextured(2,-1,sx,sy,sw,sh,2, {[0]=13, [1]=14, [2]=15, [3]=12})
	local fnDraw = mat.fnDraw
	mat.fnDraw = function(d)
		paletteRemap({[0] = 12, [1] = 13, [2] = 14, [3] = 15})
		fnDraw(d)
		paletteRemap({[0] = 0, [1] = 1, [2] = 2, [3] = 3})
	end
	return mat
end


return R.DemoPart:new({
	bdr=function(y, pMetrics)
		local sc=1
		local progress = pMetrics.progress
		if y>84 and y<118 then
			if progress > .35 and progress < .5 then
				sc = .5
			elseif progress > .7 and progress < .85 then
				sc = .5
			end
		end
		rsc = sc
		sc = (.5 + mSin(pMetrics.tics * .1)*.5) * sc
		local r0,g0,b0 = 30*rsc,50*sc,60*sc
		local r1,g1,b1 = 50*rsc,80*sc,90*sc
		local r2,g2,b2 = 120*rsc,120*sc,120*sc
		local r3,g3,b3 = 220*rsc,250*sc,250*sc
		local r4,g4,b4 = 30*rsc,30*sc,255*sc
		local r5,g5,b5 = 250*rsc,250*sc,40*sc
		vbank(0)
		setRGBSpread(1,3, r0,g0,b0, r1,g1,b1)
		setRGBSpread(4,8, r2,g2,b2, r3,g3,b3)
		setRGBSpread(12,15, 50,0,0, 180,0,60)

		vbank(1)
		setRGBSpread(1,3, r0,g0,b0, r1,g1,b1)
		setRGBSpread(4,8, r2,g2,b2, r3,g3,b3)
		setRGB(10, r4,g4,b4)
		setRGB(11, r5,g5,b5)
		setRGBSpread(12,15, 50,0,0, 180,0,60)
	end,
	tic=function(pMetrics)
		if pMetrics.isFirstRun then
			GFX_FACE_RAINS = R.TicMcTile:new(gfxFaceRains, true, 2, 0,0, 64,64)
			GFX_FACE_LOGG = R.TicMcTile:new(gfxFaceLogg, true, 2, 256,0, 64,64)

			ENGINE_BG = R2.Engine:new()
			ENGINE_FG = R2.Engine:new()
			CAMERA = R2.Camera:new(R2.V3:new(0,0,0), R2.Quaternion:newFromEuler(0,0,0))
			SCENE_BG = R2.Scene:new(CAMERA)
			SCENE_FG = R2.Scene:new(CAMERA)

			vbank(1)
			setRGB(9,255,255,255)

			LIGHT = R2.V3:new(0,-1,.5)
			LIGHT:normalize()
			ENGINE_FG:setMaterial("quadTexFace1", faceTextured(0,0,64,64))
			ENGINE_FG:setMaterial("quadTexFace2", faceTextured(64,0,64,64))
			ENGINE_FG:setMaterial("quadTexChest", R2.Material.quadTextured(2,0, 0,64,64,64))

			local palMapFgW = makeLinearPalMap(1, 8)
			local choosePalMapFgIndexW = fnChoosePalMapIndexUnitNegToPos(#palMapFgW)

			local palMapBgW = makeLinearPalMap(1, 6)
			local choosePalMapBgIndexW = fnChoosePalMapIndexUnitNegToPos(#palMapBgW)
			local palMapBgR = makeLinearPalMap(7, 8)
			local choosePalMapBgIndexR = fnChoosePalMapIndexUnitNegToPos(#palMapBgR)

			ENGINE_FG:setMaterial("quadFlatLit", quadShadedLit(LIGHT, palMapFgW, choosePalMapFgIndexW))

			ENGINE_BG:setMaterial("quadFlatLit", quadShadedLit(LIGHT, palMapBgW, choosePalMapBgIndexW))
			ENGINE_BG:setMaterial("warningLight", quadShadedLit(LIGHT, palMapBgR, choosePalMapBgIndexR))
			
			local model = makeModelFigure("regular", .95, 1.05, 1, "quadTexFace1")
			local modelID = ENGINE_FG:addModel(model)
			ACTOR1 = SCENE_FG:newActor(modelID, R2.V3:new(-2,0,0), "miPelvis")
			constrainSkeleton(ACTOR1)

			local model = makeModelFigure("regular", 1.05, 0.95, 1, "quadTexFace2")
			local modelID = ENGINE_FG:addModel(model)
			ACTOR2 = SCENE_FG:newActor(modelID, R2.V3:new(1,0,0), "miPelvis")
			constrainSkeleton(ACTOR2)

			local modelTunnel = makeModelTunnel()
			local modelID = ENGINE_BG:addModel(modelTunnel)
			for i=1,10 do
				ACTOR_TUNNELS[#ACTOR_TUNNELS+1] = SCENE_BG:newActor(modelID, R2.V3:new(0,0,0), "miRoot")
			end
		end

		PROGRESS = PROGRESS + timeSpline:getValue(pMetrics.progress) * 0.001

		local rgbScale = 1
		if pMetrics.progress < .2 then
			rgbScale = pMetrics.progress / .2
		else
			-- fix transition from above?
			rgbScale = mSin(PROGRESS * mPi * 40) * .25 + .75
		end

		local ts=PROGRESS * mPi * 400
		
		local actorX = -2
		local actorY = 4
		local actor1z = 0 -- math.sin(PROGRESS * mPi * 10) * 2 - 12
		local actor2z = 0 -- math.sin(PROGRESS * mPi * 15) * 2 - 8
		runnerPose(ACTOR1, R2.V3:new(actorX -6, actorY, actor1z), ts, .17)
		runnerPose(ACTOR2, R2.V3:new(actorX + 6, actorY, actor2z), ts + 6, .18)
		ACTOR1:setRotation(R2.Quaternion:newFromEuler(0,mPi,0))
		ACTOR2:setRotation(R2.Quaternion:newFromEuler(0,mPi,0))
		actorSplineV = actorSplines:getValue(pMetrics.progress)

		local skeleton = ACTOR1.skeleton
		skeleton:setJointWithRange({"miTorso","jNeck"}, actorSplineV.actor1.x, actorSplineV.actor1.y, 0)
		local skeleton = ACTOR2.skeleton
		skeleton:setJointWithRange({"miTorso","jNeck"},  actorSplineV.actor2.x, actorSplineV.actor2.y, 0)

		vbank(0)
		cls()
		drawFuji(0,64,64,64,10,11,11)
		GFX_FACE_RAINS:draw(0, 0)
		GFX_FACE_LOGG:draw(64, 0)

		vbank(1)
		cls()
		SCENE_FG:render(ENGINE_FG)

		if pMetrics.progress > .35 and pMetrics.progress < .5 then
			TEXT_TICKER1:render(110,84, "left", 9)
			
			if pMetrics.tics % 3 == 0 then
				TEXT_TICKER1:tick()
			end
		elseif pMetrics.progress > .7 and pMetrics.progress < .85 then
			TEXT_TICKER2:render(130,84, "left", 9)
			
			if pMetrics.tics % 3 == 0 then
				TEXT_TICKER2:tick()
			end
		end

		vbank(0)
		cls(0)
		setPaletteScaled("wryb", rgbScale, 40,0,0)

		camSplineValue = camSpline:getValue(pMetrics.progress)
		CAMERA.pos = camSplineValue.pos +
			R2.V3:new(
				0,
				-math.abs(math.sin(PROGRESS * mPi * 10) * 1),
				20 --+ math.sin(PROGRESS * mPi * 12) * 2 -- mMax(0, (pMetrics.progress - .8)/.2) * 100
			)
		CAMERA:setFOV(camSplineValue.fov)
		CAMERA:setRotation(R2.Quaternion:newFromEuler(0, 0, -.2 + pMetrics.progress * .4))

		for i=1,#ACTOR_TUNNELS do
--			local tunnelZ = -(PROGRESS * 700 + i*10)%100
			local tunnelZ = - (PROGRESS * 700 + (i-1)* 10)%100 - 100
			ACTOR_TUNNELS[i]:setPosition(R2.V3:new(0,0,tunnelZ))
		end
		SCENE_BG:render(ENGINE_BG)
	end,
	cleanup=function()
		vbank(0)
		cls()
		vbank(1)
		cls()
	end,
})

end

rift_codevectorfontasteroids=function()
rift_codevector()

local font = {
	A={13,4,2,6,15,9,7},
	B={7,1,3,6,8,7,13,15,12,8},
	C={15,13,1,3},
	D={1,2,6,12,14,13,1},
	E={15,13,1,3,1,7,9},
	F={3,1,7,9,7,13},
	G={8,9,15,13,1,3,6},
	H={15,9,7,1,13,7,9,3},
	I={13,15,14,2,3,1},
	J={3,15,14,10},
	K={13,1,7,3,7,15},
	L={1,13,15},
	M={15,3,5,1,13},
	N={13,1,15,3},
	O={1,3,15,13,1},
	P={13,1,3,9,7},
	Q={3,12,14,13,1,3,0,11,15},
	R={13,1,3,9,7,15},
	S={3,1,7,9,15,13},
	T={14,2,3,1},
	U={1,13,15,3},
	V={3,14,1},
	W={1,13,11,15,3},
	X={15,1,0,3,13},
	Y={3,8,1,8,14},
	Z={1,3,13,15},
	["0"]={13,1,3,13,15,3},
	["1"]={4,2,14,13,15},
	["2"]={15,13,6,3,1,4},
	["3"]={1,3,8,9,15,13},
	["4"]={12,10,2,14},
	["5"]={13,14,12,9,7,1,3},
	["6"]={2,7,13,15,9,7},
	["7"]={14,3,1},
	["8"]={7,1,3,9,7,13,15,9},
	["9"]={14,9,3,1,7,9},
	a={9,7,13,15,6,4},
	b={1,13,15,6,4},
	c={6,4,13,15},
	d={3,15,13,4,6},
	e={15,13,4,6,9,7},
	f={3,2,5,4,6,5,14},
	g={16,18,6,4,13,15},
	h={15,6,4,13,1},
	i={1,1,0,4,13},
	j={13,17,18,6,0,3,3},
	k={15,12,10,13,10,6,10,1},
	l={1,13,14},
	m={13,4,5,14,5,6,15},
	n={15,6,4,13},
	o={4,6,15,13,4},
	p={13,15,6,4,16},
	q={18,6,4,13,15},
	r={13,4,6},
	s={6,4,10,12,15,13},
	t={14,2,5,4,6},
	u={4,13,15,6},
	v={4,10,14,12,6},
	w={4,13,11,15,6},
	x={4,15,0,13,6},
	y={4,13,15,6,18,16},
	z={4,6,13,15},
	["^"]={7,9,15,13,7,0,4,2,6},
	["'"]={1,4},
	["("]={14,10,4,2},
        [")"]={1,5,11,13},
	["/"]={13,3},
	["@"]={15,13,1,3,12,11,5,6},
	["."]={13,13},
	[","]={13,11},
	[":"]={4,4,0,10,10},
	["!"]={13,13,0,10,1},
	["?"]={1,3,9,8,11,0,14,14},
	["&"]={6,12,14,13,7,5,2,1,4,15},
	["*"]={5,11,8,4,12,8,10,6},
	["+"]={9,7,8,5,11},
	["-"]={7,9},
	["="]={4,6,0,12,10},
}

return vecfontConvertToDefs(font)

end

rift_code3d2modelchair=function()
return function(R)

	local function makeMeshTemplateChair(type, sc)
		local verts={{-1,1,-1},{1,1,-1},{1,-1,-1},{-1,-1,-1},{-1,1,1},{1,1,1},{1,-1,1},{-1,-1,1}}
		local quads={{1,2,3,4},{6,5,8,7},{5,1,4,8},{2,6,7,3},{5,6,2,1},{4,3,7,8}}
		local dx,dy,dz=sc,sc,sc
		local tx,ty,tz=0,0,0
	
		if type == "seat" then
			dx,dy,dz=1*dx,.3*dy,1*dz
		elseif type == "back" then
			dx,dy,dz=1*dx,2*dy,.2*dz
			ty=dy/4
		end

		local mesh=R.Mesh:new()
		for _,v in ipairs(verts) do
			mesh:addVertex(nil, R.V3:new((v[1]+tx)*dx, (v[2]+ty)*dy, (v[3]+tz)*dz))
		end
	
		for i,t in ipairs(quads) do
			mesh:addRenderable("quadFlatLit", {v1=t[1],v2=t[2],v3=t[3],v4=t[4]})
		end
		
		if type == "seat" then
			mesh:addVertex("jBack", R.V3:new(0,0,dz))
		end

		return mesh
	end

	local function makeModel(sc)
		local model=R.Model:new()
		sc = sc or 1

		model:addMeshTemplate("mtSeat", makeMeshTemplateChair("seat", sc))
		model:addMeshTemplate("mtBack", makeMeshTemplateChair("back", sc))
		model:addMeshInstance("miSeat",nil,"mtSeat",R.Quaternion:newFromEuler(0,0,0))
		model:addMeshInstance("miBack",{"miSeat","jBack"},"mtBack",R.Quaternion:newFromEuler(0,0,0))

		return model
	end

	return makeModel
end

end

rift_3d2scene=function()
return function(R)
	R=R or {}

	rift_3d2camera()(R)

	local Scene={}

	function Scene:new(camera)	
		local o={
			actors={},
			camera=camera,
--			lights={},
		}
		setmetatable(o,self)
		self.__index=self
		return o
	end

	function Scene:newActor(...)
		local actor=R.Actor:new(...)
		self.actors[#self.actors+1]=actor
		return actor
	end

	function Scene:render(engine)
		local renderlist = {}
		for _, actor in pairs(self.actors) do
			actor:addToRenderlist(engine, self, renderlist)
		end

		-- rough sorting (better just using ttri's zbuffer if possible)
		for _, r in pairs(renderlist) do
			r.distance = r.material.fnDistance(r.data)
		end
		table.sort(renderlist, function(a,b) return a.material.order < b.material.order end)

		for _, r in pairs(renderlist) do
			r.material.fnDraw(r.data)
		end
	end

	function Scene:setCamera(camera)
		self.camera = camera
	end

	R.Scene = Scene
end

end

rift_3d2skeleton=function()
return function(R)
	R=R or {}

	local Skeleton={}

	local mPi = math.pi

	function Skeleton:new()
		local o={
			-- indexed by {meshID} => {jointID}
			joints={},
			jointRanges={},
		}
		setmetatable(o,self)
		self.__index=self
		return o
	end

    function Skeleton:setJoint(jointRef, quaternion)
		local meshID, jointID = jointRef[1], jointRef[2]
		if self.joints[meshID] == nil then
			self.joints[meshID] = {
				[jointID] = quaternion
			}
		else
			self.joints[meshID][jointID] = quaternion
		end
    end
    
    function Skeleton:getJoint(jointRef)
		local meshID, jointID = jointRef[1], jointRef[2]
		if self.joints[meshID] == nil then
			return nil
		end
		return self.joints[meshID][jointID] or nil
    end

	-- NB the ranges get multiplied by PI!
	function Skeleton:setJointRange(jointRef,q1m,q1r,q2m,q2r,q3m,q3r)
		local meshID, jointID = jointRef[1], jointRef[2]
		if self.jointRanges[meshID] == nil then
			self.jointRanges[meshID] = {
				[jointID] = {q1m=q1m*mPi,q1r=q1r*mPi,q2m=q2m*mPi,q2r=q2r*mPi,q3m=q3m*mPi,q3r=q3r*mPi}
			}
		else
			self.jointRanges[meshID][jointID] = {q1m=q1m*mPi,q1r=q1r*mPi,q2m=q2m*mPi,q2r=q2r*mPi,q3m=q3m*mPi,q3r=q3r*mPi}
		end
	end

	function Skeleton:getJointRange(jointRef)
		local meshID, jointID = jointRef[1], jointRef[2]
		if self.jointRanges[meshID] == nil then
			return nil
		end
		return self.jointRanges[meshID][jointID] or nil
    end

	-- NB we do not cap these values to -1 to +1, this is expected of the caller
	function Skeleton:setJointWithRange(jointRef,q1,q2,q3)
		local jointRange = self:getJointRange(jointRef)	-- assume jointRange is not nil and we find one
		self:setJoint(jointRef, R.Quaternion:newFromEuler(
			jointRange.q1m+q1*jointRange.q1r,
			jointRange.q2m+q2*jointRange.q2r,
			jointRange.q3m+q3*jointRange.q3r
		))
	end

	R.Skeleton = Skeleton
end

end

rift_code3d2modelfiguretunnel=function()
return function(R)

	local function makeMeshTemplateTunnel()
        --   =======
        --  /       \
        -- |         |
        --  \       /
        --   =======

        local mesh=R.Mesh:new()

        local x1 = 3
        local x2 = 6
        local x3 = 5
        local y1 = 6
        local y2 = 4
        local y3 = 1
        local y4 = 0
        local sc = 4
 
        local ps = {{x1,y1},{x2,y2},{x2,y3},{x3,y4},{-x3,y4},{-x2,y3},{-x2,y2},{-x1,y1}}
        local firstV1id,firstV2id = nil,nil
        local lastV1id,lastV2id = nil,nil
        for i = 1,#ps do
            local p = ps[i]
            local v1id = mesh:addVertex(nil, R.V3:new(p[1] * sc, p[2] * sc, 2))
            local v2id = mesh:addVertex(nil, R.V3:new(p[1] * sc, p[2] * sc, -2))
            if lastV1id == nil then
                firstV1id = v1id
                firstV2id = v2id
            else -- make plane
                mesh:addRenderable("quadFlatLit", {v1=lastV1id,v2=v1id,v3=v2id,v4=lastV2id})
            end
            lastV1id,lastV2id = v1id,v2id
        end
        mesh:addRenderable("quadFlatLit", {v1=lastV1id,v2=firstV1id,v3=firstV2id,v4=lastV2id})

        local x = sc*(x1+x2)/2
        local y = sc*(y1+y2)/2

        mesh:addVertex("jLight1", R.V3:new(-x,y,0))
        mesh:addVertex("jLight2", R.V3:new(x,y,0))

        return mesh
	end

	local function makeMeshTemplateLight()
        local w,h = 1,1
        local verts={{-w,h,0},{w,h,0},{w,-h,0},{-w,-h,0}}
		local quads={{1,2,3,4}}

		local mesh=R.Mesh:new()
		for _,v in ipairs(verts) do
			mesh:addVertex(nil, R.V3:new(v[1], v[2], v[3]))
		end
        
        mesh:addRenderable("warningLight", {v1=1,v2=2,v3=3,v4=4})
		return mesh
    end

	return
        function()	 
            local model=R.Model:new()

            model:addMeshTemplate("mtTunnel", makeMeshTemplateTunnel())
            model:addMeshInstance("miRoot",nil,"mtTunnel",R.Quaternion:newFromEuler(0,0,0))

            model:addMeshTemplate("mtLight", makeMeshTemplateLight())
            model:addMeshInstance("miLight1",{"miRoot","jLight1"},"mtLight",R.Quaternion:newFromEuler(0,0,0))
            model:addMeshInstance("miLight2",{"miRoot","jLight2"},"mtLight",R.Quaternion:newFromEuler(0,0,0))

            return model
        end
end

end

rift_codepalette=function()
local function setRGB(i,r,g,b)
	local a=16320+i*3
	poke(a,r)
	poke(a+1,g)
	poke(a+2,b)
end


-- ci0 -> ci1 inclusive (and same for r,g,b)
local function setRGBSpread(ci0,ci1, r0,g0,b0, r1,g1,b1)
	local ciSpread = ci1-ci0
	local rSpread,gSpread,bSpread = r1-r0, g1-g0, b1-b0
	for nc=0,ciSpread do
		local factor= nc / ciSpread
		setRGB(ci0+nc, r0+rSpread*factor, g0+gSpread*factor, b0+bSpread*factor)
	end
end

local function setRGBGradient(r, g, b)
	for i=0,15 do
		local a=16320+i*3
		local v=i/15*255
		setRGB(i,r*v)
		setRGB(i,g*v)
		setRGB(i,b*v)
	end
end

local function setPalette(palette)
	if palette == "wrb" then
		setRGBSpread(1,5, 40,40,40, 255,255,255)
		setRGBSpread(6,10, 120,10,10, 255,60,60)
		setRGBSpread(11,15, 10,10,120, 60,60,255)
	else
		setRGBSpread(0,6, 0,0,0, 255,255,255)
		setRGBSpread(7,9, 120,10,10, 255,60,60)
		setRGBSpread(10,12, 120,120,10, 255,255,60)
		setRGBSpread(13,15, 10,10,120, 60,60,255)
	end
end

local function setPaletteScaled(palette, sc, r0,g0,b0)
	local negSc = 1 - sc
	local r0sc,g0sc,b0sc = r0*negSc, g0*negSc, b0*negSc

	if palette == "w" then
		local r1,g1,b1 = 0*sc+r0sc, 0*sc+g0sc,0*sc+b0sc
		setRGB(0, r1,g1,b1)

		local r1,g1,b1 = 15*sc+r0sc, 8*sc+g0sc,20*sc+b0sc
		local r2,g2,b2 = 80*sc+r0sc,100*sc+g0sc,120*sc+b0sc
		setRGBSpread(1,15, r1,g1,b1, r2,g2,b2)
	elseif palette == "wrb" then
		local r1,g1,b1 = 0*sc+r0sc, 0*sc+g0sc,0*sc+b0sc
		setRGB(0, r1,g1,b1)

		local r1,g1,b1 = 40*sc+r0sc, 40*sc+g0sc,40*sc+b0sc
		local r2,g2,b2 = 255*sc+r0sc,255*sc+g0sc,255*sc+b0sc
		setRGBSpread(1,5, r1,g1,b1, r2,g2,b2)

		local r1,g1,b1 = 120*sc+r0sc, 10*sc+g0sc,10*sc+b0sc
		local r2,g2,b2 = 255*sc+r0sc, 60*sc+g0sc,60*sc+b0sc
		setRGBSpread(6,10, r1,g1,b1, r2,g2,b2)

		local r1,g1,b1 = 10*sc+r0sc, 10*sc+g0sc,120*sc+b0sc
		local r2,g2,b2 = 60*sc+r0sc,60*sc+g0sc,255*sc+b0sc
		setRGBSpread(11,15, r1,g1,b1, r2,g2,b2)
	else
		local r1,g1,b1 = 0*sc+r0sc, 0*sc+g0sc,0*sc+b0sc
		setRGB(0, r1,g1,b1)

		local r1,g1,b1 = 20*sc+r0sc, 20*sc+g0sc,20*sc+b0sc
		local r2,g2,b2 = 255*sc+r0sc,255*sc+g0sc,255*sc+b0sc
		setRGBSpread(1,6, r1,g1,b1, r2,g2,b2)

		local r1,g1,b1 = 120*sc+r0sc,10*sc+g0sc,10*sc+b0sc
		local r2,g2,b2 = 255*sc+r0sc,60*sc+g0sc,60*sc+b0sc
		setRGBSpread(7,9, r1,g1,b1, r2,g2,b2)

		local r1,g1,b1 = 120*sc+r0sc,120*sc+g0sc,10*sc+b0sc
		local r2,g2,b2 = 255*sc+r0sc,255*sc+g0sc,60*sc+b0sc
		setRGBSpread(10,12, r1,g1,b1, r2,g2,b2)

		local r1,g1,b1 = 10*sc+r0sc,10*sc+g0sc,120*sc+b0sc
		local r2,g2,b2 = 60*sc+r0sc,60*sc+g0sc,255*sc+b0sc
		setRGBSpread(13,15, r1,g1,b1, r2,g2,b2)
	end
end

local function setPaletteAsteroids()
	setRGB(0,30,50,40)
	setRGBSpread(1,15, 25,35,30, 255,255,255)
end

local function hslToRgb(h, s, l)
	local r, g, b
	
	if s == 0 then
		r, g, b = l, l, l -- achromatic
	else
		function hue2rgb(p, q, t)
			if t < 0   then t = t + 1 end
			if t > 1   then t = t - 1 end
			if t < 1/6 then return p + (q - p) * 6 * t end
			if t < 1/2 then return q end
			if t < 2/3 then return p + (q - p) * (2/3 - t) * 6 end
			return p
		end
	
		local q
		if l < 0.5 then
			q = l * (1 + s)
		else
			q = l + s - l * s
		end
		local p = 2 * l - q
		
		r = hue2rgb(p, q, h + 1/3)
		g = hue2rgb(p, q, h)
		b = hue2rgb(p, q, h - 1/3)
	end
	
	return r * 255, g * 255, b * 255
end
	

return function(R)
    return setRGB, setPalette, setPaletteScaled, setPaletteAsteroids, hslToRgb
end

end

rift_code3d=function()
local mSin,mCos=math.sin,math.cos


function rotatex(p,angle)
	local cosa,sina=mCos(angle),mSin(angle)
	return {x=p.x, y=p.y*cosa-p.z*sina, z=p.y*sina+p.z*cosa}
end

function rotatey(p,angle)
	local cosa,sina=mCos(angle),mSin(angle)
	return {x=p.x*cosa-p.z*sina, y=p.y, z=p.x*sina+p.z*cosa}
end

function rotatez(p,angle)
	local cosa,sina=mCos(angle),mSin(angle)
	return {x=p.x*cosa-p.y*sina, y=p.x*sina+p.y*cosa, z=p.z}
end


function transformPoints(ps, mX,mY,mZ, rotX,rotY,rotZ)
	for i,p in ipairs(ps) do
		--if x%2==0 then pv=x+math.pi end
		p=rotatex(p, rotX)
		p=rotatey(p, rotY)
		p=rotatez(p, rotZ)
		p.x=p.x+mX
		p.y=p.y+mY
		p.z=p.z+mZ
		p.x=p.x/p.z*2
		p.y=p.y/p.z*2
		p.z=p.z+400
		ps[i]=p
	end
end

function projectPoints(ps)
	for i,p in ipairs(ps) do
		if p.z>0.1 then
			p.x=120+20000*p.x/p.z
			p.y=68+20000*p.y/p.z
		end
		ps[i]=p
	end
end

end

rift_code3d2modelcabinet=function()
--[[ other side = +11
1       2


11          
	 10      23
				  3



		 9  24
8

7   6


^
+
y	5             4
-
v
<-  +1 z -1  ->
(23 and 24 are screen)
]]--

return function(R)
	local function makeMeshTemplateCabinet()
		local scx,scy,scz=6,15,6
		local sideVerts={
			{1,1}, {1,.3}, {.4,-1}, {-1,-1},    -- 1-4
			{-1,.7}, {-.25,.7}, {-.2,1}, {0,1}, -- 5-8
			{.1,.2}, {.6,.5}, {.7,.9}, -- 9-11
		}

		local tris={
			{1,2,11}, {2,10,11}, {2,3,10}, {3,9,10}, {3,4,9}, {4,6,9}, {4,5,6}, {6,7,8}, {6,8,9},
		}
		local quadPairs={
			{1,2}, {2,3}, {3,4}, {4,5}, {5,6}, {6,7}, {7,8}, {8,9}, {10,11},
		}

		local mesh=R.Mesh:new()
		for _,v in ipairs(sideVerts) do
			mesh:addVertex(nil, R.V3:new(1*scx, v[1]*scy, v[2]*scz))
		end
		for _,v in ipairs(sideVerts) do
			mesh:addVertex(nil, R.V3:new(-1*scx, v[1]*scy, v[2]*scz))
		end
		-- screen: 23,24,25,26
		-- (fake 240x128 screen)... width=1.6
		local sch = .35
		mesh:addVertex(nil, R.V3:new(.8*scx, (.1 + sch) * scy, -.1*scz))
		mesh:addVertex(nil, R.V3:new(.8*scx, .1*scy, .1*scz))
		mesh:addVertex(nil, R.V3:new(-.8*scx, (.1 + sch) * scy, -.1*scz))
		mesh:addVertex(nil, R.V3:new(-.8*scx, .1*scy, .1*scz))
	
		for i,t in ipairs(tris) do
			local v1, v2, v3 = sideVerts[t[1]], sideVerts[t[2]], sideVerts[t[3]]
			local t1 = {x = 1-(v1[2]/2 + .5), y = 1-(v1[1] / 2 + .5)}
			local t2 = {x = 1-(v2[2]/2 + .5), y = 1-(v2[1] / 2 + .5)}
			local t3 = {x = 1-(v3[2]/2 + .5), y = 1-(v3[1] / 2 + .5)}
			mesh:addRenderable("triSideart", {v1=t[1],v2=t[2],v3=t[3],t1=t1,t2=t2,t3=t3})

			t1.x = 1 - t1.x
			t2.x = 1 - t2.x
			t3.x = 1 - t3.x
			mesh:addRenderable("triSideart", {v1=t[1]+11,v2=t[2]+11,v3=t[3]+11,t1=t1,t2=t2,t3=t3})
		end
		
		for i,t in ipairs(quadPairs) do
			if t[1] == 8 then
				mesh:addRenderable("quadControlPanel", {v1=t[2]+11,v2=t[1]+11,v3=t[1],v4=t[2]})
			else
				mesh:addRenderable("quadFlat", {v1=t[1],v2=t[2],v3=t[2]+11,v4=t[1]+11})
			end
		end
		mesh:addRenderable("quadMarquee", {v4=1,v1=1+11,v2=11+11,v3=11})

		mesh:addRenderable("quadScreen", {v1=23,v2=25,v3=26,v4=24})
		mesh:addRenderable("quadScreen", {v1=23,v2=25,v3=26,v4=24}, "screen")

		return mesh
	end

	local function makeModel()
		local model=R.Model:new()

		model:addMeshTemplate("mtCabinet", makeMeshTemplateCabinet())
		model:addMeshInstance("miRoot",nil,"mtCabinet",R.Quaternion:newFromEuler(0,0,0))

		return model
	end

	return makeModel
end

end

rift_partscontrolroomend=function()
local ENGINE, CAMERA, LIGHT, SCENE
local ACTORS = {}
local ACTORS_SCREENS = {}
local ACTORS_CHAIRS = {}
local SCREENS = {}
local CUBE1 = nil

local R2 = {}	-- hack!

rift_demopart()(R)
rift_syssys()(R)
rift_3d2engine()(R2)
rift_3d2scene()(R2)
rift_3d2model()(R2)
rift_3d2mesh()(R2)
rift_3d2actor()(R2)
rift_3d2material()(R2)
rift_3d2skeleton()(R2)
rift_3d2v3()(R2)
rift_3d2m44()(R2)
rift_3d2quaternion()(R2)
rift_syscatmullrom()(R)
rift_3d2quaternion()(R2)

local setRGB, setPalette = rift_codepalette()(R)
local drawSun = rift_codedrawsun()
local controlRoomLayout, setTeleportIn = rift_codecontrolroomlayout()(R2)
local quadShadedLit, triShadedLit, makeLinearPalMap, fnChoosePalMapIndexUnitNegToPos, fnChoosePalMapIndexUnitFacing = rift_codematerialflatlitpalettemap()(R2)

local CONTROL_ROOM

local mPi = math.pi
local mSin, mCos = math.sin, math.cos

local function poseSit(actor, ts)
	local skeleton = actor.skeleton
	skeleton:setJointWithRange({"miPelvis","jLeftHip"}, 1,-.4,0)
	skeleton:setJointWithRange({"miPelvis","jRightHip"}, 1,-.4,0)
	skeleton:setJointWithRange({"miRightLegHigh","jKnee"}, 0,0,1)
	skeleton:setJointWithRange({"miLeftLegHigh","jKnee"}, 0,0,1)
	skeleton:setJointWithRange({"miTorso","jNeck"}, mSin(ts*10)*.4-.7, mSin(ts*5), mSin(ts*7))
	skeleton:setJointWithRange({"miTorso","jRightShoulder"}, 1,0,-.4)
	skeleton:setJointWithRange({"miTorso","jLeftShoulder"}, 1,0,-.4)
	skeleton:setJointWithRange({"miLeftArmHigh","jElbow"}, 0,.5,0)
	skeleton:setJointWithRange({"miRightArmHigh","jElbow"}, 0,.5,0)
end

local function drawExplosion(x,y,dimX,dimY,s)
	local dimXh, dimYh = dimX/2, dimY/2
	circ(x+dimXh,y+dimYh,dimX*.8*s,13)
	circ(x+dimXh,y+dimYh,dimX*.75*s,7)
	circ(x+dimXh,y+dimYh,dimX*.6*s,9)
	circ(x+dimXh,y+dimYh,dimX*.4*s,12)
	local maxD = dimX*s
	for iArm=1,6 do
		local aArm = iArm^5
		for d=0,maxD,4 do
			local r = 2
			local a = aArm + mSin(d*.1*iArm*.2)*.1
			local pX,pY=dimXh+mSin(a)*d, dimYh+mCos(a)*d
			circ(pX+2,pY+2, r, 3)
			circ(pX,pY, r, 6)
		end
	end
end

local camSpline = R.CatmullRomSpline:new()
camSpline:setValueInterpolater(
	function(t, v0, v1, v2, v3)
		return {
			pos = R2.V3:new(
				R.catmullRom(t, v0.pos.x, v1.pos.x, v2.pos.x, v3.pos.x),
				R.catmullRom(t, v0.pos.y, v1.pos.y, v2.pos.y, v3.pos.y),
				R.catmullRom(t, v0.pos.z, v1.pos.z, v2.pos.z, v3.pos.z)
			),
			fov = R.catmullRom(t, v0.fov, v1.fov, v2.fov, v3.fov),
			rot = R2.Quaternion:newFromEuler(
				R.catmullRom(t, v0.rot.x, v1.rot.x, v2.rot.x, v3.rot.x),
				R.catmullRom(t, v0.rot.y, v1.rot.y, v2.rot.y, v3.rot.y),
				R.catmullRom(t, v0.rot.z, v1.rot.z, v2.rot.z, v3.rot.z)
			),
		}
	end
)
camSpline:addValue(0, {pos=R2.V3:new(0,0,4), fov=60, rot={x=0,y=0,z=0}})
camSpline:addValue(.2, {pos=R2.V3:new(0,0,2), fov=60, rot={x=-.2,y=-.1,z=0}})
camSpline:addValue(.5, {pos=R2.V3:new(-1.5,0,2), fov=60, rot={x=0,y=.5,z=0}})
camSpline:addValue(1, {pos=R2.V3:new(0,0,2), fov=60, rot={x=0,y=0,z=0}})

local scrTexX, scrTexY, scrTexW, scrTexH = 0,0,120,120*2/3
local CONTROL_ROOM

return R.DemoPart:new({
	tic=function(pMetrics)
		if pMetrics.isFirstRun then
			vbank(0)
			setPalette("wrb")

			vbank(1)
			setPalette()

			CONTROL_ROOM = controlRoomLayout(scrTexX,scrTexY,scrTexW,scrTexH)
		end

		local progress = pMetrics.progress
	
		for i,actor in ipairs(CONTROL_ROOM.actors) do
			poseSit(actor, progress, i*.2)
--			local pos = actor:getPosition()
--			pos = R2.V3:new(pos.x * progress*10, pos.y, pos.z)
--			actor:setPosition(pos)
			local skewX = (((i+7)^5.2)%100-0)/100
			local skewY = ((i+4)^4.4)%100/100
			local skewZ = (((i+11)^7.9)%100-50)/100
			local rotM = 2
			local rotX,rotY,rotZ = rotM * skewX * progress, rotM * skewY * progress, rotM * skewZ * progress
			local pos = actor:setRotation(R2.Quaternion:newFromEuler(rotX,rotY,rotZ))
		end
		
		vbank(0)
--		if progress < 5 then
--			local vs={}
--			for i=0,5 do
--			end
--		else
			drawExplosion(scrTexX,scrTexY, scrTexW,scrTexH, progress)
--		end

		CONTROL_ROOM.light:set(0, mSin(progress * 8), 1)
        CONTROL_ROOM.light:normalize()

		vbank(1)
		cls()
		camSplineValue = camSpline:getValue(progress)
		CONTROL_ROOM.camera:setPosition(camSplineValue.pos)
		CONTROL_ROOM.camera:setFOV(camSplineValue.fov)
		CONTROL_ROOM.camera:setRotation(camSplineValue.rot)
		CONTROL_ROOM.sceneFG:render(CONTROL_ROOM.engineFG)

		vbank(0)
		cls()
		drawSun(160,50,35,5,0)
		CONTROL_ROOM.sceneBG:render(CONTROL_ROOM.engineBG)
	end,
	cleanup=function()
		vbank(0)
		cls()
	end,
})

end

rift_3d2mesh=function()
return function(R)
	R=R or {}

	local Mesh={}

	function Mesh:new()	
		local o={
			vertices={},     -- {x,y,z} and optionally normals?
			renderables={default={}},
		}
		setmetatable(o,self)
		self.__index=self
		return o
	end

	function Mesh:__tostring()
		-- NB This is wrong, since keyed vertices etc will not be counted
		return string.format("MESH(verts=%d,tris=%d,spheres=%d)",#self.vertices,#self.triangles,#self.spheres)
	end

	-- returns an ID for the vertex
	function Mesh:addVertex(id, v)
		id = (id == nil and #self.vertices+1) or id
		self.vertices[id]=v
		return id
	end

	function Mesh:vertex(id)
		return self.vertices[id]
	end

	-- Send in a materialID and the data it needs to render...
	function Mesh:addRenderable(materialID, data, skinID)
		skinID = skinID or "default"
		if self.renderables[skinID] == nil then
			self.renderables[skinID]={}
		end
		self.renderables[skinID][#self.renderables[skinID]+1]={materialID=materialID,data=data}
	end

	function Mesh:addToRenderlist(engine, scene, position, quaternion, skinIDs, actorData, renderlist)
		local psView={}
		local psWorld={}
		local mat = scene.camera:getMatWorldToView()

		for i,vertex in pairs(self.vertices) do
			local pWorld = position + R.Quaternion.rotateV3(quaternion, vertex)
			psWorld[i] = pWorld
			psView[i] = engine:transformForViewport(
				R.M44.multiplyVec3(
					mat,
					pWorld
				)
			)
		end

		-- We can specify that multiple skins get rendered
		for _, skinID in ipairs(skinIDs) do
			local skin = self.renderables[skinID]

			-- For each skin, we iterate through the renderables
			if skin ~= nil then
				for _,renderable in pairs(skin) do
					local material = engine:material(renderable.materialID)
					if material == nil then
						trace("Material not found: " .. renderable.materialID)
						exit()
					end
					renderlist[#renderlist+1]={
						material = material,
						data = material.fnTransform(renderable.data, psView, psWorld, actorData),
					}
				end
			end
		end
	end

	R.Mesh = Mesh
end

end

rift_codematerialflatlitpalettemap=function()
return function(R2)
	local mMin, mMax = math.min, math.max

	function makeLinearPalMap(ciLow, ciHigh)
		local palMap = {}
		palMap[#palMap+1]={ciLow,ciLow,ciLow,ciLow}
		for c=ciLow,ciHigh-1 do
			palMap[#palMap+1]={c,c+1,c,c}
			palMap[#palMap+1]={c+1,c,c,c+1}
			palMap[#palMap+1]={c+1,c+1,c+1,c}
			palMap[#palMap+1]={c+1,c+1,c+1,c+1}
		end
		return palMap
	end

	function fnChoosePalMapIndexUnitNegToPos(sizePalMap)
		local pmMid = (sizePalMap-.5)/2
		return function(angle)
			return 1+(pmMid+pmMid*angle)//1
		end
	end

	function fnChoosePalMapIndexUnitFacing(sizePalMap)
		return function(angle)
			if angle < 0 then	-- facing away from the camera
				return 0
			end
			return 1+((sizePalMap-1)*angle)//1
		end
	end

	-- Assumes the quad is a plane!
	-- function generator...
	-- we can change lightVec after it has been sent in here (ensure it is normalised)
	-- Ensure you reset palette map aft
	local function quadShadedLit(lightVec, palMap, choosePalMapIndex)
		return R2.Material:new():setFnTransform(function(d, psView, psWorld)
			return {
				v1 = psView[d.v1], v2=psView[d.v2], v3=psView[d.v3], v4=psView[d.v4],
				normal = R2.V3.normal(psWorld[d.v1], psWorld[d.v2], psWorld[d.v3]) -- tri (assuming a planar quad!)
			}
		end):setFnDistance(function(d)
			return (d.v1.z+d.v2.z+d.v3.z+d.v4.z)/4
		end):setFnDraw(function(d)
			local angle = R2.V3.dot(d.normal, lightVec)
			local palMapIndex = choosePalMapIndex(angle)
			if palMapIndex < 1 then
				return
			end
			local palMapRender = palMap[palMapIndex]

			local xdiff = mMax(d.v1.x, d.v2.x, d.v3.x, d.v4.x) - mMin(d.v1.x, d.v2.x, d.v3.x, d.v4.x)
			local ydiff = mMax(d.v1.y, d.v2.y, d.v3.y, d.v4.y) - mMin(d.v1.y, d.v2.y, d.v3.y, d.v4.y)

			local sx0, sx1 = 0, mMax(8, mMin(xdiff,127))
			local sy0, sy1 = 0, mMax(8, mMin(ydiff,127))

			local a = 0x3ff0*2
			poke4(a,palMapRender[1])
			poke4(a+1,palMapRender[2])
			poke4(a+2,palMapRender[3])
			poke4(a+3,palMapRender[4])
			ttri(
				d.v1.x,d.v1.y,d.v2.x,d.v2.y,d.v3.x,d.v3.y,
				sx0,sy0,sx1,sy0,sx1,sy1,
				1,
				-1,
				d.v1.z,d.v2.z,d.v3.z
			)
			ttri(
				d.v3.x,d.v3.y,d.v4.x,d.v4.y,d.v1.x,d.v1.y,
				sx1,sy1,sx0,sy1,sx0,sy0,
				1,
				-1,
				d.v3.z,d.v4.z,d.v1.z
			)
			-- optimise this by only doing it when we need to!
			poke4(a,0)
			poke4(a+1,1)
			poke4(a+2,2)
			poke4(a+3,3)
		end)
	end

	-- function generator...
	-- we can change lightVec after it has been sent in here (ensure it is normalised)
	-- Ensure you reset palette map after
	local function triShadedLit(lightVec, palMap, choosePalMapIndex)
		return R2.Material:new():setFnTransform(function(d, psView, psWorld)
			return {
				v1 = psView[d.v1], v2=psView[d.v2], v3=psView[d.v3],
				normal = R2.V3.normal(psWorld[d.v1], psWorld[d.v2], psWorld[d.v3]),
			}
		end):setFnDistance(function(d)
			return (d.v1.z+d.v2.z+d.v3.z)/4
		end):setFnDraw(function(d)
			local angle = R2.V3.dot(d.normal, lightVec)
			local palMapIndex = choosePalMapIndex(angle)
			if palMapIndex < 1 then
				return
			end
			local palMapRender = palMap[palMapIndex]

			local xdiff = mMax(d.v1.x, d.v2.x, d.v3.x) - mMin(d.v1.x, d.v2.x, d.v3.x)
			local ydiff = mMax(d.v1.y, d.v2.y, d.v3.y) - mMin(d.v1.y, d.v2.y, d.v3.y)

			local sx0, sx1 = 0, mMax(8, mMin(xdiff,127))
			local sy0, sy1 = 0, mMax(8, mMin(ydiff,127))

			local a = 0x3ff0*2
			poke4(a,palMapRender[1])
			poke4(a+1,palMapRender[2])
			poke4(a+2,palMapRender[3])
			poke4(a+3,palMapRender[4])
			ttri(
				d.v1.x,d.v1.y,d.v2.x,d.v2.y,d.v3.x,d.v3.y,
				sx0,sy0,sx1,sy0,sx1,sy1,
				1,
				-1,
				d.v1.z,d.v2.z,d.v3.z
			)
			-- optimise this by only doing it when we need to!
			poke4(a,0)
			poke4(a+1,1)
			poke4(a+2,2)
			poke4(a+3,3)
		end)
	end

	-- Assumes the quad is a plane!
	-- function generator...
	-- we can change lightVec after it has been sent in here (ensure it is normalised)
	-- Ensure you reset palette map aft
	local function quadTunnelLight(palMap, choosePalMapIndex)
		choosePalMapIndex = function(d, palMapSize)
			return 1 + ((d.l + d.actorData.colofs)% palMapSize)
		end

		return R2.Material:new():setFnTransform(function(d, psView, psWorld, actorData)
			return {
				v1 = psView[d.v1], v2=psView[d.v2], v3=psView[d.v3], v4=psView[d.v4],
				l = d.l,
				actorData = actorData,
			}
		end):setFnDistance(function(d)
			return (d.v1.z+d.v2.z+d.v3.z+d.v4.z)/4
		end):setFnDraw(function(d)
			local palMapIndex = choosePalMapIndex(d, #palMap)
			local palMapRender = palMap[palMapIndex]
			local xdiff = mMax(d.v1.x, d.v2.x, d.v3.x, d.v4.x) - mMin(d.v1.x, d.v2.x, d.v3.x, d.v4.x)
			local ydiff = mMax(d.v1.y, d.v2.y, d.v3.y, d.v4.y) - mMin(d.v1.y, d.v2.y, d.v3.y, d.v4.y)

			local sx0, sx1 = 0, mMax(8, mMin(xdiff,127))
			local sy0, sy1 = 0, mMax(8, mMin(ydiff,127))

			local a = 0x3ff0*2
			poke4(a,palMapRender[1])
			poke4(a+1,palMapRender[2])
			poke4(a+2,palMapRender[3])
			poke4(a+3,palMapRender[4])
			ttri(
				d.v1.x,d.v1.y,d.v2.x,d.v2.y,d.v3.x,d.v3.y,
				sx0,sy0,sx1,sy0,sx1,sy1,
				1,
				-1,
				d.v1.z,d.v2.z,d.v3.z
			)
			ttri(
				d.v3.x,d.v3.y,d.v4.x,d.v4.y,d.v1.x,d.v1.y,
				sx1,sy1,sx0,sy1,sx0,sy0,
				1,
				-1,
				d.v3.z,d.v4.z,d.v1.z
			)
			-- optimise this by only doing it when we need to!
			poke4(a,0)
			poke4(a+1,1)
			poke4(a+2,2)
			poke4(a+3,3)
		end)
	end

	-- function generator...
	local function triTunnelLight(palMap, choosePalMapIndex)
		choosePalMapIndex = function(d, palMapSize)
			return 1 + ((d.l + d.actorData.colofs)% palMapSize)
		end

		return R2.Material:new():setFnTransform(function(d, psView, psWorld, actorData)
			return {
				v1 = psView[d.v1], v2=psView[d.v2], v3=psView[d.v3],
				l = d.l,
				actorData = actorData,
			}
		end):setFnDistance(function(d)
			return (d.v1.z+d.v2.z+d.v3.z)/3
		end):setFnDraw(function(d)
			local palMapIndex = choosePalMapIndex(d, #palMap)
			local palMapRender = palMap[palMapIndex]
			local xdiff = mMax(d.v1.x, d.v2.x, d.v3.x) - mMin(d.v1.x, d.v2.x, d.v3.x)
			local ydiff = mMax(d.v1.y, d.v2.y, d.v3.y) - mMin(d.v1.y, d.v2.y, d.v3.y)

			local sx0, sx1 = 0, mMax(8, mMin(xdiff,127))
			local sy0, sy1 = 0, mMax(8, mMin(ydiff,127))

			local a = 0x3ff0*2
			poke4(a,palMapRender[1])
			poke4(a+1,palMapRender[2])
			poke4(a+2,palMapRender[3])
			poke4(a+3,palMapRender[4])
			ttri(
				d.v1.x,d.v1.y,d.v2.x,d.v2.y,d.v3.x,d.v3.y,
				sx0,sy0,sx1,sy0,sx1,sy1,
				1,
				-1,
				d.v1.z,d.v2.z,d.v3.z
			)
			-- optimise this by only doing it when we need to!
			poke4(a,0)
			poke4(a+1,1)
			poke4(a+2,2)
			poke4(a+3,3)
		end)
	end

	return quadShadedLit, triShadedLit,
		makeLinearPalMap,
		fnChoosePalMapIndexUnitNegToPos, fnChoosePalMapIndexUnitFacing,
		quadTunnelLight, triTunnelLight
end

end

rift_codedrawingpixplane=function()
local mAbs=math.abs
local mSin,mCos,mPi=math.sin,math.cos,math.pi
local FN_CLIP=function(x,y) return x>=0 and x<=255 and y>=0 and y<=127 end
local CAM={x=0,y=0,z=0}

function ppGetDefaultDots()
	return {
		{0,0,3},
		{-1,0,1},
		{1,0,1},
		{0,-1,1},
		{0,1,1},
	}
end

function ppGetDefaultFnMelt()
	return makeFnAcrossPixplanes("pp1[srcA]=pp1[srcA]*.2")
end

function ppDefaultPixplanesMelt(fnDecay, pixplanes, tics)
    local decays = {{1,1},{0,2},{2,0},{2,1},{1,2},{0,1},{1,0},{2,2},{0,0}}
    local decay = decays[tics%9+1]
    fnDecay(pixplanes, 3, 3, decay[1], decay[2])
end

function setCam(x,y,z)
	CAM={x=x,y=y,z=z}
end

function doBlur(tics)
    -- JTRUK: I don't think this is as it was
    local t=tics*.25
    for i=t%2,32640,1.9 do poke4(i,i/4e8+t%1) end
end

function ppSetClipFn(fn)
	FN_CLIP=fn
end

function ppClearClip()
	FN_CLIP=function(x,y) return x>=0 and x<=255 and y>=0 and y<=127 end
end

-- dots {{x,y,i}, {...}...}
function ppDrawLine(pp, x, y, x2, y2, dots)
	local w=x2-x
	local h=y2-y
	local dx1,dy1,dx2,dy2=0,0,0,0
	if (w<0) then dx1=-1 elseif (w>0) then dx1=1 end
	if (h<0) then dy1=-1 elseif (h>0) then dy1=1 end
	if (w<0) then dx2=-1 elseif (w>0) then dx2=1 end
	local longest=mAbs(w)
	local shortest=mAbs(h)
	if longest<shortest then
		longest=mAbs(h)
		shortest=mAbs(w)
		if h<0 then dy2=-1 elseif h>0 then dy2=1 end
		dx2=0
	end
	local numerator=longest/2

	for i=0,longest do
		if FN_CLIP(x,y) then
            for _,dot in ipairs(dots) do
                local i=((x+dot[1])//1+(y+dot[2])//1*256)&0x7fff
                pp[i]=pp[i]+dot[3]
            end
		end
		numerator=numerator+shortest
		if numerator>longest then
			numerator=numerator-longest
			x=x+dx1
			y=y+dy1
		else
			x=x+dx2
			y=y+dy2
		end
	end
end

function ppDrawSpaceship(pp, x,y,z, rotX,rotY,rotZ, dots)
	local points={
		{x=-.5,y=0,z=0},
		{x=.35,y=0,z=0},
		{x=.5,y=0,z=.4},
		{x=.5,y=mSin(mPi*2/3)*.4,z=mCos(mPi*2/3)*.4},
		{x=.5,y=mSin(mPi*4/3)*.4,z=mCos(mPi*4/3)*.4},
	}
	local lines={
		{1,3},
		{1,4},
		{1,5},
		{2,3},
		{2,4},
		{2,5},
		{3,4},
		{4,5},
		{5,3},
	}
	
	transformPoints(points, x-CAM.x,y-CAM.y,z-CAM.z, rotX,rotY,rotZ)
	projectPoints(points)
	for i,l in ipairs(lines) do
		ppDrawLine(pp, points[l[1]].x,points[l[1]].y,points[l[2]].x,points[l[2]].y, dots)
	end
end

function drawTower(x,y,z, rotX,rotY,rotZ, c)
	local points={
		{x=-.2,y=-.5,z=-.2},
		{x=.2,y=-.5,z=-.2},
		{x=-.2,y=.5,z=-.2},
		{x=.2,y=.5,z=-.2},
		{x=-.2,y=-.5,z=.2},
		{x=.2,y=-.5,z=.2},
		{x=-.2,y=.5,z=.2},
		{x=.2,y=.5,z=.2},
	}
	local lines={
		{1,2},{2,3},{3,4},{4,1},
		{5,6},{6,7},{7,8},{8,5},
	}
	
	transformPoints(points, x-CAM.x,y-CAM.y,z-CAM.z, rotX,rotY,rotZ)
	projectPoints(points)
	for i,l in ipairs(lines) do
		drawline(points[l[1]].x,points[l[1]].y,points[l[2]].x,points[l[2]].y, c,1)
	end
end

end

rift_codegameasteroid=function()
local mSin, mCos = math.sin, math.cos

GameAsteroid={}
function GameAsteroid:new(x,y,dr,size)
	local o={
		x=x,
		y=y,
		dr=dr,
		vr=0,   -- visual rotation
		size=size,  -- 1 to 3
	}
	setmetatable(o,self)
	self.__index=self
	return o
end

function GameAsteroid:move()
	local speed = 1
	self.x = (self.x + mCos(self.dr) * speed)%240
	self.y = (self.y + mSin(self.dr) * speed)%128
	self.vr = self.vr + .1
end

end

rift_codetiledefs=function()
local function makeHalfWidth(x,y,c)
	return {t='hw', x=x, y=y, c=c}
end

local function makeLarge(x,y,c)
	return {t='l', x=x, y=y, c=c}
end

local function makeHalf(x,y,c)
	return {t='h', x=x, y=y, c=c}
end

local function makeThin(x,y,c)
	return {t='th', x=x, y=y, c=c}
end

local function makeHalfHeight(x,y,c)
	return {t='hh', x=x, y=y, c=c}
end

local gapW = .1
local gapHW = gapW/2

local function tileDefs(sc)
	local defs = {}

	local rowTop = -(gapHW + .5)
	local rowBottom = gapHW + .5
	local rowTopH = rowTop - .275
	local rowTopL = rowTop + .275
	local rowBottomH = rowBottom - .275
	local rowBottomL = rowBottom + .275

	defs[#defs+1] = makeHalfWidth(0, rowTop, 'b')
	defs[#defs+1] = makeLarge(-.75 - gapW, rowTop, 'w')
	defs[#defs+1] = makeLarge(.75 + gapW, rowTop, 'r')
	defs[#defs+1] = makeLarge(-1.75 - gapW*2, rowTop, 'r')
	defs[#defs+1] = makeLarge(1.75 + gapW*2, rowTop, 'w')
	defs[#defs+1] = makeHalfHeight(-2.7, rowTopH, 'w')
	defs[#defs+1] = makeHalfHeight(-2.7, rowTopL, 'b')
	defs[#defs+1] = makeHalfHeight(2.7, rowTopH, 'w')
	defs[#defs+1] = makeHalfHeight(2.7, rowTopL, 'r')

	defs[#defs+1] = makeHalf(0, rowBottomH, 'r')
	defs[#defs+1] = makeHalf(0, rowBottomL, 'b')
	defs[#defs+1] = makeLarge(-.75 - gapW, rowBottom, 'b')
	defs[#defs+1] = makeLarge(.75 + gapW, rowBottom, 'b')

	for i,c in ipairs({
		{'r','b','r','w'},
		{'b','','w',''},
		{'w','r','','b'},
		{'r','','b',''},
		{'b','w','r','w'},
		{'','b','','r'},
		{'w','r','w','b'},
	}) do
		local x1 = -1.53 - (i-1)*.2145
		local x2 = -x1
		if c[1] then
			defs[#defs+1] = makeThin(x1, rowBottomH, c[1])
		end

		if c[2] then
			defs[#defs+1] = makeThin(x1, rowBottomL, c[2])
		end

		if c[3] then
			defs[#defs+1] = makeThin(x2, rowBottomH, c[3])
		end

		if c[4] then
			defs[#defs+1] = makeThin(x2, rowBottomL, c[4])
		end
	end

	return defs
	--[[
	-- tiles = {"l" (large), "hw" (halfwidth), "h" (half), "th" (thin), "hh" (halfheight, 2/5 width)}
	local dOne = sc
	local dGap = sc * .1
	local y1, y2, y3 = -(dOne * .75 + dGap/2), -(dOne * .5 + dGap/2), -(dOne * .25 + dGap/2)  -- top rows
	local y4, y5, y6 = -y3, -y2, -y1 -- bottom rows
	return {
		---- top
		-- centre
		{c="b",t="hw",x=0,y=y2},

		-- left
		{c="w",t="l",x=-dOne*.75-dGap,y=y2},
		{c="r",t="l",x=-dOne*1.75-dGap*2,y=y2},
		{c="w",t="hh",x=-dOne*2.5-dGap*3,y=y1},
		{c="b",t="hh",x=-dOne*2.5-dGap*3,y=y3},

		-- right
		{c="r",t="l",x=dOne*.75+dGap,y=y2},
		{c="b",t="l",x=dOne*1.75+dGap*2,y=y2},
		{c="w",t="hh",x=dOne*2.5+dGap*3,y=y1},
		{c="r",t="hh",x=dOne*2.5+dGap*3,y=y3},

		---- bottom
		-- centre
		{c="r",t="h",x=0,y=y4},
		{c="b",t="h",x=0,y=y6},

		-- left
		{c="b",t="l",x=-dOne*.75-dGap,y=y5},

		{c="r",t="th",x=-dOne*1.25-dGap*2,y=y4},
		{c="b",t="th",x=-dOne*1.5-dGap*3,y=y4},

		{c="b",t="th",x=-dOne*1.25-dGap*2,y=y6},
		{c="r",t="th",x=-dOne*1.75-dGap*3,y=y6},

		-- right
		{c="b",t="l",x=dOne*.75+dGap,y=y5},

		--[[
		{x=0,y=-.5,t="lh",c="b"},
		{x=-.75,y=-.5,t="l",c="w"},
		{x=.75,y=-.5,t="l",c="r"},
		{x=-1.75,y=-.5,t="l",c="r"},
		{x=1.75,y=-.5,t="l",c="b"},
		{x=-2.5,y=-.75,t="s",c="w"},
		{x=-2.5,y=-.25,t="s",c="b"},
		{x=2.5,y=-.75,t="s",c="w"},
		{x=2.5,y=-.25,t="s",c="r"},
		{x=0,y=.25,t="s",c="r"},
		{x=0,y=.75,t="s",c="b"},
		{x=-.75,y=.5,t="l",c="b"},
		{x=.75,y=.5,t="l",c="b"},
		
		-- missing some sh - seems they're 1/5 not 1/4!
		{x=-2.5,y=.25,t="sh",c="w"},
		{x=-2.25,y=.25,t="sh",c="b"},
		{x=-2,y=.25,t="sh",c="r"},
		{x=-1.5,y=.25,t="sh",c="w"},
		{x=-1.25,y=.25,t="sh",c="b"},
		{x=-2.5,y=0.25,t="sh",c="r"},
		--[[
		{x=-2.25,y=0.5,t="sh",c="b"},
		{x=-2,y=0.5,t="sh",c="w"},
		{x=-1.5,y=0.5,t="sh",c="r"},

		{x=1.5,y=0,t="sh",c="r"},
		{x=1.75,y=0,t="sh",c="w"},
		{x=2.25,y=0,t="sh",c="b"},
		{x=2.75,y=0,t="sh",c="w"},

		{x=1.5,y=0.5,t="sh",c="w"},
		{x=2,y=0.5,t="sh",c="b"},
		{x=2.5,y=0.5,t="sh",c="r"},
		{x=2.75,y=0.5,t="sh",c="b"},
	}
	--]]
end

return tileDefs

end

-- title:   o disaster! is roasted
-- author:  RiFT
-- desc:    short description
-- site:    website link
-- license: MIT License (change this to your license of choice)
-- version: 0.1
-- script:  lua

--using 1.0.2164 Pro

--WIREFRAME AND ADDITIVE RENDERING FTW!!!

IS_DEBUG=false

-- Copy this file into a folder within your TIC-80 code folder (e.g. ~/my-demo/)
-- Check the Rift Libs out into ~/rift/ in your TIC-80 code folder
-- Add your package path here - note the odd pattern matching style (Windows Example)
-- You can include as many of these as you like, for each team member. No need to comment any out

--[[

TO-DO:
fix sync on line generation for line tunnel
(sync already works on the "camera" angle sync shit)


IDEAS:
square tube thing like in virus matt current gba demo (0:55)

deffo trance soundtrack (how that will work in 4 channels im yet to find out)
current wip in track 0 sounds ehhh, will probably remake

]]

R=R or {}

rift_syssys()(R)
rift_demorunner()(R)
rift_fontsysfont()(R)

local data = rift_codefontasteroids6x7()
R.sysfontLoad(data)

rift_game()(R)

local DEMO_RUNNER=R.DemoRunner:new()
DEMO_RUNNER:setShowDebug(IS_DEBUG)

--DEMO_RUNNER:addPartTics(rift_partstestticmctile(), 20000)
--DEMO_RUNNER:addPartTics(rift_partsfaketogame(), 10)

-- Comment this back in as a hack to launch straight to the hidden gam
DEMO_RUNNER:addPartTics(rift_partsintro(), 800)
DEMO_RUNNER:addCueMusic(0,1)
DEMO_RUNNER:addPartMusic(rift_partscontrolroomstart(), 2)
DEMO_RUNNER:addCueMusic(1,0)
DEMO_RUNNER:addPartMusic(rift_partsrunning(), 4)
DEMO_RUNNER:addPartMusic(rift_partsprelaunch(), 2)
DEMO_RUNNER:addPartMusic(rift_partslaunch(), 2)
DEMO_RUNNER:addPartMusic(rift_partsflightfractalus(), 1)
DEMO_RUNNER:addPartMusic(rift_partsflightlinetunnel(), 1)
DEMO_RUNNER:addPartMusic(rift_partsflightwormhole(), 1)
DEMO_RUNNER:addPartMusic(rift_partsmorph(), 1)
DEMO_RUNNER:addStopMusic()
DEMO_RUNNER:addPartTics(rift_partsasteroids(), 1100)
DEMO_RUNNER:addCueMusic(2,0)
DEMO_RUNNER:addPartMusic(rift_partscontrolroomend(), 2)
DEMO_RUNNER:addPartMusic(rift_partswrithe(), 2)
DEMO_RUNNER:addPartMusic(rift_partsgreetz(), 4)
DEMO_RUNNER:addPartMusic(rift_partsoutro(), 6)

local GAME = R.Game:new()

local MODE = "demo"	-- or "game"

vbank(1)
cls()
vbank(0)
cls()
clip(0,0,240,128)

TIC=R.ticWrap(function()
	R.tryBreak()
	R.hideMouse()

	if MODE == "demo" then
		local exitSignal = DEMO_RUNNER:run()
		if exitSignal then
			if exitSignal == "secret" then
				MODE = "game"
			else
				trace("- Natural Exit :)",12)
				exit()
			end
		end
	elseif MODE == "game" then
		GAME:tic()
	end
end)

-- <TILES>
-- 000:0101010123232323010101012323232301010101232323230101010123232323
-- </TILES>


-- <WAVES>
-- 000:000000000000000000000000ffffffff
-- 002:01345689abcdeffffeddca9875431000
-- 004:43210000011111111eeffffffeeeedcc
-- 005:0000000000000000ffffffffffffffff
-- 006:0000000000000000000000ffffffffff
-- 007:00000000000000000000000000000fff
-- 008:003468abcddea99887ffffffffffffff
-- </WAVES>

-- <SFX>
-- 000:09070905290349016900890ea90cc90ae909f90009000900090009000900090009000900090009000900090009000900090009000900090009000900b05000910010
-- 001:013001a0117021d0310041005100610071007100810091009100a100a100b100b100c100c100c100c100c100d100d100d100e100e100f100f100f100374000000400
-- 002:0410f400f400f400f400f400f4000400f400f400f400f400f400f40004000400040004000400040004000400040004000400040004000400040004003460000e0e00
-- 003:020702050201020e020c0208020b020d020f020102030206020702070200020002000200020002000200020002000200020002000200020002000200a0400000000d
-- 004:05000500060006000000000007000700000000000600060005000500070007000700070007000700070007000700070007000700070007000700070030500e000000
-- 005:f500e500d600c600a000a00097008700800070006600660055005500470047004700370037003700270027002700270017000700070007000700070030400e000000
-- 006:01f00500160016002000200037004700400050006600660075008500850097009700a700a700b700b700b700b700c700c700d700d700e700e700e70030701e000000
-- 007:01000500056005a005f0f500050005000500050005000500050005000500050005000500050005000500050005000500050005000500050005000500380011510000
-- 008:01000500056005a005f0f1002500350055006500750085009500a500b500c500c500d500d500d500d500d500e500e500e500e500e500e500e500f50028b051500000
-- 009:6100a100c100d100f100f100f100f100f100f100f100f100f100f100f100f100f100f100f100f100f100f100f100f100f100f100f100f100f100f100303000000000
-- 010:4100710081009100a100b100c100d100d100e100f100f100f100f100f100f100f100f100f100f100f100f100f100f100f100f100f100f100f100f100304000000000
-- 011:080008000800080008000800080008000800080008000800080008000800080008000800080008000800080008000800080008000800080008000800303000000000
-- 012:010001000100010001000100010001000100010001000100010001000100010001000100010001000100010001000100010001000100010001000100309000000000
-- 013:060006000600060006000600060006000600060006000600060006000600060006000600060006000600060006000600060006000600060006000600305000000000
-- 014:000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000304000000000
-- 015:070007000700070007000700070007000700070007000700070007000700070007000700070007000700070007000700070007000700070007000700305000000000
-- 016:0000100020003000500060008000a000c000e000f000f000f000f000f000f000f000f000f000f000f000f000f000f000f000f000f000f000f000f00040a000000000
-- 017:30003000400040005000600060007000800080009000a000a000b000c000d000e000f000f000f000f000f000f000f000f000f000f000f000f000f000307000000000
-- </SFX>

-- <PATTERNS>
-- 000:b00054000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
-- 001:0fa100000000000000000000000000000000000000000000b00052000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
-- 002:0af100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e00058000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000f00058000000000000000000000000000000000000000000
-- 003:000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000b00058000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
-- 004:b00054000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000900052000000000000000000000000000000000000000000800052000000000000000000000000000000000000000000
-- 005:000000000000000000000000000000000000000000000000b00052000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000900054000000000000000000000000000000000000000000800054000000000000000000000000000000000000000000
-- 006:000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000b0005800000000000000000000000000000000000000000000000000000000000000000040005a000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
-- 007:700052000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000900052000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000600052000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000b00052000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
-- 008:700054000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000900054000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000600054000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000b00054000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
-- 009:000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e00058000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000900058000000000000000000000000000000000000000000b00058000000000000000000000000000000000000000000
-- 010:747258000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000947258000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000b37258000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
-- 011:e0005a000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000d0005a00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000090005a000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000b0005a000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
-- 012:0ff1000000000000000000000aa1000000000000000000000881000000000000000000000661000000000000000000000441000000000000000000000221000000000000000000000000000000000000000002009ff188900088400088b40386000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
-- 013:b00062b00062b00062b00062b00064b00062b00062b00064b00062b00062b00064b00062b00064b00062e00064d00064b00062b00062b00062b00062b00064b00062b00062b00064b00062b00062b00064b00062b00064b00064e00064d00064000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
-- 014:b82562b00062b00062b00062b00064b00062b00062b00064b00062b00062b00064b00062b00064b00062e00064d00064b82562b00062b00062b00062b00064b00062b00062b00064b00062b00062b00064b00062b00064b00062e00064d00064000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
-- 015:0ff1000000000000000000000aa100000000000000000000088100000000000000000000066100000000000000000000044100000000000000000000022100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
-- 016:40007640009e40009e40009e4000ae00000040009e40007640009e40009e40007640009e4000ae00000040009e4000ae40007640009e40009e40009e4000ae00000040009e40007640009e40009e40007640009e4000ae00000040009e4000ae40007640009e40009e40009e4000ae00000040009e40007640009e40009e40007640009e4000ae00000040009e4000ae40007640009e40009e40009e4000ae00000040009e40007640009e40009e40007640009e4000ae00000040009e4000ae
-- 017:b80562bfa162b00062b00062b00062b00062b00062b00062b00062b00062b00062b00062b00062b00062b00062b00062b00064b00064b00064b00064b00064b00064b00064b00064b00064b00064b00064b00064b00064b00064b00064b00064700064700064700064700064700064700064700064700064900064900064900064900064900064900064900064900064600064600064600064600064600064600064600064600064b00064b00064b00064b00064b00062b00062b00062b00062
-- 018:b82562baf162b00062b00062b00062b00062b00062b00062b00062b00062b00062b00062b00062b00062b00062b00062b00064b00064b00064b00064b00064b00064b00064b00064b00064b00064b00064b00064b00064b00064b00064b00064700064700064700064700064700064700064700064700064900064900064900064900064900064900064900064900064600064600064600064600064600064600064600064600064b00064b00064b00064b000649ff1889ff1889ff1889ff188
-- 019:1aa100000400b7c246b7c2b8100000b000c6b000b4b00048b0004ab00048b00046100000e0c2b8d00044b002c6970248100000000000b7c246b7c2b8100000b000c6b000b4b00048b0004ab00048b00046100000e0c2b8d00044b002c6970248ec025a000000000000000000000000000000000000000000d0005a000000000000000000000000000000000000000000b0005a0000000000000000000000000000000000000000009c025a00000000000000000061045a000000000000000000
-- 020:bfa162000000900062000000b00062000000b00064000000b771620000009fa164000000b00064000000b00062000000900062000000b00062000000b00064000000b77162000000bfa164000000900062000000900064000000e00064000000b00062000000900062000000b00062000000b00064000000b771620000009fa164000000b00064000000b00062000000900062000000b00062000000b00064000000b77162000000bfa164000000900062000000900064000000e00064000000
-- 021:7fa16400a0006000640000007000620000007000660000007771640000006fa1640000007000660000007000640000009000640000006000640000009771640000009fa166000000900064000000600066000000600064000000900062000000b00064000000b00062000000900064000000b77164000000bfa162000000b00064000000b00064000000b00062000000b00064000000b771620000009fa164000000b00064000000b00062000000900064000000b00064000000e00064000000
-- 022:4af178000000900064000000b00064000000b000660000004000780000009af166000000b00066000000b00064000000400078000000b00064000000b00066000000b771640000004af178000000900064000000900066000000e00066000000400078000000900064000000b00064000000b000660000004000780000009af166000000b00066000000b00064000000400078000000b00064000000b00066000000b771640000004af178000000900064000000900066000000e00066000000
-- 023:4af1780000006000660000007000640000007000680000004af1780000006af1660000007000680000007000660000004af1780000006000660000009771660000009af1680000004af1780000006000680000006000660000009000640000004af178000000b00064000000900066000000b771660000004af178000000b00066000000b00066000000b000640000004af178000000b771640000009af166000000b000660000004af178000000900066000000b00066000000e00066000000
-- 024:b00044000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
-- 025:b00042000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000700044000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
-- 026:4ff1ce4ff4c40000000000000aa10000000000000000000008810000000000000000000006610000000000000000000004410000000000000000000004410000000000000000000003310000000000000000000003310000000000000003000003310000000000000001000002210000000000000005f300000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
-- 027:100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
-- 028:80009e00000080009e00000080009e0000008000ae00000080009e00000080009e00000080009e00000080009e0000008000ae00000080009e00000080009e0000008000ae00000080009e00000080009e0000008000ae00000080009e00000080009e00000080009e00000080009e0000008000ae00000080009e00000080009e00000080009e00000080009e0000008000ae00000080009e00000080009e0000008000ae00000080009e00000080009e0000008000ae00000080009e000000
-- 029:00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000040008a40008a40008a000000b00088000000400088000000400088000000
-- 030:8f819e00000080009e00000080009e0000008000ae000000bff1880000008f819e00000080009e00000080009e0000008000ae00000080009e00000080009e0000008000ae000000bff1880000008f819e0000008000ae000000bff1880000008f819e00000080009e00000080009e0000008000ae000000bff1880000008f819e00000080009e00000080009e0000008000ae00000080009e00000080009e0000008000ae000000bff1880000008f819e0000008000ae000000bff188000000
-- 031:bff1b4b771dabff1b6b771e4bff1b8b771b6bff1dab771b8bff1f4b771babff1b6b771d4bff1b8b771f6bff1bab771b8bff1d4b771babff1f6b771b4bff1b8b771b6bff1eab771f8bff1b4b771babff1b6b771b4bff1e8b771b6bff1fab771b8bff1b4b771babff1b6b771e4bff1b8b771b6bff1fab771b8bff1b4b771babff1f6b771b4bff1b8b771f6bff1bab771f8bff1b4b771fabff1b6b771b4bff1e8b771b6bff1dab771b8bff1e4b771babff1d6b771b4bff1d8b771b6bff1eab771b8
-- 032:bcc2d808f100bbc2e8000000bac2f8000000b9c2e8000000b8c2d8000000b7c2e8000000b6c2f8000000b5c2e8000000b4c2d8000000b3c2e8000000b2c2f8000000b1c2e8000000b37248000000000000000000000000000000000000000000b7c258000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000b7c258000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
-- 033:e4c258000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000d3c258000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000b37258000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000b37258000000000000000000000000000000000000000000b7c258000000000000000000000000000000000000000000
-- 034:baf162083500900062000000b00062000000b00064000000baf1620000009af164000000b00064000000b00062000000900062000000b00062000000b00064000000baf162000000baf16400f000900062000000900064000000e00064000000b00062000000900062000000b00062000000b00064000000baf1620000009af164000000b00064000000b00062000000900062000000b00062000000b00064000000baf162000000baf164000000900062000000900064000000e00064000000
-- 035:7af1640835006000640000007000620000007000660000007af1640000006af1640000007000660000007000640000009000640000006000640000009af1640000009af166000000900064000000600066000000600064000000900062000000b00064000000b00062000000900064000000baf164000000baf162000000b00064000000b00064000000b00062000000b00064000000baf1620000009af164000000b00064000000b00062000000900064000000b00064000000e00064000000
-- 036:7fa144000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000910444000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000b00044000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
-- 037:7af144083500000000000000000000000000000000000000000000000000000000000000000000000000000000000000910444000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000b00044000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
-- 038:000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000baf16a100000bfa16a100000baf168100000bfa16c100000
-- 039:b42162000000b46162000000ba6162000000baf162000000b42162000000b46162000000ba6162000000baf162000000b42162000000b46162000000ba6162000000baf162000000b42162000000b46162000000ba6162000000baf162000000b42162000000b46162000000ba6162000000baf162000000b42162000000b46162000000ba6162000000baf162000000b42162000000b46162000000ba6162000000baf162000000b42162000000b46162000000ba6166000000baf164000000
-- 040:b42162083500b46162000000ba6162000000baf162000000b42162000000b46162000000ba6162000000baf162000000b42162000000b46162000000ba6162000000baf162000000b42162000000b46162000000ba6162000000baf162000000b42162000000b46162000000ba6162000000baf162000000b42162000000b46162000000ba6162000000baf162000000b42162000000b46162000000ba6162000000baf162000000b42162000000b46162000000ba6166000000baf164000000
-- 041:4af1780000000000000000000000000000000000000000004af1780000000000000000000000000000000000000000004af1780000000000000000000000000000000000000000004af1780000000000000000000000000000000000000000004af1780000000000000000000000000000000000000000004af1780000000000000000000000000000000000000000004af1780000000000000000000000000000000000000000004af178000000000000000000000000000000000000000000
-- 042:700056000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000500056000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
-- 043:600056000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
-- 044:e00009000000d00009000000600009000000e00009000000d00009000000600009000000e00009000000d0000900000060000900000040000b000000d0000900000060000900000060000b000000e00009000000d00009000000600009000000e00009000000d00009000000600009000000e00009000000d00009000000600009000000e00009000000d0000900000060000900000040000b000000d0000900000060000900000060000b000000e00009000000d00009000000600009000000
-- 045:b00014000000000000000000000000000000000000000000400096000000000000000000000000000000000000000000400096000000000000000000000000000000000000000000400096000000000000000000000000000000000000000000400096000000000000000000000000000000000000000000400096000000000000000000000000000000000000000000400096000000000000000000000000000000000000000000400096000000000000000000000000000000000000000000
-- 046:b00044000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000700044000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000600044000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
-- 047:b00014000000000000000000000000000000000000000000400096000000000000000000000000000000000000000000400096000000000000000000000000000000000000000000400096000000000000000000000000000000000000000000b000140000000000000000000000000000000000000000004000960000000000000000000000000000000000000000009000a40000004000a4000000000000000000f000a2000000000000000000b000a20000006000a2000000000000000000
-- 048:658219000000000000000000600019000000000000000000600019000000000000000000600019000000657219000000000000000000600019000000000000000000600019000000600019000000000000000000600019000000000000000000658219000000000000000000600019000000000000000000600019000000000000000000600019000000657219000000000000000000600019000000000000000000600019000000600019000000000000000000600019000000000000000000
-- 049:70000b00000060000b000000b0000900000070000b00000060000b000000b0000900000070000b00000060000b00000070000b00000060000b000000d0000900000070000b00000060000b000000d0000900000070000b00000060000b00000070000b00000060000b000000b0000900000070000b00000060000b000000b0000900000070000b00000060000b00000070000b00000060000b000000d0000900000070000b00000060000b000000d0000900000070000b00000060000b000000
-- 050:4af178000000e00064000000400066000000400068000000400078000000eaf1640000004000680000004000660000004000780000004000660000004000680000004771660000004af178000000900064000000900066000000e000660000004af178000000e00064000000400066000000400068000000400078000000eaf1640000004000680000004000660000004000780000004000660000004000680000004771660000004af178000000900064000000900066000000e00066000000
-- 051:4af1780000006000660000007000640000007000680000004af1780000006af1660000007000680000007000660000004af1780000006000660000009771660000009af1680000004af1780000006000680000006000660000009000640000004af1780000006000660000007000640000007000680000004af1780000006af1660000007000680000007000660000004af1780000006000660000009771660000009af1680000004af178000000600068000000600066000000900064000000
-- 052:4af1780000004000660000006000640000006000680000004af1780000004af1660000006000680000006000660000004af1780000004000660000006771660000006af1680000004af1780000006000680000006000660000009000640000004af1780000004000660000006000640000006000680000004af1780000004af1660000006000680000006000660000004af1780000004000660000006771660000006af1680000004af178000000600068000000600066000000900064000000
-- 053:658219000000000000000000600019000000000000000000600019000000000000000000600019000000658219000000000000000000600019000000000000000000600019000000600019000000000000000000600019000000000000000000647219000000000000000000600019000000000000000000600019000000000000000000600019000000647219000000000000000000600019000000000000000000600019000000600019000000000000000000600019000000000000000000
-- 054:b0006a00000000000000000000000000000060006a000000000000000000000000000000d0006a00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000060006a000000000000000000e0006a00000000000000000000000000000040006c000000000000000000000000000000d0006a000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e0006a00000040006c000000
-- 055:60006c00000000000000000000000000000040006c000000000000000000000000000000d0006a000000000000000000000000000000e0006a000000000000000000000000000000d0006a00000000000000000060006a000000000000000000e0006a000000000000000000000000000000d0006a000000000000000000000000000000b0006a000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
-- 056:60006c00000000000000000000000000000040006c000000000000000000000000000000e0006a000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000b0006a000000d0006a000000e0006a000000000000000000000000000000d0006a00000000000000000000000000000060006a000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
-- 057:b00014000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
-- 058:b00044000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
-- </PATTERNS>

-- <TRACKS>
-- 000:180301581ac1842b03ec3d04ec3d04194315194315996b17000000000000000000000000000000000000000000000000000030
-- 001:5d5d10616d975d50e76160e75d51e76162e75d81e76192e75a972086aa2086aaea86aa2b0000000000000000000000000000ef
-- 002:d66e20deb030de5130d261302fc13023d130d2d130d6d630de51fdd2613edec1fdd2d17ed66e200cea300000000000000000ef
-- </TRACKS>

-- <PALETTE>
-- 000:1a1c2c5d275db13e53ef7d57ffcd75a7f07038b76425717929366f3b5dc941a6f673eff7f4f4f494b0c2566c86333c57
-- </PALETTE>

