	page	240, 132
;chroma.asm	17-Apr-2025
;"Chromahedron" by Boreal, a 256-byte intro for Revison 2025.
;Assemble with: tasm; tlink /t
;Runs under DOSBox for MIDI and LFB.
	.model	tiny
	.code
	.486
	org	100h
;COM files are loaded with registers set like this:
; ax=0, bx=0, cx=00FFh, dx=cs=ds=es=ss, si=0100h, di=-2, bp=09xx, sp=-2.
;The direction flag (d) is clear (incrementing).
;When DOSBox first starts it sets the high words of extended (e) registers to
; 0000h, zeros fs and gs, and initializes the FPU.

debug	equ	0			;set this flag to 0 for compo version
buffer	equ	000406000h		;arbitrary location = float constant 3.5
LFB	equ	0C0000000h		;Linear Frame Buffer = displayed memory

;Register usage:
;  ax: working
;  bx: Face 0..2
; ecx: Y, rep
;  dx: X
; esi: movsd, 0100h
; edi: stosd, movsd, sp, index into buffer
;  bp: Edge limit
;  fs: high and low bytes of timer-counter
;
;The first five bytes store the color to be plotted, offset by Face:
;byte: 0 1 2 3 4
;Face  B G R B G
; 0:   ^ ^ ^
; 1:     ^ ^ ^
; 2:       ^ ^ ^

start:	mov	es, ax			;es:= 0; for accessing the LFB
if debug
	mov	fs, ax			;fs:= 0
endif
	mov	ax, 4F02h		;set 640x480x24 graphics mode
	mov	bx, 0112h
	int	10h

d120:	cmp	ax, 060Ah		;= approximately 120 degrees in radians
	inc	ax			; located here to be within range of si

;Replace the system timer interrupt routine (1Ch) with our routine.
;The routine is called about 18.2 times per second.
if debug
;First, save the original interrupt handler vector:
	mov	ax, 351Ch
	int	21h			;WARNING: es gets changed
	mov	oldint, bx
	mov	oldint+2, es
	push	0			;restore es = 0
	pop	es
endif
	mov	ax, 251Ch		;change address of timer interrupt to
;	mov	dx, offset music	; our handler at ds:dx
	mov	dl, low offset music	; our handler at ds:dx (if DOSBox dh=01)
	int	21h

;	fninit				;done when DOSBox first starts
	fldz				;FPU: Angle:= 0.0
					;repeat until Esc key...
t00:	mov	ecx, 640*480		;copy buffer to LFB
	mov	edi, offset buffer	;needed to erase buffer afterwards
d35	equ	$-5			;arbitrary location = 3.5 constant
	pushad				;save ecx, edi and si=0100h
	mov	esi, edi		;source:= buffer
	mov	edi, LFB		;destination:= LFB
	rep movs dword ptr [edi], [esi]	;es:[edi++]:= ds:[esi++]; ecx--
					;only takes 1 ms under DOSBox!
	popad				;erase buffer with whatever's in eax
	rep stos dword ptr es:buffer	;es:[edi++]:= eax; ecx--

	xor	bx, bx			;for Face:= 0 to 2 do
t05:	fld	st			;  CosAngle:= Cos(Angle)
	fsincos				;  FPU: Ang sin cos
	ftst				;  if CosAngle > 0.0 then
	fnstsw	ax			;    Face is facing toward the viewer
	sahf
	jb	t30

	fld	dword ptr [si+d35-start];    SinAngle3:= Sin(Angle) / 3.5
	fdivp	st(2), st		;    FPU: Ang sin3 cos

	xor	cx, cx			;    for Y:= 0 to 255 do (top down)
	or	dword ptr [si], -1	;    blues:= 255
t10:	mov	[si+1], cx		;      green:= Y; red:= 0
	mov	[si+4], cl		;      green:= Y

	push	cx			;      Disp:= fix(float(Y) * SinAngle3)
	mov	di, sp
	fild	word ptr [di]		;      FPU: Ang sin3 cos Y
	fmul	st, st(2)		;      FPU: Ang sin3 cos Ysin3
	fistp	word ptr [di]		;      FPU: Ang sin3 cos

	mov	bp, cx			;      Edge:= Y/2
	imul	dx, bp, -1		;      for X:= -Edge to Edge-1 do
	sar	dx, 1

; Point(fix(float(X)*CosAngle)+Disp+640/2, Y+480/2-256/2, Color)
t20:	push	dx			;      Point(fix(float(X)*CosAngle)
	mov	di, sp
	fild	word ptr [di]		;      FPU: Ang sin3 cos X
	fmul	st, st(1)		;      FPU: Ang sin3 cos Xcos
	fistp	word ptr [di]		;      FPU: Ang sin3 cos
	pop	ax
	add	ax, [di+2]		;      + Disp (result is positive)
	add	ax, 640/2		;      + horizontal center

	lea	edi, [ecx+480/2-256/2]	;      Y+(480/2-256/2); clears high word
	imul	edi, 80			;      * screen width in pixels 80*8=640
	lea	edi, [edi*8+eax]	;      + X component

	push	dword ptr [bx+si]	;      fetch colors
	pop	dword ptr [edi*4+buffer];      plot pixel

	sub	word ptr [si+1], 0FF01h	;      green--; red++
	dec	byte ptr [si+4]		;      green--

	inc	dx			;      next X
	dec	bp			;      Edge limit reached?
	jns	t20			;      loop if not

	pop	ax			;    balance stack by discarding Disp

	mov	ax, fs			;    if timers >= 128, start rotating
	cmp	ax, dx
	jae	t25
	 cmp	cl, al			;    else slowly draw by restarting
	 jb	t25
	  fcompp			;    FPU: Ang
	  jmp	t40
t25:
	inc	cx			;    next Y
	dec	byte ptr [si]		;    blues--
	dec	byte ptr [si+3]
	jne	t10
t30:					;  FPU: Ang sin3 cos
	fcompp				;  FPU: Ang
	fadd   dword ptr [si+d120-start];  Angle:= Angle + 120 deg + rotation
	add	word ptr [si+d120-start], 2 ;  accelerate rotation

	inc	bx			;  next Face
	jpo	t05			;  loop until bx = 3 (even parity)
t40:
	in	al, 60h			;loop until Esc key
	dec	al
	jne	t00
if debug
	mov	ax, 251Ch		;restore original interrupt vector
	mov	dx, oldint		;music stops playing
	mov	ds, oldint+2		;WARNING ds is changed
	int	21h

	mov	ax, 0003h		;restore text mode
	int	10h
endif
	ret

;-------------------------------------------------------------------------------
;Interrupt handler for playing music, based on HellMood's DECENT.ASM

music:	pusha

	mov	bx, fs			;bump counter-timer bytes
	inc	bx
	inc	bx
	test	bl, 07h			;play note every 4th interrupt
	jne	mus90
	test	bh, bh			;music starts after 256/(18.2*2) = 7 sec
	je	mus90

	mov	dx, 330h		;enable MIDI UART 401
	mov	ax, 3FC0h		; and set instrument on channel 0
	out	dx, ax

	mov	al, bl			;cycle thru instruments
	aam	5			;limit the number of instruments
	add	al, 104			;add base instrument (Sitar)
	out	dx, al

	mov	al, 90h			;play note on channel 0
	out	dx, al

	add	bh, 7			;add note step
	mov	al, bh
	aam	17			;limit note range
	imul	ax, 3			;note spread
	add	al, 40			;add base note
	out	dx, al

	imul	ax, word ptr d120+1, 3	;set increasing volume
	out	dx, al
mus90:
	mov	fs, bx
	popa
	iret

oldint	dw	?, ?			;original interrupt handler vector
	end	start
