Unit
	Usr;

Interface

	Uses
		Crt,
		Dos;

	Const
		HexChars : Array[0..$F] Of Char = '0123456789ABCDEF';

{	Var
		SinByte  : Array[0.. 511] Of Byte;
		Sin4096  : Array[0..8191] Of Byte;
}





























	Procedure
		WriteHex(W : Byte);

	Procedure
		WriteHexWord(W : Word);

	Procedure
		ClearKey;

	Procedure
		Wait(MS : Word);

	Procedure
		Clear(F : Pointer; N : Word);

	Procedure
		ClrScr;

	Function
		GetKey : Char;

	Function
		Key : Boolean;

	Function
		Strg(S : Real) : String;

	Function
		IntStrg(S : LongInt) : String;

	Function
		Val(S : String) : Real;

	Function
		Num(S : String) : LongInt;

	Function
		B2Str(B : Word) : String;

	Function
		Sgn(X : Real) : ShortInt;

	Function
		Pot(X, Y : Integer) : LongInt;

	Function
		Clip(W, A, B : LongInt) : LongInt;

	Function
		Mid(S : String; Start, Num : Byte) : String;

	Function
		Left(S : String; Num : Byte) : String;

	Function
		Right(S : String; Num : Byte) : String;

	Function
		UCase(S : String) : String;

	Function
		LCase(S : String) : String;




























Implementation

	Function
		Mid;

		Var
			C :   Byte;
			O : String;

		Begin
			If Num > 0 Then
				Move(S[Start], O[1], Num);
			O[0] := Char(Num);
			Mid := O
		End;

	Function
		Left;

		Begin
			Left := Mid(S, 1, Num)
		End;

	Function
		Right;

		Begin
			Right := Mid(S, Length(S) + 1 - Num, Num)
		End;
















	Function
		UCase;

		Var
			C : Byte;

		Begin
			For C := 1 To Length(S) Do
				If (S[C] >= 'a') And (S[C] <= 'z') Then
					S[C] := Char(223 And Byte(S[C]));
			UCase := S
		End;

	Function
		LCase;

		Var
			C : Byte;

		Begin
			For C := 1 To Length(S) Do
				If (S[C] >= 'A') And (S[C] <= 'Z') Then
					S[C] := Char(32 Or Byte(S[C]));
			LCase := S
		End;




















	Var
		C : Word;

	Procedure
		WriteHex(W : Byte);

		Begin
			Write(HexChars[W ShR $4],
						HexChars[W And $F])
		End;


	Procedure
		WriteHexWord(W : Word);

			Begin
				Write(HexChars[Hi(W) ShR $4],
							HexChars[Hi(W) And $F],
							HexChars[Lo(W) ShR $4],
							HexChars[Lo(W) And $F])
			End;
























	Procedure
		Wait(MS : Word);

		Begin
			Delay(MS)
		End;







































	Procedure
		Clear(F : Pointer; N : Word);

		Begin
			FillChar(F^, N, 0)
		End;

	Procedure
		ClearKey;

		Begin
			If Key Then
				GetKey
		End;































	Procedure
		ClrScr;

		Var
			R : Registers;

		Begin
			R.AX := 3;
			Intr($10, R)
		End;



































	Function
		GetKey : Char;

		Begin
			Repeat
			Until KeyPressed;
 			GetKey := ReadKey
		End;

	Function
		Key : Boolean;

		Begin
			Key := KeyPressed
		End;






























	Function
		Strg;

		Var
			T : String;

		Begin
			Str(S, T);
			Strg := T
		End;

	Function
		IntStrg;

		Var
			T : String;

		Begin
			Str(S, T);
			IntStrg := T
		End;

	Function
		Val(S : String) : Real;

		Var
			I : Integer;
			V :    Real;

		Begin
			System.Val(S, V, I);
			Val := V
		End;












	Function
		B2Str;

		Var
			I :   Byte;
			S : String;

		Begin
			S := '';
			If B > 255 Then
				S := B2Str(B ShR 8);
			For I := 0 To 7 Do
				If ((B ShL I) And 128) <> 0 Then
					S := S + '1'
				Else
					S := S + '0';
			B2Str := S
		End;

	Function
		Num;

		Const
			M = '0123456789';

		Var
			Mul : ShortInt;
			C   :     Byte;
			Z   :  LongInt;

		Begin
			Z   := 0;
			Mul := 1;
			If S[1] = '-' Then
			Begin
				Mul := -1;
				For C := 1 To Length(S) Do
					S[C] := S[C + 1];
				Dec(S[0])
			End;
			For C := Length(S) DownTo 1 Do
				Inc(Z, (Pos(S[C], M) - 1) * Pot(10, Length(S) - C))
		End;


	Function
		Pot(X, Y : Integer) : LongInt;

		Var
			E : LongInt;
			C :    Byte;

		Begin
			E := 1;
			If Y > 0 Then
				For C := 1 To Y Do
					E := E * X;
			Pot := E
		End;

	Function
		Sgn(X : Real) : ShortInt;

		Begin
			Sgn := 0;
			If X <> 0 Then
				Sgn := Trunc(X / Abs(X))
		End;

	Function
		Clip;

		Begin
			Clip := W;
			If W < A Then
				Clip := A
			Else
				If W > B Then
					Clip := B
		End;



Begin
{	For C := 0 To 511 Do
		SinByte[C] := Trunc(Sin(C * Pi /  128) * 127 + 127);
	Write('.');
	For C := 0 To 8191 Do
		Sin4096[C] := Trunc(Sin(C * Pi / 2048) * 127 + 127);
	WriteLn('.')}
End.