Unit
	M13;

Interface

	Uses
		Dos;

	Const
		TextM = $03;
		GrphM = $13;

		Black   = $0;
		Blue    = $1;
		Green   = $2;
		Cyan    = $3;
		Red     = $4;
		Purple  = $5;
		Brown   = $6;
		LtGrey  = $7;
		DkGrey  = $8;
		LtBlue  = $9;
		LtGreen = $A;
		LtCyan  = $B;
		LtRed   = $C;
		Magenta = $D;
		Yellow  = $E;
		White   = $F;

	Type
		PPage = ^TPage;
		TPage = Array[0..199, 0..319] Of Byte;

		PWordPage = ^TWordPage;
		TWordPage = Array[0..63999] Of Byte;

	Var
		Screen      : TPage     Absolute $A000:$0000;
		WordScreen  : TWordPage Absolute $A000:$0000;
		PScreen     : PPage                         ;
		PWordScreen : PWordPage Absolute PScreen    ;




	Procedure
		WriteXY(X, Y : Word; S : String; C : Byte);

	Procedure
		M13Char(C : Char; X, Y: Word; FC, BC : Byte);

	Procedure
		M13Rect(X1, Y1, X2, Y2: Word; C : Byte);

	Procedure
		Circle(X, Y, R : Word; C : Byte);

	Procedure
		SetRGB(Nr, R, G, B : Byte);

	Procedure
		Pixel(X, Y : Word; C : Byte);

	Function
		Quadrant(DX, DY : Integer) : Byte;

	Function
		SQuadrant(DX, DY : Integer) : Byte;

	Procedure
		SetMode(Mode : Byte);

	Procedure
		Shut;

	Procedure
		M13Init;













Implementation

	Procedure
		WriteXY;

		Var
			I : Byte;

		Begin
			For I := 1 To Length(S) Do
				M13Char(S[I], X + (I - 1) * 8, Y, C, 0)
		End;

































	Procedure
		M13Char;

		Var
			CharSize :    Word Absolute $0000:$0485;
			FPtr     : Pointer Absolute $0000:$010C;
			CharRow  :                         Byte;
			FontSeg  ,
			FontOfs  ,
			ScrOfs   ,
			I        ,
			J        :                         Word;

		Begin
			ScrOfs  := 320 * Y + X;
			FontSeg := Seg(FPtr^);
			FontOfs := Ofs(FPtr^) + CharSize * Byte(c);
			For I := 0 To CharSize - 1 Do
			Begin
				CharRow := Mem[FontSeg:FontOfs];
				For J := 0 To 7 Do
				Begin
					If (CharRow And $80) <> 0 Then
						Mem[$A000:ScrOfs + J] := FC
					Else
						Mem[$A000:ScrOfs + J] := BC;
					CharRow := CharRow ShL 1
				End;
				ScrOfs  := ScrOfs  + 320;
				FontOfs := FontOfs +   1
			End
		End;













	Procedure
		M13Rect(X1, Y1, X2, Y2: Word; C : Byte);

		Var
			X : Word;

		Begin
			For X := X1 To X2 Do
				Pixel(X, Y1, C);
			For X := X1 To X2 Do
				Pixel(X, Y2, C);
			For X := Y1 To Y2 Do
				Pixel(X1, X, C);
			For X := Y1 To Y2 Do
				Pixel(X2, X, C);
		End;





























	Procedure
		Circle(X, Y, R : Word; C : Byte);

		Var
			D1 ,
			D2 : Single;
			Fx ,
			Fy :   Word;
			Fr :   Real;

		Begin
			Fy := R;
			Fx := 0;
			Repeat
				Pixel(X + Fx, Y + Fy, C);
				Pixel(X + Fy, Y + Fx, C);
				Pixel(X - Fx, Y + Fy, C);
				Pixel(X - Fy, Y + Fx, C);
				Pixel(X + Fx, Y - Fy, C);
				Pixel(X + Fy, Y - Fx, C);
				Pixel(X - Fx, Y - Fy, C);
				Pixel(X - Fy, Y - Fx, C);
				Inc(Fx);
				If
					Abs(Sqrt(Abs(Sqr(Fx) + Sqr(Fy    ))) - R) >
					Abs(Sqrt(Abs(Sqr(Fx) + Sqr(Fy - 1))) - R) Then
					Dec(Fy)
			Until
				(SQuadrant(Fx, Fy) <> 1) Or
				( Quadrant(Fx, Fy) <> 1)
		End;














	Procedure
		SetRGB(Nr, R, G, B : Byte);

		Begin
			Port[$3C8] := Nr;
			Port[$3C9] := R;
			Port[$3C9] := G;
			Port[$3C9] := B
		End;




































	Procedure
		Pixel(X, Y : Word; C : Byte);

		Begin
			Screen[Y, X] := C
		End;







































	Function
		Quadrant(DX, DY : Integer) : Byte;

		Begin
			If (DX >= 0) Then
				If (DY >= 0) Then
					Quadrant := 1
				Else
					Quadrant := 2        { 4|1 }
			Else                     { -+- }
				If (DY >= 0) Then      { 3|2 }
					Quadrant := 4
				Else
					Quadrant := 3
		End;

	Function
		SQuadrant(DX, DY : Integer) : Byte;

		Begin
			If (Abs(DX) >{=} Abs(DY)) Then
				If DX >{=} 0 Then
					SQuadrant := 2
				Else
					SQuadrant := 4       { \1/ }
			Else                     { 4X2 }
				If DY >{=} 0 Then      { /3\ }
					SQuadrant := 1
				Else
					SQuadrant := 3
		End;














	Procedure
		SetMode(Mode : Byte);

		Var
			R : Registers;

		Begin
			R.AX := Mode;
			Intr($10, R)
		End;



































	Procedure
		M13Init;

		Begin
			PScreen := @Screen;
			SetMode(GrphM)
		End;

	Procedure
		Shut;

		Begin
			SetMode(TextM)
		End;





























Begin
	M13Init
End.